"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const authorizer_1 = require("./authorizer");
/**
 * Route class that creates the Route for API Gateway WebSocket API
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketRoute);
            }
            throw error;
        }
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = props.authorizer ?? new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this,
        });
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            apiKeyRequired: props.apiKeyRequired,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
        });
        this.routeId = route.ref;
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRoute", version: "2.54.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSw2Q0FBdUM7QUFDdkMsMkNBQXVDO0FBQ3ZDLG1FQUF3RDtBQUd4RCw2Q0FBa0Y7QUF5RGxGOzs7R0FHRztBQUNILE1BQWEsY0FBZSxTQUFRLHNCQUFRO0lBVTFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQVhSLGNBQWM7Ozs7UUFhdkIsSUFBSSxLQUFLLENBQUMsUUFBUSxJQUFJLFVBQVUsSUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO1lBQ3BELE1BQU0sSUFBSSxLQUFLLENBQUMsOERBQThELENBQUMsQ0FBQztTQUNqRjtRQUVELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFFL0IsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUM7WUFDNUMsS0FBSyxFQUFFLElBQUk7WUFDWCxLQUFLLEVBQUUsSUFBSTtTQUNaLENBQUMsQ0FBQztRQUVILE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLElBQUksSUFBSSxvQ0FBdUIsRUFBRSxDQUFDLENBQUMsOEVBQThFO1FBQ3BKLE1BQU0sY0FBYyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDckMsS0FBSyxFQUFFLElBQUk7WUFDWCxLQUFLLEVBQUUsSUFBSSxDQUFDLFlBQVksWUFBWSxzQkFBUyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJO1NBQ3pFLENBQUMsQ0FBQztRQUVILE1BQU0sS0FBSyxHQUFHLElBQUksMkJBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzNDLEtBQUssRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUs7WUFDL0IsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixNQUFNLEVBQUUsZ0JBQWdCLE1BQU0sQ0FBQyxhQUFhLEVBQUU7WUFDOUMsWUFBWSxFQUFFLGNBQWMsQ0FBQyxZQUFZO1lBQ3pDLGlCQUFpQixFQUFFLGNBQWMsQ0FBQyxpQkFBaUI7U0FDcEQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO0tBQzFCOztBQXhDSCx3Q0F5Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZXNvdXJjZSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuUm91dGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBpZ2F0ZXdheXYyJztcbmltcG9ydCB7IElSb3V0ZSB9IGZyb20gJy4uL2NvbW1vbic7XG5pbXBvcnQgeyBJV2ViU29ja2V0QXBpIH0gZnJvbSAnLi9hcGknO1xuaW1wb3J0IHsgSVdlYlNvY2tldFJvdXRlQXV0aG9yaXplciwgV2ViU29ja2V0Tm9uZUF1dGhvcml6ZXIgfSBmcm9tICcuL2F1dGhvcml6ZXInO1xuaW1wb3J0IHsgV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbiB9IGZyb20gJy4vaW50ZWdyYXRpb24nO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBSb3V0ZSBmb3IgYW4gV2ViU29ja2V0IEFQSS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJV2ViU29ja2V0Um91dGUgZXh0ZW5kcyBJUm91dGUge1xuICAvKipcbiAgICogVGhlIFdlYlNvY2tldCBBUEkgYXNzb2NpYXRlZCB3aXRoIHRoaXMgcm91dGUuXG4gICAqL1xuICByZWFkb25seSB3ZWJTb2NrZXRBcGk6IElXZWJTb2NrZXRBcGk7XG5cbiAgLyoqXG4gICAqIFRoZSBrZXkgdG8gdGhpcyByb3V0ZS5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgcm91dGVLZXk6IHN0cmluZztcbn1cblxuLyoqXG4gKiBPcHRpb25zIHVzZWQgdG8gYWRkIHJvdXRlIHRvIHRoZSBBUElcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBXZWJTb2NrZXRSb3V0ZU9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGludGVncmF0aW9uIHRvIGJlIGNvbmZpZ3VyZWQgb24gdGhpcyByb3V0ZS5cbiAgICovXG4gIHJlYWRvbmx5IGludGVncmF0aW9uOiBXZWJTb2NrZXRSb3V0ZUludGVncmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgYXV0aG9yaXplIHRvIHRoaXMgcm91dGUuIFlvdSBjYW4gb25seSBzZXQgYXV0aG9yaXplciB0byBhICRjb25uZWN0IHJvdXRlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIEF1dGhvcml6ZXJcbiAgICovXG4gIHJlYWRvbmx5IGF1dGhvcml6ZXI/OiBJV2ViU29ja2V0Um91dGVBdXRob3JpemVyO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgdG8gaW5pdGlhbGl6ZSBhIG5ldyBSb3V0ZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFdlYlNvY2tldFJvdXRlUHJvcHMgZXh0ZW5kcyBXZWJTb2NrZXRSb3V0ZU9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIEFQSSB0aGUgcm91dGUgaXMgYXNzb2NpYXRlZCB3aXRoLlxuICAgKi9cbiAgcmVhZG9ubHkgd2ViU29ja2V0QXBpOiBJV2ViU29ja2V0QXBpO1xuXG4gIC8qKlxuICAgKiBUaGUga2V5IHRvIHRoaXMgcm91dGUuXG4gICAqL1xuICByZWFkb25seSByb3V0ZUtleTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSByb3V0ZSByZXF1aXJlcyBhbiBBUEkgS2V5IHRvIGJlIHByb3ZpZGVkXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBhcGlLZXlSZXF1aXJlZD86IGJvb2xlYW47XG59XG5cbi8qKlxuICogUm91dGUgY2xhc3MgdGhhdCBjcmVhdGVzIHRoZSBSb3V0ZSBmb3IgQVBJIEdhdGV3YXkgV2ViU29ja2V0IEFQSVxuICogQHJlc291cmNlIEFXUzo6QXBpR2F0ZXdheVYyOjpSb3V0ZVxuICovXG5leHBvcnQgY2xhc3MgV2ViU29ja2V0Um91dGUgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElXZWJTb2NrZXRSb3V0ZSB7XG4gIHB1YmxpYyByZWFkb25seSByb3V0ZUlkOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSB3ZWJTb2NrZXRBcGk6IElXZWJTb2NrZXRBcGk7XG4gIHB1YmxpYyByZWFkb25seSByb3V0ZUtleTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiByZXNwb25zZSBJRFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGludGVncmF0aW9uUmVzcG9uc2VJZD86IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogV2ViU29ja2V0Um91dGVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBpZiAocHJvcHMucm91dGVLZXkgIT0gJyRjb25uZWN0JyAmJiBwcm9wcy5hdXRob3JpemVyKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1lvdSBjYW4gb25seSBzZXQgYSBXZWJTb2NrZXQgYXV0aG9yaXplciB0byBhICRjb25uZWN0IHJvdXRlLicpO1xuICAgIH1cblxuICAgIHRoaXMud2ViU29ja2V0QXBpID0gcHJvcHMud2ViU29ja2V0QXBpO1xuICAgIHRoaXMucm91dGVLZXkgPSBwcm9wcy5yb3V0ZUtleTtcblxuICAgIGNvbnN0IGNvbmZpZyA9IHByb3BzLmludGVncmF0aW9uLl9iaW5kVG9Sb3V0ZSh7XG4gICAgICByb3V0ZTogdGhpcyxcbiAgICAgIHNjb3BlOiB0aGlzLFxuICAgIH0pO1xuXG4gICAgY29uc3QgYXV0aG9yaXplciA9IHByb3BzLmF1dGhvcml6ZXIgPz8gbmV3IFdlYlNvY2tldE5vbmVBdXRob3JpemVyKCk7IC8vIG11c3QgYmUgZXhwbGljaXRseSBOT05FIChub3QgdW5kZWZpbmVkKSBmb3Igc3RhY2sgdXBkYXRlcyB0byB3b3JrIGNvcnJlY3RseVxuICAgIGNvbnN0IGF1dGhCaW5kUmVzdWx0ID0gYXV0aG9yaXplci5iaW5kKHtcbiAgICAgIHJvdXRlOiB0aGlzLFxuICAgICAgc2NvcGU6IHRoaXMud2ViU29ja2V0QXBpIGluc3RhbmNlb2YgQ29uc3RydWN0ID8gdGhpcy53ZWJTb2NrZXRBcGkgOiB0aGlzLCAvLyBzY29wZSB1bmRlciB0aGUgQVBJIGlmIGl0J3Mgbm90IGltcG9ydGVkXG4gICAgfSk7XG5cbiAgICBjb25zdCByb3V0ZSA9IG5ldyBDZm5Sb3V0ZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhcGlJZDogcHJvcHMud2ViU29ja2V0QXBpLmFwaUlkLFxuICAgICAgYXBpS2V5UmVxdWlyZWQ6IHByb3BzLmFwaUtleVJlcXVpcmVkLFxuICAgICAgcm91dGVLZXk6IHByb3BzLnJvdXRlS2V5LFxuICAgICAgdGFyZ2V0OiBgaW50ZWdyYXRpb25zLyR7Y29uZmlnLmludGVncmF0aW9uSWR9YCxcbiAgICAgIGF1dGhvcml6ZXJJZDogYXV0aEJpbmRSZXN1bHQuYXV0aG9yaXplcklkLFxuICAgICAgYXV0aG9yaXphdGlvblR5cGU6IGF1dGhCaW5kUmVzdWx0LmF1dGhvcml6YXRpb25UeXBlLFxuICAgIH0pO1xuICAgIHRoaXMucm91dGVJZCA9IHJvdXRlLnJlZjtcbiAgfVxufVxuIl19