/**
 * Selectize (v0.15.0)
 * https://selectize.dev
 *
 * Copyright (c) 2013-2015 Brian Reavis & contributors
 * Copyright (c) 2020-2022 Selectize Team & contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at:
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
 * ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 *
 * @author Brian Reavis <brian@thirdroute.com>
 * @author Ris Adams <selectize@risadams.com>
 */
(function (root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(['jquery'], factory);
  } else if (typeof module === 'object' && typeof module.exports === 'object') {
    module.exports = factory(require('jquery'));
  } else {
    root.Selectize = factory(root.jQuery);
  }
}(this, function ($) {
  'use strict';
var highlight=function(t,e){var r,a;if("string"!=typeof e||e.length)return r="string"==typeof e?new RegExp(e,"i"):e,a=function(t){var e=0;if(3===t.nodeType){var n,i,o=t.data.search(r);0<=o&&0<t.data.length&&(i=t.data.match(r),(n=document.createElement("span")).className="highlight",(o=t.splitText(o)).splitText(i[0].length),i=o.cloneNode(!0),n.appendChild(i),o.parentNode.replaceChild(n,o),e=1)}else if(1===t.nodeType&&t.childNodes&&!/(script|style)/i.test(t.tagName)&&("highlight"!==t.className||"SPAN"!==t.tagName))for(var s=0;s<t.childNodes.length;++s)s+=a(t.childNodes[s]);return e},t.each(function(){a(this)})},MicroEvent=($.fn.removeHighlight=function(){return this.find("span.highlight").each(function(){this.parentNode.firstChild.nodeName;var t=this.parentNode;t.replaceChild(this.firstChild,this),t.normalize()}).end()},function(){}),MicroPlugin=(MicroEvent.prototype={on:function(t,e){this._events=this._events||{},this._events[t]=this._events[t]||[],this._events[t].push(e)},off:function(t,e){var n=arguments.length;return 0===n?delete this._events:1===n?delete this._events[t]:(this._events=this._events||{},void(t in this._events!=!1&&this._events[t].splice(this._events[t].indexOf(e),1)))},trigger:function(t){var e=this._events=this._events||{};if(t in e!=!1)for(var n=0;n<e[t].length;n++)e[t][n].apply(this,Array.prototype.slice.call(arguments,1))}},MicroEvent.mixin=function(t){for(var e=["on","off","trigger"],n=0;n<e.length;n++)t.prototype[e[n]]=MicroEvent.prototype[e[n]]},{}),utils=(MicroPlugin.mixin=function(o){o.plugins={},o.prototype.initializePlugins=function(t){var e,n,i,o=this,s=[];if(o.plugins={names:[],settings:{},requested:{},loaded:{}},utils.isArray(t))for(e=0,n=t.length;e<n;e++)"string"==typeof t[e]?s.push(t[e]):(o.plugins.settings[t[e].name]=t[e].options,s.push(t[e].name));else if(t)for(i in t)t.hasOwnProperty(i)&&(o.plugins.settings[i]=t[i],s.push(i));for(;s.length;)o.require(s.shift())},o.prototype.loadPlugin=function(t){var e=this,n=e.plugins,i=o.plugins[t];if(!o.plugins.hasOwnProperty(t))throw new Error('Unable to find "'+t+'" plugin');n.requested[t]=!0,n.loaded[t]=i.fn.apply(e,[e.plugins.settings[t]||{}]),n.names.push(t)},o.prototype.require=function(t){var e=this,n=e.plugins;if(!e.plugins.loaded.hasOwnProperty(t)){if(n.requested[t])throw new Error('Plugin has circular dependency ("'+t+'")');e.loadPlugin(t)}return n.loaded[t]},o.define=function(t,e){o.plugins[t]={name:t,fn:e}}},{isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)}}),Sifter=function(t,e){this.items=t,this.settings=e||{diacritics:!0}},cmp=(Sifter.prototype.tokenize=function(t,e){if(!(t=trim(String(t||"").toLowerCase()))||!t.length)return[];for(var n,i,o=[],s=t.split(/ +/),r=0,a=s.length;r<a;r++){if(n=escape_regex(s[r]),this.settings.diacritics)for(i in DIACRITICS)DIACRITICS.hasOwnProperty(i)&&(n=n.replace(new RegExp(i,"g"),DIACRITICS[i]));e&&(n="\\b"+n),o.push({string:s[r],regex:new RegExp(n,"i")})}return o},Sifter.prototype.iterator=function(t,e){var n=is_array(t)?Array.prototype.forEach||function(t){for(var e=0,n=this.length;e<n;e++)t(this[e],e,this)}:function(t){for(var e in this)this.hasOwnProperty(e)&&t(this[e],e,this)};n.apply(t,[e])},Sifter.prototype.getScoreFunction=function(t,e){function o(t,e){var n;return!t||-1===(n=(t=String(t||"")).search(e.regex))?0:(e=e.string.length/t.length,0===n&&(e+=.5),e)}var s,r=(t=this.prepareSearch(t,e)).tokens,a=t.options.fields,l=r.length,p=t.options.nesting,c=(s=a.length)?1===s?function(t,e){return o(getattr(e,a[0],p),t)}:function(t,e){for(var n=0,i=0;n<s;n++)i+=o(getattr(e,a[n],p),t);return i/s}:function(){return 0};return l?1===l?function(t){return c(r[0],t)}:"and"===t.options.conjunction?function(t){for(var e,n=0,i=0;n<l;n++){if((e=c(r[n],t))<=0)return 0;i+=e}return i/l}:function(t){for(var e=0,n=0;e<l;e++)n+=c(r[e],t);return n/l}:function(){return 0}},Sifter.prototype.getSortFunction=function(t,n){var e,i,o,s,r,a,l,p=this,c=!(t=p.prepareSearch(t,n)).query&&n.sort_empty||n.sort,d=function(t,e){return"$score"===t?e.score:getattr(p.items[e.id],t,n.nesting)},u=[];if(c)for(e=0,i=c.length;e<i;e++)!t.query&&"$score"===c[e].field||u.push(c[e]);if(t.query){for(l=!0,e=0,i=u.length;e<i;e++)if("$score"===u[e].field){l=!1;break}l&&u.unshift({field:"$score",direction:"desc"})}else for(e=0,i=u.length;e<i;e++)if("$score"===u[e].field){u.splice(e,1);break}for(a=[],e=0,i=u.length;e<i;e++)a.push("desc"===u[e].direction?-1:1);return(s=u.length)?1===s?(o=u[0].field,r=a[0],function(t,e){return r*cmp(d(o,t),d(o,e))}):function(t,e){for(var n,i=0;i<s;i++)if(n=u[i].field,n=a[i]*cmp(d(n,t),d(n,e)))return n;return 0}:null},Sifter.prototype.prepareSearch=function(t,e){var n,i,o;return"object"==typeof t?t:(n=(e=extend({},e)).fields,i=e.sort,o=e.sort_empty,n&&!is_array(n)&&(e.fields=[n]),i&&!is_array(i)&&(e.sort=[i]),o&&!is_array(o)&&(e.sort_empty=[o]),{options:e,query:String(t||"").toLowerCase(),tokens:this.tokenize(t,e.respect_word_boundaries),total:0,items:[]})},Sifter.prototype.search=function(t,n){var i,o,e=this,s=this.prepareSearch(t,n);return n=s.options,t=s.query,o=n.score||e.getScoreFunction(s),t.length?e.iterator(e.items,function(t,e){i=o(t),(!1===n.filter||0<i)&&s.items.push({score:i,id:e})}):e.iterator(e.items,function(t,e){s.items.push({score:1,id:e})}),(t=e.getSortFunction(s,n))&&s.items.sort(t),s.total=s.items.length,"number"==typeof n.limit&&(s.items=s.items.slice(0,n.limit)),s},function(t,e){return"number"==typeof t&&"number"==typeof e?e<t?1:t<e?-1:0:(t=asciifold(String(t||"")),(e=asciifold(String(e||"")))<t?1:t<e?-1:0)}),extend=function(t,e){for(var n,i,o=1,s=arguments.length;o<s;o++)if(i=arguments[o])for(n in i)i.hasOwnProperty(n)&&(t[n]=i[n]);return t},getattr=function(t,e,n){if(t&&e){if(!n)return t[e];for(var i=e.split(".");i.length&&(t=t[i.shift()]););return t}},trim=function(t){return(t+"").replace(/^\s+|\s+$|/g,"")},escape_regex=function(t){return(t+"").replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")},is_array=Array.isArray||"undefined"!=typeof $&&$.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},DIACRITICS={a:"[aḀḁĂăÂâǍǎȺⱥȦȧẠạÄäÀàÁáĀāÃãÅåąĄÃąĄ]",b:"[b␢βΒB฿𐌁ᛒ]",c:"[cĆćĈĉČčĊċC̄c̄ÇçḈḉȻȼƇƈɕᴄＣｃ]",d:"[dĎďḊḋḐḑḌḍḒḓḎḏĐđD̦d̦ƉɖƊɗƋƌᵭᶁᶑȡᴅＤｄð]",e:"[eÉéÈèÊêḘḙĚěĔĕẼẽḚḛẺẻĖėËëĒēȨȩĘęᶒɆɇȄȅẾếỀềỄễỂểḜḝḖḗḔḕȆȇẸẹỆệⱸᴇＥｅɘǝƏƐε]",f:"[fƑƒḞḟ]",g:"[gɢ₲ǤǥĜĝĞğĢģƓɠĠġ]",h:"[hĤĥĦħḨḩẖẖḤḥḢḣɦʰǶƕ]",i:"[iÍíÌìĬĭÎîǏǐÏïḮḯĨĩĮįĪīỈỉȈȉȊȋỊịḬḭƗɨɨ̆ᵻᶖİiIıɪＩｉ]",j:"[jȷĴĵɈɉʝɟʲ]",k:"[kƘƙꝀꝁḰḱǨǩḲḳḴḵκϰ₭]",l:"[lŁłĽľĻļĹĺḶḷḸḹḼḽḺḻĿŀȽƚⱠⱡⱢɫɬᶅɭȴʟＬｌ]",n:"[nŃńǸǹŇňÑñṄṅŅņṆṇṊṋṈṉN̈n̈ƝɲȠƞᵰᶇɳȵɴＮｎŊŋ]",o:"[oØøÖöÓóÒòÔôǑǒŐőŎŏȮȯỌọƟɵƠơỎỏŌōÕõǪǫȌȍՕօ]",p:"[pṔṕṖṗⱣᵽƤƥᵱ]",q:"[qꝖꝗʠɊɋꝘꝙq̃]",r:"[rŔŕɌɍŘřŖŗṘṙȐȑȒȓṚṛⱤɽ]",s:"[sŚśṠṡṢṣꞨꞩŜŝŠšŞşȘșS̈s̈]",t:"[tŤťṪṫŢţṬṭƮʈȚțṰṱṮṯƬƭ]",u:"[uŬŭɄʉỤụÜüÚúÙùÛûǓǔŰűŬŭƯưỦủŪūŨũŲųȔȕ∪]",v:"[vṼṽṾṿƲʋꝞꝟⱱʋ]",w:"[wẂẃẀẁŴŵẄẅẆẇẈẉ]",x:"[xẌẍẊẋχ]",y:"[yÝýỲỳŶŷŸÿỸỹẎẏỴỵɎɏƳƴ]",z:"[zŹźẐẑŽžŻżẒẓẔẕƵƶ]"},asciifold=function(){var t,e,n,i,o="",s={};for(n in DIACRITICS)if(DIACRITICS.hasOwnProperty(n))for(o+=i=DIACRITICS[n].substring(2,DIACRITICS[n].length-1),t=0,e=i.length;t<e;t++)s[i.charAt(t)]=n;var r=new RegExp("["+o+"]","g");return function(t){return t.replace(r,function(t){return s[t]}).toLowerCase()}}();function uaDetect(t,e){return navigator.userAgentData?t===navigator.userAgentData.platform:e.test(navigator.userAgent)}var IS_MAC=uaDetect("macOS",/Mac/),KEY_A=65,KEY_COMMA=188,KEY_RETURN=13,KEY_ESC=27,KEY_LEFT=37,KEY_UP=38,KEY_P=80,KEY_RIGHT=39,KEY_DOWN=40,KEY_N=78,KEY_BACKSPACE=8,KEY_DELETE=46,KEY_SHIFT=16,KEY_CMD=IS_MAC?91:17,KEY_CTRL=IS_MAC?18:17,KEY_TAB=9,TAG_SELECT=1,TAG_INPUT=2,SUPPORTS_VALIDITY_API=!uaDetect("Android",/android/i)&&!!document.createElement("input").validity,isset=function(t){return void 0!==t},hash_key=function(t){return null==t?null:"boolean"==typeof t?t?"1":"0":t+""},escape_html=function(t){return(t+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;")},escape_replace=function(t){return(t+"").replace(/\$/g,"$$$$")},hook={before:function(t,e,n){var i=t[e];t[e]=function(){return n.apply(t,arguments),i.apply(t,arguments)}},after:function(e,t,n){var i=e[t];e[t]=function(){var t=i.apply(e,arguments);return n.apply(e,arguments),t}}},once=function(t){var e=!1;return function(){e||(e=!0,t.apply(this,arguments))}},debounce=function(n,i){var o;return function(){var t=this,e=arguments;window.clearTimeout(o),o=window.setTimeout(function(){n.apply(t,e)},i)}},debounce_events=function(e,n,t){var i,o=e.trigger,s={};for(i in e.trigger=function(){var t=arguments[0];if(-1===n.indexOf(t))return o.apply(e,arguments);s[t]=arguments},t.apply(e,[]),e.trigger=o,s)s.hasOwnProperty(i)&&o.apply(e,s[i])},watchChildEvent=function(n,t,e,i){n.on(t,e,function(t){for(var e=t.target;e&&e.parentNode!==n[0];)e=e.parentNode;return t.currentTarget=e,i.apply(this,[t])})},getInputSelection=function(t){var e,n,i={};return void 0===t?console.warn("WARN getInputSelection cannot locate input control"):"selectionStart"in t?(i.start=t.selectionStart,i.length=t.selectionEnd-i.start):document.selection&&(t.focus(),e=document.selection.createRange(),n=document.selection.createRange().text.length,e.moveStart("character",-t.value.length),i.start=e.text.length-n,i.length=n),i},transferStyles=function(t,e,n){var i,o,s={};if(n)for(i=0,o=n.length;i<o;i++)s[n[i]]=t.css(n[i]);else s=t.css();e.css(s)},measureString=function(t,e){return t?(Selectize.$testInput||(Selectize.$testInput=$("<span />").css({position:"absolute",width:"auto",padding:0,whiteSpace:"pre"}),$("<div />").css({position:"absolute",width:0,height:0,overflow:"hidden"}).append(Selectize.$testInput).appendTo("body")),Selectize.$testInput.text(t),transferStyles(e,Selectize.$testInput,["letterSpacing","fontSize","fontFamily","fontWeight","textTransform"]),Selectize.$testInput.width()):0},autoGrow=function(s){function t(t,e){var n,i,o;e=e||{},(t=t||window.event||{}).metaKey||t.altKey||!e.force&&!1===s.data("grow")||(e=s.val(),t.type&&"keydown"===t.type.toLowerCase()&&(n=48<=(i=t.keyCode)&&i<=57||65<=i&&i<=90||96<=i&&i<=111||186<=i&&i<=222||32===i,i===KEY_DELETE||i===KEY_BACKSPACE?(o=getInputSelection(s[0])).length?e=e.substring(0,o.start)+e.substring(o.start+o.length):i===KEY_BACKSPACE&&o.start?e=e.substring(0,o.start-1)+e.substring(o.start+1):i===KEY_DELETE&&void 0!==o.start&&(e=e.substring(0,o.start)+e.substring(o.start+1)):n&&(i=t.shiftKey,o=String.fromCharCode(t.keyCode),e+=o=i?o.toUpperCase():o.toLowerCase())),t=(n=s.attr("placeholder"))?measureString(n,s)+4:0,(i=Math.max(measureString(e,s),t)+4)===r)||(r=i,s.width(i),s.triggerHandler("resize"))}var r=null;s.on("keydown keyup update blur",t),t()},domToString=function(t){var e=document.createElement("div");return e.appendChild(t.cloneNode(!0)),e.innerHTML},logError=function(t,e){e=e||{};console.error("Selectize: "+t),e.explanation&&(console.group&&console.group(),console.error(e.explanation),console.group)&&console.groupEnd()},isJSON=function(t){try{JSON.parse(str)}catch(t){return!1}return!0},Selectize=function(t,e){var n,i,o=this,s=t[0],r=(s.selectize=o,window.getComputedStyle&&window.getComputedStyle(s,null));if(r=(r?r.getPropertyValue("direction"):s.currentStyle&&s.currentStyle.direction)||t.parents("[dir]:first").attr("dir")||"",$.extend(o,{order:0,settings:e,$input:t,tabIndex:t.attr("tabindex")||"",tagType:"select"===s.tagName.toLowerCase()?TAG_SELECT:TAG_INPUT,rtl:/rtl/i.test(r),eventNS:".selectize"+ ++Selectize.count,highlightedValue:null,isBlurring:!1,isOpen:!1,isDisabled:!1,isRequired:t.is("[required]"),isInvalid:!1,isLocked:!1,isFocused:!1,isInputHidden:!1,isSetup:!1,isShiftDown:!1,isCmdDown:!1,isCtrlDown:!1,ignoreFocus:!1,ignoreBlur:!1,ignoreHover:!1,hasOptions:!1,currentResults:null,lastValue:"",lastValidValue:"",lastOpenTarget:!1,caretPos:0,loading:0,loadedSearches:{},isDropdownClosing:!1,$activeOption:null,$activeItems:[],optgroups:{},options:{},userOptions:{},items:[],renderCache:{},onSearchChange:null===e.loadThrottle?o.onSearchChange:debounce(o.onSearchChange,e.loadThrottle)}),o.sifter=new Sifter(this.options,{diacritics:e.diacritics}),o.settings.options){for(n=0,i=o.settings.options.length;n<i;n++)o.registerOption(o.settings.options[n]);delete o.settings.options}if(o.settings.optgroups){for(n=0,i=o.settings.optgroups.length;n<i;n++)o.registerOptionGroup(o.settings.optgroups[n]);delete o.settings.optgroups}o.settings.mode=o.settings.mode||(1===o.settings.maxItems?"single":"multi"),"boolean"!=typeof o.settings.hideSelected&&(o.settings.hideSelected="multi"===o.settings.mode),o.initializePlugins(o.settings.plugins),o.setupCallbacks(),o.setupTemplates(),o.setup()};MicroEvent.mixin(Selectize),MicroPlugin.mixin(Selectize),$.extend(Selectize.prototype,{setup:function(){var e=this,t=e.settings,n=e.eventNS,i=$(window),o=$(document),s=e.$input,r=e.settings.mode,a=s.attr("class")||"",l=$("<div>").addClass(t.wrapperClass).addClass(a+" selectize-control").addClass(r),p=$("<div>").addClass(t.inputClass+" selectize-input items").appendTo(l),c=$('<input type="select-one" autocomplete="new-password" autofill="no" />').appendTo(p).attr("tabindex",s.is(":disabled")?"-1":e.tabIndex),d=$(t.dropdownParent||l),r=$("<div>").addClass(t.dropdownClass).addClass(r+" selectize-dropdown").hide().appendTo(d),d=$("<div>").addClass(t.dropdownContentClass+" selectize-dropdown-content").attr("tabindex","-1").appendTo(r),u=((u=s.attr("id"))&&(c.attr("id",u+"-selectized"),$("label[for='"+u+"']").attr("for",u+"-selectized")),e.settings.copyClassesToDropdown&&r.addClass(a),l.css({width:s[0].style.width}),e.plugins.names.length&&(u="plugin-"+e.plugins.names.join(" plugin-"),l.addClass(u),r.addClass(u)),(null===t.maxItems||1<t.maxItems)&&e.tagType===TAG_SELECT&&s.attr("multiple","multiple"),e.settings.placeholder&&c.attr("placeholder",t.placeholder),e.settings.search||(c.attr("readonly",!0),c.attr("inputmode","none"),p.css("cursor","pointer")),!e.settings.splitOn&&e.settings.delimiter&&(a=e.settings.delimiter.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"),e.settings.splitOn=new RegExp("\\s*"+a+"+\\s*")),s.attr("autocorrect")&&c.attr("autocorrect",s.attr("autocorrect")),s.attr("autocapitalize")&&c.attr("autocapitalize",s.attr("autocapitalize")),s.is("input")&&(c[0].type=s[0].type),e.$wrapper=l,e.$control=p,e.$control_input=c,e.$dropdown=r,e.$dropdown_content=d,r.on("mouseenter mousedown mouseup click","[data-disabled]>[data-selectable]",function(t){t.stopImmediatePropagation()}),r.on("mouseenter","[data-selectable]",function(){return e.onOptionHover.apply(e,arguments)}),r.on("mouseup click","[data-selectable]",function(){return e.onOptionSelect.apply(e,arguments)}),watchChildEvent(p,"mouseup","*:not(input)",function(){return e.onItemSelect.apply(e,arguments)}),autoGrow(c),p.on({mousedown:function(){return e.onMouseDown.apply(e,arguments)},click:function(){return e.onClick.apply(e,arguments)}}),c.on({mousedown:function(t){""===e.$control_input.val()&&!e.settings.openOnFocus||t.stopPropagation()},keydown:function(){return e.onKeyDown.apply(e,arguments)},keypress:function(){return e.onKeyPress.apply(e,arguments)},input:function(){return e.onInput.apply(e,arguments)},resize:function(){e.positionDropdown.apply(e,[])},focus:function(){return e.ignoreBlur=!1,e.onFocus.apply(e,arguments)},paste:function(){return e.onPaste.apply(e,arguments)}}),o.on("keydown"+n,function(t){e.isCmdDown=t[IS_MAC?"metaKey":"ctrlKey"],e.isCtrlDown=t[IS_MAC?"altKey":"ctrlKey"],e.isShiftDown=t.shiftKey}),o.on("keyup"+n,function(t){t.keyCode===KEY_CTRL&&(e.isCtrlDown=!1),t.keyCode===KEY_SHIFT&&(e.isShiftDown=!1),t.keyCode===KEY_CMD&&(e.isCmdDown=!1)}),o.on("mousedown"+n,function(t){if(e.isFocused){if(t.target===e.$dropdown[0]||t.target.parentNode===e.$dropdown[0])return!1;e.$dropdown.has(t.target).length||t.target===e.$control[0]||e.blur(t.target)}}),i.on(["scroll"+n,"resize"+n].join(" "),function(){e.isOpen&&e.positionDropdown.apply(e,arguments)}),i.on("mousemove"+n,function(){e.ignoreHover=e.settings.ignoreHover}),$("<div></div>")),a=s.children().detach();s.replaceWith(u),u.replaceWith(s),this.revertSettings={$children:a,tabindex:s.attr("tabindex")},s.attr("tabindex",-1).hide().after(e.$wrapper),Array.isArray(t.items)&&(e.lastValidValue=t.items,e.setValue(t.items),delete t.items),SUPPORTS_VALIDITY_API&&s.on("invalid"+n,function(t){t.preventDefault(),e.isInvalid=!0,e.refreshState()}),e.updateOriginalInput(),e.refreshItems(),e.refreshState(),e.updatePlaceholder(),e.isSetup=!0,s.is(":disabled")&&e.disable(),e.on("change",this.onChange),s.data("selectize",e),s.addClass("selectized"),e.trigger("initialize"),!0===t.preload&&e.onSearchChange("")},setupTemplates:function(){var t=this,i=t.settings.labelField,o=t.settings.valueField,n=t.settings.optgroupLabelField;t.settings.render=$.extend({},{optgroup:function(t){return'<div class="optgroup">'+t.html+"</div>"},optgroup_header:function(t,e){return'<div class="optgroup-header">'+e(t[n])+"</div>"},option:function(t,e){var n=t.classes?" "+t.classes:"";return n+=""===t[o]?" selectize-dropdown-emptyoptionlabel":"","<div"+(t.styles?' style="'+t.styles+'"':"")+' class="option'+n+'">'+e(t[i])+"</div>"},item:function(t,e){return'<div class="item">'+e(t[i])+"</div>"},option_create:function(t,e){return'<div class="create">Add <strong>'+e(t.input)+"</strong>&#x2026;</div>"}},t.settings.render)},setupCallbacks:function(){var t,e,n={initialize:"onInitialize",change:"onChange",item_add:"onItemAdd",item_remove:"onItemRemove",clear:"onClear",option_add:"onOptionAdd",option_remove:"onOptionRemove",option_clear:"onOptionClear",optgroup_add:"onOptionGroupAdd",optgroup_remove:"onOptionGroupRemove",optgroup_clear:"onOptionGroupClear",dropdown_open:"onDropdownOpen",dropdown_close:"onDropdownClose",type:"onType",load:"onLoad",focus:"onFocus",blur:"onBlur",dropdown_item_activate:"onDropdownItemActivate",dropdown_item_deactivate:"onDropdownItemDeactivate"};for(t in n)n.hasOwnProperty(t)&&(e=this.settings[n[t]])&&this.on(t,e)},onClick:function(t){this.isDropdownClosing||this.isFocused&&this.isOpen||(this.focus(),t.preventDefault())},onMouseDown:function(t){var e=this,n=t.isDefaultPrevented();$(t.target);if(e.isFocused||n||window.setTimeout(function(){e.focus()},0),t.target!==e.$control_input[0]||""===e.$control_input.val())return"single"===e.settings.mode?e.isOpen?e.close():e.open():(n||e.setActiveItem(null),e.settings.openOnFocus||(e.isOpen&&t.target===e.lastOpenTarget?(e.close(),e.lastOpenTarget=!1):(e.isOpen||(e.refreshOptions(),e.open()),e.lastOpenTarget=t.target))),!1},onChange:function(){""!==this.getValue()&&(this.lastValidValue=this.getValue()),this.$input.trigger("input"),this.$input.trigger("change")},onPaste:function(t){var o=this;o.isFull()||o.isInputHidden||o.isLocked?t.preventDefault():o.settings.splitOn&&setTimeout(function(){var t=o.$control_input.val();if(t.match(o.settings.splitOn))for(var e=t.trim().split(o.settings.splitOn),n=0,i=e.length;n<i;n++)o.createItem(e[n])},0)},onKeyPress:function(t){var e;return this.isLocked?t&&t.preventDefault():(e=String.fromCharCode(t.keyCode||t.which),this.settings.create&&"multi"===this.settings.mode&&e===this.settings.delimiter?(this.createItem(),t.preventDefault(),!1):void 0)},onKeyDown:function(t){t.target,this.$control_input[0];var e,n=this;if(n.isLocked)t.keyCode!==KEY_TAB&&t.preventDefault();else{switch(t.keyCode){case KEY_A:if(n.isCmdDown)return void n.selectAll();break;case KEY_ESC:return void(n.isOpen&&(t.preventDefault(),t.stopPropagation(),n.close()));case KEY_N:if(!t.ctrlKey||t.altKey)break;case KEY_DOWN:return!n.isOpen&&n.hasOptions?n.open():n.$activeOption&&(n.ignoreHover=!0,(e=n.getAdjacentOption(n.$activeOption,1)).length)&&n.setActiveOption(e,!0,!0),void t.preventDefault();case KEY_P:if(!t.ctrlKey||t.altKey)break;case KEY_UP:return n.$activeOption&&(n.ignoreHover=!0,(e=n.getAdjacentOption(n.$activeOption,-1)).length)&&n.setActiveOption(e,!0,!0),void t.preventDefault();case KEY_RETURN:return void(n.isOpen&&n.$activeOption&&(n.onOptionSelect({currentTarget:n.$activeOption}),t.preventDefault()));case KEY_LEFT:return void n.advanceSelection(-1,t);case KEY_RIGHT:return void n.advanceSelection(1,t);case KEY_TAB:return n.settings.selectOnTab&&n.isOpen&&n.$activeOption&&(n.onOptionSelect({currentTarget:n.$activeOption}),n.isFull()||t.preventDefault()),void(n.settings.create&&n.createItem()&&n.settings.showAddOptionOnCreate&&t.preventDefault());case KEY_BACKSPACE:case KEY_DELETE:return void n.deleteSelection(t)}!n.isFull()&&!n.isInputHidden||(IS_MAC?t.metaKey:t.ctrlKey)||t.preventDefault()}},onInput:function(t){var e=this,n=e.$control_input.val()||"";e.lastValue!==n&&(e.lastValue=n,e.onSearchChange(n),e.refreshOptions(),e.trigger("type",n))},onSearchChange:function(e){var n=this,i=n.settings.load;i&&!n.loadedSearches.hasOwnProperty(e)&&(n.loadedSearches[e]=!0,n.load(function(t){i.apply(n,[e,t])}))},onFocus:function(t){var e=this,n=e.isFocused;if(e.isDisabled)return e.blur(),t&&t.preventDefault(),!1;e.ignoreFocus||(e.isFocused=!0,"focus"===e.settings.preload&&e.onSearchChange(""),n||e.trigger("focus"),e.$activeItems.length||(e.showInput(),e.setActiveItem(null),e.refreshOptions(!!e.settings.openOnFocus)),e.refreshState())},onBlur:function(t,e){var n,i=this;i.isFocused&&(i.isFocused=!1,i.ignoreFocus||(n=function(){i.close(),i.setTextboxValue(""),i.setActiveItem(null),i.setActiveOption(null),i.setCaret(i.items.length),i.refreshState(),e&&e.focus&&e.focus(),i.isBlurring=!1,i.ignoreFocus=!1,i.trigger("blur")},i.isBlurring=!0,i.ignoreFocus=!0,i.settings.create&&i.settings.createOnBlur?i.createItem(null,!1,n):n()))},onOptionHover:function(t){this.ignoreHover||this.setActiveOption(t.currentTarget,!1)},onOptionSelect:function(t){var e,n=this;t.preventDefault&&(t.preventDefault(),t.stopPropagation()),(e=$(t.currentTarget)).hasClass("create")?n.createItem(null,function(){n.settings.closeAfterSelect&&n.close()}):void 0!==(e=e.attr("data-value"))&&(n.lastQuery=null,n.setTextboxValue(""),n.addItem(e),n.settings.closeAfterSelect?n.close():!n.settings.hideSelected&&t.type&&/mouse/.test(t.type)&&n.setActiveOption(n.getOption(e)))},onItemSelect:function(t){this.isLocked||"multi"===this.settings.mode&&(t.preventDefault(),this.setActiveItem(t.currentTarget,t))},load:function(t){var e=this,n=e.$wrapper.addClass(e.settings.loadingClass);e.loading++,t.apply(e,[function(t){e.loading=Math.max(e.loading-1,0),t&&t.length&&(e.addOption(t),e.refreshOptions(e.isFocused&&!e.isInputHidden)),e.loading||n.removeClass(e.settings.loadingClass),e.trigger("load",t)}])},getTextboxValue:function(){return this.$control_input.val()},setTextboxValue:function(t){var e=this.$control_input;e.val()!==t&&(e.val(t).triggerHandler("update"),this.lastValue=t)},getValue:function(){return this.tagType===TAG_SELECT&&this.$input.attr("multiple")?this.items:this.items.join(this.settings.delimiter)},setValue:function(t,e){(Array.isArray(t)?t:[t]).join("")!==this.items.join("")&&debounce_events(this,e?[]:["change"],function(){this.clear(e),this.addItems(t,e)})},setMaxItems:function(t){this.settings.maxItems=t=0===t?null:t,this.settings.mode=this.settings.mode||(1===this.settings.maxItems?"single":"multi"),this.refreshState()},setActiveItem:function(t,e){var n,i,o,s,r,a,l=this;if("single"!==l.settings.mode)if((t=$(t)).length){if("mousedown"===(n=e&&e.type.toLowerCase())&&l.isShiftDown&&l.$activeItems.length){for(a=l.$control.children(".active:last"),a=Array.prototype.indexOf.apply(l.$control[0].childNodes,[a[0]]),(o=Array.prototype.indexOf.apply(l.$control[0].childNodes,[t[0]]))<a&&(r=a,a=o,o=r),i=a;i<=o;i++)s=l.$control[0].childNodes[i],-1===l.$activeItems.indexOf(s)&&($(s).addClass("active"),l.$activeItems.push(s));e.preventDefault()}else"mousedown"===n&&l.isCtrlDown||"keydown"===n&&this.isShiftDown?t.hasClass("active")?(r=l.$activeItems.indexOf(t[0]),l.$activeItems.splice(r,1),t.removeClass("active")):l.$activeItems.push(t.addClass("active")[0]):($(l.$activeItems).removeClass("active"),l.$activeItems=[t.addClass("active")[0]]);l.hideInput(),this.isFocused||l.focus()}else $(l.$activeItems).removeClass("active"),l.$activeItems=[],l.isFocused&&l.showInput()},setActiveOption:function(t,e,n){var i,o,s,r,a=this;a.$activeOption&&(a.$activeOption.removeClass("active"),a.trigger("dropdown_item_deactivate",a.$activeOption.attr("data-value"))),a.$activeOption=null,(t=$(t)).length&&(a.$activeOption=t.addClass("active"),a.isOpen&&a.trigger("dropdown_item_activate",a.$activeOption.attr("data-value")),!e&&isset(e)||(t=a.$dropdown_content.height(),i=a.$activeOption.outerHeight(!0),e=a.$dropdown_content.scrollTop()||0,r=(s=o=a.$activeOption.offset().top-a.$dropdown_content.offset().top+e)-t+i,t+e<o+i?a.$dropdown_content.stop().animate({scrollTop:r},n?a.settings.scrollDuration:0):o<e&&a.$dropdown_content.stop().animate({scrollTop:s},n?a.settings.scrollDuration:0)))},selectAll:function(){var t=this;"single"!==t.settings.mode&&(t.$activeItems=Array.prototype.slice.apply(t.$control.children(":not(input)").addClass("active")),t.$activeItems.length&&(t.hideInput(),t.close()),t.focus())},hideInput:function(){this.setTextboxValue(""),this.$control_input.css({opacity:0,position:"absolute",left:this.rtl?1e4:0}),this.isInputHidden=!0},showInput:function(){this.$control_input.css({opacity:1,position:"relative",left:0}),this.isInputHidden=!1},focus:function(){var t=this;return t.isDisabled||(t.ignoreFocus=!0,t.$control_input[0].focus(),window.setTimeout(function(){t.ignoreFocus=!1,t.onFocus()},0)),t},blur:function(t){return this.$control_input[0].blur(),this.onBlur(null,t),this},getScoreFunction:function(t){return this.sifter.getScoreFunction(t,this.getSearchOptions())},getSearchOptions:function(){var t=this.settings,e=t.sortField;return{fields:t.searchField,conjunction:t.searchConjunction,sort:e="string"==typeof e?[{field:e}]:e,nesting:t.nesting,filter:t.filter,respect_word_boundaries:t.respect_word_boundaries}},search:function(t){var e,n,i,o=this,s=o.settings,r=this.getSearchOptions();if(s.score&&"function"!=typeof(i=o.settings.score.apply(this,[t])))throw new Error('Selectize "score" setting must be a function that returns a function');if(t!==o.lastQuery?(s.normalize&&(t=t.normalize("NFD").replace(/[\u0300-\u036f]/g,"")),o.lastQuery=t,n=o.sifter.search(t,$.extend(r,{score:i})),o.currentResults=n):n=$.extend(!0,{},o.currentResults),s.hideSelected)for(e=n.items.length-1;0<=e;e--)-1!==o.items.indexOf(hash_key(n.items[e].id))&&n.items.splice(e,1);return n},refreshOptions:function(t){void 0===t&&(t=!0);var e,n,i,o,s,r,a,l,p,c,d,u,h,g,f=this,v=f.$control_input.val().trim(),m=f.search(v),y=f.$dropdown_content,w=f.$activeOption&&hash_key(f.$activeOption.attr("data-value")),C=m.items.length;for("number"==typeof f.settings.maxOptions&&(C=Math.min(C,f.settings.maxOptions)),o={},s=[],e=0;e<C;e++)for(r=f.options[m.items[e].id],a=f.render("option",r),l=r[f.settings.optgroupField]||"",n=0,i=(p=Array.isArray(l)?l:[l])&&p.length;n<i;n++)l=p[n],f.optgroups.hasOwnProperty(l)||(l=""),o.hasOwnProperty(l)||(o[l]=document.createDocumentFragment(),s.push(l)),o[l].appendChild(a);for(this.settings.lockOptgroupOrder&&s.sort(function(t,e){return(f.optgroups[t]&&f.optgroups[t].$order||0)-(f.optgroups[e]&&f.optgroups[e].$order||0)}),c=document.createDocumentFragment(),e=0,C=s.length;e<C;e++)f.optgroups.hasOwnProperty(l=s[e])&&o[l].childNodes.length?((d=document.createDocumentFragment()).appendChild(f.render("optgroup_header",f.optgroups[l])),d.appendChild(o[l]),c.appendChild(f.render("optgroup",$.extend({},f.optgroups[l],{html:domToString(d),dom:d})))):c.appendChild(o[l]);if(y.html(c),f.settings.highlight&&(y.removeHighlight(),m.query.length)&&m.tokens.length)for(e=0,C=m.tokens.length;e<C;e++)highlight(y,m.tokens[e].regex);if(!f.settings.hideSelected)for(f.$dropdown.find(".selected").removeClass("selected"),e=0,C=f.items.length;e<C;e++)f.getOption(f.items[e]).addClass("selected");"auto"!==f.settings.dropdownSize.sizeType&&f.isOpen&&f.setupDropdownHeight(),(u=f.canCreate(v))&&f.settings.showAddOptionOnCreate&&(y.prepend(f.render("option_create",{input:v})),g=$(y[0].childNodes[0])),f.hasOptions=0<m.items.length||u&&f.settings.showAddOptionOnCreate||f.settings.setFirstOptionActive,f.hasOptions?(0<m.items.length?(v=w&&f.getOption(w),""!==m.query&&f.settings.setFirstOptionActive?h=y.find("[data-selectable]:first"):""!==m.query&&v&&v.length?h=v:"single"===f.settings.mode&&f.items.length&&(h=f.getOption(f.items[0])),h&&h.length||(h=g&&!f.settings.addPrecedence?f.getAdjacentOption(g,1):y.find("[data-selectable]:first"))):h=g,f.setActiveOption(h),t&&!f.isOpen&&f.open()):(f.setActiveOption(null),t&&f.isOpen&&f.close())},addOption:function(t){var e,n,i,o=this;if(Array.isArray(t))for(e=0,n=t.length;e<n;e++)o.addOption(t[e]);else(i=o.registerOption(t))&&(o.userOptions[i]=!0,o.lastQuery=null,o.trigger("option_add",i,t))},registerOption:function(t){var e=hash_key(t[this.settings.valueField]);return null!=e&&!this.options.hasOwnProperty(e)&&(t.$order=t.$order||++this.order,this.options[e]=t,e)},registerOptionGroup:function(t){var e=hash_key(t[this.settings.optgroupValueField]);return!!e&&(t.$order=t.$order||++this.order,this.optgroups[e]=t,e)},addOptionGroup:function(t,e){e[this.settings.optgroupValueField]=t,(t=this.registerOptionGroup(e))&&this.trigger("optgroup_add",t,e)},removeOptionGroup:function(t){this.optgroups.hasOwnProperty(t)&&(delete this.optgroups[t],this.renderCache={},this.trigger("optgroup_remove",t))},clearOptionGroups:function(){this.optgroups={},this.renderCache={},this.trigger("optgroup_clear")},updateOption:function(t,e){var n,i,o,s=this;if(t=hash_key(t),n=hash_key(e[s.settings.valueField]),null!==t&&s.options.hasOwnProperty(t)){if("string"!=typeof n)throw new Error("Value must be set in option data");o=s.options[t].$order,n!==t&&(delete s.options[t],-1!==(i=s.items.indexOf(t)))&&s.items.splice(i,1,n),e.$order=e.$order||o,s.options[n]=e,i=s.renderCache.item,o=s.renderCache.option,i&&(delete i[t],delete i[n]),o&&(delete o[t],delete o[n]),-1!==s.items.indexOf(n)&&(i=s.getItem(t),o=$(s.render("item",e)),i.hasClass("active")&&o.addClass("active"),i.replaceWith(o)),s.lastQuery=null,s.isOpen&&s.refreshOptions(!1)}},removeOption:function(t,e){var n=this,i=(t=hash_key(t),n.renderCache.item),o=n.renderCache.option;i&&delete i[t],o&&delete o[t],delete n.userOptions[t],delete n.options[t],n.lastQuery=null,n.trigger("option_remove",t),n.removeItem(t,e)},clearOptions:function(t){var n=this,i=(n.loadedSearches={},n.userOptions={},n.renderCache={},n.options);$.each(n.options,function(t,e){-1==n.items.indexOf(t)&&delete i[t]}),n.options=n.sifter.items=i,n.lastQuery=null,n.trigger("option_clear"),n.clear(t)},getOption:function(t){return this.getElementWithValue(t,this.$dropdown_content.find("[data-selectable]"))},getFirstOption:function(){var t=this.$dropdown.find("[data-selectable]");return 0<t.length?t.eq(0):$()},getAdjacentOption:function(t,e){var n=this.$dropdown.find("[data-selectable]"),t=n.index(t)+e;return 0<=t&&t<n.length?n.eq(t):$()},getElementWithValue:function(t,e){if(null!=(t=hash_key(t)))for(var n=0,i=e.length;n<i;n++)if(e[n].getAttribute("data-value")===t)return $(e[n]);return $()},getElementWithTextContent:function(t,e,n){if(null!=(t=hash_key(t)))for(var i=0,o=n.length;i<o;i++){var s=n[i].textContent;if(1==e&&(s=null!==s?s.toLowerCase():null,t=t.toLowerCase()),s===t)return $(n[i])}return $()},getItem:function(t){return this.getElementWithValue(t,this.$control.children())},getFirstItemMatchedByTextContent:function(t,e){return this.getElementWithTextContent(t,e=null!==e&&!0===e,this.$dropdown_content.find("[data-selectable]"))},addItems:function(t,e){this.buffer=document.createDocumentFragment();for(var n=this.$control[0].childNodes,i=0;i<n.length;i++)this.buffer.appendChild(n[i]);for(var o=Array.isArray(t)?t:[t],i=0,s=o.length;i<s;i++)this.isPending=i<s-1,this.addItem(o[i],e);t=this.$control[0];t.insertBefore(this.buffer,t.firstChild),this.buffer=null},addItem:function(s,r){debounce_events(this,r?[]:["change"],function(){var t,e,n,i=this,o=i.settings.mode;s=hash_key(s),-1!==i.items.indexOf(s)?"single"===o&&i.close():i.options.hasOwnProperty(s)&&("single"===o&&i.clear(r),"multi"===o&&i.isFull()||(t=$(i.render("item",i.options[s])),n=i.isFull(),i.items.splice(i.caretPos,0,s),i.insertAtCaret(t),i.isPending&&(n||!i.isFull())||i.refreshState(),i.isSetup&&(n=i.$dropdown_content.find("[data-selectable]"),i.isPending||(e=i.getOption(s),e=i.getAdjacentOption(e,1).attr("data-value"),i.refreshOptions(i.isFocused&&"single"!==o),e&&i.setActiveOption(i.getOption(e))),!n.length||i.isFull()?i.close():i.isPending||i.positionDropdown(),i.updatePlaceholder(),i.trigger("item_add",s,t),i.isPending||i.updateOriginalInput({silent:r}))))})},removeItem:function(t,e){var n,i,o=this,s=t instanceof $?t:o.getItem(t);t=hash_key(s.attr("data-value")),-1!==(n=o.items.indexOf(t))&&(o.trigger("item_before_remove",t,s),s.remove(),s.hasClass("active")&&(s.removeClass("active"),i=o.$activeItems.indexOf(s[0]),o.$activeItems.splice(i,1),s.removeClass("active")),o.items.splice(n,1),o.lastQuery=null,!o.settings.persist&&o.userOptions.hasOwnProperty(t)&&o.removeOption(t,e),n<o.caretPos&&o.setCaret(o.caretPos-1),o.refreshState(),o.updatePlaceholder(),o.updateOriginalInput({silent:e}),o.positionDropdown(),o.trigger("item_remove",t,s))},createItem:function(t,n){var i=this,o=i.caretPos,s=(t=t||(i.$control_input.val()||"").trim(),arguments[arguments.length-1]);if("function"!=typeof s&&(s=function(){}),"boolean"!=typeof n&&(n=!0),!i.canCreate(t))return s(),!1;i.lock();var e="function"==typeof i.settings.create?this.settings.create:function(t){var e={},t=e[i.settings.labelField]=t;if(!i.settings.formatValueToKey||"function"!=typeof i.settings.formatValueToKey||null!=(t=i.settings.formatValueToKey.apply(this,[t]))&&"object"!=typeof t&&"function"!=typeof t)return e[i.settings.valueField]=t,e;throw new Error('Selectize "formatValueToKey" setting must be a function that returns a value other than object or function.')},r=once(function(t){var e;return i.unlock(),!t||"object"!=typeof t||"string"!=typeof(e=hash_key(t[i.settings.valueField]))?s():(i.setTextboxValue(""),i.addOption(t),i.setCaret(o),i.addItem(e),i.refreshOptions(n&&"single"!==i.settings.mode),void s(t))}),e=e.apply(this,[t,r]);return void 0!==e&&r(e),!0},refreshItems:function(t){this.lastQuery=null,this.isSetup&&this.addItem(this.items,t),this.refreshState(),this.updateOriginalInput({silent:t})},refreshState:function(){this.refreshValidityState(),this.refreshClasses()},refreshValidityState:function(){if(!this.isRequired)return!1;var t=!this.items.length;this.isInvalid=t,this.$control_input.prop("required",t),this.$input.prop("required",!t)},refreshClasses:function(){var t=this,e=t.isFull(),n=t.isLocked;t.$wrapper.toggleClass("rtl",t.rtl),t.$control.toggleClass("focus",t.isFocused).toggleClass("disabled",t.isDisabled).toggleClass("required",t.isRequired).toggleClass("invalid",t.isInvalid).toggleClass("locked",n).toggleClass("full",e).toggleClass("not-full",!e).toggleClass("input-active",t.isFocused&&!t.isInputHidden).toggleClass("dropdown-active",t.isOpen).toggleClass("has-options",!$.isEmptyObject(t.options)).toggleClass("has-items",0<t.items.length),t.$control_input.data("grow",!e&&!n)},isFull:function(){return null!==this.settings.maxItems&&this.items.length>=this.settings.maxItems},updateOriginalInput:function(t){var e,n,i,o,s,r,a=this;t=t||{},a.tagType===TAG_SELECT?(o=a.$input.find("option"),e=[],n=[],i=[],r=[],o.get().forEach(function(t){e.push(t.value)}),a.items.forEach(function(t){s=a.options[t][a.settings.labelField]||"",r.push(t),-1==e.indexOf(t)&&n.push('<option value="'+escape_html(t)+'" selected="selected">'+escape_html(s)+"</option>")}),i=e.filter(function(t){return r.indexOf(t)<0}).map(function(t){return'option[value="'+t+'"]'}),e.length-i.length+n.length!==0||a.$input.attr("multiple")||n.push('<option value="" selected="selected"></option>'),a.$input.find(i.join(", ")).remove(),a.$input.append(n.join(""))):(a.$input.val(a.getValue()),a.$input.attr("value",a.$input.val())),a.isSetup&&!t.silent&&a.trigger("change",a.$input.val())},updatePlaceholder:function(){var t;this.settings.placeholder&&(t=this.$control_input,this.items.length?t.removeAttr("placeholder"):t.attr("placeholder",this.settings.placeholder),t.triggerHandler("update",{force:!0}))},open:function(){var t=this;t.isLocked||t.isOpen||"multi"===t.settings.mode&&t.isFull()||(t.focus(),t.isOpen=!0,t.refreshState(),t.$dropdown.css({visibility:"hidden",display:"block"}),t.setupDropdownHeight(),t.positionDropdown(),t.$dropdown.css({visibility:"visible"}),t.trigger("dropdown_open",t.$dropdown))},close:function(){var t=this,e=t.isOpen;"single"===t.settings.mode&&t.items.length&&(t.hideInput(),t.isBlurring)&&t.$control_input[0].blur(),t.isOpen=!1,t.$dropdown.hide(),t.setActiveOption(null),t.refreshState(),e&&t.trigger("dropdown_close",t.$dropdown)},positionDropdown:function(){var t=this.$control,e="body"===this.settings.dropdownParent?t.offset():t.position(),t=(e.top+=t.outerHeight(!0),t[0].getBoundingClientRect().width);this.settings.minWidth&&this.settings.minWidth>t&&(t=this.settings.minWidth),this.$dropdown.css({width:t,top:e.top,left:e.left})},setupDropdownHeight:function(){if("object"==typeof this.settings.dropdownSize&&"auto"!==this.settings.dropdownSize.sizeType){var t=this.settings.dropdownSize.sizeValue;if("numberItems"===this.settings.dropdownSize.sizeType){for(var e=this.$dropdown_content.find("*").not(".optgroup, .highlight").not(this.settings.ignoreOnDropwdownHeight),n=0,i=0,o=0,s=0,r=0;r<t;r++){var a=$(e[r]);if(0===a.length)break;n+=a.outerHeight(!0),void 0===a.data("selectable")&&(a.hasClass("optgroup-header")&&(a=window.getComputedStyle(a.parent()[0],":before"))&&(i=a.marginTop?Number(a.marginTop.replace(/\W*(\w)\w*/g,"$1")):0,o=a.marginBottom?Number(a.marginBottom.replace(/\W*(\w)\w*/g,"$1")):0,s=a.borderTopWidth?Number(a.borderTopWidth.replace(/\W*(\w)\w*/g,"$1")):0),t++)}t=n+(this.$dropdown_content.css("padding-top")?Number(this.$dropdown_content.css("padding-top").replace(/\W*(\w)\w*/g,"$1")):0)+(this.$dropdown_content.css("padding-bottom")?Number(this.$dropdown_content.css("padding-bottom").replace(/\W*(\w)\w*/g,"$1")):0)+i+o+s+"px"}else if("fixedHeight"!==this.settings.dropdownSize.sizeType)return void console.warn('Selectize.js - Value of "sizeType" must be "fixedHeight" or "numberItems');this.$dropdown_content.css({height:t,maxHeight:"none"})}},clear:function(t){var e=this;e.items.length&&(e.$control.children(":not(input)").remove(),e.items=[],e.lastQuery=null,e.setCaret(0),e.setActiveItem(null),e.updatePlaceholder(),e.updateOriginalInput({silent:t}),e.refreshState(),e.showInput(),e.trigger("clear"))},insertAtCaret:function(t){var e=Math.min(this.caretPos,this.items.length),t=t[0],n=this.buffer||this.$control[0];0===e?n.insertBefore(t,n.firstChild):n.insertBefore(t,n.childNodes[e]),this.setCaret(e+1)},deleteSelection:function(t){var e,n,i,o,s,r=this,a=t&&t.keyCode===KEY_BACKSPACE?-1:1,l=getInputSelection(r.$control_input[0]);if(r.$activeOption&&!r.settings.hideSelected&&(o=("string"==typeof r.settings.deselectBehavior&&"top"===r.settings.deselectBehavior?r.getFirstOption():r.getAdjacentOption(r.$activeOption,-1)).attr("data-value")),i=[],r.$activeItems.length){for(s=r.$control.children(".active:"+(0<a?"last":"first")),s=r.$control.children(":not(input)").index(s),0<a&&s++,e=0,n=r.$activeItems.length;e<n;e++)i.push($(r.$activeItems[e]).attr("data-value"));t&&(t.preventDefault(),t.stopPropagation())}else(r.isFocused||"single"===r.settings.mode)&&r.items.length&&(a<0&&0===l.start&&0===l.length?i.push(r.items[r.caretPos-1]):0<a&&l.start===r.$control_input.val().length&&i.push(r.items[r.caretPos]));if(!i.length||"function"==typeof r.settings.onDelete&&!1===r.settings.onDelete.apply(r,[i]))return!1;for(void 0!==s&&r.setCaret(s);i.length;)r.removeItem(i.pop());return r.showInput(),r.positionDropdown(),r.refreshOptions(!0),o&&(t=r.getOption(o)).length&&r.setActiveOption(t),!0},advanceSelection:function(t,e){var n,i,o,s=this;0!==t&&(s.rtl&&(t*=-1),n=0<t?"last":"first",o=getInputSelection(s.$control_input[0]),s.isFocused&&!s.isInputHidden?(i=s.$control_input.val().length,(t<0?0!==o.start||0!==o.length:o.start!==i)||i||s.advanceCaret(t,e)):(o=s.$control.children(".active:"+n)).length&&(i=s.$control.children(":not(input)").index(o),s.setActiveItem(null),s.setCaret(0<t?i+1:i)))},advanceCaret:function(t,e){var n,i=this;0!==t&&(i.isShiftDown?(n=i.$control_input[0<t?"next":"prev"]()).length&&(i.hideInput(),i.setActiveItem(n),e)&&e.preventDefault():i.setCaret(i.caretPos+t))},setCaret:function(t){var e=this;if(t="single"===e.settings.mode?e.items.length:Math.max(0,Math.min(e.items.length,t)),!e.isPending)for(var n,i=e.$control.children(":not(input)"),o=0,s=i.length;o<s;o++)n=$(i[o]).detach(),o<t?e.$control_input.before(n):e.$control.append(n);e.caretPos=t},lock:function(){this.close(),this.isLocked=!0,this.refreshState()},unlock:function(){this.isLocked=!1,this.refreshState()},disable:function(){this.$input.prop("disabled",!0),this.$control_input.prop("disabled",!0).prop("tabindex",-1),this.isDisabled=!0,this.lock()},enable:function(){var t=this;t.$input.prop("disabled",!1),t.$control_input.prop("disabled",!1).prop("tabindex",t.tabIndex),t.isDisabled=!1,t.unlock()},destroy:function(){var t=this,e=t.eventNS,n=t.revertSettings;t.trigger("destroy"),t.off(),t.$wrapper.remove(),t.$dropdown.remove(),t.$input.html("").append(n.$children).removeAttr("tabindex").removeClass("selectized").attr({tabindex:n.tabindex}).show(),t.$control_input.removeData("grow"),t.$input.removeData("selectize"),0==--Selectize.count&&Selectize.$testInput&&(Selectize.$testInput.remove(),Selectize.$testInput=void 0),$(window).off(e),$(document).off(e),$(document.body).off(e),delete t.$input[0].selectize},render:function(t,e){var n,i,o="",s=!1,r=this;return(s="option"!==t&&"item"!==t?s:!!(n=hash_key(e[r.settings.valueField])))&&(isset(r.renderCache[t])||(r.renderCache[t]={}),r.renderCache[t].hasOwnProperty(n))?r.renderCache[t][n]:(o=$(r.settings.render[t].apply(this,[e,escape_html])),"option"===t||"option_create"===t?e[r.settings.disabledField]||o.attr("data-selectable",""):"optgroup"===t&&(i=e[r.settings.optgroupValueField]||"",o.attr("data-group",i),e[r.settings.disabledField])&&o.attr("data-disabled",""),"option"!==t&&"item"!==t||o.attr("data-value",n||""),s&&(r.renderCache[t][n]=o[0]),o[0])},clearCache:function(t){void 0===t?this.renderCache={}:delete this.renderCache[t]},canCreate:function(t){var e;return!!this.settings.create&&(e=this.settings.createFilter,t.length)&&("function"!=typeof e||e.apply(this,[t]))&&("string"!=typeof e||new RegExp(e).test(t))&&(!(e instanceof RegExp)||e.test(t))}}),Selectize.count=0,Selectize.defaults={options:[],optgroups:[],plugins:[],delimiter:",",splitOn:null,persist:!0,diacritics:!0,create:!1,showAddOptionOnCreate:!0,createOnBlur:!1,createFilter:null,highlight:!0,openOnFocus:!0,maxOptions:1e3,maxItems:null,hideSelected:null,addPrecedence:!1,selectOnTab:!0,preload:!1,allowEmptyOption:!1,showEmptyOptionInDropdown:!1,emptyOptionLabel:"--",setFirstOptionActive:!1,closeAfterSelect:!1,closeDropdownThreshold:250,scrollDuration:60,deselectBehavior:"previous",loadThrottle:300,loadingClass:"loading",dataAttr:"data-data",optgroupField:"optgroup",valueField:"value",labelField:"text",disabledField:"disabled",optgroupLabelField:"label",optgroupValueField:"value",lockOptgroupOrder:!1,sortField:"$order",searchField:["text"],searchConjunction:"and",respect_word_boundaries:!0,mode:null,wrapperClass:"",inputClass:"",dropdownClass:"",dropdownContentClass:"",dropdownParent:null,copyClassesToDropdown:!0,dropdownSize:{sizeType:"auto",sizeValue:"auto"},normalize:!1,ignoreOnDropwdownHeight:"img, i",search:!0,render:{}},$.fn.selectize=function(c){function d(t,o){function e(t,e){t=$(t);var n,i=hash_key(t.val());(i||v.allowEmptyOption)&&(l.hasOwnProperty(i)?e&&((n=l[i][O])?Array.isArray(n)?n.push(e):l[i][O]=[n,e]:l[i][O]=e):((n=p(t)||{})[y]=n[y]||t.text(),n[w]=n[w]||i,n[C]=n[C]||t.prop("disabled"),n[O]=n[O]||e,n.styles=t.attr("style")||"",n.classes=t.attr("class")||"",l[i]=n,a.push(n),t.is(":selected")&&o.items.push(i)))}var n,i,s,r,a=o.options,l={},p=function(t){var e=m&&t.attr(m),t=t.data(),n={};return"string"==typeof e&&e.length&&(isJSON(e)?Object.assign(n,JSON.parse(e)):n[e]=e),Object.assign(n,t),n||null};for(o.maxItems=t.attr("multiple")?null:1,n=0,i=(r=t.children()).length;n<i;n++)if("optgroup"===(s=r[n].tagName.toLowerCase())){g=h=u=d=c=void 0;var c,d,u,h,g,f=r[n];for((u=(f=$(f)).attr("label"))&&((h=p(f)||{})[_]=u,h[b]=u,h[C]=f.prop("disabled"),o.optgroups.push(h)),c=0,d=(g=$("option",f)).length;c<d;c++)e(g[c],u)}else"option"===s&&e(r[n])}var u=$.fn.selectize.defaults,v=$.extend({},u,c),m=v.dataAttr,y=v.labelField,w=v.valueField,C=v.disabledField,O=v.optgroupField,_=v.optgroupLabelField,b=v.optgroupValueField;return this.each(function(){if(!this.selectize){var t=$(this),e=this.tagName.toLowerCase(),n=t.attr("placeholder")||t.attr("data-placeholder"),i=(n||v.allowEmptyOption||(n=t.children('option[value=""]').text()),v.allowEmptyOption&&v.showEmptyOptionInDropdown&&!t.children('option[value=""]').length&&(l=t.html(),i=escape_html(v.emptyOptionLabel||"--"),t.html('<option value="">'+i+"</option>"+l)),{placeholder:n,options:[],optgroups:[],items:[]});if("select"===e)d(t,i);else{var o,s,r,a,l=t,p=i,n=l.attr(m);if(n)for(p.options=JSON.parse(n),o=0,s=p.options.length;o<s;o++)p.items.push(p.options[o][w]);else{n=(l.val()||"").trim();if(v.allowEmptyOption||n.length){for(o=0,s=(r=n.split(v.delimiter)).length;o<s;o++)(a={})[y]=r[o],a[w]=r[o],p.options.push(a);p.items=r}}}new Selectize(t,$.extend(!0,{},u,i,c)).settings_user=c}})},$.fn.selectize.defaults=Selectize.defaults,$.fn.selectize.support={validity:SUPPORTS_VALIDITY_API},Selectize.define("auto_position",function(){const o={top:"top",bottom:"bottom"};this.positionDropdown=function(){var t=this.$control,e="body"===this.settings.dropdownParent?t.offset():t.position(),n=(e.top+=t.outerHeight(!0),this.$dropdown.prop("scrollHeight")+5),n=this.$control.get(0).getBoundingClientRect().top+n+this.$wrapper.height()>window.innerHeight?o.top:o.bottom,i={width:t.outerWidth(),left:e.left};n===o.top?(n={bottom:e.top,top:"unset"},"body"===this.settings.dropdownParent&&(n.top=e.top-this.$dropdown.outerHeight(!0)-t.outerHeight(!0),n.bottom="unset"),Object.assign(i,n),this.$dropdown.addClass("selectize-position-top"),this.$control.addClass("selectize-position-top")):(Object.assign(i,{top:e.top,bottom:"unset"}),this.$dropdown.removeClass("selectize-position-top"),this.$control.removeClass("selectize-position-top")),this.$dropdown.css(i)}}),Selectize.define("auto_select_on_type",function(t){var n,i=this;i.onBlur=(n=i.onBlur,function(t){var e=i.getFirstItemMatchedByTextContent(i.lastValue,!0);return void 0!==e.attr("data-value")&&i.getValue()!==e.attr("data-value")&&i.setValue(e.attr("data-value")),n.apply(this,arguments)})}),Selectize.define("autofill_disable",function(t){var e,n=this;n.setup=(e=n.setup,function(){e.apply(n,arguments),n.$control_input.attr({autocomplete:"new-password",autofill:"no"})})}),Selectize.define("clear_button",function(e){var t,n=this;e=$.extend({title:"Clear",className:"clear",label:"×",html:function(t){return'<a class="'+t.className+'" title="'+t.title+'"> '+t.label+"</a>"}},e),n.setup=(t=n.setup,function(){t.apply(n,arguments),n.$button_clear=$(e.html(e)),"single"===n.settings.mode&&n.$wrapper.addClass("single"),n.$wrapper.append(n.$button_clear),""!==n.getValue()&&0!==n.getValue().length||n.$wrapper.find("."+e.className).css("display","none"),n.on("change",function(){""===n.getValue()||0===n.getValue().length?n.$wrapper.find("."+e.className).css("display","none"):n.$wrapper.find("."+e.className).css("display","")}),n.$wrapper.on("click","."+e.className,function(t){t.preventDefault(),t.stopImmediatePropagation(),t.stopPropagation(),n.isLocked||(n.clear(),n.$wrapper.find("."+e.className).css("display","none"))})})}),Selectize.define("drag_drop",function(t){if(!$.fn.sortable)throw new Error('The "drag_drop" plugin requires jQuery UI "sortable".');var i,e,n,o;"multi"===this.settings.mode&&((i=this).lock=(e=i.lock,function(){var t=i.$control.data("sortable");return t&&t.disable(),e.apply(i,arguments)}),i.unlock=(n=i.unlock,function(){var t=i.$control.data("sortable");return t&&t.enable(),n.apply(i,arguments)}),i.setup=(o=i.setup,function(){o.apply(this,arguments);var n=i.$control.sortable({items:"[data-value]",forcePlaceholderSize:!0,disabled:i.isLocked,start:function(t,e){e.placeholder.css("width",e.helper.css("width")),n.addClass("dragging")},stop:function(){n.removeClass("dragging");var t=i.$activeItems?i.$activeItems.slice():null,e=[];n.children("[data-value]").each(function(){e.push($(this).attr("data-value"))}),i.isFocused=!1,i.setValue(e),i.isFocused=!0,i.setActiveItem(t),i.positionDropdown()}})}))}),Selectize.define("dropdown_header",function(t){var e,n=this;t=$.extend({title:"Untitled",headerClass:"selectize-dropdown-header",titleRowClass:"selectize-dropdown-header-title",labelClass:"selectize-dropdown-header-label",closeClass:"selectize-dropdown-header-close",html:function(t){return'<div class="'+t.headerClass+'"><div class="'+t.titleRowClass+'"><span class="'+t.labelClass+'">'+t.title+'</span><a href="javascript:void(0)" class="'+t.closeClass+'">&#xd7;</a></div></div>'}},t),n.setup=(e=n.setup,function(){e.apply(n,arguments),n.$dropdown_header=$(t.html(t)),n.$dropdown.prepend(n.$dropdown_header),n.$dropdown_header.find("."+t.closeClass).on("click",function(){n.close()})})}),Selectize.define("optgroup_columns",function(r){function t(){var t,e,n,i,o=$("[data-group]",a.$dropdown_content),s=o.length;if(s&&a.$dropdown_content.width()){if(r.equalizeHeight){for(t=e=0;t<s;t++)e=Math.max(e,o.eq(t).height());o.css({height:e})}r.equalizeWidth&&(i=a.$dropdown_content.innerWidth()-l(),n=Math.round(i/s),o.css({width:n}),1<s)&&(i=i-n*(s-1),o.eq(s-1).css({width:i}))}}var i,a=this,l=(r=$.extend({equalizeWidth:!0,equalizeHeight:!0},r),this.getAdjacentOption=function(t,e){var n=t.closest("[data-group]").find("[data-selectable]"),t=n.index(t)+e;return 0<=t&&t<n.length?n.eq(t):$()},this.onKeyDown=(i=a.onKeyDown,function(t){var e,n;if(!this.isOpen||t.keyCode!==KEY_LEFT&&t.keyCode!==KEY_RIGHT)return i.apply(this,arguments);a.ignoreHover=!0,e=(n=this.$activeOption.closest("[data-group]")).find("[data-selectable]").index(this.$activeOption),(n=(n=(n=t.keyCode===KEY_LEFT?n.prev("[data-group]"):n.next("[data-group]")).find("[data-selectable]")).eq(Math.min(n.length-1,e))).length&&this.setActiveOption(n)}),function(){var t,e=l.width,n=document;return void 0===e&&((t=n.createElement("div")).innerHTML='<div style="width:50px;height:50px;position:absolute;left:-50px;top:-50px;overflow:auto;"><div style="width:1px;height:100px;"></div></div>',t=t.firstChild,n.body.appendChild(t),e=l.width=t.offsetWidth-t.clientWidth,n.body.removeChild(t)),e});(r.equalizeHeight||r.equalizeWidth)&&(hook.after(this,"positionDropdown",t),hook.after(this,"refreshOptions",t))}),Selectize.define("remove_button",function(t){var s,e,n,i,r;"single"!==this.settings.mode&&(t=$.extend({label:"&#xd7;",title:"Remove",className:"remove",append:!0},t),i=s=this,r='<a href="javascript:void(0)" class="'+(e=t).className+'" tabindex="-1" title="'+escape_html(e.title)+'">'+e.label+"</a>",s.setup=(n=i.setup,function(){var o;e.append&&(o=i.settings.render.item,i.settings.render.item=function(t){return e=o.apply(s,arguments),n=r,i=e.search(/(<\/[^>]+>\s*)$/),e.substring(0,i)+n+e.substring(i);var e,n,i}),n.apply(s,arguments),s.$control.on("click","."+e.className,function(t){if(t.preventDefault(),!i.isLocked)return t=$(t.currentTarget).parent(),i.setActiveItem(t),i.deleteSelection()&&i.setCaret(i.items.length),!1})}))}),Selectize.define("restore_on_backspace",function(n){var i,t=this;n.text=n.text||function(t){return t[this.settings.labelField]},this.onKeyDown=(i=t.onKeyDown,function(t){var e;if(!(t.keyCode===KEY_BACKSPACE&&""===this.$control_input.val()&&!this.$activeItems.length&&0<=(e=this.caretPos-1)&&e<this.items.length))return i.apply(this,arguments);e=this.options[this.items[e]],this.deleteSelection(t)&&(this.setTextboxValue(n.text.apply(this,[e])),this.refreshOptions(!0)),t.preventDefault()})}),Selectize.define("select_on_focus",function(t){var n,e,i=this;i.on("focus",(n=i.onFocus,function(t){var e=i.getItem(i.getValue()).text();return i.clear(),i.setTextboxValue(e),i.$control_input.select(),setTimeout(function(){i.settings.selectOnTab&&i.setActiveOption(i.getFirstItemMatchedByTextContent(e)),i.settings.score=null},0),n.apply(this,arguments)})),i.onBlur=(e=i.onBlur,function(t){return""===i.getValue()&&i.lastValidValue!==i.getValue()&&i.setValue(i.lastValidValue),setTimeout(function(){i.settings.score=function(){return function(){return 1}}},0),e.apply(this,arguments)}),i.settings.score=function(){return function(){return 1}}}),Selectize.define("tag_limit",function(o){const t=this;o.tagLimit=o.tagLimit,this.onBlur=function(){const i=t.onBlur;return function(t){if(i.apply(this,t),t){var t=this.$control,e=t.find(".item");const n=o.tagLimit;void 0===n||e.length<=n||(e.toArray().forEach(function(t,e){e<n||$(t).hide()}),t.append("<span><b>"+(e.length-n)+"</b></span>"))}}}(),this.onFocus=function(){const e=t.onFocus;return function(t){e.apply(this,t),t&&((t=this.$control).find(".item").show(),t.find("span").remove())}}()});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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

  return Selectize;
}));
