/* global define, jQuery */
(function (factory) {
    if (typeof define === 'function' && define.amd) {
      define(['jquery'], factory)
    } else if (typeof module === 'object' && module.exports) {
      module.exports = factory(require('jquery'))
    } else {
      // Browser globals
      factory(jQuery || window.django.jQuery)
    }
  }(function ($) {
    'use strict'
    var init = function ($element, options) {
      $element.selectize(options)
    }
  
    var initHeavy = function ($element, options) {
      var settings = $.extend({
        ajax: {
          data: function (params) {
            var result = {
              term: params.term,
              page: params.page,
              field_id: $element.data('field_id')
            }
  
            var dependentFields = $element.data('selectize-dependent-fields')
            if (dependentFields) {
              dependentFields = dependentFields.trim().split(/\s+/)
              $.each(dependentFields, function (i, dependentField) {
                result[dependentField] = $('[name=' + dependentField + ']', $element.closest('form')).val()
              })
            }
  
            return result
          },
          processResults: function (data, page) {
            return {
              results: data.results,
              pagination: {
                more: data.more
              }
            }
          }
        }
      }, options)
  
      $element.selectize(settings)
    }
  
    $.fn.djangoselectize = function (options) {
      var settings = $.extend({}, options)
      $.each(this, function (i, element) {
        var $element = $(element)
        if ($element.hasClass('django-selectize-heavy')) {
          initHeavy($element, settings)
        } else {
          init($element, settings)
        }
        $element.on('selectize:select', function (e) {
          var name = $(e.currentTarget).attr('name')
          $('[data-selectize-dependent-fields~=' + name + ']').each(function () {
            $(this).val('').trigger('change')
          })
        })
      })
      return this
    }
  
    $(function () {
      $('.django-selectize').djangoselectize()
    })
  
    return $.fn.djangoselectize
  }))
  