# pulp_cookbook-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.1.0b9
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_cookbook
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_cookbook
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_cookbook
from pulpcore.client.pulp_cookbook.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_cookbook.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_cookbook.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_cookbook.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_cookbook.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_cookbook.ContentCookbooksApi(api_client)
    name = 'name_example' # str | name of the cookbook
artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
file = '/path/to/file' # file | An uploaded file that may be turned into the artifact of the content unit. (optional)
repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
version = 'version_example' # str | version of the cookbook (optional)

    try:
        # Create a cookbook package content
        api_response = api_instance.create(name, artifact=artifact, file=file, repository=repository, version=version)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentCookbooksApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentCookbooksApi* | [**create**](docs/ContentCookbooksApi.md#create) | **POST** /pulp/api/v3/content/cookbook/cookbooks/ | Create a cookbook package content
*ContentCookbooksApi* | [**list**](docs/ContentCookbooksApi.md#list) | **GET** /pulp/api/v3/content/cookbook/cookbooks/ | List cookbook package contents
*ContentCookbooksApi* | [**read**](docs/ContentCookbooksApi.md#read) | **GET** {cookbook_cookbook_package_content_href} | Inspect a cookbook package content
*DistributionsCookbookApi* | [**create**](docs/DistributionsCookbookApi.md#create) | **POST** /pulp/api/v3/distributions/cookbook/cookbook/ | Create a cookbook distribution
*DistributionsCookbookApi* | [**delete**](docs/DistributionsCookbookApi.md#delete) | **DELETE** {cookbook_cookbook_distribution_href} | Delete a cookbook distribution
*DistributionsCookbookApi* | [**list**](docs/DistributionsCookbookApi.md#list) | **GET** /pulp/api/v3/distributions/cookbook/cookbook/ | List cookbook distributions
*DistributionsCookbookApi* | [**partial_update**](docs/DistributionsCookbookApi.md#partial_update) | **PATCH** {cookbook_cookbook_distribution_href} | Update a cookbook distribution
*DistributionsCookbookApi* | [**read**](docs/DistributionsCookbookApi.md#read) | **GET** {cookbook_cookbook_distribution_href} | Inspect a cookbook distribution
*DistributionsCookbookApi* | [**update**](docs/DistributionsCookbookApi.md#update) | **PUT** {cookbook_cookbook_distribution_href} | Update a cookbook distribution
*PublicationsCookbookApi* | [**create**](docs/PublicationsCookbookApi.md#create) | **POST** /pulp/api/v3/publications/cookbook/cookbook/ | Create a cookbook publication
*PublicationsCookbookApi* | [**delete**](docs/PublicationsCookbookApi.md#delete) | **DELETE** {cookbook_cookbook_publication_href} | Delete a cookbook publication
*PublicationsCookbookApi* | [**list**](docs/PublicationsCookbookApi.md#list) | **GET** /pulp/api/v3/publications/cookbook/cookbook/ | List cookbook publications
*PublicationsCookbookApi* | [**read**](docs/PublicationsCookbookApi.md#read) | **GET** {cookbook_cookbook_publication_href} | Inspect a cookbook publication
*RemotesCookbookApi* | [**create**](docs/RemotesCookbookApi.md#create) | **POST** /pulp/api/v3/remotes/cookbook/cookbook/ | Create a cookbook remote
*RemotesCookbookApi* | [**delete**](docs/RemotesCookbookApi.md#delete) | **DELETE** {cookbook_cookbook_remote_href} | Delete a cookbook remote
*RemotesCookbookApi* | [**list**](docs/RemotesCookbookApi.md#list) | **GET** /pulp/api/v3/remotes/cookbook/cookbook/ | List cookbook remotes
*RemotesCookbookApi* | [**partial_update**](docs/RemotesCookbookApi.md#partial_update) | **PATCH** {cookbook_cookbook_remote_href} | Update a cookbook remote
*RemotesCookbookApi* | [**read**](docs/RemotesCookbookApi.md#read) | **GET** {cookbook_cookbook_remote_href} | Inspect a cookbook remote
*RemotesCookbookApi* | [**update**](docs/RemotesCookbookApi.md#update) | **PUT** {cookbook_cookbook_remote_href} | Update a cookbook remote
*RepositoriesCookbookApi* | [**create**](docs/RepositoriesCookbookApi.md#create) | **POST** /pulp/api/v3/repositories/cookbook/cookbook/ | Create a cookbook repository
*RepositoriesCookbookApi* | [**delete**](docs/RepositoriesCookbookApi.md#delete) | **DELETE** {cookbook_cookbook_repository_href} | Delete a cookbook repository
*RepositoriesCookbookApi* | [**list**](docs/RepositoriesCookbookApi.md#list) | **GET** /pulp/api/v3/repositories/cookbook/cookbook/ | List cookbook repositorys
*RepositoriesCookbookApi* | [**modify**](docs/RepositoriesCookbookApi.md#modify) | **POST** {cookbook_cookbook_repository_href}modify/ | Modify Repository Content
*RepositoriesCookbookApi* | [**partial_update**](docs/RepositoriesCookbookApi.md#partial_update) | **PATCH** {cookbook_cookbook_repository_href} | Update a cookbook repository
*RepositoriesCookbookApi* | [**read**](docs/RepositoriesCookbookApi.md#read) | **GET** {cookbook_cookbook_repository_href} | Inspect a cookbook repository
*RepositoriesCookbookApi* | [**sync**](docs/RepositoriesCookbookApi.md#sync) | **POST** {cookbook_cookbook_repository_href}sync/ | 
*RepositoriesCookbookApi* | [**update**](docs/RepositoriesCookbookApi.md#update) | **PUT** {cookbook_cookbook_repository_href} | Update a cookbook repository
*RepositoriesCookbookVersionsApi* | [**delete**](docs/RepositoriesCookbookVersionsApi.md#delete) | **DELETE** {cookbook_cookbook_repository_version_href} | Delete a repository version
*RepositoriesCookbookVersionsApi* | [**list**](docs/RepositoriesCookbookVersionsApi.md#list) | **GET** {cookbook_cookbook_repository_href}versions/ | List repository versions
*RepositoriesCookbookVersionsApi* | [**read**](docs/RepositoriesCookbookVersionsApi.md#read) | **GET** {cookbook_cookbook_repository_version_href} | Inspect a repository version
*RepositoriesCookbookVersionsApi* | [**repair**](docs/RepositoriesCookbookVersionsApi.md#repair) | **POST** {cookbook_cookbook_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [CookbookCookbookDistribution](docs/CookbookCookbookDistribution.md)
 - [CookbookCookbookDistributionResponse](docs/CookbookCookbookDistributionResponse.md)
 - [CookbookCookbookPackageContent](docs/CookbookCookbookPackageContent.md)
 - [CookbookCookbookPackageContentResponse](docs/CookbookCookbookPackageContentResponse.md)
 - [CookbookCookbookPublication](docs/CookbookCookbookPublication.md)
 - [CookbookCookbookPublicationResponse](docs/CookbookCookbookPublicationResponse.md)
 - [CookbookCookbookRemote](docs/CookbookCookbookRemote.md)
 - [CookbookCookbookRemoteResponse](docs/CookbookCookbookRemoteResponse.md)
 - [CookbookCookbookRepository](docs/CookbookCookbookRepository.md)
 - [CookbookCookbookRepositoryResponse](docs/CookbookCookbookRepositoryResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedcookbookCookbookDistributionResponseList](docs/PaginatedcookbookCookbookDistributionResponseList.md)
 - [PaginatedcookbookCookbookPackageContentResponseList](docs/PaginatedcookbookCookbookPackageContentResponseList.md)
 - [PaginatedcookbookCookbookPublicationResponseList](docs/PaginatedcookbookCookbookPublicationResponseList.md)
 - [PaginatedcookbookCookbookRemoteResponseList](docs/PaginatedcookbookCookbookRemoteResponseList.md)
 - [PaginatedcookbookCookbookRepositoryResponseList](docs/PaginatedcookbookCookbookRepositoryResponseList.md)
 - [PatchedcookbookCookbookDistribution](docs/PatchedcookbookCookbookDistribution.md)
 - [PatchedcookbookCookbookRemote](docs/PatchedcookbookCookbookRemote.md)
 - [PatchedcookbookCookbookRepository](docs/PatchedcookbookCookbookRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


