"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3PutObjectAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const case_1 = require("case");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon S3 bucket.
 */
class S3PutObjectAction {
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_S3PutObjectActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3PutObjectAction);
            }
            throw error;
        }
        this.accessControl = props.accessControl;
        this.key = props.key;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            resources: [this.bucket.arnForObjects('*')],
        }));
        return {
            configuration: {
                s3: {
                    bucketName: this.bucket.bucketName,
                    cannedAcl: this.accessControl && (0, case_1.kebab)(this.accessControl.toString()),
                    key: this.key ?? '${topic()}/${timestamp()}',
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
S3PutObjectAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.S3PutObjectAction", version: "2.73.0-alpha.0" };
exports.S3PutObjectAction = S3PutObjectAction;
//# sourceMappingURL=data:application/json;base64,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