"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        this.func.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.73.0-alpha.0" };
exports.LambdaFunctionAction = LambdaFunctionAction;
//# sourceMappingURL=data:application/json;base64,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