"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the Kinesis Data stream.
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_KinesisPutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisPutRecordAction);
            }
            throw error;
        }
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.KinesisPutRecordAction", version: "2.73.0-alpha.0" };
exports.KinesisPutRecordAction = KinesisPutRecordAction;
//# sourceMappingURL=data:application/json;base64,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