"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchSetAlarmStateAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        const role = this.props.role ?? (0, role_1.singletonActionRole)(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: this.props.reason ?? `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchSetAlarmStateAction", version: "2.73.0-alpha.0" };
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
//# sourceMappingURL=data:application/json;base64,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