"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchPutMetricAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const role_1 = require("./private/role");
/**
 * The action to capture an Amazon CloudWatch metric.
 */
class CloudWatchPutMetricAction {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchPutMetricActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchPutMetricAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.props.role ?? (0, role_1.singletonActionRole)(rule);
        cloudwatch.Metric.grantPutMetricData(role);
        return {
            configuration: {
                cloudwatchMetric: {
                    metricName: this.props.metricName,
                    metricNamespace: this.props.metricNamespace,
                    metricTimestamp: this.props.metricTimestamp,
                    metricUnit: this.props.metricUnit,
                    metricValue: this.props.metricValue,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CloudWatchPutMetricAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchPutMetricAction", version: "2.73.0-alpha.0" };
exports.CloudWatchPutMetricAction = CloudWatchPutMetricAction;
//# sourceMappingURL=data:application/json;base64,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