from enum import Enum
from typing import List

from pyfinviz.utils import WebScraper


class Screener:
    class ScreenerFilterOption:
        ALL = ""

    class ExchangeOption(ScreenerFilterOption, Enum):
        AMEX = "exch_amex"
        NASDAQ = "exch_nasd"
        NYSE = "exch_nyse"
        CUSTOM_ELITE_ONLY = "exch_modal"

    class IndexOption(ScreenerFilterOption, Enum):
        SANDP_500 = "idx_sp500"
        DJIA = "idx_dji"

    class SectorOption(ScreenerFilterOption, Enum):
        BASIC_MATERIALS = "sec_basicmaterials"
        COMMUNICATION_SERVICES = "sec_communicationservices"
        CONSUMER_CYCLICAL = "sec_consumercyclical"
        CONSUMER_DEFENSIVE = "sec_consumerdefensive"
        ENERGY = "sec_energy"
        FINANCIAL = "sec_financial"
        HEALTHCARE = "sec_healthcare"
        INDUSTRIALS = "sec_industrials"
        REAL_ESTATE = "sec_realestate"
        TECHNOLOGY = "sec_technology"
        UTILITIES = "sec_utilities"
        CUSTOM_ELITE_ONLY = "sec_modal"

    class IndustryOption(ScreenerFilterOption, Enum):
        STOCKS_ONLY_EX_FUNDS = "ind_stocksonly"
        EXCHANGE_TRADED_FUND = "ind_exchangetradedfund"
        ADVERTISING_AGENCIES = "ind_advertisingagencies"
        AEROSPACE_AND_DEFENSE = "ind_aerospacedefense"
        AGRICULTURAL_INPUTS = "ind_agriculturalinputs"
        AIRLINES = "ind_airlines"
        AIRPORTS_AND_AIR_SERVICES = "ind_airportsairservices"
        ALUMINUM = "ind_aluminum"
        APPAREL_MANUFACTURING = "ind_apparelmanufacturing"
        APPAREL_RETAIL = "ind_apparelretail"
        ASSET_MANAGEMENT = "ind_assetmanagement"
        AUTO_MANUFACTURERS = "ind_automanufacturers"
        AUTO_PARTS = "ind_autoparts"
        AUTO_AND_TRUCK_DEALERSHIPS = "ind_autotruckdealerships"
        BANKS_DIVERSIFIED = "ind_banksdiversified"
        BANKS_REGIONAL = "ind_banksregional"
        BEVERAGES_BREWERS = "ind_beveragesbrewers"
        BEVERAGES_NON_ALCOHOLIC = "ind_beveragesnonalcoholic"
        BEVERAGES_WINERIES_AND_DISTILLERIES = "ind_beverageswineriesdistilleries"
        BIOTECHNOLOGY = "ind_biotechnology"
        BROADCASTING = "ind_broadcasting"
        BUILDING_MATERIALS = "ind_buildingmaterials"
        BUILDING_PRODUCTS_AND_EQUIPMENT = "ind_buildingproductsequipment"
        BUSINESS_EQUIPMENT_AND_SUPPLIES = "ind_businessequipmentsupplies"
        CAPITAL_MARKETS = "ind_capitalmarkets"
        CHEMICALS = "ind_chemicals"
        CLOSED_END_FUND_DEBT = "ind_closedendfunddebt"
        CLOSED_END_FUND_EQUITY = "ind_closedendfundequity"
        CLOSED_END_FUND_FOREIGN = "ind_closedendfundforeign"
        COKING_COAL = "ind_cokingcoal"
        COMMUNICATION_EQUIPMENT = "ind_communicationequipment"
        COMPUTER_HARDWARE = "ind_computerhardware"
        CONFECTIONERS = "ind_confectioners"
        CONGLOMERATES = "ind_conglomerates"
        CONSULTING_SERVICES = "ind_consultingservices"
        CONSUMER_ELECTRONICS = "ind_consumerelectronics"
        COPPER = "ind_copper"
        CREDIT_SERVICES = "ind_creditservices"
        DEPARTMENT_STORES = "ind_departmentstores"
        DIAGNOSTICS_AND_RESEARCH = "ind_diagnosticsresearch"
        DISCOUNT_STORES = "ind_discountstores"
        DRUG_MANUFACTURERS_GENERAL = "ind_drugmanufacturersgeneral"
        DRUG_MANUFACTURERS_SPECIALTY_AND_GENERIC = "ind_drugmanufacturersspecialtygeneric"
        EDUCATION_AND_TRAINING_SERVICES = "ind_educationtrainingservices"
        ELECTRICAL_EQUIPMENT_AND_PARTS = "ind_electricalequipmentparts"
        ELECTRONIC_COMPONENTS = "ind_electroniccomponents"
        ELECTRONIC_GAMING_AND_MULTIMEDIA = "ind_electronicgamingmultimedia"
        ELECTRONICS_AND_COMPUTER_DISTRIBUTION = "ind_electronicscomputerdistribution"
        ENGINEERING_AND_CONSTRUCTION = "ind_engineeringconstruction"
        ENTERTAINMENT = "ind_entertainment"
        FARM_AND_HEAVY_CONSTRUCTION_MACHINERY = "ind_farmheavyconstructionmachinery"
        FARM_PRODUCTS = "ind_farmproducts"
        FINANCIAL_CONGLOMERATES = "ind_financialconglomerates"
        FINANCIAL_DATA_AND_STOCK_EXCHANGES = "ind_financialdatastockexchanges"
        FOOD_DISTRIBUTION = "ind_fooddistribution"
        FOOTWEAR_AND_ACCESSORIES = "ind_footwearaccessories"
        FURNISHINGS_FIXTURES_AND_APPLIANCES = "ind_furnishingsfixturesappliances"
        GAMBLING = "ind_gambling"
        GOLD = "ind_gold"
        GROCERY_STORES = "ind_grocerystores"
        HEALTHCARE_PLANS = "ind_healthcareplans"
        HEALTH_INFORMATION_SERVICES = "ind_healthinformationservices"
        HOME_IMPROVEMENT_RETAIL = "ind_homeimprovementretail"
        HOUSEHOLD_AND_PERSONAL_PRODUCTS = "ind_householdpersonalproducts"
        INDUSTRIAL_DISTRIBUTION = "ind_industrialdistribution"
        INFORMATION_TECHNOLOGY_SERVICES = "ind_informationtechnologyservices"
        INFRASTRUCTURE_OPERATIONS = "ind_infrastructureoperations"
        INSURANCE_BROKERS = "ind_insurancebrokers"
        INSURANCE_DIVERSIFIED = "ind_insurancediversified"
        INSURANCE_LIFE = "ind_insurancelife"
        INSURANCE_PROPERTY_AND_CASUALTY = "ind_insurancepropertycasualty"
        INSURANCE_REINSURANCE = "ind_insurancereinsurance"
        INSURANCE_SPECIALTY = "ind_insurancespecialty"
        INTEGRATED_FREIGHT_AND_LOGISTICS = "ind_integratedfreightlogistics"
        INTERNET_CONTENT_AND_INFORMATION = "ind_internetcontentinformation"
        INTERNET_RETAIL = "ind_internetretail"
        LEISURE = "ind_leisure"
        LODGING = "ind_lodging"
        LUMBER_AND_WOOD_PRODUCTION = "ind_lumberwoodproduction"
        LUXURY_GOODS = "ind_luxurygoods"
        MARINE_SHIPPING = "ind_marineshipping"
        MEDICAL_CARE_FACILITIES = "ind_medicalcarefacilities"
        MEDICAL_DEVICES = "ind_medicaldevices"
        MEDICAL_DISTRIBUTION = "ind_medicaldistribution"
        MEDICAL_INSTRUMENTS_AND_SUPPLIES = "ind_medicalinstrumentssupplies"
        METAL_FABRICATION = "ind_metalfabrication"
        MORTGAGE_FINANCE = "ind_mortgagefinance"
        OIL_AND_GAS_DRILLING = "ind_oilgasdrilling"
        OIL_AND_GAS_EANDP = "ind_oilgasep"
        OIL_AND_GAS_EQUIPMENT_AND_SERVICES = "ind_oilgasequipmentservices"
        OIL_AND_GAS_INTEGRATED = "ind_oilgasintegrated"
        OIL_AND_GAS_MIDSTREAM = "ind_oilgasmidstream"
        OIL_AND_GAS_REFINING_AND_MARKETING = "ind_oilgasrefiningmarketing"
        OTHER_INDUSTRIAL_METALS_AND_MINING = "ind_otherindustrialmetalsmining"
        OTHER_PRECIOUS_METALS_AND_MINING = "ind_otherpreciousmetalsmining"
        PACKAGED_FOODS = "ind_packagedfoods"
        PACKAGING_AND_CONTAINERS = "ind_packagingcontainers"
        PAPER_AND_PAPER_PRODUCTS = "ind_paperpaperproducts"
        PERSONAL_SERVICES = "ind_personalservices"
        PHARMACEUTICAL_RETAILERS = "ind_pharmaceuticalretailers"
        POLLUTION_AND_TREATMENT_CONTROLS = "ind_pollutiontreatmentcontrols"
        PUBLISHING = "ind_publishing"
        RAILROADS = "ind_railroads"
        REAL_ESTATE_DEVELOPMENT = "ind_realestatedevelopment"
        REAL_ESTATE_DIVERSIFIED = "ind_realestatediversified"
        REAL_ESTATE_SERVICES = "ind_realestateservices"
        RECREATIONAL_VEHICLES = "ind_recreationalvehicles"
        REIT_DIVERSIFIED = "ind_reitdiversified"
        REIT_HEALTHCARE_FACILITIES = "ind_reithealthcarefacilities"
        REIT_HOTEL_AND_MOTEL = "ind_reithotelmotel"
        REIT_INDUSTRIAL = "ind_reitindustrial"
        REIT_MORTGAGE = "ind_reitmortgage"
        REIT_OFFICE = "ind_reitoffice"
        REIT_RESIDENTIAL = "ind_reitresidential"
        REIT_RETAIL = "ind_reitretail"
        REIT_SPECIALTY = "ind_reitspecialty"
        RENTAL_AND_LEASING_SERVICES = "ind_rentalleasingservices"
        RESIDENTIAL_CONSTRUCTION = "ind_residentialconstruction"
        RESORTS_AND_CASINOS = "ind_resortscasinos"
        RESTAURANTS = "ind_restaurants"
        SCIENTIFIC_AND_TECHNICAL_INSTRUMENTS = "ind_scientifictechnicalinstruments"
        SECURITY_AND_PROTECTION_SERVICES = "ind_securityprotectionservices"
        SEMICONDUCTOR_EQUIPMENT_AND_MATERIALS = "ind_semiconductorequipmentmaterials"
        SEMICONDUCTORS = "ind_semiconductors"
        SHELL_COMPANIES = "ind_shellcompanies"
        SILVER = "ind_silver"
        SOFTWARE_APPLICATION = "ind_softwareapplication"
        SOFTWARE_INFRASTRUCTURE = "ind_softwareinfrastructure"
        SOLAR = "ind_solar"
        SPECIALTY_BUSINESS_SERVICES = "ind_specialtybusinessservices"
        SPECIALTY_CHEMICALS = "ind_specialtychemicals"
        SPECIALTY_INDUSTRIAL_MACHINERY = "ind_specialtyindustrialmachinery"
        SPECIALTY_RETAIL = "ind_specialtyretail"
        STAFFING_AND_EMPLOYMENT_SERVICES = "ind_staffingemploymentservices"
        STEEL = "ind_steel"
        TELECOM_SERVICES = "ind_telecomservices"
        TEXTILE_MANUFACTURING = "ind_textilemanufacturing"
        THERMAL_COAL = "ind_thermalcoal"
        TOBACCO = "ind_tobacco"
        TOOLS_AND_ACCESSORIES = "ind_toolsaccessories"
        TRAVEL_SERVICES = "ind_travelservices"
        TRUCKING = "ind_trucking"
        URANIUM = "ind_uranium"
        UTILITIES_DIVERSIFIED = "ind_utilitiesdiversified"
        UTILITIES_INDEPENDENT_POWER_PRODUCERS = "ind_utilitiesindependentpowerproducers"
        UTILITIES_REGULATED_ELECTRIC = "ind_utilitiesregulatedelectric"
        UTILITIES_REGULATED_GAS = "ind_utilitiesregulatedgas"
        UTILITIES_REGULATED_WATER = "ind_utilitiesregulatedwater"
        UTILITIES_RENEWABLE = "ind_utilitiesrenewable"
        WASTE_MANAGEMENT = "ind_wastemanagement"
        CUSTOM_ELITE_ONLY = "ind_modal"

    class CountryOption(ScreenerFilterOption, Enum):
        USA = "geo_usa"
        FOREIGN_EX_USA = "geo_notusa"
        ASIA = "geo_asia"
        EUROPE = "geo_europe"
        LATIN_AMERICA = "geo_latinamerica"
        BRIC = "geo_bric"
        ARGENTINA = "geo_argentina"
        AUSTRALIA = "geo_australia"
        BAHAMAS = "geo_bahamas"
        BELGIUM = "geo_belgium"
        BENELUX = "geo_benelux"
        BERMUDA = "geo_bermuda"
        BRAZIL = "geo_brazil"
        CANADA = "geo_canada"
        CAYMAN_ISLANDS = "geo_caymanislands"
        CHILE = "geo_chile"
        CHINA = "geo_china"
        CHINA_AND_HONG_KONG = "geo_chinahongkong"
        COLOMBIA = "geo_colombia"
        CYPRUS = "geo_cyprus"
        DENMARK = "geo_denmark"
        FINLAND = "geo_finland"
        FRANCE = "geo_france"
        GERMANY = "geo_germany"
        GREECE = "geo_greece"
        HONG_KONG = "geo_hongkong"
        HUNGARY = "geo_hungary"
        ICELAND = "geo_iceland"
        INDIA = "geo_india"
        INDONESIA = "geo_indonesia"
        IRELAND = "geo_ireland"
        ISRAEL = "geo_israel"
        ITALY = "geo_italy"
        JAPAN = "geo_japan"
        KAZAKHSTAN = "geo_kazakhstan"
        LUXEMBOURG = "geo_luxembourg"
        MALAYSIA = "geo_malaysia"
        MALTA = "geo_malta"
        MEXICO = "geo_mexico"
        MONACO = "geo_monaco"
        NETHERLANDS = "geo_netherlands"
        NEW_ZEALAND = "geo_newzealand"
        NORWAY = "geo_norway"
        PANAMA = "geo_panama"
        PERU = "geo_peru"
        PHILIPPINES = "geo_philippines"
        PORTUGAL = "geo_portugal"
        RUSSIA = "geo_russia"
        SINGAPORE = "geo_singapore"
        SOUTH_AFRICA = "geo_southafrica"
        SOUTH_KOREA = "geo_southkorea"
        SPAIN = "geo_spain"
        SWEDEN = "geo_sweden"
        SWITZERLAND = "geo_switzerland"
        TAIWAN = "geo_taiwan"
        TURKEY = "geo_turkey"
        UNITED_ARAB_EMIRATES = "geo_unitedarabemirates"
        UNITED_KINGDOM = "geo_unitedkingdom"
        URUGUAY = "geo_uruguay"
        CUSTOM_ELITE_ONLY = "geo_modal"

    class MarketCapOption(ScreenerFilterOption, Enum):
        MEGA_USD200BLN_AND_MORE = "cap_mega"
        LARGE_USD10BLN_TO_200BLN = "cap_large"
        MID_USD2BLN_TO_10BLN = "cap_mid"
        SMALL_USD300MLN_TO_2BLN = "cap_small"
        MICRO_USD50MLN_TO_300MLN = "cap_micro"
        NANO_UNDER_USD50MLN = "cap_nano"
        LARGE_OVER_USD10BLN = "cap_largeover"
        MID_OVER_USD2BLN = "cap_midover"
        SMALL_OVER_USD300MLN = "cap_smallover"
        MICRO_OVER_USD50MLN = "cap_microover"
        LARGE_UNDER_USD200BLN = "cap_largeunder"
        MID_UNDER_USD10BLN = "cap_midunder"
        SMALL_UNDER_USD2BLN = "cap_smallunder"
        MICRO_UNDER_USD300MLN = "cap_microunder"
        CUSTOM_ELITE_ONLY = "cap_frange"

    class PEOption(ScreenerFilterOption, Enum):
        LOW_15 = "fa_pe_low"
        PROFITABLE_0 = "fa_pe_profitable"
        HIGH_50 = "fa_pe_high"
        UNDER_5 = "fa_pe_u5"
        UNDER_10 = "fa_pe_u10"
        UNDER_15 = "fa_pe_u15"
        UNDER_20 = "fa_pe_u20"
        UNDER_25 = "fa_pe_u25"
        UNDER_30 = "fa_pe_u30"
        UNDER_35 = "fa_pe_u35"
        UNDER_40 = "fa_pe_u40"
        UNDER_45 = "fa_pe_u45"
        UNDER_50 = "fa_pe_u50"
        OVER_5 = "fa_pe_o5"
        OVER_10 = "fa_pe_o10"
        OVER_15 = "fa_pe_o15"
        OVER_20 = "fa_pe_o20"
        OVER_25 = "fa_pe_o25"
        OVER_30 = "fa_pe_o30"
        OVER_35 = "fa_pe_o35"
        OVER_40 = "fa_pe_o40"
        OVER_45 = "fa_pe_o45"
        OVER_50 = "fa_pe_o50"
        CUSTOM_ELITE_ONLY = "fa_pe_range"

    class ForwardPEOption(ScreenerFilterOption, Enum):
        LOW_15 = "fa_fpe_low"
        PROFITABLE_0 = "fa_fpe_profitable"
        HIGH_50 = "fa_fpe_high"
        UNDER_5 = "fa_fpe_u5"
        UNDER_10 = "fa_fpe_u10"
        UNDER_15 = "fa_fpe_u15"
        UNDER_20 = "fa_fpe_u20"
        UNDER_25 = "fa_fpe_u25"
        UNDER_30 = "fa_fpe_u30"
        UNDER_35 = "fa_fpe_u35"
        UNDER_40 = "fa_fpe_u40"
        UNDER_45 = "fa_fpe_u45"
        UNDER_50 = "fa_fpe_u50"
        OVER_5 = "fa_fpe_o5"
        OVER_10 = "fa_fpe_o10"
        OVER_15 = "fa_fpe_o15"
        OVER_20 = "fa_fpe_o20"
        OVER_25 = "fa_fpe_o25"
        OVER_30 = "fa_fpe_o30"
        OVER_35 = "fa_fpe_o35"
        OVER_40 = "fa_fpe_o40"
        OVER_45 = "fa_fpe_o45"
        OVER_50 = "fa_fpe_o50"
        CUSTOM_ELITE_ONLY = "fa_fpe_range"

    class PEGOption(ScreenerFilterOption, Enum):
        LOW_1 = "fa_peg_low"
        HIGH_2 = "fa_peg_high"
        UNDER_1 = "fa_peg_u1"
        UNDER_2 = "fa_peg_u2"
        UNDER_3 = "fa_peg_u3"
        OVER_1 = "fa_peg_o1"
        OVER_2 = "fa_peg_o2"
        OVER_3 = "fa_peg_o3"
        CUSTOM_ELITE_ONLY = "fa_peg_range"

    class PSOption(ScreenerFilterOption, Enum):
        LOW_1 = "fa_ps_low"
        HIGH_10 = "fa_ps_high"
        UNDER_1 = "fa_ps_u1"
        UNDER_2 = "fa_ps_u2"
        UNDER_3 = "fa_ps_u3"
        UNDER_4 = "fa_ps_u4"
        UNDER_5 = "fa_ps_u5"
        UNDER_6 = "fa_ps_u6"
        UNDER_7 = "fa_ps_u7"
        UNDER_8 = "fa_ps_u8"
        UNDER_9 = "fa_ps_u9"
        UNDER_10 = "fa_ps_u10"
        OVER_1 = "fa_ps_o1"
        OVER_2 = "fa_ps_o2"
        OVER_3 = "fa_ps_o3"
        OVER_4 = "fa_ps_o4"
        OVER_5 = "fa_ps_o5"
        OVER_6 = "fa_ps_o6"
        OVER_7 = "fa_ps_o7"
        OVER_8 = "fa_ps_o8"
        OVER_9 = "fa_ps_o9"
        OVER_10 = "fa_ps_o10"
        CUSTOM_ELITE_ONLY = "fa_ps_range"

    class PBOption(ScreenerFilterOption, Enum):
        LOW_1 = "fa_pb_low"
        HIGH_5 = "fa_pb_high"
        UNDER_1 = "fa_pb_u1"
        UNDER_2 = "fa_pb_u2"
        UNDER_3 = "fa_pb_u3"
        UNDER_4 = "fa_pb_u4"
        UNDER_5 = "fa_pb_u5"
        UNDER_6 = "fa_pb_u6"
        UNDER_7 = "fa_pb_u7"
        UNDER_8 = "fa_pb_u8"
        UNDER_9 = "fa_pb_u9"
        UNDER_10 = "fa_pb_u10"
        OVER_1 = "fa_pb_o1"
        OVER_2 = "fa_pb_o2"
        OVER_3 = "fa_pb_o3"
        OVER_4 = "fa_pb_o4"
        OVER_5 = "fa_pb_o5"
        OVER_6 = "fa_pb_o6"
        OVER_7 = "fa_pb_o7"
        OVER_8 = "fa_pb_o8"
        OVER_9 = "fa_pb_o9"
        OVER_10 = "fa_pb_o10"
        CUSTOM_ELITE_ONLY = "fa_pb_range"

    class PriceCashOption(ScreenerFilterOption, Enum):
        LOW_3 = "fa_pc_low"
        HIGH_50 = "fa_pc_high"
        UNDER_1 = "fa_pc_u1"
        UNDER_2 = "fa_pc_u2"
        UNDER_3 = "fa_pc_u3"
        UNDER_4 = "fa_pc_u4"
        UNDER_5 = "fa_pc_u5"
        UNDER_6 = "fa_pc_u6"
        UNDER_7 = "fa_pc_u7"
        UNDER_8 = "fa_pc_u8"
        UNDER_9 = "fa_pc_u9"
        UNDER_10 = "fa_pc_u10"
        OVER_1 = "fa_pc_o1"
        OVER_2 = "fa_pc_o2"
        OVER_3 = "fa_pc_o3"
        OVER_4 = "fa_pc_o4"
        OVER_5 = "fa_pc_o5"
        OVER_6 = "fa_pc_o6"
        OVER_7 = "fa_pc_o7"
        OVER_8 = "fa_pc_o8"
        OVER_9 = "fa_pc_o9"
        OVER_10 = "fa_pc_o10"
        OVER_20 = "fa_pc_o20"
        OVER_30 = "fa_pc_o30"
        OVER_40 = "fa_pc_o40"
        OVER_50 = "fa_pc_o50"
        CUSTOM_ELITE_ONLY = "fa_pc_range"

    class PriceFreeCashFlowOption(ScreenerFilterOption, Enum):
        LOW_15 = "fa_pfcf_low"
        HIGH_50 = "fa_pfcf_high"
        UNDER_5 = "fa_pfcf_u5"
        UNDER_10 = "fa_pfcf_u10"
        UNDER_15 = "fa_pfcf_u15"
        UNDER_20 = "fa_pfcf_u20"
        UNDER_25 = "fa_pfcf_u25"
        UNDER_30 = "fa_pfcf_u30"
        UNDER_35 = "fa_pfcf_u35"
        UNDER_40 = "fa_pfcf_u40"
        UNDER_45 = "fa_pfcf_u45"
        UNDER_50 = "fa_pfcf_u50"
        UNDER_60 = "fa_pfcf_u60"
        UNDER_70 = "fa_pfcf_u70"
        UNDER_80 = "fa_pfcf_u80"
        UNDER_90 = "fa_pfcf_u90"
        UNDER_100 = "fa_pfcf_u100"
        OVER_5 = "fa_pfcf_o5"
        OVER_10 = "fa_pfcf_o10"
        OVER_15 = "fa_pfcf_o15"
        OVER_20 = "fa_pfcf_o20"
        OVER_25 = "fa_pfcf_o25"
        OVER_30 = "fa_pfcf_o30"
        OVER_35 = "fa_pfcf_o35"
        OVER_40 = "fa_pfcf_o40"
        OVER_45 = "fa_pfcf_o45"
        OVER_50 = "fa_pfcf_o50"
        OVER_60 = "fa_pfcf_o60"
        OVER_70 = "fa_pfcf_o70"
        OVER_80 = "fa_pfcf_o80"
        OVER_90 = "fa_pfcf_o90"
        OVER_100 = "fa_pfcf_o100"
        CUSTOM_ELITE_ONLY = "fa_pfcf_range"

    class EPSGrowthThisYearOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_epsyoy_neg"
        POSITIVE_0_PERCENT = "fa_epsyoy_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_epsyoy_poslow"
        HIGH_25_PERCENT = "fa_epsyoy_high"
        UNDER_5_PERCENT = "fa_epsyoy_u5"
        UNDER_10_PERCENT = "fa_epsyoy_u10"
        UNDER_15_PERCENT = "fa_epsyoy_u15"
        UNDER_20_PERCENT = "fa_epsyoy_u20"
        UNDER_25_PERCENT = "fa_epsyoy_u25"
        UNDER_30_PERCENT = "fa_epsyoy_u30"
        OVER_5_PERCENT = "fa_epsyoy_o5"
        OVER_10_PERCENT = "fa_epsyoy_o10"
        OVER_15_PERCENT = "fa_epsyoy_o15"
        OVER_20_PERCENT = "fa_epsyoy_o20"
        OVER_25_PERCENT = "fa_epsyoy_o25"
        OVER_30_PERCENT = "fa_epsyoy_o30"
        CUSTOM_ELITE_ONLY = "fa_epsyoy_range"

    class EPSGrowthNextYearOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_epsyoy1_neg"
        POSITIVE_0_PERCENT = "fa_epsyoy1_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_epsyoy1_poslow"
        HIGH_25_PERCENT = "fa_epsyoy1_high"
        UNDER_5_PERCENT = "fa_epsyoy1_u5"
        UNDER_10_PERCENT = "fa_epsyoy1_u10"
        UNDER_15_PERCENT = "fa_epsyoy1_u15"
        UNDER_20_PERCENT = "fa_epsyoy1_u20"
        UNDER_25_PERCENT = "fa_epsyoy1_u25"
        UNDER_30_PERCENT = "fa_epsyoy1_u30"
        OVER_5_PERCENT = "fa_epsyoy1_o5"
        OVER_10_PERCENT = "fa_epsyoy1_o10"
        OVER_15_PERCENT = "fa_epsyoy1_o15"
        OVER_20_PERCENT = "fa_epsyoy1_o20"
        OVER_25_PERCENT = "fa_epsyoy1_o25"
        OVER_30_PERCENT = "fa_epsyoy1_o30"
        CUSTOM_ELITE_ONLY = "fa_epsyoy1_range"

    class EPSGrowthPast5YearsOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_eps5years_neg"
        POSITIVE_0_PERCENT = "fa_eps5years_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_eps5years_poslow"
        HIGH_25_PERCENT = "fa_eps5years_high"
        UNDER_5_PERCENT = "fa_eps5years_u5"
        UNDER_10_PERCENT = "fa_eps5years_u10"
        UNDER_15_PERCENT = "fa_eps5years_u15"
        UNDER_20_PERCENT = "fa_eps5years_u20"
        UNDER_25_PERCENT = "fa_eps5years_u25"
        UNDER_30_PERCENT = "fa_eps5years_u30"
        OVER_5_PERCENT = "fa_eps5years_o5"
        OVER_10_PERCENT = "fa_eps5years_o10"
        OVER_15_PERCENT = "fa_eps5years_o15"
        OVER_20_PERCENT = "fa_eps5years_o20"
        OVER_25_PERCENT = "fa_eps5years_o25"
        OVER_30_PERCENT = "fa_eps5years_o30"
        CUSTOM_ELITE_ONLY = "fa_eps5years_range"

    class EPSGrowthNext5YearsOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_estltgrowth_neg"
        POSITIVE_0_PERCENT = "fa_estltgrowth_pos"
        POSITIVE_LOW_10_PERCENT = "fa_estltgrowth_poslow"
        HIGH_25_PERCENT = "fa_estltgrowth_high"
        UNDER_5_PERCENT = "fa_estltgrowth_u5"
        UNDER_10_PERCENT = "fa_estltgrowth_u10"
        UNDER_15_PERCENT = "fa_estltgrowth_u15"
        UNDER_20_PERCENT = "fa_estltgrowth_u20"
        UNDER_25_PERCENT = "fa_estltgrowth_u25"
        UNDER_30_PERCENT = "fa_estltgrowth_u30"
        OVER_5_PERCENT = "fa_estltgrowth_o5"
        OVER_10_PERCENT = "fa_estltgrowth_o10"
        OVER_15_PERCENT = "fa_estltgrowth_o15"
        OVER_20_PERCENT = "fa_estltgrowth_o20"
        OVER_25_PERCENT = "fa_estltgrowth_o25"
        OVER_30_PERCENT = "fa_estltgrowth_o30"
        CUSTOM_ELITE_ONLY = "fa_estltgrowth_range"

    class SalesGrowthPast5YearsOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_sales5years_neg"
        POSITIVE_0_PERCENT = "fa_sales5years_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_sales5years_poslow"
        HIGH_25_PERCENT = "fa_sales5years_high"
        UNDER_5_PERCENT = "fa_sales5years_u5"
        UNDER_10_PERCENT = "fa_sales5years_u10"
        UNDER_15_PERCENT = "fa_sales5years_u15"
        UNDER_20_PERCENT = "fa_sales5years_u20"
        UNDER_25_PERCENT = "fa_sales5years_u25"
        UNDER_30_PERCENT = "fa_sales5years_u30"
        OVER_5_PERCENT = "fa_sales5years_o5"
        OVER_10_PERCENT = "fa_sales5years_o10"
        OVER_15_PERCENT = "fa_sales5years_o15"
        OVER_20_PERCENT = "fa_sales5years_o20"
        OVER_25_PERCENT = "fa_sales5years_o25"
        OVER_30_PERCENT = "fa_sales5years_o30"
        CUSTOM_ELITE_ONLY = "fa_sales5years_range"

    class EPSGrowthQtrOverQtrOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_epsqoq_neg"
        POSITIVE_0_PERCENT = "fa_epsqoq_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_epsqoq_poslow"
        HIGH_25_PERCENT = "fa_epsqoq_high"
        UNDER_5_PERCENT = "fa_epsqoq_u5"
        UNDER_10_PERCENT = "fa_epsqoq_u10"
        UNDER_15_PERCENT = "fa_epsqoq_u15"
        UNDER_20_PERCENT = "fa_epsqoq_u20"
        UNDER_25_PERCENT = "fa_epsqoq_u25"
        UNDER_30_PERCENT = "fa_epsqoq_u30"
        OVER_5_PERCENT = "fa_epsqoq_o5"
        OVER_10_PERCENT = "fa_epsqoq_o10"
        OVER_15_PERCENT = "fa_epsqoq_o15"
        OVER_20_PERCENT = "fa_epsqoq_o20"
        OVER_25_PERCENT = "fa_epsqoq_o25"
        OVER_30_PERCENT = "fa_epsqoq_o30"
        CUSTOM_ELITE_ONLY = "fa_epsqoq_range"

    class SalesGrowthQtrOverQtrOption(ScreenerFilterOption, Enum):
        NEGATIVE_0_PERCENT = "fa_salesqoq_neg"
        POSITIVE_0_PERCENT = "fa_salesqoq_pos"
        POSITIVE_LOW_0_10_PERCENT = "fa_salesqoq_poslow"
        HIGH_25_PERCENT = "fa_salesqoq_high"
        UNDER_5_PERCENT = "fa_salesqoq_u5"
        UNDER_10_PERCENT = "fa_salesqoq_u10"
        UNDER_15_PERCENT = "fa_salesqoq_u15"
        UNDER_20_PERCENT = "fa_salesqoq_u20"
        UNDER_25_PERCENT = "fa_salesqoq_u25"
        UNDER_30_PERCENT = "fa_salesqoq_u30"
        OVER_5_PERCENT = "fa_salesqoq_o5"
        OVER_10_PERCENT = "fa_salesqoq_o10"
        OVER_15_PERCENT = "fa_salesqoq_o15"
        OVER_20_PERCENT = "fa_salesqoq_o20"
        OVER_25_PERCENT = "fa_salesqoq_o25"
        OVER_30_PERCENT = "fa_salesqoq_o30"
        CUSTOM_ELITE_ONLY = "fa_salesqoq_range"

    class DividendYieldOption(ScreenerFilterOption, Enum):
        NONE_0_PERCENT = "fa_div_none"
        POSITIVE_0_PERCENT = "fa_div_pos"
        HIGH_5_PERCENT = "fa_div_high"
        VERY_HIGH_10_PERCENT = "fa_div_veryhigh"
        OVER_1_PERCENT = "fa_div_o1"
        OVER_2_PERCENT = "fa_div_o2"
        OVER_3_PERCENT = "fa_div_o3"
        OVER_4_PERCENT = "fa_div_o4"
        OVER_5_PERCENT = "fa_div_o5"
        OVER_6_PERCENT = "fa_div_o6"
        OVER_7_PERCENT = "fa_div_o7"
        OVER_8_PERCENT = "fa_div_o8"
        OVER_9_PERCENT = "fa_div_o9"
        OVER_10_PERCENT = "fa_div_o10"
        CUSTOM_ELITE_ONLY = "fa_div_range"

    class ReturnOnAssetsOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_roa_pos"
        NEGATIVE_0_PERCENT = "fa_roa_neg"
        VERY_POSITIVE_15_PERCENT = "fa_roa_verypos"
        VERY_NEGATIVE_15_PERCENT = "fa_roa_veryneg"
        UNDER_50_PERCENT = "fa_roa_u-50"
        UNDER_45_PERCENT = "fa_roa_u-45"
        UNDER_40_PERCENT = "fa_roa_u-40"
        UNDER_35_PERCENT = "fa_roa_u-35"
        UNDER_30_PERCENT = "fa_roa_u-30"
        UNDER_25_PERCENT = "fa_roa_u-25"
        UNDER_20_PERCENT = "fa_roa_u-20"
        UNDER_15_PERCENT = "fa_roa_u-15"
        UNDER_10_PERCENT = "fa_roa_u-10"
        UNDER_5_PERCENT = "fa_roa_u-5"
        OVER_5_PERCENT = "fa_roa_o5"
        OVER_10_PERCENT = "fa_roa_o10"
        OVER_15_PERCENT = "fa_roa_o15"
        OVER_20_PERCENT = "fa_roa_o20"
        OVER_25_PERCENT = "fa_roa_o25"
        OVER_30_PERCENT = "fa_roa_o30"
        OVER_35_PERCENT = "fa_roa_o35"
        OVER_40_PERCENT = "fa_roa_o40"
        OVER_45_PERCENT = "fa_roa_o45"
        OVER_50_PERCENT = "fa_roa_o50"
        CUSTOM_ELITE_ONLY = "fa_roa_range"

    class ReturnOnEquityOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_roe_pos"
        NEGATIVE_0_PERCENT = "fa_roe_neg"
        VERY_POSITIVE_30_PERCENT = "fa_roe_verypos"
        VERY_NEGATIVE_15_PERCENT = "fa_roe_veryneg"
        UNDER_50_PERCENT = "fa_roe_u-50"
        UNDER_45_PERCENT = "fa_roe_u-45"
        UNDER_40_PERCENT = "fa_roe_u-40"
        UNDER_35_PERCENT = "fa_roe_u-35"
        UNDER_30_PERCENT = "fa_roe_u-30"
        UNDER_25_PERCENT = "fa_roe_u-25"
        UNDER_20_PERCENT = "fa_roe_u-20"
        UNDER_15_PERCENT = "fa_roe_u-15"
        UNDER_10_PERCENT = "fa_roe_u-10"
        UNDER_5_PERCENT = "fa_roe_u-5"
        OVER_5_PERCENT = "fa_roe_o5"
        OVER_10_PERCENT = "fa_roe_o10"
        OVER_15_PERCENT = "fa_roe_o15"
        OVER_20_PERCENT = "fa_roe_o20"
        OVER_25_PERCENT = "fa_roe_o25"
        OVER_30_PERCENT = "fa_roe_o30"
        OVER_35_PERCENT = "fa_roe_o35"
        OVER_40_PERCENT = "fa_roe_o40"
        OVER_45_PERCENT = "fa_roe_o45"
        OVER_50_PERCENT = "fa_roe_o50"
        CUSTOM_ELITE_ONLY = "fa_roe_range"

    class ReturnOnInvestmentOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_roi_pos"
        NEGATIVE_0_PERCENT = "fa_roi_neg"
        VERY_POSITIVE_25_PERCENT = "fa_roi_verypos"
        VERY_NEGATIVE_10_PERCENT = "fa_roi_veryneg"
        UNDER_50_PERCENT = "fa_roi_u-50"
        UNDER_45_PERCENT = "fa_roi_u-45"
        UNDER_40_PERCENT = "fa_roi_u-40"
        UNDER_35_PERCENT = "fa_roi_u-35"
        UNDER_30_PERCENT = "fa_roi_u-30"
        UNDER_25_PERCENT = "fa_roi_u-25"
        UNDER_20_PERCENT = "fa_roi_u-20"
        UNDER_15_PERCENT = "fa_roi_u-15"
        UNDER_10_PERCENT = "fa_roi_u-10"
        UNDER_5_PERCENT = "fa_roi_u-5"
        OVER_5_PERCENT = "fa_roi_o5"
        OVER_10_PERCENT = "fa_roi_o10"
        OVER_15_PERCENT = "fa_roi_o15"
        OVER_20_PERCENT = "fa_roi_o20"
        OVER_25_PERCENT = "fa_roi_o25"
        OVER_30_PERCENT = "fa_roi_o30"
        OVER_35_PERCENT = "fa_roi_o35"
        OVER_40_PERCENT = "fa_roi_o40"
        OVER_45_PERCENT = "fa_roi_o45"
        OVER_50_PERCENT = "fa_roi_o50"
        CUSTOM_ELITE_ONLY = "fa_roi_range"

    class CurrentRatioOption(ScreenerFilterOption, Enum):
        HIGH_3 = "fa_curratio_high"
        LOW_1 = "fa_curratio_low"
        UNDER_1 = "fa_curratio_u1"
        UNDER_0_5 = "fa_curratio_u0.5"
        OVER_0_5 = "fa_curratio_o0.5"
        OVER_1 = "fa_curratio_o1"
        OVER_1_5 = "fa_curratio_o1.5"
        OVER_2 = "fa_curratio_o2"
        OVER_3 = "fa_curratio_o3"
        OVER_4 = "fa_curratio_o4"
        OVER_5 = "fa_curratio_o5"
        OVER_10 = "fa_curratio_o10"
        CUSTOM_ELITE_ONLY = "fa_curratio_range"

    class QuickRatioOption(ScreenerFilterOption, Enum):
        HIGH_3 = "fa_quickratio_high"
        LOW_0_5 = "fa_quickratio_low"
        UNDER_1 = "fa_quickratio_u1"
        UNDER_0_5 = "fa_quickratio_u0.5"
        OVER_0_5 = "fa_quickratio_o0.5"
        OVER_1 = "fa_quickratio_o1"
        OVER_1_5 = "fa_quickratio_o1.5"
        OVER_2 = "fa_quickratio_o2"
        OVER_3 = "fa_quickratio_o3"
        OVER_4 = "fa_quickratio_o4"
        OVER_5 = "fa_quickratio_o5"
        OVER_10 = "fa_quickratio_o10"
        CUSTOM_ELITE_ONLY = "fa_quickratio_frange"

    class LTDebtEquityOption(ScreenerFilterOption, Enum):
        HIGH_0_5 = "fa_ltdebteq_high"
        LOW_0_1 = "fa_ltdebteq_low"
        UNDER_1 = "fa_ltdebteq_u1"
        UNDER_0_9 = "fa_ltdebteq_u0.9"
        UNDER_0_8 = "fa_ltdebteq_u0.8"
        UNDER_0_7 = "fa_ltdebteq_u0.7"
        UNDER_0_6 = "fa_ltdebteq_u0.6"
        UNDER_0_5 = "fa_ltdebteq_u0.5"
        UNDER_0_4 = "fa_ltdebteq_u0.4"
        UNDER_0_3 = "fa_ltdebteq_u0.3"
        UNDER_0_2 = "fa_ltdebteq_u0.2"
        UNDER_0_1 = "fa_ltdebteq_u0.1"
        OVER_0_1 = "fa_ltdebteq_o0.1"
        OVER_0_2 = "fa_ltdebteq_o0.2"
        OVER_0_3 = "fa_ltdebteq_o0.3"
        OVER_0_4 = "fa_ltdebteq_o0.4"
        OVER_0_5 = "fa_ltdebteq_o0.5"
        OVER_0_6 = "fa_ltdebteq_o0.6"
        OVER_0_7 = "fa_ltdebteq_o0.7"
        OVER_0_8 = "fa_ltdebteq_o0.8"
        OVER_0_9 = "fa_ltdebteq_o0.9"
        OVER_1 = "fa_ltdebteq_o1"
        CUSTOM_ELITE_ONLY = "fa_ltdebteq_frange"

    class DebtEquityOption(ScreenerFilterOption, Enum):
        HIGH_0_5 = "fa_debteq_high"
        LOW_0_1 = "fa_debteq_low"
        UNDER_1 = "fa_debteq_u1"
        UNDER_0_9 = "fa_debteq_u0.9"
        UNDER_0_8 = "fa_debteq_u0.8"
        UNDER_0_7 = "fa_debteq_u0.7"
        UNDER_0_6 = "fa_debteq_u0.6"
        UNDER_0_5 = "fa_debteq_u0.5"
        UNDER_0_4 = "fa_debteq_u0.4"
        UNDER_0_3 = "fa_debteq_u0.3"
        UNDER_0_2 = "fa_debteq_u0.2"
        UNDER_0_1 = "fa_debteq_u0.1"
        OVER_0_1 = "fa_debteq_o0.1"
        OVER_0_2 = "fa_debteq_o0.2"
        OVER_0_3 = "fa_debteq_o0.3"
        OVER_0_4 = "fa_debteq_o0.4"
        OVER_0_5 = "fa_debteq_o0.5"
        OVER_0_6 = "fa_debteq_o0.6"
        OVER_0_7 = "fa_debteq_o0.7"
        OVER_0_8 = "fa_debteq_o0.8"
        OVER_0_9 = "fa_debteq_o0.9"
        OVER_1 = "fa_debteq_o1"
        CUSTOM_ELITE_ONLY = "fa_debteq_frange"

    class GrossMarginOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_grossmargin_pos"
        NEGATIVE_0_PERCENT = "fa_grossmargin_neg"
        HIGH_50_PERCENT = "fa_grossmargin_high"
        UNDER_90_PERCENT = "fa_grossmargin_u90"
        UNDER_80_PERCENT = "fa_grossmargin_u80"
        UNDER_70_PERCENT = "fa_grossmargin_u70"
        UNDER_60_PERCENT = "fa_grossmargin_u60"
        UNDER_50_PERCENT = "fa_grossmargin_u50"
        UNDER_45_PERCENT = "fa_grossmargin_u45"
        UNDER_40_PERCENT = "fa_grossmargin_u40"
        UNDER_35_PERCENT = "fa_grossmargin_u35"
        UNDER_30_PERCENT = "fa_grossmargin_u30"
        UNDER_25_PERCENT = "fa_grossmargin_u25"
        UNDER_20_PERCENT = "fa_grossmargin_u20"
        UNDER_15_PERCENT = "fa_grossmargin_u15"
        UNDER_10_PERCENT = "fa_grossmargin_u10"
        UNDER_5_PERCENT = "fa_grossmargin_u5"
        UNDER_0_PERCENT = "fa_grossmargin_u0"
        UNDER_NEG_10_PERCENT = "fa_grossmargin_u-10"
        UNDER_NEG_20_PERCENT = "fa_grossmargin_u-20"
        UNDER_NEG_30_PERCENT = "fa_grossmargin_u-30"
        UNDER_NEG_50_PERCENT = "fa_grossmargin_u-50"
        UNDER_NEG_70_PERCENT = "fa_grossmargin_u-70"
        UNDER_100_PERCENT = "fa_grossmargin_u-100"
        OVER_0_PERCENT = "fa_grossmargin_o0"
        OVER_5_PERCENT = "fa_grossmargin_o5"
        OVER_10_PERCENT = "fa_grossmargin_o10"
        OVER_15_PERCENT = "fa_grossmargin_o15"
        OVER_20_PERCENT = "fa_grossmargin_o20"
        OVER_25_PERCENT = "fa_grossmargin_o25"
        OVER_30_PERCENT = "fa_grossmargin_o30"
        OVER_35_PERCENT = "fa_grossmargin_o35"
        OVER_40_PERCENT = "fa_grossmargin_o40"
        OVER_45_PERCENT = "fa_grossmargin_o45"
        OVER_50_PERCENT = "fa_grossmargin_o50"
        OVER_60_PERCENT = "fa_grossmargin_o60"
        OVER_70_PERCENT = "fa_grossmargin_o70"
        OVER_80_PERCENT = "fa_grossmargin_o80"
        OVER_90_PERCENT = "fa_grossmargin_o90"
        CUSTOM_ELITE_ONLY = "fa_grossmargin_range"

    class OperatingMarginOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_opermargin_pos"
        NEGATIVE_0_PERCENT = "fa_opermargin_neg"
        VERY_NEGATIVE_20_PERCENT = "fa_opermargin_veryneg"
        HIGH_25_PERCENT = "fa_opermargin_high"
        UNDER_90_PERCENT = "fa_opermargin_u90"
        UNDER_80_PERCENT = "fa_opermargin_u80"
        UNDER_70_PERCENT = "fa_opermargin_u70"
        UNDER_60_PERCENT = "fa_opermargin_u60"
        UNDER_50_PERCENT = "fa_opermargin_u50"
        UNDER_45_PERCENT = "fa_opermargin_u45"
        UNDER_40_PERCENT = "fa_opermargin_u40"
        UNDER_35_PERCENT = "fa_opermargin_u35"
        UNDER_30_PERCENT = "fa_opermargin_u30"
        UNDER_25_PERCENT = "fa_opermargin_u25"
        UNDER_20_PERCENT = "fa_opermargin_u20"
        UNDER_15_PERCENT = "fa_opermargin_u15"
        UNDER_10_PERCENT = "fa_opermargin_u10"
        UNDER_5_PERCENT = "fa_opermargin_u5"
        UNDER_0_PERCENT = "fa_opermargin_u0"
        UNDER_NEG_10_PERCENT = "fa_opermargin_u-10"
        UNDER_NEG_20_PERCENT = "fa_opermargin_u-20"
        UNDER_NEG_30_PERCENT = "fa_opermargin_u-30"
        UNDER_NEG_50_PERCENT = "fa_opermargin_u-50"
        UNDER_NEG_70_PERCENT = "fa_opermargin_u-70"
        UNDER_100_PERCENT = "fa_opermargin_u-100"
        OVER_0_PERCENT = "fa_opermargin_o0"
        OVER_5_PERCENT = "fa_opermargin_o5"
        OVER_10_PERCENT = "fa_opermargin_o10"
        OVER_15_PERCENT = "fa_opermargin_o15"
        OVER_20_PERCENT = "fa_opermargin_o20"
        OVER_25_PERCENT = "fa_opermargin_o25"
        OVER_30_PERCENT = "fa_opermargin_o30"
        OVER_35_PERCENT = "fa_opermargin_o35"
        OVER_40_PERCENT = "fa_opermargin_o40"
        OVER_45_PERCENT = "fa_opermargin_o45"
        OVER_50_PERCENT = "fa_opermargin_o50"
        OVER_60_PERCENT = "fa_opermargin_o60"
        OVER_70_PERCENT = "fa_opermargin_o70"
        OVER_80_PERCENT = "fa_opermargin_o80"
        OVER_90_PERCENT = "fa_opermargin_o90"
        CUSTOM_ELITE_ONLY = "fa_opermargin_range"

    class NetProfitMarginOption(ScreenerFilterOption, Enum):
        POSITIVE_0_PERCENT = "fa_netmargin_pos"
        NEGATIVE_0_PERCENT = "fa_netmargin_neg"
        VERY_NEGATIVE_20_PERCENT = "fa_netmargin_veryneg"
        HIGH_20_PERCENT = "fa_netmargin_high"
        UNDER_90_PERCENT = "fa_netmargin_u90"
        UNDER_80_PERCENT = "fa_netmargin_u80"
        UNDER_70_PERCENT = "fa_netmargin_u70"
        UNDER_60_PERCENT = "fa_netmargin_u60"
        UNDER_50_PERCENT = "fa_netmargin_u50"
        UNDER_45_PERCENT = "fa_netmargin_u45"
        UNDER_40_PERCENT = "fa_netmargin_u40"
        UNDER_35_PERCENT = "fa_netmargin_u35"
        UNDER_30_PERCENT = "fa_netmargin_u30"
        UNDER_25_PERCENT = "fa_netmargin_u25"
        UNDER_20_PERCENT = "fa_netmargin_u20"
        UNDER_15_PERCENT = "fa_netmargin_u15"
        UNDER_10_PERCENT = "fa_netmargin_u10"
        UNDER_5_PERCENT = "fa_netmargin_u5"
        UNDER_0_PERCENT = "fa_netmargin_u0"
        UNDER_NEG_10_PERCENT = "fa_netmargin_u-10"
        UNDER_NEG_20_PERCENT = "fa_netmargin_u-20"
        UNDER_NEG_30_PERCENT = "fa_netmargin_u-30"
        UNDER_NEG_50_PERCENT = "fa_netmargin_u-50"
        UNDER_NEG_70_PERCENT = "fa_netmargin_u-70"
        UNDER_100_PERCENT = "fa_netmargin_u-100"
        OVER_0_PERCENT = "fa_netmargin_o0"
        OVER_5_PERCENT = "fa_netmargin_o5"
        OVER_10_PERCENT = "fa_netmargin_o10"
        OVER_15_PERCENT = "fa_netmargin_o15"
        OVER_20_PERCENT = "fa_netmargin_o20"
        OVER_25_PERCENT = "fa_netmargin_o25"
        OVER_30_PERCENT = "fa_netmargin_o30"
        OVER_35_PERCENT = "fa_netmargin_o35"
        OVER_40_PERCENT = "fa_netmargin_o40"
        OVER_45_PERCENT = "fa_netmargin_o45"
        OVER_50_PERCENT = "fa_netmargin_o50"
        OVER_60_PERCENT = "fa_netmargin_o60"
        OVER_70_PERCENT = "fa_netmargin_o70"
        OVER_80_PERCENT = "fa_netmargin_o80"
        OVER_90_PERCENT = "fa_netmargin_o90"
        CUSTOM_ELITE_ONLY = "fa_netmargin_range"

    class PayoutRatioOption(ScreenerFilterOption, Enum):
        NONE_0_PERCENT = "fa_payoutratio_none"
        POSITIVE_0_PERCENT = "fa_payoutratio_pos"
        LOW_20_PERCENT = "fa_payoutratio_low"
        HIGH_50_PERCENT = "fa_payoutratio_high"
        OVER_0_PERCENT = "fa_payoutratio_o0"
        OVER_10_PERCENT = "fa_payoutratio_o10"
        OVER_20_PERCENT = "fa_payoutratio_o20"
        OVER_30_PERCENT = "fa_payoutratio_o30"
        OVER_40_PERCENT = "fa_payoutratio_o40"
        OVER_50_PERCENT = "fa_payoutratio_o50"
        OVER_60_PERCENT = "fa_payoutratio_o60"
        OVER_70_PERCENT = "fa_payoutratio_o70"
        OVER_80_PERCENT = "fa_payoutratio_o80"
        OVER_90_PERCENT = "fa_payoutratio_o90"
        OVER_100_PERCENT = "fa_payoutratio_o100"
        UNDER_10_PERCENT = "fa_payoutratio_u10"
        UNDER_20_PERCENT = "fa_payoutratio_u20"
        UNDER_30_PERCENT = "fa_payoutratio_u30"
        UNDER_40_PERCENT = "fa_payoutratio_u40"
        UNDER_50_PERCENT = "fa_payoutratio_u50"
        UNDER_60_PERCENT = "fa_payoutratio_u60"
        UNDER_70_PERCENT = "fa_payoutratio_u70"
        UNDER_80_PERCENT = "fa_payoutratio_u80"
        UNDER_90_PERCENT = "fa_payoutratio_u90"
        UNDER_100_PERCENT = "fa_payoutratio_u100"
        CUSTOM_ELITE_ONLY = "fa_payoutratio_range"

    class InsiderOwnershipOption(ScreenerFilterOption, Enum):
        LOW_5_PERCENT = "sh_insiderown_low"
        HIGH_30_PERCENT = "sh_insiderown_high"
        VERY_HIGH_50_PERCENT = "sh_insiderown_veryhigh"
        OVER_10_PERCENT = "sh_insiderown_o10"
        OVER_20_PERCENT = "sh_insiderown_o20"
        OVER_30_PERCENT = "sh_insiderown_o30"
        OVER_40_PERCENT = "sh_insiderown_o40"
        OVER_50_PERCENT = "sh_insiderown_o50"
        OVER_60_PERCENT = "sh_insiderown_o60"
        OVER_70_PERCENT = "sh_insiderown_o70"
        OVER_80_PERCENT = "sh_insiderown_o80"
        OVER_90_PERCENT = "sh_insiderown_o90"
        CUSTOM_ELITE_ONLY = "sh_insiderown_range"

    class InsiderTransactionsOption(ScreenerFilterOption, Enum):
        VERY_NEGATIVE_20_PERCENT = "sh_insidertrans_veryneg"
        NEGATIVE_0_PERCENT = "sh_insidertrans_neg"
        POSITIVE_0_PERCENT = "sh_insidertrans_pos"
        VERY_POSITIVE_20_PERCENT = "sh_insidertrans_verypos"
        UNDER_90_PERCENT = "sh_insidertrans_u-90"
        UNDER_80_PERCENT = "sh_insidertrans_u-80"
        UNDER_70_PERCENT = "sh_insidertrans_u-70"
        UNDER_60_PERCENT = "sh_insidertrans_u-60"
        UNDER_50_PERCENT = "sh_insidertrans_u-50"
        UNDER_45_PERCENT = "sh_insidertrans_u-45"
        UNDER_40_PERCENT = "sh_insidertrans_u-40"
        UNDER_35_PERCENT = "sh_insidertrans_u-35"
        UNDER_30_PERCENT = "sh_insidertrans_u-30"
        UNDER_25_PERCENT = "sh_insidertrans_u-25"
        UNDER_20_PERCENT = "sh_insidertrans_u-20"
        UNDER_15_PERCENT = "sh_insidertrans_u-15"
        UNDER_10_PERCENT = "sh_insidertrans_u-10"
        UNDER_5_PERCENT = "sh_insidertrans_u-5"
        OVER_5_PERCENT = "sh_insidertrans_o5"
        OVER_10_PERCENT = "sh_insidertrans_o10"
        OVER_15_PERCENT = "sh_insidertrans_o15"
        OVER_20_PERCENT = "sh_insidertrans_o20"
        OVER_25_PERCENT = "sh_insidertrans_o25"
        OVER_30_PERCENT = "sh_insidertrans_o30"
        OVER_35_PERCENT = "sh_insidertrans_o35"
        OVER_40_PERCENT = "sh_insidertrans_o40"
        OVER_45_PERCENT = "sh_insidertrans_o45"
        OVER_50_PERCENT = "sh_insidertrans_o50"
        OVER_60_PERCENT = "sh_insidertrans_o60"
        OVER_70_PERCENT = "sh_insidertrans_o70"
        OVER_80_PERCENT = "sh_insidertrans_o80"
        OVER_90_PERCENT = "sh_insidertrans_o90"
        CUSTOM_ELITE_ONLY = "sh_insidertrans_range"

    class InstitutionalOwnershipOption(ScreenerFilterOption, Enum):
        LOW_5_PERCENT = "sh_instown_low"
        HIGH_90_PERCENT = "sh_instown_high"
        UNDER_90_PERCENT = "sh_instown_u90"
        UNDER_80_PERCENT = "sh_instown_u80"
        UNDER_70_PERCENT = "sh_instown_u70"
        UNDER_60_PERCENT = "sh_instown_u60"
        UNDER_50_PERCENT = "sh_instown_u50"
        UNDER_40_PERCENT = "sh_instown_u40"
        UNDER_30_PERCENT = "sh_instown_u30"
        UNDER_20_PERCENT = "sh_instown_u20"
        UNDER_10_PERCENT = "sh_instown_u10"
        OVER_10_PERCENT = "sh_instown_o10"
        OVER_20_PERCENT = "sh_instown_o20"
        OVER_30_PERCENT = "sh_instown_o30"
        OVER_40_PERCENT = "sh_instown_o40"
        OVER_50_PERCENT = "sh_instown_o50"
        OVER_60_PERCENT = "sh_instown_o60"
        OVER_70_PERCENT = "sh_instown_o70"
        OVER_80_PERCENT = "sh_instown_o80"
        OVER_90_PERCENT = "sh_instown_o90"
        CUSTOM_ELITE_ONLY = "sh_instown_range"

    class InstitutionalTransactionsOption(ScreenerFilterOption, Enum):
        VERY_NEGATIVE_20_PERCENT = "sh_insttrans_veryneg"
        NEGATIVE_0_PERCENT = "sh_insttrans_neg"
        POSITIVE_0_PERCENT = "sh_insttrans_pos"
        VERY_POSITIVE_20_PERCENT = "sh_insttrans_verypos"
        UNDER_50_PERCENT = "sh_insttrans_u-50"
        UNDER_45_PERCENT = "sh_insttrans_u-45"
        UNDER_40_PERCENT = "sh_insttrans_u-40"
        UNDER_35_PERCENT = "sh_insttrans_u-35"
        UNDER_30_PERCENT = "sh_insttrans_u-30"
        UNDER_25_PERCENT = "sh_insttrans_u-25"
        UNDER_20_PERCENT = "sh_insttrans_u-20"
        UNDER_15_PERCENT = "sh_insttrans_u-15"
        UNDER_10_PERCENT = "sh_insttrans_u-10"
        UNDER_5_PERCENT = "sh_insttrans_u-5"
        OVER_5_PERCENT = "sh_insttrans_o5"
        OVER_10_PERCENT = "sh_insttrans_o10"
        OVER_15_PERCENT = "sh_insttrans_o15"
        OVER_20_PERCENT = "sh_insttrans_o20"
        OVER_25_PERCENT = "sh_insttrans_o25"
        OVER_30_PERCENT = "sh_insttrans_o30"
        OVER_35_PERCENT = "sh_insttrans_o35"
        OVER_40_PERCENT = "sh_insttrans_o40"
        OVER_45_PERCENT = "sh_insttrans_o45"
        OVER_50_PERCENT = "sh_insttrans_o50"
        CUSTOM_ELITE_ONLY = "sh_insttrans_range"

    class FloatShortOption(ScreenerFilterOption, Enum):
        LOW_5_PERCENT = "sh_short_low"
        HIGH_20_PERCENT = "sh_short_high"
        UNDER_5_PERCENT = "sh_short_u5"
        UNDER_10_PERCENT = "sh_short_u10"
        UNDER_15_PERCENT = "sh_short_u15"
        UNDER_20_PERCENT = "sh_short_u20"
        UNDER_25_PERCENT = "sh_short_u25"
        UNDER_30_PERCENT = "sh_short_u30"
        OVER_5_PERCENT = "sh_short_o5"
        OVER_10_PERCENT = "sh_short_o10"
        OVER_15_PERCENT = "sh_short_o15"
        OVER_20_PERCENT = "sh_short_o20"
        OVER_25_PERCENT = "sh_short_o25"
        OVER_30_PERCENT = "sh_short_o30"
        CUSTOM_ELITE_ONLY = "sh_short_range"

    class AnalystRecomOption(ScreenerFilterOption, Enum):
        STRONG_BUY_1 = "an_recom_strongbuy"
        BUY_OR_BETTER = "an_recom_buybetter"
        BUY = "an_recom_buy"
        HOLD_OR_BETTER = "an_recom_holdbetter"
        HOLD = "an_recom_hold"
        HOLD_OR_WORSE = "an_recom_holdworse"
        SELL = "an_recom_sell"
        SELL_OR_WORSE = "an_recom_sellworse"
        STRONG_SELL_5 = "an_recom_strongsell"
        CUSTOM_ELITE_ONLY = "an_recom_modal"

    class OptionShortOption(ScreenerFilterOption, Enum):
        OPTIONABLE = "sh_opt_option"
        SHORTABLE = "sh_opt_short"
        OPTIONABLE_AND_SHORTABLE = "sh_opt_optionshort"

    class EarningsDateOption(ScreenerFilterOption, Enum):
        TODAY = "earningsdate_today"
        TODAY_BEFORE_MARKET_OPEN = "earningsdate_todaybefore"
        TODAY_AFTER_MARKET_CLOSE = "earningsdate_todayafter"
        TOMORROW = "earningsdate_tomorrow"
        TOMORROW_BEFORE_MARKET_OPEN = "earningsdate_tomorrowbefore"
        TOMORROW_AFTER_MARKET_CLOSE = "earningsdate_tomorrowafter"
        YESTERDAY = "earningsdate_yesterday"
        YESTERDAY_BEFORE_MARKET_OPEN = "earningsdate_yesterdaybefore"
        YESTERDAY_AFTER_MARKET_CLOSE = "earningsdate_yesterdayafter"
        NEXT_5_DAYS = "earningsdate_nextdays5"
        PREVIOUS_5_DAYS = "earningsdate_prevdays5"
        THIS_WEEK = "earningsdate_thisweek"
        NEXT_WEEK = "earningsdate_nextweek"
        PREVIOUS_WEEK = "earningsdate_prevweek"
        THIS_MONTH = "earningsdate_thismonth"
        CUSTOM_ELITE_ONLY = "earningsdate_modal"

    class PerformanceOption(ScreenerFilterOption, Enum):
        TODAY_UP = "ta_perf_dup"
        TODAY_DOWN = "ta_perf_ddown"
        TODAY_NEG_15_PERCENT = "ta_perf_d15u"
        TODAY_NEG_10_PERCENT = "ta_perf_d10u"
        TODAY_NEG_5_PERCENT = "ta_perf_d5u"
        TODAY_5_PERCENT = "ta_perf_d5o"
        TODAY_10_PERCENT = "ta_perf_d10o"
        TODAY_15_PERCENT = "ta_perf_d15o"
        WEEK_NEG_30_PERCENT = "ta_perf_1w30u"
        WEEK_NEG_20_PERCENT = "ta_perf_1w20u"
        WEEK_NEG_10_PERCENT = "ta_perf_1w10u"
        WEEK_DOWN = "ta_perf_1wdown"
        WEEK_UP = "ta_perf_1wup"
        WEEK_10_PERCENT = "ta_perf_1w10o"
        WEEK_20_PERCENT = "ta_perf_1w20o"
        WEEK_30_PERCENT = "ta_perf_1w30o"
        MONTH_NEG_50_PERCENT = "ta_perf_4w50u"
        MONTH_NEG_30_PERCENT = "ta_perf_4w30u"
        MONTH_NEG_20_PERCENT = "ta_perf_4w20u"
        MONTH_NEG_10_PERCENT = "ta_perf_4w10u"
        MONTH_DOWN = "ta_perf_4wdown"
        MONTH_UP = "ta_perf_4wup"
        MONTH_10_PERCENT = "ta_perf_4w10o"
        MONTH_20_PERCENT = "ta_perf_4w20o"
        MONTH_30_PERCENT = "ta_perf_4w30o"
        MONTH_50_PERCENT = "ta_perf_4w50o"
        QUARTER_NEG_50_PERCENT = "ta_perf_13w50u"
        QUARTER_NEG_30_PERCENT = "ta_perf_13w30u"
        QUARTER_NEG_20_PERCENT = "ta_perf_13w20u"
        QUARTER_NEG_10_PERCENT = "ta_perf_13w10u"
        QUARTER_DOWN = "ta_perf_13wdown"
        QUARTER_UP = "ta_perf_13wup"
        QUARTER_10_PERCENT = "ta_perf_13w10o"
        QUARTER_20_PERCENT = "ta_perf_13w20o"
        QUARTER_30_PERCENT = "ta_perf_13w30o"
        QUARTER_50_PERCENT = "ta_perf_13w50o"
        HALF_NEG_75_PERCENT = "ta_perf_26w75u"
        HALF_NEG_50_PERCENT = "ta_perf_26w50u"
        HALF_NEG_30_PERCENT = "ta_perf_26w30u"
        HALF_NEG_20_PERCENT = "ta_perf_26w20u"
        HALF_NEG_10_PERCENT = "ta_perf_26w10u"
        HALF_DOWN = "ta_perf_26wdown"
        HALF_UP = "ta_perf_26wup"
        HALF_10_PERCENT = "ta_perf_26w10o"
        HALF_20_PERCENT = "ta_perf_26w20o"
        HALF_30_PERCENT = "ta_perf_26w30o"
        HALF_50_PERCENT = "ta_perf_26w50o"
        HALF_100_PERCENT = "ta_perf_26w100o"
        YEAR_NEG_75_PERCENT = "ta_perf_52w75u"
        YEAR_NEG_50_PERCENT = "ta_perf_52w50u"
        YEAR_NEG_30_PERCENT = "ta_perf_52w30u"
        YEAR_NEG_20_PERCENT = "ta_perf_52w20u"
        YEAR_NEG_10_PERCENT = "ta_perf_52w10u"
        YEAR_DOWN = "ta_perf_52wdown"
        YEAR_UP = "ta_perf_52wup"
        YEAR_10_PERCENT = "ta_perf_52w10o"
        YEAR_20_PERCENT = "ta_perf_52w20o"
        YEAR_30_PERCENT = "ta_perf_52w30o"
        YEAR_50_PERCENT = "ta_perf_52w50o"
        YEAR_100_PERCENT = "ta_perf_52w100o"
        YEAR_200_PERCENT = "ta_perf_52w200o"
        YEAR_300_PERCENT = "ta_perf_52w300o"
        YEAR_500_PERCENT = "ta_perf_52w500o"
        YTD_NEG_75_PERCENT = "ta_perf_ytd75u"
        YTD_NEG_50_PERCENT = "ta_perf_ytd50u"
        YTD_NEG_30_PERCENT = "ta_perf_ytd30u"
        YTD_NEG_20_PERCENT = "ta_perf_ytd20u"
        YTD_NEG_10_PERCENT = "ta_perf_ytd10u"
        YTD_NEG_5_PERCENT = "ta_perf_ytd5u"
        YTD_DOWN = "ta_perf_ytddown"
        YTD_UP = "ta_perf_ytdup"
        YTD_5_PERCENT = "ta_perf_ytd5o"
        YTD_10_PERCENT = "ta_perf_ytd10o"
        YTD_20_PERCENT = "ta_perf_ytd20o"
        YTD_30_PERCENT = "ta_perf_ytd30o"
        YTD_50_PERCENT = "ta_perf_ytd50o"
        YTD_100_PERCENT = "ta_perf_ytd100o"

    class Performance2Option(ScreenerFilterOption, Enum):
        TODAY_UP = "ta_perf2_dup"
        TODAY_DOWN = "ta_perf2_ddown"
        TODAY_NEG_15_PERCENT = "ta_perf2_d15u"
        TODAY_NEG_10_PERCENT = "ta_perf2_d10u"
        TODAY_NEG_5_PERCENT = "ta_perf2_d5u"
        TODAY_5_PERCENT = "ta_perf2_d5o"
        TODAY_10_PERCENT = "ta_perf2_d10o"
        TODAY_15_PERCENT = "ta_perf2_d15o"
        WEEK_NEG_30_PERCENT = "ta_perf2_1w30u"
        WEEK_NEG_20_PERCENT = "ta_perf2_1w20u"
        WEEK_NEG_10_PERCENT = "ta_perf2_1w10u"
        WEEK_DOWN = "ta_perf2_1wdown"
        WEEK_UP = "ta_perf2_1wup"
        WEEK_10_PERCENT = "ta_perf2_1w10o"
        WEEK_20_PERCENT = "ta_perf2_1w20o"
        WEEK_30_PERCENT = "ta_perf2_1w30o"
        MONTH_NEG_50_PERCENT = "ta_perf2_4w50u"
        MONTH_NEG_30_PERCENT = "ta_perf2_4w30u"
        MONTH_NEG_20_PERCENT = "ta_perf2_4w20u"
        MONTH_NEG_10_PERCENT = "ta_perf2_4w10u"
        MONTH_DOWN = "ta_perf2_4wdown"
        MONTH_UP = "ta_perf2_4wup"
        MONTH_10_PERCENT = "ta_perf2_4w10o"
        MONTH_20_PERCENT = "ta_perf2_4w20o"
        MONTH_30_PERCENT = "ta_perf2_4w30o"
        MONTH_50_PERCENT = "ta_perf2_4w50o"
        QUARTER_NEG_50_PERCENT = "ta_perf2_13w50u"
        QUARTER_NEG_30_PERCENT = "ta_perf2_13w30u"
        QUARTER_NEG_20_PERCENT = "ta_perf2_13w20u"
        QUARTER_NEG_10_PERCENT = "ta_perf2_13w10u"
        QUARTER_DOWN = "ta_perf2_13wdown"
        QUARTER_UP = "ta_perf2_13wup"
        QUARTER_10_PERCENT = "ta_perf2_13w10o"
        QUARTER_20_PERCENT = "ta_perf2_13w20o"
        QUARTER_30_PERCENT = "ta_perf2_13w30o"
        QUARTER_50_PERCENT = "ta_perf2_13w50o"
        HALF_NEG_75_PERCENT = "ta_perf2_26w75u"
        HALF_NEG_50_PERCENT = "ta_perf2_26w50u"
        HALF_NEG_30_PERCENT = "ta_perf2_26w30u"
        HALF_NEG_20_PERCENT = "ta_perf2_26w20u"
        HALF_NEG_10_PERCENT = "ta_perf2_26w10u"
        HALF_DOWN = "ta_perf2_26wdown"
        HALF_UP = "ta_perf2_26wup"
        HALF_10_PERCENT = "ta_perf2_26w10o"
        HALF_20_PERCENT = "ta_perf2_26w20o"
        HALF_30_PERCENT = "ta_perf2_26w30o"
        HALF_50_PERCENT = "ta_perf2_26w50o"
        HALF_100_PERCENT = "ta_perf2_26w100o"
        YEAR_NEG_75_PERCENT = "ta_perf2_52w75u"
        YEAR_NEG_50_PERCENT = "ta_perf2_52w50u"
        YEAR_NEG_30_PERCENT = "ta_perf2_52w30u"
        YEAR_NEG_20_PERCENT = "ta_perf2_52w20u"
        YEAR_NEG_10_PERCENT = "ta_perf2_52w10u"
        YEAR_DOWN = "ta_perf2_52wdown"
        YEAR_UP = "ta_perf2_52wup"
        YEAR_10_PERCENT = "ta_perf2_52w10o"
        YEAR_20_PERCENT = "ta_perf2_52w20o"
        YEAR_30_PERCENT = "ta_perf2_52w30o"
        YEAR_50_PERCENT = "ta_perf2_52w50o"
        YEAR_100_PERCENT = "ta_perf2_52w100o"
        YEAR_200_PERCENT = "ta_perf2_52w200o"
        YEAR_300_PERCENT = "ta_perf2_52w300o"
        YEAR_500_PERCENT = "ta_perf2_52w500o"
        YTD_NEG_75_PERCENT = "ta_perf2_ytd75u"
        YTD_NEG_50_PERCENT = "ta_perf2_ytd50u"
        YTD_NEG_30_PERCENT = "ta_perf2_ytd30u"
        YTD_NEG_20_PERCENT = "ta_perf2_ytd20u"
        YTD_NEG_10_PERCENT = "ta_perf2_ytd10u"
        YTD_NEG_5_PERCENT = "ta_perf2_ytd5u"
        YTD_DOWN = "ta_perf2_ytddown"
        YTD_UP = "ta_perf2_ytdup"
        YTD_5_PERCENT = "ta_perf2_ytd5o"
        YTD_10_PERCENT = "ta_perf2_ytd10o"
        YTD_20_PERCENT = "ta_perf2_ytd20o"
        YTD_30_PERCENT = "ta_perf2_ytd30o"
        YTD_50_PERCENT = "ta_perf2_ytd50o"
        YTD_100_PERCENT = "ta_perf2_ytd100o"

    class VolatilityOption(ScreenerFilterOption, Enum):
        WEEK_OVER_3_PERCENT = "ta_volatility_wo3"
        WEEK_OVER_4_PERCENT = "ta_volatility_wo4"
        WEEK_OVER_5_PERCENT = "ta_volatility_wo5"
        WEEK_OVER_6_PERCENT = "ta_volatility_wo6"
        WEEK_OVER_7_PERCENT = "ta_volatility_wo7"
        WEEK_OVER_8_PERCENT = "ta_volatility_wo8"
        WEEK_OVER_9_PERCENT = "ta_volatility_wo9"
        WEEK_OVER_10_PERCENT = "ta_volatility_wo10"
        WEEK_OVER_12_PERCENT = "ta_volatility_wo12"
        WEEK_OVER_15_PERCENT = "ta_volatility_wo15"
        MONTH_OVER_2_PERCENT = "ta_volatility_mo2"
        MONTH_OVER_3_PERCENT = "ta_volatility_mo3"
        MONTH_OVER_4_PERCENT = "ta_volatility_mo4"
        MONTH_OVER_5_PERCENT = "ta_volatility_mo5"
        MONTH_OVER_6_PERCENT = "ta_volatility_mo6"
        MONTH_OVER_7_PERCENT = "ta_volatility_mo7"
        MONTH_OVER_8_PERCENT = "ta_volatility_mo8"
        MONTH_OVER_9_PERCENT = "ta_volatility_mo9"
        MONTH_OVER_10_PERCENT = "ta_volatility_mo10"
        MONTH_OVER_12_PERCENT = "ta_volatility_mo12"
        MONTH_OVER_15_PERCENT = "ta_volatility_mo15"

    class RSI14Option(ScreenerFilterOption, Enum):
        OVERBOUGHT_90 = "ta_rsi_ob90"
        OVERBOUGHT_80 = "ta_rsi_ob80"
        OVERBOUGHT_70 = "ta_rsi_ob70"
        OVERBOUGHT_60 = "ta_rsi_ob60"
        OVERSOLD_40 = "ta_rsi_os40"
        OVERSOLD_30 = "ta_rsi_os30"
        OVERSOLD_20 = "ta_rsi_os20"
        OVERSOLD_10 = "ta_rsi_os10"
        NOT_OVERBOUGHT_60 = "ta_rsi_nob60"
        NOT_OVERBOUGHT_50 = "ta_rsi_nob50"
        NOT_OVERSOLD_50 = "ta_rsi_nos50"
        NOT_OVERSOLD_40 = "ta_rsi_nos40"
        CUSTOM_ELITE_ONLY = "ta_rsi_range"

    class GapOption(ScreenerFilterOption, Enum):
        UP = "ta_gap_u"
        UP_0_PERCENT = "ta_gap_u0"
        UP_1_PERCENT = "ta_gap_u1"
        UP_2_PERCENT = "ta_gap_u2"
        UP_3_PERCENT = "ta_gap_u3"
        UP_4_PERCENT = "ta_gap_u4"
        UP_5_PERCENT = "ta_gap_u5"
        UP_6_PERCENT = "ta_gap_u6"
        UP_7_PERCENT = "ta_gap_u7"
        UP_8_PERCENT = "ta_gap_u8"
        UP_9_PERCENT = "ta_gap_u9"
        UP_10_PERCENT = "ta_gap_u10"
        UP_15_PERCENT = "ta_gap_u15"
        UP_20_PERCENT = "ta_gap_u20"
        DOWN = "ta_gap_d"
        DOWN_0_PERCENT = "ta_gap_d0"
        DOWN_1_PERCENT = "ta_gap_d1"
        DOWN_2_PERCENT = "ta_gap_d2"
        DOWN_3_PERCENT = "ta_gap_d3"
        DOWN_4_PERCENT = "ta_gap_d4"
        DOWN_5_PERCENT = "ta_gap_d5"
        DOWN_6_PERCENT = "ta_gap_d6"
        DOWN_7_PERCENT = "ta_gap_d7"
        DOWN_8_PERCENT = "ta_gap_d8"
        DOWN_9_PERCENT = "ta_gap_d9"
        DOWN_10_PERCENT = "ta_gap_d10"
        DOWN_15_PERCENT = "ta_gap_d15"
        DOWN_20_PERCENT = "ta_gap_d20"
        CUSTOM_ELITE_ONLY = "ta_gap_frange"

    class _20DaySimpleMovingAverageOption(ScreenerFilterOption, Enum):
        PRICE_BELOW_SMA20 = "ta_sma20_pb"
        PRICE_10_PERCENT_BELOW_SMA20 = "ta_sma20_pb10"
        PRICE_20_PERCENT_BELOW_SMA20 = "ta_sma20_pb20"
        PRICE_30_PERCENT_BELOW_SMA20 = "ta_sma20_pb30"
        PRICE_40_PERCENT_BELOW_SMA20 = "ta_sma20_pb40"
        PRICE_50_PERCENT_BELOW_SMA20 = "ta_sma20_pb50"
        PRICE_ABOVE_SMA20 = "ta_sma20_pa"
        PRICE_10_PERCENT_ABOVE_SMA20 = "ta_sma20_pa10"
        PRICE_20_PERCENT_ABOVE_SMA20 = "ta_sma20_pa20"
        PRICE_30_PERCENT_ABOVE_SMA20 = "ta_sma20_pa30"
        PRICE_40_PERCENT_ABOVE_SMA20 = "ta_sma20_pa40"
        PRICE_50_PERCENT_ABOVE_SMA20 = "ta_sma20_pa50"
        PRICE_CROSSED_SMA20 = "ta_sma20_pc"
        PRICE_CROSSED_SMA20_ABOVE = "ta_sma20_pca"
        PRICE_CROSSED_SMA20_BELOW = "ta_sma20_pcb"
        SMA20_CROSSED_SMA50 = "ta_sma20_cross50"
        SMA20_CROSSED_SMA50_ABOVE = "ta_sma20_cross50a"
        SMA20_CROSSED_SMA50_BELOW = "ta_sma20_cross50b"
        SMA20_CROSSED_SMA200 = "ta_sma20_cross200"
        SMA20_CROSSED_SMA200_ABOVE = "ta_sma20_cross200a"
        SMA20_CROSSED_SMA200_BELOW = "ta_sma20_cross200b"
        SMA20_ABOVE_SMA50 = "ta_sma20_sa50"
        SMA20_BELOW_SMA50 = "ta_sma20_sb50"
        SMA20_ABOVE_SMA200 = "ta_sma20_sa200"
        SMA20_BELOW_SMA200 = "ta_sma20_sb200"

    class _50DaySimpleMovingAverageOption(ScreenerFilterOption, Enum):
        PRICE_BELOW_SMA50 = "ta_sma50_pb"
        PRICE_10_PERCENT_BELOW_SMA50 = "ta_sma50_pb10"
        PRICE_20_PERCENT_BELOW_SMA50 = "ta_sma50_pb20"
        PRICE_30_PERCENT_BELOW_SMA50 = "ta_sma50_pb30"
        PRICE_40_PERCENT_BELOW_SMA50 = "ta_sma50_pb40"
        PRICE_50_PERCENT_BELOW_SMA50 = "ta_sma50_pb50"
        PRICE_ABOVE_SMA50 = "ta_sma50_pa"
        PRICE_10_PERCENT_ABOVE_SMA50 = "ta_sma50_pa10"
        PRICE_20_PERCENT_ABOVE_SMA50 = "ta_sma50_pa20"
        PRICE_30_PERCENT_ABOVE_SMA50 = "ta_sma50_pa30"
        PRICE_40_PERCENT_ABOVE_SMA50 = "ta_sma50_pa40"
        PRICE_50_PERCENT_ABOVE_SMA50 = "ta_sma50_pa50"
        PRICE_CROSSED_SMA50 = "ta_sma50_pc"
        PRICE_CROSSED_SMA50_ABOVE = "ta_sma50_pca"
        PRICE_CROSSED_SMA50_BELOW = "ta_sma50_pcb"
        SMA50_CROSSED_SMA20 = "ta_sma50_cross20"
        SMA50_CROSSED_SMA20_ABOVE = "ta_sma50_cross20a"
        SMA50_CROSSED_SMA20_BELOW = "ta_sma50_cross20b"
        SMA50_CROSSED_SMA200 = "ta_sma50_cross200"
        SMA50_CROSSED_SMA200_ABOVE = "ta_sma50_cross200a"
        SMA50_CROSSED_SMA200_BELOW = "ta_sma50_cross200b"
        SMA50_ABOVE_SMA20 = "ta_sma50_sa20"
        SMA50_BELOW_SMA20 = "ta_sma50_sb20"
        SMA50_ABOVE_SMA200 = "ta_sma50_sa200"
        SMA50_BELOW_SMA200 = "ta_sma50_sb200"

    class _200DaySimpleMovingAverageOption(ScreenerFilterOption, Enum):
        PRICE_BELOW_SMA200 = "ta_sma200_pb"
        PRICE_10_PERCENT_BELOW_SMA200 = "ta_sma200_pb10"
        PRICE_20_PERCENT_BELOW_SMA200 = "ta_sma200_pb20"
        PRICE_30_PERCENT_BELOW_SMA200 = "ta_sma200_pb30"
        PRICE_40_PERCENT_BELOW_SMA200 = "ta_sma200_pb40"
        PRICE_50_PERCENT_BELOW_SMA200 = "ta_sma200_pb50"
        PRICE_60_PERCENT_BELOW_SMA200 = "ta_sma200_pb60"
        PRICE_70_PERCENT_BELOW_SMA200 = "ta_sma200_pb70"
        PRICE_80_PERCENT_BELOW_SMA200 = "ta_sma200_pb80"
        PRICE_90_PERCENT_BELOW_SMA200 = "ta_sma200_pb90"
        PRICE_ABOVE_SMA200 = "ta_sma200_pa"
        PRICE_10_PERCENT_ABOVE_SMA200 = "ta_sma200_pa10"
        PRICE_20_PERCENT_ABOVE_SMA200 = "ta_sma200_pa20"
        PRICE_30_PERCENT_ABOVE_SMA200 = "ta_sma200_pa30"
        PRICE_40_PERCENT_ABOVE_SMA200 = "ta_sma200_pa40"
        PRICE_50_PERCENT_ABOVE_SMA200 = "ta_sma200_pa50"
        PRICE_60_PERCENT_ABOVE_SMA200 = "ta_sma200_pa60"
        PRICE_70_PERCENT_ABOVE_SMA200 = "ta_sma200_pa70"
        PRICE_80_PERCENT_ABOVE_SMA200 = "ta_sma200_pa80"
        PRICE_90_PERCENT_ABOVE_SMA200 = "ta_sma200_pa90"
        PRICE_100_PERCENT_ABOVE_SMA200 = "ta_sma200_pa100"
        PRICE_CROSSED_SMA200 = "ta_sma200_pc"
        PRICE_CROSSED_SMA200_ABOVE = "ta_sma200_pca"
        PRICE_CROSSED_SMA200_BELOW = "ta_sma200_pcb"
        SMA200_CROSSED_SMA20 = "ta_sma200_cross20"
        SMA200_CROSSED_SMA20_ABOVE = "ta_sma200_cross20a"
        SMA200_CROSSED_SMA20_BELOW = "ta_sma200_cross20b"
        SMA200_CROSSED_SMA50 = "ta_sma200_cross50"
        SMA200_CROSSED_SMA50_ABOVE = "ta_sma200_cross50a"
        SMA200_CROSSED_SMA50_BELOW = "ta_sma200_cross50b"
        SMA200_ABOVE_SMA20 = "ta_sma200_sa20"
        SMA200_BELOW_SMA20 = "ta_sma200_sb20"
        SMA200_ABOVE_SMA50 = "ta_sma200_sa50"
        SMA200_BELOW_SMA50 = "ta_sma200_sb50"

    class ChangeOption(ScreenerFilterOption, Enum):
        UP = "ta_change_u"
        UP_1_PERCENT = "ta_change_u1"
        UP_2_PERCENT = "ta_change_u2"
        UP_3_PERCENT = "ta_change_u3"
        UP_4_PERCENT = "ta_change_u4"
        UP_5_PERCENT = "ta_change_u5"
        UP_6_PERCENT = "ta_change_u6"
        UP_7_PERCENT = "ta_change_u7"
        UP_8_PERCENT = "ta_change_u8"
        UP_9_PERCENT = "ta_change_u9"
        UP_10_PERCENT = "ta_change_u10"
        UP_15_PERCENT = "ta_change_u15"
        UP_20_PERCENT = "ta_change_u20"
        DOWN = "ta_change_d"
        DOWN_1_PERCENT = "ta_change_d1"
        DOWN_2_PERCENT = "ta_change_d2"
        DOWN_3_PERCENT = "ta_change_d3"
        DOWN_4_PERCENT = "ta_change_d4"
        DOWN_5_PERCENT = "ta_change_d5"
        DOWN_6_PERCENT = "ta_change_d6"
        DOWN_7_PERCENT = "ta_change_d7"
        DOWN_8_PERCENT = "ta_change_d8"
        DOWN_9_PERCENT = "ta_change_d9"
        DOWN_10_PERCENT = "ta_change_d10"
        DOWN_15_PERCENT = "ta_change_d15"
        DOWN_20_PERCENT = "ta_change_d20"
        CUSTOM_ELITE_ONLY = "ta_change_frange"

    class ChangeFromOpenOption(ScreenerFilterOption, Enum):
        UP = "ta_changeopen_u"
        UP_1_PERCENT = "ta_changeopen_u1"
        UP_2_PERCENT = "ta_changeopen_u2"
        UP_3_PERCENT = "ta_changeopen_u3"
        UP_4_PERCENT = "ta_changeopen_u4"
        UP_5_PERCENT = "ta_changeopen_u5"
        UP_6_PERCENT = "ta_changeopen_u6"
        UP_7_PERCENT = "ta_changeopen_u7"
        UP_8_PERCENT = "ta_changeopen_u8"
        UP_9_PERCENT = "ta_changeopen_u9"
        UP_10_PERCENT = "ta_changeopen_u10"
        UP_15_PERCENT = "ta_changeopen_u15"
        UP_20_PERCENT = "ta_changeopen_u20"
        DOWN = "ta_changeopen_d"
        DOWN_1_PERCENT = "ta_changeopen_d1"
        DOWN_2_PERCENT = "ta_changeopen_d2"
        DOWN_3_PERCENT = "ta_changeopen_d3"
        DOWN_4_PERCENT = "ta_changeopen_d4"
        DOWN_5_PERCENT = "ta_changeopen_d5"
        DOWN_6_PERCENT = "ta_changeopen_d6"
        DOWN_7_PERCENT = "ta_changeopen_d7"
        DOWN_8_PERCENT = "ta_changeopen_d8"
        DOWN_9_PERCENT = "ta_changeopen_d9"
        DOWN_10_PERCENT = "ta_changeopen_d10"
        DOWN_15_PERCENT = "ta_changeopen_d15"
        DOWN_20_PERCENT = "ta_changeopen_d20"
        CUSTOM_ELITE_ONLY = "ta_changeopen_frange"

    class _20DayHighLowOption(ScreenerFilterOption, Enum):
        NEW_HIGH = "ta_highlow20d_nh"
        NEW_LOW = "ta_highlow20d_nl"
        _5_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b5h"
        _10_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b10h"
        _15_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b15h"
        _20_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b20h"
        _30_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b30h"
        _40_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b40h"
        _50_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow20d_b50h"
        _0_3_PERCENT_BELOW_HIGH = "ta_highlow20d_b0to3h"
        _0_5_PERCENT_BELOW_HIGH = "ta_highlow20d_b0to5h"
        _0_10_PERCENT_BELOW_HIGH = "ta_highlow20d_b0to10h"
        _5_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a5h"
        _10_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a10h"
        _15_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a15h"
        _20_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a20h"
        _30_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a30h"
        _40_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a40h"
        _50_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow20d_a50h"
        _0_3_PERCENT_ABOVE_LOW = "ta_highlow20d_a0to3h"
        _0_5_PERCENT_ABOVE_LOW = "ta_highlow20d_a0to5h"
        _0_10_PERCENT_ABOVE_LOW = "ta_highlow20d_a0to10h"

    class _50DayHighLowOption(ScreenerFilterOption, Enum):
        NEW_HIGH = "ta_highlow50d_nh"
        NEW_LOW = "ta_highlow50d_nl"
        _5_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b5h"
        _10_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b10h"
        _15_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b15h"
        _20_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b20h"
        _30_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b30h"
        _40_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b40h"
        _50_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow50d_b50h"
        _0_3_PERCENT_BELOW_HIGH = "ta_highlow50d_b0to3h"
        _0_5_PERCENT_BELOW_HIGH = "ta_highlow50d_b0to5h"
        _0_10_PERCENT_BELOW_HIGH = "ta_highlow50d_b0to10h"
        _5_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a5h"
        _10_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a10h"
        _15_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a15h"
        _20_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a20h"
        _30_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a30h"
        _40_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a40h"
        _50_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow50d_a50h"
        _0_3_PERCENT_ABOVE_LOW = "ta_highlow50d_a0to3h"
        _0_5_PERCENT_ABOVE_LOW = "ta_highlow50d_a0to5h"
        _0_10_PERCENT_ABOVE_LOW = "ta_highlow50d_a0to10h"

    class _52WeekHighLowOption(ScreenerFilterOption, Enum):
        NEW_HIGH = "ta_highlow52w_nh"
        NEW_LOW = "ta_highlow52w_nl"
        _5_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b5h"
        _10_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b10h"
        _15_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b15h"
        _20_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b20h"
        _30_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b30h"
        _40_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b40h"
        _50_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b50h"
        _60_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b60h"
        _70_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b70h"
        _80_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b80h"
        _90_PERCENT_OR_MORE_BELOW_HIGH = "ta_highlow52w_b90h"
        _0_3_PERCENT_BELOW_HIGH = "ta_highlow52w_b0to3h"
        _0_5_PERCENT_BELOW_HIGH = "ta_highlow52w_b0to5h"
        _0_10_PERCENT_BELOW_HIGH = "ta_highlow52w_b0to10h"
        _5_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a5h"
        _10_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a10h"
        _15_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a15h"
        _20_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a20h"
        _30_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a30h"
        _40_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a40h"
        _50_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a50h"
        _60_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a60h"
        _70_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a70h"
        _80_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a80h"
        _90_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a90h"
        _100_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a100h"
        _120_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a120h"
        _150_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a150h"
        _200_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a200h"
        _300_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a300h"
        _500_PERCENT_OR_MORE_ABOVE_LOW = "ta_highlow52w_a500h"
        _0_3_PERCENT_ABOVE_LOW = "ta_highlow52w_a0to3h"
        _0_5_PERCENT_ABOVE_LOW = "ta_highlow52w_a0to5h"
        _0_10_PERCENT_ABOVE_LOW = "ta_highlow52w_a0to10h"

    class PatternOption(ScreenerFilterOption, Enum):
        HORIZONTAL_S_R = "ta_pattern_horizontal"
        HORIZONTAL_S_R_STRONG = "ta_pattern_horizontal2"
        TL_RESISTANCE = "ta_pattern_tlresistance"
        TL_RESISTANCE_STRONG = "ta_pattern_tlresistance2"
        TL_SUPPORT = "ta_pattern_tlsupport"
        TL_SUPPORT_STRONG = "ta_pattern_tlsupport2"
        WEDGE_UP = "ta_pattern_wedgeup"
        WEDGE_UP_STRONG = "ta_pattern_wedgeup2"
        WEDGE_DOWN = "ta_pattern_wedgedown"
        WEDGE_DOWN_STRONG = "ta_pattern_wedgedown2"
        TRIANGLE_ASCENDING = "ta_pattern_wedgeresistance"
        TRIANGLE_ASCENDING_STRONG = "ta_pattern_wedgeresistance2"
        TRIANGLE_DESCENDING = "ta_pattern_wedgesupport"
        TRIANGLE_DESCENDING_STRONG = "ta_pattern_wedgesupport2"
        WEDGE = "ta_pattern_wedge"
        WEDGE_STRONG = "ta_pattern_wedge2"
        CHANNEL_UP = "ta_pattern_channelup"
        CHANNEL_UP_STRONG = "ta_pattern_channelup2"
        CHANNEL_DOWN = "ta_pattern_channeldown"
        CHANNEL_DOWN_STRONG = "ta_pattern_channeldown2"
        CHANNEL = "ta_pattern_channel"
        CHANNEL_STRONG = "ta_pattern_channel2"
        DOUBLE_TOP = "ta_pattern_doubletop"
        DOUBLE_BOTTOM = "ta_pattern_doublebottom"
        MULTIPLE_TOP = "ta_pattern_multipletop"
        MULTIPLE_BOTTOM = "ta_pattern_multiplebottom"
        HEAD_AND_SHOULDERS = "ta_pattern_headandshoulders"
        HEAD_AND_SHOULDERS_INVERSE = "ta_pattern_headandshouldersinv"
        CUSTOM_ELITE_ONLY = "ta_pattern_modal"

    class CandlestickOption(ScreenerFilterOption, Enum):
        LONG_LOWER_SHADOW = "ta_candlestick_lls"
        LONG_UPPER_SHADOW = "ta_candlestick_lus"
        HAMMER = "ta_candlestick_h"
        INVERTED_HAMMER = "ta_candlestick_ih"
        SPINNING_TOP_WHITE = "ta_candlestick_stw"
        SPINNING_TOP_BLACK = "ta_candlestick_stb"
        DOJI = "ta_candlestick_d"
        DRAGONFLY_DOJI = "ta_candlestick_dd"
        GRAVESTONE_DOJI = "ta_candlestick_gd"
        MARUBOZU_WHITE = "ta_candlestick_mw"
        MARUBOZU_BLACK = "ta_candlestick_mb"
        CUSTOM_ELITE_ONLY = "ta_candlestick_modal"

    class BetaOption(ScreenerFilterOption, Enum):
        UNDER_0 = "ta_beta_u0"
        UNDER_0_5 = "ta_beta_u0.5"
        UNDER_1 = "ta_beta_u1"
        UNDER_1_5 = "ta_beta_u1.5"
        UNDER_2 = "ta_beta_u2"
        OVER_0 = "ta_beta_o0"
        OVER_0_5 = "ta_beta_o0.5"
        OVER_1 = "ta_beta_o1"
        OVER_1_5 = "ta_beta_o1.5"
        OVER_2 = "ta_beta_o2"
        OVER_2_5 = "ta_beta_o2.5"
        OVER_3 = "ta_beta_o3"
        OVER_4 = "ta_beta_o4"
        _0_TO_0_5 = "ta_beta_0to0.5"
        _0_TO_1 = "ta_beta_0to1"
        _0_5_TO_1 = "ta_beta_0.5to1"
        _0_5_TO_1_5 = "ta_beta_0.5to1.5"
        _1_TO_1_5 = "ta_beta_1to1.5"
        _1_TO_2 = "ta_beta_1to2"
        CUSTOM_ELITE_ONLY = "ta_beta_frange"

    class AverageTrueRangeOption(ScreenerFilterOption, Enum):
        OVER_0_25 = "ta_averagetruerange_o0.25"
        OVER_0_5 = "ta_averagetruerange_o0.5"
        OVER_0_75 = "ta_averagetruerange_o0.75"
        OVER_1 = "ta_averagetruerange_o1"
        OVER_1_5 = "ta_averagetruerange_o1.5"
        OVER_2 = "ta_averagetruerange_o2"
        OVER_2_5 = "ta_averagetruerange_o2.5"
        OVER_3 = "ta_averagetruerange_o3"
        OVER_3_5 = "ta_averagetruerange_o3.5"
        OVER_4 = "ta_averagetruerange_o4"
        OVER_4_5 = "ta_averagetruerange_o4.5"
        OVER_5 = "ta_averagetruerange_o5"
        UNDER_0_25 = "ta_averagetruerange_u0.25"
        UNDER_0_5 = "ta_averagetruerange_u0.5"
        UNDER_0_75 = "ta_averagetruerange_u0.75"
        UNDER_1 = "ta_averagetruerange_u1"
        UNDER_1_5 = "ta_averagetruerange_u1.5"
        UNDER_2 = "ta_averagetruerange_u2"
        UNDER_2_5 = "ta_averagetruerange_u2.5"
        UNDER_3 = "ta_averagetruerange_u3"
        UNDER_3_5 = "ta_averagetruerange_u3.5"
        UNDER_4 = "ta_averagetruerange_u4"
        UNDER_4_5 = "ta_averagetruerange_u4.5"
        UNDER_5 = "ta_averagetruerange_u5"
        CUSTOM_ELITE_ONLY = "ta_averagetruerange_frange"

    class AverageVolumeOption(ScreenerFilterOption, Enum):
        UNDER_50K = "sh_avgvol_u50"
        UNDER_100K = "sh_avgvol_u100"
        UNDER_500K = "sh_avgvol_u500"
        UNDER_750K = "sh_avgvol_u750"
        UNDER_1M = "sh_avgvol_u1000"
        OVER_50K = "sh_avgvol_o50"
        OVER_100K = "sh_avgvol_o100"
        OVER_200K = "sh_avgvol_o200"
        OVER_300K = "sh_avgvol_o300"
        OVER_400K = "sh_avgvol_o400"
        OVER_500K = "sh_avgvol_o500"
        OVER_750K = "sh_avgvol_o750"
        OVER_1M = "sh_avgvol_o1000"
        OVER_2M = "sh_avgvol_o2000"
        _100K_TO_500K = "sh_avgvol_100to500"
        _100K_TO_1M = "sh_avgvol_100to1000"
        _500K_TO_1M = "sh_avgvol_500to1000"
        _500K_TO_10M = "sh_avgvol_500to10000"
        CUSTOM_ELITE_ONLY = "sh_avgvol_range"

    class RelativeVolumeOption(ScreenerFilterOption, Enum):
        OVER_10 = "sh_relvol_o10"
        OVER_5 = "sh_relvol_o5"
        OVER_3 = "sh_relvol_o3"
        OVER_2 = "sh_relvol_o2"
        OVER_1_5 = "sh_relvol_o1.5"
        OVER_1 = "sh_relvol_o1"
        OVER_0_75 = "sh_relvol_o0.75"
        OVER_0_5 = "sh_relvol_o0.5"
        OVER_0_25 = "sh_relvol_o0.25"
        UNDER_2 = "sh_relvol_u2"
        UNDER_1_5 = "sh_relvol_u1.5"
        UNDER_1 = "sh_relvol_u1"
        UNDER_0_75 = "sh_relvol_u0.75"
        UNDER_0_5 = "sh_relvol_u0.5"
        UNDER_0_25 = "sh_relvol_u0.25"
        UNDER_0_1 = "sh_relvol_u0.1"
        CUSTOM_ELITE_ONLY = "sh_relvol_frange"

    class CurrentVolumeOption(ScreenerFilterOption, Enum):
        UNDER_50K = "sh_curvol_u50"
        UNDER_100K = "sh_curvol_u100"
        UNDER_500K = "sh_curvol_u500"
        UNDER_750K = "sh_curvol_u750"
        UNDER_1M = "sh_curvol_u1000"
        OVER_0 = "sh_curvol_o0"
        OVER_50K = "sh_curvol_o50"
        OVER_100K = "sh_curvol_o100"
        OVER_200K = "sh_curvol_o200"
        OVER_300K = "sh_curvol_o300"
        OVER_400K = "sh_curvol_o400"
        OVER_500K = "sh_curvol_o500"
        OVER_750K = "sh_curvol_o750"
        OVER_1M = "sh_curvol_o1000"
        OVER_2M = "sh_curvol_o2000"
        OVER_5M = "sh_curvol_o5000"
        OVER_10M = "sh_curvol_o10000"
        OVER_20M = "sh_curvol_o20000"
        CUSTOM_ELITE_ONLY = "sh_curvol_range"

    class PriceOption(ScreenerFilterOption, Enum):
        UNDER_USD1 = "sh_price_u1"
        UNDER_USD2 = "sh_price_u2"
        UNDER_USD3 = "sh_price_u3"
        UNDER_USD4 = "sh_price_u4"
        UNDER_USD5 = "sh_price_u5"
        UNDER_USD7 = "sh_price_u7"
        UNDER_USD10 = "sh_price_u10"
        UNDER_USD15 = "sh_price_u15"
        UNDER_USD20 = "sh_price_u20"
        UNDER_USD30 = "sh_price_u30"
        UNDER_USD40 = "sh_price_u40"
        UNDER_USD50 = "sh_price_u50"
        OVER_USD1 = "sh_price_o1"
        OVER_USD2 = "sh_price_o2"
        OVER_USD3 = "sh_price_o3"
        OVER_USD4 = "sh_price_o4"
        OVER_USD5 = "sh_price_o5"
        OVER_USD7 = "sh_price_o7"
        OVER_USD10 = "sh_price_o10"
        OVER_USD15 = "sh_price_o15"
        OVER_USD20 = "sh_price_o20"
        OVER_USD30 = "sh_price_o30"
        OVER_USD40 = "sh_price_o40"
        OVER_USD50 = "sh_price_o50"
        OVER_USD60 = "sh_price_o60"
        OVER_USD70 = "sh_price_o70"
        OVER_USD80 = "sh_price_o80"
        OVER_USD90 = "sh_price_o90"
        OVER_USD100 = "sh_price_o100"
        USD1_TO_5 = "sh_price_1to5"
        USD1_TO_10 = "sh_price_1to10"
        USD1_TO_20 = "sh_price_1to20"
        USD5_TO_10 = "sh_price_5to10"
        USD5_TO_20 = "sh_price_5to20"
        USD5_TO_50 = "sh_price_5to50"
        USD10_TO_20 = "sh_price_10to20"
        USD10_TO_50 = "sh_price_10to50"
        USD20_TO_50 = "sh_price_20to50"
        USD50_TO_100 = "sh_price_50to100"
        CUSTOM_ELITE_ONLY = "sh_price_range"

    class TargetPriceOption(ScreenerFilterOption, Enum):
        _50_PERCENT_ABOVE_PRICE = "targetprice_a50"
        _40_PERCENT_ABOVE_PRICE = "targetprice_a40"
        _30_PERCENT_ABOVE_PRICE = "targetprice_a30"
        _20_PERCENT_ABOVE_PRICE = "targetprice_a20"
        _10_PERCENT_ABOVE_PRICE = "targetprice_a10"
        _5_PERCENT_ABOVE_PRICE = "targetprice_a5"
        ABOVE_PRICE = "targetprice_above"
        BELOW_PRICE = "targetprice_below"
        _5_PERCENT_BELOW_PRICE = "targetprice_b5"
        _10_PERCENT_BELOW_PRICE = "targetprice_b10"
        _20_PERCENT_BELOW_PRICE = "targetprice_b20"
        _30_PERCENT_BELOW_PRICE = "targetprice_b30"
        _40_PERCENT_BELOW_PRICE = "targetprice_b40"
        _50_PERCENT_BELOW_PRICE = "targetprice_b50"

    class IPODateOption(ScreenerFilterOption, Enum):
        TODAY = "ipodate_today"
        YESTERDAY = "ipodate_yesterday"
        IN_THE_LAST_WEEK = "ipodate_prevweek"
        IN_THE_LAST_MONTH = "ipodate_prevmonth"
        IN_THE_LAST_QUARTER = "ipodate_prevquarter"
        IN_THE_LAST_YEAR = "ipodate_prevyear"
        IN_THE_LAST_2_YEARS = "ipodate_prev2yrs"
        IN_THE_LAST_3_YEARS = "ipodate_prev3yrs"
        IN_THE_LAST_5_YEARS = "ipodate_prev5yrs"
        MORE_THAN_A_YEAR_AGO = "ipodate_more1"
        MORE_THAN_5_YEARS_AGO = "ipodate_more5"
        MORE_THAN_10_YEARS_AGO = "ipodate_more10"
        MORE_THAN_15_YEARS_AGO = "ipodate_more15"
        MORE_THAN_20_YEARS_AGO = "ipodate_more20"
        MORE_THAN_25_YEARS_AGO = "ipodate_more25"

    class SharesOutstandingOption(ScreenerFilterOption, Enum):
        UNDER_1M = "sh_outstanding_u1"
        UNDER_5M = "sh_outstanding_u5"
        UNDER_10M = "sh_outstanding_u10"
        UNDER_20M = "sh_outstanding_u20"
        UNDER_50M = "sh_outstanding_u50"
        UNDER_100M = "sh_outstanding_u100"
        OVER_1M = "sh_outstanding_o1"
        OVER_2M = "sh_outstanding_o2"
        OVER_5M = "sh_outstanding_o5"
        OVER_10M = "sh_outstanding_o10"
        OVER_20M = "sh_outstanding_o20"
        OVER_50M = "sh_outstanding_o50"
        OVER_100M = "sh_outstanding_o100"
        OVER_200M = "sh_outstanding_o200"
        OVER_500M = "sh_outstanding_o500"
        OVER_1000M = "sh_outstanding_o1000"
        CUSTOM_ELITE_ONLY = "sh_outstanding_range"

    class FloatOption(ScreenerFilterOption, Enum):
        UNDER_1M = "sh_float_u1"
        UNDER_5M = "sh_float_u5"
        UNDER_10M = "sh_float_u10"
        UNDER_20M = "sh_float_u20"
        UNDER_50M = "sh_float_u50"
        UNDER_100M = "sh_float_u100"
        OVER_1M = "sh_float_o1"
        OVER_2M = "sh_float_o2"
        OVER_5M = "sh_float_o5"
        OVER_10M = "sh_float_o10"
        OVER_20M = "sh_float_o20"
        OVER_50M = "sh_float_o50"
        OVER_100M = "sh_float_o100"
        OVER_200M = "sh_float_o200"
        OVER_500M = "sh_float_o500"
        OVER_1000M = "sh_float_o1000"
        CUSTOM_ELITE_ONLY = "sh_float_range"

    class AfterHoursCloseOption(ScreenerFilterOption, Enum):
        CUSTOM_ELITE_ONLY = "ah_close_range"

    class AfterHoursChangeOption(ScreenerFilterOption, Enum):
        CUSTOM_ELITE_ONLY = "ah_change_frange"

    class ViewOption(Enum):
        OVERVIEW = "111"
        VALUATION = "121"
        FINANCIAL = "161"
        OWNERSHIP = "131"
        PERFORMANCE = "141"
        TECHNICAL = "171"
        CUSTOM = "151"

    @staticmethod
    def page_number(n: int):
        """
        :param n: number you see on page (e.g. page 2)
        :return: number that appears on url when you press the link (e.g. you press 2, but url shows r=21, [(2-1) * 20] + 1
        """
        return str((n - 1) * 20 + 1)

    @staticmethod
    def fetch(filter_options: List[ScreenerFilterOption] = None,
              view_option: ViewOption = ViewOption.OVERVIEW, pages=None):

        if filter_options is None:
            filter_options = []

        if pages is None:
            pages = [1]

        main_url = "https://finviz.com/screener.ashx?ft=4&v=" + view_option.value + "&f="
        # check if the same enum was used twice
        enums = {}
        for e in filter_options:
            enums[e.__class__.__name__] = e

        f_str = ""
        for key in enums:
            e = enums[key]
            f_str += (e.value + " ")

        main_url += f_str.strip().replace(" ", ",") + "&r="

        main_dataframe = WebScraper.get_single_table_pandas(main_url + Screener.page_number(pages[0]))
        for page_number in pages[1:]:
            url_ = main_url + Screener.page_number(page_number)
            main_dataframe = WebScraper.get_single_table_pandas(url_, main_dataframe)

        return main_dataframe
