# AUTOGENERATED! DO NOT EDIT! File to edit: 05_report.ipynb (unless otherwise specified).

__all__ = ['plot_ch', 'ch_report', 'timefreq_report', 'coherence_report']

# Cell
from cognify import dataset, spectra
import pandas as pd
import mne
import matplotlib.pyplot as plt
import numpy as np
from mne.time_frequency import psd_array_welch, tfr_array_multitaper
from scipy.signal import morlet

# Cell
def plot_ch(ch, sfreq, name, method='welch', window_sec=2):
    time = np.arange(ch.size) / sfreq
#     n_per_seg = window_sec * sfreq
    psd, freqs = psd_array_welch(ch, sfreq)

    fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(30, 3))

    ax1.plot(time, ch, lw=1.5, label=name)
    ax1.set_xlabel('Time (s)')
    ax1.set_ylabel('Amplitude (µV)')
    ax1.set_title(f'Raw voltage activity')
    ax1.set_xlim([time.min(), time.max()])
    ax1.legend()

    ax2.plot(freqs, psd, label=name)
    ax2.set_xlabel('Frequency (Hz)')
    ax2.set_ylabel('Power Spectral Density (V²/Hz)')
    ax2.set_title(f'{method} periodogram')
    ax2.set_ylim([0, psd.max() * 1.1])
    ax2.set_xlim([0, freqs.max()])
    ax2.legend()

# Cell
def ch_report(raw):
    sfreq = raw.info['sfreq']
    [plot_ch(ch, sfreq, n) for ch, n in zip(raw.get_data(), raw.ch_names)]

# Cell
def timefreq_report(epochs, baseline=None, log=False):
    mode = 'logratio' if log else 'mean'
    power, itc = spectra.calc_tfr(epochs, log=log)
    power.plot_topo(baseline=baseline, mode=mode, title='Average Power');
    itc.plot_topo(baseline=baseline, mode=mode, title='Inter-Trial coherence');

# Cell
def coherence_report(epochs, freqs, mode='csd'):
    csd = spectra.calc_csd(epochs, freqs)
    csd.mean().plot(mode=mode);
    csd.plot(mode=mode);