from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="TAAAccept")


@attr.s(auto_attribs=True)
class TAAAccept:
    """
    Attributes:
        mechanism (Union[Unset, str]):
        text (Union[Unset, str]):
        version (Union[Unset, str]):
    """

    mechanism: Union[Unset, str] = UNSET
    text: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        mechanism = self.mechanism
        text = self.text
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if mechanism is not UNSET:
            field_dict["mechanism"] = mechanism
        if text is not UNSET:
            field_dict["text"] = text
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        mechanism = d.pop("mechanism", UNSET)

        text = d.pop("text", UNSET)

        version = d.pop("version", UNSET)

        taa_accept = cls(
            mechanism=mechanism,
            text=text,
            version=version,
        )

        taa_accept.additional_properties = d
        return taa_accept

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
