from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="LinkedDataProof")


@attr.s(auto_attribs=True)
class LinkedDataProof:
    """
    Attributes:
        created (str): The string value of an ISO8601 combined date and time string generated by the Signature Algorithm
            Example: 2021-12-31 23:59:59+00:00.
        proof_purpose (str): Proof purpose Example: assertionMethod.
        type (str): Identifies the digital signature suite that was used to create the signature Example:
            Ed25519Signature2018.
        verification_method (str): Information used for proof verification Example:
            did:key:z6Mkgg342Ycpuk263R9d8Aq6MUaxPn1DDeHyGo38EefXmgDL#z6Mkgg342Ycpuk263R9d8Aq6MUaxPn1DDeHyGo38EefXmgDL.
        challenge (Union[Unset, str]): Associates a challenge with a proof, for use with a proofPurpose such as
            authentication Example: 3fa85f64-5717-4562-b3fc-2c963f66afa6.
        domain (Union[Unset, str]): A string value specifying the restricted domain of the signature. Example:
            example.com.
        jws (Union[Unset, str]): Associates a Detached Json Web Signature with a proof Example:
            eyJhbGciOiAiRWREUc2UsICJjcml0IjogWyJiNjQiXX0..lKJU0Df_keblRKhZAS9Qq6zybm-
            HqUXNVZ8vgEPNTAjQ1Ch6YBKY7UBAjg6iBX5qBQ.
        nonce (Union[Unset, str]): The nonce Example:
            CF69iO3nfvqRsRBNElE8b4wO39SyJHPM7Gg1nExltW5vSfQA1lvDCR/zXX1To0/4NLo==.
        proof_value (Union[Unset, str]): The proof value of a proof Example: sy1AahqbzJQ63n9RtekmwzqZeVj494VppdAVJBnMYrT
            wft6cLJJGeTSSxCCJ6HKnRtwE7jjDh6sB2z2AAiZY9BBnCD8wUVgwqH3qchGRCuC2RugA4eQ9fUrR4Yuycac3caiaaay.
    """

    created: str
    proof_purpose: str
    type: str
    verification_method: str
    challenge: Union[Unset, str] = UNSET
    domain: Union[Unset, str] = UNSET
    jws: Union[Unset, str] = UNSET
    nonce: Union[Unset, str] = UNSET
    proof_value: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        created = self.created
        proof_purpose = self.proof_purpose
        type = self.type
        verification_method = self.verification_method
        challenge = self.challenge
        domain = self.domain
        jws = self.jws
        nonce = self.nonce
        proof_value = self.proof_value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "created": created,
                "proofPurpose": proof_purpose,
                "type": type,
                "verificationMethod": verification_method,
            }
        )
        if challenge is not UNSET:
            field_dict["challenge"] = challenge
        if domain is not UNSET:
            field_dict["domain"] = domain
        if jws is not UNSET:
            field_dict["jws"] = jws
        if nonce is not UNSET:
            field_dict["nonce"] = nonce
        if proof_value is not UNSET:
            field_dict["proofValue"] = proof_value

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        created = d.pop("created")

        proof_purpose = d.pop("proofPurpose")

        type = d.pop("type")

        verification_method = d.pop("verificationMethod")

        challenge = d.pop("challenge", UNSET)

        domain = d.pop("domain", UNSET)

        jws = d.pop("jws", UNSET)

        nonce = d.pop("nonce", UNSET)

        proof_value = d.pop("proofValue", UNSET)

        linked_data_proof = cls(
            created=created,
            proof_purpose=proof_purpose,
            type=type,
            verification_method=verification_method,
            challenge=challenge,
            domain=domain,
            jws=jws,
            nonce=nonce,
            proof_value=proof_value,
        )

        linked_data_proof.additional_properties = d
        return linked_data_proof

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
