"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-stepfunctions-integ');
const sum = new sfn.Task(stack, 'Sum', {
    task: new tasks.EvaluateExpression({
        expression: '$.a + $.b',
    }),
    resultPath: '$.c'
});
const multiply = new sfn.Task(stack, 'Multiply', {
    task: new tasks.EvaluateExpression({
        expression: '$.c * 2'
    }),
    resultPath: '$.waitSeconds'
});
new sfn.StateMachine(stack, 'StateMachine', {
    definition: sum
        .next(multiply)
        .next(new sfn.Wait(stack, 'Wait', {
        time: sfn.WaitTime.secondsPath('$.waitSeconds')
    })),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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