"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
const emr_create_cluster_1 = require("./emr-create-cluster");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: [
                        'elasticmapreduce:ModifyInstanceGroups',
                        'elasticmapreduce:ListInstanceGroups'
                    ],
                    resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`]
                })
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup)
            }
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
(function (EmrModifyInstanceGroupByName) {
    /**
     * Render the InstanceResizePolicyProperty to JSON
     *
     * @param property
     */
    function InstanceResizePolicyPropertyToJson(property) {
        var _a;
        return {
            InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
            InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
            InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds())
        };
    }
    EmrModifyInstanceGroupByName.InstanceResizePolicyPropertyToJson = InstanceResizePolicyPropertyToJson;
    /**
     * Render the ShrinkPolicyProperty to JSON
     *
     * @param property
     */
    function ShrinkPolicyPropertyToJson(property) {
        var _a;
        return {
            DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
            InstanceResizePolicy: (property.instanceResizePolicy === undefined) ?
                property.instanceResizePolicy :
                InstanceResizePolicyPropertyToJson(property.instanceResizePolicy)
        };
    }
    EmrModifyInstanceGroupByName.ShrinkPolicyPropertyToJson = ShrinkPolicyPropertyToJson;
    /**
     * Render the InstanceGroupModifyConfigPropety to JSON
     *
     * @param property
     */
    function InstanceGroupModifyConfigPropertyToJson(property) {
        return {
            Configurations: cdk.listMapper(emr_create_cluster_1.EmrCreateCluster.ConfigurationPropertyToJson)(property.configurations),
            EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
            InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
            ShrinkPolicy: (property.shrinkPolicy === undefined) ?
                property.shrinkPolicy :
                ShrinkPolicyPropertyToJson(property.shrinkPolicy)
        };
    }
    EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
})(EmrModifyInstanceGroupByName = exports.EmrModifyInstanceGroupByName || (exports.EmrModifyInstanceGroupByName = {}));
//# sourceMappingURL=data:application/json;base64,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