setuplib
========

The *setuplib* package provides core functions for the query of meta information 
and installation repositories of *Python* packages. It provides query and filter 
options on the installed packages and the available information, while displaying
the result data in various formats, e.g. as table, list, or JSON, XML, YAML,
CSV, etc.

The provided commands and extension points integrate seamless into the standard
*setuptools* and/or *distutils*. The *setuplib* is member of the group *setuplib*
of extension components for the common *setup.py* installer. 

The targeted users are mainly developers, advanced users, and system administrators.

**Online documentation**:

* https://setuplib.sourceforge.io/

**Runtime-Repository**:

* PyPI: https://pypi.org/project/setuplib/

  Install: *pip install setuplib*, see also section 'Install' of the online documentation.


**Downloads**:

* sourceforge.net: https://sourceforge.net/projects/setuplib/files/

* bitbucket.org: https://bitbucket.org/acue/setuplib

* github.com: https://github.com/ArnoCan/setuplib/

* pypi.org: https://pypi.org/project/setuplib/


Project Data
------------

* PROJECT: 'setuplib'

* MISSION: Support library functions for extensions and entry points of setuptools / distutils.

* VERSION: 00.01

* RELEASE: 00.01.008

* STATUS: beta

* AUTHOR: Arno-Can Uestuensoez

* COPYRIGHT: Copyright (C) 2019 Arno-Can Uestuensoez @Ingenieurbuero Arno-Can Uestuensoez

* LICENSE: Artistic-License-2.0 + Forced-Fairplay-Constraints

Concepts and enumeration values are migrated from the 

* *UnifiedSessionsManager* (C) 2008 Arno-Can Uestuensoez @Ingenieurbuero Arno-Can Uestuensoez.  

Runtime Environment
-------------------
For a comprehensive list refer to the documentation.

**Python Syntax Support**

*  Python2.7, and Python3

**Python Implementation Support**

*  CPython, IPython, IronPython, Jython, and PyPy

**OS on Server, Workstation, Laptops, Virtual Machines, and Containers**

* Linux: AlpineLinux, ArchLinux, CentOS, Debian, Fedora, Gentoo, OpenSUSE, Raspbian, RHEL, Slackware, SLES, Ubuntu, ...  

* BSD: DragonFlyBSD, FreeBSD, NetBSD, OpenBSD, GhostBSD, TrueOS, NomadBSD

* OS-X: Snow Leopard

* Windows: Win10, Win8.1, Win7, WinXP, Win2019, Win2016, Win2012, Win2008, Win2000

* WSL-1.0: Alpine, Debian, KaliLinux, openSUSE, SLES, Ubuntu

* Cygwin

* UNIX: Solaris10, Solaris11

* Minix: Minix3

* ReactOS

**Network and Security**

* Network Devices: OpenWRT

* Security: KaliLinux, pfSense

**OS on Embedded Devices**

* RaspberryPI: ArchLinux, CentOS, OpenBSD, OpenWRT, Raspbian

* ASUS-TinkerBoard: Armbian

**Creation of Special Deployment Packages**

* MicroPython: CircuitPython, MicroPython

Current Release
---------------

REMARK:
   Currently tested by application to the other projects of the author.
   So for now no package tests defined.

Major Changes:

* Initial version.

ToDo:

* Clipping in table layout

* Deployment to remote MicroPython, and CircuitPython

