# coding: utf-8

"""
    TTS documentation

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from speechpro.cloud.speech.synthesis.rest.cloud_client.cloud_api_client import CloudApiClient


class Synthesize(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = CloudApiClient()
        self.api_client = api_client

    def language_voices_support(self, x_session_id, **kwargs):  # noqa: E501
        """Available languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.language_voices_support(x_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :return: list[SynthesizeLanguage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.language_voices_support_with_http_info(x_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.language_voices_support_with_http_info(x_session_id, **kwargs)  # noqa: E501
            return data

    def language_voices_support_with_http_info(self, x_session_id, **kwargs):  # noqa: E501
        """Available languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.language_voices_support_with_http_info(x_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :return: list[SynthesizeLanguage]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_session_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method language_voices_support" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_session_id' is set
        if ('x_session_id' not in params or
                params['x_session_id'] is None):
            raise ValueError("Missing the required parameter `x_session_id` when calling `language_voices_support`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_session_id' in params:
            header_params['X-Session-ID'] = params['x_session_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/languages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SynthesizeLanguage]',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def synthesize(self, x_session_id, body, **kwargs):  # noqa: E501
        """Synthesize speech from text  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.synthesize(x_session_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param SynthesizeRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: SynthesizeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.synthesize_with_http_info(x_session_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.synthesize_with_http_info(x_session_id, body, **kwargs)  # noqa: E501
            return data

    def synthesize_with_http_info(self, x_session_id, body, **kwargs):  # noqa: E501
        """Synthesize speech from text  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.synthesize_with_http_info(x_session_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param SynthesizeRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: SynthesizeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_session_id', 'body', 'x_request_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method synthesize" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_session_id' is set
        if ('x_session_id' not in params or
                params['x_session_id'] is None):
            raise ValueError("Missing the required parameter `x_session_id` when calling `synthesize`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `synthesize`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_session_id' in params:
            header_params['X-Session-ID'] = params['x_session_id']  # noqa: E501
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/synthesize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SynthesizeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def synthesize_sessionless(self, body, **kwargs):  # noqa: E501
        """Synthesize speech from text without session  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.synthesize_sessionless(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param SynthesizeSessionlessRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: SynthesizeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.synthesize_sessionless_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.synthesize_sessionless_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def synthesize_sessionless_with_http_info(self, body, **kwargs):  # noqa: E501
        """Synthesize speech from text without session  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.synthesize_sessionless_with_http_info(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param SynthesizeSessionlessRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: SynthesizeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_request_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method synthesize_sessionless" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `synthesize_sessionless`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/synthesize/sessionless', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SynthesizeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def voices(self, x_session_id, language, **kwargs):  # noqa: E501
        """Available languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.voices(x_session_id, language, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param str language: Language name (required)
        :return: list[SynthesizeVoiceType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.voices_with_http_info(x_session_id, language, **kwargs)  # noqa: E501
        else:
            (data) = self.voices_with_http_info(x_session_id, language, **kwargs)  # noqa: E501
            return data

    def voices_with_http_info(self, x_session_id, language, **kwargs):  # noqa: E501
        """Available languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.voices_with_http_info(x_session_id, language, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param str language: Language name (required)
        :return: list[SynthesizeVoiceType]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_session_id', 'language']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method voices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_session_id' is set
        if ('x_session_id' not in params or
                params['x_session_id'] is None):
            raise ValueError("Missing the required parameter `x_session_id` when calling `voices`")  # noqa: E501
        # verify the required parameter 'language' is set
        if ('language' not in params or
                params['language'] is None):
            raise ValueError("Missing the required parameter `language` when calling `voices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'language' in params:
            path_params['language'] = params['language']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_session_id' in params:
            header_params['X-Session-ID'] = params['x_session_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/languages/{language}/voices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SynthesizeVoiceType]',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def web_socket_stream(self, x_session_id, body, **kwargs):  # noqa: E501
        """Get websocket connection param  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.web_socket_stream(x_session_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param WebSocketSynthesizeRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: WebSocketServerConfigurationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.web_socket_stream_with_http_info(x_session_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.web_socket_stream_with_http_info(x_session_id, body, **kwargs)  # noqa: E501
            return data

    def web_socket_stream_with_http_info(self, x_session_id, body, **kwargs):  # noqa: E501
        """Get websocket connection param  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.web_socket_stream_with_http_info(x_session_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param WebSocketSynthesizeRequest body: Synthesize param (required)
        :param str x_request_id: Request identifier
        :return: WebSocketServerConfigurationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_session_id', 'body', 'x_request_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method web_socket_stream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_session_id' is set
        if ('x_session_id' not in params or
                params['x_session_id'] is None):
            raise ValueError("Missing the required parameter `x_session_id` when calling `web_socket_stream`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `web_socket_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_session_id' in params:
            header_params['X-Session-ID'] = params['x_session_id']  # noqa: E501
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/synthesize/stream', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebSocketServerConfigurationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def web_socket_stream_0(self, x_session_id, x_transaction_id, **kwargs):  # noqa: E501
        """Close transaction  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.web_socket_stream_0(x_session_id, x_transaction_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param str x_transaction_id: Transaction identifier (required)
        :return: CloseTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.web_socket_stream_0_with_http_info(x_session_id, x_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.web_socket_stream_0_with_http_info(x_session_id, x_transaction_id, **kwargs)  # noqa: E501
            return data

    def web_socket_stream_0_with_http_info(self, x_session_id, x_transaction_id, **kwargs):  # noqa: E501
        """Close transaction  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.web_socket_stream_0_with_http_info(x_session_id, x_transaction_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_session_id: Session identifier (required)
        :param str x_transaction_id: Transaction identifier (required)
        :return: CloseTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_session_id', 'x_transaction_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method web_socket_stream_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_session_id' is set
        if ('x_session_id' not in params or
                params['x_session_id'] is None):
            raise ValueError("Missing the required parameter `x_session_id` when calling `web_socket_stream_0`")  # noqa: E501
        # verify the required parameter 'x_transaction_id' is set
        if ('x_transaction_id' not in params or
                params['x_transaction_id'] is None):
            raise ValueError("Missing the required parameter `x_transaction_id` when calling `web_socket_stream_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_session_id' in params:
            header_params['X-Session-ID'] = params['x_session_id']  # noqa: E501
        if 'x_transaction_id' in params:
            header_params['X-Transaction-Id'] = params['x_transaction_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/vktts/rest/v1/synthesize/stream', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloseTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
