"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk8s_1 = require("cdk8s");
const lib_1 = require("../lib");
const globals_1 = require("@jest/globals");
globals_1.test('minimal configuration', () => {
    // GIVEN
    const app = cdk8s_1.Testing.app();
    const chart = new cdk8s_1.Chart(app, 'test');
    // WHEN
    new lib_1.Flux(chart, 'flux', {
        ns: 'flux',
        name: 'flux',
        image: 'fluxcd/flux',
        tag: '1.19.0',
        replicas: 1,
        arguments: [
            '--memcached-service=',
            '--ssh-keygen-dir=/etc/fluxd/keygen',
            '--git-url=git@github.com:rafaribe/cdk8s-k3s-gitops.git',
            '--git-branch=master',
            '--git-path=cluster',
            '--git-label=flux',
            '--git-user=flux',
            '--git-email=flux@rafaribe.com',
            '--git-poll-interval=5m',
            '--sync-garbage-collection',
        ],
    });
    // THEN
    globals_1.expect(cdk8s_1.Testing.synth(chart)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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