import { Construct } from 'constructs';
export interface FluxOptions {
    /**
     * The image for flux (docker hub only)
     */
    readonly image: string;
    /**
     * The tag for the flux image
     */
    readonly tag: string;
    /**
     * The name for the flux container
     */
    readonly name: string;
    /**
     * The Namespace that should be used for the resources
     */
    readonly ns: string;
    /**
     * Number of replicas.
     *
     * @default 1
     */
    readonly replicas?: number;
    /**
     * The tag for the memcached image
     *  * @default 1.5.20
     */
    readonly memcachedTag?: string;
    /**
     * Flux Arguments
     *
     */
    readonly arguments: string[];
}
export declare class Flux extends Construct {
    constructor(scope: Construct, constructId: string, options: FluxOptions);
}
