"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyFlux = void 0;
const cdk8s_1 = require("cdk8s");
const index_1 = require("../lib/index");
class MyFlux extends cdk8s_1.Chart {
    constructor(scope, name) {
        super(scope, name);
        new index_1.Flux(this, 'flux', {
            ns: 'flux',
            name: 'flux',
            image: 'fluxcd/flux',
            tag: '1.19.0',
            replicas: 1,
            arguments: [
                '--memcached-service=',
                '--ssh-keygen-dir=/etc/fluxd/keygen',
                '--git-url=git@github.com:rafaribe/cdk8s-k3s-gitops.git',
                '--git-branch=master',
                '--git-path=cluster',
                '--git-label=flux',
                '--git-user=flux',
                '--git-email=flux@rafaribe.com',
                '--git-poll-interval=5m',
                '--sync-garbage-collection',
            ],
        });
    }
}
exports.MyFlux = MyFlux;
const app = new cdk8s_1.App();
new MyFlux(app, 'flux');
app.synth();
//# sourceMappingURL=data:application/json;base64,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