import { PipelineBase, PipelineBaseProps } from 'aws-cdk-lib/pipelines';
import { Construct } from 'constructs';
import { DockerCredential } from './docker-credentials';
import * as github from './workflows-model';
/**
 * Props for `GitHubWorkflow`.
 */
export interface GitHubWorkflowProps extends PipelineBaseProps {
    /**
     * File path for the GitHub workflow.
     *
     * @default ".github/workflows/deploy.yml"
     */
    readonly workflowPath?: string;
    /**
     * Name of the workflow.
     *
     * @default "deploy"
     */
    readonly workflowName?: string;
    /**
     * GitHub workflow triggers.
     *
     * @default - By default, workflow is triggered on push to the `main` branch
     * and can also be triggered manually (`workflow_dispatch`).
     */
    readonly workflowTriggers?: github.Triggers;
    /**
     * Version of the CDK CLI to use.
     * @default - automatic
     */
    readonly cdkCliVersion?: string;
    /**
     * Indicates if the repository already contains a synthesized `cdk.out` directory, in which
     * case we will simply checkout the repo in jobs that require `cdk.out`.
     *
     * @default false
     */
    readonly preSynthed?: boolean;
    /**
     * Names of GitHub repository secrets that include AWS credentials for
     * deployment.
     *
     * @default - `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`.
     */
    readonly awsCredentials?: AwsCredentialsSecrets;
    /**
     * A role that utilizes the GitHub OIDC Identity Provider in your AWS account.
     * If supplied, this will be used instead of `awsCredentials`.
     *
     * You can create your own role in the console with the necessary trust policy
     * to allow gitHub actions from your gitHub repository to assume the role, or
     * you can utilize the `GitHubActionRole` construct to create a role for you.
     *
     * @default - GitHub repository secrets are used instead of OpenId Connect role.
     */
    readonly gitHubActionRoleArn?: string;
    /**
     * Build container options.
     *
     * @default - GitHub defaults
     */
    readonly buildContainer?: github.ContainerOptions;
    /**
     * GitHub workflow steps to execute before build.
     *
     * @default []
     */
    readonly preBuildSteps?: github.JobStep[];
    /**
     * GitHub workflow steps to execute after build.
     *
     * @default []
     */
    readonly postBuildSteps?: github.JobStep[];
    /**
     * The Docker Credentials to use to login. If you set this variable,
     * you will be logged in to docker when you upload Docker Assets.
     */
    readonly dockerCredentials?: DockerCredential[];
}
/**
 * CDK Pipelines for GitHub workflows.
 */
export declare class GitHubWorkflow extends PipelineBase {
    readonly workflowPath: string;
    readonly workflowName: string;
    private readonly workflowTriggers;
    private readonly preSynthed;
    private readonly awsCredentials;
    private readonly gitHubActionRoleArn?;
    private readonly useGitHubActionRole;
    private readonly dockerCredentials;
    private readonly cdkCliVersion?;
    private readonly buildContainer?;
    private readonly preBuildSteps;
    private readonly postBuildSteps;
    private readonly jobOutputs;
    private readonly assetHashMap;
    constructor(scope: Construct, id: string, props: GitHubWorkflowProps);
    protected doBuildPipeline(): void;
    private insertJobOutputs;
    private renderJobOutputs;
    /**
     * Make an action from the given node and/or step
     */
    private jobForNode;
    private jobForAssetPublish;
    private jobForDeploy;
    private jobForBuildStep;
    /**
     * Searches for the stack that produced the output via the current
     * job's dependencies.
     *
     * This function should always find a stack, since it is guaranteed
     * that a CfnOutput comes from a referenced stack.
     */
    private findStackOfOutput;
    private addJobOutput;
    private jobForScriptStep;
    private stepsToConfigureAws;
    private stepsToConfigureDocker;
    private stepsToDownloadAssembly;
    private stepsToCheckout;
    private stepsToUploadAssembly;
    private renderDependencies;
}
/**
 * Names of secrets for AWS credentials.
 */
export interface AwsCredentialsSecrets {
    /**
     * @default "AWS_ACCESS_KEY_ID"
     */
    readonly accessKeyId?: string;
    /**
     * @default "AWS_SECRET_ACCESS_KEY"
     */
    readonly secretAccessKey?: string;
    /**
     * @default - no session token is used
     */
    readonly sessionToken?: string;
}
export declare function flatten<A>(xs: Iterable<A[]>): IterableIterator<A>;
