"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const test_origin_1 = require("./test-origin");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-distribution-extensive');
new cloudfront.Distribution(stack, 'MyDist', {
    defaultBehavior: { origin: new test_origin_1.TestOrigin('www.example.com') },
    comment: 'a test',
    defaultRootObject: 'index.html',
    enabled: true,
    enableIpv6: true,
    enableLogging: true,
    geoRestriction: cloudfront.GeoRestriction.whitelist('US', 'GB'),
    httpVersion: cloudfront.HttpVersion.HTTP2,
    logFilePrefix: 'logs/',
    logIncludesCookies: true,
    priceClass: cloudfront.PriceClass.PRICE_CLASS_100,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGlzdHJpYnV0aW9uLWV4dGVuc2l2ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmRpc3RyaWJ1dGlvbi1leHRlbnNpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBcUM7QUFDckMscUNBQXFDO0FBQ3JDLCtDQUEyQztBQUUzQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFFakUsSUFBSSxVQUFVLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7SUFDM0MsZUFBZSxFQUFFLEVBQUUsTUFBTSxFQUFFLElBQUksd0JBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFO0lBQzlELE9BQU8sRUFBRSxRQUFRO0lBQ2pCLGlCQUFpQixFQUFFLFlBQVk7SUFDL0IsT0FBTyxFQUFFLElBQUk7SUFDYixVQUFVLEVBQUUsSUFBSTtJQUNoQixhQUFhLEVBQUUsSUFBSTtJQUNuQixjQUFjLEVBQUUsVUFBVSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQztJQUMvRCxXQUFXLEVBQUUsVUFBVSxDQUFDLFdBQVcsQ0FBQyxLQUFLO0lBQ3pDLGFBQWEsRUFBRSxPQUFPO0lBQ3RCLGtCQUFrQixFQUFFLElBQUk7SUFDeEIsVUFBVSxFQUFFLFVBQVUsQ0FBQyxVQUFVLENBQUMsZUFBZTtDQUNsRCxDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0T3JpZ2luIH0gZnJvbSAnLi90ZXN0LW9yaWdpbic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnaW50ZWctZGlzdHJpYnV0aW9uLWV4dGVuc2l2ZScpO1xuXG5uZXcgY2xvdWRmcm9udC5EaXN0cmlidXRpb24oc3RhY2ssICdNeURpc3QnLCB7XG4gIGRlZmF1bHRCZWhhdmlvcjogeyBvcmlnaW46IG5ldyBUZXN0T3JpZ2luKCd3d3cuZXhhbXBsZS5jb20nKSB9LFxuICBjb21tZW50OiAnYSB0ZXN0JyxcbiAgZGVmYXVsdFJvb3RPYmplY3Q6ICdpbmRleC5odG1sJyxcbiAgZW5hYmxlZDogdHJ1ZSxcbiAgZW5hYmxlSXB2NjogdHJ1ZSxcbiAgZW5hYmxlTG9nZ2luZzogdHJ1ZSxcbiAgZ2VvUmVzdHJpY3Rpb246IGNsb3VkZnJvbnQuR2VvUmVzdHJpY3Rpb24ud2hpdGVsaXN0KCdVUycsICdHQicpLFxuICBodHRwVmVyc2lvbjogY2xvdWRmcm9udC5IdHRwVmVyc2lvbi5IVFRQMixcbiAgbG9nRmlsZVByZWZpeDogJ2xvZ3MvJyxcbiAgbG9nSW5jbHVkZXNDb29raWVzOiB0cnVlLFxuICBwcmljZUNsYXNzOiBjbG91ZGZyb250LlByaWNlQ2xhc3MuUFJJQ0VfQ0xBU1NfMTAwLFxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19