"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const test_origin_1 = require("./test-origin");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-distribution-basic');
new cloudfront.Distribution(stack, 'Dist', {
    defaultBehavior: { origin: new test_origin_1.TestOrigin('www.example.com') },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGlzdHJpYnV0aW9uLWJhc2ljLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuZGlzdHJpYnV0aW9uLWJhc2ljLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLHFDQUFxQztBQUNyQywrQ0FBMkM7QUFFM0MsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO0FBRTdELElBQUksVUFBVSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFO0lBQ3pDLGVBQWUsRUFBRSxFQUFFLE1BQU0sRUFBRSxJQUFJLHdCQUFVLENBQUMsaUJBQWlCLENBQUMsRUFBRTtDQUMvRCxDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0T3JpZ2luIH0gZnJvbSAnLi90ZXN0LW9yaWdpbic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnaW50ZWctZGlzdHJpYnV0aW9uLWJhc2ljJyk7XG5cbm5ldyBjbG91ZGZyb250LkRpc3RyaWJ1dGlvbihzdGFjaywgJ0Rpc3QnLCB7XG4gIGRlZmF1bHRCZWhhdmlvcjogeyBvcmlnaW46IG5ldyBUZXN0T3JpZ2luKCd3d3cuZXhhbXBsZS5jb20nKSB9LFxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19