import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#account_encryption_source StorageAccount#account_encryption_source}
    */
    readonly accountEncryptionSource?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#account_kind StorageAccount#account_kind}
    */
    readonly accountKind?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#account_replication_type StorageAccount#account_replication_type}
    */
    readonly accountReplicationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#account_tier StorageAccount#account_tier}
    */
    readonly accountTier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#enable_blob_encryption StorageAccount#enable_blob_encryption}
    */
    readonly enableBlobEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#enable_https_traffic_only StorageAccount#enable_https_traffic_only}
    */
    readonly enableHttpsTrafficOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#id StorageAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#location StorageAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#name StorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#resource_group_name StorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#tags StorageAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * custom_domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#custom_domain StorageAccount#custom_domain}
    */
    readonly customDomain?: StorageAccountCustomDomain;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#timeouts StorageAccount#timeouts}
    */
    readonly timeouts?: StorageAccountTimeouts;
}
export interface StorageAccountCustomDomain {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#name StorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#use_subdomain StorageAccount#use_subdomain}
    */
    readonly useSubdomain?: boolean | cdktf.IResolvable;
}
export declare function storageAccountCustomDomainToTerraform(struct?: StorageAccountCustomDomainOutputReference | StorageAccountCustomDomain): any;
export declare class StorageAccountCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountCustomDomain | undefined;
    set internalValue(value: StorageAccountCustomDomain | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useSubdomain?;
    get useSubdomain(): boolean | cdktf.IResolvable;
    set useSubdomain(value: boolean | cdktf.IResolvable);
    resetUseSubdomain(): void;
    get useSubdomainInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#create StorageAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#delete StorageAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#read StorageAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account#update StorageAccount#update}
    */
    readonly update?: string;
}
export declare function storageAccountTimeoutsToTerraform(struct?: StorageAccountTimeoutsOutputReference | StorageAccountTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account azurestack_storage_account}
*/
export declare class StorageAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurestack_storage_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/r/storage_account azurestack_storage_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountConfig);
    private _accountEncryptionSource?;
    get accountEncryptionSource(): string;
    set accountEncryptionSource(value: string);
    resetAccountEncryptionSource(): void;
    get accountEncryptionSourceInput(): string | undefined;
    private _accountKind?;
    get accountKind(): string;
    set accountKind(value: string);
    resetAccountKind(): void;
    get accountKindInput(): string | undefined;
    private _accountReplicationType?;
    get accountReplicationType(): string;
    set accountReplicationType(value: string);
    get accountReplicationTypeInput(): string | undefined;
    private _accountTier?;
    get accountTier(): string;
    set accountTier(value: string);
    get accountTierInput(): string | undefined;
    private _enableBlobEncryption?;
    get enableBlobEncryption(): boolean | cdktf.IResolvable;
    set enableBlobEncryption(value: boolean | cdktf.IResolvable);
    resetEnableBlobEncryption(): void;
    get enableBlobEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttpsTrafficOnly?;
    get enableHttpsTrafficOnly(): boolean | cdktf.IResolvable;
    set enableHttpsTrafficOnly(value: boolean | cdktf.IResolvable);
    resetEnableHttpsTrafficOnly(): void;
    get enableHttpsTrafficOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryBlobConnectionString(): string;
    get primaryBlobEndpoint(): string;
    get primaryConnectionString(): string;
    get primaryFileEndpoint(): string;
    get primaryLocation(): string;
    get primaryQueueEndpoint(): string;
    get primaryTableEndpoint(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryBlobConnectionString(): string;
    get secondaryBlobEndpoint(): string;
    get secondaryConnectionString(): string;
    get secondaryLocation(): string;
    get secondaryQueueEndpoint(): string;
    get secondaryTableEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customDomain;
    get customDomain(): StorageAccountCustomDomainOutputReference;
    putCustomDomain(value: StorageAccountCustomDomain): void;
    resetCustomDomain(): void;
    get customDomainInput(): StorageAccountCustomDomain | undefined;
    private _timeouts;
    get timeouts(): StorageAccountTimeoutsOutputReference;
    putTimeouts(value: StorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
