import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzurestackProviderConfig {
    /**
    * The Hostname which should be used for the Azure Metadata Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#arm_endpoint AzurestackProvider#arm_endpoint}
    */
    readonly armEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#auxiliary_tenant_ids AzurestackProvider#auxiliary_tenant_ids}
    */
    readonly auxiliaryTenantIds?: string[];
    /**
    * The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#client_certificate_password AzurestackProvider#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#client_certificate_path AzurestackProvider#client_certificate_path}
    */
    readonly clientCertificatePath?: string;
    /**
    * The Client ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#client_id AzurestackProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#client_secret AzurestackProvider#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * This will disable the x-ms-correlation-request-id header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#disable_correlation_request_id AzurestackProvider#disable_correlation_request_id}
    */
    readonly disableCorrelationRequestId?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Environment which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#environment AzurestackProvider#environment}
    */
    readonly environment?: string;
    /**
    * The Hostname which should be used for the Azure Metadata Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#metadata_host AzurestackProvider#metadata_host}
    */
    readonly metadataHost?: string;
    /**
    * The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#msi_endpoint AzurestackProvider#msi_endpoint}
    */
    readonly msiEndpoint?: string;
    /**
    * Should the AzureStack Provider skip registering all of the Resource Providers that it supports, if they're not already registered?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#skip_provider_registration AzurestackProvider#skip_provider_registration}
    */
    readonly skipProviderRegistration?: boolean | cdktf.IResolvable;
    /**
    * The Subscription ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#subscription_id AzurestackProvider#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * The Tenant ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#tenant_id AzurestackProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Allowed Managed Service Identity be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#use_msi AzurestackProvider#use_msi}
    */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#alias AzurestackProvider#alias}
    */
    readonly alias?: string;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#features AzurestackProvider#features}
    */
    readonly features: AzurestackProviderFeatures;
}
export interface AzurestackProviderFeaturesResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#prevent_deletion_if_contains_resources AzurestackProvider#prevent_deletion_if_contains_resources}
    */
    readonly preventDeletionIfContainsResources?: boolean | cdktf.IResolvable;
}
export declare function azurestackProviderFeaturesResourceGroupToTerraform(struct?: AzurestackProviderFeaturesResourceGroup): any;
export interface AzurestackProviderFeaturesVirtualMachine {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#delete_os_disk_on_deletion AzurestackProvider#delete_os_disk_on_deletion}
    */
    readonly deleteOsDiskOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#graceful_shutdown AzurestackProvider#graceful_shutdown}
    */
    readonly gracefulShutdown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#skip_shutdown_and_force_delete AzurestackProvider#skip_shutdown_and_force_delete}
    */
    readonly skipShutdownAndForceDelete?: boolean | cdktf.IResolvable;
}
export declare function azurestackProviderFeaturesVirtualMachineToTerraform(struct?: AzurestackProviderFeaturesVirtualMachine): any;
export interface AzurestackProviderFeaturesVirtualMachineScaleSet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#force_delete AzurestackProvider#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#roll_instances_when_required AzurestackProvider#roll_instances_when_required}
    */
    readonly rollInstancesWhenRequired: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#scale_to_zero_before_deletion AzurestackProvider#scale_to_zero_before_deletion}
    */
    readonly scaleToZeroBeforeDeletion?: boolean | cdktf.IResolvable;
}
export declare function azurestackProviderFeaturesVirtualMachineScaleSetToTerraform(struct?: AzurestackProviderFeaturesVirtualMachineScaleSet): any;
export interface AzurestackProviderFeatures {
    /**
    * resource_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#resource_group AzurestackProvider#resource_group}
    */
    readonly resourceGroup?: AzurestackProviderFeaturesResourceGroup;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#virtual_machine AzurestackProvider#virtual_machine}
    */
    readonly virtualMachine?: AzurestackProviderFeaturesVirtualMachine;
    /**
    * virtual_machine_scale_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack#virtual_machine_scale_set AzurestackProvider#virtual_machine_scale_set}
    */
    readonly virtualMachineScaleSet?: AzurestackProviderFeaturesVirtualMachineScaleSet;
}
export declare function azurestackProviderFeaturesToTerraform(struct?: AzurestackProviderFeatures): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack azurestack}
*/
export declare class AzurestackProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "azurestack";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack azurestack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurestackProviderConfig
    */
    constructor(scope: Construct, id: string, config: AzurestackProviderConfig);
    private _armEndpoint?;
    get armEndpoint(): string | undefined;
    set armEndpoint(value: string | undefined);
    resetArmEndpoint(): void;
    get armEndpointInput(): string | undefined;
    private _auxiliaryTenantIds?;
    get auxiliaryTenantIds(): string[] | undefined;
    set auxiliaryTenantIds(value: string[] | undefined);
    resetAuxiliaryTenantIds(): void;
    get auxiliaryTenantIdsInput(): string[] | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string | undefined;
    set clientCertificatePassword(value: string | undefined);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    get clientCertificatePath(): string | undefined;
    set clientCertificatePath(value: string | undefined);
    resetClientCertificatePath(): void;
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _disableCorrelationRequestId?;
    get disableCorrelationRequestId(): boolean | cdktf.IResolvable | undefined;
    set disableCorrelationRequestId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableCorrelationRequestId(): void;
    get disableCorrelationRequestIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    get environment(): string | undefined;
    set environment(value: string | undefined);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _metadataHost?;
    get metadataHost(): string | undefined;
    set metadataHost(value: string | undefined);
    resetMetadataHost(): void;
    get metadataHostInput(): string | undefined;
    private _msiEndpoint?;
    get msiEndpoint(): string | undefined;
    set msiEndpoint(value: string | undefined);
    resetMsiEndpoint(): void;
    get msiEndpointInput(): string | undefined;
    private _skipProviderRegistration?;
    get skipProviderRegistration(): boolean | cdktf.IResolvable | undefined;
    set skipProviderRegistration(value: boolean | cdktf.IResolvable | undefined);
    resetSkipProviderRegistration(): void;
    get skipProviderRegistrationInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionId?;
    get subscriptionId(): string | undefined;
    set subscriptionId(value: string | undefined);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string | undefined;
    set tenantId(value: string | undefined);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _useMsi?;
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    resetUseMsi(): void;
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _features?;
    get features(): AzurestackProviderFeatures | undefined;
    set features(value: AzurestackProviderFeatures | undefined);
    get featuresInput(): AzurestackProviderFeatures | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
