import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackVirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection#id DataAzurestackVirtualNetworkGatewayConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection#name DataAzurestackVirtualNetworkGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection#resource_group_name DataAzurestackVirtualNetworkGatewayConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection#timeouts DataAzurestackVirtualNetworkGatewayConnection#timeouts}
    */
    readonly timeouts?: DataAzurestackVirtualNetworkGatewayConnectionTimeouts;
}
export interface DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicy {
}
export declare function dataAzurestackVirtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct?: DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicy): any;
export declare class DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicy | undefined);
    get dhGroup(): string;
    get ikeEncryption(): string;
    get ikeIntegrity(): string;
    get ipsecEncryption(): string;
    get ipsecIntegrity(): string;
    get pfsGroup(): string;
    get saDatasize(): number;
    get saLifetime(): number;
}
export declare class DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection#read DataAzurestackVirtualNetworkGatewayConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackVirtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: DataAzurestackVirtualNetworkGatewayConnectionTimeoutsOutputReference | DataAzurestackVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackVirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection azurestack_virtual_network_gateway_connection}
*/
export declare class DataAzurestackVirtualNetworkGatewayConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_virtual_network_gateway_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway_connection azurestack_virtual_network_gateway_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackVirtualNetworkGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackVirtualNetworkGatewayConnectionConfig);
    get authorizationKey(): string;
    get egressBytesTransferred(): number;
    get enableBgp(): cdktf.IResolvable;
    get expressRouteCircuitId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ingressBytesTransferred(): number;
    private _ipsecPolicy;
    get ipsecPolicy(): DataAzurestackVirtualNetworkGatewayConnectionIpsecPolicyList;
    get localNetworkGatewayId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get peerVirtualNetworkGatewayId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceGuid(): string;
    get routingWeight(): number;
    get sharedKey(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    get usePolicyBasedTrafficSelectors(): cdktf.IResolvable;
    get virtualNetworkGatewayId(): string;
    private _timeouts;
    get timeouts(): DataAzurestackVirtualNetworkGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackVirtualNetworkGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackVirtualNetworkGatewayConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
