import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackResourcesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#id DataAzurestackResources#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#name DataAzurestackResources#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#required_tags DataAzurestackResources#required_tags}
    */
    readonly requiredTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#resource_group_name DataAzurestackResources#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#type DataAzurestackResources#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#timeouts DataAzurestackResources#timeouts}
    */
    readonly timeouts?: DataAzurestackResourcesTimeouts;
}
export interface DataAzurestackResourcesResources {
}
export declare function dataAzurestackResourcesResourcesToTerraform(struct?: DataAzurestackResourcesResources): any;
export declare class DataAzurestackResourcesResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackResourcesResources | undefined;
    set internalValue(value: DataAzurestackResourcesResources | undefined);
    get id(): string;
    get location(): string;
    get name(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
}
export declare class DataAzurestackResourcesResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackResourcesResourcesOutputReference;
}
export interface DataAzurestackResourcesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resources#read DataAzurestackResources#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackResourcesTimeoutsToTerraform(struct?: DataAzurestackResourcesTimeoutsOutputReference | DataAzurestackResourcesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackResourcesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackResourcesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackResourcesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/resources azurestack_resources}
*/
export declare class DataAzurestackResources extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_resources";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/resources azurestack_resources} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackResourcesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurestackResourcesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _requiredTags?;
    get requiredTags(): {
        [key: string]: string;
    };
    set requiredTags(value: {
        [key: string]: string;
    });
    resetRequiredTags(): void;
    get requiredTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _resources;
    get resources(): DataAzurestackResourcesResourcesList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackResourcesTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackResourcesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackResourcesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
