import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackPublicIpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#id DataAzurestackPublicIp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#name DataAzurestackPublicIp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#resource_group_name DataAzurestackPublicIp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#tags DataAzurestackPublicIp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#timeouts DataAzurestackPublicIp#timeouts}
    */
    readonly timeouts?: DataAzurestackPublicIpTimeouts;
}
export interface DataAzurestackPublicIpTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip#read DataAzurestackPublicIp#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackPublicIpTimeoutsToTerraform(struct?: DataAzurestackPublicIpTimeoutsOutputReference | DataAzurestackPublicIpTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackPublicIpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackPublicIpTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackPublicIpTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip azurestack_public_ip}
*/
export declare class DataAzurestackPublicIp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_public_ip";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/public_ip azurestack_public_ip} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackPublicIpConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackPublicIpConfig);
    get allocationMethod(): string;
    get domainNameLabel(): string;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    get ipAddress(): string;
    get ipVersion(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get reverseFqdn(): string;
    get sku(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurestackPublicIpTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackPublicIpTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackPublicIpTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
