import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#id DataAzurestackManagedDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#name DataAzurestackManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#resource_group_name DataAzurestackManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#tags DataAzurestackManagedDisk#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#timeouts DataAzurestackManagedDisk#timeouts}
    */
    readonly timeouts?: DataAzurestackManagedDiskTimeouts;
}
export interface DataAzurestackManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk#read DataAzurestackManagedDisk#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackManagedDiskTimeoutsToTerraform(struct?: DataAzurestackManagedDiskTimeoutsOutputReference | DataAzurestackManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackManagedDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackManagedDiskTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk azurestack_managed_disk}
*/
export declare class DataAzurestackManagedDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_managed_disk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/managed_disk azurestack_managed_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackManagedDiskConfig);
    get createOption(): string;
    get diskSizeGb(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageReferenceId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get storageAccountType(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackManagedDiskTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
