import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#id DataAzurestackImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#name DataAzurestackImage#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#name_regex DataAzurestackImage#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#resource_group_name DataAzurestackImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#sort_descending DataAzurestackImage#sort_descending}
    */
    readonly sortDescending?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#timeouts DataAzurestackImage#timeouts}
    */
    readonly timeouts?: DataAzurestackImageTimeouts;
}
export interface DataAzurestackImageDataDisk {
}
export declare function dataAzurestackImageDataDiskToTerraform(struct?: DataAzurestackImageDataDisk): any;
export declare class DataAzurestackImageDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackImageDataDisk | undefined;
    set internalValue(value: DataAzurestackImageDataDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get lun(): number;
    get managedDiskId(): string;
    get sizeGb(): number;
}
export declare class DataAzurestackImageDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackImageDataDiskOutputReference;
}
export interface DataAzurestackImageOsDisk {
}
export declare function dataAzurestackImageOsDiskToTerraform(struct?: DataAzurestackImageOsDisk): any;
export declare class DataAzurestackImageOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackImageOsDisk | undefined;
    set internalValue(value: DataAzurestackImageOsDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get managedDiskId(): string;
    get osState(): string;
    get osType(): string;
    get sizeGb(): number;
}
export declare class DataAzurestackImageOsDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackImageOsDiskOutputReference;
}
export interface DataAzurestackImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/image#read DataAzurestackImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackImageTimeoutsToTerraform(struct?: DataAzurestackImageTimeoutsOutputReference | DataAzurestackImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackImageTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/image azurestack_image}
*/
export declare class DataAzurestackImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/image azurestack_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackImageConfig);
    private _dataDisk;
    get dataDisk(): DataAzurestackImageDataDiskList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _osDisk;
    get osDisk(): DataAzurestackImageOsDiskList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sortDescending?;
    get sortDescending(): boolean | cdktf.IResolvable;
    set sortDescending(value: boolean | cdktf.IResolvable);
    resetSortDescending(): void;
    get sortDescendingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
