import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackClientConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/client_config#id DataAzurestackClientConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/client_config#timeouts DataAzurestackClientConfig#timeouts}
    */
    readonly timeouts?: DataAzurestackClientConfigTimeouts;
}
export interface DataAzurestackClientConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/client_config#read DataAzurestackClientConfig#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackClientConfigTimeoutsToTerraform(struct?: DataAzurestackClientConfigTimeoutsOutputReference | DataAzurestackClientConfigTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackClientConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackClientConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackClientConfigTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/client_config azurestack_client_config}
*/
export declare class DataAzurestackClientConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_client_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/client_config azurestack_client_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackClientConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurestackClientConfigConfig);
    get clientId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get objectId(): string;
    get servicePrincipalApplicationId(): string;
    get servicePrincipalObjectId(): string;
    get subscriptionId(): string;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurestackClientConfigTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackClientConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackClientConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
