# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BillTo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'first_name': 'str',
        'last_name': 'str',
        'company': 'str',
        'address1': 'str',
        'address2': 'str',
        'locality': 'str',
        'administrative_area': 'str',
        'postal_code': 'str',
        'country': 'str',
        'email': 'str',
        'phone_number': 'str'
    }

    attribute_map = {
        'first_name': 'firstName',
        'last_name': 'lastName',
        'company': 'company',
        'address1': 'address1',
        'address2': 'address2',
        'locality': 'locality',
        'administrative_area': 'administrativeArea',
        'postal_code': 'postalCode',
        'country': 'country',
        'email': 'email',
        'phone_number': 'phoneNumber'
    }

    def __init__(self, first_name=None, last_name=None, company=None, address1=None, address2=None, locality=None, administrative_area=None, postal_code=None, country=None, email=None, phone_number=None):
        """
        BillTo - a model defined in Swagger
        """

        self._first_name = None
        self._last_name = None
        self._company = None
        self._address1 = None
        self._address2 = None
        self._locality = None
        self._administrative_area = None
        self._postal_code = None
        self._country = None
        self._email = None
        self._phone_number = None

        if first_name is not None:
          self.first_name = first_name
        if last_name is not None:
          self.last_name = last_name
        if company is not None:
          self.company = company
        if address1 is not None:
          self.address1 = address1
        if address2 is not None:
          self.address2 = address2
        if locality is not None:
          self.locality = locality
        if administrative_area is not None:
          self.administrative_area = administrative_area
        if postal_code is not None:
          self.postal_code = postal_code
        if country is not None:
          self.country = country
        if email is not None:
          self.email = email
        if phone_number is not None:
          self.phone_number = phone_number

    @property
    def first_name(self):
        """
        Gets the first_name of this BillTo.
        Customer’s first name. For a credit card transaction, this name must match the name on the card.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The first_name of this BillTo.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this BillTo.
        Customer’s first name. For a credit card transaction, this name must match the name on the card.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param first_name: The first_name of this BillTo.
        :type: str
        """
        if first_name is not None and len(first_name) > 60:
            raise ValueError("Invalid value for `first_name`, length must be less than or equal to `60`")

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this BillTo.
        Customer’s last name. For a credit card transaction, this name must match the name on the card.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The last_name of this BillTo.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this BillTo.
        Customer’s last name. For a credit card transaction, this name must match the name on the card.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param last_name: The last_name of this BillTo.
        :type: str
        """
        if last_name is not None and len(last_name) > 60:
            raise ValueError("Invalid value for `last_name`, length must be less than or equal to `60`")

        self._last_name = last_name

    @property
    def company(self):
        """
        Gets the company of this BillTo.
        Name of the customer’s company.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The company of this BillTo.
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """
        Sets the company of this BillTo.
        Name of the customer’s company.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param company: The company of this BillTo.
        :type: str
        """
        if company is not None and len(company) > 60:
            raise ValueError("Invalid value for `company`, length must be less than or equal to `60`")

        self._company = company

    @property
    def address1(self):
        """
        Gets the address1 of this BillTo.
        First line of the billing street address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The address1 of this BillTo.
        :rtype: str
        """
        return self._address1

    @address1.setter
    def address1(self, address1):
        """
        Sets the address1 of this BillTo.
        First line of the billing street address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param address1: The address1 of this BillTo.
        :type: str
        """
        if address1 is not None and len(address1) > 60:
            raise ValueError("Invalid value for `address1`, length must be less than or equal to `60`")

        self._address1 = address1

    @property
    def address2(self):
        """
        Gets the address2 of this BillTo.
        Additional address information.

        :return: The address2 of this BillTo.
        :rtype: str
        """
        return self._address2

    @address2.setter
    def address2(self, address2):
        """
        Sets the address2 of this BillTo.
        Additional address information.

        :param address2: The address2 of this BillTo.
        :type: str
        """
        if address2 is not None and len(address2) > 60:
            raise ValueError("Invalid value for `address2`, length must be less than or equal to `60`")

        self._address2 = address2

    @property
    def locality(self):
        """
        Gets the locality of this BillTo.
        City of the billing address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The locality of this BillTo.
        :rtype: str
        """
        return self._locality

    @locality.setter
    def locality(self, locality):
        """
        Sets the locality of this BillTo.
        City of the billing address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param locality: The locality of this BillTo.
        :type: str
        """
        if locality is not None and len(locality) > 50:
            raise ValueError("Invalid value for `locality`, length must be less than or equal to `50`")

        self._locality = locality

    @property
    def administrative_area(self):
        """
        Gets the administrative_area of this BillTo.
        State or province of the billing address. For an address in the U.S. or Canada, use the State, Province, and Territory Codes for the United States and Canada.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The administrative_area of this BillTo.
        :rtype: str
        """
        return self._administrative_area

    @administrative_area.setter
    def administrative_area(self, administrative_area):
        """
        Sets the administrative_area of this BillTo.
        State or province of the billing address. For an address in the U.S. or Canada, use the State, Province, and Territory Codes for the United States and Canada.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param administrative_area: The administrative_area of this BillTo.
        :type: str
        """
        if administrative_area is not None and len(administrative_area) > 20:
            raise ValueError("Invalid value for `administrative_area`, length must be less than or equal to `20`")

        self._administrative_area = administrative_area

    @property
    def postal_code(self):
        """
        Gets the postal_code of this BillTo.
        Postal code for the billing address. The postal code must consist of 5 to 9 digits.  When the billing country is the U.S., the 9-digit postal code must follow this format: [5 digits][dash][4 digits] **Example** 12345-6789  When the billing country is Canada, the 6-digit postal code must follow this format: [alpha][numeric][alpha][space] [numeric][alpha][numeric] Example A1B 2C3  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The postal_code of this BillTo.
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """
        Sets the postal_code of this BillTo.
        Postal code for the billing address. The postal code must consist of 5 to 9 digits.  When the billing country is the U.S., the 9-digit postal code must follow this format: [5 digits][dash][4 digits] **Example** 12345-6789  When the billing country is Canada, the 6-digit postal code must follow this format: [alpha][numeric][alpha][space] [numeric][alpha][numeric] Example A1B 2C3  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important**: It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param postal_code: The postal_code of this BillTo.
        :type: str
        """
        if postal_code is not None and len(postal_code) > 10:
            raise ValueError("Invalid value for `postal_code`, length must be less than or equal to `10`")

        self._postal_code = postal_code

    @property
    def country(self):
        """
        Gets the country of this BillTo.
        Country of the billing address. Accepts input in the ISO 3166-1 standard, stores as ISO 3166-1-Alpha-2.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important** It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The country of this BillTo.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this BillTo.
        Country of the billing address. Accepts input in the ISO 3166-1 standard, stores as ISO 3166-1-Alpha-2.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important** It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param country: The country of this BillTo.
        :type: str
        """
        if country is not None and len(country) > 3:
            raise ValueError("Invalid value for `country`, length must be less than or equal to `3`")
        if country is not None and len(country) < 2:
            raise ValueError("Invalid value for `country`, length must be greater than or equal to `2`")

        self._country = country

    @property
    def email(self):
        """
        Gets the email of this BillTo.
        Customer’s email address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important** It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :return: The email of this BillTo.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this BillTo.
        Customer’s email address.  This field is optional if your CyberSource account is configured for relaxed requirements for address data and expiration date. See the TMS REST Developer Guide for more information about relaxed address requirements.  **Important** It is your responsibility to determine whether a field is required for the transaction you are requesting. 

        :param email: The email of this BillTo.
        :type: str
        """
        if email is not None and len(email) > 320:
            raise ValueError("Invalid value for `email`, length must be less than or equal to `320`")

        self._email = email

    @property
    def phone_number(self):
        """
        Gets the phone_number of this BillTo.
        Customer phone number. When you create a customer profile, the requirements depend on the payment method:   * Credit cards — optional.   * Electronic checks — contact your payment processor representative to find out if this field is required or optional.   * PINless debits — optional. 

        :return: The phone_number of this BillTo.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """
        Sets the phone_number of this BillTo.
        Customer phone number. When you create a customer profile, the requirements depend on the payment method:   * Credit cards — optional.   * Electronic checks — contact your payment processor representative to find out if this field is required or optional.   * PINless debits — optional. 

        :param phone_number: The phone_number of this BillTo.
        :type: str
        """
        if phone_number is not None and len(phone_number) > 32:
            raise ValueError("Invalid value for `phone_number`, length must be less than or equal to `32`")
        if phone_number is not None and len(phone_number) < 6:
            raise ValueError("Invalid value for `phone_number`, length must be greater than or equal to `6`")

        self._phone_number = phone_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, BillTo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
