apitypes = {
    # NTDLL
    'DWORD':        'unsigned int',
    'HANDLE':       'DWORD',
    'LIBHANDLE':    'HANDLE',
    'HEAP':         'HANDLE',

    # KERNEL32
}

api = {
    # NTDLL
    'ntdll.main_entry':( 'int', None, 'stdcall', 'ntdll.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.seh3_prolog':('int', None, 'stdcall', 'ntdll.seh3_prolog', (('struct SEH3_SCOPETABLE *','pScopeTable'),('int','dwAllocSize'))),
    'ntdll.seh4_prolog':('int', None, 'stdcall', 'ntdll.seh4_prolog', (('void *','pScopeTable'),('int','dwAllocSize'))),
    'ntdll.seh4_gs_prolog':('int', None, 'stdcall', 'ntdll.seh4_gs_prolog', (('void *','pScopeTable'),('int','dwAllocSize'))),

    'ntdll.seh3_epilog':('int', None, 'stdcall', 'ntdll.seh3_epilog', ()),
    'ntdll.seh4_epilog':('int', None, 'stdcall', 'ntdll.seh4_epilog', ()),

    'ntdll.eh_prolog':('int', None, 'stdcall', 'ntdll.eh_prolog', ()),
    'ntdll.gs_prolog':('int', None, 'stdcall', 'ntdll.gs_prolog', ()),
    'ntdll._alloca_probe':('int', None, 'stdcall', 'ntdll._alloca_probe', ()),

    'ntdll.csrallocatecapturebuffer':( 'int', None, 'stdcall', 'ntdll.CsrAllocateCaptureBuffer', (('int', None), ('int', None)) ),
    'ntdll.csrallocatemessagepointer':( 'int', None, 'stdcall', 'ntdll.CsrAllocateMessagePointer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.csrcapturemessagebuffer':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageBuffer', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.csrcapturemessagemultiunicodestringsinplace':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageMultiUnicodeStringsInPlace', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrcapturemessagestring':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageString', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrcapturetimeout':( 'int', None, 'stdcall', 'ntdll.CsrCaptureTimeout', (('int', None), ('int', None)) ),
    'ntdll.csrclientcallserver':( 'int', None, 'stdcall', 'ntdll.CsrClientCallServer', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrclientconnecttoserver':( 'int', None, 'stdcall', 'ntdll.CsrClientConnectToServer', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.csrfreecapturebuffer':( 'int', None, 'stdcall', 'ntdll.CsrFreeCaptureBuffer', (('void *', 'ptr'),) ),
    'ntdll.csrgetprocessid':( 'int', None, 'cdecl', 'ntdll.CsrGetProcessId', () ),
    'ntdll.csridentifyalertablethread':( 'int', None, 'cdecl', 'ntdll.CsrIdentifyAlertableThread', () ),
    'ntdll.csrnewthread':( 'int', None, 'cdecl', 'ntdll.CsrNewThread', () ),
    'ntdll.csrprobeforread':( 'int', None, 'stdcall', 'ntdll.CsrProbeForRead', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrprobeforwrite':( 'int', None, 'stdcall', 'ntdll.CsrProbeForWrite', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrsetpriorityclass':( 'int', None, 'stdcall', 'ntdll.CsrSetPriorityClass', (('int', None), ('int', None)) ),
    'ntdll.dbgbreakpoint':( 'int', None, 'cdecl', 'ntdll.DbgBreakPoint', () ),
    'ntdll.dbgprint':( 'int', None, 'cdecl', 'ntdll.DbgPrint', (('int', None),) ),
    'ntdll.dbgprintex':( 'int', None, 'cdecl', 'ntdll.DbgPrintEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.dbgprintreturncontrolc':( 'int', None, 'cdecl', 'ntdll.DbgPrintReturnControlC', (('int', None),) ),
    'ntdll.dbgprompt':( 'int', None, 'stdcall', 'ntdll.DbgPrompt', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.dbgquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.DbgQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.dbgsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.DbgSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.dbguiconnecttodbg':( 'int', None, 'cdecl', 'ntdll.DbgUiConnectToDbg', () ),
    'ntdll.dbguicontinue':( 'int', None, 'stdcall', 'ntdll.DbgUiContinue', (('int', None), ('int', None)) ),
    'ntdll.dbguiconvertstatechangestructure':( 'int', None, 'stdcall', 'ntdll.DbgUiConvertStateChangeStructure', (('int', None), ('int', None)) ),
    'ntdll.dbguidebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.DbgUiDebugActiveProcess', (('int', None),) ),
    'ntdll.dbguigetthreaddebugobject':( 'int', None, 'cdecl', 'ntdll.DbgUiGetThreadDebugObject', () ),
    'ntdll.dbguiissueremotebreakin':( 'int', None, 'stdcall', 'ntdll.DbgUiIssueRemoteBreakin', (('int', None),) ),
    'ntdll.dbguiremotebreakin':( 'int', None, 'stdcall', 'ntdll.DbgUiRemoteBreakin', () ),
    'ntdll.dbguisetthreaddebugobject':( 'int', None, 'stdcall', 'ntdll.DbgUiSetThreadDebugObject', (('int', None),) ),
    'ntdll.dbguistopdebugging':( 'int', None, 'stdcall', 'ntdll.DbgUiStopDebugging', (('int', None),) ),
    'ntdll.dbguiwaitstatechange':( 'int', None, 'stdcall', 'ntdll.DbgUiWaitStateChange', (('int', None), ('int', None)) ),
    'ntdll.dbguserbreakpoint':( 'int', None, 'cdecl', 'ntdll.DbgUserBreakPoint', () ),
    'ntdll.kifastsystemcall':( 'int', None, 'cdecl', 'ntdll.KiFastSystemCall', () ),
    'ntdll.kifastsystemcallret':( 'int', None, 'cdecl', 'ntdll.KiFastSystemCallRet', () ),
    'ntdll.kiintsystemcall':( 'int', None, 'cdecl', 'ntdll.KiIntSystemCall', () ),
    'ntdll.kiraiseuserexceptiondispatcher':( 'int', None, 'cdecl', 'ntdll.KiRaiseUserExceptionDispatcher', () ),
    'ntdll.kiuserapcdispatcher':( 'int', None, 'cdecl', 'ntdll.KiUserApcDispatcher', (('int', None), ('int', None)) ),
    'ntdll.kiusercallbackdispatcher':( 'int', None, 'cdecl', 'ntdll.KiUserCallbackDispatcher', (('int', None),) ),
    'ntdll.kiuserexceptiondispatcher':( 'int', None, 'stdcall', 'ntdll.KiUserExceptionDispatcher', ( ('int', None),) ),
    'ntdll.ldraccessoutofprocessresource':( 'int', None, 'stdcall', 'ntdll.LdrAccessOutOfProcessResource', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldraccessresource':( 'int', None, 'stdcall', 'ntdll.LdrAccessResource', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldraddrefdll':( 'int', None, 'stdcall', 'ntdll.LdrAddRefDll', (('int', None), ('int', None)) ),
    'ntdll.ldralternateresourcesenabled':( 'int', None, 'cdecl', 'ntdll.LdrAlternateResourcesEnabled', () ),
    'ntdll.ldrcreateoutofprocessimage':( 'int', None, 'stdcall', 'ntdll.LdrCreateOutOfProcessImage', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrdestroyoutofprocessimage':( 'int', None, 'stdcall', 'ntdll.LdrDestroyOutOfProcessImage', (('int', None),) ),
    'ntdll.ldrdisablethreadcalloutsfordll':( 'int', None, 'stdcall', 'ntdll.LdrDisableThreadCalloutsForDll', (('int', None),) ),
    'ntdll.ldrenumresources':( 'int', None, 'stdcall', 'ntdll.LdrEnumResources', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrenumerateloadedmodules':( 'int', None, 'stdcall', 'ntdll.LdrEnumerateLoadedModules', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.ldrfindcreateprocessmanifest':( 'int', None, 'stdcall', 'ntdll.LdrFindCreateProcessManifest', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrfindentryforaddress':( 'int', None, 'stdcall', 'ntdll.LdrFindEntryForAddress', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresourcedirectory_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResourceDirectory_U', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresourceex_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResourceEx_U', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresource_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResource_U', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrflushalternateresourcemodules':( 'int', None, 'cdecl', 'ntdll.LdrFlushAlternateResourceModules', () ),
    'ntdll.ldrgetdllhandle':( 'int', None, 'stdcall', 'ntdll.LdrGetDllHandle', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrgetdllhandleex':( 'int', None, 'stdcall', 'ntdll.LdrGetDllHandleEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ldrgetprocedureaddress':( 'int', None, 'stdcall', 'ntdll.LdrGetProcedureAddress', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrhotpatchroutine':( 'int', None, 'cdecl', 'ntdll.LdrHotPatchRoutine', (('int', None),) ),
    'ntdll.ldrinitshimenginedynamic':( 'int', None, 'stdcall', 'ntdll.LdrInitShimEngineDynamic', (('int', None),) ),
    'ntdll.ldrinitializethunk':( 'int', None, 'stdcall', 'ntdll.LdrInitializeThunk', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrloadalternateresourcemodule':( 'int', None, 'stdcall', 'ntdll.LdrLoadAlternateResourceModule', (('int', None), ('int', None)) ),
    'ntdll.ldrloaddll':( 'int', None, 'stdcall', 'ntdll.LdrLoadDll', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrlockloaderlock':( 'int', None, 'stdcall', 'ntdll.LdrLockLoaderLock', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrprocessrelocationblock':( 'int', None, 'stdcall', 'ntdll.LdrProcessRelocationBlock', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrqueryimagefileexecutionoptions':( 'int', None, 'stdcall', 'ntdll.LdrQueryImageFileExecutionOptions', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrqueryprocessmoduleinformation':( 'int', None, 'stdcall', 'ntdll.LdrQueryProcessModuleInformation', ( ('int', None), ('int', None)) ),
    'ntdll.ldrsetappcompatdllredirectioncallback':( 'int', None, 'stdcall', 'ntdll.LdrSetAppCompatDllRedirectionCallback', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrsetdllmanifestprober':( 'int', None, 'stdcall', 'ntdll.LdrSetDllManifestProber', (('int', None),) ),
    'ntdll.ldrshutdownprocess':( 'int', None, 'cdecl', 'ntdll.LdrShutdownProcess', () ),
    'ntdll.ldrshutdownthread':( 'int', None, 'stdcall', 'ntdll.LdrShutdownThread', () ),
    'ntdll.ldrunloadalternateresourcemodule':( 'int', None, 'stdcall', 'ntdll.LdrUnloadAlternateResourceModule', (('int', None),) ),
    'ntdll.ldrunloaddll':( 'int', None, 'stdcall', 'ntdll.LdrUnloadDll', ( ('int', None),) ),
    'ntdll.ldrunlockloaderlock':( 'int', None, 'stdcall', 'ntdll.LdrUnlockLoaderLock', (('int', None), ('int', None)) ),
    'ntdll.ldrverifyimagematcheschecksum':( 'int', None, 'stdcall', 'ntdll.LdrVerifyImageMatchesChecksum', (('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'ntdll.nlsansicodepage':( 'int', None, 'cdecl', 'ntdll.NlsAnsiCodePage', () ),
    'ntdll.nlsmbcodepagetag':( 'int', None, 'cdecl', 'ntdll.NlsMbCodePageTag', () ),
    'ntdll.nlsmboemcodepagetag':( 'int', None, 'cdecl', 'ntdll.NlsMbOemCodePageTag', () ),
    'ntdll.ntacceptconnectport':( 'int', None, 'stdcall', 'ntdll.NtAcceptConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheck':( 'int', None, 'stdcall', 'ntdll.NtAccessCheck', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytype':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByType', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytypeandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlist':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultList', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlistandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultListAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlistandauditalarmbyhandle':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultListAndAuditAlarmByHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaddatom':( 'int', None, 'stdcall', 'ntdll.NtAddAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaddbootentry':( 'int', None, 'stdcall', 'ntdll.NtAddBootEntry', (('int', None), ('int', None)) ),
    'ntdll.ntadjustgroupstoken':( 'int', None, 'stdcall', 'ntdll.NtAdjustGroupsToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntadjustprivilegestoken':( 'int', None, 'stdcall', 'ntdll.NtAdjustPrivilegesToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntalertresumethread':( 'int', None, 'stdcall', 'ntdll.NtAlertResumeThread', (('int', None), ('int', None)) ),
    'ntdll.ntalertthread':( 'int', None, 'stdcall', 'ntdll.NtAlertThread', (('int', None),) ),
    'ntdll.ntallocatelocallyuniqueid':( 'int', None, 'stdcall', 'ntdll.NtAllocateLocallyUniqueId', (('int', None),) ),
    'ntdll.ntallocateuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtAllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntallocateuuids':( 'int', None, 'stdcall', 'ntdll.NtAllocateUuids', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntallocatevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtAllocateVirtualMemory', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntaremappedfilesthesame':( 'int', None, 'stdcall', 'ntdll.NtAreMappedFilesTheSame', (('int', None), ('int', None)) ),
    'ntdll.ntassignprocesstojobobject':( 'int', None, 'stdcall', 'ntdll.NtAssignProcessToJobObject', (('int', None), ('int', None)) ),
    'ntdll.ntcallbackreturn':( 'int', None, 'stdcall', 'ntdll.NtCallbackReturn', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcanceldevicewakeuprequest':( 'int', None, 'stdcall', 'ntdll.NtCancelDeviceWakeupRequest', (('int', None),) ),
    'ntdll.ntcanceliofile':( 'int', None, 'stdcall', 'ntdll.NtCancelIoFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntcanceltimer':( 'int', None, 'stdcall', 'ntdll.NtCancelTimer', (('int', None), ('int', None)) ),
    'ntdll.ntclearevent':( 'int', None, 'stdcall', 'ntdll.NtClearEvent', (('int', None),) ),
    'ntdll.ntclose':( 'int', None, 'stdcall', 'ntdll.NtClose', (('int', None),) ),
    'ntdll.ntcloseobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtCloseObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcompactkeys':( 'int', None, 'stdcall', 'ntdll.NtCompactKeys', (('int', None), ('int', None)) ),
    'ntdll.ntcomparetokens':( 'int', None, 'stdcall', 'ntdll.NtCompareTokens', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcompleteconnectport':( 'int', None, 'stdcall', 'ntdll.NtCompleteConnectPort', (('int', None),) ),
    'ntdll.ntcompresskey':( 'int', None, 'stdcall', 'ntdll.NtCompressKey', (('int', None),) ),
    'ntdll.ntconnectport':( 'int', None, 'stdcall', 'ntdll.NtConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcontinue':( 'int', None, 'stdcall', 'ntdll.NtContinue', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatedebugobject':( 'int', None, 'stdcall', 'ntdll.NtCreateDebugObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatedirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtCreateDirectoryObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateevent':( 'int', None, 'stdcall', 'ntdll.NtCreateEvent', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateeventpair':( 'int', None, 'stdcall', 'ntdll.NtCreateEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatefile':( 'int', None, 'stdcall', 'ntdll.NtCreateFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateiocompletion':( 'int', None, 'stdcall', 'ntdll.NtCreateIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatejobobject':( 'int', None, 'stdcall', 'ntdll.NtCreateJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatejobset':( 'int', None, 'stdcall', 'ntdll.NtCreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatekey':( 'int', None, 'stdcall', 'ntdll.NtCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntcreatekeyedevent':( 'int', None, 'stdcall', 'ntdll.NtCreateKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatemailslotfile':( 'int', None, 'stdcall', 'ntdll.NtCreateMailslotFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatemutant':( 'int', None, 'stdcall', 'ntdll.NtCreateMutant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatenamedpipefile':( 'int', None, 'stdcall', 'ntdll.NtCreateNamedPipeFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatepagingfile':( 'int', None, 'stdcall', 'ntdll.NtCreatePagingFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateport':( 'int', None, 'stdcall', 'ntdll.NtCreatePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprocess':( 'int', None, 'stdcall', 'ntdll.NtCreateProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprocessex':( 'int', None, 'stdcall', 'ntdll.NtCreateProcessEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprofile':( 'int', None, 'stdcall', 'ntdll.NtCreateProfile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesection':( 'int', None, 'stdcall', 'ntdll.NtCreateSection', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesemaphore':( 'int', None, 'stdcall', 'ntdll.NtCreateSemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtCreateSymbolicLinkObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatethread':( 'int', None, 'stdcall', 'ntdll.NtCreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatetimer':( 'int', None, 'stdcall', 'ntdll.NtCreateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatetoken':( 'int', None, 'stdcall', 'ntdll.NtCreateToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatewaitableport':( 'int', None, 'stdcall', 'ntdll.NtCreateWaitablePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcurrentteb':( 'int', None, 'cdecl', 'ntdll.NtCurrentTeb', () ),
    'ntdll.ntdebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.NtDebugActiveProcess', (('int', None), ('int', None)) ),
    'ntdll.ntdebugcontinue':( 'int', None, 'stdcall', 'ntdll.NtDebugContinue', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdelayexecution':( 'int', None, 'stdcall', 'ntdll.NtDelayExecution', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntdeleteatom':( 'int', None, 'stdcall', 'ntdll.NtDeleteAtom', (('int', None),) ),
    'ntdll.ntdeletebootentry':( 'int', None, 'stdcall', 'ntdll.NtDeleteBootEntry', (('int', None),) ),
    'ntdll.ntdeletefile':( 'int', None, 'stdcall', 'ntdll.NtDeleteFile', (('int', None),) ),
    'ntdll.ntdeletekey':( 'int', None, 'stdcall', 'ntdll.NtDeleteKey', (('int', None),) ),
    'ntdll.ntdeleteobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtDeleteObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdeletevaluekey':( 'int', None, 'stdcall', 'ntdll.NtDeleteValueKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntdeviceiocontrolfile':( 'int', None, 'stdcall', 'ntdll.NtDeviceIoControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdisplaystring':( 'int', None, 'stdcall', 'ntdll.NtDisplayString', (('int', None),) ),
    'ntdll.ntduplicateobject':( 'int', None, 'stdcall', 'ntdll.NtDuplicateObject', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntduplicatetoken':( 'int', None, 'stdcall', 'ntdll.NtDuplicateToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntenumeratebootentries':( 'int', None, 'stdcall', 'ntdll.NtEnumerateBootEntries', (('int', None), ('int', None)) ),
    'ntdll.ntenumeratekey':( 'int', None, 'stdcall', 'ntdll.NtEnumerateKey', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntenumeratesystemenvironmentvaluesex':( 'int', None, 'stdcall', 'ntdll.NtEnumerateSystemEnvironmentValuesEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntenumeratevaluekey':( 'int', None, 'stdcall', 'ntdll.NtEnumerateValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntextendsection':( 'int', None, 'stdcall', 'ntdll.NtExtendSection', (('int', None), ('int', None)) ),
    'ntdll.ntfiltertoken':( 'int', None, 'stdcall', 'ntdll.NtFilterToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntfindatom':( 'int', None, 'stdcall', 'ntdll.NtFindAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushbuffersfile':( 'int', None, 'stdcall', 'ntdll.NtFlushBuffersFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntflushinstructioncache':( 'int', None, 'stdcall', 'ntdll.NtFlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushkey':( 'int', None, 'stdcall', 'ntdll.NtFlushKey', (('int', None),) ),
    'ntdll.ntflushvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtFlushVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushwritebuffer':( 'int', None, 'cdecl', 'ntdll.NtFlushWriteBuffer', () ),
    'ntdll.ntfreeuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtFreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntfreevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtFreeVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntfscontrolfile':( 'int', None, 'stdcall', 'ntdll.NtFsControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntgetcontextthread':( 'int', None, 'stdcall', 'ntdll.NtGetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntgetdevicepowerstate':( 'int', None, 'stdcall', 'ntdll.NtGetDevicePowerState', (('int', None), ('int', None)) ),
    'ntdll.ntgetplugplayevent':( 'int', None, 'stdcall', 'ntdll.NtGetPlugPlayEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntgetwritewatch':( 'int', None, 'stdcall', 'ntdll.NtGetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntimpersonateanonymoustoken':( 'int', None, 'stdcall', 'ntdll.NtImpersonateAnonymousToken', (('int', None),) ),
    'ntdll.ntimpersonateclientofport':( 'int', None, 'stdcall', 'ntdll.NtImpersonateClientOfPort', (('int', None), ('int', None)) ),
    'ntdll.ntimpersonatethread':( 'int', None, 'stdcall', 'ntdll.NtImpersonateThread', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntinitializeregistry':( 'int', None, 'stdcall', 'ntdll.NtInitializeRegistry', (('int', None),) ),
    'ntdll.ntinitiatepoweraction':( 'int', None, 'stdcall', 'ntdll.NtInitiatePowerAction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntisprocessinjob':( 'int', None, 'stdcall', 'ntdll.NtIsProcessInJob', (('int', None), ('int', None)) ),
    'ntdll.ntissystemresumeautomatic':( 'int', None, 'cdecl', 'ntdll.NtIsSystemResumeAutomatic', () ),
    'ntdll.ntlistenport':( 'int', None, 'stdcall', 'ntdll.NtListenPort', (('int', None), ('int', None)) ),
    'ntdll.ntloaddriver':( 'int', None, 'stdcall', 'ntdll.NtLoadDriver', (('int', None),) ),
    'ntdll.ntloadkey':( 'int', None, 'stdcall', 'ntdll.NtLoadKey', (('int', None), ('int', None)) ),
    'ntdll.ntloadkey2':( 'int', None, 'stdcall', 'ntdll.NtLoadKey2', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntlockfile':( 'int', None, 'stdcall', 'ntdll.NtLockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntlockproductactivationkeys':( 'int', None, 'stdcall', 'ntdll.NtLockProductActivationKeys', (('int', None), ('int', None)) ),
    'ntdll.ntlockregistrykey':( 'int', None, 'stdcall', 'ntdll.NtLockRegistryKey', (('int', None),) ),
    'ntdll.ntlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtLockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmakepermanentobject':( 'int', None, 'stdcall', 'ntdll.NtMakePermanentObject', (('int', None),) ),
    'ntdll.ntmaketemporaryobject':( 'int', None, 'stdcall', 'ntdll.NtMakeTemporaryObject', (('int', None),) ),
    'ntdll.ntmapuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtMapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'ntdll.NtMapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmapviewofsection':( 'int', None, 'stdcall', 'ntdll.NtMapViewOfSection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmodifybootentry':( 'int', None, 'stdcall', 'ntdll.NtModifyBootEntry', (('int', None),) ),
    'ntdll.ntnotifychangedirectoryfile':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntnotifychangekey':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntnotifychangemultiplekeys':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeMultipleKeys', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopendirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtOpenDirectoryObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenevent':( 'int', None, 'stdcall', 'ntdll.NtOpenEvent', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopeneventpair':( 'int', None, 'stdcall', 'ntdll.NtOpenEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenfile':( 'int', None, 'stdcall', 'ntdll.NtOpenFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntopeniocompletion':( 'int', None, 'stdcall', 'ntdll.NtOpenIoCompletion', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenjobobject':( 'int', None, 'stdcall', 'ntdll.NtOpenJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenkey':( 'int', None, 'stdcall', 'ntdll.NtOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenkeyedevent':( 'int', None, 'stdcall', 'ntdll.NtOpenKeyedEvent', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenmutant':( 'int', None, 'stdcall', 'ntdll.NtOpenMutant', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtOpenObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenprocess':( 'int', None, 'stdcall', 'ntdll.NtOpenProcess', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntopenprocesstoken':( 'int', None, 'stdcall', 'ntdll.NtOpenProcessToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenprocesstokenex':( 'int', None, 'stdcall', 'ntdll.NtOpenProcessTokenEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopensection':( 'int', None, 'stdcall', 'ntdll.NtOpenSection', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopensemaphore':( 'int', None, 'stdcall', 'ntdll.NtOpenSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopensymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtOpenSymbolicLinkObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenthread':( 'int', None, 'stdcall', 'ntdll.NtOpenThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntopenthreadtoken':( 'int', None, 'stdcall', 'ntdll.NtOpenThreadToken', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenthreadtokenex':( 'int', None, 'stdcall', 'ntdll.NtOpenThreadTokenEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopentimer':( 'int', None, 'stdcall', 'ntdll.NtOpenTimer', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntplugplaycontrol':( 'int', None, 'stdcall', 'ntdll.NtPlugPlayControl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntpowerinformation':( 'int', None, 'stdcall', 'ntdll.NtPowerInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprivilegecheck':( 'int', None, 'stdcall', 'ntdll.NtPrivilegeCheck', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntprivilegeobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtPrivilegeObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprivilegedserviceauditalarm':( 'int', None, 'stdcall', 'ntdll.NtPrivilegedServiceAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprotectvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtProtectVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntpulseevent':( 'int', None, 'stdcall', 'ntdll.NtPulseEvent', (('int', None), ('int', None)) ),
    'ntdll.ntqueryattributesfile':( 'int', None, 'stdcall', 'ntdll.NtQueryAttributesFile', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntquerybootentryorder':( 'int', None, 'stdcall', 'ntdll.NtQueryBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.ntquerybootoptions':( 'int', None, 'stdcall', 'ntdll.NtQueryBootOptions', (('int', None), ('int', None)) ),
    'ntdll.ntquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.NtQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.ntquerydefaultlocale':( 'int', None, 'stdcall', 'ntdll.NtQueryDefaultLocale', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerydefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.NtQueryDefaultUILanguage', (('int', None),) ),
    'ntdll.ntquerydirectoryfile':( 'int', None, 'stdcall', 'ntdll.NtQueryDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerydirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtQueryDirectoryObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryeafile':( 'int', None, 'stdcall', 'ntdll.NtQueryEaFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryevent':( 'int', None, 'stdcall', 'ntdll.NtQueryEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryfullattributesfile':( 'int', None, 'stdcall', 'ntdll.NtQueryFullAttributesFile', (('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationatom':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationAtom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationjobobject':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationport':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationprocess':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationthread':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationtoken':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryinstalluilanguage':( 'int', None, 'stdcall', 'ntdll.NtQueryInstallUILanguage', (('int', None),) ),
    'ntdll.ntqueryintervalprofile':( 'int', None, 'stdcall', 'ntdll.NtQueryIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.ntqueryiocompletion':( 'int', None, 'stdcall', 'ntdll.NtQueryIoCompletion', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerykey':( 'int', None, 'stdcall', 'ntdll.NtQueryKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerymultiplevaluekey':( 'int', None, 'stdcall', 'ntdll.NtQueryMultipleValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerymutant':( 'int', None, 'stdcall', 'ntdll.NtQueryMutant', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryobject':( 'int', None, 'stdcall', 'ntdll.NtQueryObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryopensubkeys':( 'int', None, 'stdcall', 'ntdll.NtQueryOpenSubKeys', (('int', None), ('int', None)) ),
    'ntdll.ntqueryperformancecounter':( 'int', None, 'stdcall', 'ntdll.NtQueryPerformanceCounter', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntqueryportinformationprocess':( 'int', None, 'cdecl', 'ntdll.NtQueryPortInformationProcess', () ),
    'ntdll.ntqueryquotainformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysection':( 'int', None, 'stdcall', 'ntdll.NtQuerySection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.NtQuerySecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerysemaphore':( 'int', None, 'stdcall', 'ntdll.NtQuerySemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtQuerySymbolicLinkObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemEnvironmentValue', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysysteminformation':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerysystemtime':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemTime', (('void *', 'ptr'),) ),
    'ntdll.ntquerytimer':( 'int', None, 'stdcall', 'ntdll.NtQueryTimer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerytimerresolution':( 'int', None, 'stdcall', 'ntdll.NtQueryTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.NtQueryValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtQueryVirtualMemory', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryVolumeInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueueapcthread':( 'int', None, 'stdcall', 'ntdll.NtQueueApcThread', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntraiseexception':( 'int', None, 'stdcall', 'ntdll.NtRaiseException', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntraiseharderror':( 'int', None, 'stdcall', 'ntdll.NtRaiseHardError', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntreadfile':( 'int', None, 'stdcall', 'ntdll.NtReadFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntreadfilescatter':( 'int', None, 'stdcall', 'ntdll.NtReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreadrequestdata':( 'int', None, 'stdcall', 'ntdll.NtReadRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreadvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtReadVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntregisterthreadterminateport':( 'int', None, 'stdcall', 'ntdll.NtRegisterThreadTerminatePort', (('int', None),) ),
    'ntdll.ntreleasekeyedevent':( 'int', None, 'stdcall', 'ntdll.NtReleaseKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreleasemutant':( 'int', None, 'stdcall', 'ntdll.NtReleaseMutant', (('int', None), ('int', None)) ),
    'ntdll.ntreleasesemaphore':( 'int', None, 'stdcall', 'ntdll.NtReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntremoveiocompletion':( 'int', None, 'stdcall', 'ntdll.NtRemoveIoCompletion', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntremoveprocessdebug':( 'int', None, 'stdcall', 'ntdll.NtRemoveProcessDebug', (('int', None), ('int', None)) ),
    'ntdll.ntrenamekey':( 'int', None, 'stdcall', 'ntdll.NtRenameKey', (('int', None), ('int', None)) ),
    'ntdll.ntreplacekey':( 'int', None, 'stdcall', 'ntdll.NtReplaceKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplyport':( 'int', None, 'stdcall', 'ntdll.NtReplyPort', (('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreceiveport':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReceivePort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreceiveportex':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReceivePortEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreplyport':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReplyPort', (('int', None), ('int', None)) ),
    'ntdll.ntrequestdevicewakeup':( 'int', None, 'stdcall', 'ntdll.NtRequestDeviceWakeup', (('int', None),) ),
    'ntdll.ntrequestport':( 'int', None, 'stdcall', 'ntdll.NtRequestPort', (('int', None), ('int', None)) ),
    'ntdll.ntrequestwaitreplyport':( 'int', None, 'stdcall', 'ntdll.NtRequestWaitReplyPort', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntrequestwakeuplatency':( 'int', None, 'stdcall', 'ntdll.NtRequestWakeupLatency', (('int', None),) ),
    'ntdll.ntresetevent':( 'int', None, 'stdcall', 'ntdll.NtResetEvent', (('int', None), ('int', None)) ),
    'ntdll.ntresetwritewatch':( 'int', None, 'stdcall', 'ntdll.NtResetWriteWatch', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntrestorekey':( 'int', None, 'stdcall', 'ntdll.NtRestoreKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntresumeprocess':( 'int', None, 'stdcall', 'ntdll.NtResumeProcess', (('int', None),) ),
    'ntdll.ntresumethread':( 'int', None, 'stdcall', 'ntdll.NtResumeThread', (('int', None), ('int', None)) ),
    'ntdll.ntsavekey':( 'int', None, 'stdcall', 'ntdll.NtSaveKey', (('int', None), ('int', None)) ),
    'ntdll.ntsavekeyex':( 'int', None, 'stdcall', 'ntdll.NtSaveKeyEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsavemergedkeys':( 'int', None, 'stdcall', 'ntdll.NtSaveMergedKeys', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsecureconnectport':( 'int', None, 'stdcall', 'ntdll.NtSecureConnectPort', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntsetbootentryorder':( 'int', None, 'stdcall', 'ntdll.NtSetBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.ntsetbootoptions':( 'int', None, 'stdcall', 'ntdll.NtSetBootOptions', (('int', None), ('int', None)) ),
    'ntdll.ntsetcontextthread':( 'int', None, 'stdcall', 'ntdll.NtSetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.NtSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetdefaultharderrorport':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultHardErrorPort', (('int', None),) ),
    'ntdll.ntsetdefaultlocale':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultLocale', (('int', None), ('int', None)) ),
    'ntdll.ntsetdefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultUILanguage', (('int', None),) ),
    'ntdll.ntseteafile':( 'int', None, 'stdcall', 'ntdll.NtSetEaFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetevent':( 'int', None, 'stdcall', 'ntdll.NtSetEvent', (('int', None), ('int', None)) ),
    'ntdll.ntseteventboostpriority':( 'int', None, 'stdcall', 'ntdll.NtSetEventBoostPriority', (('int', None),) ),
    'ntdll.ntsethigheventpair':( 'int', None, 'stdcall', 'ntdll.NtSetHighEventPair', (('int', None),) ),
    'ntdll.ntsethighwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.NtSetHighWaitLowEventPair', (('int', None),) ),
    'ntdll.ntsetinformationdebugobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationDebugObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationjobobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationkey':( 'int', None, 'stdcall', 'ntdll.NtSetInformationKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationprocess':( 'int', None, 'stdcall', 'ntdll.NtSetInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationthread':( 'int', None, 'stdcall', 'ntdll.NtSetInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationtoken':( 'int', None, 'stdcall', 'ntdll.NtSetInformationToken', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetintervalprofile':( 'int', None, 'stdcall', 'ntdll.NtSetIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.ntsetiocompletion':( 'int', None, 'stdcall', 'ntdll.NtSetIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetldtentries':( 'int', None, 'stdcall', 'ntdll.NtSetLdtEntries', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetloweventpair':( 'int', None, 'stdcall', 'ntdll.NtSetLowEventPair', (('int', None),) ),
    'ntdll.ntsetlowwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.NtSetLowWaitHighEventPair', (('int', None),) ),
    'ntdll.ntsetquotainformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.NtSetSecurityObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntsetsystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.NtSetSystemEnvironmentValue', (('int', None), ('int', None)) ),
    'ntdll.ntsetsystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.NtSetSystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsysteminformation':( 'int', None, 'stdcall', 'ntdll.NtSetSystemInformation', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsystempowerstate':( 'int', None, 'stdcall', 'ntdll.NtSetSystemPowerState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsystemtime':( 'int', None, 'stdcall', 'ntdll.NtSetSystemTime', (('int', None), ('int', None)) ),
    'ntdll.ntsetthreadexecutionstate':( 'int', None, 'stdcall', 'ntdll.NtSetThreadExecutionState', (('int', None), ('int', None)) ),
    'ntdll.ntsettimer':( 'int', None, 'stdcall', 'ntdll.NtSetTimer', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsettimerresolution':( 'int', None, 'stdcall', 'ntdll.NtSetTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetuuidseed':( 'int', None, 'stdcall', 'ntdll.NtSetUuidSeed', (('int', None),) ),
    'ntdll.ntsetvaluekey':( 'int', None, 'stdcall', 'ntdll.NtSetValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetVolumeInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntshutdownsystem':( 'int', None, 'stdcall', 'ntdll.NtShutdownSystem', (('int', None),) ),
    'ntdll.ntsignalandwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.NtSignalAndWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntstartprofile':( 'int', None, 'stdcall', 'ntdll.NtStartProfile', (('int', None),) ),
    'ntdll.ntstopprofile':( 'int', None, 'stdcall', 'ntdll.NtStopProfile', (('int', None),) ),
    'ntdll.ntsuspendprocess':( 'int', None, 'stdcall', 'ntdll.NtSuspendProcess', (('int', None),) ),
    'ntdll.ntsuspendthread':( 'int', None, 'stdcall', 'ntdll.NtSuspendThread', (('int', None), ('int', None)) ),
    'ntdll.ntsystemdebugcontrol':( 'int', None, 'stdcall', 'ntdll.NtSystemDebugControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntterminatejobobject':( 'int', None, 'stdcall', 'ntdll.NtTerminateJobObject', (('int', None), ('int', None)) ),
    'ntdll.ntterminateprocess':( 'int', None, 'stdcall', 'ntdll.NtTerminateProcess', (('int', None), ('int', None)) ),
    'ntdll.ntterminatethread':( 'int', None, 'stdcall', 'ntdll.NtTerminateThread', (('int', None), ('int', None)) ),
    'ntdll.nttestalert':( 'int', None, 'cdecl', 'ntdll.NtTestAlert', () ),
    'ntdll.nttraceevent':( 'int', None, 'stdcall', 'ntdll.NtTraceEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.nttranslatefilepath':( 'int', None, 'stdcall', 'ntdll.NtTranslateFilePath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunloaddriver':( 'int', None, 'stdcall', 'ntdll.NtUnloadDriver', (('int', None),) ),
    'ntdll.ntunloadkey':( 'int', None, 'stdcall', 'ntdll.NtUnloadKey', (('int', None),) ),
    'ntdll.ntunloadkeyex':( 'int', None, 'stdcall', 'ntdll.NtUnloadKeyEx', (('int', None), ('int', None)) ),
    'ntdll.ntunlockfile':( 'int', None, 'stdcall', 'ntdll.NtUnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtUnlockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunmapviewofsection':( 'int', None, 'stdcall', 'ntdll.NtUnmapViewOfSection', (('int', None), ('int', None)) ),
    'ntdll.ntvdmcontrol':( 'int', None, 'stdcall', 'ntdll.NtVdmControl', (('int', None), ('int', None)) ),
    'ntdll.ntwaitfordebugevent':( 'int', None, 'stdcall', 'ntdll.NtWaitForDebugEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitforkeyedevent':( 'int', None, 'stdcall', 'ntdll.NtWaitForKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitformultipleobjects':( 'int', None, 'stdcall', 'ntdll.NtWaitForMultipleObjects', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.NtWaitForSingleObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.NtWaitHighEventPair', (('int', None),) ),
    'ntdll.ntwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.NtWaitLowEventPair', (('int', None),) ),
    'ntdll.ntwritefile':( 'int', None, 'stdcall', 'ntdll.NtWriteFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntwritefilegather':( 'int', None, 'stdcall', 'ntdll.NtWriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwriterequestdata':( 'int', None, 'stdcall', 'ntdll.NtWriteRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwritevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtWriteVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntyieldexecution':( 'int', None, 'cdecl', 'ntdll.NtYieldExecution', () ),
    'ntdll.pfxfindprefix':( 'int', None, 'stdcall', 'ntdll.PfxFindPrefix', (('int', None), ('int', None)) ),
    'ntdll.pfxinitialize':( 'int', None, 'stdcall', 'ntdll.PfxInitialize', (('int', None),) ),
    'ntdll.pfxinsertprefix':( 'int', None, 'stdcall', 'ntdll.PfxInsertPrefix', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.pfxremoveprefix':( 'int', None, 'stdcall', 'ntdll.PfxRemovePrefix', (('int', None), ('int', None)) ),
    'ntdll.propertylengthasvariant':( 'int', None, 'stdcall', 'ntdll.PropertyLengthAsVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlabortrxact':( 'int', None, 'stdcall', 'ntdll.RtlAbortRXact', (('int', None),) ),
    'ntdll.rtlabsolutetoselfrelativesd':( 'int', None, 'stdcall', 'ntdll.RtlAbsoluteToSelfRelativeSD', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlacquirepeblock':( 'int', None, 'cdecl', 'ntdll.RtlAcquirePebLock', () ),
    'ntdll.rtlacquireresourceexclusive':( 'int', None, 'stdcall', 'ntdll.RtlAcquireResourceExclusive', ( ('int', None), ('int', None)) ),
    'ntdll.rtlacquireresourceshared':( 'int', None, 'stdcall', 'ntdll.RtlAcquireResourceShared', (('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContext', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontextex':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContextEx', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontextunsafefast':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContextUnsafeFast', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdaccessallowedace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessallowedaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessallowedobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdace':( 'int', None, 'stdcall', 'ntdll.RtlAddAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdactiontorxact':( 'int', None, 'stdcall', 'ntdll.RtlAddActionToRXact', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdatomtoatomtable':( 'int', None, 'stdcall', 'ntdll.RtlAddAtomToAtomTable', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdattributeactiontorxact':( 'int', None, 'stdcall', 'ntdll.RtlAddAttributeActionToRXact', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdauditaccessace':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdauditaccessaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdauditaccessobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdcompoundace':( 'int', None, 'stdcall', 'ntdll.RtlAddCompoundAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtladdrange':( 'int', None, 'stdcall', 'ntdll.RtlAddRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdrefactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlAddRefActivationContext', (('int', None),) ),
    'ntdll.rtladdrefmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlAddRefMemoryStream', (('int', None),) ),
    'ntdll.rtladdvectoredexceptionhandler':( 'int', None, 'stdcall', 'ntdll.RtlAddVectoredExceptionHandler', ( ('int', None), ('int', None)) ),
    'ntdll.rtladdressinsectiontable':( 'int', None, 'stdcall', 'ntdll.RtlAddressInSectionTable', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladjustprivilege':( 'int', None, 'stdcall', 'ntdll.RtlAdjustPrivilege', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlallocateandinitializesid':( 'int', None, 'stdcall', 'ntdll.RtlAllocateAndInitializeSid', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlallocatehandle':( 'int', None, 'stdcall', 'ntdll.RtlAllocateHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlallocateheap':( 'int', None, 'stdcall', 'ntdll.RtlAllocateHeap', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlansichartounicodechar':( 'int', None, 'stdcall', 'ntdll.RtlAnsiCharToUnicodeChar', (('void *', 'ptr'),) ),
    'ntdll.rtlansistringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlAnsiStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlansistringtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlAnsiStringToUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlappendasciiztostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendAsciizToString', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlappendpathelement':( 'int', None, 'stdcall', 'ntdll.RtlAppendPathElement', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlappendstringtostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendStringToString', (('int', None), ('int', None)) ),
    'ntdll.rtlappendunicodestringtostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendUnicodeStringToString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlappendunicodetostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendUnicodeToString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlapplicationverifierstop':( 'int', None, 'stdcall', 'ntdll.RtlApplicationVerifierStop', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlapplyrxact':( 'int', None, 'stdcall', 'ntdll.RtlApplyRXact', (('int', None),) ),
    'ntdll.rtlapplyrxactnoflush':( 'int', None, 'stdcall', 'ntdll.RtlApplyRXactNoFlush', (('int', None),) ),
    'ntdll.rtlareallaccessesgranted':( 'int', None, 'stdcall', 'ntdll.RtlAreAllAccessesGranted', (('int', None), ('int', None)) ),
    'ntdll.rtlareanyaccessesgranted':( 'int', None, 'stdcall', 'ntdll.RtlAreAnyAccessesGranted', (('int', None), ('int', None)) ),
    'ntdll.rtlarebitsclear':( 'int', None, 'stdcall', 'ntdll.RtlAreBitsClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlarebitsset':( 'int', None, 'stdcall', 'ntdll.RtlAreBitsSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlassert':( 'int', None, 'stdcall', 'ntdll.RtlAssert', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlassert2':( 'int', None, 'stdcall', 'ntdll.RtlAssert2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcanceltimer':( 'int', None, 'stdcall', 'ntdll.RtlCancelTimer', ( ('int', None), ('int', None)) ),
    'ntdll.rtlcapturecontext':( 'int', None, 'stdcall', 'ntdll.RtlCaptureContext', (('void *', 'ptr'),) ),
    'ntdll.rtlcapturestackbacktrace':( 'int', None, 'stdcall', 'ntdll.RtlCaptureStackBackTrace', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcapturestackcontext':( 'int', None, 'stdcall', 'ntdll.RtlCaptureStackContext', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlchartointeger':( 'int', None, 'stdcall', 'ntdll.RtlCharToInteger', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcheckfororphanedcriticalsections':( 'int', None, 'stdcall', 'ntdll.RtlCheckForOrphanedCriticalSections', ( ('int', None),) ),
    'ntdll.rtlcheckprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlCheckProcessParameters', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcheckregistrykey':( 'int', None, 'stdcall', 'ntdll.RtlCheckRegistryKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlclearallbits':( 'int', None, 'stdcall', 'ntdll.RtlClearAllBits', (('int', None),) ),
    'ntdll.rtlclearbits':( 'int', None, 'stdcall', 'ntdll.RtlClearBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlclonememorystream':( 'int', None, 'stdcall', 'ntdll.RtlCloneMemoryStream', (('int', None), ('int', None)) ),
    'ntdll.rtlcommitmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlCommitMemoryStream', (('int', None), ('int', None)) ),
    'ntdll.rtlcompactheap':( 'int', None, 'stdcall', 'ntdll.RtlCompactHeap', ( ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcomparememory':( 'int', None, 'stdcall', 'ntdll.RtlCompareMemory', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcomparememoryulong':( 'int', None, 'stdcall', 'ntdll.RtlCompareMemoryUlong', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomparestring':( 'int', None, 'stdcall', 'ntdll.RtlCompareString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcompareunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCompareUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcompressbuffer':( 'int', None, 'stdcall', 'ntdll.RtlCompressBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputecrc32':( 'int', None, 'stdcall', 'ntdll.RtlComputeCrc32', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputeimporttablehash':( 'int', None, 'stdcall', 'ntdll.RtlComputeImportTableHash', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputeprivatizeddllname_u':( 'int', None, 'stdcall', 'ntdll.RtlComputePrivatizedDllName_U', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlconsolemultibytetounicoden':( 'int', None, 'stdcall', 'ntdll.RtlConsoleMultiByteToUnicodeN', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertexclusivetoshared':( 'int', None, 'stdcall', 'ntdll.RtlConvertExclusiveToShared', ( ('int', None),) ),
    'ntdll.rtlconvertlongtolargeinteger':( 'int', None, 'stdcall', 'ntdll.RtlConvertLongToLargeInteger', (('int', None),) ),
    'ntdll.rtlconvertpropertytovariant':( 'int', None, 'stdcall', 'ntdll.RtlConvertPropertyToVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertsharedtoexclusive':( 'int', None, 'stdcall', 'ntdll.RtlConvertSharedToExclusive', ( ('int', None),) ),
    'ntdll.rtlconvertsidtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlConvertSidToUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlconverttoautoinheritsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlConvertToAutoInheritSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertuilisttoapilist':( 'int', None, 'stdcall', 'ntdll.RtlConvertUiListToApiList', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlconvertulongtolargeinteger':( 'int', None, 'stdcall', 'ntdll.RtlConvertUlongToLargeInteger', (('int', None),) ),
    'ntdll.rtlconvertvarianttoproperty':( 'int', None, 'stdcall', 'ntdll.RtlConvertVariantToProperty', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyluid':( 'int', None, 'stdcall', 'ntdll.RtlCopyLuid', (('int', None), ('int', None)) ),
    'ntdll.rtlcopyluidandattributesarray':( 'int', None, 'stdcall', 'ntdll.RtlCopyLuidAndAttributesArray', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopymemorystreamto':( 'int', None, 'stdcall', 'ntdll.RtlCopyMemoryStreamTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyoutofprocessmemorystreamto':( 'int', None, 'stdcall', 'ntdll.RtlCopyOutOfProcessMemoryStreamTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyrangelist':( 'int', None, 'stdcall', 'ntdll.RtlCopyRangeList', (('int', None), ('int', None)) ),
    'ntdll.rtlcopysecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlCopySecurityDescriptor', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcopysid':( 'int', None, 'stdcall', 'ntdll.RtlCopySid', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcopysidandattributesarray':( 'int', None, 'stdcall', 'ntdll.RtlCopySidAndAttributesArray', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlcopystring':( 'int', None, 'stdcall', 'ntdll.RtlCopyString', (('int', None), ('int', None)) ),
    'ntdll.rtlcopyunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCopyUnicodeString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcreateacl':( 'int', None, 'stdcall', 'ntdll.RtlCreateAcl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlCreateActivationContext', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateandsetsd':( 'int', None, 'stdcall', 'ntdll.RtlCreateAndSetSD', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateatomtable':( 'int', None, 'stdcall', 'ntdll.RtlCreateAtomTable', (('int', None), ('int', None)) ),
    'ntdll.rtlcreatebootstatusdatafile':( 'int', None, 'cdecl', 'ntdll.RtlCreateBootStatusDataFile', () ),
    'ntdll.rtlcreateenvironment':( 'int', None, 'stdcall', 'ntdll.RtlCreateEnvironment', (('int', None), ('int', None)) ),
    'ntdll.rtlcreateheap':( 'int', None, 'stdcall', 'ntdll.RtlCreateHeap', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlCreateProcessParameters', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreatequerydebugbuffer':( 'int', None, 'stdcall', 'ntdll.RtlCreateQueryDebugBuffer', (('int', None), ('int', None)) ),
    'ntdll.rtlcreateregistrykey':( 'int', None, 'stdcall', 'ntdll.RtlCreateRegistryKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreatesecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlCreateSecurityDescriptor', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreateservicesid':( 'int', None, 'stdcall', 'ntdll.RtlCreateServiceSid', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreatesystemvolumeinformationfolder':( 'int', None, 'stdcall', 'ntdll.RtlCreateSystemVolumeInformationFolder', (('int', None),) ),
    'ntdll.rtlcreatetagheap':( 'int', None, 'stdcall', 'ntdll.RtlCreateTagHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreatetimer':( 'int', None, 'stdcall', 'ntdll.RtlCreateTimer', ( ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreatetimerqueue':( 'int', None, 'stdcall', 'ntdll.RtlCreateTimerQueue', ( ('void *', 'ptr'),) ),
    'ntdll.rtlcreateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCreateUnicodeString', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateunicodestringfromasciiz':( 'int', None, 'stdcall', 'ntdll.RtlCreateUnicodeStringFromAsciiz', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreateuserprocess':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateusersecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserSecurityObject', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateuserthread':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserThread', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcustomcptounicoden':( 'int', None, 'stdcall', 'ntdll.RtlCustomCPToUnicodeN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcutovertimetosystemtime':( 'int', None, 'msfastcall', 'ntdll.RtlCutoverTimeToSystemTime', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldenormalizeprocessparams':( 'int', None, 'stdcall', 'ntdll.RtlDeNormalizeProcessParams', (('int', None),) ),
    'ntdll.rtldeactivateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlDeactivateActivationContext', (('int', None), ('int', None)) ),
    'ntdll.rtldeactivateactivationcontextunsafefast':( 'int', None, 'stdcall', 'ntdll.RtlDeactivateActivationContextUnsafeFast', (('int', None),) ),
    'ntdll.rtldebugprinttimes':( 'int', None, 'cdecl', 'ntdll.RtlDebugPrintTimes', () ),
    'ntdll.rtldecodepointer':( 'int', None, 'stdcall', 'ntdll.RtlDecodePointer', (('int', None),) ),
    'ntdll.rtldecodesystempointer':( 'int', None, 'stdcall', 'ntdll.RtlDecodeSystemPointer', (('int', None),) ),
    'ntdll.rtldecompressbuffer':( 'int', None, 'stdcall', 'ntdll.RtlDecompressBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldecompressfragment':( 'int', None, 'stdcall', 'ntdll.RtlDecompressFragment', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldefaultnpacl':( 'int', None, 'stdcall', 'ntdll.RtlDefaultNpAcl', (('int', None),) ),
    'ntdll.rtldelete':( 'int', None, 'stdcall', 'ntdll.RtlDelete', (('int', None),) ),
    'ntdll.rtldeleteace':( 'int', None, 'stdcall', 'ntdll.RtlDeleteAce', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteatomfromatomtable':( 'int', None, 'stdcall', 'ntdll.RtlDeleteAtomFromAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtldeletecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlDeleteCriticalSection', ( ('int', None),) ),
    'ntdll.rtldeleteelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlDeleteElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlDeleteElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtldeletenosplay':( 'int', None, 'stdcall', 'ntdll.RtlDeleteNoSplay', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteownersranges':( 'int', None, 'stdcall', 'ntdll.RtlDeleteOwnersRanges', (('int', None), ('int', None)) ),
    'ntdll.rtldeleterange':( 'int', None, 'stdcall', 'ntdll.RtlDeleteRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldeleteregistryvalue':( 'int', None, 'stdcall', 'ntdll.RtlDeleteRegistryValue', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtldeleteresource':( 'int', None, 'stdcall', 'ntdll.RtlDeleteResource', ( ('int', None),) ),
    'ntdll.rtldeletesecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlDeleteSecurityObject', (('int', None),) ),
    'ntdll.rtldeletetimer':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimer', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldeletetimerqueue':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimerQueue', ( ('int', None),) ),
    'ntdll.rtldeletetimerqueueex':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimerQueueEx', ( ('int', None), ('int', None)) ),
    'ntdll.rtlderegisterwait':( 'int', None, 'stdcall', 'ntdll.RtlDeregisterWait', () ),
    'ntdll.rtlderegisterwaitex':( 'int', None, 'stdcall', 'ntdll.RtlDeregisterWaitEx', ( ('int', None),) ),
    'ntdll.rtldestroyatomtable':( 'int', None, 'stdcall', 'ntdll.RtlDestroyAtomTable', ( ('int', None),) ),
    'ntdll.rtldestroyenvironment':( 'int', None, 'stdcall', 'ntdll.RtlDestroyEnvironment', (('int', None),) ),
    'ntdll.rtldestroyhandletable':( 'int', None, 'stdcall', 'ntdll.RtlDestroyHandleTable', (('int', None),) ),
    'ntdll.rtldestroyheap':( 'int', None, 'stdcall', 'ntdll.RtlDestroyHeap', (('void *', 'ptr'),) ),
    'ntdll.rtldestroyprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlDestroyProcessParameters', (('int', None),) ),
    'ntdll.rtldestroyquerydebugbuffer':( 'int', None, 'stdcall', 'ntdll.RtlDestroyQueryDebugBuffer', (('void *', 'ptr'),) ),
    'ntdll.rtldeterminedospathnametype_u':( 'int', None, 'stdcall', 'ntdll.RtlDetermineDosPathNameType_U', (('void *', 'ptr'),) ),
    'ntdll.rtldllshutdowninprogress':( 'int', None, 'cdecl', 'ntdll.RtlDllShutdownInProgress', () ),
    'ntdll.rtldnshostnametocomputername':( 'int', None, 'stdcall', 'ntdll.RtlDnsHostNameToComputerName', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldoesfileexists_u':( 'int', None, 'stdcall', 'ntdll.RtlDoesFileExists_U', (('int', None),) ),
    'ntdll.rtldosapplyfileisolationredirection_ustr':( 'int', None, 'stdcall', 'ntdll.RtlDosApplyFileIsolationRedirection_Ustr', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldospathnametontpathname_u':( 'int', None, 'stdcall', 'ntdll.RtlDosPathNameToNtPathName_U', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtldossearchpath_u':( 'int', None, 'stdcall', 'ntdll.RtlDosSearchPath_U', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtldossearchpath_ustr':( 'int', None, 'stdcall', 'ntdll.RtlDosSearchPath_Ustr', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtldowncaseunicodechar':( 'int', None, 'stdcall', 'ntdll.RtlDowncaseUnicodeChar', (('int', None),) ),
    'ntdll.rtldowncaseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlDowncaseUnicodeString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldumpresource':( 'int', None, 'stdcall', 'ntdll.RtlDumpResource', (('int', None),) ),
    'ntdll.rtlduplicateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlDuplicateUnicodeString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlemptyatomtable':( 'int', None, 'stdcall', 'ntdll.RtlEmptyAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtlenableearlycriticalsectioneventcreation':( 'int', None, 'cdecl', 'ntdll.RtlEnableEarlyCriticalSectionEventCreation', () ),
    'ntdll.rtlencodepointer':( 'int', None, 'stdcall', 'ntdll.RtlEncodePointer', (('int', None),) ),
    'ntdll.rtlencodesystempointer':( 'int', None, 'stdcall', 'ntdll.RtlEncodeSystemPointer', (('int', None),) ),
    'ntdll.rtlenlargedintegermultiply':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedIntegerMultiply', (('int', None), ('int', None)) ),
    'ntdll.rtlenlargedunsigneddivide':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedUnsignedDivide', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlenlargedunsignedmultiply':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedUnsignedMultiply', (('int', None), ('int', None)) ),
    'ntdll.rtlentercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlEnterCriticalSection', (('int', None),) ),
    'ntdll.rtlenumprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlEnumProcessHeaps', ( ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlenumerategenerictable':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablelikeadirectory':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableLikeADirectory', (('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablewithoutsplaying':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableWithoutSplaying', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablewithoutsplayingavl':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableWithoutSplayingAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlequalcomputername':( 'int', None, 'stdcall', 'ntdll.RtlEqualComputerName', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlequaldomainname':( 'int', None, 'stdcall', 'ntdll.RtlEqualDomainName', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlequalluid':( 'int', None, 'stdcall', 'ntdll.RtlEqualLuid', (('int', None), ('int', None)) ),
    'ntdll.rtlequalprefixsid':( 'int', None, 'stdcall', 'ntdll.RtlEqualPrefixSid', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlequalsid':( 'int', None, 'stdcall', 'ntdll.RtlEqualSid', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlequalstring':( 'int', None, 'stdcall', 'ntdll.RtlEqualString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlequalunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlEqualUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtleraseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlEraseUnicodeString', (('int', None),) ),
    'ntdll.rtlexituserthread':( 'int', None, 'stdcall', 'ntdll.RtlExitUserThread', ( ('int', None),) ),
    'ntdll.rtlexpandenvironmentstrings_u':( 'int', None, 'stdcall', 'ntdll.RtlExpandEnvironmentStrings_U', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlextendheap':( 'int', None, 'stdcall', 'ntdll.RtlExtendHeap', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlextendedintegermultiply':( 'int', None, 'stdcall', 'ntdll.RtlExtendedIntegerMultiply', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlextendedlargeintegerdivide':( 'int', None, 'stdcall', 'ntdll.RtlExtendedLargeIntegerDivide', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlextendedmagicdivide':( 'int', None, 'stdcall', 'ntdll.RtlExtendedMagicDivide', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfillmemory':( 'int', None, 'stdcall', 'ntdll.RtlFillMemory', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfillmemoryulong':( 'int', None, 'stdcall', 'ntdll.RtlFillMemoryUlong', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfinalreleaseoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlFinalReleaseOutOfProcessMemoryStream', (('int', None),) ),
    'ntdll.rtlfindactivationcontextsectionguid':( 'int', None, 'stdcall', 'ntdll.RtlFindActivationContextSectionGuid', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlfindactivationcontextsectionstring':( 'int', None, 'stdcall', 'ntdll.RtlFindActivationContextSectionString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlfindcharinunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlFindCharInUnicodeString', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlfindclearbits':( 'int', None, 'stdcall', 'ntdll.RtlFindClearBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindclearbitsandset':( 'int', None, 'stdcall', 'ntdll.RtlFindClearBitsAndSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindclearruns':( 'int', None, 'stdcall', 'ntdll.RtlFindClearRuns', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlfindlastbackwardrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindLastBackwardRunClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindleastsignificantbit':( 'int', None, 'stdcall', 'ntdll.RtlFindLeastSignificantBit', (('int', None), ('int', None)) ),
    'ntdll.rtlfindlongestrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindLongestRunClear', (('int', None), ('int', None)) ),
    'ntdll.rtlfindmessage':( 'int', None, 'stdcall', 'ntdll.RtlFindMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindmostsignificantbit':( 'int', None, 'stdcall', 'ntdll.RtlFindMostSignificantBit', (('int', None), ('int', None)) ),
    'ntdll.rtlfindnextforwardrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindNextForwardRunClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindrange':( 'int', None, 'stdcall', 'ntdll.RtlFindRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlfindsetbits':( 'int', None, 'stdcall', 'ntdll.RtlFindSetBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindsetbitsandclear':( 'int', None, 'stdcall', 'ntdll.RtlFindSetBitsAndClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfirstentryslist':( 'int', None, 'stdcall', 'ntdll.RtlFirstEntrySList', (('int', None),) ),
    'ntdll.rtlfirstfreeace':( 'int', None, 'stdcall', 'ntdll.RtlFirstFreeAce', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlflushsecurememorycache':( 'int', None, 'stdcall', 'ntdll.RtlFlushSecureMemoryCache', (('int', None), ('int', None)) ),
    'ntdll.rtlformatcurrentuserkeypath':( 'int', None, 'stdcall', 'ntdll.RtlFormatCurrentUserKeyPath', (('void *', 'ptr'),) ),
    'ntdll.rtlformatmessage':( 'int', None, 'stdcall', 'ntdll.RtlFormatMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlfreeansistring':( 'int', None, 'stdcall', 'ntdll.RtlFreeAnsiString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreehandle':( 'int', None, 'stdcall', 'ntdll.RtlFreeHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlfreeheap':( 'int', None, 'stdcall', 'ntdll.RtlFreeHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlfreeoemstring':( 'int', None, 'stdcall', 'ntdll.RtlFreeOemString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreerangelist':( 'int', None, 'stdcall', 'ntdll.RtlFreeRangeList', (('int', None),) ),
    'ntdll.rtlfreesid':( 'int', None, 'stdcall', 'ntdll.RtlFreeSid', (('void *', 'ptr'),) ),
    'ntdll.rtlfreethreadactivationcontextstack':( 'int', None, 'cdecl', 'ntdll.RtlFreeThreadActivationContextStack', () ),
    'ntdll.rtlfreeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlFreeUnicodeString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreeuserthreadstack':( 'int', None, 'stdcall', 'ntdll.RtlFreeUserThreadStack', (('int', None), ('int', None)) ),
    'ntdll.rtlguidfromstring':( 'int', None, 'stdcall', 'ntdll.RtlGUIDFromString', (('int', None), ('int', None)) ),
    'ntdll.rtlgenerate8dot3name':( 'int', None, 'stdcall', 'ntdll.RtlGenerate8dot3Name', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetace':( 'int', None, 'stdcall', 'ntdll.RtlGetAce', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetactiveactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlGetActiveActivationContext', (('int', None),) ),
    'ntdll.rtlgetcallersaddress':( 'int', None, 'stdcall', 'ntdll.RtlGetCallersAddress', (('int', None), ('int', None)) ),
    'ntdll.rtlgetcompressionworkspacesize':( 'int', None, 'stdcall', 'ntdll.RtlGetCompressionWorkSpaceSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetcontrolsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetControlSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetcurrentdirectory_u':( 'int', None, 'stdcall', 'ntdll.RtlGetCurrentDirectory_U', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetcurrentpeb':( 'int', None, 'cdecl', 'ntdll.RtlGetCurrentPeb', () ),
    'ntdll.rtlgetdaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetDaclSecurityDescriptor', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlGetElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtlgetelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlGetElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlgetfirstrange':( 'int', None, 'stdcall', 'ntdll.RtlGetFirstRange', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlgetframe':( 'int', None, 'cdecl', 'ntdll.RtlGetFrame', () ),
    'ntdll.rtlgetfullpathname_u':( 'int', None, 'stdcall', 'ntdll.RtlGetFullPathName_U', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetgroupsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetGroupSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetlastntstatus':( 'int', None, 'cdecl', 'ntdll.RtlGetLastNtStatus', () ),
    'ntdll.rtlgetlastwin32error':( 'int', None, 'cdecl', 'ntdll.RtlGetLastWin32Error', () ),
    'ntdll.rtlgetlengthwithoutlastfulldosorntpathelement':( 'int', None, 'stdcall', 'ntdll.RtlGetLengthWithoutLastFullDosOrNtPathElement', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlgetlengthwithouttrailingpathseperators':( 'int', None, 'stdcall', 'ntdll.RtlGetLengthWithoutTrailingPathSeperators', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetlongestntpathlength':( 'int', None, 'cdecl', 'ntdll.RtlGetLongestNtPathLength', () ),
    'ntdll.rtlgetnativesysteminformation':( 'int', None, 'stdcall', 'ntdll.RtlGetNativeSystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetnextrange':( 'int', None, 'stdcall', 'ntdll.RtlGetNextRange', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetntglobalflags':( 'int', None, 'cdecl', 'ntdll.RtlGetNtGlobalFlags', () ),
    'ntdll.rtlgetntproducttype':( 'int', None, 'stdcall', 'ntdll.RtlGetNtProductType', (('void *', 'ptr'),) ),
    'ntdll.rtlgetntversionnumbers':( 'int', None, 'stdcall', 'ntdll.RtlGetNtVersionNumbers', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetownersecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetOwnerSecurityDescriptor', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlGetProcessHeaps', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetsaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetSaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'ntdll.RtlGetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'ntdll.rtlgetsetbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlGetSetBootStatusData', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlgetunloadeventtrace':( 'int', None, 'cdecl', 'ntdll.RtlGetUnloadEventTrace', () ),
    'ntdll.rtlgetuserinfoheap':( 'int', None, 'stdcall', 'ntdll.RtlGetUserInfoHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ntdll.rtlgetversion':( 'int', None, 'stdcall', 'ntdll.RtlGetVersion', (('void *', 'ptr'),) ),
    'ntdll.rtlhashunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlHashUnicodeString', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlidentifierauthoritysid':( 'int', None, 'stdcall', 'ntdll.RtlIdentifierAuthoritySid', (('int', None),) ),
    'ntdll.rtlimagedirectoryentrytodata':( 'int', None, 'stdcall', 'ntdll.RtlImageDirectoryEntryToData', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlimagentheader':( 'int', None, 'stdcall', 'ntdll.RtlImageNtHeader', (('int', None),) ),
    'ntdll.rtlimagervatosection':( 'int', None, 'stdcall', 'ntdll.RtlImageRvaToSection', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlimagervatova':( 'int', None, 'stdcall', 'ntdll.RtlImageRvaToVa', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlimpersonateself':( 'int', None, 'stdcall', 'ntdll.RtlImpersonateSelf', (('int', None),) ),
    'ntdll.rtlinitansistring':( 'int', None, 'stdcall', 'ntdll.RtlInitAnsiString', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitcodepagetable':( 'int', None, 'stdcall', 'ntdll.RtlInitCodePageTable', (('int', None), ('int', None)) ),
    'ntdll.rtlinitmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlInitMemoryStream', (('int', None),) ),
    'ntdll.rtlinitnlstables':( 'int', None, 'stdcall', 'ntdll.RtlInitNlsTables', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlinitoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlInitOutOfProcessMemoryStream', (('int', None),) ),
    'ntdll.rtlinitstring':( 'int', None, 'stdcall', 'ntdll.RtlInitString', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlInitUnicodeString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlinitunicodestringex':( 'int', None, 'stdcall', 'ntdll.RtlInitUnicodeStringEx', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlinitializeatompackage':( 'int', None, 'stdcall', 'ntdll.RtlInitializeAtomPackage', (('int', None),) ),
    'ntdll.rtlinitializebitmap':( 'int', None, 'stdcall', 'ntdll.RtlInitializeBitMap', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializecontext':( 'int', None, 'stdcall', 'ntdll.RtlInitializeContext', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlInitializeCriticalSection', () ),
    'ntdll.rtlinitializecriticalsectionandspincount':( 'int', None, 'stdcall', 'ntdll.RtlInitializeCriticalSectionAndSpinCount', ( ('int', None),) ),
    'ntdll.rtlinitializegenerictable':( 'int', None, 'stdcall', 'ntdll.RtlInitializeGenericTable', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializegenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlInitializeGenericTableAvl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializehandletable':( 'int', None, 'stdcall', 'ntdll.RtlInitializeHandleTable', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializerxact':( 'int', None, 'stdcall', 'ntdll.RtlInitializeRXact', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializerangelist':( 'int', None, 'stdcall', 'ntdll.RtlInitializeRangeList', (('int', None),) ),
    'ntdll.rtlinitializeresource':( 'int', None, 'stdcall', 'ntdll.RtlInitializeResource', () ),
    'ntdll.rtlinitializeslisthead':( 'int', None, 'stdcall', 'ntdll.RtlInitializeSListHead', (('int', None),) ),
    'ntdll.rtlinitializesid':( 'int', None, 'stdcall', 'ntdll.RtlInitializeSid', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitializestacktracedatabase':( 'int', None, 'stdcall', 'ntdll.RtlInitializeStackTraceDataBase', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinsertelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlInsertElementGenericTable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinsertelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlInsertElementGenericTableAvl', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlint64tounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlInt64ToUnicodeString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlintegertochar':( 'int', None, 'stdcall', 'ntdll.RtlIntegerToChar', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlintegertounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlIntegerToUnicodeString', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlinterlockedflushslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedFlushSList', () ),
    'ntdll.rtlinterlockedpopentryslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPopEntrySList', () ),
    'ntdll.rtlinterlockedpushentryslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPushEntrySList', (('int', None), ('int', None)) ),
    'ntdll.rtlinterlockedpushlistslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPushListSList', ( ('int', None), ('int', None)) ),
    'ntdll.rtlinvertrangelist':( 'int', None, 'stdcall', 'ntdll.RtlInvertRangeList', (('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringA', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv4addresstostringexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringW', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv4stringtoaddressa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringA', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6addresstostringexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringW', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6stringtoaddressa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6stringtoaddressexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressExA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6stringtoaddressexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6stringtoaddressw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlisactivationcontextactive':( 'int', None, 'stdcall', 'ntdll.RtlIsActivationContextActive', (('int', None),) ),
    'ntdll.rtlisdosdevicename_u':( 'int', None, 'stdcall', 'ntdll.RtlIsDosDeviceName_U', (('void *', 'ptr'),) ),
    'ntdll.rtlisgenerictableempty':( 'int', None, 'stdcall', 'ntdll.RtlIsGenericTableEmpty', (('int', None),) ),
    'ntdll.rtlisgenerictableemptyavl':( 'int', None, 'stdcall', 'ntdll.RtlIsGenericTableEmptyAvl', (('int', None),) ),
    'ntdll.rtlisnamelegaldos8dot3':( 'int', None, 'stdcall', 'ntdll.RtlIsNameLegalDOS8Dot3', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlisrangeavailable':( 'int', None, 'stdcall', 'ntdll.RtlIsRangeAvailable', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlistextunicode':( 'int', None, 'stdcall', 'ntdll.RtlIsTextUnicode', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlisthreadwithinloadercallout':( 'int', None, 'cdecl', 'ntdll.RtlIsThreadWithinLoaderCallout', () ),
    'ntdll.rtlisvalidhandle':( 'int', None, 'stdcall', 'ntdll.RtlIsValidHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlisvalidindexhandle':( 'int', None, 'stdcall', 'ntdll.RtlIsValidIndexHandle', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegeradd':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerAdd', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegerarithmeticshift':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerArithmeticShift', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegerdivide':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerDivide', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegernegate':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerNegate', (('int', None), ('int', None)) ),
    'ntdll.rtllargeintegershiftleft':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerShiftLeft', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegershiftright':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerShiftRight', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegersubtract':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerSubtract', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegertochar':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerToChar', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlleavecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlLeaveCriticalSection', ( ('int', None),) ),
    'ntdll.rtllengthrequiredsid':( 'int', None, 'stdcall', 'ntdll.RtlLengthRequiredSid', (('int', None),) ),
    'ntdll.rtllengthsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlLengthSecurityDescriptor', (('int', None),) ),
    'ntdll.rtllengthsid':( 'int', None, 'stdcall', 'ntdll.RtlLengthSid', (('void *', 'ptr'),) ),
    'ntdll.rtllocaltimetosystemtime':( 'int', None, 'stdcall', 'ntdll.RtlLocalTimeToSystemTime', (('int', None), ('int', None)) ),
    'ntdll.rtllockbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlLockBootStatusData', (('int', None),) ),
    'ntdll.rtllockheap':( 'int', None, 'stdcall', 'ntdll.RtlLockHeap', ( ('int', None),) ),
    'ntdll.rtllockmemorystreamregion':( 'int', None, 'stdcall', 'ntdll.RtlLockMemoryStreamRegion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllogstackbacktrace':( 'int', None, 'cdecl', 'ntdll.RtlLogStackBackTrace', () ),
    'ntdll.rtllookupatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlLookupAtomInAtomTable', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllookupelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlLookupElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtllookupelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlLookupElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlmakeselfrelativesd':( 'int', None, 'stdcall', 'ntdll.RtlMakeSelfRelativeSD', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlmapgenericmask':( 'int', None, 'stdcall', 'ntdll.RtlMapGenericMask', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlmapsecurityerrortontstatus':( 'int', None, 'stdcall', 'ntdll.RtlMapSecurityErrorToNtStatus', (('int', None),) ),
    'ntdll.rtlmergerangelists':( 'int', None, 'stdcall', 'ntdll.RtlMergeRangeLists', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmovememory':( 'int', None, 'stdcall', 'ntdll.RtlMoveMemory', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmultiappendunicodestringbuffer':( 'int', None, 'stdcall', 'ntdll.RtlMultiAppendUnicodeStringBuffer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlmultibytetounicoden':( 'int', None, 'stdcall', 'ntdll.RtlMultiByteToUnicodeN', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmultibytetounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlMultiByteToUnicodeSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewinstancesecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlNewInstanceSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecuritygrantedaccess':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityGrantedAccess', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobjectex':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobjectwithmultipleinheritance':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObjectWithMultipleInheritance', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnormalizeprocessparams':( 'int', None, 'stdcall', 'ntdll.RtlNormalizeProcessParams', (('int', None),) ),
    'ntdll.rtlntpathnametodospathname':( 'int', None, 'stdcall', 'ntdll.RtlNtPathNameToDosPathName', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlntstatustodoserror':( 'int', None, 'stdcall', 'ntdll.RtlNtStatusToDosError', (('int', None),) ),
    'ntdll.rtlntstatustodoserrornoteb':( 'int', None, 'stdcall', 'ntdll.RtlNtStatusToDosErrorNoTeb', (('int', None),) ),
    'ntdll.rtlnumbergenerictableelements':( 'int', None, 'stdcall', 'ntdll.RtlNumberGenericTableElements', (('int', None),) ),
    'ntdll.rtlnumbergenerictableelementsavl':( 'int', None, 'stdcall', 'ntdll.RtlNumberGenericTableElementsAvl', (('int', None),) ),
    'ntdll.rtlnumberofclearbits':( 'int', None, 'stdcall', 'ntdll.RtlNumberOfClearBits', (('int', None),) ),
    'ntdll.rtlnumberofsetbits':( 'int', None, 'stdcall', 'ntdll.RtlNumberOfSetBits', (('int', None),) ),
    'ntdll.rtloemstringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlOemStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtloemstringtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlOemStringToUnicodeString', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtloemtounicoden':( 'int', None, 'stdcall', 'ntdll.RtlOemToUnicodeN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlopencurrentuser':( 'int', None, 'stdcall', 'ntdll.RtlOpenCurrentUser', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpctofileheader':( 'int', None, 'stdcall', 'ntdll.RtlPcToFileHeader', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpinatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlPinAtomInAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtlpopframe':( 'int', None, 'stdcall', 'ntdll.RtlPopFrame', (('int', None),) ),
    'ntdll.rtlprefixstring':( 'int', None, 'stdcall', 'ntdll.RtlPrefixString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlprefixunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlPrefixUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlprotectheap':( 'int', None, 'stdcall', 'ntdll.RtlProtectHeap', (('int', None), ('int', None)) ),
    'ntdll.rtlpushframe':( 'int', None, 'stdcall', 'ntdll.RtlPushFrame', (('int', None),) ),
    'ntdll.rtlqueryatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlQueryAtomInAtomTable', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll.rtlquerydepthslist':( 'int', None, 'stdcall', 'ntdll.RtlQueryDepthSList', (('int', None),) ),
    'ntdll.rtlqueryenvironmentvariable_u':( 'int', None, 'stdcall', 'ntdll.RtlQueryEnvironmentVariable_U', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlqueryheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryHeapInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationacl':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationAcl', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationActivationContext', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationactiveactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationActiveActivationContext', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinterfacememorystream':( 'int', None, 'stdcall', 'ntdll.RtlQueryInterfaceMemoryStream', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryprocessbacktraceinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessBackTraceInformation', (('int', None),) ),
    'ntdll.rtlqueryprocessdebuginformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessDebugInformation', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlqueryprocessheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessHeapInformation', ( ('int', None),) ),
    'ntdll.rtlqueryprocesslockinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessLockInformation', ( ('int', None),) ),
    'ntdll.rtlqueryregistryvalues':( 'int', None, 'stdcall', 'ntdll.RtlQueryRegistryValues', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlQuerySecurityObject', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlquerytagheap':( 'int', None, 'stdcall', 'ntdll.RtlQueryTagHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlquerytimezoneinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryTimeZoneInformation', (('int', None),) ),
    'ntdll.rtlqueueapcwow64thread':( 'int', None, 'stdcall', 'ntdll.RtlQueueApcWow64Thread', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueueworkitem':( 'int', None, 'stdcall', 'ntdll.RtlQueueWorkItem', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlraiseexception':( 'int', None, 'cdecl', 'ntdll.RtlRaiseException', (('void *', 'ptr'),) ),
    'ntdll.rtlraisestatus':( 'int', None, 'stdcall', 'ntdll.RtlRaiseStatus', (('int', None),) ),
    'ntdll.rtlrandom':( 'int', None, 'stdcall', 'ntdll.RtlRandom', (('int', None),) ),
    'ntdll.rtlrandomex':( 'int', None, 'stdcall', 'ntdll.RtlRandomEx', (('void *', 'ptr'),) ),
    'ntdll.rtlreallocateheap':( 'int', None, 'stdcall', 'ntdll.RtlReAllocateHeap', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlreadmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlReadMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlreadoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlReadOutOfProcessMemoryStream', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlrealpredecessor':( 'int', None, 'stdcall', 'ntdll.RtlRealPredecessor', (('int', None),) ),
    'ntdll.rtlrealsuccessor':( 'int', None, 'stdcall', 'ntdll.RtlRealSuccessor', (('int', None),) ),
    'ntdll.rtlregistersecurememorycachecallback':( 'int', None, 'stdcall', 'ntdll.RtlRegisterSecureMemoryCacheCallback', (('int', None),) ),
    'ntdll.rtlregisterwait':( 'int', None, 'stdcall', 'ntdll.RtlRegisterWait', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlreleaseactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlReleaseActivationContext', (('int', None),) ),
    'ntdll.rtlreleasememorystream':( 'int', None, 'stdcall', 'ntdll.RtlReleaseMemoryStream', (('int', None),) ),
    'ntdll.rtlreleasepeblock':( 'int', None, 'cdecl', 'ntdll.RtlReleasePebLock', () ),
    'ntdll.rtlreleaseresource':( 'int', None, 'stdcall', 'ntdll.RtlReleaseResource', ( ('int', None),) ),
    'ntdll.rtlremotecall':( 'int', None, 'stdcall', 'ntdll.RtlRemoteCall', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlremovevectoredexceptionhandler':( 'int', None, 'stdcall', 'ntdll.RtlRemoveVectoredExceptionHandler', ( ('int', None),) ),
    'ntdll.rtlresetrtltranslations':( 'int', None, 'stdcall', 'ntdll.RtlResetRtlTranslations', (('void *', 'ptr'),) ),
    'ntdll.rtlrestorelastwin32error':( 'int', None, 'stdcall', 'ntdll.RtlRestoreLastWin32Error', (('int', None),) ),
    'ntdll.rtlrevertmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlRevertMemoryStream', (('int', None),) ),
    'ntdll.rtlrundecodeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlRunDecodeUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlrunencodeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlRunEncodeUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlsecondssince1970totime':( 'int', None, 'stdcall', 'ntdll.RtlSecondsSince1970ToTime', (('int', None), ('int', None)) ),
    'ntdll.rtlsecondssince1980totime':( 'int', None, 'stdcall', 'ntdll.RtlSecondsSince1980ToTime', (('int', None), ('int', None)) ),
    'ntdll.rtlseekmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlSeekMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlselfrelativetoabsolutesd':( 'int', None, 'stdcall', 'ntdll.RtlSelfRelativeToAbsoluteSD', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlselfrelativetoabsolutesd2':( 'int', None, 'stdcall', 'ntdll.RtlSelfRelativeToAbsoluteSD2', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlsetallbits':( 'int', None, 'stdcall', 'ntdll.RtlSetAllBits', (('int', None),) ),
    'ntdll.rtlsetattributessecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetAttributesSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetbits':( 'int', None, 'stdcall', 'ntdll.RtlSetBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetcontrolsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetControlSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetcriticalsectionspincount':( 'int', None, 'stdcall', 'ntdll.RtlSetCriticalSectionSpinCount', (('int', None), ('int', None)) ),
    'ntdll.rtlsetcurrentdirectory_u':( 'int', None, 'stdcall', 'ntdll.RtlSetCurrentDirectory_U', (('void *', 'ptr'),) ),
    'ntdll.rtlsetcurrentenvironment':( 'int', None, 'stdcall', 'ntdll.RtlSetCurrentEnvironment', (('int', None), ('int', None)) ),
    'ntdll.rtlsetdaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetDaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetenvironmentvariable':( 'int', None, 'stdcall', 'ntdll.RtlSetEnvironmentVariable', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlsetgroupsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetGroupSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlSetHeapInformation', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetinformationacl':( 'int', None, 'stdcall', 'ntdll.RtlSetInformationAcl', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetiocompletioncallback':( 'int', None, 'stdcall', 'ntdll.RtlSetIoCompletionCallback', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetlastwin32error':( 'int', None, 'stdcall', 'ntdll.RtlSetLastWin32Error', (('int', None),) ),
    'ntdll.rtlsetlastwin32errorandntstatusfromntstatus':( 'int', None, 'stdcall', 'ntdll.RtlSetLastWin32ErrorAndNtStatusFromNtStatus', (('int', None),) ),
    'ntdll.rtlsetmemorystreamsize':( 'int', None, 'stdcall', 'ntdll.RtlSetMemoryStreamSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetownersecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetOwnerSecurityDescriptor', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlsetprocessiscritical':( 'int', None, 'cdecl', 'ntdll.RtlSetProcessIsCritical', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetSaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'ntdll.rtlsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsecurityobjectex':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetthreadiscritical':( 'int', None, 'cdecl', 'ntdll.RtlSetThreadIsCritical', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetthreadpoolstartfunc':( 'int', None, 'stdcall', 'ntdll.RtlSetThreadPoolStartFunc', (('int', None), ('int', None)) ),
    'ntdll.rtlsettimezoneinformation':( 'int', None, 'stdcall', 'ntdll.RtlSetTimeZoneInformation', ( ('void *', 'ptr'),) ),
    'ntdll.rtlsettimer':( 'int', None, 'stdcall', 'ntdll.RtlSetTimer', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetunicodecallouts':( 'int', None, 'stdcall', 'ntdll.RtlSetUnicodeCallouts', (('int', None),) ),
    'ntdll.rtlsetuserflagsheap':( 'int', None, 'stdcall', 'ntdll.RtlSetUserFlagsHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetuservalueheap':( 'int', None, 'stdcall', 'ntdll.RtlSetUserValueHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ntdll.rtlsizeheap':( 'int', None, 'stdcall', 'ntdll.RtlSizeHeap', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlsplay':( 'int', None, 'stdcall', 'ntdll.RtlSplay', (('int', None),) ),
    'ntdll.rtlstartrxact':( 'int', None, 'stdcall', 'ntdll.RtlStartRXact', (('int', None),) ),
    'ntdll.rtlstatmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlStatMemoryStream', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlstringfromguid':( 'int', None, 'stdcall', 'ntdll.RtlStringFromGUID', (('int', None), ('int', None)) ),
    'ntdll.rtlsubauthoritycountsid':( 'int', None, 'stdcall', 'ntdll.RtlSubAuthorityCountSid', (('int', None),) ),
    'ntdll.rtlsubauthoritysid':( 'int', None, 'stdcall', 'ntdll.RtlSubAuthoritySid', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlsubtreepredecessor':( 'int', None, 'stdcall', 'ntdll.RtlSubtreePredecessor', (('int', None),) ),
    'ntdll.rtlsubtreesuccessor':( 'int', None, 'stdcall', 'ntdll.RtlSubtreeSuccessor', (('int', None),) ),
    'ntdll.rtlsystemtimetolocaltime':( 'int', None, 'stdcall', 'ntdll.RtlSystemTimeToLocalTime', (('int', None), ('int', None)) ),
    'ntdll.rtltimefieldstotime':( 'int', None, 'stdcall', 'ntdll.RtlTimeFieldsToTime', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtltimetoelapsedtimefields':( 'int', None, 'msfastcall', 'ntdll.RtlTimeToElapsedTimeFields', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltimetosecondssince1970':( 'int', None, 'stdcall', 'ntdll.RtlTimeToSecondsSince1970', (('int', None), ('int', None)) ),
    'ntdll.rtltimetosecondssince1980':( 'int', None, 'stdcall', 'ntdll.RtlTimeToSecondsSince1980', (('int', None), ('int', None)) ),
    'ntdll.rtltimetotimefields':( 'int', None, 'msfastcall', 'ntdll.RtlTimeToTimeFields', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtltracedatabaseadd':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseAdd', ( ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtltracedatabasecreate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseCreate', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabasedestroy':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseDestroy', ( ('int', None),) ),
    'ntdll.rtltracedatabaseenumerate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseEnumerate', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabasefind':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseFind', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabaselock':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseLock', (('int', None),) ),
    'ntdll.rtltracedatabaseunlock':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseUnlock', ( ('int', None),) ),
    'ntdll.rtltracedatabasevalidate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseValidate', ( ('int', None),) ),
    'ntdll.rtltryentercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlTryEnterCriticalSection', (('int', None),) ),
    'ntdll.rtlulongbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUlongByteSwap', () ),
    'ntdll.rtlulonglongbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUlonglongByteSwap', (('int', None), ('int', None)) ),
    'ntdll.rtlunhandledexceptionfilter':( 'int', None, 'stdcall', 'ntdll.RtlUnhandledExceptionFilter', (('void *', 'ptr'),) ),
    'ntdll.rtlunhandledexceptionfilter2':( 'int', None, 'stdcall', 'ntdll.RtlUnhandledExceptionFilter2', (('int', None), ('int', None)) ),
    'ntdll.rtlunicodestringtoansisize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToAnsiSize', (('int', None),) ),
    'ntdll.rtlunicodestringtoansistring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToAnsiString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlunicodestringtocountedoemstring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToCountedOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlunicodestringtointeger':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToInteger', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlunicodestringtooemsize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToOemSize', (('int', None),) ),
    'ntdll.rtlunicodestringtooemstring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToOemString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetocustomcpn':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToCustomCPN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetomultibyten':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToMultiByteN', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetomultibytesize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToMultiByteSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetooemn':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToOemN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtluniform':( 'int', None, 'stdcall', 'ntdll.RtlUniform', (('int', None),) ),
    'ntdll.rtlunlockbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlUnlockBootStatusData', (('int', None),) ),
    'ntdll.rtlunlockheap':( 'int', None, 'stdcall', 'ntdll.RtlUnlockHeap', ( ('int', None),) ),
    'ntdll.rtlunlockmemorystreamregion':( 'int', None, 'stdcall', 'ntdll.RtlUnlockMemoryStreamRegion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunwind':( 'int', None, 'stdcall', 'ntdll.RtlUnwind', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodechar':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeChar', (('int', None),) ),
    'ntdll.rtlupcaseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtoansistring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToAnsiString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtocountedoemstring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToCountedOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtooemstring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodetocustomcpn':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToCustomCPN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodetomultibyten':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToMultiByteN', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodetooemn':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToOemN', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlupdatetimer':( 'int', None, 'stdcall', 'ntdll.RtlUpdateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupperchar':( 'int', None, 'stdcall', 'ntdll.RtlUpperChar', (('int', None),) ),
    'ntdll.rtlupperstring':( 'int', None, 'stdcall', 'ntdll.RtlUpperString', (('int', None), ('int', None)) ),
    'ntdll.rtlusageheap':( 'int', None, 'stdcall', 'ntdll.RtlUsageHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlushortbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUshortByteSwap', () ),
    'ntdll.rtlvalidacl':( 'int', None, 'stdcall', 'ntdll.RtlValidAcl', (('int', None),) ),
    'ntdll.rtlvalidrelativesecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlValidRelativeSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlvalidsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlValidSecurityDescriptor', (('int', None),) ),
    'ntdll.rtlvalidsid':( 'int', None, 'stdcall', 'ntdll.RtlValidSid', (('int', None),) ),
    'ntdll.rtlvalidateheap':( 'int', None, 'stdcall', 'ntdll.RtlValidateHeap', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlvalidateprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlValidateProcessHeaps', () ),
    'ntdll.rtlvalidateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlValidateUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlverifyversioninfo':( 'int', None, 'stdcall', 'ntdll.RtlVerifyVersionInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlwalkframechain':( 'int', None, 'stdcall', 'ntdll.RtlWalkFrameChain', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlwalkheap':( 'int', None, 'stdcall', 'ntdll.RtlWalkHeap', ( ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlwritememorystream':( 'int', None, 'stdcall', 'ntdll.RtlWriteMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlwriteregistryvalue':( 'int', None, 'stdcall', 'ntdll.RtlWriteRegistryValue', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlzeroheap':( 'int', None, 'stdcall', 'ntdll.RtlZeroHeap', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlzeromemory':( 'int', None, 'stdcall', 'ntdll.RtlZeroMemory', (('int', None), ('int', None)) ),
    'ntdll.rtlzombifyactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlZombifyActivationContext', (('int', None),) ),
    'ntdll.rtlpapplylengthfunction':( 'int', None, 'stdcall', 'ntdll.RtlpApplyLengthFunction', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll.rtlpensurebuffersize':( 'int', None, 'stdcall', 'ntdll.RtlpEnsureBufferSize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpnotownercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpNotOwnerCriticalSection', (('int', None),) ),
    'ntdll.rtlpntcreatekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpntenumeratesubkey':( 'int', None, 'stdcall', 'ntdll.RtlpNtEnumerateSubKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlpntmaketemporarykey':( 'int', None, 'stdcall', 'ntdll.RtlpNtMakeTemporaryKey', (('int', None),) ),
    'ntdll.rtlpntopenkey':( 'int', None, 'stdcall', 'ntdll.RtlpNtOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpntqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtQueryValueKey', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlpntsetvaluekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtSetValueKey', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpunwaitcriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpUnWaitCriticalSection', ( ('int', None),) ),
    'ntdll.rtlpwaitforcriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpWaitForCriticalSection', (('int', None),) ),
    'ntdll.rtlxansistringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlxAnsiStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlxoemstringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlxOemStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlxunicodestringtoansisize':( 'int', None, 'stdcall', 'ntdll.RtlxUnicodeStringToAnsiSize', (('int', None),) ),
    'ntdll.rtlxunicodestringtooemsize':( 'int', None, 'stdcall', 'ntdll.RtlxUnicodeStringToOemSize', (('int', None),) ),
    'ntdll.versetconditionmask':( 'int', None, 'stdcall', 'ntdll.VerSetConditionMask', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwacceptconnectport':( 'int', None, 'stdcall', 'ntdll.ZwAcceptConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheck':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheck', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytype':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByType', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytypeandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlist':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultList', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlistandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultListAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlistandauditalarmbyhandle':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultListAndAuditAlarmByHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaddatom':( 'int', None, 'stdcall', 'ntdll.ZwAddAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaddbootentry':( 'int', None, 'stdcall', 'ntdll.ZwAddBootEntry', (('int', None), ('int', None)) ),
    'ntdll.zwadjustgroupstoken':( 'int', None, 'stdcall', 'ntdll.ZwAdjustGroupsToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwadjustprivilegestoken':( 'int', None, 'stdcall', 'ntdll.ZwAdjustPrivilegesToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwalertresumethread':( 'int', None, 'stdcall', 'ntdll.ZwAlertResumeThread', (('int', None), ('int', None)) ),
    'ntdll.zwalertthread':( 'int', None, 'stdcall', 'ntdll.ZwAlertThread', (('int', None),) ),
    'ntdll.zwallocatelocallyuniqueid':( 'int', None, 'stdcall', 'ntdll.ZwAllocateLocallyUniqueId', (('int', None),) ),
    'ntdll.zwallocateuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwAllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwallocateuuids':( 'int', None, 'stdcall', 'ntdll.ZwAllocateUuids', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwallocatevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwAllocateVirtualMemory', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwaremappedfilesthesame':( 'int', None, 'stdcall', 'ntdll.ZwAreMappedFilesTheSame', (('int', None), ('int', None)) ),
    'ntdll.zwassignprocesstojobobject':( 'int', None, 'stdcall', 'ntdll.ZwAssignProcessToJobObject', (('int', None), ('int', None)) ),
    'ntdll.zwcallbackreturn':( 'int', None, 'stdcall', 'ntdll.ZwCallbackReturn', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcanceldevicewakeuprequest':( 'int', None, 'stdcall', 'ntdll.ZwCancelDeviceWakeupRequest', (('int', None),) ),
    'ntdll.zwcanceliofile':( 'int', None, 'stdcall', 'ntdll.ZwCancelIoFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwcanceltimer':( 'int', None, 'stdcall', 'ntdll.ZwCancelTimer', (('int', None), ('int', None)) ),
    'ntdll.zwclearevent':( 'int', None, 'stdcall', 'ntdll.ZwClearEvent', (('int', None),) ),
    'ntdll.zwclose':( 'int', None, 'stdcall', 'ntdll.ZwClose', (('int', None),) ),
    'ntdll.zwcloseobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwCloseObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcompactkeys':( 'int', None, 'stdcall', 'ntdll.ZwCompactKeys', (('int', None), ('int', None)) ),
    'ntdll.zwcomparetokens':( 'int', None, 'stdcall', 'ntdll.ZwCompareTokens', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcompleteconnectport':( 'int', None, 'stdcall', 'ntdll.ZwCompleteConnectPort', (('int', None),) ),
    'ntdll.zwcompresskey':( 'int', None, 'stdcall', 'ntdll.ZwCompressKey', (('int', None),) ),
    'ntdll.zwconnectport':( 'int', None, 'stdcall', 'ntdll.ZwConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcontinue':( 'int', None, 'stdcall', 'ntdll.ZwContinue', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatedebugobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateDebugObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatedirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateDirectoryObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateevent':( 'int', None, 'stdcall', 'ntdll.ZwCreateEvent', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateeventpair':( 'int', None, 'stdcall', 'ntdll.ZwCreateEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatefile':( 'int', None, 'stdcall', 'ntdll.ZwCreateFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwCreateIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatejobobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatejobset':( 'int', None, 'stdcall', 'ntdll.ZwCreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatekey':( 'int', None, 'stdcall', 'ntdll.ZwCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwcreatekeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwCreateKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatemailslotfile':( 'int', None, 'stdcall', 'ntdll.ZwCreateMailslotFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatemutant':( 'int', None, 'stdcall', 'ntdll.ZwCreateMutant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatenamedpipefile':( 'int', None, 'stdcall', 'ntdll.ZwCreateNamedPipeFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatepagingfile':( 'int', None, 'stdcall', 'ntdll.ZwCreatePagingFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateport':( 'int', None, 'stdcall', 'ntdll.ZwCreatePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprocess':( 'int', None, 'stdcall', 'ntdll.ZwCreateProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprocessex':( 'int', None, 'stdcall', 'ntdll.ZwCreateProcessEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprofile':( 'int', None, 'stdcall', 'ntdll.ZwCreateProfile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesection':( 'int', None, 'stdcall', 'ntdll.ZwCreateSection', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesemaphore':( 'int', None, 'stdcall', 'ntdll.ZwCreateSemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateSymbolicLinkObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatethread':( 'int', None, 'stdcall', 'ntdll.ZwCreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatetimer':( 'int', None, 'stdcall', 'ntdll.ZwCreateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatetoken':( 'int', None, 'stdcall', 'ntdll.ZwCreateToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatewaitableport':( 'int', None, 'stdcall', 'ntdll.ZwCreateWaitablePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.ZwDebugActiveProcess', (('int', None), ('int', None)) ),
    'ntdll.zwdebugcontinue':( 'int', None, 'stdcall', 'ntdll.ZwDebugContinue', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdelayexecution':( 'int', None, 'stdcall', 'ntdll.ZwDelayExecution', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwdeleteatom':( 'int', None, 'stdcall', 'ntdll.ZwDeleteAtom', (('int', None),) ),
    'ntdll.zwdeletebootentry':( 'int', None, 'stdcall', 'ntdll.ZwDeleteBootEntry', (('int', None),) ),
    'ntdll.zwdeletefile':( 'int', None, 'stdcall', 'ntdll.ZwDeleteFile', (('int', None),) ),
    'ntdll.zwdeletekey':( 'int', None, 'stdcall', 'ntdll.ZwDeleteKey', (('int', None),) ),
    'ntdll.zwdeleteobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwDeleteObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdeletevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwDeleteValueKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwdeviceiocontrolfile':( 'int', None, 'stdcall', 'ntdll.ZwDeviceIoControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdisplaystring':( 'int', None, 'stdcall', 'ntdll.ZwDisplayString', (('int', None),) ),
    'ntdll.zwduplicateobject':( 'int', None, 'stdcall', 'ntdll.ZwDuplicateObject', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwduplicatetoken':( 'int', None, 'stdcall', 'ntdll.ZwDuplicateToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwenumeratebootentries':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateBootEntries', (('int', None), ('int', None)) ),
    'ntdll.zwenumeratekey':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateKey', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwenumeratesystemenvironmentvaluesex':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateSystemEnvironmentValuesEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwenumeratevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwextendsection':( 'int', None, 'stdcall', 'ntdll.ZwExtendSection', (('int', None), ('int', None)) ),
    'ntdll.zwfiltertoken':( 'int', None, 'stdcall', 'ntdll.ZwFilterToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwfindatom':( 'int', None, 'stdcall', 'ntdll.ZwFindAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushbuffersfile':( 'int', None, 'stdcall', 'ntdll.ZwFlushBuffersFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwflushinstructioncache':( 'int', None, 'stdcall', 'ntdll.ZwFlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushkey':( 'int', None, 'stdcall', 'ntdll.ZwFlushKey', (('int', None),) ),
    'ntdll.zwflushvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwFlushVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushwritebuffer':( 'int', None, 'cdecl', 'ntdll.ZwFlushWriteBuffer', () ),
    'ntdll.zwfreeuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwFreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwfreevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwFreeVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwfscontrolfile':( 'int', None, 'stdcall', 'ntdll.ZwFsControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwgetcontextthread':( 'int', None, 'stdcall', 'ntdll.ZwGetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwgetdevicepowerstate':( 'int', None, 'stdcall', 'ntdll.ZwGetDevicePowerState', (('int', None), ('int', None)) ),
    'ntdll.zwgetplugplayevent':( 'int', None, 'stdcall', 'ntdll.ZwGetPlugPlayEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwgetwritewatch':( 'int', None, 'stdcall', 'ntdll.ZwGetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwimpersonateanonymoustoken':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateAnonymousToken', (('int', None),) ),
    'ntdll.zwimpersonateclientofport':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateClientOfPort', (('int', None), ('int', None)) ),
    'ntdll.zwimpersonatethread':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateThread', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwinitializeregistry':( 'int', None, 'stdcall', 'ntdll.ZwInitializeRegistry', (('int', None),) ),
    'ntdll.zwinitiatepoweraction':( 'int', None, 'stdcall', 'ntdll.ZwInitiatePowerAction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwisprocessinjob':( 'int', None, 'stdcall', 'ntdll.ZwIsProcessInJob', (('int', None), ('int', None)) ),
    'ntdll.zwissystemresumeautomatic':( 'int', None, 'cdecl', 'ntdll.ZwIsSystemResumeAutomatic', () ),
    'ntdll.zwlistenport':( 'int', None, 'stdcall', 'ntdll.ZwListenPort', (('int', None), ('int', None)) ),
    'ntdll.zwloaddriver':( 'int', None, 'stdcall', 'ntdll.ZwLoadDriver', (('int', None),) ),
    'ntdll.zwloadkey':( 'int', None, 'stdcall', 'ntdll.ZwLoadKey', (('int', None), ('int', None)) ),
    'ntdll.zwloadkey2':( 'int', None, 'stdcall', 'ntdll.ZwLoadKey2', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwlockfile':( 'int', None, 'stdcall', 'ntdll.ZwLockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwlockproductactivationkeys':( 'int', None, 'stdcall', 'ntdll.ZwLockProductActivationKeys', (('int', None), ('int', None)) ),
    'ntdll.zwlockregistrykey':( 'int', None, 'stdcall', 'ntdll.ZwLockRegistryKey', (('int', None),) ),
    'ntdll.zwlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwLockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmakepermanentobject':( 'int', None, 'stdcall', 'ntdll.ZwMakePermanentObject', (('int', None),) ),
    'ntdll.zwmaketemporaryobject':( 'int', None, 'stdcall', 'ntdll.ZwMakeTemporaryObject', (('int', None),) ),
    'ntdll.zwmapuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwMapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'ntdll.ZwMapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmapviewofsection':( 'int', None, 'stdcall', 'ntdll.ZwMapViewOfSection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmodifybootentry':( 'int', None, 'stdcall', 'ntdll.ZwModifyBootEntry', (('int', None),) ),
    'ntdll.zwnotifychangedirectoryfile':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwnotifychangekey':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwnotifychangemultiplekeys':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeMultipleKeys', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopendirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenDirectoryObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenevent':( 'int', None, 'stdcall', 'ntdll.ZwOpenEvent', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopeneventpair':( 'int', None, 'stdcall', 'ntdll.ZwOpenEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenfile':( 'int', None, 'stdcall', 'ntdll.ZwOpenFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwopeniocompletion':( 'int', None, 'stdcall', 'ntdll.ZwOpenIoCompletion', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenjobobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenkey':( 'int', None, 'stdcall', 'ntdll.ZwOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenkeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwOpenKeyedEvent', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenmutant':( 'int', None, 'stdcall', 'ntdll.ZwOpenMutant', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwOpenObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenprocess':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcess', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwopenprocesstoken':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcessToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenprocesstokenex':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcessTokenEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopensection':( 'int', None, 'stdcall', 'ntdll.ZwOpenSection', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopensemaphore':( 'int', None, 'stdcall', 'ntdll.ZwOpenSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopensymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenSymbolicLinkObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenthread':( 'int', None, 'stdcall', 'ntdll.ZwOpenThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwopenthreadtoken':( 'int', None, 'stdcall', 'ntdll.ZwOpenThreadToken', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenthreadtokenex':( 'int', None, 'stdcall', 'ntdll.ZwOpenThreadTokenEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopentimer':( 'int', None, 'stdcall', 'ntdll.ZwOpenTimer', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwplugplaycontrol':( 'int', None, 'stdcall', 'ntdll.ZwPlugPlayControl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwpowerinformation':( 'int', None, 'stdcall', 'ntdll.ZwPowerInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprivilegecheck':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegeCheck', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwprivilegeobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegeObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprivilegedserviceauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegedServiceAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprotectvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwProtectVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwpulseevent':( 'int', None, 'stdcall', 'ntdll.ZwPulseEvent', (('int', None), ('int', None)) ),
    'ntdll.zwqueryattributesfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryAttributesFile', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwquerybootentryorder':( 'int', None, 'stdcall', 'ntdll.ZwQueryBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.zwquerybootoptions':( 'int', None, 'stdcall', 'ntdll.ZwQueryBootOptions', (('int', None), ('int', None)) ),
    'ntdll.zwquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.ZwQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.zwquerydefaultlocale':( 'int', None, 'stdcall', 'ntdll.ZwQueryDefaultLocale', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerydefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.ZwQueryDefaultUILanguage', (('int', None),) ),
    'ntdll.zwquerydirectoryfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerydirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryDirectoryObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryeafile':( 'int', None, 'stdcall', 'ntdll.ZwQueryEaFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryevent':( 'int', None, 'stdcall', 'ntdll.ZwQueryEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryfullattributesfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryFullAttributesFile', (('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationatom':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationAtom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationjobobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationport':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationprocess':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationthread':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationtoken':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryinstalluilanguage':( 'int', None, 'stdcall', 'ntdll.ZwQueryInstallUILanguage', (('int', None),) ),
    'ntdll.zwqueryintervalprofile':( 'int', None, 'stdcall', 'ntdll.ZwQueryIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.zwqueryiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwQueryIoCompletion', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerykey':( 'int', None, 'stdcall', 'ntdll.ZwQueryKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerymultiplevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwQueryMultipleValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerymutant':( 'int', None, 'stdcall', 'ntdll.ZwQueryMutant', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryopensubkeys':( 'int', None, 'stdcall', 'ntdll.ZwQueryOpenSubKeys', (('int', None), ('int', None)) ),
    'ntdll.zwqueryperformancecounter':( 'int', None, 'stdcall', 'ntdll.ZwQueryPerformanceCounter', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwqueryportinformationprocess':( 'int', None, 'cdecl', 'ntdll.ZwQueryPortInformationProcess', () ),
    'ntdll.zwqueryquotainformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysection':( 'int', None, 'stdcall', 'ntdll.ZwQuerySection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.ZwQuerySecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerysemaphore':( 'int', None, 'stdcall', 'ntdll.ZwQuerySemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwQuerySymbolicLinkObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemEnvironmentValue', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysysteminformation':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerysystemtime':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemTime', (('void *', 'ptr'),) ),
    'ntdll.zwquerytimer':( 'int', None, 'stdcall', 'ntdll.ZwQueryTimer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerytimerresolution':( 'int', None, 'stdcall', 'ntdll.ZwQueryTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.ZwQueryValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwQueryVirtualMemory', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryVolumeInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueueapcthread':( 'int', None, 'stdcall', 'ntdll.ZwQueueApcThread', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwraiseexception':( 'int', None, 'stdcall', 'ntdll.ZwRaiseException', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwraiseharderror':( 'int', None, 'stdcall', 'ntdll.ZwRaiseHardError', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwreadfile':( 'int', None, 'stdcall', 'ntdll.ZwReadFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwreadfilescatter':( 'int', None, 'stdcall', 'ntdll.ZwReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreadrequestdata':( 'int', None, 'stdcall', 'ntdll.ZwReadRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreadvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwReadVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwregisterthreadterminateport':( 'int', None, 'stdcall', 'ntdll.ZwRegisterThreadTerminatePort', (('int', None),) ),
    'ntdll.zwreleasekeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwReleaseKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreleasemutant':( 'int', None, 'stdcall', 'ntdll.ZwReleaseMutant', (('int', None), ('int', None)) ),
    'ntdll.zwreleasesemaphore':( 'int', None, 'stdcall', 'ntdll.ZwReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwremoveiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwRemoveIoCompletion', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwremoveprocessdebug':( 'int', None, 'stdcall', 'ntdll.ZwRemoveProcessDebug', (('int', None), ('int', None)) ),
    'ntdll.zwrenamekey':( 'int', None, 'stdcall', 'ntdll.ZwRenameKey', (('int', None), ('int', None)) ),
    'ntdll.zwreplacekey':( 'int', None, 'stdcall', 'ntdll.ZwReplaceKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplyport':( 'int', None, 'stdcall', 'ntdll.ZwReplyPort', (('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreceiveport':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReceivePort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreceiveportex':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReceivePortEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreplyport':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReplyPort', (('int', None), ('int', None)) ),
    'ntdll.zwrequestdevicewakeup':( 'int', None, 'stdcall', 'ntdll.ZwRequestDeviceWakeup', (('int', None),) ),
    'ntdll.zwrequestport':( 'int', None, 'stdcall', 'ntdll.ZwRequestPort', (('int', None), ('int', None)) ),
    'ntdll.zwrequestwaitreplyport':( 'int', None, 'stdcall', 'ntdll.ZwRequestWaitReplyPort', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwrequestwakeuplatency':( 'int', None, 'stdcall', 'ntdll.ZwRequestWakeupLatency', (('int', None),) ),
    'ntdll.zwresetevent':( 'int', None, 'stdcall', 'ntdll.ZwResetEvent', (('int', None), ('int', None)) ),
    'ntdll.zwresetwritewatch':( 'int', None, 'stdcall', 'ntdll.ZwResetWriteWatch', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwrestorekey':( 'int', None, 'stdcall', 'ntdll.ZwRestoreKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwresumeprocess':( 'int', None, 'stdcall', 'ntdll.ZwResumeProcess', (('int', None),) ),
    'ntdll.zwresumethread':( 'int', None, 'stdcall', 'ntdll.ZwResumeThread', (('int', None), ('int', None)) ),
    'ntdll.zwsavekey':( 'int', None, 'stdcall', 'ntdll.ZwSaveKey', (('int', None), ('int', None)) ),
    'ntdll.zwsavekeyex':( 'int', None, 'stdcall', 'ntdll.ZwSaveKeyEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsavemergedkeys':( 'int', None, 'stdcall', 'ntdll.ZwSaveMergedKeys', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsecureconnectport':( 'int', None, 'stdcall', 'ntdll.ZwSecureConnectPort', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwsetbootentryorder':( 'int', None, 'stdcall', 'ntdll.ZwSetBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.zwsetbootoptions':( 'int', None, 'stdcall', 'ntdll.ZwSetBootOptions', (('int', None), ('int', None)) ),
    'ntdll.zwsetcontextthread':( 'int', None, 'stdcall', 'ntdll.ZwSetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.ZwSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetdefaultharderrorport':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultHardErrorPort', (('int', None),) ),
    'ntdll.zwsetdefaultlocale':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultLocale', (('int', None), ('int', None)) ),
    'ntdll.zwsetdefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultUILanguage', (('int', None),) ),
    'ntdll.zwseteafile':( 'int', None, 'stdcall', 'ntdll.ZwSetEaFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetevent':( 'int', None, 'stdcall', 'ntdll.ZwSetEvent', (('int', None), ('int', None)) ),
    'ntdll.zwseteventboostpriority':( 'int', None, 'stdcall', 'ntdll.ZwSetEventBoostPriority', (('int', None),) ),
    'ntdll.zwsethigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetHighEventPair', (('int', None),) ),
    'ntdll.zwsethighwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetHighWaitLowEventPair', (('int', None),) ),
    'ntdll.zwsetinformationdebugobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationDebugObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationjobobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationkey':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationprocess':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationthread':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationtoken':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationToken', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetintervalprofile':( 'int', None, 'stdcall', 'ntdll.ZwSetIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.zwsetiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwSetIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetldtentries':( 'int', None, 'stdcall', 'ntdll.ZwSetLdtEntries', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetLowEventPair', (('int', None),) ),
    'ntdll.zwsetlowwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetLowWaitHighEventPair', (('int', None),) ),
    'ntdll.zwsetquotainformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.ZwSetSecurityObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwsetsystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemEnvironmentValue', (('int', None), ('int', None)) ),
    'ntdll.zwsetsystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsysteminformation':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemInformation', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsystempowerstate':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemPowerState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsystemtime':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemTime', (('int', None), ('int', None)) ),
    'ntdll.zwsetthreadexecutionstate':( 'int', None, 'stdcall', 'ntdll.ZwSetThreadExecutionState', (('int', None), ('int', None)) ),
    'ntdll.zwsettimer':( 'int', None, 'stdcall', 'ntdll.ZwSetTimer', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsettimerresolution':( 'int', None, 'stdcall', 'ntdll.ZwSetTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetuuidseed':( 'int', None, 'stdcall', 'ntdll.ZwSetUuidSeed', (('int', None),) ),
    'ntdll.zwsetvaluekey':( 'int', None, 'stdcall', 'ntdll.ZwSetValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetVolumeInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwshutdownsystem':( 'int', None, 'stdcall', 'ntdll.ZwShutdownSystem', (('int', None),) ),
    'ntdll.zwsignalandwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.ZwSignalAndWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwstartprofile':( 'int', None, 'stdcall', 'ntdll.ZwStartProfile', (('int', None),) ),
    'ntdll.zwstopprofile':( 'int', None, 'stdcall', 'ntdll.ZwStopProfile', (('int', None),) ),
    'ntdll.zwsuspendprocess':( 'int', None, 'stdcall', 'ntdll.ZwSuspendProcess', (('int', None),) ),
    'ntdll.zwsuspendthread':( 'int', None, 'stdcall', 'ntdll.ZwSuspendThread', (('int', None), ('int', None)) ),
    'ntdll.zwsystemdebugcontrol':( 'int', None, 'stdcall', 'ntdll.ZwSystemDebugControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwterminatejobobject':( 'int', None, 'stdcall', 'ntdll.ZwTerminateJobObject', (('int', None), ('int', None)) ),
    'ntdll.zwterminateprocess':( 'int', None, 'stdcall', 'ntdll.ZwTerminateProcess', (('int', None), ('int', None)) ),
    'ntdll.zwterminatethread':( 'int', None, 'stdcall', 'ntdll.ZwTerminateThread', (('int', None), ('int', None)) ),
    'ntdll.zwtestalert':( 'int', None, 'cdecl', 'ntdll.ZwTestAlert', () ),
    'ntdll.zwtraceevent':( 'int', None, 'stdcall', 'ntdll.ZwTraceEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwtranslatefilepath':( 'int', None, 'stdcall', 'ntdll.ZwTranslateFilePath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunloaddriver':( 'int', None, 'stdcall', 'ntdll.ZwUnloadDriver', (('int', None),) ),
    'ntdll.zwunloadkey':( 'int', None, 'stdcall', 'ntdll.ZwUnloadKey', (('int', None),) ),
    'ntdll.zwunloadkeyex':( 'int', None, 'stdcall', 'ntdll.ZwUnloadKeyEx', (('int', None), ('int', None)) ),
    'ntdll.zwunlockfile':( 'int', None, 'stdcall', 'ntdll.ZwUnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwUnlockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunmapviewofsection':( 'int', None, 'stdcall', 'ntdll.ZwUnmapViewOfSection', (('int', None), ('int', None)) ),
    'ntdll.zwvdmcontrol':( 'int', None, 'stdcall', 'ntdll.ZwVdmControl', (('int', None), ('int', None)) ),
    'ntdll.zwwaitfordebugevent':( 'int', None, 'stdcall', 'ntdll.ZwWaitForDebugEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitforkeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwWaitForKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitformultipleobjects':( 'int', None, 'stdcall', 'ntdll.ZwWaitForMultipleObjects', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.ZwWaitForSingleObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwWaitHighEventPair', (('int', None),) ),
    'ntdll.zwwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwWaitLowEventPair', (('int', None),) ),
    'ntdll.zwwritefile':( 'int', None, 'stdcall', 'ntdll.ZwWriteFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwwritefilegather':( 'int', None, 'stdcall', 'ntdll.ZwWriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwriterequestdata':( 'int', None, 'stdcall', 'ntdll.ZwWriteRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwritevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwWriteVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwyieldexecution':( 'int', None, 'cdecl', 'ntdll.ZwYieldExecution', () ),
    'ntdll._cicos':( 'int', None, 'cdecl', 'ntdll._CIcos', () ),
    'ntdll._cilog':( 'int', None, 'cdecl', 'ntdll._CIlog', () ),
    'ntdll._cipow':( 'int', None, 'cdecl', 'ntdll._CIpow', () ),
    'ntdll._cisin':( 'int', None, 'cdecl', 'ntdll._CIsin', () ),
    'ntdll._cisqrt':( 'int', None, 'cdecl', 'ntdll._CIsqrt', () ),
    'ntdll.__isascii':( 'int', None, 'cdecl', 'ntdll.__isascii', (('int', None),) ),
    'ntdll.__iscsym':( 'int', None, 'cdecl', 'ntdll.__iscsym', (('int', None),) ),
    'ntdll.__iscsymf':( 'int', None, 'cdecl', 'ntdll.__iscsymf', (('int', None),) ),
    'ntdll.__toascii':( 'int', None, 'cdecl', 'ntdll.__toascii', (('int', None),) ),
    'ntdll._alldiv':( 'int', None, 'stdcall', 'ntdll._alldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._alldvrm':( 'int', None, 'stdcall', 'ntdll._alldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._allmul':( 'int', None, 'stdcall', 'ntdll._allmul', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._alloca_probe':( 'int', None, 'cdecl', 'ntdll._alloca_probe', () ),
    'ntdll._allrem':( 'int', None, 'stdcall', 'ntdll._allrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._allshl':( 'int', None, 'cdecl', 'ntdll._allshl', () ),
    'ntdll._allshr':( 'int', None, 'cdecl', 'ntdll._allshr', () ),
    'ntdll._atoi64':( 'int', None, 'cdecl', 'ntdll._atoi64', (('int', None),) ),
    'ntdll._aulldiv':( 'int', None, 'stdcall', 'ntdll._aulldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aulldvrm':( 'int', None, 'stdcall', 'ntdll._aulldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aullrem':( 'int', None, 'stdcall', 'ntdll._aullrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aullshr':( 'int', None, 'cdecl', 'ntdll._aullshr', () ),
    'ntdll._chkstk':( 'int', None, 'cdecl', 'ntdll._chkstk', () ),
    'ntdll._fltused':( 'int', None, 'cdecl', 'ntdll._fltused', () ),
    'ntdll._ftol':( 'int', None, 'cdecl', 'ntdll._ftol', () ),
    'ntdll._i64toa':( 'int', None, 'msfastcall', 'ntdll._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._i64tow':( 'int', None, 'msfastcall', 'ntdll._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._itoa':( 'int', None, 'cdecl', 'ntdll._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._itow':( 'int', None, 'cdecl', 'ntdll._itow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._lfind':( 'int', None, 'cdecl', 'ntdll._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll._ltoa':( 'int', None, 'cdecl', 'ntdll._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._ltow':( 'int', None, 'cdecl', 'ntdll._ltow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._memccpy':( 'int', None, 'cdecl', 'ntdll._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._memicmp':( 'int', None, 'cdecl', 'ntdll._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._snprintf':( 'int', None, 'cdecl', 'ntdll._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._snwprintf':( 'int', None, 'cdecl', 'ntdll._snwprintf', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll._splitpath':( 'int', None, 'cdecl', 'ntdll._splitpath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._strcmpi':( 'int', None, 'cdecl', 'ntdll._strcmpi', (('int', None), ('int', None)) ),
    'ntdll._stricmp':( 'int', None, 'cdecl', 'ntdll._stricmp', (('int', None), ('int', None)) ),
    'ntdll._strlwr':( 'int', None, 'cdecl', 'ntdll._strlwr', (('int', None),) ),
    'ntdll._strnicmp':( 'int', None, 'cdecl', 'ntdll._strnicmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._strupr':( 'int', None, 'cdecl', 'ntdll._strupr', (('int', None),) ),
    'ntdll._tolower':( 'int', None, 'cdecl', 'ntdll._tolower', (('int', None),) ),
    'ntdll._toupper':( 'int', None, 'cdecl', 'ntdll._toupper', (('int', None),) ),
    'ntdll._ui64toa':( 'int', None, 'msfastcall', 'ntdll._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._ui64tow':( 'int', None, 'msfastcall', 'ntdll._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._ultoa':( 'int', None, 'cdecl', 'ntdll._ultoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._ultow':( 'int', None, 'cdecl', 'ntdll._ultow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._vsnprintf':( 'int', None, 'cdecl', 'ntdll._vsnprintf', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._vsnwprintf':( 'int', None, 'cdecl', 'ntdll._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._wcsicmp':( 'int', None, 'cdecl', 'ntdll._wcsicmp', (('int', None), ('int', None)) ),
    'ntdll._wcslwr':( 'int', None, 'cdecl', 'ntdll._wcslwr', (('int', None),) ),
    'ntdll._wcsnicmp':( 'int', None, 'cdecl', 'ntdll._wcsnicmp', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll._wcsupr':( 'int', None, 'cdecl', 'ntdll._wcsupr', (('int', None),) ),
    'ntdll._wtoi':( 'int', None, 'cdecl', 'ntdll._wtoi', (('int', None),) ),
    'ntdll._wtoi64':( 'int', None, 'cdecl', 'ntdll._wtoi64', (('int', None),) ),
    'ntdll._wtol':( 'int', None, 'cdecl', 'ntdll._wtol', (('int', None),) ),
    'ntdll.abs':( 'int', None, 'cdecl', 'ntdll.abs', (('int', None),) ),
    'ntdll.atan':( 'int', None, 'cdecl', 'ntdll.atan', () ),
    'ntdll.atoi':( 'int', None, 'cdecl', 'ntdll.atoi', (('int', None),) ),
    'ntdll.atol':( 'int', None, 'cdecl', 'ntdll.atol', (('int', None),) ),
    'ntdll.bsearch':( 'int', None, 'cdecl', 'ntdll.bsearch', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll.ceil':( 'int', None, 'cdecl', 'ntdll.ceil', () ),
    'ntdll.cos':( 'int', None, 'cdecl', 'ntdll.cos', () ),
    'ntdll.fabs':( 'int', None, 'cdecl', 'ntdll.fabs', (('int', None), ('int', None)) ),
    'ntdll.floor':( 'int', None, 'cdecl', 'ntdll.floor', () ),
    'ntdll.isalnum':( 'int', None, 'cdecl', 'ntdll.isalnum', (('int', None),) ),
    'ntdll.isalpha':( 'int', None, 'cdecl', 'ntdll.isalpha', (('int', None),) ),
    'ntdll.iscntrl':( 'int', None, 'cdecl', 'ntdll.iscntrl', (('int', None),) ),
    'ntdll.isdigit':( 'int', None, 'cdecl', 'ntdll.isdigit', (('int', None),) ),
    'ntdll.isgraph':( 'int', None, 'cdecl', 'ntdll.isgraph', (('int', None),) ),
    'ntdll.islower':( 'int', None, 'cdecl', 'ntdll.islower', (('int', None),) ),
    'ntdll.isprint':( 'int', None, 'cdecl', 'ntdll.isprint', (('int', None),) ),
    'ntdll.ispunct':( 'int', None, 'cdecl', 'ntdll.ispunct', (('int', None),) ),
    'ntdll.isspace':( 'int', None, 'cdecl', 'ntdll.isspace', (('int', None),) ),
    'ntdll.isupper':( 'int', None, 'cdecl', 'ntdll.isupper', (('int', None),) ),
    'ntdll.iswalpha':( 'int', None, 'cdecl', 'ntdll.iswalpha', (('int', None),) ),
    'ntdll.iswctype':( 'int', None, 'cdecl', 'ntdll.iswctype', (('int', None), ('int', None)) ),
    'ntdll.iswdigit':( 'int', None, 'cdecl', 'ntdll.iswdigit', (('int', None),) ),
    'ntdll.iswlower':( 'int', None, 'cdecl', 'ntdll.iswlower', (('int', None),) ),
    'ntdll.iswspace':( 'int', None, 'cdecl', 'ntdll.iswspace', (('int', None),) ),
    'ntdll.iswxdigit':( 'int', None, 'cdecl', 'ntdll.iswxdigit', (('int', None),) ),
    'ntdll.isxdigit':( 'int', None, 'cdecl', 'ntdll.isxdigit', (('int', None),) ),
    'ntdll.labs':( 'int', None, 'cdecl', 'ntdll.labs', (('int', None),) ),
    'ntdll.log':( 'int', None, 'cdecl', 'ntdll.log', () ),
    'ntdll.mbstowcs':( 'int', None, 'cdecl', 'ntdll.mbstowcs', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.memchr':( 'int', None, 'cdecl', 'ntdll.memchr', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memcmp':( 'int', None, 'cdecl', 'ntdll.memcmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memcpy':( 'int', None, 'cdecl', 'ntdll.memcpy', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memmove':( 'int', None, 'cdecl', 'ntdll.memmove', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.memset':( 'int', None, 'cdecl', 'ntdll.memset', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.pow':( 'int', None, 'cdecl', 'ntdll.pow', () ),
    'ntdll.qsort':( 'int', None, 'stdcall', 'ntdll.qsort', ( ('void *', 'funcptr'), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.sin':( 'int', None, 'cdecl', 'ntdll.sin', () ),
    'ntdll.sprintf':( 'int', None, 'cdecl', 'ntdll.sprintf', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.sqrt':( 'int', None, 'cdecl', 'ntdll.sqrt', () ),
    'ntdll.sscanf':( 'int', None, 'cdecl', 'ntdll.sscanf', (('int', None), ('int', None)) ),
    'ntdll.strcat':( 'int', None, 'cdecl', 'ntdll.strcat', (('int', None), ('int', None)) ),
    'ntdll.strchr':( 'int', None, 'cdecl', 'ntdll.strchr', (('int', None), ('int', None)) ),
    'ntdll.strcmp':( 'int', None, 'cdecl', 'ntdll.strcmp', (('int', None), ('int', None)) ),
    'ntdll.strcpy':( 'int', None, 'cdecl', 'ntdll.strcpy', (('int', None), ('int', None)) ),
    'ntdll.strcspn':( 'int', None, 'cdecl', 'ntdll.strcspn', (('int', None), ('int', None)) ),
    'ntdll.strlen':( 'int', None, 'cdecl', 'ntdll.strlen', (('int', None),) ),
    'ntdll.strncat':( 'int', None, 'cdecl', 'ntdll.strncat', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strncmp':( 'int', None, 'cdecl', 'ntdll.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strncpy':( 'int', None, 'cdecl', 'ntdll.strncpy', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strpbrk':( 'int', None, 'cdecl', 'ntdll.strpbrk', (('int', None), ('int', None)) ),
    'ntdll.strrchr':( 'int', None, 'cdecl', 'ntdll.strrchr', (('int', None), ('int', None)) ),
    'ntdll.strspn':( 'int', None, 'cdecl', 'ntdll.strspn', (('int', None), ('int', None)) ),
    'ntdll.strstr':( 'int', None, 'cdecl', 'ntdll.strstr', (('int', None), ('int', None)) ),
    'ntdll.strtol':( 'int', None, 'cdecl', 'ntdll.strtol', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strtoul':( 'int', None, 'cdecl', 'ntdll.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.swprintf':( 'int', None, 'cdecl', 'ntdll.swprintf', (('wchar *', 'ptr'), ('int', None)) ),
    'ntdll.tan':( 'int', None, 'cdecl', 'ntdll.tan', () ),
    'ntdll.tolower':( 'int', None, 'cdecl', 'ntdll.tolower', (('int', None),) ),
    'ntdll.toupper':( 'int', None, 'cdecl', 'ntdll.toupper', (('int', None),) ),
    'ntdll.towlower':( 'int', None, 'cdecl', 'ntdll.towlower', (('int', None),) ),
    'ntdll.towupper':( 'int', None, 'cdecl', 'ntdll.towupper', (('int', None),) ),
    'ntdll.vdbgprintex':( 'int', None, 'stdcall', 'ntdll.vDbgPrintEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.vdbgprintexwithprefix':( 'int', None, 'stdcall', 'ntdll.vDbgPrintExWithPrefix', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.vsprintf':( 'int', None, 'cdecl', 'ntdll.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcscat':( 'int', None, 'cdecl', 'ntdll.wcscat', (('int', None), ('void *', 'ptr')) ),
    'ntdll.wcschr':( 'int', None, 'cdecl', 'ntdll.wcschr', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcscmp':( 'int', None, 'cdecl', 'ntdll.wcscmp', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcscpy':( 'int', None, 'cdecl', 'ntdll.wcscpy', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.wcscspn':( 'int', None, 'cdecl', 'ntdll.wcscspn', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcslen':( 'int', None, 'cdecl', 'ntdll.wcslen', (('void *', 'ptr'),) ),
    'ntdll.wcsncat':( 'int', None, 'cdecl', 'ntdll.wcsncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.wcsncmp':( 'int', None, 'cdecl', 'ntdll.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcsncpy':( 'int', None, 'cdecl', 'ntdll.wcsncpy', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.wcspbrk':( 'int', None, 'cdecl', 'ntdll.wcspbrk', (('int', None), ('int', None)) ),
    'ntdll.wcsrchr':( 'int', None, 'cdecl', 'ntdll.wcsrchr', (('int', None), ('int', None)) ),
    'ntdll.wcsspn':( 'int', None, 'cdecl', 'ntdll.wcsspn', (('int', None), ('int', None)) ),
    'ntdll.wcsstr':( 'int', None, 'cdecl', 'ntdll.wcsstr', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcstol':( 'int', None, 'cdecl', 'ntdll.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcstombs':( 'int', None, 'cdecl', 'ntdll.wcstombs', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcstoul':( 'int', None, 'cdecl', 'ntdll.wcstoul', (('int', None), ('void *', 'ptr'), ('int', None)) ),

    # KERNEL32
    'kernel32.main_entry':( 'int', None, 'stdcall', 'kernel32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.activateactctx':( 'int', None, 'stdcall', 'kernel32.ActivateActCtx', (('int', None), ('int', None)) ),
    'kernel32.addatoma':( 'int', None, 'stdcall', 'kernel32.AddAtomA', (('int', None),) ),
    'kernel32.addatomw':( 'int', None, 'stdcall', 'kernel32.AddAtomW', (('int', None),) ),
    'kernel32.addconsolealiasa':( 'int', None, 'stdcall', 'kernel32.AddConsoleAliasA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.addconsolealiasw':( 'int', None, 'stdcall', 'kernel32.AddConsoleAliasW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.addlocalalternatecomputernamea':( 'int', None, 'stdcall', 'kernel32.AddLocalAlternateComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.addlocalalternatecomputernamew':( 'int', None, 'stdcall', 'kernel32.AddLocalAlternateComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.addrefactctx':( 'int', None, 'cdecl', 'kernel32.AddRefActCtx', () ),
    'kernel32.allocconsole':( 'int', None, 'cdecl', 'kernel32.AllocConsole', () ),
    'kernel32.allocateuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.AllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.arefileapisansi':( 'int', None, 'cdecl', 'kernel32.AreFileApisANSI', () ),
    'kernel32.assignprocesstojobobject':( 'int', None, 'stdcall', 'kernel32.AssignProcessToJobObject', (('int', None), ('int', None)) ),
    'kernel32.attachconsole':( 'int', None, 'stdcall', 'kernel32.AttachConsole', (('int', None),) ),
    'kernel32.backupread':( 'int', None, 'stdcall', 'kernel32.BackupRead', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.backupseek':( 'int', None, 'stdcall', 'kernel32.BackupSeek', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.backupwrite':( 'int', None, 'stdcall', 'kernel32.BackupWrite', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.basecheckappcompatcache':( 'int', None, 'stdcall', 'kernel32.BaseCheckAppcompatCache', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.basecleanupappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseCleanupAppcompatCache', () ),
    'kernel32.basecleanupappcompatcachesupport':( 'int', None, 'stdcall', 'kernel32.BaseCleanupAppcompatCacheSupport', (('int', None),) ),
    'kernel32.basedumpappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseDumpAppcompatCache', () ),
    'kernel32.baseflushappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseFlushAppcompatCache', () ),
    'kernel32.baseinitappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseInitAppcompatCache', () ),
    'kernel32.baseinitappcompatcachesupport':( 'int', None, 'cdecl', 'kernel32.BaseInitAppcompatCacheSupport', () ),
    'kernel32.baseprocessinitpostimport':( 'int', None, 'cdecl', 'kernel32.BaseProcessInitPostImport', () ),
    'kernel32.basequerymoduledata':( 'int', None, 'stdcall', 'kernel32.BaseQueryModuleData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.baseupdateappcompatcache':( 'int', None, 'stdcall', 'kernel32.BaseUpdateAppcompatCache', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.basepcheckwinsaferrestrictions':( 'int', None, 'stdcall', 'kernel32.BasepCheckWinSaferRestrictions', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.beep':( 'int', None, 'stdcall', 'kernel32.Beep', (('int', None), ('int', None)) ),
    'kernel32.beginupdateresourcea':( 'int', None, 'stdcall', 'kernel32.BeginUpdateResourceA', ( ('int', None), ('int', None)) ),
    'kernel32.beginupdateresourcew':( 'int', None, 'stdcall', 'kernel32.BeginUpdateResourceW', ( ('void *', 'ptr'), ('int', None)) ),
    'kernel32.bindiocompletioncallback':( 'int', None, 'stdcall', 'kernel32.BindIoCompletionCallback', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.buildcommdcba':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBA', ( ('int', None),) ),
    'kernel32.buildcommdcbandtimeoutsa':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBAndTimeoutsA', ( ('int', None), ('void *', 'ptr')) ),
    'kernel32.buildcommdcbandtimeoutsw':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBAndTimeoutsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.buildcommdcbw':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBW', (('int', None), ('int', None)) ),
    'kernel32.callnamedpipea':( 'int', None, 'stdcall', 'kernel32.CallNamedPipeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.callnamedpipew':( 'int', None, 'stdcall', 'kernel32.CallNamedPipeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.canceldevicewakeuprequest':( 'int', None, 'stdcall', 'kernel32.CancelDeviceWakeupRequest', (('int', None),) ),
    'kernel32.cancelio':( 'int', None, 'stdcall', 'kernel32.CancelIo', (('int', None),) ),
    'kernel32.canceltimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.CancelTimerQueueTimer', (('int', None), ('int', None)) ),
    'kernel32.cancelwaitabletimer':( 'int', None, 'stdcall', 'kernel32.CancelWaitableTimer', (('int', None),) ),
    'kernel32.changetimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.ChangeTimerQueueTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checknamelegaldos8dot3a':( 'int', None, 'stdcall', 'kernel32.CheckNameLegalDOS8Dot3A', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checknamelegaldos8dot3w':( 'int', None, 'stdcall', 'kernel32.CheckNameLegalDOS8Dot3W', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checkremotedebuggerpresent':( 'int', None, 'stdcall', 'kernel32.CheckRemoteDebuggerPresent', (('int', None), ('int', None)) ),
    'kernel32.clearcommbreak':( 'int', None, 'stdcall', 'kernel32.ClearCommBreak', (('int', None),) ),
    'kernel32.clearcommerror':( 'int', None, 'stdcall', 'kernel32.ClearCommError', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.closeconsolehandle':( 'int', None, 'stdcall', 'kernel32.CloseConsoleHandle', (('int', None),) ),
    'kernel32.closehandle':( 'int', None, 'stdcall', 'kernel32.CloseHandle', (('int', None),) ),
    'kernel32.closeprofileusermapping':( 'int', None, 'cdecl', 'kernel32.CloseProfileUserMapping', () ),
    'kernel32.cmdbatnotification':( 'int', None, 'stdcall', 'kernel32.CmdBatNotification', (('int', None),) ),
    'kernel32.commconfigdialoga':( 'int', None, 'stdcall', 'kernel32.CommConfigDialogA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.commconfigdialogw':( 'int', None, 'stdcall', 'kernel32.CommConfigDialogW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.comparefiletime':( 'int', None, 'stdcall', 'kernel32.CompareFileTime', (('int', None), ('int', None)) ),
    'kernel32.comparestringa':( 'int', None, 'stdcall', 'kernel32.CompareStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.comparestringw':( 'int', None, 'stdcall', 'kernel32.CompareStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.connectnamedpipe':( 'int', None, 'stdcall', 'kernel32.ConnectNamedPipe', (('int', None), ('int', None)) ),
    'kernel32.consolemenucontrol':( 'int', None, 'stdcall', 'kernel32.ConsoleMenuControl', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.continuedebugevent':( 'int', None, 'stdcall', 'kernel32.ContinueDebugEvent', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.convertdefaultlocale':( 'int', None, 'stdcall', 'kernel32.ConvertDefaultLocale', (('int', None),) ),
    'kernel32.convertfibertothread':( 'int', None, 'cdecl', 'kernel32.ConvertFiberToThread', () ),
    'kernel32.convertthreadtofiber':( 'int', None, 'stdcall', 'kernel32.ConvertThreadToFiber', (('int', None),) ),
    'kernel32.copyfilea':( 'int', None, 'stdcall', 'kernel32.CopyFileA', ( ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfileexa':( 'int', None, 'stdcall', 'kernel32.CopyFileExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfileexw':( 'int', None, 'stdcall', 'kernel32.CopyFileExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfilew':( 'int', None, 'stdcall', 'kernel32.CopyFileW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.copylzfile':( 'int', None, 'stdcall', 'kernel32.CopyLZFile', (('int', None), ('int', None)) ),
    'kernel32.createactctxa':( 'int', None, 'stdcall', 'kernel32.CreateActCtxA', (('int', None),) ),
    'kernel32.createactctxw':( 'int', None, 'stdcall', 'kernel32.CreateActCtxW', (('void *', 'ptr'),) ),
    'kernel32.createconsolescreenbuffer':( 'int', None, 'stdcall', 'kernel32.CreateConsoleScreenBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectorya':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.createdirectoryexa':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryExA', ( ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectoryexw':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectoryw':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.createeventa':( 'int', None, 'stdcall', 'kernel32.CreateEventA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createeventw':( 'int', None, 'stdcall', 'kernel32.CreateEventW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfiber':( 'int', None, 'stdcall', 'kernel32.CreateFiber', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfiberex':( 'int', None, 'stdcall', 'kernel32.CreateFiberEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilea':( 'int', None, 'stdcall', 'kernel32.CreateFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilemappinga':( 'int', None, 'stdcall', 'kernel32.CreateFileMappingA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilemappingw':( 'int', None, 'stdcall', 'kernel32.CreateFileMappingW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilew':( 'int', None, 'stdcall', 'kernel32.CreateFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createhardlinka':( 'int', None, 'stdcall', 'kernel32.CreateHardLinkA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createhardlinkw':( 'int', None, 'stdcall', 'kernel32.CreateHardLinkW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createiocompletionport':( 'int', None, 'stdcall', 'kernel32.CreateIoCompletionPort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createjobobjecta':( 'int', None, 'stdcall', 'kernel32.CreateJobObjectA', (('int', None), ('int', None)) ),
    'kernel32.createjobobjectw':( 'int', None, 'stdcall', 'kernel32.CreateJobObjectW', (('int', None), ('int', None)) ),
    'kernel32.createjobset':( 'int', None, 'stdcall', 'kernel32.CreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createmailslota':( 'int', None, 'stdcall', 'kernel32.CreateMailslotA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createmailslotw':( 'int', None, 'stdcall', 'kernel32.CreateMailslotW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.creatememoryresourcenotification':( 'int', None, 'stdcall', 'kernel32.CreateMemoryResourceNotification', (('int', None),) ),
    'kernel32.createmutexa':( 'int', None, 'stdcall', 'kernel32.CreateMutexA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createmutexw':( 'int', None, 'stdcall', 'kernel32.CreateMutexW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createnamedpipea':( 'int', None, 'stdcall', 'kernel32.CreateNamedPipeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createnamedpipew':( 'int', None, 'stdcall', 'kernel32.CreateNamedPipeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createnlssecuritydescriptor':( 'int', None, 'stdcall', 'kernel32.CreateNlsSecurityDescriptor', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createpipe':( 'int', None, 'stdcall', 'kernel32.CreatePipe', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createprocessa':( 'int', None, 'stdcall', 'kernel32.CreateProcessA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.createprocessinternala':( 'int', None, 'stdcall', 'kernel32.CreateProcessInternalA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.createprocessinternalw':( 'int', None, 'stdcall', 'kernel32.CreateProcessInternalW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createprocessinternalwsecure':( 'int', None, 'cdecl', 'kernel32.CreateProcessInternalWSecure', () ),
    'kernel32.createprocessw':( 'int', None, 'stdcall', 'kernel32.CreateProcessW', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.createremotethread':( 'int', None, 'stdcall', 'kernel32.CreateRemoteThread', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsemaphorea':( 'int', None, 'stdcall', 'kernel32.CreateSemaphoreA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsemaphorew':( 'int', None, 'stdcall', 'kernel32.CreateSemaphoreW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsockethandle':( 'int', None, 'cdecl', 'kernel32.CreateSocketHandle', () ),
    'kernel32.createtapepartition':( 'int', None, 'stdcall', 'kernel32.CreateTapePartition', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createthread':( 'int', None, 'stdcall', 'kernel32.CreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createtimerqueue':( 'int', None, 'stdcall', 'kernel32.CreateTimerQueue', () ),
    'kernel32.createtimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.CreateTimerQueueTimer', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createtoolhelp32snapshot':( 'int', None, 'stdcall', 'kernel32.CreateToolhelp32Snapshot', (('int', None), ('int', None)) ),
    'kernel32.createvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.CreateVirtualBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createwaitabletimera':( 'int', None, 'stdcall', 'kernel32.CreateWaitableTimerA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createwaitabletimerw':( 'int', None, 'stdcall', 'kernel32.CreateWaitableTimerW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.deactivateactctx':( 'int', None, 'stdcall', 'kernel32.DeactivateActCtx', (('int', None), ('int', None)) ),
    'kernel32.debugactiveprocess':( 'int', None, 'stdcall', 'kernel32.DebugActiveProcess', (('int', None),) ),
    'kernel32.debugactiveprocessstop':( 'int', None, 'stdcall', 'kernel32.DebugActiveProcessStop', (('int', None),) ),
    'kernel32.debugbreak':( 'int', None, 'cdecl', 'kernel32.DebugBreak', () ),
    'kernel32.debugbreakprocess':( 'int', None, 'stdcall', 'kernel32.DebugBreakProcess', (('int', None),) ),
    'kernel32.debugsetprocesskillonexit':( 'int', None, 'stdcall', 'kernel32.DebugSetProcessKillOnExit', (('int', None),) ),
    'kernel32.definedosdevicea':( 'int', None, 'stdcall', 'kernel32.DefineDosDeviceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.definedosdevicew':( 'int', None, 'stdcall', 'kernel32.DefineDosDeviceW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.delayloadfailurehook':( 'int', None, 'stdcall', 'kernel32.DelayLoadFailureHook', (('int', None), ('int', None)) ),
    'kernel32.deleteatom':( 'int', None, 'stdcall', 'kernel32.DeleteAtom', (('int', None),) ),
    'kernel32.deletefiber':( 'int', None, 'stdcall', 'kernel32.DeleteFiber', (('DWORD', None),) ),
    'kernel32.deletefilea':( 'int', None, 'stdcall', 'kernel32.DeleteFileA', (('int', None),) ),
    'kernel32.deletefilew':( 'int', None, 'stdcall', 'kernel32.DeleteFileW', (('void *', 'ptr'),) ),
    'kernel32.deletetimerqueue':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueue', (('int', None),) ),
    'kernel32.deletetimerqueueex':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueueEx', (('int', None), ('int', None)) ),
    'kernel32.deletetimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueueTimer', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.deletevolumemountpointa':( 'int', None, 'stdcall', 'kernel32.DeleteVolumeMountPointA', (('int', None),) ),
    'kernel32.deletevolumemountpointw':( 'int', None, 'stdcall', 'kernel32.DeleteVolumeMountPointW', (('int', None),) ),
    'kernel32.deviceiocontrol':( 'int', None, 'stdcall', 'kernel32.DeviceIoControl', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.disablethreadlibrarycalls':( 'int', None, 'stdcall', 'kernel32.DisableThreadLibraryCalls', (('int', None),) ),
    'kernel32.disconnectnamedpipe':( 'int', None, 'stdcall', 'kernel32.DisconnectNamedPipe', (('int', None),) ),
    'kernel32.dnshostnametocomputernamea':( 'int', None, 'stdcall', 'kernel32.DnsHostnameToComputerNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dnshostnametocomputernamew':( 'int', None, 'stdcall', 'kernel32.DnsHostnameToComputerNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.dosdatetimetofiletime':( 'int', None, 'stdcall', 'kernel32.DosDateTimeToFileTime', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dospathtosessionpatha':( 'int', None, 'stdcall', 'kernel32.DosPathToSessionPathA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dospathtosessionpathw':( 'int', None, 'stdcall', 'kernel32.DosPathToSessionPathW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.duplicateconsolehandle':( 'int', None, 'stdcall', 'kernel32.DuplicateConsoleHandle', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.duplicatehandle':( 'int', None, 'stdcall', 'kernel32.DuplicateHandle', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.endupdateresourcea':( 'int', None, 'stdcall', 'kernel32.EndUpdateResourceA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.endupdateresourcew':( 'int', None, 'stdcall', 'kernel32.EndUpdateResourceW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.enumcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfoexa':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoExA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfoexw':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoExW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfow':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsa':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsexa':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsExA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsexw':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsExW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsw':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumlanguagegrouplocalesa':( 'int', None, 'stdcall', 'kernel32.EnumLanguageGroupLocalesA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumlanguagegrouplocalesw':( 'int', None, 'stdcall', 'kernel32.EnumLanguageGroupLocalesW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumresourcelanguagesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceLanguagesA', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcelanguagesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceLanguagesW', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcenamesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceNamesA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcenamesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceNamesW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'kernel32.enumresourcetypesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceTypesA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcetypesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceTypesW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemcodepagesa':( 'int', None, 'stdcall', 'kernel32.EnumSystemCodePagesA', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemcodepagesw':( 'int', None, 'stdcall', 'kernel32.EnumSystemCodePagesW', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemgeoid':( 'int', None, 'stdcall', 'kernel32.EnumSystemGeoID', ( ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'kernel32.enumsystemlanguagegroupsa':( 'int', None, 'stdcall', 'kernel32.EnumSystemLanguageGroupsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumsystemlanguagegroupsw':( 'int', None, 'stdcall', 'kernel32.EnumSystemLanguageGroupsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumsystemlocalesa':( 'int', None, 'stdcall', 'kernel32.EnumSystemLocalesA', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemlocalesw':( 'int', None, 'stdcall', 'kernel32.EnumSystemLocalesW', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumtimeformatsa':( 'int', None, 'stdcall', 'kernel32.EnumTimeFormatsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumtimeformatsw':( 'int', None, 'stdcall', 'kernel32.EnumTimeFormatsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumuilanguagesa':( 'int', None, 'stdcall', 'kernel32.EnumUILanguagesA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumuilanguagesw':( 'int', None, 'stdcall', 'kernel32.EnumUILanguagesW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumeratelocalcomputernamesa':( 'int', None, 'stdcall', 'kernel32.EnumerateLocalComputerNamesA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumeratelocalcomputernamesw':( 'int', None, 'stdcall', 'kernel32.EnumerateLocalComputerNamesW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.erasetape':( 'int', None, 'stdcall', 'kernel32.EraseTape', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.escapecommfunction':( 'int', None, 'stdcall', 'kernel32.EscapeCommFunction', (('int', None), ('int', None)) ),
    'kernel32.exitprocess':( 'int', None, 'cdecl', 'kernel32.ExitProcess', (('int', None),) ),
    'kernel32.exitthread':( 'int', None, 'cdecl', 'kernel32.ExitThread', (('int', None),) ),
    'kernel32.exitvdm':( 'int', None, 'stdcall', 'kernel32.ExitVDM', (('int', None), ('int', None)) ),
    'kernel32.expandenvironmentstringsa':( 'int', None, 'stdcall', 'kernel32.ExpandEnvironmentStringsA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.expandenvironmentstringsw':( 'int', None, 'stdcall', 'kernel32.ExpandEnvironmentStringsW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.expungeconsolecommandhistorya':( 'int', None, 'stdcall', 'kernel32.ExpungeConsoleCommandHistoryA', (('int', None),) ),
    'kernel32.expungeconsolecommandhistoryw':( 'int', None, 'stdcall', 'kernel32.ExpungeConsoleCommandHistoryW', (('int', None),) ),
    'kernel32.extendvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.ExtendVirtualBuffer', (('int', None), ('int', None)) ),
    'kernel32.fatalappexita':( 'int', None, 'stdcall', 'kernel32.FatalAppExitA', (('int', None), ('int', None)) ),
    'kernel32.fatalappexitw':( 'int', None, 'stdcall', 'kernel32.FatalAppExitW', (('int', None), ('int', None)) ),
    'kernel32.fatalexit':( 'int', None, 'cdecl', 'kernel32.FatalExit', (('int', None),) ),
    'kernel32.filetimetodosdatetime':( 'int', None, 'stdcall', 'kernel32.FileTimeToDosDateTime', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.filetimetolocalfiletime':( 'int', None, 'stdcall', 'kernel32.FileTimeToLocalFileTime', (('int', None), ('int', None)) ),
    'kernel32.filetimetosystemtime':( 'int', None, 'stdcall', 'kernel32.FileTimeToSystemTime', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.fillconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.fillconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.fillconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionguid':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionGuid', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionstringa':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionstringw':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findatoma':( 'int', None, 'stdcall', 'kernel32.FindAtomA', (('int', None),) ),
    'kernel32.findatomw':( 'int', None, 'stdcall', 'kernel32.FindAtomW', (('int', None),) ),
    'kernel32.findclose':( 'int', None, 'stdcall', 'kernel32.FindClose', (('void *', 'ptr'),) ),
    'kernel32.findclosechangenotification':( 'int', None, 'stdcall', 'kernel32.FindCloseChangeNotification', (('int', None),) ),
    'kernel32.findfirstchangenotificationa':( 'int', None, 'stdcall', 'kernel32.FindFirstChangeNotificationA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstchangenotificationw':( 'int', None, 'stdcall', 'kernel32.FindFirstChangeNotificationW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfilea':( 'int', None, 'stdcall', 'kernel32.FindFirstFileA', (('int', None), ('int', None)) ),
    'kernel32.findfirstfileexa':( 'int', None, 'stdcall', 'kernel32.FindFirstFileExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfileexw':( 'int', None, 'stdcall', 'kernel32.FindFirstFileExW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfilew':( 'int', None, 'stdcall', 'kernel32.FindFirstFileW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.findfirstvolumea':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeA', (('int', None), ('int', None)) ),
    'kernel32.findfirstvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstvolumemountpointw':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeMountPointW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstvolumew':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeW', (('int', None), ('int', None)) ),
    'kernel32.findnextchangenotification':( 'int', None, 'stdcall', 'kernel32.FindNextChangeNotification', (('int', None),) ),
    'kernel32.findnextfilea':( 'int', None, 'stdcall', 'kernel32.FindNextFileA', (('int', None), ('int', None)) ),
    'kernel32.findnextfilew':( 'int', None, 'stdcall', 'kernel32.FindNextFileW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.findnextvolumea':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumemountpointw':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeMountPointW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumew':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourcea':( 'int', None, 'stdcall', 'kernel32.FindResourceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourceexa':( 'int', None, 'stdcall', 'kernel32.FindResourceExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourceexw':( 'int', None, 'stdcall', 'kernel32.FindResourceExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourcew':( 'int', None, 'stdcall', 'kernel32.FindResourceW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findvolumeclose':( 'int', None, 'stdcall', 'kernel32.FindVolumeClose', (('void *', 'ptr'),) ),
    'kernel32.findvolumemountpointclose':( 'int', None, 'stdcall', 'kernel32.FindVolumeMountPointClose', (('int', None),) ),
    'kernel32.flushconsoleinputbuffer':( 'int', None, 'stdcall', 'kernel32.FlushConsoleInputBuffer', (('int', None),) ),
    'kernel32.flushfilebuffers':( 'int', None, 'stdcall', 'kernel32.FlushFileBuffers', (('int', None),) ),
    'kernel32.flushinstructioncache':( 'int', None, 'stdcall', 'kernel32.FlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.flushviewoffile':( 'int', None, 'stdcall', 'kernel32.FlushViewOfFile', (('int', None), ('int', None)) ),
    'kernel32.foldstringa':( 'int', None, 'stdcall', 'kernel32.FoldStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.foldstringw':( 'int', None, 'stdcall', 'kernel32.FoldStringW', (('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'kernel32.formatmessagea':( 'int', None, 'stdcall', 'kernel32.FormatMessageA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.formatmessagew':( 'int', None, 'stdcall', 'kernel32.FormatMessageW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.freeconsole':( 'int', None, 'cdecl', 'kernel32.FreeConsole', () ),
    'kernel32.freeenvironmentstringsa':( 'int', None, 'stdcall', 'kernel32.FreeEnvironmentStringsA', (('void *', 'ptr'),) ),
    'kernel32.freeenvironmentstringsw':( 'int', None, 'stdcall', 'kernel32.FreeEnvironmentStringsW', (('int', None),) ),
    'kernel32.freelibrary':( 'int', None, 'stdcall', 'kernel32.FreeLibrary', (('int', None),) ),
    'kernel32.freelibraryandexitthread':( 'int', None, 'stdcall', 'kernel32.FreeLibraryAndExitThread', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.freeresource':( 'int', None, 'stdcall', 'kernel32.FreeResource', (('int', None),) ),
    'kernel32.freeuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.FreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.freevirtualbuffer':( 'int', None, 'stdcall', 'kernel32.FreeVirtualBuffer', (('void *', 'ptr'),) ),
    'kernel32.generateconsolectrlevent':( 'int', None, 'stdcall', 'kernel32.GenerateConsoleCtrlEvent', (('int', None), ('int', None)) ),
    'kernel32.getacp':( 'int', None, 'cdecl', 'kernel32.GetACP', () ),
    'kernel32.getatomnamea':( 'int', None, 'stdcall', 'kernel32.GetAtomNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getatomnamew':( 'int', None, 'stdcall', 'kernel32.GetAtomNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getbinarytype':( 'int', None, 'stdcall', 'kernel32.GetBinaryType', (('int', None), ('int', None)) ),
    'kernel32.getbinarytypea':( 'int', None, 'stdcall', 'kernel32.GetBinaryTypeA', (('int', None), ('int', None)) ),
    'kernel32.getbinarytypew':( 'int', None, 'stdcall', 'kernel32.GetBinaryTypeW', (('int', None), ('int', None)) ),
    'kernel32.getcpfilenamefromregistry':( 'int', None, 'stdcall', 'kernel32.GetCPFileNameFromRegistry', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getcpinfo':( 'int', None, 'stdcall', 'kernel32.GetCPInfo', ( ('int', None),) ),
    'kernel32.getcpinfoexa':( 'int', None, 'stdcall', 'kernel32.GetCPInfoExA', ( ('int', None), ('int', None)) ),
    'kernel32.getcpinfoexw':( 'int', None, 'stdcall', 'kernel32.GetCPInfoExW', ( ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.GetCalendarInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcalendarinfow':( 'int', None, 'stdcall', 'kernel32.GetCalendarInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getcompluspackageinstallstatus':( 'int', None, 'cdecl', 'kernel32.GetComPlusPackageInstallStatus', () ),
    'kernel32.getcommconfig':( 'int', None, 'stdcall', 'kernel32.GetCommConfig', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcommmask':( 'int', None, 'stdcall', 'kernel32.GetCommMask', (('int', None), ('int', None)) ),
    'kernel32.getcommmodemstatus':( 'int', None, 'stdcall', 'kernel32.GetCommModemStatus', (('int', None), ('int', None)) ),
    'kernel32.getcommproperties':( 'int', None, 'stdcall', 'kernel32.GetCommProperties', (('int', None), ('int', None)) ),
    'kernel32.getcommstate':( 'int', None, 'stdcall', 'kernel32.GetCommState', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcommtimeouts':( 'int', None, 'stdcall', 'kernel32.GetCommTimeouts', (('int', None), ('int', None)) ),
    'kernel32.getcommandlinea':( 'int', None, 'cdecl', 'kernel32.GetCommandLineA', () ),
    'kernel32.getcommandlinew':( 'int', None, 'cdecl', 'kernel32.GetCommandLineW', () ),
    'kernel32.getcompressedfilesizea':( 'int', None, 'stdcall', 'kernel32.GetCompressedFileSizeA', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcompressedfilesizew':( 'int', None, 'stdcall', 'kernel32.GetCompressedFileSizeW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernamea':( 'int', None, 'stdcall', 'kernel32.GetComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.getcomputernameexa':( 'int', None, 'stdcall', 'kernel32.GetComputerNameExA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernameexw':( 'int', None, 'stdcall', 'kernel32.GetComputerNameExW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernamew':( 'int', None, 'stdcall', 'kernel32.GetComputerNameW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsolealiasa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiasexesa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasExesA', (('int', None), ('int', None)) ),
    'kernel32.getconsolealiasexeslengtha':( 'int', None, 'cdecl', 'kernel32.GetConsoleAliasExesLengthA', () ),
    'kernel32.getconsolealiasexeslengthw':( 'int', None, 'cdecl', 'kernel32.GetConsoleAliasExesLengthW', () ),
    'kernel32.getconsolealiasexesw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasExesW', (('int', None), ('int', None)) ),
    'kernel32.getconsolealiasw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiasesa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiaseslengtha':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesLengthA', (('int', None),) ),
    'kernel32.getconsolealiaseslengthw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesLengthW', (('int', None),) ),
    'kernel32.getconsolealiasesw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecp':( 'int', None, 'cdecl', 'kernel32.GetConsoleCP', () ),
    'kernel32.getconsolechartype':( 'int', None, 'stdcall', 'kernel32.GetConsoleCharType', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecommandhistorya':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecommandhistorylengtha':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryLengthA', (('int', None),) ),
    'kernel32.getconsolecommandhistorylengthw':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryLengthW', (('int', None),) ),
    'kernel32.getconsolecommandhistoryw':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecursorinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleCursorInfo', (('int', None), ('int', None)) ),
    'kernel32.getconsolecursormode':( 'int', None, 'stdcall', 'kernel32.GetConsoleCursorMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsoledisplaymode':( 'int', None, 'stdcall', 'kernel32.GetConsoleDisplayMode', (('void *', 'ptr'),) ),
    'kernel32.getconsolefontinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleFontInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolefontsize':( 'int', None, 'stdcall', 'kernel32.GetConsoleFontSize', (('int', None), ('int', None)) ),
    'kernel32.getconsolehardwarestate':( 'int', None, 'stdcall', 'kernel32.GetConsoleHardwareState', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsoleinputexenamea':( 'int', None, 'stdcall', 'kernel32.GetConsoleInputExeNameA', (('int', None), ('int', None)) ),
    'kernel32.getconsoleinputexenamew':( 'int', None, 'stdcall', 'kernel32.GetConsoleInputExeNameW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsoleinputwaithandle':( 'int', None, 'cdecl', 'kernel32.GetConsoleInputWaitHandle', () ),
    'kernel32.getconsolekeyboardlayoutnamea':( 'int', None, 'stdcall', 'kernel32.GetConsoleKeyboardLayoutNameA', (('int', None),) ),
    'kernel32.getconsolekeyboardlayoutnamew':( 'int', None, 'stdcall', 'kernel32.GetConsoleKeyboardLayoutNameW', (('int', None),) ),
    'kernel32.getconsolemode':( 'int', None, 'stdcall', 'kernel32.GetConsoleMode', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsolenlsmode':( 'int', None, 'stdcall', 'kernel32.GetConsoleNlsMode', (('int', None), ('int', None)) ),
    'kernel32.getconsoleoutputcp':( 'int', None, 'cdecl', 'kernel32.GetConsoleOutputCP', () ),
    'kernel32.getconsoleprocesslist':( 'int', None, 'stdcall', 'kernel32.GetConsoleProcessList', (('int', None), ('int', None)) ),
    'kernel32.getconsolescreenbufferinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleScreenBufferInfo', (('int', None), ('int', None)) ),
    'kernel32.getconsoleselectioninfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleSelectionInfo', (('int', None),) ),
    'kernel32.getconsoletitlea':( 'int', None, 'stdcall', 'kernel32.GetConsoleTitleA', (('int', None), ('int', None)) ),
    'kernel32.getconsoletitlew':( 'int', None, 'stdcall', 'kernel32.GetConsoleTitleW', (('int', None), ('int', None)) ),
    'kernel32.getconsolewindow':( 'int', None, 'cdecl', 'kernel32.GetConsoleWindow', () ),
    'kernel32.getcurrencyformata':( 'int', None, 'stdcall', 'kernel32.GetCurrencyFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcurrencyformatw':( 'int', None, 'stdcall', 'kernel32.GetCurrencyFormatW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getcurrentactctx':( 'int', None, 'stdcall', 'kernel32.GetCurrentActCtx', (('int', None),) ),
    'kernel32.getcurrentconsolefont':( 'int', None, 'stdcall', 'kernel32.GetCurrentConsoleFont', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcurrentdirectorya':( 'int', None, 'stdcall', 'kernel32.GetCurrentDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getcurrentdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetCurrentDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.getcurrentprocess':( 'int', None, 'cdecl', 'kernel32.GetCurrentProcess', () ),
    'kernel32.getcurrentprocessid':( 'int', None, 'cdecl', 'kernel32.GetCurrentProcessId', () ),
    'kernel32.getcurrentthread':( 'int', None, 'cdecl', 'kernel32.GetCurrentThread', () ),
    'kernel32.getcurrentthreadid':( 'int', None, 'cdecl', 'kernel32.GetCurrentThreadId', () ),
    'kernel32.getdateformata':( 'int', None, 'stdcall', 'kernel32.GetDateFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdateformatw':( 'int', None, 'stdcall', 'kernel32.GetDateFormatW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getdefaultcommconfiga':( 'int', None, 'stdcall', 'kernel32.GetDefaultCommConfigA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdefaultcommconfigw':( 'int', None, 'stdcall', 'kernel32.GetDefaultCommConfigW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdefaultsortkeysize':( 'int', None, 'stdcall', 'kernel32.GetDefaultSortkeySize', (('int', None),) ),
    'kernel32.getdevicepowerstate':( 'int', None, 'stdcall', 'kernel32.GetDevicePowerState', (('int', None), ('int', None)) ),
    'kernel32.getdiskfreespacea':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespaceexa':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespaceexw':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespacew':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdlldirectorya':( 'int', None, 'stdcall', 'kernel32.GetDllDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getdlldirectoryw':( 'int', None, 'stdcall', 'kernel32.GetDllDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.getdrivetypea':( 'int', None, 'stdcall', 'kernel32.GetDriveTypeA', (('int', None),) ),
    'kernel32.getdrivetypew':( 'int', None, 'stdcall', 'kernel32.GetDriveTypeW', (('int', None),) ),
    'kernel32.getenvironmentstrings':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStrings', () ),
    'kernel32.getenvironmentstringsa':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStringsA', () ),
    'kernel32.getenvironmentstringsw':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStringsW', () ),
    'kernel32.getenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.GetEnvironmentVariableA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.GetEnvironmentVariableW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getexitcodeprocess':( 'int', None, 'stdcall', 'kernel32.GetExitCodeProcess', (('int', None), ('int', None)) ),
    'kernel32.getexitcodethread':( 'int', None, 'stdcall', 'kernel32.GetExitCodeThread', (('int', None), ('int', None)) ),
    'kernel32.getexpandednamea':( 'int', None, 'stdcall', 'kernel32.GetExpandedNameA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getexpandednamew':( 'int', None, 'stdcall', 'kernel32.GetExpandedNameW', (('int', None), ('int', None)) ),
    'kernel32.getfileattributesa':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesA', (('int', None),) ),
    'kernel32.getfileattributesexa':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfileattributesexw':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfileattributesw':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesW', (('int', None),) ),
    'kernel32.getfileinformationbyhandle':( 'int', None, 'stdcall', 'kernel32.GetFileInformationByHandle', (('int', None), ('int', None)) ),
    'kernel32.getfilesize':( 'int', None, 'stdcall', 'kernel32.GetFileSize', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getfilesizeex':( 'int', None, 'stdcall', 'kernel32.GetFileSizeEx', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getfiletime':( 'int', None, 'stdcall', 'kernel32.GetFileTime', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.getfiletype':( 'int', None, 'stdcall', 'kernel32.GetFileType', (('int', None),) ),
    'kernel32.getfirmwareenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.GetFirmwareEnvironmentVariableA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfirmwareenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.GetFirmwareEnvironmentVariableW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfullpathnamea':( 'int', None, 'stdcall', 'kernel32.GetFullPathNameA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getfullpathnamew':( 'int', None, 'stdcall', 'kernel32.GetFullPathNameW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.getgeoinfoa':( 'int', None, 'stdcall', 'kernel32.GetGeoInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getgeoinfow':( 'int', None, 'stdcall', 'kernel32.GetGeoInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.gethandlecontext':( 'int', None, 'stdcall', 'kernel32.GetHandleContext', (('int', None),) ),
    'kernel32.gethandleinformation':( 'int', None, 'stdcall', 'kernel32.GetHandleInformation', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getlargestconsolewindowsize':( 'int', None, 'stdcall', 'kernel32.GetLargestConsoleWindowSize', (('int', None),) ),
    'kernel32.getlinguistlangsize':( 'int', None, 'stdcall', 'kernel32.GetLinguistLangSize', (('int', None),) ),
    'kernel32.getlocaltime':( 'int', None, 'stdcall', 'kernel32.GetLocalTime', (('void *', 'ptr'),) ),
    'kernel32.getlocaleinfoa':( 'int', None, 'stdcall', 'kernel32.GetLocaleInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getlocaleinfow':( 'int', None, 'stdcall', 'kernel32.GetLocaleInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getlogicaldrivestringsa':( 'int', None, 'stdcall', 'kernel32.GetLogicalDriveStringsA', (('int', None), ('int', None)) ),
    'kernel32.getlogicaldrivestringsw':( 'int', None, 'stdcall', 'kernel32.GetLogicalDriveStringsW', (('int', None), ('int', None)) ),
    'kernel32.getlogicaldrives':( 'int', None, 'cdecl', 'kernel32.GetLogicalDrives', () ),
    'kernel32.getlogicalprocessorinformation':( 'int', None, 'stdcall', 'kernel32.GetLogicalProcessorInformation', (('int', None), ('int', None)) ),
    'kernel32.getlongpathnamea':( 'int', None, 'stdcall', 'kernel32.GetLongPathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getlongpathnamew':( 'int', None, 'stdcall', 'kernel32.GetLongPathNameW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getmailslotinfo':( 'int', None, 'stdcall', 'kernel32.GetMailslotInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulefilenamea':( 'int', None, 'stdcall', 'kernel32.GetModuleFileNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulefilenamew':( 'int', None, 'stdcall', 'kernel32.GetModuleFileNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandlea':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleA', (('int', None),) ),
    'kernel32.getmodulehandleexa':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandleexw':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandlew':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleW', (('int', None),) ),
    'kernel32.getnamedpipehandlestatea':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeHandleStateA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnamedpipehandlestatew':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeHandleStateW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnamedpipeinfo':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnativesysteminfo':( 'int', None, 'stdcall', 'kernel32.GetNativeSystemInfo', (('int', None),) ),
    'kernel32.getnextvdmcommand':( 'int', None, 'stdcall', 'kernel32.GetNextVDMCommand', (('int', None),) ),
    'kernel32.getnlssectionname':( 'int', None, 'stdcall', 'kernel32.GetNlsSectionName', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj'), ('int', None)) ),
    'kernel32.getnumaavailablememory':( 'int', None, 'stdcall', 'kernel32.GetNumaAvailableMemory', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumaavailablememorynode':( 'int', None, 'stdcall', 'kernel32.GetNumaAvailableMemoryNode', (('int', None), ('int', None)) ),
    'kernel32.getnumahighestnodenumber':( 'int', None, 'stdcall', 'kernel32.GetNumaHighestNodeNumber', (('int', None),) ),
    'kernel32.getnumanodeprocessormask':( 'int', None, 'stdcall', 'kernel32.GetNumaNodeProcessorMask', (('int', None), ('int', None)) ),
    'kernel32.getnumaprocessormap':( 'int', None, 'stdcall', 'kernel32.GetNumaProcessorMap', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumaprocessornode':( 'int', None, 'stdcall', 'kernel32.GetNumaProcessorNode', (('int', None), ('int', None)) ),
    'kernel32.getnumberformata':( 'int', None, 'stdcall', 'kernel32.GetNumberFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumberformatw':( 'int', None, 'stdcall', 'kernel32.GetNumberFormatW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getnumberofconsolefonts':( 'int', None, 'cdecl', 'kernel32.GetNumberOfConsoleFonts', () ),
    'kernel32.getnumberofconsoleinputevents':( 'int', None, 'stdcall', 'kernel32.GetNumberOfConsoleInputEvents', (('int', None), ('int', None)) ),
    'kernel32.getnumberofconsolemousebuttons':( 'int', None, 'stdcall', 'kernel32.GetNumberOfConsoleMouseButtons', (('int', None),) ),
    'kernel32.getoemcp':( 'int', None, 'cdecl', 'kernel32.GetOEMCP', () ),
    'kernel32.getoverlappedresult':( 'int', None, 'stdcall', 'kernel32.GetOverlappedResult', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getpriorityclass':( 'int', None, 'stdcall', 'kernel32.GetPriorityClass', (('int', None),) ),
    'kernel32.getprivateprofileinta':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileIntA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofileintw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileIntW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectiona':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionnamesa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionNamesA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionnamesw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionNamesW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getprivateprofilestringa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStringA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestringw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStringW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestructa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStructA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestructw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStructW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocaddress':( 'int', None, 'stdcall', 'kernel32.GetProcAddress', (('int', None), ('int', None)) ),
    'kernel32.getprocessaffinitymask':( 'int', None, 'stdcall', 'kernel32.GetProcessAffinityMask', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocessdeppolicy':( 'int', None, 'stdcall', 'kernel32.GetProcessDEPPolicy', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocesshandlecount':( 'int', None, 'stdcall', 'kernel32.GetProcessHandleCount', (('int', None), ('int', None)) ),
    'kernel32.getprocessheap':( 'int', None, 'cdecl', 'kernel32.GetProcessHeap', () ),
    'kernel32.getprocessheaps':( 'int', None, 'cdecl', 'kernel32.GetProcessHeaps', () ),
    'kernel32.getprocessid':( 'int', None, 'stdcall', 'kernel32.GetProcessId', (('int', None),) ),
    'kernel32.getprocessiocounters':( 'int', None, 'stdcall', 'kernel32.GetProcessIoCounters', (('int', None), ('int', None)) ),
    'kernel32.getprocesspriorityboost':( 'int', None, 'stdcall', 'kernel32.GetProcessPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.getprocessshutdownparameters':( 'int', None, 'stdcall', 'kernel32.GetProcessShutdownParameters', (('int', None), ('int', None)) ),
    'kernel32.getprocesstimes':( 'int', None, 'stdcall', 'kernel32.GetProcessTimes', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocessversion':( 'int', None, 'stdcall', 'kernel32.GetProcessVersion', (('int', None),) ),
    'kernel32.getprocessworkingsetsize':( 'int', None, 'stdcall', 'kernel32.GetProcessWorkingSetSize', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofileinta':( 'int', None, 'stdcall', 'kernel32.GetProfileIntA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofileintw':( 'int', None, 'stdcall', 'kernel32.GetProfileIntW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofilesectiona':( 'int', None, 'stdcall', 'kernel32.GetProfileSectionA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofilesectionw':( 'int', None, 'stdcall', 'kernel32.GetProfileSectionW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getprofilestringa':( 'int', None, 'stdcall', 'kernel32.GetProfileStringA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getprofilestringw':( 'int', None, 'stdcall', 'kernel32.GetProfileStringW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getqueuedcompletionstatus':( 'int', None, 'stdcall', 'kernel32.GetQueuedCompletionStatus', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getshortpathnamea':( 'int', None, 'stdcall', 'kernel32.GetShortPathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getshortpathnamew':( 'int', None, 'stdcall', 'kernel32.GetShortPathNameW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getstartupinfoa':( 'int', None, 'stdcall', 'kernel32.GetStartupInfoA', (('int', None),) ),
    'kernel32.getstartupinfow':( 'int', None, 'stdcall', 'kernel32.GetStartupInfoW', (('void *', 'ptr'),) ),
    'kernel32.getstdhandle':( 'int', None, 'stdcall', 'kernel32.GetStdHandle', (('int', None),) ),
    'kernel32.getstringtypea':( 'int', None, 'stdcall', 'kernel32.GetStringTypeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getstringtypeexa':( 'int', None, 'stdcall', 'kernel32.GetStringTypeExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getstringtypeexw':( 'int', None, 'stdcall', 'kernel32.GetStringTypeExW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'kernel32.getstringtypew':( 'int', None, 'stdcall', 'kernel32.GetStringTypeW', (('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getsystemdeppolicy':( 'int', None, 'cdecl', 'kernel32.GetSystemDEPPolicy', () ),
    'kernel32.getsystemdefaultlcid':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultLCID', () ),
    'kernel32.getsystemdefaultlangid':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultLangID', () ),
    'kernel32.getsystemdefaultuilanguage':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultUILanguage', () ),
    'kernel32.getsystemdirectorya':( 'int', None, 'stdcall', 'kernel32.GetSystemDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getsysteminfo':( 'int', None, 'stdcall', 'kernel32.GetSystemInfo', (('int', None),) ),
    'kernel32.getsystempowerstatus':( 'int', None, 'stdcall', 'kernel32.GetSystemPowerStatus', (('int', None),) ),
    'kernel32.getsystemregistryquota':( 'int', None, 'stdcall', 'kernel32.GetSystemRegistryQuota', (('int', None), ('int', None)) ),
    'kernel32.getsystemtime':( 'int', None, 'stdcall', 'kernel32.GetSystemTime', (('void *', 'ptr'),) ),
    'kernel32.getsystemtimeadjustment':( 'int', None, 'stdcall', 'kernel32.GetSystemTimeAdjustment', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getsystemtimeasfiletime':( 'int', None, 'stdcall', 'kernel32.GetSystemTimeAsFileTime', (('void *', 'ptr'),) ),
    'kernel32.getsystemtimes':( 'int', None, 'stdcall', 'kernel32.GetSystemTimes', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getsystemwindowsdirectorya':( 'int', None, 'stdcall', 'kernel32.GetSystemWindowsDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemwindowsdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemWindowsDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getsystemwow64directorya':( 'int', None, 'stdcall', 'kernel32.GetSystemWow64DirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemwow64directoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemWow64DirectoryW', (('int', None), ('int', None)) ),
    'kernel32.gettapeparameters':( 'int', None, 'stdcall', 'kernel32.GetTapeParameters', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.gettapeposition':( 'int', None, 'stdcall', 'kernel32.GetTapePosition', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettapestatus':( 'int', None, 'stdcall', 'kernel32.GetTapeStatus', (('int', None),) ),
    'kernel32.gettempfilenamea':( 'int', None, 'stdcall', 'kernel32.GetTempFileNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettempfilenamew':( 'int', None, 'stdcall', 'kernel32.GetTempFileNameW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.gettemppatha':( 'int', None, 'stdcall', 'kernel32.GetTempPathA', (('int', None), ('int', None)) ),
    'kernel32.gettemppathw':( 'int', None, 'stdcall', 'kernel32.GetTempPathW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getthreadcontext':( 'int', None, 'stdcall', 'kernel32.GetThreadContext', (('int', None), ('int', None)) ),
    'kernel32.getthreadiopendingflag':( 'int', None, 'stdcall', 'kernel32.GetThreadIOPendingFlag', (('int', None), ('int', None)) ),
    'kernel32.getthreadlocale':( 'int', None, 'cdecl', 'kernel32.GetThreadLocale', () ),
    'kernel32.getthreadpriority':( 'int', None, 'stdcall', 'kernel32.GetThreadPriority', (('int', None),) ),
    'kernel32.getthreadpriorityboost':( 'int', None, 'stdcall', 'kernel32.GetThreadPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.getthreadselectorentry':( 'int', None, 'stdcall', 'kernel32.GetThreadSelectorEntry', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getthreadtimes':( 'int', None, 'stdcall', 'kernel32.GetThreadTimes', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettickcount':( 'int', None, 'cdecl', 'kernel32.GetTickCount', () ),
    'kernel32.gettimeformata':( 'int', None, 'stdcall', 'kernel32.GetTimeFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettimeformatw':( 'int', None, 'stdcall', 'kernel32.GetTimeFormatW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.gettimezoneinformation':( 'int', None, 'stdcall', 'kernel32.GetTimeZoneInformation', (('void *', 'ptr'),) ),
    'kernel32.getuserdefaultlcid':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultLCID', () ),
    'kernel32.getuserdefaultlangid':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultLangID', () ),
    'kernel32.getuserdefaultuilanguage':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultUILanguage', () ),
    'kernel32.getusergeoid':( 'int', None, 'stdcall', 'kernel32.GetUserGeoID', (('int', None),) ),
    'kernel32.getvdmcurrentdirectories':( 'int', None, 'stdcall', 'kernel32.GetVDMCurrentDirectories', (('int', None), ('int', None)) ),
    'kernel32.getversion':( 'int', None, 'cdecl', 'kernel32.GetVersion', () ),
    'kernel32.getversionexa':( 'int', None, 'stdcall', 'kernel32.GetVersionExA', (('int', None),) ),
    'kernel32.getversionexw':( 'int', None, 'stdcall', 'kernel32.GetVersionExW', (('void *', 'ptr'),) ),
    'kernel32.getvolumeinformationa':( 'int', None, 'stdcall', 'kernel32.GetVolumeInformationA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumeinformationw':( 'int', None, 'stdcall', 'kernel32.GetVolumeInformationW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumenameforvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.GetVolumeNameForVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumenameforvolumemountpointw':( 'int', None, 'msfastcall', 'kernel32.GetVolumeNameForVolumeMountPointW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getvolumepathnamea':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamew':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamesforvolumenamea':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNamesForVolumeNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamesforvolumenamew':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNamesForVolumeNameW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getwindowsdirectorya':( 'int', None, 'stdcall', 'kernel32.GetWindowsDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getwindowsdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetWindowsDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getwritewatch':( 'int', None, 'stdcall', 'kernel32.GetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.globaladdatoma':( 'int', None, 'stdcall', 'kernel32.GlobalAddAtomA', (('int', None),) ),
    'kernel32.globaladdatomw':( 'int', None, 'stdcall', 'kernel32.GlobalAddAtomW', (('int', None),) ),
    'kernel32.globalalloc':( 'int', None, 'stdcall', 'kernel32.GlobalAlloc', (('int', None), ('DWORD', None)) ),
    'kernel32.globalcompact':( 'int', None, 'stdcall', 'kernel32.GlobalCompact', (('int', None),) ),
    'kernel32.globaldeleteatom':( 'int', None, 'stdcall', 'kernel32.GlobalDeleteAtom', (('int', None),) ),
    'kernel32.globalfindatoma':( 'int', None, 'stdcall', 'kernel32.GlobalFindAtomA', (('int', None),) ),
    'kernel32.globalfindatomw':( 'int', None, 'stdcall', 'kernel32.GlobalFindAtomW', (('int', None),) ),
    'kernel32.globalfix':( 'int', None, 'stdcall', 'kernel32.GlobalFix', (('int', None),) ),
    'kernel32.globalflags':( 'int', None, 'stdcall', 'kernel32.GlobalFlags', (('int', None),) ),
    'kernel32.globalfree':( 'int', None, 'stdcall', 'kernel32.GlobalFree', (('void *', 'ptr'),) ),
    'kernel32.globalgetatomnamea':( 'int', None, 'stdcall', 'kernel32.GlobalGetAtomNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.globalgetatomnamew':( 'int', None, 'stdcall', 'kernel32.GlobalGetAtomNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.globalhandle':( 'int', None, 'stdcall', 'kernel32.GlobalHandle', (('int', None),) ),
    'kernel32.globallock':( 'int', None, 'stdcall', 'kernel32.GlobalLock', (('int', None),) ),
    'kernel32.globalmemorystatus':( 'int', None, 'stdcall', 'kernel32.GlobalMemoryStatus', (('int', None),) ),
    'kernel32.globalmemorystatusex':( 'int', None, 'stdcall', 'kernel32.GlobalMemoryStatusEx', (('int', None),) ),
    'kernel32.globalrealloc':( 'int', None, 'stdcall', 'kernel32.GlobalReAlloc', (('void *', 'ptr'), ('DWORD', None), ('int', None)) ),
    'kernel32.globalsize':( 'int', None, 'stdcall', 'kernel32.GlobalSize', (('int', None),) ),
    'kernel32.globalunwire':( 'int', None, 'stdcall', 'kernel32.GlobalUnWire', (('int', None),) ),
    'kernel32.globalunfix':( 'int', None, 'stdcall', 'kernel32.GlobalUnfix', (('int', None),) ),
    'kernel32.globalunlock':( 'int', None, 'stdcall', 'kernel32.GlobalUnlock', (('int', None),) ),
    'kernel32.globalwire':( 'int', None, 'stdcall', 'kernel32.GlobalWire', (('int', None),) ),
    'kernel32.heap32first':( 'int', None, 'stdcall', 'kernel32.Heap32First', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heap32listfirst':( 'int', None, 'stdcall', 'kernel32.Heap32ListFirst', (('int', None), ('int', None)) ),
    'kernel32.heap32listnext':( 'int', None, 'stdcall', 'kernel32.Heap32ListNext', (('int', None), ('int', None)) ),
    'kernel32.heap32next':( 'int', None, 'stdcall', 'kernel32.Heap32Next', (('int', None),) ),
    'kernel32.heapcompact':( 'int', None, 'cdecl', 'kernel32.HeapCompact', () ),
    'kernel32.heapcreate':( 'int', None, 'stdcall', 'kernel32.HeapCreate', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapcreatetagsw':( 'int', None, 'cdecl', 'kernel32.HeapCreateTagsW', () ),
    'kernel32.heapdestroy':( 'int', None, 'stdcall', 'kernel32.HeapDestroy', (('int', None),) ),
    'kernel32.heapextend':( 'int', None, 'stdcall', 'kernel32.HeapExtend', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heaplock':( 'int', None, 'stdcall', 'kernel32.HeapLock', (('int', None),) ),
    'kernel32.heapqueryinformation':( 'int', None, 'stdcall', 'kernel32.HeapQueryInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapquerytagw':( 'int', None, 'cdecl', 'kernel32.HeapQueryTagW', () ),
    'kernel32.heapsetinformation':( 'int', None, 'stdcall', 'kernel32.HeapSetInformation', (('HEAP', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapsummary':( 'int', None, 'stdcall', 'kernel32.HeapSummary', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapunlock':( 'int', None, 'stdcall', 'kernel32.HeapUnlock', (('int', None),) ),
    'kernel32.heapusage':( 'int', None, 'stdcall', 'kernel32.HeapUsage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapvalidate':( 'int', None, 'stdcall', 'kernel32.HeapValidate', (('HEAP', None), ('int', None), ('int', None)) ),
    'kernel32.heapwalk':( 'int', None, 'stdcall', 'kernel32.HeapWalk', (('HEAP', None), ('int', None)) ),
    'kernel32.initatomtable':( 'int', None, 'stdcall', 'kernel32.InitAtomTable', (('int', None),) ),
    'kernel32.initializecriticalsection':( 'int', None, 'stdcall', 'kernel32.InitializeCriticalSection', (('int', None),) ),
    'kernel32.initializecriticalsectionandspincount':( 'int', None, 'stdcall', 'kernel32.InitializeCriticalSectionAndSpinCount', (('int', None), ('int', None)) ),
    'kernel32.interlockedcompareexchange':( 'int', None, 'stdcall', 'kernel32.InterlockedCompareExchange', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.interlockeddecrement':( 'int', None, 'stdcall', 'kernel32.InterlockedDecrement', (('int', None),) ),
    'kernel32.interlockedexchange':( 'int', None, 'stdcall', 'kernel32.InterlockedExchange', (('int', None), ('int', None)) ),
    'kernel32.interlockedexchangeadd':( 'int', None, 'stdcall', 'kernel32.InterlockedExchangeAdd', (('int', None), ('int', None)) ),
    'kernel32.interlockedincrement':( 'int', None, 'stdcall', 'kernel32.InterlockedIncrement', (('int', None),) ),
    'kernel32.invalidateconsoledibits':( 'int', None, 'stdcall', 'kernel32.InvalidateConsoleDIBits', (('int', None), ('int', None)) ),
    'kernel32.isbadcodeptr':( 'int', None, 'stdcall', 'kernel32.IsBadCodePtr', (('int', None),) ),
    'kernel32.isbadhugereadptr':( 'int', None, 'stdcall', 'kernel32.IsBadHugeReadPtr', (('int', None), ('int', None)) ),
    'kernel32.isbadhugewriteptr':( 'int', None, 'stdcall', 'kernel32.IsBadHugeWritePtr', (('int', None), ('int', None)) ),
    'kernel32.isbadreadptr':( 'int', None, 'stdcall', 'kernel32.IsBadReadPtr', (('int', None), ('int', None)) ),
    'kernel32.isbadstringptra':( 'int', None, 'stdcall', 'kernel32.IsBadStringPtrA', (('int', None), ('int', None)) ),
    'kernel32.isbadstringptrw':( 'int', None, 'stdcall', 'kernel32.IsBadStringPtrW', (('int', None), ('int', None)) ),
    'kernel32.isbadwriteptr':( 'int', None, 'stdcall', 'kernel32.IsBadWritePtr', (('int', None), ('int', None)) ),
    'kernel32.isdbcsleadbyte':( 'int', None, 'stdcall', 'kernel32.IsDBCSLeadByte', (('int', None),) ),
    'kernel32.isdbcsleadbyteex':( 'int', None, 'stdcall', 'kernel32.IsDBCSLeadByteEx', ( ('int', None),) ),
    'kernel32.isdebuggerpresent':( 'int', None, 'cdecl', 'kernel32.IsDebuggerPresent', () ),
    'kernel32.isprocessinjob':( 'int', None, 'stdcall', 'kernel32.IsProcessInJob', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.isprocessorfeaturepresent':( 'int', None, 'stdcall', 'kernel32.IsProcessorFeaturePresent', (('int', None),) ),
    'kernel32.issystemresumeautomatic':( 'int', None, 'stdcall', 'kernel32.IsSystemResumeAutomatic', () ),
    'kernel32.isvalidcodepage':( 'int', None, 'stdcall', 'kernel32.IsValidCodePage', (('int', None),) ),
    'kernel32.isvalidlanguagegroup':( 'int', None, 'stdcall', 'kernel32.IsValidLanguageGroup', (('int', None), ('int', None)) ),
    'kernel32.isvalidlocale':( 'int', None, 'stdcall', 'kernel32.IsValidLocale', ( ('int', None),) ),
    'kernel32.isvaliduilanguage':( 'int', None, 'stdcall', 'kernel32.IsValidUILanguage', (('int', None),) ),
    'kernel32.iswow64process':( 'int', None, 'stdcall', 'kernel32.IsWow64Process', (('int', None), ('int', None)) ),
    'kernel32.lcmapstringa':( 'int', None, 'stdcall', 'kernel32.LCMapStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lcmapstringw':( 'int', None, 'stdcall', 'kernel32.LCMapStringW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lzclose':( 'int', None, 'stdcall', 'kernel32.LZClose', (('int', None),) ),
    'kernel32.lzclosefile':( 'int', None, 'stdcall', 'kernel32.LZCloseFile', (('int', None),) ),
    'kernel32.lzcopy':( 'int', None, 'stdcall', 'kernel32.LZCopy', (('int', None), ('int', None)) ),
    'kernel32.lzcreatefilew':( 'int', None, 'stdcall', 'kernel32.LZCreateFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzdone':( 'int', None, 'cdecl', 'kernel32.LZDone', () ),
    'kernel32.lzinit':( 'int', None, 'stdcall', 'kernel32.LZInit', (('int', None),) ),
    'kernel32.lzopenfilea':( 'int', None, 'stdcall', 'kernel32.LZOpenFileA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lzopenfilew':( 'int', None, 'stdcall', 'kernel32.LZOpenFileW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzread':( 'int', None, 'stdcall', 'kernel32.LZRead', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lzseek':( 'int', None, 'stdcall', 'kernel32.LZSeek', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzstart':( 'int', None, 'cdecl', 'kernel32.LZStart', () ),
    'kernel32.loadlibrarya':( 'int', None, 'stdcall', 'kernel32.LoadLibraryA', (('int', None),) ),
    'kernel32.loadlibraryexa':( 'int', None, 'stdcall', 'kernel32.LoadLibraryExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.loadlibraryexw':( 'int', None, 'stdcall', 'kernel32.LoadLibraryExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.loadlibraryw':( 'int', None, 'stdcall', 'kernel32.LoadLibraryW', (('void *', 'ptr'),) ),
    'kernel32.loadmodule':( 'int', None, 'stdcall', 'kernel32.LoadModule', (('int', None), ('int', None)) ),
    'kernel32.loadresource':( 'int', None, 'stdcall', 'kernel32.LoadResource', (('int', None), ('int', None)) ),
    'kernel32.localalloc':( 'int', None, 'stdcall', 'kernel32.LocalAlloc', (('int', None), ('DWORD', None)) ),
    'kernel32.localcompact':( 'int', None, 'stdcall', 'kernel32.LocalCompact', (('int', None),) ),
    'kernel32.localfiletimetofiletime':( 'int', None, 'stdcall', 'kernel32.LocalFileTimeToFileTime', (('int', None), ('int', None)) ),
    'kernel32.localflags':( 'int', None, 'stdcall', 'kernel32.LocalFlags', (('int', None),) ),
    'kernel32.localfree':( 'int', None, 'stdcall', 'kernel32.LocalFree', (('void *', 'ptr'),) ),
    'kernel32.localhandle':( 'int', None, 'stdcall', 'kernel32.LocalHandle', (('int', None),) ),
    'kernel32.locallock':( 'int', None, 'stdcall', 'kernel32.LocalLock', (('int', None),) ),
    'kernel32.localrealloc':( 'int', None, 'stdcall', 'kernel32.LocalReAlloc', (('int', None), ('DWORD', None), ('int', None)) ),
    'kernel32.localshrink':( 'int', None, 'stdcall', 'kernel32.LocalShrink', (('int', None), ('int', None)) ),
    'kernel32.localsize':( 'int', None, 'stdcall', 'kernel32.LocalSize', (('int', None),) ),
    'kernel32.localunlock':( 'int', None, 'stdcall', 'kernel32.LocalUnlock', (('int', None),) ),
    'kernel32.lockfile':( 'int', None, 'stdcall', 'kernel32.LockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lockfileex':( 'int', None, 'stdcall', 'kernel32.LockFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lockresource':( 'int', None, 'stdcall', 'kernel32.LockResource', (('int', None),) ),
    'kernel32.mapuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.MapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'kernel32.MapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapviewoffile':( 'int', None, 'stdcall', 'kernel32.MapViewOfFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapviewoffileex':( 'int', None, 'stdcall', 'kernel32.MapViewOfFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.module32first':( 'int', None, 'stdcall', 'kernel32.Module32First', (('int', None), ('int', None)) ),
    'kernel32.module32firstw':( 'int', None, 'stdcall', 'kernel32.Module32FirstW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.module32next':( 'int', None, 'stdcall', 'kernel32.Module32Next', (('int', None), ('int', None)) ),
    'kernel32.module32nextw':( 'int', None, 'stdcall', 'kernel32.Module32NextW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.movefilea':( 'int', None, 'stdcall', 'kernel32.MoveFileA', (('int', None), ('int', None)) ),
    'kernel32.movefileexa':( 'int', None, 'stdcall', 'kernel32.MoveFileExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefileexw':( 'int', None, 'stdcall', 'kernel32.MoveFileExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefilew':( 'int', None, 'stdcall', 'kernel32.MoveFileW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.movefilewithprogressa':( 'int', None, 'stdcall', 'kernel32.MoveFileWithProgressA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefilewithprogressw':( 'int', None, 'stdcall', 'kernel32.MoveFileWithProgressW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.muldiv':( 'int', None, 'stdcall', 'kernel32.MulDiv', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.multibytetowidechar':( 'int', None, 'stdcall', 'kernel32.MultiByteToWideChar', ( ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'kernel32.nlsconvertintegertostring':( 'int', None, 'stdcall', 'kernel32.NlsConvertIntegerToString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.nlsgetcacheupdatecount':( 'int', None, 'cdecl', 'kernel32.NlsGetCacheUpdateCount', () ),
    'kernel32.nlsresetprocesslocale':( 'int', None, 'cdecl', 'kernel32.NlsResetProcessLocale', () ),
    'kernel32.numavirtualquerynode':( 'int', None, 'stdcall', 'kernel32.NumaVirtualQueryNode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.openconsolew':( 'int', None, 'stdcall', 'kernel32.OpenConsoleW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.opendatafile':( 'int', None, 'stdcall', 'kernel32.OpenDataFile', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.openeventa':( 'int', None, 'stdcall', 'kernel32.OpenEventA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openeventw':( 'int', None, 'stdcall', 'kernel32.OpenEventW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openfile':( 'int', None, 'stdcall', 'kernel32.OpenFile', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.openfilemappinga':( 'int', None, 'stdcall', 'kernel32.OpenFileMappingA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openfilemappingw':( 'int', None, 'stdcall', 'kernel32.OpenFileMappingW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openjobobjecta':( 'int', None, 'stdcall', 'kernel32.OpenJobObjectA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openjobobjectw':( 'int', None, 'stdcall', 'kernel32.OpenJobObjectW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openmutexa':( 'int', None, 'stdcall', 'kernel32.OpenMutexA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openmutexw':( 'int', None, 'stdcall', 'kernel32.OpenMutexW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openprocess':( 'int', None, 'stdcall', 'kernel32.OpenProcess', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openprofileusermapping':( 'int', None, 'cdecl', 'kernel32.OpenProfileUserMapping', () ),
    'kernel32.opensemaphorea':( 'int', None, 'stdcall', 'kernel32.OpenSemaphoreA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.opensemaphorew':( 'int', None, 'stdcall', 'kernel32.OpenSemaphoreW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openthread':( 'int', None, 'stdcall', 'kernel32.OpenThread', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openwaitabletimera':( 'int', None, 'stdcall', 'kernel32.OpenWaitableTimerA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openwaitabletimerw':( 'int', None, 'stdcall', 'kernel32.OpenWaitableTimerW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.outputdebugstringa':( 'int', None, 'stdcall', 'kernel32.OutputDebugStringA', (('int', None),) ),
    'kernel32.outputdebugstringw':( 'int', None, 'stdcall', 'kernel32.OutputDebugStringW', (('int', None),) ),
    'kernel32.peekconsoleinputa':( 'int', None, 'stdcall', 'kernel32.PeekConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.peekconsoleinputw':( 'int', None, 'stdcall', 'kernel32.PeekConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.peeknamedpipe':( 'int', None, 'stdcall', 'kernel32.PeekNamedPipe', (('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.postqueuedcompletionstatus':( 'int', None, 'stdcall', 'kernel32.PostQueuedCompletionStatus', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.preparetape':( 'int', None, 'stdcall', 'kernel32.PrepareTape', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.privcopyfileexw':( 'int', None, 'stdcall', 'kernel32.PrivCopyFileExW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.privmovefileidentityw':( 'int', None, 'stdcall', 'kernel32.PrivMoveFileIdentityW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.process32first':( 'int', None, 'stdcall', 'kernel32.Process32First', (('int', None), ('int', None)) ),
    'kernel32.process32firstw':( 'int', None, 'stdcall', 'kernel32.Process32FirstW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.process32next':( 'int', None, 'stdcall', 'kernel32.Process32Next', (('int', None), ('int', None)) ),
    'kernel32.process32nextw':( 'int', None, 'stdcall', 'kernel32.Process32NextW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.processidtosessionid':( 'int', None, 'stdcall', 'kernel32.ProcessIdToSessionId', (('int', None), ('int', None)) ),
    'kernel32.pulseevent':( 'int', None, 'stdcall', 'kernel32.PulseEvent', (('int', None),) ),
    'kernel32.purgecomm':( 'int', None, 'stdcall', 'kernel32.PurgeComm', (('int', None), ('int', None)) ),
    'kernel32.queryactctxw':( 'int', None, 'stdcall', 'kernel32.QueryActCtxW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.querydosdevicea':( 'int', None, 'stdcall', 'kernel32.QueryDosDeviceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.querydosdevicew':( 'int', None, 'stdcall', 'kernel32.QueryDosDeviceW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.queryinformationjobobject':( 'int', None, 'stdcall', 'kernel32.QueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.querymemoryresourcenotification':( 'int', None, 'stdcall', 'kernel32.QueryMemoryResourceNotification', (('int', None), ('int', None)) ),
    'kernel32.queryperformancecounter':( 'int', None, 'stdcall', 'kernel32.QueryPerformanceCounter', (('int', None),) ),
    'kernel32.queryperformancefrequency':( 'int', None, 'stdcall', 'kernel32.QueryPerformanceFrequency', (('int', None),) ),
    'kernel32.querywin31inifilesmappedtoregistry':( 'int', None, 'stdcall', 'kernel32.QueryWin31IniFilesMappedToRegistry', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.queueuserapc':( 'int', None, 'stdcall', 'kernel32.QueueUserAPC', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.queueuserworkitem':( 'int', None, 'stdcall', 'kernel32.QueueUserWorkItem', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.raiseexception':( 'int', None, 'stdcall', 'kernel32.RaiseException', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.readconsolea':( 'int', None, 'stdcall', 'kernel32.ReadConsoleA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputexa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputexw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsolew':( 'int', None, 'stdcall', 'kernel32.ReadConsoleW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readdirectorychangesw':( 'int', None, 'stdcall', 'kernel32.ReadDirectoryChangesW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readfile':( 'int', None, 'stdcall', 'kernel32.ReadFile', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.readfileex':( 'int', None, 'stdcall', 'kernel32.ReadFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readfilescatter':( 'int', None, 'stdcall', 'kernel32.ReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readprocessmemory':( 'int', None, 'stdcall', 'kernel32.ReadProcessMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.registerconsoleime':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleIME', (('int', None), ('int', None)) ),
    'kernel32.registerconsoleos2':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleOS2', (('int', None),) ),
    'kernel32.registerconsolevdm':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleVDM', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwaitforinputidle':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForInputIdle', (('int', None),) ),
    'kernel32.registerwaitforsingleobject':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwaitforsingleobjectex':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForSingleObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwowbasehandlers':( 'int', None, 'stdcall', 'kernel32.RegisterWowBaseHandlers', (('int', None),) ),
    'kernel32.registerwowexec':( 'int', None, 'stdcall', 'kernel32.RegisterWowExec', (('int', None),) ),
    'kernel32.releaseactctx':( 'int', None, 'cdecl', 'kernel32.ReleaseActCtx', () ),
    'kernel32.releasemutex':( 'int', None, 'stdcall', 'kernel32.ReleaseMutex', (('int', None),) ),
    'kernel32.releasesemaphore':( 'int', None, 'stdcall', 'kernel32.ReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.removedirectorya':( 'int', None, 'stdcall', 'kernel32.RemoveDirectoryA', (('int', None),) ),
    'kernel32.removedirectoryw':( 'int', None, 'stdcall', 'kernel32.RemoveDirectoryW', (('int', None),) ),
    'kernel32.removelocalalternatecomputernamea':( 'int', None, 'stdcall', 'kernel32.RemoveLocalAlternateComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.removelocalalternatecomputernamew':( 'int', None, 'stdcall', 'kernel32.RemoveLocalAlternateComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.replacefile':( 'int', None, 'stdcall', 'kernel32.ReplaceFile', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.replacefilea':( 'int', None, 'stdcall', 'kernel32.ReplaceFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.replacefilew':( 'int', None, 'stdcall', 'kernel32.ReplaceFileW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.requestdevicewakeup':( 'int', None, 'stdcall', 'kernel32.RequestDeviceWakeup', (('int', None),) ),
    'kernel32.requestwakeuplatency':( 'int', None, 'stdcall', 'kernel32.RequestWakeupLatency', (('int', None),) ),
    'kernel32.resetevent':( 'int', None, 'stdcall', 'kernel32.ResetEvent', (('int', None),) ),
    'kernel32.resetwritewatch':( 'int', None, 'stdcall', 'kernel32.ResetWriteWatch', (('int', None), ('int', None)) ),
    'kernel32.resumethread':( 'int', None, 'stdcall', 'kernel32.ResumeThread', (('int', None),) ),
    'kernel32.scrollconsolescreenbuffera':( 'int', None, 'stdcall', 'kernel32.ScrollConsoleScreenBufferA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.scrollconsolescreenbufferw':( 'int', None, 'stdcall', 'kernel32.ScrollConsoleScreenBufferW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.searchpatha':( 'int', None, 'stdcall', 'kernel32.SearchPathA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.searchpathw':( 'int', None, 'stdcall', 'kernel32.SearchPathW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.setcpglobal':( 'int', None, 'stdcall', 'kernel32.SetCPGlobal', (('int', None),) ),
    'kernel32.setcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.SetCalendarInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcalendarinfow':( 'int', None, 'stdcall', 'kernel32.SetCalendarInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'kernel32.setclienttimezoneinformation':( 'int', None, 'stdcall', 'kernel32.SetClientTimeZoneInformation', (('int', None),) ),
    'kernel32.setcompluspackageinstallstatus':( 'int', None, 'stdcall', 'kernel32.SetComPlusPackageInstallStatus', (('int', None),) ),
    'kernel32.setcommbreak':( 'int', None, 'stdcall', 'kernel32.SetCommBreak', (('int', None),) ),
    'kernel32.setcommconfig':( 'int', None, 'stdcall', 'kernel32.SetCommConfig', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcommmask':( 'int', None, 'stdcall', 'kernel32.SetCommMask', (('int', None), ('int', None)) ),
    'kernel32.setcommstate':( 'int', None, 'stdcall', 'kernel32.SetCommState', (('int', None), ('int', None)) ),
    'kernel32.setcommtimeouts':( 'int', None, 'stdcall', 'kernel32.SetCommTimeouts', (('int', None), ('int', None)) ),
    'kernel32.setcomputernamea':( 'int', None, 'stdcall', 'kernel32.SetComputerNameA', (('int', None),) ),
    'kernel32.setcomputernameexa':( 'int', None, 'stdcall', 'kernel32.SetComputerNameExA', (('int', None), ('int', None)) ),
    'kernel32.setcomputernameexw':( 'int', None, 'stdcall', 'kernel32.SetComputerNameExW', (('int', None), ('int', None)) ),
    'kernel32.setcomputernamew':( 'int', None, 'stdcall', 'kernel32.SetComputerNameW', (('int', None),) ),
    'kernel32.setconsoleactivescreenbuffer':( 'int', None, 'stdcall', 'kernel32.SetConsoleActiveScreenBuffer', (('int', None),) ),
    'kernel32.setconsolecp':( 'int', None, 'stdcall', 'kernel32.SetConsoleCP', (('int', None),) ),
    'kernel32.setconsolecommandhistorymode':( 'int', None, 'stdcall', 'kernel32.SetConsoleCommandHistoryMode', (('int', None),) ),
    'kernel32.setconsolectrlhandler':( 'int', None, 'stdcall', 'kernel32.SetConsoleCtrlHandler', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursor':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursor', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursorinfo':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorInfo', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursormode':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolecursorposition':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorPosition', (('int', None), ('int', None)) ),
    'kernel32.setconsoledisplaymode':( 'int', None, 'stdcall', 'kernel32.SetConsoleDisplayMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolefont':( 'int', None, 'stdcall', 'kernel32.SetConsoleFont', (('int', None), ('int', None)) ),
    'kernel32.setconsolehardwarestate':( 'int', None, 'stdcall', 'kernel32.SetConsoleHardwareState', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsoleicon':( 'int', None, 'stdcall', 'kernel32.SetConsoleIcon', (('int', None),) ),
    'kernel32.setconsoleinputexenamea':( 'int', None, 'stdcall', 'kernel32.SetConsoleInputExeNameA', (('int', None),) ),
    'kernel32.setconsoleinputexenamew':( 'int', None, 'stdcall', 'kernel32.SetConsoleInputExeNameW', (('int', None),) ),
    'kernel32.setconsolekeyshortcuts':( 'int', None, 'stdcall', 'kernel32.SetConsoleKeyShortcuts', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolelocaleudc':( 'int', None, 'stdcall', 'kernel32.SetConsoleLocalEUDC', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolemaximumwindowsize':( 'int', None, 'stdcall', 'kernel32.SetConsoleMaximumWindowSize', (('int', None), ('int', None)) ),
    'kernel32.setconsolemenuclose':( 'int', None, 'stdcall', 'kernel32.SetConsoleMenuClose', (('int', None),) ),
    'kernel32.setconsolemode':( 'int', None, 'stdcall', 'kernel32.SetConsoleMode', (('int', None), ('int', None)) ),
    'kernel32.setconsolenlsmode':( 'int', None, 'stdcall', 'kernel32.SetConsoleNlsMode', (('int', None), ('int', None)) ),
    'kernel32.setconsolenumberofcommandsa':( 'int', None, 'stdcall', 'kernel32.SetConsoleNumberOfCommandsA', (('int', None), ('int', None)) ),
    'kernel32.setconsolenumberofcommandsw':( 'int', None, 'stdcall', 'kernel32.SetConsoleNumberOfCommandsW', (('int', None), ('int', None)) ),
    'kernel32.setconsoleos2oemformat':( 'int', None, 'stdcall', 'kernel32.SetConsoleOS2OemFormat', (('int', None),) ),
    'kernel32.setconsoleoutputcp':( 'int', None, 'stdcall', 'kernel32.SetConsoleOutputCP', (('int', None),) ),
    'kernel32.setconsolepalette':( 'int', None, 'stdcall', 'kernel32.SetConsolePalette', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolescreenbuffersize':( 'int', None, 'stdcall', 'kernel32.SetConsoleScreenBufferSize', (('int', None), ('int', None)) ),
    'kernel32.setconsoletextattribute':( 'int', None, 'stdcall', 'kernel32.SetConsoleTextAttribute', (('int', None), ('int', None)) ),
    'kernel32.setconsoletitlea':( 'int', None, 'stdcall', 'kernel32.SetConsoleTitleA', (('int', None),) ),
    'kernel32.setconsoletitlew':( 'int', None, 'stdcall', 'kernel32.SetConsoleTitleW', (('int', None),) ),
    'kernel32.setconsolewindowinfo':( 'int', None, 'stdcall', 'kernel32.SetConsoleWindowInfo', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcurrentdirectorya':( 'int', None, 'stdcall', 'kernel32.SetCurrentDirectoryA', (('int', None),) ),
    'kernel32.setcurrentdirectoryw':( 'int', None, 'stdcall', 'kernel32.SetCurrentDirectoryW', (('int', None),) ),
    'kernel32.setdefaultcommconfiga':( 'int', None, 'stdcall', 'kernel32.SetDefaultCommConfigA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setdefaultcommconfigw':( 'int', None, 'stdcall', 'kernel32.SetDefaultCommConfigW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setdlldirectorya':( 'int', None, 'stdcall', 'kernel32.SetDllDirectoryA', (('int', None),) ),
    'kernel32.setdlldirectoryw':( 'int', None, 'stdcall', 'kernel32.SetDllDirectoryW', (('int', None),) ),
    'kernel32.setendoffile':( 'int', None, 'stdcall', 'kernel32.SetEndOfFile', (('int', None),) ),
    'kernel32.setenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.SetEnvironmentVariableA', (('int', None), ('int', None)) ),
    'kernel32.setenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.SetEnvironmentVariableW', (('int', None), ('int', None)) ),
    'kernel32.seterrormode':( 'int', None, 'stdcall', 'kernel32.SetErrorMode', (('int', None),) ),
    'kernel32.setevent':( 'int', None, 'stdcall', 'kernel32.SetEvent', (('int', None),) ),
    'kernel32.setfileapistoansi':( 'int', None, 'cdecl', 'kernel32.SetFileApisToANSI', () ),
    'kernel32.setfileapistooem':( 'int', None, 'cdecl', 'kernel32.SetFileApisToOEM', () ),
    'kernel32.setfileattributesa':( 'int', None, 'stdcall', 'kernel32.SetFileAttributesA', (('int', None), ('int', None)) ),
    'kernel32.setfileattributesw':( 'int', None, 'stdcall', 'kernel32.SetFileAttributesW', (('int', None), ('int', None)) ),
    'kernel32.setfilepointer':( 'int', None, 'stdcall', 'kernel32.SetFilePointer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setfilepointerex':( 'int', None, 'stdcall', 'kernel32.SetFilePointerEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfileshortnamea':( 'int', None, 'stdcall', 'kernel32.SetFileShortNameA', (('int', None), ('int', None)) ),
    'kernel32.setfileshortnamew':( 'int', None, 'stdcall', 'kernel32.SetFileShortNameW', (('int', None), ('int', None)) ),
    'kernel32.setfiletime':( 'int', None, 'stdcall', 'kernel32.SetFileTime', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.setfilevaliddata':( 'int', None, 'stdcall', 'kernel32.SetFileValidData', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfirmwareenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.SetFirmwareEnvironmentVariableA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfirmwareenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.SetFirmwareEnvironmentVariableW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.sethandlecontext':( 'int', None, 'stdcall', 'kernel32.SetHandleContext', (('int', None), ('int', None)) ),
    'kernel32.sethandlecount':( 'int', None, 'stdcall', 'kernel32.SetHandleCount', (('int', None),) ),
    'kernel32.sethandleinformation':( 'int', None, 'stdcall', 'kernel32.SetHandleInformation', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setinformationjobobject':( 'int', None, 'stdcall', 'kernel32.SetInformationJobObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setlastconsoleeventactive':( 'int', None, 'cdecl', 'kernel32.SetLastConsoleEventActive', () ),
    'kernel32.setlocalprimarycomputernamea':( 'int', None, 'stdcall', 'kernel32.SetLocalPrimaryComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.setlocalprimarycomputernamew':( 'int', None, 'stdcall', 'kernel32.SetLocalPrimaryComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.setlocaltime':( 'int', None, 'stdcall', 'kernel32.SetLocalTime', (('int', None),) ),
    'kernel32.setlocaleinfoa':( 'int', None, 'stdcall', 'kernel32.SetLocaleInfoA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setlocaleinfow':( 'int', None, 'stdcall', 'kernel32.SetLocaleInfoW', (('int', None), ('int', None), ('void *', 'obj')) ),
    'kernel32.setmailslotinfo':( 'int', None, 'stdcall', 'kernel32.SetMailslotInfo', (('int', None), ('int', None)) ),
    'kernel32.setmessagewaitingindicator':( 'int', None, 'stdcall', 'kernel32.SetMessageWaitingIndicator', (('int', None), ('int', None)) ),
    'kernel32.setnamedpipehandlestate':( 'int', None, 'stdcall', 'kernel32.SetNamedPipeHandleState', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.setpriorityclass':( 'int', None, 'stdcall', 'kernel32.SetPriorityClass', ( ('int', None), ('int', None)) ),
    'kernel32.setprocessaffinitymask':( 'int', None, 'stdcall', 'kernel32.SetProcessAffinityMask', (('int', None), ('int', None)) ),
    'kernel32.setprocessdeppolicy':( 'int', None, 'stdcall', 'kernel32.SetProcessDEPPolicy', (('int', None),) ),
    'kernel32.setprocesspriorityboost':( 'int', None, 'stdcall', 'kernel32.SetProcessPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.setprocessshutdownparameters':( 'int', None, 'stdcall', 'kernel32.SetProcessShutdownParameters', (('int', None), ('int', None)) ),
    'kernel32.setprocessworkingsetsize':( 'int', None, 'stdcall', 'kernel32.SetProcessWorkingSetSize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setsearchpathmode':( 'int', None, 'stdcall', 'kernel32.SetSearchPathMode', (('int', None),) ),
    'kernel32.setstdhandle':( 'int', None, 'stdcall', 'kernel32.SetStdHandle', (('int', None), ('int', None)) ),
    'kernel32.setsystempowerstate':( 'int', None, 'stdcall', 'kernel32.SetSystemPowerState', (('int', None), ('int', None)) ),
    'kernel32.setsystemtime':( 'int', None, 'stdcall', 'kernel32.SetSystemTime', (('void *', 'ptr'),) ),
    'kernel32.setsystemtimeadjustment':( 'int', None, 'stdcall', 'kernel32.SetSystemTimeAdjustment', (('int', None), ('int', None)) ),
    'kernel32.settapeparameters':( 'int', None, 'stdcall', 'kernel32.SetTapeParameters', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.settapeposition':( 'int', None, 'stdcall', 'kernel32.SetTapePosition', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.settermsrvappinstallmode':( 'int', None, 'stdcall', 'kernel32.SetTermsrvAppInstallMode', (('int', None),) ),
    'kernel32.setthreadaffinitymask':( 'int', None, 'stdcall', 'kernel32.SetThreadAffinityMask', (('int', None), ('int', None)) ),
    'kernel32.setthreadcontext':( 'int', None, 'stdcall', 'kernel32.SetThreadContext', (('int', None), ('int', None)) ),
    'kernel32.setthreadexecutionstate':( 'int', None, 'stdcall', 'kernel32.SetThreadExecutionState', (('int', None),) ),
    'kernel32.setthreadidealprocessor':( 'int', None, 'stdcall', 'kernel32.SetThreadIdealProcessor', (('int', None), ('int', None)) ),
    'kernel32.setthreadlocale':( 'int', None, 'stdcall', 'kernel32.SetThreadLocale', (('int', None),) ),
    'kernel32.setthreadpriority':( 'int', None, 'stdcall', 'kernel32.SetThreadPriority', (('int', None), ('int', None)) ),
    'kernel32.setthreadpriorityboost':( 'int', None, 'stdcall', 'kernel32.SetThreadPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.setthreaduilanguage':( 'int', None, 'stdcall', 'kernel32.SetThreadUILanguage', (('int', None),) ),
    'kernel32.settimezoneinformation':( 'int', None, 'stdcall', 'kernel32.SetTimeZoneInformation', ( ('int', None),) ),
    'kernel32.settimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.SetTimerQueueTimer', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setunhandledexceptionfilter':( 'int', None, 'stdcall', 'kernel32.SetUnhandledExceptionFilter', (('int', None),) ),
    'kernel32.setusergeoid':( 'int', None, 'stdcall', 'kernel32.SetUserGeoID', (('int', None),) ),
    'kernel32.setvdmcurrentdirectories':( 'int', None, 'stdcall', 'kernel32.SetVDMCurrentDirectories', (('int', None), ('int', None)) ),
    'kernel32.setvolumelabela':( 'int', None, 'msfastcall', 'kernel32.SetVolumeLabelA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setvolumelabelw':( 'int', None, 'msfastcall', 'kernel32.SetVolumeLabelW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setvolumemountpointa':( 'int', None, 'msfastcall', 'kernel32.SetVolumeMountPointA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setvolumemountpointw':( 'int', None, 'msfastcall', 'kernel32.SetVolumeMountPointW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setwaitabletimer':( 'int', None, 'stdcall', 'kernel32.SetWaitableTimer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setupcomm':( 'int', None, 'stdcall', 'kernel32.SetupComm', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.showconsolecursor':( 'int', None, 'stdcall', 'kernel32.ShowConsoleCursor', (('int', None), ('int', None)) ),
    'kernel32.signalobjectandwait':( 'int', None, 'stdcall', 'kernel32.SignalObjectAndWait', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.sizeofresource':( 'int', None, 'stdcall', 'kernel32.SizeofResource', (('int', None), ('int', None)) ),
    'kernel32.sleep':( 'int', None, 'stdcall', 'kernel32.Sleep', (('int', None),) ),
    'kernel32.sleepex':( 'int', None, 'stdcall', 'kernel32.SleepEx', (('int', None), ('int', None)) ),
    'kernel32.suspendthread':( 'int', None, 'stdcall', 'kernel32.SuspendThread', (('int', None),) ),
    'kernel32.switchtofiber':( 'int', None, 'cdecl', 'kernel32.SwitchToFiber', (('int', None),) ),
    'kernel32.switchtothread':( 'int', None, 'stdcall', 'kernel32.SwitchToThread', () ),
    'kernel32.systemtimetofiletime':( 'int', None, 'stdcall', 'kernel32.SystemTimeToFileTime', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.systemtimetotzspecificlocaltime':( 'int', None, 'stdcall', 'kernel32.SystemTimeToTzSpecificLocalTime', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.terminatejobobject':( 'int', None, 'stdcall', 'kernel32.TerminateJobObject', (('int', None), ('int', None)) ),
    'kernel32.terminateprocess':( 'int', None, 'stdcall', 'kernel32.TerminateProcess', (('int', None), ('int', None)) ),
    'kernel32.terminatethread':( 'int', None, 'stdcall', 'kernel32.TerminateThread', (('int', None), ('int', None)) ),
    'kernel32.termsrvappinstallmode':( 'int', None, 'cdecl', 'kernel32.TermsrvAppInstallMode', () ),
    'kernel32.thread32first':( 'int', None, 'stdcall', 'kernel32.Thread32First', (('int', None), ('int', None)) ),
    'kernel32.thread32next':( 'int', None, 'stdcall', 'kernel32.Thread32Next', (('int', None), ('int', None)) ),
    'kernel32.tlsalloc':( 'int', None, 'cdecl', 'kernel32.TlsAlloc', () ),
    'kernel32.tlsfree':( 'int', None, 'stdcall', 'kernel32.TlsFree', (('int', None),) ),
    'kernel32.tlsgetvalue':( 'int', None, 'stdcall', 'kernel32.TlsGetValue', (('int', None),) ),
    'kernel32.tlssetvalue':( 'int', None, 'stdcall', 'kernel32.TlsSetValue', (('int', None), ('int', None)) ),
    'kernel32.toolhelp32readprocessmemory':( 'int', None, 'stdcall', 'kernel32.Toolhelp32ReadProcessMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.transactnamedpipe':( 'int', None, 'stdcall', 'kernel32.TransactNamedPipe', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.transmitcommchar':( 'int', None, 'stdcall', 'kernel32.TransmitCommChar', (('int', None), ('int', None)) ),
    'kernel32.trimvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.TrimVirtualBuffer', (('int', None),) ),
    'kernel32.tzspecificlocaltimetosystemtime':( 'int', None, 'stdcall', 'kernel32.TzSpecificLocalTimeToSystemTime', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.utregister':( 'int', None, 'stdcall', 'kernel32.UTRegister', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.utunregister':( 'int', None, 'stdcall', 'kernel32.UTUnRegister', (('int', None),) ),
    'kernel32.unhandledexceptionfilter':( 'int', None, 'stdcall', 'kernel32.UnhandledExceptionFilter', (('int', None),) ),
    'kernel32.unlockfile':( 'int', None, 'stdcall', 'kernel32.UnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.unlockfileex':( 'int', None, 'stdcall', 'kernel32.UnlockFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.unmapviewoffile':( 'int', None, 'stdcall', 'kernel32.UnmapViewOfFile', (('int', None),) ),
    'kernel32.unregisterconsoleime':( 'int', None, 'cdecl', 'kernel32.UnregisterConsoleIME', () ),
    'kernel32.unregisterwait':( 'int', None, 'stdcall', 'kernel32.UnregisterWait', (('void *', 'ptr'),) ),
    'kernel32.unregisterwaitex':( 'int', None, 'stdcall', 'kernel32.UnregisterWaitEx', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.updateresourcea':( 'int', None, 'stdcall', 'kernel32.UpdateResourceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'kernel32.updateresourcew':( 'int', None, 'stdcall', 'kernel32.UpdateResourceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'kernel32.vdmconsoleoperation':( 'int', None, 'stdcall', 'kernel32.VDMConsoleOperation', (('int', None), ('int', None)) ),
    'kernel32.vdmoperationstarted':( 'int', None, 'stdcall', 'kernel32.VDMOperationStarted', (('int', None),) ),
    'kernel32.validatelctype':( 'int', None, 'stdcall', 'kernel32.ValidateLCType', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.validatelocale':( 'int', None, 'stdcall', 'kernel32.ValidateLocale', (('int', None),) ),
    'kernel32.verlanguagenamea':( 'int', None, 'stdcall', 'kernel32.VerLanguageNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.verlanguagenamew':( 'int', None, 'stdcall', 'kernel32.VerLanguageNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.verifyconsoleiohandle':( 'int', None, 'stdcall', 'kernel32.VerifyConsoleIoHandle', (('int', None),) ),
    'kernel32.verifyversioninfoa':( 'int', None, 'stdcall', 'kernel32.VerifyVersionInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.verifyversioninfow':( 'int', None, 'stdcall', 'kernel32.VerifyVersionInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualalloc':( 'int', None, 'stdcall', 'kernel32.VirtualAlloc', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualallocex':( 'int', None, 'stdcall', 'kernel32.VirtualAllocEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualbufferexceptionhandler':( 'int', None, 'stdcall', 'kernel32.VirtualBufferExceptionHandler', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualfree':( 'int', None, 'stdcall', 'kernel32.VirtualFree', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualfreeex':( 'int', None, 'stdcall', 'kernel32.VirtualFreeEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtuallock':( 'int', None, 'stdcall', 'kernel32.VirtualLock', (('int', None), ('int', None)) ),
    'kernel32.virtualprotect':( 'int', None, 'stdcall', 'kernel32.VirtualProtect', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualprotectex':( 'int', None, 'stdcall', 'kernel32.VirtualProtectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualquery':( 'int', None, 'stdcall', 'kernel32.VirtualQuery', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.virtualqueryex':( 'int', None, 'stdcall', 'kernel32.VirtualQueryEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualunlock':( 'int', None, 'stdcall', 'kernel32.VirtualUnlock', (('int', None), ('int', None)) ),
    'kernel32.wtsgetactiveconsolesessionid':( 'int', None, 'cdecl', 'kernel32.WTSGetActiveConsoleSessionId', () ),
    'kernel32.waitcommevent':( 'int', None, 'stdcall', 'kernel32.WaitCommEvent', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitfordebugevent':( 'int', None, 'stdcall', 'kernel32.WaitForDebugEvent', (('int', None), ('int', None)) ),
    'kernel32.waitformultipleobjects':( 'int', None, 'stdcall', 'kernel32.WaitForMultipleObjects', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitformultipleobjectsex':( 'int', None, 'stdcall', 'kernel32.WaitForMultipleObjectsEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitforsingleobject':( 'int', None, 'stdcall', 'kernel32.WaitForSingleObject', (('int', None), ('int', None)) ),
    'kernel32.waitforsingleobjectex':( 'int', None, 'stdcall', 'kernel32.WaitForSingleObjectEx', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitnamedpipea':( 'int', None, 'stdcall', 'kernel32.WaitNamedPipeA', ( ('int', None), ('int', None)) ),
    'kernel32.waitnamedpipew':( 'int', None, 'stdcall', 'kernel32.WaitNamedPipeW', (('int', None), ('int', None)) ),
    'kernel32.widechartomultibyte':( 'int', None, 'stdcall', 'kernel32.WideCharToMultiByte', ( ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.winexec':( 'int', None, 'stdcall', 'kernel32.WinExec', (('int', None), ('int', None)) ),
    'kernel32.writeconsolea':( 'int', None, 'stdcall', 'kernel32.WriteConsoleA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputa':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputvdma':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputVDMA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputvdmw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputVDMW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputa':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsolew':( 'int', None, 'stdcall', 'kernel32.WriteConsoleW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writefile':( 'int', None, 'stdcall', 'kernel32.WriteFile', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writefileex':( 'int', None, 'stdcall', 'kernel32.WriteFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writefilegather':( 'int', None, 'stdcall', 'kernel32.WriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilesectiona':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileSectionA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilesectionw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileSectionW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilestringa':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStringA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writeprivateprofilestringw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writeprivateprofilestructa':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStructA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilestructw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStructW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprocessmemory':( 'int', None, 'stdcall', 'kernel32.WriteProcessMemory', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprofilesectiona':( 'int', None, 'stdcall', 'kernel32.WriteProfileSectionA', (('int', None), ('int', None)) ),
    'kernel32.writeprofilesectionw':( 'int', None, 'stdcall', 'kernel32.WriteProfileSectionW', (('int', None), ('int', None)) ),
    'kernel32.writeprofilestringa':( 'int', None, 'stdcall', 'kernel32.WriteProfileStringA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprofilestringw':( 'int', None, 'stdcall', 'kernel32.WriteProfileStringW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.writetapemark':( 'int', None, 'stdcall', 'kernel32.WriteTapemark', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.zombifyactctx':( 'int', None, 'stdcall', 'kernel32.ZombifyActCtx', (('int', None),) ),
    'kernel32._hread':( 'int', None, 'stdcall', 'kernel32._hread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._hwrite':( 'int', None, 'stdcall', 'kernel32._hwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._lclose':( 'int', None, 'stdcall', 'kernel32._lclose', (('int', None),) ),
    'kernel32._lcreat':( 'int', None, 'stdcall', 'kernel32._lcreat', (('int', None), ('int', None)) ),
    'kernel32._llseek':( 'int', None, 'stdcall', 'kernel32._llseek', (('int', None), ('int', None), ('int', None)) ),
    'kernel32._lopen':( 'int', None, 'stdcall', 'kernel32._lopen', (('int', None), ('int', None)) ),
    'kernel32._lread':( 'int', None, 'stdcall', 'kernel32._lread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._lwrite':( 'int', None, 'stdcall', 'kernel32._lwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcat':( 'int', None, 'stdcall', 'kernel32.lstrcat', (('int', None), ('int', None)) ),
    'kernel32.lstrcata':( 'int', None, 'stdcall', 'kernel32.lstrcatA', (('int', None), ('int', None)) ),
    'kernel32.lstrcatw':( 'int', None, 'stdcall', 'kernel32.lstrcatW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.lstrcmp':( 'int', None, 'stdcall', 'kernel32.lstrcmp', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcmpa':( 'int', None, 'stdcall', 'kernel32.lstrcmpA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcmpw':( 'int', None, 'stdcall', 'kernel32.lstrcmpW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.lstrcmpi':( 'int', None, 'stdcall', 'kernel32.lstrcmpi', (('int', None), ('int', None)) ),
    'kernel32.lstrcmpia':( 'int', None, 'stdcall', 'kernel32.lstrcmpiA', (('int', None), ('int', None)) ),
    'kernel32.lstrcmpiw':( 'int', None, 'stdcall', 'kernel32.lstrcmpiW', (('int', None), ('int', None)) ),
    'kernel32.lstrcpy':( 'int', None, 'stdcall', 'kernel32.lstrcpy', (('int', None), ('int', None)) ),
    'kernel32.lstrcpya':( 'int', None, 'stdcall', 'kernel32.lstrcpyA', (('int', None), ('int', None)) ),
    'kernel32.lstrcpyw':( 'int', None, 'stdcall', 'kernel32.lstrcpyW', (('int', None), ('int', None)) ),
    'kernel32.lstrcpyn':( 'int', None, 'stdcall', 'kernel32.lstrcpyn', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lstrcpyna':( 'int', None, 'stdcall', 'kernel32.lstrcpynA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lstrcpynw':( 'int', None, 'stdcall', 'kernel32.lstrcpynW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lstrlen':( 'int', None, 'stdcall', 'kernel32.lstrlen', (('int', None),) ),
    'kernel32.lstrlena':( 'int', None, 'stdcall', 'kernel32.lstrlenA', (('int', None),) ),
    'kernel32.lstrlenw':( 'int', None, 'stdcall', 'kernel32.lstrlenW', (('int', None),) ),
    'kernel32.addvectoredexceptionhandler':('int', None, 'stdcall', 'ntdll.RtlAddVectoredExceptionHandler', ( ('int', None), ('int', None))),
    'kernel32.decodepointer':('int', None, 'stdcall', 'ntdll.RtlDecodePointer', (('int', None),)),
    'kernel32.decodesystempointer':('int', None, 'stdcall', 'ntdll.RtlDecodeSystemPointer', (('int', None),)),
    'kernel32.deletecriticalsection':('int', None, 'stdcall', 'ntdll.RtlDeleteCriticalSection', (('int', None),) ),
    'kernel32.encodepointer':('int', None, 'stdcall', 'ntdll.RtlEncodePointer', (('int', None),)),
    'kernel32.encodesystempointer':('int', None, 'stdcall', 'ntdll.RtlEncodeSystemPointer', (('int', None),)),
    'kernel32.entercriticalsection':('int', None, 'stdcall', 'ntdll.RtlEnterCriticalSection', (('int', None),)),
    'kernel32.getlasterror':('int', None, 'cdecl', 'ntdll.RtlGetLastWin32Error', ()),
    'kernel32.heapalloc':('int', None, 'stdcall', 'ntdll.RtlAllocateHeap', (('void *', 'ptr'), ('int', None), ('int', None))),
    'kernel32.heapfree':('int', None, 'stdcall', 'ntdll.RtlFreeHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'))),
    'kernel32.heaprealloc':('int', None, 'stdcall', 'ntdll.RtlReAllocateHeap', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None))),
    'kernel32.heapsize':('int', None, 'stdcall', 'ntdll.RtlSizeHeap', ( ('void *', 'ptr'), ('int', None), ('int', None))),
    'kernel32.initializeslisthead':('int', None, 'stdcall', 'ntdll.RtlInitializeSListHead', (('int', None),)),
    'kernel32.interlockedflushslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedFlushSList', ()),
    'kernel32.interlockedpopentryslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedPopEntrySList', ()),
    'kernel32.interlockedpushentryslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedPushEntrySList', (('int', None), ('int', None))),
    'kernel32.leavecriticalsection':('int', None, 'stdcall', 'ntdll.RtlLeaveCriticalSection', ( ('int', None),)),
    'kernel32.querydepthslist':('int', None, 'stdcall', 'ntdll.RtlQueryDepthSList', (('int', None),)),
    'kernel32.removevectoredexceptionhandler':('int', None, 'stdcall', 'ntdll.RtlRemoveVectoredExceptionHandler', ( ('int', None),)),
    'kernel32.restorelasterror':('int', None, 'stdcall', 'ntdll.RtlRestoreLastWin32Error', (('int', None),)),
    'kernel32.rtlcapturecontext':('int', None, 'stdcall', 'ntdll.RtlCaptureContext', (('void *', 'ptr'),)),
    'kernel32.rtlcapturestackbacktrace':('int', None, 'stdcall', 'ntdll.RtlCaptureStackBackTrace', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'))),
    'kernel32.rtlfillmemory':('int', None, 'stdcall', 'ntdll.RtlFillMemory', (('int', None), ('int', None), ('int', None))),
    'kernel32.rtlmovememory':('int', None, 'stdcall', 'ntdll.RtlMoveMemory', (('int', None), ('int', None), ('int', None))),
    'kernel32.rtlunwind':('int', None, 'stdcall', 'ntdll.RtlUnwind', (('int', None), ('int', None), ('int', None), ('int', None))),
    'kernel32.rtlzeromemory':('int', None, 'stdcall', 'ntdll.RtlZeroMemory', (('int', None), ('int', None))),
    'kernel32.setcriticalsectionspincount':('int', None, 'stdcall', 'ntdll.RtlSetCriticalSectionSpinCount', (('int', None), ('int', None))),
    'kernel32.setlasterror':('int', None, 'stdcall', 'ntdll.RtlSetLastWin32Error', (('int', None),)),
    'kernel32.tryentercriticalsection':('int', None, 'stdcall', 'ntdll.RtlTryEnterCriticalSection', (('int', None),)),
    'kernel32.versetconditionmask':('int', None, 'stdcall', 'ntdll.VerSetConditionMask', (('int', None), ('int', None), ('int', None), ('int', None))),

    # ADVAPI32
    'advapi32.main_entry':( 'int', None, 'stdcall', 'advapi32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.a_shafinal':( 'int', None, 'stdcall', 'advapi32.A_SHAFinal', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.a_shainit':( 'int', None, 'stdcall', 'advapi32.A_SHAInit', (('void *', 'ptr'),) ),
    'advapi32.a_shaupdate':( 'int', None, 'stdcall', 'advapi32.A_SHAUpdate', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.abortsystemshutdowna':( 'int', None, 'stdcall', 'advapi32.AbortSystemShutdownA', ( ('int', None),) ),
    'advapi32.abortsystemshutdownw':( 'int', None, 'stdcall', 'advapi32.AbortSystemShutdownW', ( ('void *', 'ptr'),) ),
    'advapi32.accesscheck':( 'int', None, 'stdcall', 'advapi32.AccessCheck', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.accesscheckandauditalarma':( 'int', None, 'stdcall', 'advapi32.AccessCheckAndAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckandauditalarmw':( 'int', None, 'stdcall', 'advapi32.AccessCheckAndAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytype':( 'int', None, 'stdcall', 'advapi32.AccessCheckByType', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytypeandauditalarma':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeAndAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytypeandauditalarmw':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeAndAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytyperesultlist':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeResultList', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytyperesultlistandauditalarma':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeResultListAndAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytyperesultlistandauditalarmbyhandlea':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeResultListAndAuditAlarmByHandleA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytyperesultlistandauditalarmbyhandlew':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeResultListAndAuditAlarmByHandleW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.accesscheckbytyperesultlistandauditalarmw':( 'int', None, 'stdcall', 'advapi32.AccessCheckByTypeResultListAndAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addaccessallowedace':( 'int', None, 'stdcall', 'advapi32.AddAccessAllowedAce', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addaccessallowedaceex':( 'int', None, 'stdcall', 'advapi32.AddAccessAllowedAceEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.addaccessallowedobjectace':( 'int', None, 'stdcall', 'advapi32.AddAccessAllowedObjectAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.addaccessdeniedace':( 'int', None, 'stdcall', 'advapi32.AddAccessDeniedAce', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addaccessdeniedaceex':( 'int', None, 'stdcall', 'advapi32.AddAccessDeniedAceEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addaccessdeniedobjectace':( 'int', None, 'stdcall', 'advapi32.AddAccessDeniedObjectAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.addace':( 'int', None, 'bfastcall', 'advapi32.AddAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addauditaccessace':( 'int', None, 'stdcall', 'advapi32.AddAuditAccessAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addauditaccessaceex':( 'int', None, 'stdcall', 'advapi32.AddAuditAccessAceEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.addauditaccessobjectace':( 'int', None, 'stdcall', 'advapi32.AddAuditAccessObjectAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.adduserstoencryptedfile':( 'int', None, 'stdcall', 'advapi32.AddUsersToEncryptedFile', (('int', None), ('int', None)) ),
    'advapi32.adjusttokengroups':( 'int', None, 'stdcall', 'advapi32.AdjustTokenGroups', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.adjusttokenprivileges':( 'int', None, 'stdcall', 'advapi32.AdjustTokenPrivileges', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.allocateandinitializesid':( 'int', None, 'stdcall', 'advapi32.AllocateAndInitializeSid', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.allocatelocallyuniqueid':( 'int', None, 'stdcall', 'advapi32.AllocateLocallyUniqueId', (('int', None),) ),
    'advapi32.areallaccessesgranted':( 'int', None, 'stdcall', 'advapi32.AreAllAccessesGranted', (('int', None), ('int', None)) ),
    'advapi32.areanyaccessesgranted':( 'int', None, 'stdcall', 'advapi32.AreAnyAccessesGranted', (('int', None), ('int', None)) ),
    'advapi32.backupeventloga':( 'int', None, 'stdcall', 'advapi32.BackupEventLogA', (('int', None), ('int', None)) ),
    'advapi32.backupeventlogw':( 'int', None, 'stdcall', 'advapi32.BackupEventLogW', (('int', None), ('int', None)) ),
    'advapi32.buildexplicitaccesswithnamea':( 'int', None, 'stdcall', 'advapi32.BuildExplicitAccessWithNameA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildexplicitaccesswithnamew':( 'int', None, 'stdcall', 'advapi32.BuildExplicitAccessWithNameW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildimpersonateexplicitaccesswithnamea':( 'int', None, 'stdcall', 'advapi32.BuildImpersonateExplicitAccessWithNameA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildimpersonateexplicitaccesswithnamew':( 'int', None, 'stdcall', 'advapi32.BuildImpersonateExplicitAccessWithNameW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildimpersonatetrusteea':( 'int', None, 'stdcall', 'advapi32.BuildImpersonateTrusteeA', (('int', None), ('int', None)) ),
    'advapi32.buildimpersonatetrusteew':( 'int', None, 'stdcall', 'advapi32.BuildImpersonateTrusteeW', (('int', None), ('int', None)) ),
    'advapi32.buildsecuritydescriptora':( 'int', None, 'stdcall', 'advapi32.BuildSecurityDescriptorA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.buildsecuritydescriptorw':( 'int', None, 'stdcall', 'advapi32.BuildSecurityDescriptorW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.buildtrusteewithnamea':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithNameA', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.buildtrusteewithnamew':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithNameW', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.buildtrusteewithobjectsandnamea':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithObjectsAndNameA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildtrusteewithobjectsandnamew':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithObjectsAndNameW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildtrusteewithobjectsandsida':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithObjectsAndSidA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildtrusteewithobjectsandsidw':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithObjectsAndSidW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.buildtrusteewithsida':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithSidA', (('int', None), ('int', None)) ),
    'advapi32.buildtrusteewithsidw':( 'int', None, 'stdcall', 'advapi32.BuildTrusteeWithSidW', (('int', None), ('int', None)) ),
    'advapi32.canceloverlappedaccess':( 'int', None, 'stdcall', 'advapi32.CancelOverlappedAccess', (('int', None),) ),
    'advapi32.changeserviceconfig2a':( 'int', None, 'stdcall', 'advapi32.ChangeServiceConfig2A', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.changeserviceconfig2w':( 'int', None, 'stdcall', 'advapi32.ChangeServiceConfig2W', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.changeserviceconfiga':( 'int', None, 'stdcall', 'advapi32.ChangeServiceConfigA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.changeserviceconfigw':( 'int', None, 'stdcall', 'advapi32.ChangeServiceConfigW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.checktokenmembership':( 'int', None, 'stdcall', 'advapi32.CheckTokenMembership', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.cleareventloga':( 'int', None, 'stdcall', 'advapi32.ClearEventLogA', (('int', None), ('int', None)) ),
    'advapi32.cleareventlogw':( 'int', None, 'stdcall', 'advapi32.ClearEventLogW', (('int', None), ('int', None)) ),
    'advapi32.closecodeauthzlevel':( 'int', None, 'stdcall', 'advapi32.CloseCodeAuthzLevel', (('int', None),) ),
    'advapi32.closeencryptedfileraw':( 'int', None, 'cdecl', 'advapi32.CloseEncryptedFileRaw', () ),
    'advapi32.closeeventlog':( 'int', None, 'stdcall', 'advapi32.CloseEventLog', (('int', None),) ),
    'advapi32.closeservicehandle':( 'int', None, 'stdcall', 'advapi32.CloseServiceHandle', (('int', None),) ),
    'advapi32.closetrace':( 'int', None, 'stdcall', 'advapi32.CloseTrace', (('int', None), ('int', None)) ),
    'advapi32.commandlinefrommsidescriptor':( 'int', None, 'stdcall', 'advapi32.CommandLineFromMsiDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.computeaccesstokenfromcodeauthzlevel':( 'int', None, 'stdcall', 'advapi32.ComputeAccessTokenFromCodeAuthzLevel', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.controlservice':( 'int', None, 'stdcall', 'advapi32.ControlService', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.controltracea':( 'int', None, 'stdcall', 'advapi32.ControlTraceA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.controltracew':( 'int', None, 'stdcall', 'advapi32.ControlTraceW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.convertaccesstosecuritydescriptora':( 'int', None, 'stdcall', 'advapi32.ConvertAccessToSecurityDescriptorA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertaccesstosecuritydescriptorw':( 'int', None, 'stdcall', 'advapi32.ConvertAccessToSecurityDescriptorW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertsdtostringsdrootdomaina':( 'int', None, 'stdcall', 'advapi32.ConvertSDToStringSDRootDomainA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertsdtostringsdrootdomainw':( 'int', None, 'stdcall', 'advapi32.ConvertSDToStringSDRootDomainW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.convertsecuritydescriptortoaccessa':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToAccessA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.convertsecuritydescriptortoaccessnameda':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToAccessNamedA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.convertsecuritydescriptortoaccessnamedw':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToAccessNamedW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertsecuritydescriptortoaccessw':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToAccessW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertsecuritydescriptortostringsecuritydescriptora':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToStringSecurityDescriptorA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertsecuritydescriptortostringsecuritydescriptorw':( 'int', None, 'stdcall', 'advapi32.ConvertSecurityDescriptorToStringSecurityDescriptorW', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.convertsidtostringsida':( 'int', None, 'stdcall', 'advapi32.ConvertSidToStringSidA', ( ('int', None), ('int', None)) ),
    'advapi32.convertsidtostringsidw':( 'int', None, 'stdcall', 'advapi32.ConvertSidToStringSidW', ( ('int', None), ('void *', 'ptr')) ),
    'advapi32.convertstringsdtosddomaina':( 'int', None, 'stdcall', 'advapi32.ConvertStringSDToSDDomainA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsdtosddomainw':( 'int', None, 'stdcall', 'advapi32.ConvertStringSDToSDDomainW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsdtosdrootdomaina':( 'int', None, 'stdcall', 'advapi32.ConvertStringSDToSDRootDomainA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsdtosdrootdomainw':( 'int', None, 'stdcall', 'advapi32.ConvertStringSDToSDRootDomainW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsecuritydescriptortosecuritydescriptora':( 'int', None, 'stdcall', 'advapi32.ConvertStringSecurityDescriptorToSecurityDescriptorA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsecuritydescriptortosecuritydescriptorw':( 'int', None, 'stdcall', 'advapi32.ConvertStringSecurityDescriptorToSecurityDescriptorW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.convertstringsidtosida':( 'int', None, 'stdcall', 'advapi32.ConvertStringSidToSidA', (('int', None), ('int', None)) ),
    'advapi32.convertstringsidtosidw':( 'int', None, 'stdcall', 'advapi32.ConvertStringSidToSidW', (('int', None), ('void *', 'ptr')) ),
    'advapi32.converttoautoinheritprivateobjectsecurity':( 'int', None, 'stdcall', 'advapi32.ConvertToAutoInheritPrivateObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.copysid':( 'int', None, 'stdcall', 'advapi32.CopySid', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.createcodeauthzlevel':( 'int', None, 'stdcall', 'advapi32.CreateCodeAuthzLevel', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createprivateobjectsecurity':( 'int', None, 'stdcall', 'advapi32.CreatePrivateObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createprivateobjectsecurityex':( 'int', None, 'stdcall', 'advapi32.CreatePrivateObjectSecurityEx', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.createprivateobjectsecuritywithmultipleinheritance':( 'int', None, 'stdcall', 'advapi32.CreatePrivateObjectSecurityWithMultipleInheritance', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createprocessasusera':( 'int', None, 'stdcall', 'advapi32.CreateProcessAsUserA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createprocessasusersecure':( 'int', None, 'cdecl', 'advapi32.CreateProcessAsUserSecure', () ),
    'advapi32.createprocessasuserw':( 'int', None, 'stdcall', 'advapi32.CreateProcessAsUserW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createprocesswithlogonw':( 'int', None, 'stdcall', 'advapi32.CreateProcessWithLogonW', (('int', None), ('int', None), ('int', None), ('int', None), ('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createrestrictedtoken':( 'int', None, 'stdcall', 'advapi32.CreateRestrictedToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.createservicea':( 'int', None, 'stdcall', 'advapi32.CreateServiceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createservicew':( 'int', None, 'stdcall', 'advapi32.CreateServiceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.createtraceinstanceid':( 'int', None, 'stdcall', 'advapi32.CreateTraceInstanceId', (('int', None), ('int', None)) ),
    'advapi32.createwellknownsid':( 'int', None, 'stdcall', 'advapi32.CreateWellKnownSid', ( ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.creddeletea':( 'int', None, 'stdcall', 'advapi32.CredDeleteA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.creddeletew':( 'int', None, 'stdcall', 'advapi32.CredDeleteW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credenumeratea':( 'int', None, 'stdcall', 'advapi32.CredEnumerateA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credenumeratew':( 'int', None, 'stdcall', 'advapi32.CredEnumerateW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credfree':( 'int', None, 'cdecl', 'advapi32.CredFree', () ),
    'advapi32.credgetsessiontypes':( 'int', None, 'stdcall', 'advapi32.CredGetSessionTypes', (('int', None), ('int', None)) ),
    'advapi32.credgettargetinfoa':( 'int', None, 'stdcall', 'advapi32.CredGetTargetInfoA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credgettargetinfow':( 'int', None, 'stdcall', 'advapi32.CredGetTargetInfoW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credismarshaledcredentiala':( 'int', None, 'stdcall', 'advapi32.CredIsMarshaledCredentialA', (('int', None),) ),
    'advapi32.credismarshaledcredentialw':( 'int', None, 'stdcall', 'advapi32.CredIsMarshaledCredentialW', (('int', None),) ),
    'advapi32.credmarshalcredentiala':( 'int', None, 'stdcall', 'advapi32.CredMarshalCredentialA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.credmarshalcredentialw':( 'int', None, 'stdcall', 'advapi32.CredMarshalCredentialW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credprofileloaded':( 'int', None, 'cdecl', 'advapi32.CredProfileLoaded', () ),
    'advapi32.credreada':( 'int', None, 'stdcall', 'advapi32.CredReadA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.credreaddomaincredentialsa':( 'int', None, 'stdcall', 'advapi32.CredReadDomainCredentialsA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credreaddomaincredentialsw':( 'int', None, 'stdcall', 'advapi32.CredReadDomainCredentialsW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credreadw':( 'int', None, 'stdcall', 'advapi32.CredReadW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.credrenamea':( 'int', None, 'stdcall', 'advapi32.CredRenameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credrenamew':( 'int', None, 'stdcall', 'advapi32.CredRenameW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.credunmarshalcredentiala':( 'int', None, 'stdcall', 'advapi32.CredUnmarshalCredentialA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.credunmarshalcredentialw':( 'int', None, 'stdcall', 'advapi32.CredUnmarshalCredentialW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.credwritea':( 'int', None, 'stdcall', 'advapi32.CredWriteA', (('int', None), ('int', None)) ),
    'advapi32.credwritedomaincredentialsa':( 'int', None, 'stdcall', 'advapi32.CredWriteDomainCredentialsA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credwritedomaincredentialsw':( 'int', None, 'stdcall', 'advapi32.CredWriteDomainCredentialsW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.credwritew':( 'int', None, 'stdcall', 'advapi32.CredWriteW', (('int', None), ('int', None)) ),
    'advapi32.credpconvertcredential':( 'int', None, 'stdcall', 'advapi32.CredpConvertCredential', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.credpconverttargetinfo':( 'int', None, 'stdcall', 'advapi32.CredpConvertTargetInfo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.credpdecodecredential':( 'int', None, 'stdcall', 'advapi32.CredpDecodeCredential', (('int', None),) ),
    'advapi32.credpencodecredential':( 'int', None, 'stdcall', 'advapi32.CredpEncodeCredential', (('int', None),) ),
    'advapi32.cryptacquirecontexta':( 'int', None, 'stdcall', 'advapi32.CryptAcquireContextA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptacquirecontextw':( 'int', None, 'stdcall', 'advapi32.CryptAcquireContextW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptcontextaddref':( 'int', None, 'stdcall', 'advapi32.CryptContextAddRef', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptcreatehash':( 'int', None, 'stdcall', 'advapi32.CryptCreateHash', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.cryptdecrypt':( 'int', None, 'stdcall', 'advapi32.CryptDecrypt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptderivekey':( 'int', None, 'stdcall', 'advapi32.CryptDeriveKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptdestroyhash':( 'int', None, 'stdcall', 'advapi32.CryptDestroyHash', (('void *', 'ptr'),) ),
    'advapi32.cryptdestroykey':( 'int', None, 'stdcall', 'advapi32.CryptDestroyKey', (('void *', 'ptr'),) ),
    'advapi32.cryptduplicatehash':( 'int', None, 'stdcall', 'advapi32.CryptDuplicateHash', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptduplicatekey':( 'int', None, 'stdcall', 'advapi32.CryptDuplicateKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptencrypt':( 'int', None, 'stdcall', 'advapi32.CryptEncrypt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptenumprovidertypesa':( 'int', None, 'stdcall', 'advapi32.CryptEnumProviderTypesA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.cryptenumprovidertypesw':( 'int', None, 'stdcall', 'advapi32.CryptEnumProviderTypesW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptenumprovidersa':( 'int', None, 'stdcall', 'advapi32.CryptEnumProvidersA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.cryptenumprovidersw':( 'int', None, 'stdcall', 'advapi32.CryptEnumProvidersW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptexportkey':( 'int', None, 'stdcall', 'advapi32.CryptExportKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgenkey':( 'int', None, 'stdcall', 'advapi32.CryptGenKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgenrandom':( 'int', None, 'stdcall', 'advapi32.CryptGenRandom', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgetdefaultprovidera':( 'int', None, 'stdcall', 'advapi32.CryptGetDefaultProviderA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.cryptgetdefaultproviderw':( 'int', None, 'stdcall', 'advapi32.CryptGetDefaultProviderW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgethashparam':( 'int', None, 'stdcall', 'advapi32.CryptGetHashParam', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.cryptgetkeyparam':( 'int', None, 'stdcall', 'advapi32.CryptGetKeyParam', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgetprovparam':( 'int', None, 'stdcall', 'advapi32.CryptGetProvParam', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptgetuserkey':( 'int', None, 'stdcall', 'advapi32.CryptGetUserKey', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.crypthashdata':( 'int', None, 'stdcall', 'advapi32.CryptHashData', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.crypthashsessionkey':( 'int', None, 'stdcall', 'advapi32.CryptHashSessionKey', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptimportkey':( 'int', None, 'stdcall', 'advapi32.CryptImportKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptreleasecontext':( 'int', None, 'stdcall', 'advapi32.CryptReleaseContext', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.cryptsethashparam':( 'int', None, 'stdcall', 'advapi32.CryptSetHashParam', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsetkeyparam':( 'int', None, 'stdcall', 'advapi32.CryptSetKeyParam', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsetprovparam':( 'int', None, 'stdcall', 'advapi32.CryptSetProvParam', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsetprovidera':( 'int', None, 'stdcall', 'advapi32.CryptSetProviderA', (('int', None), ('int', None)) ),
    'advapi32.cryptsetproviderexa':( 'int', None, 'stdcall', 'advapi32.CryptSetProviderExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsetproviderexw':( 'int', None, 'stdcall', 'advapi32.CryptSetProviderExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsetproviderw':( 'int', None, 'stdcall', 'advapi32.CryptSetProviderW', (('int', None), ('int', None)) ),
    'advapi32.cryptsignhasha':( 'int', None, 'stdcall', 'advapi32.CryptSignHashA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptsignhashw':( 'int', None, 'stdcall', 'advapi32.CryptSignHashW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptverifysignaturea':( 'int', None, 'stdcall', 'advapi32.CryptVerifySignatureA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.cryptverifysignaturew':( 'int', None, 'stdcall', 'advapi32.CryptVerifySignatureW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.decryptfilea':( 'int', None, 'stdcall', 'advapi32.DecryptFileA', (('int', None), ('int', None)) ),
    'advapi32.decryptfilew':( 'int', None, 'stdcall', 'advapi32.DecryptFileW', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.deleteace':( 'int', None, 'bfastcall', 'advapi32.DeleteAce', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.deleteservice':( 'int', None, 'stdcall', 'advapi32.DeleteService', (('int', None),) ),
    'advapi32.deregistereventsource':( 'int', None, 'stdcall', 'advapi32.DeregisterEventSource', (('int', None),) ),
    'advapi32.destroyprivateobjectsecurity':( 'int', None, 'stdcall', 'advapi32.DestroyPrivateObjectSecurity', (('void *', 'ptr'),) ),
    'advapi32.duplicateencryptioninfofile':( 'int', None, 'stdcall', 'advapi32.DuplicateEncryptionInfoFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.duplicatetoken':( 'int', None, 'stdcall', 'advapi32.DuplicateToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.duplicatetokenex':( 'int', None, 'stdcall', 'advapi32.DuplicateTokenEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.elfbackupeventlogfilea':( 'int', None, 'stdcall', 'advapi32.ElfBackupEventLogFileA', (('int', None), ('int', None)) ),
    'advapi32.elfbackupeventlogfilew':( 'int', None, 'stdcall', 'advapi32.ElfBackupEventLogFileW', (('int', None), ('void *', 'ptr')) ),
    'advapi32.elfchangenotify':( 'int', None, 'stdcall', 'advapi32.ElfChangeNotify', (('int', None), ('int', None)) ),
    'advapi32.elfcleareventlogfilea':( 'int', None, 'stdcall', 'advapi32.ElfClearEventLogFileA', (('int', None), ('int', None)) ),
    'advapi32.elfcleareventlogfilew':( 'int', None, 'stdcall', 'advapi32.ElfClearEventLogFileW', (('int', None), ('void *', 'ptr')) ),
    'advapi32.elfcloseeventlog':( 'int', None, 'stdcall', 'advapi32.ElfCloseEventLog', (('int', None),) ),
    'advapi32.elfderegistereventsource':( 'int', None, 'stdcall', 'advapi32.ElfDeregisterEventSource', (('int', None),) ),
    'advapi32.elfflusheventlog':( 'int', None, 'stdcall', 'advapi32.ElfFlushEventLog', (('int', None),) ),
    'advapi32.elfnumberofrecords':( 'int', None, 'stdcall', 'advapi32.ElfNumberOfRecords', (('int', None), ('int', None)) ),
    'advapi32.elfoldestrecord':( 'int', None, 'stdcall', 'advapi32.ElfOldestRecord', (('int', None), ('int', None)) ),
    'advapi32.elfopenbackupeventloga':( 'int', None, 'stdcall', 'advapi32.ElfOpenBackupEventLogA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.elfopenbackupeventlogw':( 'int', None, 'stdcall', 'advapi32.ElfOpenBackupEventLogW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.elfopeneventloga':( 'int', None, 'stdcall', 'advapi32.ElfOpenEventLogA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.elfopeneventlogw':( 'int', None, 'stdcall', 'advapi32.ElfOpenEventLogW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.elfreadeventloga':( 'int', None, 'stdcall', 'advapi32.ElfReadEventLogA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.elfreadeventlogw':( 'int', None, 'stdcall', 'advapi32.ElfReadEventLogW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.elfregistereventsourcea':( 'int', None, 'stdcall', 'advapi32.ElfRegisterEventSourceA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.elfregistereventsourcew':( 'int', None, 'stdcall', 'advapi32.ElfRegisterEventSourceW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.elfreporteventa':( 'int', None, 'stdcall', 'advapi32.ElfReportEventA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.elfreporteventw':( 'int', None, 'stdcall', 'advapi32.ElfReportEventW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enabletrace':( 'int', None, 'stdcall', 'advapi32.EnableTrace', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.encryptfilea':( 'int', None, 'stdcall', 'advapi32.EncryptFileA', (('int', None),) ),
    'advapi32.encryptfilew':( 'int', None, 'stdcall', 'advapi32.EncryptFileW', (('void *', 'ptr'),) ),
    'advapi32.encryptedfilekeyinfo':( 'int', None, 'stdcall', 'advapi32.EncryptedFileKeyInfo', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.encryptiondisable':( 'int', None, 'stdcall', 'advapi32.EncryptionDisable', (('int', None), ('int', None)) ),
    'advapi32.enumdependentservicesa':( 'int', None, 'stdcall', 'advapi32.EnumDependentServicesA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumdependentservicesw':( 'int', None, 'stdcall', 'advapi32.EnumDependentServicesW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumservicegroupw':( 'int', None, 'stdcall', 'advapi32.EnumServiceGroupW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumservicesstatusa':( 'int', None, 'stdcall', 'advapi32.EnumServicesStatusA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumservicesstatusexa':( 'int', None, 'stdcall', 'advapi32.EnumServicesStatusExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumservicesstatusexw':( 'int', None, 'stdcall', 'advapi32.EnumServicesStatusExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.enumservicesstatusw':( 'int', None, 'stdcall', 'advapi32.EnumServicesStatusW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.enumeratetraceguids':( 'int', None, 'stdcall', 'advapi32.EnumerateTraceGuids', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.equaldomainsid':( 'int', None, 'stdcall', 'advapi32.EqualDomainSid', ( ('int', None), ('int', None), ('int', None)) ),
    'advapi32.equalprefixsid':( 'int', None, 'stdcall', 'advapi32.EqualPrefixSid', (('int', None), ('int', None)) ),
    'advapi32.equalsid':( 'int', None, 'stdcall', 'advapi32.EqualSid', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.fileencryptionstatusa':( 'int', None, 'stdcall', 'advapi32.FileEncryptionStatusA', (('int', None), ('int', None)) ),
    'advapi32.fileencryptionstatusw':( 'int', None, 'stdcall', 'advapi32.FileEncryptionStatusW', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.findfirstfreeace':( 'int', None, 'stdcall', 'advapi32.FindFirstFreeAce', (('int', None), ('int', None)) ),
    'advapi32.flushtracea':( 'int', None, 'stdcall', 'advapi32.FlushTraceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.flushtracew':( 'int', None, 'stdcall', 'advapi32.FlushTraceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.freeencryptedfilekeyinfo':( 'int', None, 'stdcall', 'advapi32.FreeEncryptedFileKeyInfo', (('int', None),) ),
    'advapi32.freeencryptioncertificatehashlist':( 'int', None, 'stdcall', 'advapi32.FreeEncryptionCertificateHashList', (('int', None),) ),
    'advapi32.freeinheritedfromarray':( 'int', None, 'stdcall', 'advapi32.FreeInheritedFromArray', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.freesid':( 'int', None, 'cdecl', 'advapi32.FreeSid', () ),
    'advapi32.getaccesspermissionsforobjecta':( 'int', None, 'stdcall', 'advapi32.GetAccessPermissionsForObjectA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getaccesspermissionsforobjectw':( 'int', None, 'stdcall', 'advapi32.GetAccessPermissionsForObjectW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getace':( 'int', None, 'stdcall', 'advapi32.GetAce', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.getaclinformation':( 'int', None, 'bfastcall', 'advapi32.GetAclInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getauditedpermissionsfromacla':( 'int', None, 'stdcall', 'advapi32.GetAuditedPermissionsFromAclA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getauditedpermissionsfromaclw':( 'int', None, 'stdcall', 'advapi32.GetAuditedPermissionsFromAclW', ( ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.getcurrenthwprofilea':( 'int', None, 'stdcall', 'advapi32.GetCurrentHwProfileA', (('int', None),) ),
    'advapi32.getcurrenthwprofilew':( 'int', None, 'stdcall', 'advapi32.GetCurrentHwProfileW', (('void *', 'ptr'),) ),
    'advapi32.geteffectiverightsfromacla':( 'int', None, 'stdcall', 'advapi32.GetEffectiveRightsFromAclA', ( ('int', None), ('int', None), ('int', None)) ),
    'advapi32.geteffectiverightsfromaclw':( 'int', None, 'stdcall', 'advapi32.GetEffectiveRightsFromAclW', ( ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.geteventloginformation':( 'int', None, 'stdcall', 'advapi32.GetEventLogInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getexplicitentriesfromacla':( 'int', None, 'stdcall', 'advapi32.GetExplicitEntriesFromAclA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.getexplicitentriesfromaclw':( 'int', None, 'stdcall', 'advapi32.GetExplicitEntriesFromAclW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getfilesecuritya':( 'int', None, 'stdcall', 'advapi32.GetFileSecurityA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getfilesecurityw':( 'int', None, 'stdcall', 'advapi32.GetFileSecurityW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getinformationcodeauthzlevelw':( 'int', None, 'stdcall', 'advapi32.GetInformationCodeAuthzLevelW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.getinformationcodeauthzpolicyw':( 'int', None, 'stdcall', 'advapi32.GetInformationCodeAuthzPolicyW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getinheritancesourcea':( 'int', None, 'stdcall', 'advapi32.GetInheritanceSourceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getinheritancesourcew':( 'int', None, 'stdcall', 'advapi32.GetInheritanceSourceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getkernelobjectsecurity':( 'int', None, 'stdcall', 'advapi32.GetKernelObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getlengthsid':( 'int', None, 'cdecl', 'advapi32.GetLengthSid', () ),
    'advapi32.getlocalmanagedapplicationdata':( 'int', None, 'stdcall', 'advapi32.GetLocalManagedApplicationData', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.getlocalmanagedapplications':( 'int', None, 'stdcall', 'advapi32.GetLocalManagedApplications', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.getmanagedapplicationcategories':( 'int', None, 'stdcall', 'advapi32.GetManagedApplicationCategories', (('int', None), ('int', None)) ),
    'advapi32.getmanagedapplications':( 'int', None, 'stdcall', 'advapi32.GetManagedApplications', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getmultipletrusteea':( 'int', None, 'stdcall', 'advapi32.GetMultipleTrusteeA', (('int', None),) ),
    'advapi32.getmultipletrusteeoperationa':( 'int', None, 'stdcall', 'advapi32.GetMultipleTrusteeOperationA', (('int', None),) ),
    'advapi32.getmultipletrusteeoperationw':( 'int', None, 'stdcall', 'advapi32.GetMultipleTrusteeOperationW', (('int', None),) ),
    'advapi32.getmultipletrusteew':( 'int', None, 'stdcall', 'advapi32.GetMultipleTrusteeW', (('int', None),) ),
    'advapi32.getnamedsecurityinfoa':( 'int', None, 'stdcall', 'advapi32.GetNamedSecurityInfoA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getnamedsecurityinfoexa':( 'int', None, 'stdcall', 'advapi32.GetNamedSecurityInfoExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getnamedsecurityinfoexw':( 'int', None, 'stdcall', 'advapi32.GetNamedSecurityInfoExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.getnamedsecurityinfow':( 'int', None, 'stdcall', 'advapi32.GetNamedSecurityInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getnumberofeventlogrecords':( 'int', None, 'stdcall', 'advapi32.GetNumberOfEventLogRecords', (('int', None), ('int', None)) ),
    'advapi32.getoldesteventlogrecord':( 'int', None, 'stdcall', 'advapi32.GetOldestEventLogRecord', (('int', None), ('int', None)) ),
    'advapi32.getoverlappedaccessresults':( 'int', None, 'stdcall', 'advapi32.GetOverlappedAccessResults', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.getprivateobjectsecurity':( 'int', None, 'stdcall', 'advapi32.GetPrivateObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getsecuritydescriptorcontrol':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorControl', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.getsecuritydescriptordacl':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorDacl', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getsecuritydescriptorgroup':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorGroup', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getsecuritydescriptorlength':( 'int', None, 'cdecl', 'advapi32.GetSecurityDescriptorLength', () ),
    'advapi32.getsecuritydescriptorowner':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorOwner', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'advapi32.getsecuritydescriptorsacl':( 'int', None, 'stdcall', 'advapi32.GetSecurityDescriptorSacl', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getsecurityinfo':( 'int', None, 'stdcall', 'advapi32.GetSecurityInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getsecurityinfoexa':( 'int', None, 'stdcall', 'advapi32.GetSecurityInfoExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getsecurityinfoexw':( 'int', None, 'stdcall', 'advapi32.GetSecurityInfoExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getservicedisplaynamea':( 'int', None, 'stdcall', 'advapi32.GetServiceDisplayNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getservicedisplaynamew':( 'int', None, 'stdcall', 'advapi32.GetServiceDisplayNameW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getservicekeynamea':( 'int', None, 'stdcall', 'advapi32.GetServiceKeyNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getservicekeynamew':( 'int', None, 'stdcall', 'advapi32.GetServiceKeyNameW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.getsididentifierauthority':( 'int', None, 'cdecl', 'advapi32.GetSidIdentifierAuthority', () ),
    'advapi32.getsidlengthrequired':( 'int', None, 'stdcall', 'advapi32.GetSidLengthRequired', (('int', None),) ),
    'advapi32.getsidsubauthority':( 'int', None, 'cdecl', 'advapi32.GetSidSubAuthority', () ),
    'advapi32.getsidsubauthoritycount':( 'int', None, 'cdecl', 'advapi32.GetSidSubAuthorityCount', () ),
    'advapi32.gettokeninformation':( 'int', None, 'stdcall', 'advapi32.GetTokenInformation', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.gettraceenableflags':( 'int', None, 'stdcall', 'advapi32.GetTraceEnableFlags', (('int', None), ('int', None)) ),
    'advapi32.gettraceenablelevel':( 'int', None, 'stdcall', 'advapi32.GetTraceEnableLevel', (('int', None), ('int', None)) ),
    'advapi32.gettraceloggerhandle':( 'int', None, 'stdcall', 'advapi32.GetTraceLoggerHandle', (('int', None),) ),
    'advapi32.gettrusteeforma':( 'int', None, 'stdcall', 'advapi32.GetTrusteeFormA', (('int', None),) ),
    'advapi32.gettrusteeformw':( 'int', None, 'stdcall', 'advapi32.GetTrusteeFormW', (('int', None),) ),
    'advapi32.gettrusteenamea':( 'int', None, 'stdcall', 'advapi32.GetTrusteeNameA', (('int', None),) ),
    'advapi32.gettrusteenamew':( 'int', None, 'stdcall', 'advapi32.GetTrusteeNameW', (('int', None),) ),
    'advapi32.gettrusteetypea':( 'int', None, 'stdcall', 'advapi32.GetTrusteeTypeA', (('int', None),) ),
    'advapi32.gettrusteetypew':( 'int', None, 'stdcall', 'advapi32.GetTrusteeTypeW', (('int', None),) ),
    'advapi32.getusernamea':( 'int', None, 'stdcall', 'advapi32.GetUserNameA', (('int', None), ('int', None)) ),
    'advapi32.getusernamew':( 'int', None, 'stdcall', 'advapi32.GetUserNameW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.getwindowsaccountdomainsid':( 'int', None, 'stdcall', 'advapi32.GetWindowsAccountDomainSid', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.i_scgetcurrentgroupstatew':( 'int', None, 'stdcall', 'advapi32.I_ScGetCurrentGroupStateW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.i_scissecurityprocess':( 'int', None, 'cdecl', 'advapi32.I_ScIsSecurityProcess', () ),
    'advapi32.i_scpnpgetservicename':( 'int', None, 'stdcall', 'advapi32.I_ScPnPGetServiceName', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.i_scsendtsmessage':( 'int', None, 'stdcall', 'advapi32.I_ScSendTSMessage', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.i_scsetservicebitsa':( 'int', None, 'stdcall', 'advapi32.I_ScSetServiceBitsA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.i_scsetservicebitsw':( 'int', None, 'stdcall', 'advapi32.I_ScSetServiceBitsW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.identifycodeauthzlevelw':( 'int', None, 'stdcall', 'advapi32.IdentifyCodeAuthzLevelW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.impersonateanonymoustoken':( 'int', None, 'stdcall', 'advapi32.ImpersonateAnonymousToken', (('int', None),) ),
    'advapi32.impersonateloggedonuser':( 'int', None, 'stdcall', 'advapi32.ImpersonateLoggedOnUser', (('int', None),) ),
    'advapi32.impersonatenamedpipeclient':( 'int', None, 'stdcall', 'advapi32.ImpersonateNamedPipeClient', (('int', None),) ),
    'advapi32.impersonateself':( 'int', None, 'stdcall', 'advapi32.ImpersonateSelf', (('int', None),) ),
    'advapi32.initializeacl':( 'int', None, 'stdcall', 'advapi32.InitializeAcl', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.initializesecuritydescriptor':( 'int', None, 'stdcall', 'advapi32.InitializeSecurityDescriptor', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.initializesid':( 'int', None, 'stdcall', 'advapi32.InitializeSid', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.initiatesystemshutdowna':( 'int', None, 'stdcall', 'advapi32.InitiateSystemShutdownA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.initiatesystemshutdownexa':( 'int', None, 'stdcall', 'advapi32.InitiateSystemShutdownExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.initiatesystemshutdownexw':( 'int', None, 'stdcall', 'advapi32.InitiateSystemShutdownExW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.initiatesystemshutdownw':( 'int', None, 'stdcall', 'advapi32.InitiateSystemShutdownW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.installapplication':( 'int', None, 'stdcall', 'advapi32.InstallApplication', (('int', None),) ),
    'advapi32.istextunicode':( 'int', None, 'stdcall', 'advapi32.IsTextUnicode', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.istokenrestricted':( 'int', None, 'stdcall', 'advapi32.IsTokenRestricted', ( ('int', None),) ),
    'advapi32.istokenuntrusted':( 'int', None, 'stdcall', 'advapi32.IsTokenUntrusted', (('int', None),) ),
    'advapi32.isvalidacl':( 'int', None, 'stdcall', 'advapi32.IsValidAcl', (('int', None),) ),
    'advapi32.isvalidsecuritydescriptor':( 'int', None, 'stdcall', 'advapi32.IsValidSecurityDescriptor', (('int', None),) ),
    'advapi32.isvalidsid':( 'int', None, 'stdcall', 'advapi32.IsValidSid', (('int', None),) ),
    'advapi32.iswellknownsid':( 'int', None, 'stdcall', 'advapi32.IsWellKnownSid', (('int', None), ('int', None)) ),
    'advapi32.lockservicedatabase':( 'int', None, 'stdcall', 'advapi32.LockServiceDatabase', (('int', None),) ),
    'advapi32.logonusera':( 'int', None, 'stdcall', 'advapi32.LogonUserA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.logonuserexa':( 'int', None, 'stdcall', 'advapi32.LogonUserExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.logonuserexexw':( 'int', None, 'stdcall', 'advapi32.LogonUserExExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.logonuserexw':( 'int', None, 'stdcall', 'advapi32.LogonUserExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.logonuserw':( 'int', None, 'stdcall', 'advapi32.LogonUserW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupaccountnamea':( 'int', None, 'stdcall', 'advapi32.LookupAccountNameA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupaccountnamew':( 'int', None, 'stdcall', 'advapi32.LookupAccountNameW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupaccountsida':( 'int', None, 'stdcall', 'advapi32.LookupAccountSidA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.lookupaccountsidw':( 'int', None, 'stdcall', 'advapi32.LookupAccountSidW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.lookupprivilegedisplaynamea':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeDisplayNameA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupprivilegedisplaynamew':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeDisplayNameW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupprivilegenamea':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupprivilegenamew':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeNameW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupprivilegevaluea':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeValueA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupprivilegevaluew':( 'int', None, 'stdcall', 'advapi32.LookupPrivilegeValueW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupsecuritydescriptorpartsa':( 'int', None, 'stdcall', 'advapi32.LookupSecurityDescriptorPartsA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lookupsecuritydescriptorpartsw':( 'int', None, 'stdcall', 'advapi32.LookupSecurityDescriptorPartsW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaaddaccountrights':( 'int', None, 'stdcall', 'advapi32.LsaAddAccountRights', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsaaddprivilegestoaccount':( 'int', None, 'stdcall', 'advapi32.LsaAddPrivilegesToAccount', (('int', None), ('int', None)) ),
    'advapi32.lsaclearauditlog':( 'int', None, 'stdcall', 'advapi32.LsaClearAuditLog', (('int', None),) ),
    'advapi32.lsaclose':( 'int', None, 'stdcall', 'advapi32.LsaClose', (('int', None),) ),
    'advapi32.lsacreateaccount':( 'int', None, 'stdcall', 'advapi32.LsaCreateAccount', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsacreatesecret':( 'int', None, 'stdcall', 'advapi32.LsaCreateSecret', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsacreatetrusteddomain':( 'int', None, 'stdcall', 'advapi32.LsaCreateTrustedDomain', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsacreatetrusteddomainex':( 'int', None, 'stdcall', 'advapi32.LsaCreateTrustedDomainEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsadelete':( 'int', None, 'stdcall', 'advapi32.LsaDelete', (('int', None),) ),
    'advapi32.lsadeletetrusteddomain':( 'int', None, 'stdcall', 'advapi32.LsaDeleteTrustedDomain', (('int', None), ('int', None)) ),
    'advapi32.lsaenumerateaccountrights':( 'int', None, 'stdcall', 'advapi32.LsaEnumerateAccountRights', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaenumerateaccounts':( 'int', None, 'stdcall', 'advapi32.LsaEnumerateAccounts', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaenumerateaccountswithuserright':( 'int', None, 'stdcall', 'advapi32.LsaEnumerateAccountsWithUserRight', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.lsaenumerateprivileges':( 'int', None, 'stdcall', 'advapi32.LsaEnumeratePrivileges', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaenumerateprivilegesofaccount':( 'int', None, 'stdcall', 'advapi32.LsaEnumeratePrivilegesOfAccount', (('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaenumeratetrusteddomains':( 'int', None, 'stdcall', 'advapi32.LsaEnumerateTrustedDomains', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaenumeratetrusteddomainsex':( 'int', None, 'stdcall', 'advapi32.LsaEnumerateTrustedDomainsEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsafreememory':( 'int', None, 'stdcall', 'advapi32.LsaFreeMemory', (('int', None),) ),
    'advapi32.lsagetquotasforaccount':( 'int', None, 'stdcall', 'advapi32.LsaGetQuotasForAccount', (('int', None), ('int', None)) ),
    'advapi32.lsagetremoteusername':( 'int', None, 'stdcall', 'advapi32.LsaGetRemoteUserName', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsagetsystemaccessaccount':( 'int', None, 'stdcall', 'advapi32.LsaGetSystemAccessAccount', (('int', None), ('void *', 'ptr')) ),
    'advapi32.lsagetusername':( 'int', None, 'stdcall', 'advapi32.LsaGetUserName', (('int', None), ('int', None)) ),
    'advapi32.lsaiclookupnames':( 'int', None, 'stdcall', 'advapi32.LsaICLookupNames', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsaiclookupnameswithcreds':( 'int', None, 'stdcall', 'advapi32.LsaICLookupNamesWithCreds', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaiclookupsids':( 'int', None, 'stdcall', 'advapi32.LsaICLookupSids', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsaiclookupsidswithcreds':( 'int', None, 'stdcall', 'advapi32.LsaICLookupSidsWithCreds', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsalookupnames':( 'int', None, 'stdcall', 'advapi32.LsaLookupNames', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsalookupnames2':( 'int', None, 'stdcall', 'advapi32.LsaLookupNames2', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.lsalookupprivilegedisplayname':( 'int', None, 'stdcall', 'advapi32.LsaLookupPrivilegeDisplayName', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsalookupprivilegename':( 'int', None, 'stdcall', 'advapi32.LsaLookupPrivilegeName', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsalookupprivilegevalue':( 'int', None, 'stdcall', 'advapi32.LsaLookupPrivilegeValue', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.lsalookupsids':( 'int', None, 'stdcall', 'advapi32.LsaLookupSids', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsantstatustowinerror':( 'int', None, 'cdecl', 'advapi32.LsaNtStatusToWinError', () ),
    'advapi32.lsaopenaccount':( 'int', None, 'stdcall', 'advapi32.LsaOpenAccount', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaopenpolicy':( 'int', None, 'stdcall', 'advapi32.LsaOpenPolicy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaopenpolicysce':( 'int', None, 'stdcall', 'advapi32.LsaOpenPolicySce', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaopensecret':( 'int', None, 'stdcall', 'advapi32.LsaOpenSecret', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaopentrusteddomain':( 'int', None, 'stdcall', 'advapi32.LsaOpenTrustedDomain', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaopentrusteddomainbyname':( 'int', None, 'stdcall', 'advapi32.LsaOpenTrustedDomainByName', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaquerydomaininformationpolicy':( 'int', None, 'stdcall', 'advapi32.LsaQueryDomainInformationPolicy', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaqueryforesttrustinformation':( 'int', None, 'stdcall', 'advapi32.LsaQueryForestTrustInformation', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaqueryinfotrusteddomain':( 'int', None, 'stdcall', 'advapi32.LsaQueryInfoTrustedDomain', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaqueryinformationpolicy':( 'int', None, 'stdcall', 'advapi32.LsaQueryInformationPolicy', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.lsaquerysecret':( 'int', None, 'stdcall', 'advapi32.LsaQuerySecret', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsaquerysecurityobject':( 'int', None, 'stdcall', 'advapi32.LsaQuerySecurityObject', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaquerytrusteddomaininfo':( 'int', None, 'stdcall', 'advapi32.LsaQueryTrustedDomainInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaquerytrusteddomaininfobyname':( 'int', None, 'stdcall', 'advapi32.LsaQueryTrustedDomainInfoByName', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaremoveaccountrights':( 'int', None, 'stdcall', 'advapi32.LsaRemoveAccountRights', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.lsaremoveprivilegesfromaccount':( 'int', None, 'stdcall', 'advapi32.LsaRemovePrivilegesFromAccount', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsaretrieveprivatedata':( 'int', None, 'stdcall', 'advapi32.LsaRetrievePrivateData', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.lsasetdomaininformationpolicy':( 'int', None, 'stdcall', 'advapi32.LsaSetDomainInformationPolicy', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetforesttrustinformation':( 'int', None, 'stdcall', 'advapi32.LsaSetForestTrustInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetinformationpolicy':( 'int', None, 'stdcall', 'advapi32.LsaSetInformationPolicy', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetinformationtrusteddomain':( 'int', None, 'stdcall', 'advapi32.LsaSetInformationTrustedDomain', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetquotasforaccount':( 'int', None, 'stdcall', 'advapi32.LsaSetQuotasForAccount', (('int', None), ('int', None)) ),
    'advapi32.lsasetsecret':( 'int', None, 'stdcall', 'advapi32.LsaSetSecret', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetsecurityobject':( 'int', None, 'stdcall', 'advapi32.LsaSetSecurityObject', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasetsystemaccessaccount':( 'int', None, 'stdcall', 'advapi32.LsaSetSystemAccessAccount', (('int', None), ('int', None)) ),
    'advapi32.lsasettrusteddomaininfobyname':( 'int', None, 'stdcall', 'advapi32.LsaSetTrustedDomainInfoByName', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsasettrusteddomaininformation':( 'int', None, 'stdcall', 'advapi32.LsaSetTrustedDomainInformation', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.lsastoreprivatedata':( 'int', None, 'stdcall', 'advapi32.LsaStorePrivateData', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.md4final':( 'int', None, 'stdcall', 'advapi32.MD4Final', (('void *', 'ptr'),) ),
    'advapi32.md4init':( 'int', None, 'stdcall', 'advapi32.MD4Init', (('void *', 'ptr'),) ),
    'advapi32.md4update':( 'int', None, 'stdcall', 'advapi32.MD4Update', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.md5final':( 'int', None, 'stdcall', 'advapi32.MD5Final', (('void *', 'ptr'),) ),
    'advapi32.md5init':( 'int', None, 'stdcall', 'advapi32.MD5Init', (('void *', 'ptr'),) ),
    'advapi32.md5update':( 'int', None, 'stdcall', 'advapi32.MD5Update', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.mschapsrvchangepassword':( 'int', None, 'stdcall', 'advapi32.MSChapSrvChangePassword', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.mschapsrvchangepassword2':( 'int', None, 'stdcall', 'advapi32.MSChapSrvChangePassword2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.makeabsolutesd':( 'int', None, 'stdcall', 'advapi32.MakeAbsoluteSD', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.makeabsolutesd2':( 'int', None, 'stdcall', 'advapi32.MakeAbsoluteSD2', (('int', None), ('int', None)) ),
    'advapi32.makeselfrelativesd':( 'int', None, 'stdcall', 'advapi32.MakeSelfRelativeSD', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.mapgenericmask':( 'int', None, 'cdecl', 'advapi32.MapGenericMask', () ),
    'advapi32.notifybootconfigstatus':( 'int', None, 'stdcall', 'advapi32.NotifyBootConfigStatus', (('int', None),) ),
    'advapi32.notifychangeeventlog':( 'int', None, 'stdcall', 'advapi32.NotifyChangeEventLog', (('int', None), ('int', None)) ),
    'advapi32.objectcloseauditalarma':( 'int', None, 'stdcall', 'advapi32.ObjectCloseAuditAlarmA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectcloseauditalarmw':( 'int', None, 'stdcall', 'advapi32.ObjectCloseAuditAlarmW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectdeleteauditalarma':( 'int', None, 'stdcall', 'advapi32.ObjectDeleteAuditAlarmA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectdeleteauditalarmw':( 'int', None, 'stdcall', 'advapi32.ObjectDeleteAuditAlarmW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectopenauditalarma':( 'int', None, 'stdcall', 'advapi32.ObjectOpenAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectopenauditalarmw':( 'int', None, 'stdcall', 'advapi32.ObjectOpenAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectprivilegeauditalarma':( 'int', None, 'stdcall', 'advapi32.ObjectPrivilegeAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.objectprivilegeauditalarmw':( 'int', None, 'stdcall', 'advapi32.ObjectPrivilegeAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.openbackupeventloga':( 'int', None, 'stdcall', 'advapi32.OpenBackupEventLogA', (('int', None), ('int', None)) ),
    'advapi32.openbackupeventlogw':( 'int', None, 'stdcall', 'advapi32.OpenBackupEventLogW', (('int', None), ('int', None)) ),
    'advapi32.openencryptedfilerawa':( 'int', None, 'stdcall', 'advapi32.OpenEncryptedFileRawA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.openencryptedfileraww':( 'int', None, 'stdcall', 'advapi32.OpenEncryptedFileRawW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.openeventloga':( 'int', None, 'stdcall', 'advapi32.OpenEventLogA', (('int', None), ('int', None)) ),
    'advapi32.openeventlogw':( 'int', None, 'stdcall', 'advapi32.OpenEventLogW', (('int', None), ('int', None)) ),
    'advapi32.openprocesstoken':( 'int', None, 'stdcall', 'advapi32.OpenProcessToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.openscmanagera':( 'int', None, 'stdcall', 'advapi32.OpenSCManagerA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.openscmanagerw':( 'int', None, 'stdcall', 'advapi32.OpenSCManagerW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.openservicea':( 'int', None, 'stdcall', 'advapi32.OpenServiceA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.openservicew':( 'int', None, 'stdcall', 'advapi32.OpenServiceW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.openthreadtoken':( 'int', None, 'stdcall', 'advapi32.OpenThreadToken', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.opentracea':( 'int', None, 'stdcall', 'advapi32.OpenTraceA', (('int', None),) ),
    'advapi32.opentracew':( 'int', None, 'stdcall', 'advapi32.OpenTraceW', (('int', None),) ),
    'advapi32.privilegecheck':( 'int', None, 'stdcall', 'advapi32.PrivilegeCheck', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.privilegedserviceauditalarma':( 'int', None, 'stdcall', 'advapi32.PrivilegedServiceAuditAlarmA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.privilegedserviceauditalarmw':( 'int', None, 'stdcall', 'advapi32.PrivilegedServiceAuditAlarmW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.processidletasks':( 'int', None, 'cdecl', 'advapi32.ProcessIdleTasks', () ),
    'advapi32.processtrace':( 'int', None, 'stdcall', 'advapi32.ProcessTrace', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryalltracesa':( 'int', None, 'stdcall', 'advapi32.QueryAllTracesA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryalltracesw':( 'int', None, 'stdcall', 'advapi32.QueryAllTracesW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryrecoveryagentsonencryptedfile':( 'int', None, 'stdcall', 'advapi32.QueryRecoveryAgentsOnEncryptedFile', (('int', None), ('int', None)) ),
    'advapi32.queryserviceconfig2a':( 'int', None, 'stdcall', 'advapi32.QueryServiceConfig2A', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryserviceconfig2w':( 'int', None, 'stdcall', 'advapi32.QueryServiceConfig2W', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryserviceconfiga':( 'int', None, 'stdcall', 'advapi32.QueryServiceConfigA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryserviceconfigw':( 'int', None, 'stdcall', 'advapi32.QueryServiceConfigW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryservicelockstatusa':( 'int', None, 'stdcall', 'advapi32.QueryServiceLockStatusA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryservicelockstatusw':( 'int', None, 'stdcall', 'advapi32.QueryServiceLockStatusW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryserviceobjectsecurity':( 'int', None, 'stdcall', 'advapi32.QueryServiceObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.queryservicestatus':( 'int', None, 'stdcall', 'advapi32.QueryServiceStatus', (('int', None), ('void *', 'ptr')) ),
    'advapi32.queryservicestatusex':( 'int', None, 'stdcall', 'advapi32.QueryServiceStatusEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.querytracea':( 'int', None, 'stdcall', 'advapi32.QueryTraceA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.querytracew':( 'int', None, 'stdcall', 'advapi32.QueryTraceW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.queryusersonencryptedfile':( 'int', None, 'stdcall', 'advapi32.QueryUsersOnEncryptedFile', (('int', None), ('int', None)) ),
    'advapi32.querywindows31filesmigration':( 'int', None, 'stdcall', 'advapi32.QueryWindows31FilesMigration', (('int', None),) ),
    'advapi32.readencryptedfileraw':( 'int', None, 'cdecl', 'advapi32.ReadEncryptedFileRaw', () ),
    'advapi32.readeventloga':( 'int', None, 'stdcall', 'advapi32.ReadEventLogA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.readeventlogw':( 'int', None, 'stdcall', 'advapi32.ReadEventLogW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regclosekey':( 'int', None, 'stdcall', 'advapi32.RegCloseKey', (('int', None),) ),
    'advapi32.regconnectregistrya':( 'int', None, 'stdcall', 'advapi32.RegConnectRegistryA', ( ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regconnectregistryw':( 'int', None, 'stdcall', 'advapi32.RegConnectRegistryW', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.regcreatekeya':( 'int', None, 'stdcall', 'advapi32.RegCreateKeyA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.regcreatekeyexa':( 'int', None, 'stdcall', 'advapi32.RegCreateKeyExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regcreatekeyexw':( 'int', None, 'stdcall', 'advapi32.RegCreateKeyExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regcreatekeyw':( 'int', None, 'stdcall', 'advapi32.RegCreateKeyW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regdeletekeya':( 'int', None, 'stdcall', 'advapi32.RegDeleteKeyA', (('int', None), ('int', None)) ),
    'advapi32.regdeletekeyw':( 'int', None, 'stdcall', 'advapi32.RegDeleteKeyW', (('int', None), ('int', None)) ),
    'advapi32.regdeletevaluea':( 'int', None, 'stdcall', 'advapi32.RegDeleteValueA', (('int', None), ('int', None)) ),
    'advapi32.regdeletevaluew':( 'int', None, 'stdcall', 'advapi32.RegDeleteValueW', (('int', None), ('int', None)) ),
    'advapi32.regdisablepredefinedcache':( 'int', None, 'cdecl', 'advapi32.RegDisablePredefinedCache', () ),
    'advapi32.regdisablepredefinedcacheex':( 'int', None, 'cdecl', 'advapi32.RegDisablePredefinedCacheEx', () ),
    'advapi32.regenumkeya':( 'int', None, 'stdcall', 'advapi32.RegEnumKeyA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regenumkeyexa':( 'int', None, 'stdcall', 'advapi32.RegEnumKeyExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regenumkeyexw':( 'int', None, 'stdcall', 'advapi32.RegEnumKeyExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regenumkeyw':( 'int', None, 'stdcall', 'advapi32.RegEnumKeyW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.regenumvaluea':( 'int', None, 'stdcall', 'advapi32.RegEnumValueA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regenumvaluew':( 'int', None, 'stdcall', 'advapi32.RegEnumValueW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regflushkey':( 'int', None, 'stdcall', 'advapi32.RegFlushKey', (('int', None),) ),
    'advapi32.reggetkeysecurity':( 'int', None, 'stdcall', 'advapi32.RegGetKeySecurity', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regloadkeya':( 'int', None, 'stdcall', 'advapi32.RegLoadKeyA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regloadkeyw':( 'int', None, 'stdcall', 'advapi32.RegLoadKeyW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regnotifychangekeyvalue':( 'int', None, 'stdcall', 'advapi32.RegNotifyChangeKeyValue', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regopencurrentuser':( 'int', None, 'stdcall', 'advapi32.RegOpenCurrentUser', (('int', None), ('void *', 'ptr')) ),
    'advapi32.regopenkeya':( 'int', None, 'stdcall', 'advapi32.RegOpenKeyA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.regopenkeyexa':( 'int', None, 'stdcall', 'advapi32.RegOpenKeyExA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.regopenkeyexw':( 'int', None, 'stdcall', 'advapi32.RegOpenKeyExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.regopenkeyw':( 'int', None, 'stdcall', 'advapi32.RegOpenKeyW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regopenuserclassesroot':( 'int', None, 'stdcall', 'advapi32.RegOpenUserClassesRoot', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regoverridepredefkey':( 'int', None, 'stdcall', 'advapi32.RegOverridePredefKey', (('int', None), ('int', None)) ),
    'advapi32.regqueryinfokeya':( 'int', None, 'stdcall', 'advapi32.RegQueryInfoKeyA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.regqueryinfokeyw':( 'int', None, 'stdcall', 'advapi32.RegQueryInfoKeyW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regquerymultiplevaluesa':( 'int', None, 'stdcall', 'advapi32.RegQueryMultipleValuesA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regquerymultiplevaluesw':( 'int', None, 'stdcall', 'advapi32.RegQueryMultipleValuesW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regqueryvaluea':( 'int', None, 'stdcall', 'advapi32.RegQueryValueA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regqueryvalueexa':( 'int', None, 'stdcall', 'advapi32.RegQueryValueExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regqueryvalueexw':( 'int', None, 'stdcall', 'advapi32.RegQueryValueExW', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regqueryvaluew':( 'int', None, 'stdcall', 'advapi32.RegQueryValueW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.regreplacekeya':( 'int', None, 'stdcall', 'advapi32.RegReplaceKeyA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regreplacekeyw':( 'int', None, 'stdcall', 'advapi32.RegReplaceKeyW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regrestorekeya':( 'int', None, 'stdcall', 'advapi32.RegRestoreKeyA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regrestorekeyw':( 'int', None, 'stdcall', 'advapi32.RegRestoreKeyW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsavekeya':( 'int', None, 'stdcall', 'advapi32.RegSaveKeyA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsavekeyexa':( 'int', None, 'stdcall', 'advapi32.RegSaveKeyExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsavekeyexw':( 'int', None, 'stdcall', 'advapi32.RegSaveKeyExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsavekeyw':( 'int', None, 'stdcall', 'advapi32.RegSaveKeyW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsetkeysecurity':( 'int', None, 'stdcall', 'advapi32.RegSetKeySecurity', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsetvaluea':( 'int', None, 'stdcall', 'advapi32.RegSetValueA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsetvalueexa':( 'int', None, 'stdcall', 'advapi32.RegSetValueExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.regsetvalueexw':( 'int', None, 'stdcall', 'advapi32.RegSetValueExW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.regsetvaluew':( 'int', None, 'stdcall', 'advapi32.RegSetValueW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.regunloadkeya':( 'int', None, 'stdcall', 'advapi32.RegUnLoadKeyA', (('int', None), ('int', None)) ),
    'advapi32.regunloadkeyw':( 'int', None, 'stdcall', 'advapi32.RegUnLoadKeyW', (('int', None), ('int', None)) ),
    'advapi32.registereventsourcea':( 'int', None, 'stdcall', 'advapi32.RegisterEventSourceA', (('int', None), ('int', None)) ),
    'advapi32.registereventsourcew':( 'int', None, 'stdcall', 'advapi32.RegisterEventSourceW', (('int', None), ('int', None)) ),
    'advapi32.registeridletask':( 'int', None, 'stdcall', 'advapi32.RegisterIdleTask', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.registerservicectrlhandlera':( 'int', None, 'stdcall', 'advapi32.RegisterServiceCtrlHandlerA', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.registerservicectrlhandlerexa':( 'int', None, 'stdcall', 'advapi32.RegisterServiceCtrlHandlerExA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.registerservicectrlhandlerexw':( 'int', None, 'stdcall', 'advapi32.RegisterServiceCtrlHandlerExW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.registerservicectrlhandlerw':( 'int', None, 'stdcall', 'advapi32.RegisterServiceCtrlHandlerW', (('int', None), ('int', None)) ),
    'advapi32.registertraceguidsa':( 'int', None, 'stdcall', 'advapi32.RegisterTraceGuidsA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.registertraceguidsw':( 'int', None, 'stdcall', 'advapi32.RegisterTraceGuidsW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.removetracecallback':( 'int', None, 'stdcall', 'advapi32.RemoveTraceCallback', (('int', None),) ),
    'advapi32.removeusersfromencryptedfile':( 'int', None, 'stdcall', 'advapi32.RemoveUsersFromEncryptedFile', (('int', None), ('int', None)) ),
    'advapi32.reporteventa':( 'int', None, 'stdcall', 'advapi32.ReportEventA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.reporteventw':( 'int', None, 'stdcall', 'advapi32.ReportEventW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.reverttoself':( 'int', None, 'cdecl', 'advapi32.RevertToSelf', () ),
    'advapi32.safercloselevel':( 'int', None, 'stdcall', 'advapi32.SaferCloseLevel', (('int', None),) ),
    'advapi32.safercomputetokenfromlevel':( 'int', None, 'stdcall', 'advapi32.SaferComputeTokenFromLevel', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.safercreatelevel':( 'int', None, 'stdcall', 'advapi32.SaferCreateLevel', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.safergetlevelinformation':( 'int', None, 'stdcall', 'advapi32.SaferGetLevelInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.safergetpolicyinformation':( 'int', None, 'stdcall', 'advapi32.SaferGetPolicyInformation', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferidentifylevel':( 'int', None, 'stdcall', 'advapi32.SaferIdentifyLevel', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferrecordeventlogentry':( 'int', None, 'stdcall', 'advapi32.SaferRecordEventLogEntry', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.safersetlevelinformation':( 'int', None, 'stdcall', 'advapi32.SaferSetLevelInformation', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.safersetpolicyinformation':( 'int', None, 'stdcall', 'advapi32.SaferSetPolicyInformation', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferichangeregistryscope':( 'int', None, 'stdcall', 'advapi32.SaferiChangeRegistryScope', ( ('int', None), ('int', None)) ),
    'advapi32.safericomparetokenlevels':( 'int', None, 'stdcall', 'advapi32.SaferiCompareTokenLevels', ( ('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferiisexecutablefiletype':( 'int', None, 'stdcall', 'advapi32.SaferiIsExecutableFileType', (('int', None), ('DWORD', None)) ),
    'advapi32.saferipopulatedefaultsinregistry':( 'int', None, 'stdcall', 'advapi32.SaferiPopulateDefaultsInRegistry', (('int', None), ('int', None)) ),
    'advapi32.saferirecordeventlogentry':( 'int', None, 'stdcall', 'advapi32.SaferiRecordEventLogEntry', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferireplaceprocessthreadtokens':( 'int', None, 'stdcall', 'advapi32.SaferiReplaceProcessThreadTokens', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.saferisearchmatchinghashrules':( 'int', None, 'stdcall', 'advapi32.SaferiSearchMatchingHashRules', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setaclinformation':( 'int', None, 'stdcall', 'advapi32.SetAclInformation', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setentriesinaccesslista':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAccessListA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.setentriesinaccesslistw':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAccessListW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setentriesinacla':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAclA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setentriesinaclw':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAclW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.setentriesinauditlista':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAuditListA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.setentriesinauditlistw':( 'int', None, 'stdcall', 'advapi32.SetEntriesInAuditListW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setfilesecuritya':( 'int', None, 'stdcall', 'advapi32.SetFileSecurityA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.setfilesecurityw':( 'int', None, 'stdcall', 'advapi32.SetFileSecurityW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.setinformationcodeauthzlevelw':( 'int', None, 'stdcall', 'advapi32.SetInformationCodeAuthzLevelW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setinformationcodeauthzpolicyw':( 'int', None, 'stdcall', 'advapi32.SetInformationCodeAuthzPolicyW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setkernelobjectsecurity':( 'int', None, 'stdcall', 'advapi32.SetKernelObjectSecurity', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.setnamedsecurityinfoa':( 'int', None, 'stdcall', 'advapi32.SetNamedSecurityInfoA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setnamedsecurityinfoexa':( 'int', None, 'stdcall', 'advapi32.SetNamedSecurityInfoExA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setnamedsecurityinfoexw':( 'int', None, 'stdcall', 'advapi32.SetNamedSecurityInfoExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setnamedsecurityinfow':( 'int', None, 'stdcall', 'advapi32.SetNamedSecurityInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setprivateobjectsecurity':( 'int', None, 'stdcall', 'advapi32.SetPrivateObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setprivateobjectsecurityex':( 'int', None, 'stdcall', 'advapi32.SetPrivateObjectSecurityEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptorcontrol':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorControl', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptordacl':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorDacl', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptorgroup':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorGroup', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptorowner':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorOwner', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'advapi32.setsecuritydescriptorsacl':( 'int', None, 'stdcall', 'advapi32.SetSecurityDescriptorSacl', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecurityinfo':( 'int', None, 'stdcall', 'advapi32.SetSecurityInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecurityinfoexa':( 'int', None, 'stdcall', 'advapi32.SetSecurityInfoExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setsecurityinfoexw':( 'int', None, 'stdcall', 'advapi32.SetSecurityInfoExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setservicebits':( 'int', None, 'stdcall', 'advapi32.SetServiceBits', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.setserviceobjectsecurity':( 'int', None, 'stdcall', 'advapi32.SetServiceObjectSecurity', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.setservicestatus':( 'int', None, 'stdcall', 'advapi32.SetServiceStatus', (('int', None), ('int', None)) ),
    'advapi32.setthreadtoken':( 'int', None, 'stdcall', 'advapi32.SetThreadToken', (('int', None), ('int', None)) ),
    'advapi32.settokeninformation':( 'int', None, 'stdcall', 'advapi32.SetTokenInformation', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.settracecallback':( 'int', None, 'stdcall', 'advapi32.SetTraceCallback', (('int', None), ('int', None)) ),
    'advapi32.setuserfileencryptionkey':( 'int', None, 'stdcall', 'advapi32.SetUserFileEncryptionKey', (('int', None),) ),
    'advapi32.startservicea':( 'int', None, 'stdcall', 'advapi32.StartServiceA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.startservicectrldispatchera':( 'int', None, 'stdcall', 'advapi32.StartServiceCtrlDispatcherA', (('int', None),) ),
    'advapi32.startservicectrldispatcherw':( 'int', None, 'stdcall', 'advapi32.StartServiceCtrlDispatcherW', (('int', None),) ),
    'advapi32.startservicew':( 'int', None, 'stdcall', 'advapi32.StartServiceW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.starttracea':( 'int', None, 'stdcall', 'advapi32.StartTraceA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.starttracew':( 'int', None, 'stdcall', 'advapi32.StartTraceW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'advapi32.stoptracea':( 'int', None, 'stdcall', 'advapi32.StopTraceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.stoptracew':( 'int', None, 'stdcall', 'advapi32.StopTraceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.synchronizewindows31filesandwindowsntregistry':( 'int', None, 'stdcall', 'advapi32.SynchronizeWindows31FilesAndWindowsNTRegistry', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction001':( 'int', None, 'stdcall', 'advapi32.SystemFunction001', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction002':( 'int', None, 'stdcall', 'advapi32.SystemFunction002', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.systemfunction003':( 'int', None, 'stdcall', 'advapi32.SystemFunction003', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction004':( 'int', None, 'stdcall', 'advapi32.SystemFunction004', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.systemfunction005':( 'int', None, 'stdcall', 'advapi32.SystemFunction005', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.systemfunction006':( 'int', None, 'stdcall', 'advapi32.SystemFunction006', (('int', None), ('int', None)) ),
    'advapi32.systemfunction007':( 'int', None, 'stdcall', 'advapi32.SystemFunction007', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction008':( 'int', None, 'stdcall', 'advapi32.SystemFunction008', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction009':( 'int', None, 'stdcall', 'advapi32.SystemFunction009', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction010':( 'int', None, 'stdcall', 'advapi32.SystemFunction010', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction011':( 'int', None, 'stdcall', 'advapi32.SystemFunction011', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction012':( 'int', None, 'stdcall', 'advapi32.SystemFunction012', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction013':( 'int', None, 'stdcall', 'advapi32.SystemFunction013', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction014':( 'int', None, 'stdcall', 'advapi32.SystemFunction014', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction015':( 'int', None, 'stdcall', 'advapi32.SystemFunction015', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction016':( 'int', None, 'stdcall', 'advapi32.SystemFunction016', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction017':( 'int', None, 'stdcall', 'advapi32.SystemFunction017', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction018':( 'int', None, 'stdcall', 'advapi32.SystemFunction018', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction019':( 'int', None, 'stdcall', 'advapi32.SystemFunction019', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction020':( 'int', None, 'stdcall', 'advapi32.SystemFunction020', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction021':( 'int', None, 'stdcall', 'advapi32.SystemFunction021', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction022':( 'int', None, 'stdcall', 'advapi32.SystemFunction022', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction023':( 'int', None, 'stdcall', 'advapi32.SystemFunction023', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction024':( 'int', None, 'stdcall', 'advapi32.SystemFunction024', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction025':( 'int', None, 'stdcall', 'advapi32.SystemFunction025', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction026':( 'int', None, 'stdcall', 'advapi32.SystemFunction026', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction027':( 'int', None, 'stdcall', 'advapi32.SystemFunction027', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.systemfunction028':( 'int', None, 'stdcall', 'advapi32.SystemFunction028', (('int', None), ('void *', 'ptr')) ),
    'advapi32.systemfunction029':( 'int', None, 'stdcall', 'advapi32.SystemFunction029', (('int', None), ('int', None)) ),
    'advapi32.systemfunction030':( 'int', None, 'stdcall', 'advapi32.SystemFunction030', (('int', None), ('int', None)) ),
    'advapi32.systemfunction031':( 'int', None, 'stdcall', 'advapi32.SystemFunction031', (('int', None), ('int', None)) ),
    'advapi32.systemfunction032':( 'int', None, 'stdcall', 'advapi32.SystemFunction032', (('int', None), ('int', None)) ),
    'advapi32.systemfunction033':( 'int', None, 'stdcall', 'advapi32.SystemFunction033', (('int', None), ('int', None)) ),
    'advapi32.systemfunction034':( 'int', None, 'stdcall', 'advapi32.SystemFunction034', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction035':( 'int', None, 'stdcall', 'advapi32.SystemFunction035', (('int', None),) ),
    'advapi32.systemfunction036':( 'int', None, 'stdcall', 'advapi32.SystemFunction036', (('void *', 'ptr'), ('int', None)) ),
    'advapi32.systemfunction040':( 'int', None, 'stdcall', 'advapi32.SystemFunction040', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'advapi32.systemfunction041':( 'int', None, 'stdcall', 'advapi32.SystemFunction041', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.traceevent':( 'int', None, 'stdcall', 'advapi32.TraceEvent', (('int', None), ('int', None), ('void *', 'obj')) ),
    'advapi32.traceeventinstance':( 'int', None, 'stdcall', 'advapi32.TraceEventInstance', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'advapi32.tracemessage':( 'int', None, 'cdecl', 'advapi32.TraceMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.tracemessageva':( 'int', None, 'stdcall', 'advapi32.TraceMessageVa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.treeresetnamedsecurityinfoa':( 'int', None, 'stdcall', 'advapi32.TreeResetNamedSecurityInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.treeresetnamedsecurityinfow':( 'int', None, 'stdcall', 'advapi32.TreeResetNamedSecurityInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.trusteeaccesstoobjecta':( 'int', None, 'stdcall', 'advapi32.TrusteeAccessToObjectA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.trusteeaccesstoobjectw':( 'int', None, 'stdcall', 'advapi32.TrusteeAccessToObjectW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.uninstallapplication':( 'int', None, 'stdcall', 'advapi32.UninstallApplication', (('int', None), ('int', None)) ),
    'advapi32.unlockservicedatabase':( 'int', None, 'stdcall', 'advapi32.UnlockServiceDatabase', (('int', None),) ),
    'advapi32.unregisteridletask':( 'int', None, 'stdcall', 'advapi32.UnregisterIdleTask', (('int', None), ('HANDLE', None), ('HANDLE', None)) ),
    'advapi32.unregistertraceguids':( 'int', None, 'stdcall', 'advapi32.UnregisterTraceGuids', (('int', None), ('int', None)) ),
    'advapi32.updatetracea':( 'int', None, 'stdcall', 'advapi32.UpdateTraceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.updatetracew':( 'int', None, 'stdcall', 'advapi32.UpdateTraceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wdmwmiservicemain':( 'int', None, 'stdcall', 'advapi32.WdmWmiServiceMain', (('int', None), ('int', None)) ),
    'advapi32.wmicloseblock':( 'int', None, 'stdcall', 'advapi32.WmiCloseBlock', (('HANDLE', None),) ),
    'advapi32.wmiclosetracewithcursor':( 'int', None, 'stdcall', 'advapi32.WmiCloseTraceWithCursor', (('int', None),) ),
    'advapi32.wmiconverttimestamp':( 'int', None, 'stdcall', 'advapi32.WmiConvertTimestamp', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmidevinsttoinstancenamea':( 'int', None, 'stdcall', 'advapi32.WmiDevInstToInstanceNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmidevinsttoinstancenamew':( 'int', None, 'stdcall', 'advapi32.WmiDevInstToInstanceNameW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmienumerateguids':( 'int', None, 'stdcall', 'advapi32.WmiEnumerateGuids', (('int', None), ('int', None)) ),
    'advapi32.wmiexecutemethoda':( 'int', None, 'stdcall', 'advapi32.WmiExecuteMethodA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiexecutemethodw':( 'int', None, 'stdcall', 'advapi32.WmiExecuteMethodW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmifilehandletoinstancenamea':( 'int', None, 'stdcall', 'advapi32.WmiFileHandleToInstanceNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmifilehandletoinstancenamew':( 'int', None, 'stdcall', 'advapi32.WmiFileHandleToInstanceNameW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'advapi32.wmifreebuffer':( 'int', None, 'stdcall', 'advapi32.WmiFreeBuffer', (('void *', 'ptr'),) ),
    'advapi32.wmigetfirsttraceoffset':( 'int', None, 'stdcall', 'advapi32.WmiGetFirstTraceOffset', (('int', None),) ),
    'advapi32.wmigetnextevent':( 'int', None, 'stdcall', 'advapi32.WmiGetNextEvent', (('int', None),) ),
    'advapi32.wmigettraceheader':( 'int', None, 'stdcall', 'advapi32.WmiGetTraceHeader', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmimofenumerateresourcesa':( 'int', None, 'stdcall', 'advapi32.WmiMofEnumerateResourcesA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmimofenumerateresourcesw':( 'int', None, 'stdcall', 'advapi32.WmiMofEnumerateResourcesW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'advapi32.wminotificationregistrationa':( 'int', None, 'stdcall', 'advapi32.WmiNotificationRegistrationA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wminotificationregistrationw':( 'int', None, 'stdcall', 'advapi32.WmiNotificationRegistrationW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiopenblock':( 'int', None, 'stdcall', 'advapi32.WmiOpenBlock', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmiopentracewithcursor':( 'int', None, 'stdcall', 'advapi32.WmiOpenTraceWithCursor', (('void *', 'ptr'),) ),
    'advapi32.wmiparsetraceevent':( 'int', None, 'stdcall', 'advapi32.WmiParseTraceEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiqueryalldataa':( 'int', None, 'stdcall', 'advapi32.WmiQueryAllDataA', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiqueryalldatamultiplea':( 'int', None, 'stdcall', 'advapi32.WmiQueryAllDataMultipleA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmiqueryalldatamultiplew':( 'int', None, 'stdcall', 'advapi32.WmiQueryAllDataMultipleW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmiqueryalldataw':( 'int', None, 'stdcall', 'advapi32.WmiQueryAllDataW', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiqueryguidinformation':( 'int', None, 'stdcall', 'advapi32.WmiQueryGuidInformation', (('int', None), ('int', None)) ),
    'advapi32.wmiquerysingleinstancea':( 'int', None, 'stdcall', 'advapi32.WmiQuerySingleInstanceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmiquerysingleinstancemultiplea':( 'int', None, 'stdcall', 'advapi32.WmiQuerySingleInstanceMultipleA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmiquerysingleinstancemultiplew':( 'int', None, 'stdcall', 'advapi32.WmiQuerySingleInstanceMultipleW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'advapi32.wmiquerysingleinstancew':( 'int', None, 'stdcall', 'advapi32.WmiQuerySingleInstanceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmireceivenotificationsa':( 'int', None, 'stdcall', 'advapi32.WmiReceiveNotificationsA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'advapi32.wmireceivenotificationsw':( 'int', None, 'stdcall', 'advapi32.WmiReceiveNotificationsW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'advapi32.wmisetsingleinstancea':( 'int', None, 'stdcall', 'advapi32.WmiSetSingleInstanceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmisetsingleinstancew':( 'int', None, 'stdcall', 'advapi32.WmiSetSingleInstanceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmisetsingleitema':( 'int', None, 'stdcall', 'advapi32.WmiSetSingleItemA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wmisetsingleitemw':( 'int', None, 'stdcall', 'advapi32.WmiSetSingleItemW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'advapi32.wow64win32apientry':( 'int', None, 'stdcall', 'advapi32.Wow64Win32ApiEntry', (('int', None), ('int', None), ('int', None)) ),
    'advapi32.writeencryptedfileraw':( 'int', None, 'cdecl', 'advapi32.WriteEncryptedFileRaw', () ),

    # GDI32
    'gdi32.main_entry':( 'int', None, 'stdcall', 'gdi32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.abortdoc':( 'int', None, 'stdcall', 'gdi32.AbortDoc', (('int', None),) ),
    'gdi32.abortpath':( 'int', None, 'stdcall', 'gdi32.AbortPath', (('int', None),) ),
    'gdi32.addfontmemresourceex':( 'int', None, 'stdcall', 'gdi32.AddFontMemResourceEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.addfontresourcea':( 'int', None, 'stdcall', 'gdi32.AddFontResourceA', (('int', None),) ),
    'gdi32.addfontresourceexa':( 'int', None, 'stdcall', 'gdi32.AddFontResourceExA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.addfontresourceexw':( 'int', None, 'stdcall', 'gdi32.AddFontResourceExW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.addfontresourcetracking':( 'int', None, 'stdcall', 'gdi32.AddFontResourceTracking', (('int', None), ('int', None)) ),
    'gdi32.addfontresourcew':( 'int', None, 'stdcall', 'gdi32.AddFontResourceW', (('void *', 'ptr'),) ),
    'gdi32.anglearc':( 'int', None, 'stdcall', 'gdi32.AngleArc', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.animatepalette':( 'int', None, 'stdcall', 'gdi32.AnimatePalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.anylinkedfonts':( 'int', None, 'cdecl', 'gdi32.AnyLinkedFonts', () ),
    'gdi32.arc':( 'int', None, 'stdcall', 'gdi32.Arc', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.arcto':( 'int', None, 'stdcall', 'gdi32.ArcTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.brushobj_hgetcolortransform':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_hGetColorTransform', (('int', None),) ),
    'gdi32.brushobj_pvallocrbrush':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_pvAllocRbrush', (('int', None), ('int', None)) ),
    'gdi32.brushobj_pvgetrbrush':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_pvGetRbrush', (('int', None),) ),
    'gdi32.brushobj_ulgetbrushcolor':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_ulGetBrushColor', (('int', None),) ),
    'gdi32.beginpath':( 'int', None, 'stdcall', 'gdi32.BeginPath', (('int', None),) ),
    'gdi32.bitblt':( 'int', None, 'stdcall', 'gdi32.BitBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_benum':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_bEnum', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_cenumstart':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_cEnumStart', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_ppogetpath':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_ppoGetPath', (('int', None),) ),
    'gdi32.canceldc':( 'int', None, 'stdcall', 'gdi32.CancelDC', (('int', None),) ),
    'gdi32.checkcolorsingamut':( 'int', None, 'stdcall', 'gdi32.CheckColorsInGamut', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.choosepixelformat':( 'int', None, 'stdcall', 'gdi32.ChoosePixelFormat', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.chord':( 'int', None, 'stdcall', 'gdi32.Chord', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clearbitmapattributes':( 'int', None, 'stdcall', 'gdi32.ClearBitmapAttributes', (('int', None), ('int', None)) ),
    'gdi32.clearbrushattributes':( 'int', None, 'stdcall', 'gdi32.ClearBrushAttributes', (('int', None), ('int', None)) ),
    'gdi32.closeenhmetafile':( 'int', None, 'stdcall', 'gdi32.CloseEnhMetaFile', (('int', None),) ),
    'gdi32.closefigure':( 'int', None, 'stdcall', 'gdi32.CloseFigure', (('int', None),) ),
    'gdi32.closemetafile':( 'int', None, 'stdcall', 'gdi32.CloseMetaFile', (('int', None),) ),
    'gdi32.colorcorrectpalette':( 'int', None, 'stdcall', 'gdi32.ColorCorrectPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.colormatchtotarget':( 'int', None, 'stdcall', 'gdi32.ColorMatchToTarget', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.combinergn':( 'int', None, 'stdcall', 'gdi32.CombineRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.combinetransform':( 'int', None, 'stdcall', 'gdi32.CombineTransform', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.copyenhmetafilea':( 'int', None, 'stdcall', 'gdi32.CopyEnhMetaFileA', (('int', None), ('int', None)) ),
    'gdi32.copyenhmetafilew':( 'int', None, 'stdcall', 'gdi32.CopyEnhMetaFileW', (('int', None), ('StringW', None)) ),
    'gdi32.copymetafilea':( 'int', None, 'stdcall', 'gdi32.CopyMetaFileA', (('int', None), ('int', None)) ),
    'gdi32.copymetafilew':( 'int', None, 'stdcall', 'gdi32.CopyMetaFileW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.createbitmap':( 'int', None, 'stdcall', 'gdi32.CreateBitmap', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createbitmapindirect':( 'int', None, 'stdcall', 'gdi32.CreateBitmapIndirect', (('void *', 'ptr'),) ),
    'gdi32.createbrushindirect':( 'int', None, 'stdcall', 'gdi32.CreateBrushIndirect', (('void *', 'ptr'),) ),
    'gdi32.createcolorspacea':( 'int', None, 'stdcall', 'gdi32.CreateColorSpaceA', (('int', None),) ),
    'gdi32.createcolorspacew':( 'int', None, 'stdcall', 'gdi32.CreateColorSpaceW', (('void *', 'ptr'),) ),
    'gdi32.createcompatiblebitmap':( 'int', None, 'stdcall', 'gdi32.CreateCompatibleBitmap', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createcompatibledc':( 'int', None, 'stdcall', 'gdi32.CreateCompatibleDC', (('int', None),) ),
    'gdi32.createdca':( 'int', None, 'stdcall', 'gdi32.CreateDCA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createdcw':( 'int', None, 'stdcall', 'gdi32.CreateDCW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createdibpatternbrush':( 'int', None, 'stdcall', 'gdi32.CreateDIBPatternBrush', ( ('int', None), ('int', None)) ),
    'gdi32.createdibpatternbrushpt':( 'int', None, 'stdcall', 'gdi32.CreateDIBPatternBrushPt', (('int', None), ('int', None)) ),
    'gdi32.createdibsection':( 'int', None, 'stdcall', 'gdi32.CreateDIBSection', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.createdibitmap':( 'int', None, 'stdcall', 'gdi32.CreateDIBitmap', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.creatediscardablebitmap':( 'int', None, 'stdcall', 'gdi32.CreateDiscardableBitmap', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createellipticrgn':( 'int', None, 'stdcall', 'gdi32.CreateEllipticRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createellipticrgnindirect':( 'int', None, 'stdcall', 'gdi32.CreateEllipticRgnIndirect', (('int', None),) ),
    'gdi32.createenhmetafilea':( 'int', None, 'stdcall', 'gdi32.CreateEnhMetaFileA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'gdi32.createenhmetafilew':( 'int', None, 'stdcall', 'gdi32.CreateEnhMetaFileW', (('int', None), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'gdi32.createfonta':( 'int', None, 'stdcall', 'gdi32.CreateFontA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createfontindirecta':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectA', (('void *', 'ptr'),) ),
    'gdi32.createfontindirectexa':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectExA', (('int', None),) ),
    'gdi32.createfontindirectexw':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectExW', (('void *', 'ptr'),) ),
    'gdi32.createfontindirectw':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectW', (('void *', 'ptr'),) ),
    'gdi32.createfontw':( 'int', None, 'stdcall', 'gdi32.CreateFontW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createhalftonepalette':( 'int', None, 'stdcall', 'gdi32.CreateHalftonePalette', (('int', None),) ),
    'gdi32.createhatchbrush':( 'int', None, 'stdcall', 'gdi32.CreateHatchBrush', (('int', None), ('int', None)) ),
    'gdi32.createica':( 'int', None, 'stdcall', 'gdi32.CreateICA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createicw':( 'int', None, 'stdcall', 'gdi32.CreateICW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createmetafilea':( 'int', None, 'stdcall', 'gdi32.CreateMetaFileA', (('int', None),) ),
    'gdi32.createmetafilew':( 'int', None, 'stdcall', 'gdi32.CreateMetaFileW', (('int', None),) ),
    'gdi32.createpalette':( 'int', None, 'stdcall', 'gdi32.CreatePalette', (('int', None),) ),
    'gdi32.createpatternbrush':( 'int', None, 'stdcall', 'gdi32.CreatePatternBrush', (('int', None),) ),
    'gdi32.createpen':( 'int', None, 'stdcall', 'gdi32.CreatePen', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createpenindirect':( 'int', None, 'stdcall', 'gdi32.CreatePenIndirect', (('void *', 'ptr'),) ),
    'gdi32.createpolypolygonrgn':( 'int', None, 'stdcall', 'gdi32.CreatePolyPolygonRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createpolygonrgn':( 'int', None, 'stdcall', 'gdi32.CreatePolygonRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createrectrgn':( 'int', None, 'stdcall', 'gdi32.CreateRectRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createrectrgnindirect':( 'int', None, 'stdcall', 'gdi32.CreateRectRgnIndirect', (('int', None),) ),
    'gdi32.createroundrectrgn':( 'int', None, 'stdcall', 'gdi32.CreateRoundRectRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createscalablefontresourcea':( 'int', None, 'stdcall', 'gdi32.CreateScalableFontResourceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createscalablefontresourcew':( 'int', None, 'stdcall', 'gdi32.CreateScalableFontResourceW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.createsolidbrush':( 'int', None, 'stdcall', 'gdi32.CreateSolidBrush', (('int', None),) ),
    'gdi32.dptolp':( 'int', None, 'stdcall', 'gdi32.DPtoLP', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry0':( 'int', None, 'stdcall', 'gdi32.DdEntry0', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry1':( 'int', None, 'stdcall', 'gdi32.DdEntry1', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry10':( 'int', None, 'stdcall', 'gdi32.DdEntry10', (('int', None), ('int', None)) ),
    'gdi32.ddentry11':( 'int', None, 'stdcall', 'gdi32.DdEntry11', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry12':( 'int', None, 'stdcall', 'gdi32.DdEntry12', (('int', None), ('int', None)) ),
    'gdi32.ddentry13':( 'int', None, 'stdcall', 'gdi32.DdEntry13', (('int', None), ('int', None)) ),
    'gdi32.ddentry14':( 'int', None, 'stdcall', 'gdi32.DdEntry14', (('int', None), ('int', None)) ),
    'gdi32.ddentry15':( 'int', None, 'stdcall', 'gdi32.DdEntry15', (('int', None),) ),
    'gdi32.ddentry16':( 'int', None, 'stdcall', 'gdi32.DdEntry16', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry17':( 'int', None, 'stdcall', 'gdi32.DdEntry17', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'gdi32.ddentry18':( 'int', None, 'stdcall', 'gdi32.DdEntry18', (('int', None), ('int', None)) ),
    'gdi32.ddentry19':( 'int', None, 'stdcall', 'gdi32.DdEntry19', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ddentry2':( 'int', None, 'stdcall', 'gdi32.DdEntry2', (('int', None),) ),
    'gdi32.ddentry20':( 'int', None, 'stdcall', 'gdi32.DdEntry20', (('int', None),) ),
    'gdi32.ddentry21':( 'int', None, 'stdcall', 'gdi32.DdEntry21', (('int', None),) ),
    'gdi32.ddentry22':( 'int', None, 'stdcall', 'gdi32.DdEntry22', (('int', None), ('int', None)) ),
    'gdi32.ddentry23':( 'int', None, 'stdcall', 'gdi32.DdEntry23', (('int', None), ('int', None)) ),
    'gdi32.ddentry24':( 'int', None, 'stdcall', 'gdi32.DdEntry24', (('int', None),) ),
    'gdi32.ddentry25':( 'int', None, 'stdcall', 'gdi32.DdEntry25', (('int', None), ('int', None)) ),
    'gdi32.ddentry26':( 'int', None, 'stdcall', 'gdi32.DdEntry26', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry27':( 'int', None, 'stdcall', 'gdi32.DdEntry27', (('int', None), ('int', None)) ),
    'gdi32.ddentry28':( 'int', None, 'stdcall', 'gdi32.DdEntry28', (('int', None), ('int', None)) ),
    'gdi32.ddentry29':( 'int', None, 'stdcall', 'gdi32.DdEntry29', (('int', None), ('int', None)) ),
    'gdi32.ddentry3':( 'int', None, 'stdcall', 'gdi32.DdEntry3', (('int', None),) ),
    'gdi32.ddentry30':( 'int', None, 'stdcall', 'gdi32.DdEntry30', (('int', None), ('int', None)) ),
    'gdi32.ddentry31':( 'int', None, 'stdcall', 'gdi32.DdEntry31', (('int', None), ('void *', 'ptr')) ),
    'gdi32.ddentry32':( 'int', None, 'stdcall', 'gdi32.DdEntry32', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry33':( 'int', None, 'stdcall', 'gdi32.DdEntry33', (('int', None), ('int', None)) ),
    'gdi32.ddentry34':( 'int', None, 'stdcall', 'gdi32.DdEntry34', (('int', None), ('int', None)) ),
    'gdi32.ddentry35':( 'int', None, 'stdcall', 'gdi32.DdEntry35', (('int', None), ('int', None)) ),
    'gdi32.ddentry36':( 'int', None, 'stdcall', 'gdi32.DdEntry36', (('int', None), ('int', None)) ),
    'gdi32.ddentry37':( 'int', None, 'stdcall', 'gdi32.DdEntry37', (('int', None), ('int', None)) ),
    'gdi32.ddentry38':( 'int', None, 'stdcall', 'gdi32.DdEntry38', (('int', None), ('int', None)) ),
    'gdi32.ddentry39':( 'int', None, 'stdcall', 'gdi32.DdEntry39', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry4':( 'int', None, 'stdcall', 'gdi32.DdEntry4', (('int', None),) ),
    'gdi32.ddentry40':( 'int', None, 'stdcall', 'gdi32.DdEntry40', (('int', None), ('int', None)) ),
    'gdi32.ddentry41':( 'int', None, 'stdcall', 'gdi32.DdEntry41', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ddentry42':( 'int', None, 'stdcall', 'gdi32.DdEntry42', (('int', None), ('int', None)) ),
    'gdi32.ddentry43':( 'int', None, 'stdcall', 'gdi32.DdEntry43', (('int', None), ('int', None)) ),
    'gdi32.ddentry44':( 'int', None, 'stdcall', 'gdi32.DdEntry44', (('int', None),) ),
    'gdi32.ddentry45':( 'int', None, 'stdcall', 'gdi32.DdEntry45', (('int', None), ('int', None)) ),
    'gdi32.ddentry46':( 'int', None, 'stdcall', 'gdi32.DdEntry46', (('int', None), ('int', None)) ),
    'gdi32.ddentry47':( 'int', None, 'stdcall', 'gdi32.DdEntry47', (('int', None), ('int', None)) ),
    'gdi32.ddentry48':( 'int', None, 'stdcall', 'gdi32.DdEntry48', (('int', None), ('int', None)) ),
    'gdi32.ddentry49':( 'int', None, 'stdcall', 'gdi32.DdEntry49', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry5':( 'int', None, 'stdcall', 'gdi32.DdEntry5', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry50':( 'int', None, 'stdcall', 'gdi32.DdEntry50', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry51':( 'int', None, 'stdcall', 'gdi32.DdEntry51', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry52':( 'int', None, 'stdcall', 'gdi32.DdEntry52', (('int', None), ('int', None)) ),
    'gdi32.ddentry53':( 'int', None, 'stdcall', 'gdi32.DdEntry53', (('int', None), ('int', None)) ),
    'gdi32.ddentry54':( 'int', None, 'stdcall', 'gdi32.DdEntry54', (('int', None), ('int', None)) ),
    'gdi32.ddentry55':( 'int', None, 'stdcall', 'gdi32.DdEntry55', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry56':( 'int', None, 'stdcall', 'gdi32.DdEntry56', (('int', None), ('int', None)) ),
    'gdi32.ddentry6':( 'int', None, 'stdcall', 'gdi32.DdEntry6', (('int', None),) ),
    'gdi32.ddentry7':( 'int', None, 'stdcall', 'gdi32.DdEntry7', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry8':( 'int', None, 'stdcall', 'gdi32.DdEntry8', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry9':( 'int', None, 'stdcall', 'gdi32.DdEntry9', (('int', None), ('int', None)) ),
    'gdi32.deletecolorspace':( 'int', None, 'stdcall', 'gdi32.DeleteColorSpace', (('int', None),) ),
    'gdi32.deletedc':( 'int', None, 'stdcall', 'gdi32.DeleteDC', (('int', None),) ),
    'gdi32.deleteenhmetafile':( 'int', None, 'stdcall', 'gdi32.DeleteEnhMetaFile', (('int', None),) ),
    'gdi32.deletemetafile':( 'int', None, 'stdcall', 'gdi32.DeleteMetaFile', (('int', None),) ),
    'gdi32.deleteobject':( 'int', None, 'stdcall', 'gdi32.DeleteObject', (('int', None),) ),
    'gdi32.describepixelformat':( 'int', None, 'stdcall', 'gdi32.DescribePixelFormat', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.devicecapabilitiesexa':( 'int', None, 'stdcall', 'gdi32.DeviceCapabilitiesExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.devicecapabilitiesexw':( 'int', None, 'stdcall', 'gdi32.DeviceCapabilitiesExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.drawescape':( 'int', None, 'stdcall', 'gdi32.DrawEscape', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.ellipse':( 'int', None, 'stdcall', 'gdi32.Ellipse', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.enableeudc':( 'int', None, 'stdcall', 'gdi32.EnableEUDC', (('int', None),) ),
    'gdi32.enddoc':( 'int', None, 'stdcall', 'gdi32.EndDoc', (('int', None),) ),
    'gdi32.endformpage':( 'int', None, 'stdcall', 'gdi32.EndFormPage', (('int', None),) ),
    'gdi32.endpage':( 'int', None, 'stdcall', 'gdi32.EndPage', (('int', None),) ),
    'gdi32.endpath':( 'int', None, 'stdcall', 'gdi32.EndPath', (('int', None),) ),
    'gdi32.engacquiresemaphore':( 'int', None, 'cdecl', 'gdi32.EngAcquireSemaphore', () ),
    'gdi32.engalphablend':( 'int', None, 'stdcall', 'gdi32.EngAlphaBlend', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engassociatesurface':( 'int', None, 'stdcall', 'gdi32.EngAssociateSurface', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engbitblt':( 'int', None, 'stdcall', 'gdi32.EngBitBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcheckabort':( 'int', None, 'stdcall', 'gdi32.EngCheckAbort', (('int', None),) ),
    'gdi32.engcomputeglyphset':( 'int', None, 'stdcall', 'gdi32.EngComputeGlyphSet', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcopybits':( 'int', None, 'stdcall', 'gdi32.EngCopyBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatebitmap':( 'int', None, 'stdcall', 'gdi32.EngCreateBitmap', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreateclip':( 'int', None, 'cdecl', 'gdi32.EngCreateClip', () ),
    'gdi32.engcreatedevicebitmap':( 'int', None, 'stdcall', 'gdi32.EngCreateDeviceBitmap', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatedevicesurface':( 'int', None, 'stdcall', 'gdi32.EngCreateDeviceSurface', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatepalette':( 'int', None, 'stdcall', 'gdi32.EngCreatePalette', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatesemaphore':( 'int', None, 'cdecl', 'gdi32.EngCreateSemaphore', () ),
    'gdi32.engdeleteclip':( 'int', None, 'stdcall', 'gdi32.EngDeleteClip', (('int', None),) ),
    'gdi32.engdeletepalette':( 'int', None, 'stdcall', 'gdi32.EngDeletePalette', (('int', None),) ),
    'gdi32.engdeletepath':( 'int', None, 'stdcall', 'gdi32.EngDeletePath', (('int', None),) ),
    'gdi32.engdeletesemaphore':( 'int', None, 'stdcall', 'gdi32.EngDeleteSemaphore', (('void *', 'ptr'),) ),
    'gdi32.engdeletesurface':( 'int', None, 'stdcall', 'gdi32.EngDeleteSurface', (('int', None),) ),
    'gdi32.engerasesurface':( 'int', None, 'stdcall', 'gdi32.EngEraseSurface', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfillpath':( 'int', None, 'stdcall', 'gdi32.EngFillPath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfindresource':( 'int', None, 'stdcall', 'gdi32.EngFindResource', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfreemodule':( 'int', None, 'cdecl', 'gdi32.EngFreeModule', () ),
    'gdi32.enggetcurrentcodepage':( 'int', None, 'stdcall', 'gdi32.EngGetCurrentCodePage', (('int', None), ('int', None)) ),
    'gdi32.enggetdrivername':( 'int', None, 'stdcall', 'gdi32.EngGetDriverName', (('int', None),) ),
    'gdi32.enggetprinterdatafilename':( 'int', None, 'stdcall', 'gdi32.EngGetPrinterDataFileName', (('int', None),) ),
    'gdi32.enggradientfill':( 'int', None, 'stdcall', 'gdi32.EngGradientFill', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.englineto':( 'int', None, 'stdcall', 'gdi32.EngLineTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engloadmodule':( 'int', None, 'stdcall', 'gdi32.EngLoadModule', (('int', None),) ),
    'gdi32.englocksurface':( 'int', None, 'stdcall', 'gdi32.EngLockSurface', (('int', None),) ),
    'gdi32.engmarkbandingsurface':( 'int', None, 'stdcall', 'gdi32.EngMarkBandingSurface', (('int', None),) ),
    'gdi32.engmultibytetounicoden':( 'int', None, 'cdecl', 'gdi32.EngMultiByteToUnicodeN', () ),
    'gdi32.engmultibytetowidechar':( 'int', None, 'stdcall', 'gdi32.EngMultiByteToWideChar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engpaint':( 'int', None, 'stdcall', 'gdi32.EngPaint', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engplgblt':( 'int', None, 'stdcall', 'gdi32.EngPlgBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engqueryemfinfo':( 'int', None, 'stdcall', 'gdi32.EngQueryEMFInfo', (('int', None), ('int', None)) ),
    'gdi32.engquerylocaltime':( 'int', None, 'stdcall', 'gdi32.EngQueryLocalTime', (('int', None),) ),
    'gdi32.engreleasesemaphore':( 'int', None, 'cdecl', 'gdi32.EngReleaseSemaphore', () ),
    'gdi32.engstretchblt':( 'int', None, 'stdcall', 'gdi32.EngStretchBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstretchbltrop':( 'int', None, 'stdcall', 'gdi32.EngStretchBltROP', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstrokeandfillpath':( 'int', None, 'stdcall', 'gdi32.EngStrokeAndFillPath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstrokepath':( 'int', None, 'stdcall', 'gdi32.EngStrokePath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engtextout':( 'int', None, 'stdcall', 'gdi32.EngTextOut', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engtransparentblt':( 'int', None, 'stdcall', 'gdi32.EngTransparentBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engunicodetomultibyten':( 'int', None, 'cdecl', 'gdi32.EngUnicodeToMultiByteN', () ),
    'gdi32.engunlocksurface':( 'int', None, 'stdcall', 'gdi32.EngUnlockSurface', (('int', None),) ),
    'gdi32.engwidechartomultibyte':( 'int', None, 'stdcall', 'gdi32.EngWideCharToMultiByte', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.enumenhmetafile':( 'int', None, 'stdcall', 'gdi32.EnumEnhMetaFile', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesa':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontfamiliesexa':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesExA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesexw':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesExW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesw':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontsa':( 'int', None, 'stdcall', 'gdi32.EnumFontsA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontsw':( 'int', None, 'stdcall', 'gdi32.EnumFontsW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumicmprofilesa':( 'int', None, 'stdcall', 'gdi32.EnumICMProfilesA', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'gdi32.enumicmprofilesw':( 'int', None, 'stdcall', 'gdi32.EnumICMProfilesW', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'gdi32.enummetafile':( 'int', None, 'stdcall', 'gdi32.EnumMetaFile', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumobjects':( 'int', None, 'stdcall', 'gdi32.EnumObjects', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.equalrgn':( 'int', None, 'stdcall', 'gdi32.EqualRgn', (('int', None), ('int', None)) ),
    'gdi32.escape':( 'int', None, 'stdcall', 'gdi32.Escape', (('int', None), ('int', None), ('DWORD', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.eudcloadlinkw':( 'int', None, 'stdcall', 'gdi32.EudcLoadLinkW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.eudcunloadlinkw':( 'int', None, 'stdcall', 'gdi32.EudcUnloadLinkW', (('int', None), ('int', None)) ),
    'gdi32.excludecliprect':( 'int', None, 'stdcall', 'gdi32.ExcludeClipRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.extcreatepen':( 'int', None, 'stdcall', 'gdi32.ExtCreatePen', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.extcreateregion':( 'int', None, 'stdcall', 'gdi32.ExtCreateRegion', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.extescape':( 'int', None, 'stdcall', 'gdi32.ExtEscape', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.extfloodfill':( 'int', None, 'stdcall', 'gdi32.ExtFloodFill', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.extselectcliprgn':( 'int', None, 'stdcall', 'gdi32.ExtSelectClipRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.exttextouta':( 'int', None, 'stdcall', 'gdi32.ExtTextOutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None), ('int', None)) ),
    'gdi32.exttextoutw':( 'int', None, 'stdcall', 'gdi32.ExtTextOutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.fontobj_cgetallglyphhandles':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_cGetAllGlyphHandles', (('int', None), ('int', None)) ),
    'gdi32.fontobj_cgetglyphs':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_cGetGlyphs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.fontobj_pqueryglyphattrs':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pQueryGlyphAttrs', (('int', None), ('int', None)) ),
    'gdi32.fontobj_pfdg':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pfdg', (('int', None),) ),
    'gdi32.fontobj_pifi':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pifi', (('int', None),) ),
    'gdi32.fontobj_pvtruetypefontfile':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pvTrueTypeFontFile', (('int', None), ('int', None)) ),
    'gdi32.fontobj_pxogetxform':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pxoGetXform', (('int', None),) ),
    'gdi32.fontobj_vgetinfo':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_vGetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.fillpath':( 'int', None, 'stdcall', 'gdi32.FillPath', (('int', None),) ),
    'gdi32.fillrgn':( 'int', None, 'stdcall', 'gdi32.FillRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.fixbrushorgex':( 'int', None, 'stdcall', 'gdi32.FixBrushOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.flattenpath':( 'int', None, 'stdcall', 'gdi32.FlattenPath', (('int', None),) ),
    'gdi32.floodfill':( 'int', None, 'stdcall', 'gdi32.FloodFill', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.fontislinked':( 'int', None, 'stdcall', 'gdi32.FontIsLinked', (('int', None),) ),
    'gdi32.framergn':( 'int', None, 'stdcall', 'gdi32.FrameRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiaddfontresourcew':( 'int', None, 'stdcall', 'gdi32.GdiAddFontResourceW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.gdiaddglsbounds':( 'int', None, 'stdcall', 'gdi32.GdiAddGlsBounds', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiaddglsrecord':( 'int', None, 'stdcall', 'gdi32.GdiAddGlsRecord', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdialphablend':( 'int', None, 'stdcall', 'gdi32.GdiAlphaBlend', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiartificialdecrementdriver':( 'int', None, 'stdcall', 'gdi32.GdiArtificialDecrementDriver', (('int', None), ('int', None)) ),
    'gdi32.gdicleancachedc':( 'int', None, 'stdcall', 'gdi32.GdiCleanCacheDC', (('int', None),) ),
    'gdi32.gdicomment':( 'int', None, 'stdcall', 'gdi32.GdiComment', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiconsoletextout':( 'int', None, 'stdcall', 'gdi32.GdiConsoleTextOut', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiconvertandcheckdc':( 'int', None, 'stdcall', 'gdi32.GdiConvertAndCheckDC', (('int', None),) ),
    'gdi32.gdiconvertbitmap':( 'int', None, 'stdcall', 'gdi32.GdiConvertBitmap', (('int', None),) ),
    'gdi32.gdiconvertbitmapv5':( 'int', None, 'stdcall', 'gdi32.GdiConvertBitmapV5', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiconvertbrush':( 'int', None, 'stdcall', 'gdi32.GdiConvertBrush', (('int', None),) ),
    'gdi32.gdiconvertdc':( 'int', None, 'stdcall', 'gdi32.GdiConvertDC', (('int', None),) ),
    'gdi32.gdiconvertenhmetafile':( 'int', None, 'stdcall', 'gdi32.GdiConvertEnhMetaFile', (('int', None),) ),
    'gdi32.gdiconvertfont':( 'int', None, 'stdcall', 'gdi32.GdiConvertFont', (('int', None),) ),
    'gdi32.gdiconvertmetafilepict':( 'int', None, 'stdcall', 'gdi32.GdiConvertMetaFilePict', (('int', None),) ),
    'gdi32.gdiconvertpalette':( 'int', None, 'stdcall', 'gdi32.GdiConvertPalette', (('int', None),) ),
    'gdi32.gdiconvertregion':( 'int', None, 'stdcall', 'gdi32.GdiConvertRegion', (('int', None),) ),
    'gdi32.gdiconverttodevmodew':( 'int', None, 'stdcall', 'gdi32.GdiConvertToDevmodeW', (('int', None),) ),
    'gdi32.gdicreatelocalenhmetafile':( 'int', None, 'stdcall', 'gdi32.GdiCreateLocalEnhMetaFile', (('int', None),) ),
    'gdi32.gdicreatelocalmetafilepict':( 'int', None, 'stdcall', 'gdi32.GdiCreateLocalMetaFilePict', (('int', None),) ),
    'gdi32.gdideletelocaldc':( 'int', None, 'stdcall', 'gdi32.GdiDeleteLocalDC', (('int', None),) ),
    'gdi32.gdideletespoolfilehandle':( 'int', None, 'stdcall', 'gdi32.GdiDeleteSpoolFileHandle', (('void *', 'ptr'),) ),
    'gdi32.gdidescribepixelformat':( 'int', None, 'stdcall', 'gdi32.GdiDescribePixelFormat', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdidllinitialize':( 'int', None, 'stdcall', 'gdi32.GdiDllInitialize', ( ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdidrawstream':( 'int', None, 'stdcall', 'gdi32.GdiDrawStream', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdienddocemf':( 'int', None, 'stdcall', 'gdi32.GdiEndDocEMF', (('int', None),) ),
    'gdi32.gdiendpageemf':( 'int', None, 'stdcall', 'gdi32.GdiEndPageEMF', (('int', None), ('int', None)) ),
    'gdi32.gdientry1':( 'int', None, 'stdcall', 'gdi32.GdiEntry1', (('int', None), ('int', None)) ),
    'gdi32.gdientry10':( 'int', None, 'stdcall', 'gdi32.GdiEntry10', (('int', None), ('int', None)) ),
    'gdi32.gdientry11':( 'int', None, 'stdcall', 'gdi32.GdiEntry11', (('int', None), ('int', None)) ),
    'gdi32.gdientry12':( 'int', None, 'stdcall', 'gdi32.GdiEntry12', (('int', None), ('int', None)) ),
    'gdi32.gdientry13':( 'int', None, 'cdecl', 'gdi32.GdiEntry13', () ),
    'gdi32.gdientry14':( 'int', None, 'stdcall', 'gdi32.GdiEntry14', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry15':( 'int', None, 'stdcall', 'gdi32.GdiEntry15', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry16':( 'int', None, 'stdcall', 'gdi32.GdiEntry16', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry2':( 'int', None, 'stdcall', 'gdi32.GdiEntry2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry3':( 'int', None, 'stdcall', 'gdi32.GdiEntry3', (('int', None),) ),
    'gdi32.gdientry4':( 'int', None, 'stdcall', 'gdi32.GdiEntry4', (('int', None), ('int', None)) ),
    'gdi32.gdientry5':( 'int', None, 'stdcall', 'gdi32.GdiEntry5', (('int', None),) ),
    'gdi32.gdientry6':( 'int', None, 'stdcall', 'gdi32.GdiEntry6', (('int', None), ('int', None)) ),
    'gdi32.gdientry7':( 'int', None, 'stdcall', 'gdi32.GdiEntry7', (('int', None), ('int', None)) ),
    'gdi32.gdientry8':( 'int', None, 'stdcall', 'gdi32.GdiEntry8', (('int', None),) ),
    'gdi32.gdientry9':( 'int', None, 'stdcall', 'gdi32.GdiEntry9', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdifixuphandle':( 'int', None, 'stdcall', 'gdi32.GdiFixUpHandle', (('int', None),) ),
    'gdi32.gdiflush':( 'int', None, 'cdecl', 'gdi32.GdiFlush', () ),
    'gdi32.gdifullscreencontrol':( 'int', None, 'stdcall', 'gdi32.GdiFullscreenControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetbatchlimit':( 'int', None, 'cdecl', 'gdi32.GdiGetBatchLimit', () ),
    'gdi32.gdigetbitmapbitssize':( 'int', None, 'stdcall', 'gdi32.GdiGetBitmapBitsSize', (('int', None),) ),
    'gdi32.gdigetchardimensions':( 'int', None, 'stdcall', 'gdi32.GdiGetCharDimensions', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetcodepage':( 'int', None, 'stdcall', 'gdi32.GdiGetCodePage', (('int', None),) ),
    'gdi32.gdigetdc':( 'int', None, 'stdcall', 'gdi32.GdiGetDC', (('int', None),) ),
    'gdi32.gdigetdevmodeforpage':( 'int', None, 'stdcall', 'gdi32.GdiGetDevmodeForPage', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetlocalbrush':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalBrush', (('int', None),) ),
    'gdi32.gdigetlocaldc':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalDC', (('int', None),) ),
    'gdi32.gdigetlocalfont':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalFont', (('int', None),) ),
    'gdi32.gdigetpagecount':( 'int', None, 'stdcall', 'gdi32.GdiGetPageCount', (('int', None),) ),
    'gdi32.gdigetpagehandle':( 'int', None, 'stdcall', 'gdi32.GdiGetPageHandle', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdigetspoolfilehandle':( 'int', None, 'stdcall', 'gdi32.GdiGetSpoolFileHandle', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetspoolmessage':( 'int', None, 'stdcall', 'gdi32.GdiGetSpoolMessage', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigradientfill':( 'int', None, 'stdcall', 'gdi32.GdiGradientFill', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiinitspool':( 'int', None, 'cdecl', 'gdi32.GdiInitSpool', () ),
    'gdi32.gdiinitializelanguagepack':( 'int', None, 'stdcall', 'gdi32.GdiInitializeLanguagePack', (('int', None),) ),
    'gdi32.gdiismetafiledc':( 'int', None, 'stdcall', 'gdi32.GdiIsMetaFileDC', (('int', None),) ),
    'gdi32.gdiismetaprintdc':( 'int', None, 'stdcall', 'gdi32.GdiIsMetaPrintDC', (('int', None),) ),
    'gdi32.gdiisplaymetafiledc':( 'int', None, 'stdcall', 'gdi32.GdiIsPlayMetafileDC', (('int', None),) ),
    'gdi32.gdiplaydcscript':( 'int', None, 'stdcall', 'gdi32.GdiPlayDCScript', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayEMF', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayjournal':( 'int', None, 'stdcall', 'gdi32.GdiPlayJournal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplaypageemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayPageEMF', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.gdiplayprivatepageemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayPrivatePageEMF', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayscript':( 'int', None, 'stdcall', 'gdi32.GdiPlayScript', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiprinterthunk':( 'int', None, 'stdcall', 'gdi32.GdiPrinterThunk', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiprocesssetup':( 'int', None, 'cdecl', 'gdi32.GdiProcessSetup', () ),
    'gdi32.gdiqueryfonts':( 'int', None, 'stdcall', 'gdi32.GdiQueryFonts', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiquerytable':( 'int', None, 'cdecl', 'gdi32.GdiQueryTable', () ),
    'gdi32.gdirealizationinfo':( 'int', None, 'stdcall', 'gdi32.GdiRealizationInfo', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gdireleasedc':( 'int', None, 'stdcall', 'gdi32.GdiReleaseDC', (('int', None),) ),
    'gdi32.gdireleaselocaldc':( 'int', None, 'stdcall', 'gdi32.GdiReleaseLocalDC', (('int', None),) ),
    'gdi32.gdiresetdcemf':( 'int', None, 'stdcall', 'gdi32.GdiResetDCEMF', (('int', None), ('int', None)) ),
    'gdi32.gdisetattrs':( 'int', None, 'stdcall', 'gdi32.GdiSetAttrs', (('int', None),) ),
    'gdi32.gdisetbatchlimit':( 'int', None, 'stdcall', 'gdi32.GdiSetBatchLimit', (('int', None),) ),
    'gdi32.gdisetlasterror':( 'int', None, 'stdcall', 'gdi32.GdiSetLastError', (('int', None),) ),
    'gdi32.gdisetpixelformat':( 'int', None, 'stdcall', 'gdi32.GdiSetPixelFormat', (('int', None), ('int', None)) ),
    'gdi32.gdisetserverattr':( 'int', None, 'stdcall', 'gdi32.GdiSetServerAttr', (('int', None), ('int', None)) ),
    'gdi32.gdistartdocemf':( 'int', None, 'stdcall', 'gdi32.GdiStartDocEMF', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.gdistartpageemf':( 'int', None, 'stdcall', 'gdi32.GdiStartPageEMF', (('int', None),) ),
    'gdi32.gdiswapbuffers':( 'int', None, 'stdcall', 'gdi32.GdiSwapBuffers', (('int', None),) ),
    'gdi32.gditransparentblt':( 'int', None, 'stdcall', 'gdi32.GdiTransparentBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdivalidatehandle':( 'int', None, 'stdcall', 'gdi32.GdiValidateHandle', (('int', None),) ),
    'gdi32.getarcdirection':( 'int', None, 'stdcall', 'gdi32.GetArcDirection', (('int', None),) ),
    'gdi32.getaspectratiofilterex':( 'int', None, 'stdcall', 'gdi32.GetAspectRatioFilterEx', (('int', None), ('int', None)) ),
    'gdi32.getbitmapattributes':( 'int', None, 'stdcall', 'gdi32.GetBitmapAttributes', (('int', None),) ),
    'gdi32.getbitmapbits':( 'int', None, 'stdcall', 'gdi32.GetBitmapBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getbitmapdimensionex':( 'int', None, 'stdcall', 'gdi32.GetBitmapDimensionEx', (('int', None), ('int', None)) ),
    'gdi32.getbkcolor':( 'int', None, 'stdcall', 'gdi32.GetBkColor', (('int', None),) ),
    'gdi32.getbkmode':( 'int', None, 'stdcall', 'gdi32.GetBkMode', (('int', None),) ),
    'gdi32.getboundsrect':( 'int', None, 'stdcall', 'gdi32.GetBoundsRect', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getbrushattributes':( 'int', None, 'stdcall', 'gdi32.GetBrushAttributes', (('int', None),) ),
    'gdi32.getbrushorgex':( 'int', None, 'stdcall', 'gdi32.GetBrushOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getcharabcwidthsa':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsfloata':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsFloatA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsfloatw':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsFloatW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsi':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsI', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsw':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidth32a':( 'int', None, 'stdcall', 'gdi32.GetCharWidth32A', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidth32w':( 'int', None, 'stdcall', 'gdi32.GetCharWidth32W', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidtha':( 'int', None, 'stdcall', 'gdi32.GetCharWidthA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthfloata':( 'int', None, 'stdcall', 'gdi32.GetCharWidthFloatA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthfloatw':( 'int', None, 'stdcall', 'gdi32.GetCharWidthFloatW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthi':( 'int', None, 'stdcall', 'gdi32.GetCharWidthI', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getcharwidthinfo':( 'int', None, 'stdcall', 'gdi32.GetCharWidthInfo', (('int', None), ('int', None)) ),
    'gdi32.getcharwidthw':( 'int', None, 'stdcall', 'gdi32.GetCharWidthW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharacterplacementa':( 'int', None, 'stdcall', 'gdi32.GetCharacterPlacementA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharacterplacementw':( 'int', None, 'stdcall', 'gdi32.GetCharacterPlacementW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getclipbox':( 'int', None, 'stdcall', 'gdi32.GetClipBox', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getcliprgn':( 'int', None, 'stdcall', 'gdi32.GetClipRgn', (('int', None), ('int', None)) ),
    'gdi32.getcoloradjustment':( 'int', None, 'stdcall', 'gdi32.GetColorAdjustment', (('int', None), ('int', None)) ),
    'gdi32.getcolorspace':( 'int', None, 'stdcall', 'gdi32.GetColorSpace', (('int', None),) ),
    'gdi32.getcurrentobject':( 'int', None, 'stdcall', 'gdi32.GetCurrentObject', (('int', None), ('int', None)) ),
    'gdi32.getcurrentpositionex':( 'int', None, 'stdcall', 'gdi32.GetCurrentPositionEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getdcbrushcolor':( 'int', None, 'stdcall', 'gdi32.GetDCBrushColor', (('int', None),) ),
    'gdi32.getdcorgex':( 'int', None, 'stdcall', 'gdi32.GetDCOrgEx', (('int', None), ('int', None)) ),
    'gdi32.getdcpencolor':( 'int', None, 'stdcall', 'gdi32.GetDCPenColor', (('int', None),) ),
    'gdi32.getdibcolortable':( 'int', None, 'stdcall', 'gdi32.GetDIBColorTable', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getdibits':( 'int', None, 'stdcall', 'gdi32.GetDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getdevicecaps':( 'int', None, 'stdcall', 'gdi32.GetDeviceCaps', (('int', None), ('int', None)) ),
    'gdi32.getdevicegammaramp':( 'int', None, 'stdcall', 'gdi32.GetDeviceGammaRamp', (('int', None), ('int', None)) ),
    'gdi32.getetm':( 'int', None, 'stdcall', 'gdi32.GetETM', (('int', None), ('void *', 'ptr')) ),
    'gdi32.geteudctimestamp':( 'int', None, 'cdecl', 'gdi32.GetEUDCTimeStamp', () ),
    'gdi32.geteudctimestampexw':( 'int', None, 'stdcall', 'gdi32.GetEUDCTimeStampExW', (('int', None),) ),
    'gdi32.getenhmetafilea':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileA', (('int', None),) ),
    'gdi32.getenhmetafilebits':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafiledescriptiona':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileDescriptionA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafiledescriptionw':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileDescriptionW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafileheader':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileHeader', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getenhmetafilepaletteentries':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFilePaletteEntries', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafilepixelformat':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFilePixelFormat', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getenhmetafilew':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileW', (('void *', 'ptr'),) ),
    'gdi32.getfontassocstatus':( 'int', None, 'stdcall', 'gdi32.GetFontAssocStatus', (('int', None),) ),
    'gdi32.getfontdata':( 'int', None, 'stdcall', 'gdi32.GetFontData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getfontlanguageinfo':( 'int', None, 'stdcall', 'gdi32.GetFontLanguageInfo', (('int', None),) ),
    'gdi32.getfontresourceinfow':( 'int', None, 'stdcall', 'gdi32.GetFontResourceInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getfontunicoderanges':( 'int', None, 'stdcall', 'gdi32.GetFontUnicodeRanges', (('int', None), ('int', None)) ),
    'gdi32.getglyphindicesa':( 'int', None, 'stdcall', 'gdi32.GetGlyphIndicesA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getglyphindicesw':( 'int', None, 'stdcall', 'gdi32.GetGlyphIndicesW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getglyphoutline':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutline', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinea':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinew':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinewow':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineWow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getgraphicsmode':( 'int', None, 'stdcall', 'gdi32.GetGraphicsMode', (('int', None),) ),
    'gdi32.gethfont':( 'int', None, 'stdcall', 'gdi32.GetHFONT', (('int', None),) ),
    'gdi32.geticmprofilea':( 'int', None, 'stdcall', 'gdi32.GetICMProfileA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.geticmprofilew':( 'int', None, 'stdcall', 'gdi32.GetICMProfileW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.getkerningpairs':( 'int', None, 'stdcall', 'gdi32.GetKerningPairs', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getkerningpairsa':( 'int', None, 'stdcall', 'gdi32.GetKerningPairsA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getkerningpairsw':( 'int', None, 'stdcall', 'gdi32.GetKerningPairsW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getlayout':( 'int', None, 'stdcall', 'gdi32.GetLayout', (('int', None),) ),
    'gdi32.getlogcolorspacea':( 'int', None, 'stdcall', 'gdi32.GetLogColorSpaceA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getlogcolorspacew':( 'int', None, 'stdcall', 'gdi32.GetLogColorSpaceW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getmapmode':( 'int', None, 'stdcall', 'gdi32.GetMapMode', (('int', None),) ),
    'gdi32.getmetafilea':( 'int', None, 'stdcall', 'gdi32.GetMetaFileA', (('int', None),) ),
    'gdi32.getmetafilebitsex':( 'int', None, 'stdcall', 'gdi32.GetMetaFileBitsEx', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getmetafilew':( 'int', None, 'stdcall', 'gdi32.GetMetaFileW', (('void *', 'ptr'),) ),
    'gdi32.getmetargn':( 'int', None, 'stdcall', 'gdi32.GetMetaRgn', (('int', None), ('int', None)) ),
    'gdi32.getmiterlimit':( 'int', None, 'stdcall', 'gdi32.GetMiterLimit', (('int', None), ('int', None)) ),
    'gdi32.getnearestcolor':( 'int', None, 'stdcall', 'gdi32.GetNearestColor', (('int', None), ('int', None)) ),
    'gdi32.getnearestpaletteindex':( 'int', None, 'stdcall', 'gdi32.GetNearestPaletteIndex', (('int', None), ('int', None)) ),
    'gdi32.getobjecta':( 'int', None, 'stdcall', 'gdi32.GetObjectA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getobjecttype':( 'int', None, 'stdcall', 'gdi32.GetObjectType', (('int', None),) ),
    'gdi32.getobjectw':( 'int', None, 'stdcall', 'gdi32.GetObjectW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getoutlinetextmetricsa':( 'int', None, 'stdcall', 'gdi32.GetOutlineTextMetricsA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getoutlinetextmetricsw':( 'int', None, 'stdcall', 'gdi32.GetOutlineTextMetricsW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpaletteentries':( 'int', None, 'stdcall', 'gdi32.GetPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpath':( 'int', None, 'stdcall', 'gdi32.GetPath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpixel':( 'int', None, 'stdcall', 'gdi32.GetPixel', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpixelformat':( 'int', None, 'stdcall', 'gdi32.GetPixelFormat', ( ('int', None),) ),
    'gdi32.getpolyfillmode':( 'int', None, 'stdcall', 'gdi32.GetPolyFillMode', (('int', None),) ),
    'gdi32.getrop2':( 'int', None, 'stdcall', 'gdi32.GetROP2', (('int', None),) ),
    'gdi32.getrandomrgn':( 'int', None, 'stdcall', 'gdi32.GetRandomRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getrasterizercaps':( 'int', None, 'stdcall', 'gdi32.GetRasterizerCaps', (('int', None), ('int', None)) ),
    'gdi32.getregiondata':( 'int', None, 'stdcall', 'gdi32.GetRegionData', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getrelabs':( 'int', None, 'stdcall', 'gdi32.GetRelAbs', (('int', None), ('int', None)) ),
    'gdi32.getrgnbox':( 'int', None, 'stdcall', 'gdi32.GetRgnBox', (('int', None), ('int', None)) ),
    'gdi32.getstockobject':( 'int', None, 'stdcall', 'gdi32.GetStockObject', (('int', None),) ),
    'gdi32.getstretchbltmode':( 'int', None, 'stdcall', 'gdi32.GetStretchBltMode', (('int', None),) ),
    'gdi32.getstringbitmapa':( 'int', None, 'stdcall', 'gdi32.GetStringBitmapA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getstringbitmapw':( 'int', None, 'stdcall', 'gdi32.GetStringBitmapW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getsystempaletteentries':( 'int', None, 'stdcall', 'gdi32.GetSystemPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getsystempaletteuse':( 'int', None, 'stdcall', 'gdi32.GetSystemPaletteUse', (('int', None),) ),
    'gdi32.gettextalign':( 'int', None, 'stdcall', 'gdi32.GetTextAlign', (('int', None),) ),
    'gdi32.gettextcharacterextra':( 'int', None, 'stdcall', 'gdi32.GetTextCharacterExtra', (('int', None),) ),
    'gdi32.gettextcharset':( 'int', None, 'stdcall', 'gdi32.GetTextCharset', (('int', None),) ),
    'gdi32.gettextcharsetinfo':( 'int', None, 'stdcall', 'gdi32.GetTextCharsetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextcolor':( 'int', None, 'stdcall', 'gdi32.GetTextColor', (('int', None),) ),
    'gdi32.gettextextentexpointa':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointi':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointI', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointw':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointwpri':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointWPri', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentpoint32a':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPoint32A', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpoint32w':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPoint32W', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpointa':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentpointi':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointI', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpointw':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextfacea':( 'int', None, 'stdcall', 'gdi32.GetTextFaceA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextfacealiasw':( 'int', None, 'stdcall', 'gdi32.GetTextFaceAliasW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextfacew':( 'int', None, 'stdcall', 'gdi32.GetTextFaceW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextmetricsa':( 'int', None, 'stdcall', 'gdi32.GetTextMetricsA', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextmetricsw':( 'int', None, 'stdcall', 'gdi32.GetTextMetricsW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gettransform':( 'int', None, 'stdcall', 'gdi32.GetTransform', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getviewportextex':( 'int', None, 'stdcall', 'gdi32.GetViewportExtEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getviewportorgex':( 'int', None, 'stdcall', 'gdi32.GetViewportOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getwinmetafilebits':( 'int', None, 'stdcall', 'gdi32.GetWinMetaFileBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getwindowextex':( 'int', None, 'stdcall', 'gdi32.GetWindowExtEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getwindoworgex':( 'int', None, 'stdcall', 'gdi32.GetWindowOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getworldtransform':( 'int', None, 'stdcall', 'gdi32.GetWorldTransform', (('int', None), ('void *', 'ptr')) ),
    'gdi32.ht_get8bppformatpalette':( 'int', None, 'stdcall', 'gdi32.HT_Get8BPPFormatPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ht_get8bppmaskpalette':( 'int', None, 'stdcall', 'gdi32.HT_Get8BPPMaskPalette', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.intersectcliprect':( 'int', None, 'stdcall', 'gdi32.IntersectClipRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.invertrgn':( 'int', None, 'stdcall', 'gdi32.InvertRgn', (('int', None), ('int', None)) ),
    'gdi32.isvalidenhmetarecord':( 'int', None, 'stdcall', 'gdi32.IsValidEnhMetaRecord', (('int', None), ('int', None)) ),
    'gdi32.isvalidenhmetarecordoffext':( 'int', None, 'stdcall', 'gdi32.IsValidEnhMetaRecordOffExt', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'gdi32.lptodp':( 'int', None, 'stdcall', 'gdi32.LPtoDP', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.linedda':( 'int', None, 'stdcall', 'gdi32.LineDDA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.lineto':( 'int', None, 'stdcall', 'gdi32.LineTo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.maskblt':( 'int', None, 'stdcall', 'gdi32.MaskBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.mirrorrgn':( 'int', None, 'stdcall', 'gdi32.MirrorRgn', (('int', None), ('int', None)) ),
    'gdi32.modifyworldtransform':( 'int', None, 'stdcall', 'gdi32.ModifyWorldTransform', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.movetoex':( 'int', None, 'stdcall', 'gdi32.MoveToEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.namedescape':( 'int', None, 'stdcall', 'gdi32.NamedEscape', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetcliprgn':( 'int', None, 'stdcall', 'gdi32.OffsetClipRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetrgn':( 'int', None, 'stdcall', 'gdi32.OffsetRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetviewportorgex':( 'int', None, 'stdcall', 'gdi32.OffsetViewportOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetwindoworgex':( 'int', None, 'stdcall', 'gdi32.OffsetWindowOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_benum':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_bEnum', (('int', None), ('int', None)) ),
    'gdi32.pathobj_benumcliplines':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_bEnumClipLines', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_venumstart':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vEnumStart', (('int', None),) ),
    'gdi32.pathobj_venumstartcliplines':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vEnumStartClipLines', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_vgetbounds':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vGetBounds', (('int', None), ('int', None)) ),
    'gdi32.paintrgn':( 'int', None, 'stdcall', 'gdi32.PaintRgn', (('int', None), ('int', None)) ),
    'gdi32.patblt':( 'int', None, 'stdcall', 'gdi32.PatBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathtoregion':( 'int', None, 'stdcall', 'gdi32.PathToRegion', (('int', None),) ),
    'gdi32.pie':( 'int', None, 'stdcall', 'gdi32.Pie', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.playenhmetafile':( 'int', None, 'stdcall', 'gdi32.PlayEnhMetaFile', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.playenhmetafilerecord':( 'int', None, 'stdcall', 'gdi32.PlayEnhMetaFileRecord', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.playmetafile':( 'int', None, 'stdcall', 'gdi32.PlayMetaFile', (('int', None), ('int', None)) ),
    'gdi32.playmetafilerecord':( 'int', None, 'stdcall', 'gdi32.PlayMetaFileRecord', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.plgblt':( 'int', None, 'stdcall', 'gdi32.PlgBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polybezier':( 'int', None, 'stdcall', 'gdi32.PolyBezier', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polybezierto':( 'int', None, 'stdcall', 'gdi32.PolyBezierTo', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polydraw':( 'int', None, 'stdcall', 'gdi32.PolyDraw', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypatblt':( 'int', None, 'stdcall', 'gdi32.PolyPatBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypolygon':( 'int', None, 'stdcall', 'gdi32.PolyPolygon', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypolyline':( 'int', None, 'stdcall', 'gdi32.PolyPolyline', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polytextouta':( 'int', None, 'stdcall', 'gdi32.PolyTextOutA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.polytextoutw':( 'int', None, 'stdcall', 'gdi32.PolyTextOutW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.polygon':( 'int', None, 'stdcall', 'gdi32.Polygon', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polyline':( 'int', None, 'stdcall', 'gdi32.Polyline', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polylineto':( 'int', None, 'stdcall', 'gdi32.PolylineTo', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ptinregion':( 'int', None, 'stdcall', 'gdi32.PtInRegion', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ptvisible':( 'int', None, 'stdcall', 'gdi32.PtVisible', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.queryfontassocstatus':( 'int', None, 'cdecl', 'gdi32.QueryFontAssocStatus', () ),
    'gdi32.realizepalette':( 'int', None, 'stdcall', 'gdi32.RealizePalette', (('int', None),) ),
    'gdi32.rectinregion':( 'int', None, 'stdcall', 'gdi32.RectInRegion', (('int', None), ('int', None)) ),
    'gdi32.rectvisible':( 'int', None, 'stdcall', 'gdi32.RectVisible', (('int', None), ('int', None)) ),
    'gdi32.rectangle':( 'int', None, 'stdcall', 'gdi32.Rectangle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontmemresourceex':( 'int', None, 'stdcall', 'gdi32.RemoveFontMemResourceEx', (('int', None),) ),
    'gdi32.removefontresourcea':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceA', (('int', None),) ),
    'gdi32.removefontresourceexa':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceExA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontresourceexw':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceExW', ( ('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontresourcetracking':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceTracking', ( ('int', None), ('int', None)) ),
    'gdi32.removefontresourcew':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceW', ( ('void *', 'ptr'),) ),
    'gdi32.resetdca':( 'int', None, 'stdcall', 'gdi32.ResetDCA', (('int', None), ('int', None)) ),
    'gdi32.resetdcw':( 'int', None, 'stdcall', 'gdi32.ResetDCW', (('int', None), ('int', None)) ),
    'gdi32.resizepalette':( 'int', None, 'stdcall', 'gdi32.ResizePalette', (('int', None), ('int', None)) ),
    'gdi32.restoredc':( 'int', None, 'stdcall', 'gdi32.RestoreDC', (('int', None), ('int', None)) ),
    'gdi32.roundrect':( 'int', None, 'stdcall', 'gdi32.RoundRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_benum':( 'int', None, 'stdcall', 'gdi32.STROBJ_bEnum', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_benumpositionsonly':( 'int', None, 'stdcall', 'gdi32.STROBJ_bEnumPositionsOnly', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_bgetadvancewidths':( 'int', None, 'stdcall', 'gdi32.STROBJ_bGetAdvanceWidths', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_dwgetcodepage':( 'int', None, 'stdcall', 'gdi32.STROBJ_dwGetCodePage', (('int', None),) ),
    'gdi32.strobj_venumstart':( 'int', None, 'stdcall', 'gdi32.STROBJ_vEnumStart', (('int', None),) ),
    'gdi32.savedc':( 'int', None, 'stdcall', 'gdi32.SaveDC', (('int', None),) ),
    'gdi32.scaleviewportextex':( 'int', None, 'stdcall', 'gdi32.ScaleViewportExtEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.scalewindowextex':( 'int', None, 'stdcall', 'gdi32.ScaleWindowExtEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.selectbrushlocal':( 'int', None, 'stdcall', 'gdi32.SelectBrushLocal', (('int', None), ('int', None)) ),
    'gdi32.selectclippath':( 'int', None, 'stdcall', 'gdi32.SelectClipPath', (('int', None), ('int', None)) ),
    'gdi32.selectcliprgn':( 'int', None, 'stdcall', 'gdi32.SelectClipRgn', (('int', None), ('int', None)) ),
    'gdi32.selectfontlocal':( 'int', None, 'stdcall', 'gdi32.SelectFontLocal', (('int', None), ('int', None)) ),
    'gdi32.selectobject':( 'int', None, 'stdcall', 'gdi32.SelectObject', (('int', None), ('int', None)) ),
    'gdi32.selectpalette':( 'int', None, 'stdcall', 'gdi32.SelectPalette', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setabortproc':( 'int', None, 'stdcall', 'gdi32.SetAbortProc', (('int', None), ('int', None)) ),
    'gdi32.setarcdirection':( 'int', None, 'stdcall', 'gdi32.SetArcDirection', (('int', None), ('int', None)) ),
    'gdi32.setbitmapattributes':( 'int', None, 'stdcall', 'gdi32.SetBitmapAttributes', (('int', None), ('int', None)) ),
    'gdi32.setbitmapbits':( 'int', None, 'stdcall', 'gdi32.SetBitmapBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbitmapdimensionex':( 'int', None, 'stdcall', 'gdi32.SetBitmapDimensionEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbkcolor':( 'int', None, 'stdcall', 'gdi32.SetBkColor', (('int', None), ('int', None)) ),
    'gdi32.setbkmode':( 'int', None, 'stdcall', 'gdi32.SetBkMode', (('int', None), ('int', None)) ),
    'gdi32.setboundsrect':( 'int', None, 'stdcall', 'gdi32.SetBoundsRect', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbrushattributes':( 'int', None, 'stdcall', 'gdi32.SetBrushAttributes', (('int', None), ('int', None)) ),
    'gdi32.setbrushorgex':( 'int', None, 'stdcall', 'gdi32.SetBrushOrgEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setcoloradjustment':( 'int', None, 'stdcall', 'gdi32.SetColorAdjustment', (('int', None), ('int', None)) ),
    'gdi32.setcolorspace':( 'int', None, 'stdcall', 'gdi32.SetColorSpace', (('int', None), ('int', None)) ),
    'gdi32.setdcbrushcolor':( 'int', None, 'stdcall', 'gdi32.SetDCBrushColor', (('int', None), ('int', None)) ),
    'gdi32.setdcpencolor':( 'int', None, 'stdcall', 'gdi32.SetDCPenColor', (('int', None), ('int', None)) ),
    'gdi32.setdibcolortable':( 'int', None, 'stdcall', 'gdi32.SetDIBColorTable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setdibits':( 'int', None, 'stdcall', 'gdi32.SetDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setdibitstodevice':( 'int', None, 'stdcall', 'gdi32.SetDIBitsToDevice', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.setdevicegammaramp':( 'int', None, 'stdcall', 'gdi32.SetDeviceGammaRamp', (('int', None), ('int', None)) ),
    'gdi32.setenhmetafilebits':( 'int', None, 'stdcall', 'gdi32.SetEnhMetaFileBits', (('int', None), ('int', None)) ),
    'gdi32.setfontenumeration':( 'int', None, 'stdcall', 'gdi32.SetFontEnumeration', (('int', None),) ),
    'gdi32.setgraphicsmode':( 'int', None, 'stdcall', 'gdi32.SetGraphicsMode', (('int', None), ('int', None)) ),
    'gdi32.seticmmode':( 'int', None, 'stdcall', 'gdi32.SetICMMode', (('int', None), ('int', None)) ),
    'gdi32.seticmprofilea':( 'int', None, 'stdcall', 'gdi32.SetICMProfileA', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.seticmprofilew':( 'int', None, 'stdcall', 'gdi32.SetICMProfileW', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.setlayout':( 'int', None, 'stdcall', 'gdi32.SetLayout', (('int', None), ('int', None)) ),
    'gdi32.setlayoutwidth':( 'int', None, 'stdcall', 'gdi32.SetLayoutWidth', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setmagiccolors':( 'int', None, 'stdcall', 'gdi32.SetMagicColors', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setmapmode':( 'int', None, 'stdcall', 'gdi32.SetMapMode', (('int', None), ('int', None)) ),
    'gdi32.setmapperflags':( 'int', None, 'stdcall', 'gdi32.SetMapperFlags', (('int', None), ('int', None)) ),
    'gdi32.setmetafilebitsex':( 'int', None, 'stdcall', 'gdi32.SetMetaFileBitsEx', (('int', None), ('int', None)) ),
    'gdi32.setmetargn':( 'int', None, 'stdcall', 'gdi32.SetMetaRgn', (('int', None),) ),
    'gdi32.setmiterlimit':( 'int', None, 'stdcall', 'gdi32.SetMiterLimit', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpaletteentries':( 'int', None, 'stdcall', 'gdi32.SetPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpixel':( 'int', None, 'stdcall', 'gdi32.SetPixel', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpixelformat':( 'int', None, 'stdcall', 'gdi32.SetPixelFormat', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setpixelv':( 'int', None, 'stdcall', 'gdi32.SetPixelV', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpolyfillmode':( 'int', None, 'stdcall', 'gdi32.SetPolyFillMode', (('int', None), ('int', None)) ),
    'gdi32.setrop2':( 'int', None, 'stdcall', 'gdi32.SetROP2', (('int', None), ('int', None)) ),
    'gdi32.setrectrgn':( 'int', None, 'stdcall', 'gdi32.SetRectRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setrelabs':( 'int', None, 'stdcall', 'gdi32.SetRelAbs', (('int', None), ('int', None)) ),
    'gdi32.setstretchbltmode':( 'int', None, 'stdcall', 'gdi32.SetStretchBltMode', (('int', None), ('int', None)) ),
    'gdi32.setsystempaletteuse':( 'int', None, 'stdcall', 'gdi32.SetSystemPaletteUse', (('int', None), ('int', None)) ),
    'gdi32.settextalign':( 'int', None, 'stdcall', 'gdi32.SetTextAlign', (('int', None), ('int', None)) ),
    'gdi32.settextcharacterextra':( 'int', None, 'stdcall', 'gdi32.SetTextCharacterExtra', (('int', None), ('int', None)) ),
    'gdi32.settextcolor':( 'int', None, 'stdcall', 'gdi32.SetTextColor', (('int', None), ('int', None)) ),
    'gdi32.settextjustification':( 'int', None, 'stdcall', 'gdi32.SetTextJustification', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setviewportextex':( 'int', None, 'stdcall', 'gdi32.SetViewportExtEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setviewportorgex':( 'int', None, 'stdcall', 'gdi32.SetViewportOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setvirtualresolution':( 'int', None, 'stdcall', 'gdi32.SetVirtualResolution', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setwinmetafilebits':( 'int', None, 'stdcall', 'gdi32.SetWinMetaFileBits', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setwindowextex':( 'int', None, 'stdcall', 'gdi32.SetWindowExtEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setwindoworgex':( 'int', None, 'stdcall', 'gdi32.SetWindowOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setworldtransform':( 'int', None, 'stdcall', 'gdi32.SetWorldTransform', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startdoca':( 'int', None, 'stdcall', 'gdi32.StartDocA', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startdocw':( 'int', None, 'stdcall', 'gdi32.StartDocW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startformpage':( 'int', None, 'stdcall', 'gdi32.StartFormPage', (('int', None),) ),
    'gdi32.startpage':( 'int', None, 'stdcall', 'gdi32.StartPage', (('int', None),) ),
    'gdi32.stretchblt':( 'int', None, 'stdcall', 'gdi32.StretchBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.stretchdibits':( 'int', None, 'stdcall', 'gdi32.StretchDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.strokeandfillpath':( 'int', None, 'stdcall', 'gdi32.StrokeAndFillPath', (('int', None),) ),
    'gdi32.strokepath':( 'int', None, 'stdcall', 'gdi32.StrokePath', (('int', None),) ),
    'gdi32.swapbuffers':( 'int', None, 'stdcall', 'gdi32.SwapBuffers', ( ('int', None),) ),
    'gdi32.textouta':( 'int', None, 'stdcall', 'gdi32.TextOutA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'gdi32.textoutw':( 'int', None, 'stdcall', 'gdi32.TextOutW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'gdi32.translatecharsetinfo':( 'int', None, 'stdcall', 'gdi32.TranslateCharsetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.unloadnetworkfonts':( 'int', None, 'stdcall', 'gdi32.UnloadNetworkFonts', ( ('int', None),) ),
    'gdi32.unrealizeobject':( 'int', None, 'stdcall', 'gdi32.UnrealizeObject', (('int', None),) ),
    'gdi32.updatecolors':( 'int', None, 'stdcall', 'gdi32.UpdateColors', (('int', None),) ),
    'gdi32.updateicmregkeya':( 'int', None, 'stdcall', 'gdi32.UpdateICMRegKeyA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.updateicmregkeyw':( 'int', None, 'stdcall', 'gdi32.UpdateICMRegKeyW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.widenpath':( 'int', None, 'stdcall', 'gdi32.WidenPath', (('int', None),) ),
    'gdi32.xformobj_bapplyxform':( 'int', None, 'stdcall', 'gdi32.XFORMOBJ_bApplyXform', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.xformobj_igetxform':( 'int', None, 'stdcall', 'gdi32.XFORMOBJ_iGetXform', (('int', None), ('int', None)) ),
    'gdi32.xlateobj_cgetpalette':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_cGetPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.xlateobj_hgetcolortransform':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_hGetColorTransform', (('int', None),) ),
    'gdi32.xlateobj_ixlate':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_iXlate', (('int', None), ('int', None)) ),
    'gdi32.xlateobj_pivector':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_piVector', (('int', None),) ),
    'gdi32.binitsystemandfontsdirectoriesw':( 'int', None, 'stdcall', 'gdi32.bInitSystemAndFontsDirectoriesW', (('int', None), ('int', None)) ),
    'gdi32.bmakepathnamew':( 'int', None, 'stdcall', 'gdi32.bMakePathNameW', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.cgetttffromfot':( 'int', None, 'stdcall', 'gdi32.cGetTTFFromFOT', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.gdiplayspoolstream':( 'int', None, 'stdcall', 'gdi32.gdiPlaySpoolStream', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),

    # OLE32
    'ole32.main_entry':( 'int', None, 'stdcall', 'ole32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ole32.bindmoniker':( 'int', None, 'stdcall', 'ole32.BindMoniker', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.clipformat_userfree':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserFree', (('int', None), ('int', None)) ),
    'ole32.clipformat_usermarshal':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clipformat_usersize':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clipformat_userunmarshal':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clsidfromole1class':( 'int', None, 'stdcall', 'ole32.CLSIDFromOle1Class', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.clsidfromprogid':( 'int', None, 'stdcall', 'ole32.CLSIDFromProgID', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.clsidfromprogidex':( 'int', None, 'stdcall', 'ole32.CLSIDFromProgIDEx', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.clsidfromstring':( 'int', None, 'stdcall', 'ole32.CLSIDFromString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.coaddrefserverprocess':( 'int', None, 'cdecl', 'ole32.CoAddRefServerProcess', () ),
    'ole32.coallowsetforegroundwindow':( 'int', None, 'stdcall', 'ole32.CoAllowSetForegroundWindow', (('int', None), ('int', None)) ),
    'ole32.cobuildversion':( 'int', None, 'cdecl', 'ole32.CoBuildVersion', () ),
    'ole32.cocancelcall':( 'int', None, 'stdcall', 'ole32.CoCancelCall', (('int', None), ('int', None)) ),
    'ole32.cocopyproxy':( 'int', None, 'stdcall', 'ole32.CoCopyProxy', (('int', None), ('void *', 'ptr')) ),
    'ole32.cocreatefreethreadedmarshaler':( 'int', None, 'stdcall', 'ole32.CoCreateFreeThreadedMarshaler', (('int', None), ('int', None)) ),
    'ole32.cocreateguid':( 'int', None, 'stdcall', 'ole32.CoCreateGuid', (('void *', 'ptr'),) ),
    'ole32.cocreateinstance':( 'int', None, 'stdcall', 'ole32.CoCreateInstance', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cocreateinstanceex':( 'int', None, 'stdcall', 'ole32.CoCreateInstanceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cocreateobjectincontext':( 'int', None, 'stdcall', 'ole32.CoCreateObjectInContext', (('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.codeactivateobject':( 'int', None, 'stdcall', 'ole32.CoDeactivateObject', (('int', None), ('int', None)) ),
    'ole32.codisablecallcancellation':( 'int', None, 'stdcall', 'ole32.CoDisableCallCancellation', (('int', None),) ),
    'ole32.codisconnectobject':( 'int', None, 'stdcall', 'ole32.CoDisconnectObject', ( ('int', None), ('int', None)) ),
    'ole32.codosdatetimetofiletime':( 'int', None, 'stdcall', 'ole32.CoDosDateTimeToFileTime', (('int', None), ('int', None), ('int', None)) ),
    'ole32.coenablecallcancellation':( 'int', None, 'stdcall', 'ole32.CoEnableCallCancellation', (('int', None),) ),
    'ole32.cofiletimenow':( 'int', None, 'stdcall', 'ole32.CoFileTimeNow', (('void *', 'ptr'),) ),
    'ole32.cofiletimetodosdatetime':( 'int', None, 'stdcall', 'ole32.CoFileTimeToDosDateTime', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cofreealllibraries':( 'int', None, 'cdecl', 'ole32.CoFreeAllLibraries', () ),
    'ole32.cofreelibrary':( 'int', None, 'cdecl', 'ole32.CoFreeLibrary', () ),
    'ole32.cofreeunusedlibraries':( 'int', None, 'cdecl', 'ole32.CoFreeUnusedLibraries', () ),
    'ole32.cofreeunusedlibrariesex':( 'int', None, 'stdcall', 'ole32.CoFreeUnusedLibrariesEx', (('int', None), ('int', None)) ),
    'ole32.cogetapartmentid':( 'int', None, 'stdcall', 'ole32.CoGetApartmentID', (('int', None), ('int', None)) ),
    'ole32.cogetcallcontext':( 'int', None, 'stdcall', 'ole32.CoGetCallContext', (('int', None), ('void *', 'ptr')) ),
    'ole32.cogetcallertid':( 'int', None, 'stdcall', 'ole32.CoGetCallerTID', (('int', None),) ),
    'ole32.cogetcancelobject':( 'int', None, 'stdcall', 'ole32.CoGetCancelObject', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetclassobject':( 'int', None, 'stdcall', 'ole32.CoGetClassObject', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetclassversion':( 'int', None, 'stdcall', 'ole32.CoGetClassVersion', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetcomcatalog':( 'int', None, 'stdcall', 'ole32.CoGetComCatalog', (('int', None), ('void *', 'ptr')) ),
    'ole32.cogetcontexttoken':( 'int', None, 'stdcall', 'ole32.CoGetContextToken', (('int', None),) ),
    'ole32.cogetcurrentlogicalthreadid':( 'int', None, 'stdcall', 'ole32.CoGetCurrentLogicalThreadId', (('int', None),) ),
    'ole32.cogetcurrentprocess':( 'int', None, 'cdecl', 'ole32.CoGetCurrentProcess', () ),
    'ole32.cogetdefaultcontext':( 'int', None, 'stdcall', 'ole32.CoGetDefaultContext', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinstancefromfile':( 'int', None, 'stdcall', 'ole32.CoGetInstanceFromFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('StringW', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinstancefromistorage':( 'int', None, 'stdcall', 'ole32.CoGetInstanceFromIStorage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinterceptor':( 'int', None, 'stdcall', 'ole32.CoGetInterceptor', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinterceptorfromtypeinfo':( 'int', None, 'stdcall', 'ole32.CoGetInterceptorFromTypeInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetinterfaceandreleasestream':( 'int', None, 'stdcall', 'ole32.CoGetInterfaceAndReleaseStream', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.cogetmalloc':( 'int', None, 'stdcall', 'ole32.CoGetMalloc', (('int', None), ('int', None)) ),
    'ole32.cogetmarshalsizemax':( 'int', None, 'stdcall', 'ole32.CoGetMarshalSizeMax', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.cogetobject':( 'int', None, 'stdcall', 'ole32.CoGetObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetobjectcontext':( 'int', None, 'stdcall', 'ole32.CoGetObjectContext', ( ('int', None), ('int', None)) ),
    'ole32.cogetpsclsid':( 'int', None, 'stdcall', 'ole32.CoGetPSClsid', ( ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetprocessidentifier':( 'int', None, 'stdcall', 'ole32.CoGetProcessIdentifier', (('int', None),) ),
    'ole32.cogetstandardmarshal':( 'int', None, 'stdcall', 'ole32.CoGetStandardMarshal', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetstate':( 'int', None, 'stdcall', 'ole32.CoGetState', (('int', None),) ),
    'ole32.cogetstdmarshalex':( 'int', None, 'stdcall', 'ole32.CoGetStdMarshalEx', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetsystemsecuritypermissions':( 'int', None, 'stdcall', 'ole32.CoGetSystemSecurityPermissions', (('DWORD', None), ('int', None)) ),
    'ole32.cogettreatasclass':( 'int', None, 'stdcall', 'ole32.CoGetTreatAsClass', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.coimpersonateclient':( 'int', None, 'stdcall', 'ole32.CoImpersonateClient', () ),
    'ole32.coinitialize':( 'int', None, 'stdcall', 'ole32.CoInitialize', (('int', None),) ),
    'ole32.coinitializeex':( 'int', None, 'stdcall', 'ole32.CoInitializeEx', (('int', None), ('int', None)) ),
    'ole32.coinitializesecurity':( 'int', None, 'stdcall', 'ole32.CoInitializeSecurity', (('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coinitializewow':( 'int', None, 'stdcall', 'ole32.CoInitializeWOW', (('int', None), ('int', None)) ),
    'ole32.coinstall':( 'int', None, 'stdcall', 'ole32.CoInstall', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coinvalidateremotemachinebindings':( 'int', None, 'stdcall', 'ole32.CoInvalidateRemoteMachineBindings', (('int', None),) ),
    'ole32.coishandlerconnected':( 'int', None, 'stdcall', 'ole32.CoIsHandlerConnected', (('int', None),) ),
    'ole32.coisole1class':( 'int', None, 'stdcall', 'ole32.CoIsOle1Class', (('void *', 'ptr'),) ),
    'ole32.coloadlibrary':( 'int', None, 'stdcall', 'ole32.CoLoadLibrary', (('int', None), ('int', None)) ),
    'ole32.colockobjectexternal':( 'int', None, 'stdcall', 'ole32.CoLockObjectExternal', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.comarshalhresult':( 'int', None, 'stdcall', 'ole32.CoMarshalHresult', (('int', None), ('int', None)) ),
    'ole32.comarshalinterthreadinterfaceinstream':( 'int', None, 'stdcall', 'ole32.CoMarshalInterThreadInterfaceInStream', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.comarshalinterface':( 'int', None, 'stdcall', 'ole32.CoMarshalInterface', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.copopservicedomain':( 'int', None, 'stdcall', 'ole32.CoPopServiceDomain', (('int', None),) ),
    'ole32.copushservicedomain':( 'int', None, 'stdcall', 'ole32.CoPushServiceDomain', (('int', None),) ),
    'ole32.coqueryauthenticationservices':( 'int', None, 'stdcall', 'ole32.CoQueryAuthenticationServices', (('int', None), ('int', None)) ),
    'ole32.coqueryclientblanket':( 'int', None, 'stdcall', 'ole32.CoQueryClientBlanket', ( ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.coqueryproxyblanket':( 'int', None, 'stdcall', 'ole32.CoQueryProxyBlanket', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coqueryreleaseobject':( 'int', None, 'stdcall', 'ole32.CoQueryReleaseObject', (('int', None),) ),
    'ole32.coreactivateobject':( 'int', None, 'stdcall', 'ole32.CoReactivateObject', ( ('int', None),) ),
    'ole32.coregisterchannelhook':( 'int', None, 'stdcall', 'ole32.CoRegisterChannelHook', (('int', None), ('int', None)) ),
    'ole32.coregisterclassobject':( 'int', None, 'stdcall', 'ole32.CoRegisterClassObject', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coregisterinitializespy':( 'int', None, 'stdcall', 'ole32.CoRegisterInitializeSpy', (('int', None), ('int', None)) ),
    'ole32.coregistermallocspy':( 'int', None, 'stdcall', 'ole32.CoRegisterMallocSpy', ( ('int', None),) ),
    'ole32.coregistermessagefilter':( 'int', None, 'stdcall', 'ole32.CoRegisterMessageFilter', (('int', None), ('int', None)) ),
    'ole32.coregisterpsclsid':( 'int', None, 'stdcall', 'ole32.CoRegisterPSClsid', ( ('void *', 'ptr'), ('int', None)) ),
    'ole32.coregistersurrogate':( 'int', None, 'stdcall', 'ole32.CoRegisterSurrogate', (('int', None),) ),
    'ole32.coregistersurrogateex':( 'int', None, 'stdcall', 'ole32.CoRegisterSurrogateEx', ( ('int', None), ('int', None)) ),
    'ole32.coreleasemarshaldata':( 'int', None, 'stdcall', 'ole32.CoReleaseMarshalData', ( ('void *', 'ptr'),) ),
    'ole32.coreleaseserverprocess':( 'int', None, 'cdecl', 'ole32.CoReleaseServerProcess', () ),
    'ole32.coresumeclassobjects':( 'int', None, 'cdecl', 'ole32.CoResumeClassObjects', () ),
    'ole32.coretireserver':( 'int', None, 'stdcall', 'ole32.CoRetireServer', (('int', None),) ),
    'ole32.coreverttoself':( 'int', None, 'stdcall', 'ole32.CoRevertToSelf', () ),
    'ole32.corevokeclassobject':( 'int', None, 'stdcall', 'ole32.CoRevokeClassObject', (('int', None),) ),
    'ole32.corevokeinitializespy':( 'int', None, 'stdcall', 'ole32.CoRevokeInitializeSpy', (('int', None), ('int', None)) ),
    'ole32.corevokemallocspy':( 'int', None, 'cdecl', 'ole32.CoRevokeMallocSpy', () ),
    'ole32.cosetcancelobject':( 'int', None, 'stdcall', 'ole32.CoSetCancelObject', (('int', None),) ),
    'ole32.cosetproxyblanket':( 'int', None, 'stdcall', 'ole32.CoSetProxyBlanket', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cosetstate':( 'int', None, 'stdcall', 'ole32.CoSetState', (('int', None),) ),
    'ole32.cosuspendclassobjects':( 'int', None, 'cdecl', 'ole32.CoSuspendClassObjects', () ),
    'ole32.coswitchcallcontext':( 'int', None, 'stdcall', 'ole32.CoSwitchCallContext', (('int', None), ('int', None)) ),
    'ole32.cotaskmemalloc':( 'int', None, 'stdcall', 'ole32.CoTaskMemAlloc', (('int', None),) ),
    'ole32.cotaskmemfree':( 'int', None, 'stdcall', 'ole32.CoTaskMemFree', (('void *', 'ptr'),) ),
    'ole32.cotaskmemrealloc':( 'int', None, 'stdcall', 'ole32.CoTaskMemRealloc', (('int', None), ('int', None)) ),
    'ole32.cotestcancel':( 'int', None, 'stdcall', 'ole32.CoTestCancel', () ),
    'ole32.cotreatasclass':( 'int', None, 'stdcall', 'ole32.CoTreatAsClass', (('int', None), ('void *', 'ptr')) ),
    'ole32.couninitialize':( 'int', None, 'cdecl', 'ole32.CoUninitialize', () ),
    'ole32.counloadingwow':( 'int', None, 'stdcall', 'ole32.CoUnloadingWOW', (('int', None),) ),
    'ole32.counmarshalhresult':( 'int', None, 'stdcall', 'ole32.CoUnmarshalHresult', (('int', None), ('int', None)) ),
    'ole32.counmarshalinterface':( 'int', None, 'stdcall', 'ole32.CoUnmarshalInterface', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.cowaitformultiplehandles':( 'int', None, 'stdcall', 'ole32.CoWaitForMultipleHandles', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.comps_cstdstubbuffer_addref':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_AddRef', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_connect':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Connect', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_countrefs':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_CountRefs', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_debugserverqueryinterface':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_DebugServerQueryInterface', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_debugserverrelease':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_DebugServerRelease', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_disconnect':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Disconnect', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_invoke':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Invoke', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_isiidsupported':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_IsIIDSupported', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_queryinterface':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_QueryInterface', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_iunknown_addref_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_AddRef_Proxy', (('int', None),) ),
    'ole32.comps_iunknown_queryinterface_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_QueryInterface_Proxy', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_iunknown_release_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_Release_Proxy', (('int', None),) ),
    'ole32.comps_ndrcstdstubbuffer2_release':( 'int', None, 'stdcall', 'ole32.ComPs_NdrCStdStubBuffer2_Release', (('int', None), ('int', None)) ),
    'ole32.comps_ndrcstdstubbuffer_release':( 'int', None, 'stdcall', 'ole32.ComPs_NdrCStdStubBuffer_Release', (('int', None), ('int', None)) ),
    'ole32.comps_ndrclientcall2':( 'int', None, 'cdecl', 'ole32.ComPs_NdrClientCall2', (('int', None), ('int', None)) ),
    'ole32.comps_ndrclientcall2_va':( 'int', None, 'stdcall', 'ole32.ComPs_NdrClientCall2_va', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllcanunloadnow':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllCanUnloadNow', (('int', None),) ),
    'ole32.comps_ndrdllgetclassobject':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllGetClassObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllregisterproxy':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllRegisterProxy', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllunregisterproxy':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllUnregisterProxy', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrstubcall2':( 'int', None, 'stdcall', 'ole32.ComPs_NdrStubCall2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrstubforwardingfunction':( 'int', None, 'stdcall', 'ole32.ComPs_NdrStubForwardingFunction', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.createantimoniker':( 'int', None, 'stdcall', 'ole32.CreateAntiMoniker', (('int', None),) ),
    'ole32.createbindctx':( 'int', None, 'stdcall', 'ole32.CreateBindCtx', (('int', None), ('void *', 'ptr')) ),
    'ole32.createclassmoniker':( 'int', None, 'stdcall', 'ole32.CreateClassMoniker', (('int', None), ('int', None)) ),
    'ole32.createdataadviseholder':( 'int', None, 'stdcall', 'ole32.CreateDataAdviseHolder', (('int', None),) ),
    'ole32.createdatacache':( 'int', None, 'stdcall', 'ole32.CreateDataCache', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.createerrorinfo':( 'int', None, 'stdcall', 'ole32.CreateErrorInfo', (('int', None),) ),
    'ole32.createfilemoniker':( 'int', None, 'stdcall', 'ole32.CreateFileMoniker', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.creategenericcomposite':( 'int', None, 'stdcall', 'ole32.CreateGenericComposite', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.createilockbytesonhglobal':( 'int', None, 'stdcall', 'ole32.CreateILockBytesOnHGlobal', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.createitemmoniker':( 'int', None, 'stdcall', 'ole32.CreateItemMoniker', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.createobjrefmoniker':( 'int', None, 'stdcall', 'ole32.CreateObjrefMoniker', (('int', None), ('int', None)) ),
    'ole32.createoleadviseholder':( 'int', None, 'stdcall', 'ole32.CreateOleAdviseHolder', (('int', None),) ),
    'ole32.createpointermoniker':( 'int', None, 'stdcall', 'ole32.CreatePointerMoniker', (('int', None), ('int', None)) ),
    'ole32.createstdprogressindicator':( 'int', None, 'stdcall', 'ole32.CreateStdProgressIndicator', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.createstreamonhglobal':( 'int', None, 'stdcall', 'ole32.CreateStreamOnHGlobal', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.dcomchannelsethresult':( 'int', None, 'stdcall', 'ole32.DcomChannelSetHResult', (('int', None), ('int', None), ('int', None)) ),
    'ole32.dlldebugobjectrpchook':( 'int', None, 'stdcall', 'ole32.DllDebugObjectRPCHook', (('int', None), ('int', None)) ),
    'ole32.dllgetclassobject':( 'int', None, 'stdcall', 'ole32.DllGetClassObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.dllgetclassobjectwow':( 'int', None, 'stdcall', 'ole32.DllGetClassObjectWOW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.dllregisterserver':( 'int', None, 'stdcall', 'ole32.DllRegisterServer', () ),
    'ole32.dodragdrop':( 'int', None, 'stdcall', 'ole32.DoDragDrop', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.enablehookobject':( 'int', None, 'stdcall', 'ole32.EnableHookObject', (('int', None), ('int', None)) ),
    'ole32.fmtidtopropstgname':( 'int', None, 'stdcall', 'ole32.FmtIdToPropStgName', (('int', None), ('int', None)) ),
    'ole32.freepropvariantarray':( 'int', None, 'stdcall', 'ole32.FreePropVariantArray', (('int', None), ('int', None)) ),
    'ole32.getclassfile':( 'int', None, 'stdcall', 'ole32.GetClassFile', (('StringW', None), ('void *', 'ptr')) ),
    'ole32.getconvertstg':( 'int', None, 'stdcall', 'ole32.GetConvertStg', (('int', None),) ),
    'ole32.getdocumentbitstg':( 'int', None, 'stdcall', 'ole32.GetDocumentBitStg', (('int', None),) ),
    'ole32.geterrorinfo':( 'int', None, 'stdcall', 'ole32.GetErrorInfo', (('int', None), ('int', None)) ),
    'ole32.gethglobalfromilockbytes':( 'int', None, 'stdcall', 'ole32.GetHGlobalFromILockBytes', (('int', None), ('void *', 'ptr')) ),
    'ole32.gethglobalfromstream':( 'int', None, 'stdcall', 'ole32.GetHGlobalFromStream', (('int', None), ('void *', 'ptr')) ),
    'ole32.gethookinterface':( 'int', None, 'stdcall', 'ole32.GetHookInterface', (('int', None),) ),
    'ole32.getrunningobjecttable':( 'int', None, 'stdcall', 'ole32.GetRunningObjectTable', (('int', None), ('void *', 'ptr')) ),
    'ole32.haccel_userfree':( 'int', None, 'stdcall', 'ole32.HACCEL_UserFree', (('int', None), ('int', None)) ),
    'ole32.haccel_usermarshal':( 'int', None, 'stdcall', 'ole32.HACCEL_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.haccel_usersize':( 'int', None, 'stdcall', 'ole32.HACCEL_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.haccel_userunmarshal':( 'int', None, 'stdcall', 'ole32.HACCEL_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_userfree':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserFree', (('int', None), ('int', None)) ),
    'ole32.hbitmap_usermarshal':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_usersize':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_userunmarshal':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_userfree':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserFree', (('int', None), ('int', None)) ),
    'ole32.hbrush_usermarshal':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_usersize':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_userunmarshal':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_userfree':( 'int', None, 'stdcall', 'ole32.HDC_UserFree', (('int', None), ('int', None)) ),
    'ole32.hdc_usermarshal':( 'int', None, 'stdcall', 'ole32.HDC_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_usersize':( 'int', None, 'stdcall', 'ole32.HDC_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_userunmarshal':( 'int', None, 'stdcall', 'ole32.HDC_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_userfree':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserFree', (('int', None), ('int', None)) ),
    'ole32.henhmetafile_usermarshal':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_usersize':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_userunmarshal':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_userfree':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserFree', (('int', None), ('int', None)) ),
    'ole32.hglobal_usermarshal':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_usersize':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_userunmarshal':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_userfree':( 'int', None, 'stdcall', 'ole32.HICON_UserFree', (('int', None), ('int', None)) ),
    'ole32.hicon_usermarshal':( 'int', None, 'stdcall', 'ole32.HICON_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_usersize':( 'int', None, 'stdcall', 'ole32.HICON_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_userunmarshal':( 'int', None, 'stdcall', 'ole32.HICON_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_userfree':( 'int', None, 'stdcall', 'ole32.HMENU_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmenu_usermarshal':( 'int', None, 'stdcall', 'ole32.HMENU_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_usersize':( 'int', None, 'stdcall', 'ole32.HMENU_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMENU_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_userfree':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmetafilepict_usermarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_usersize':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_userfree':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmetafile_usermarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_usersize':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserUnmarshal', (('int', None), ('int', None)) ),
    'ole32.hpalette_userfree':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserFree', (('int', None), ('int', None)) ),
    'ole32.hpalette_usermarshal':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hpalette_usersize':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hpalette_userunmarshal':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_userfree':( 'int', None, 'stdcall', 'ole32.HWND_UserFree', (('int', None), ('int', None)) ),
    'ole32.hwnd_usermarshal':( 'int', None, 'stdcall', 'ole32.HWND_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_usersize':( 'int', None, 'stdcall', 'ole32.HWND_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_userunmarshal':( 'int', None, 'stdcall', 'ole32.HWND_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hkoleregisterobject':( 'int', None, 'stdcall', 'ole32.HkOleRegisterObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.iidfromstring':( 'int', None, 'stdcall', 'ole32.IIDFromString', (('int', None), ('int', None)) ),
    'ole32.isaccelerator':( 'int', None, 'stdcall', 'ole32.IsAccelerator', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'ole32.isequalguid':( 'int', None, 'stdcall', 'ole32.IsEqualGUID', (('int', None), ('int', None)) ),
    'ole32.isvalidiid':( 'int', None, 'stdcall', 'ole32.IsValidIid', (('int', None),) ),
    'ole32.isvalidinterface':( 'int', None, 'stdcall', 'ole32.IsValidInterface', (('int', None),) ),
    'ole32.isvalidptrin':( 'int', None, 'stdcall', 'ole32.IsValidPtrIn', (('int', None), ('int', None)) ),
    'ole32.isvalidptrout':( 'int', None, 'stdcall', 'ole32.IsValidPtrOut', (('int', None), ('int', None)) ),
    'ole32.mkparsedisplayname':( 'int', None, 'stdcall', 'ole32.MkParseDisplayName', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.monikercommonprefixwith':( 'int', None, 'stdcall', 'ole32.MonikerCommonPrefixWith', (('int', None), ('int', None), ('int', None)) ),
    'ole32.monikerrelativepathto':( 'int', None, 'stdcall', 'ole32.MonikerRelativePathTo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.olebuildversion':( 'int', None, 'cdecl', 'ole32.OleBuildVersion', () ),
    'ole32.oleconvertistoragetoolestream':( 'int', None, 'stdcall', 'ole32.OleConvertIStorageToOLESTREAM', (('int', None), ('int', None)) ),
    'ole32.oleconvertistoragetoolestreamex':( 'int', None, 'stdcall', 'ole32.OleConvertIStorageToOLESTREAMEx', (('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None)) ),
    'ole32.oleconvertolestreamtoistorage':( 'int', None, 'stdcall', 'ole32.OleConvertOLESTREAMToIStorage', (('int', None), ('int', None), ('int', None)) ),
    'ole32.oleconvertolestreamtoistorageex':( 'int', None, 'stdcall', 'ole32.OleConvertOLESTREAMToIStorageEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreate':( 'int', None, 'stdcall', 'ole32.OleCreate', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreatedefaulthandler':( 'int', None, 'stdcall', 'ole32.OleCreateDefaultHandler', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreateembeddinghelper':( 'int', None, 'stdcall', 'ole32.OleCreateEmbeddingHelper', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreateex':( 'int', None, 'stdcall', 'ole32.OleCreateEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreatefromdata':( 'int', None, 'stdcall', 'ole32.OleCreateFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromdataex':( 'int', None, 'stdcall', 'ole32.OleCreateFromDataEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromfile':( 'int', None, 'stdcall', 'ole32.OleCreateFromFile', (('void *', 'ptr'), ('StringW', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromfileex':( 'int', None, 'stdcall', 'ole32.OleCreateFromFileEx', ( ('void *', 'ptr'), ('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelink':( 'int', None, 'stdcall', 'ole32.OleCreateLink', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkfromdata':( 'int', None, 'stdcall', 'ole32.OleCreateLinkFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkfromdataex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkFromDataEx', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinktofile':( 'int', None, 'stdcall', 'ole32.OleCreateLinkToFile', (('StringW', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinktofileex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkToFileEx', ( ('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatemenudescriptor':( 'int', None, 'stdcall', 'ole32.OleCreateMenuDescriptor', (('int', None), ('int', None)) ),
    'ole32.olecreatestaticfromdata':( 'int', None, 'stdcall', 'ole32.OleCreateStaticFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oledestroymenudescriptor':( 'int', None, 'stdcall', 'ole32.OleDestroyMenuDescriptor', (('void *', 'ptr'),) ),
    'ole32.oledoautoconvert':( 'int', None, 'msfastcall', 'ole32.OleDoAutoConvert', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.oledraw':( 'int', None, 'stdcall', 'ole32.OleDraw', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oleduplicatedata':( 'int', None, 'stdcall', 'ole32.OleDuplicateData', (('int', None), ('int', None), ('int', None)) ),
    'ole32.oleflushclipboard':( 'int', None, 'cdecl', 'ole32.OleFlushClipboard', () ),
    'ole32.olegetautoconvert':( 'int', None, 'stdcall', 'ole32.OleGetAutoConvert', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.olegetclipboard':( 'int', None, 'stdcall', 'ole32.OleGetClipboard', (('int', None),) ),
    'ole32.olegeticonofclass':( 'int', None, 'stdcall', 'ole32.OleGetIconOfClass', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.olegeticonoffile':( 'int', None, 'stdcall', 'ole32.OleGetIconOfFile', (('StringW', None), ('int', None)) ),
    'ole32.oleinitialize':( 'int', None, 'stdcall', 'ole32.OleInitialize', (('int', None),) ),
    'ole32.oleinitializewow':( 'int', None, 'stdcall', 'ole32.OleInitializeWOW', (('int', None), ('int', None)) ),
    'ole32.oleiscurrentclipboard':( 'int', None, 'stdcall', 'ole32.OleIsCurrentClipboard', (('int', None),) ),
    'ole32.oleisrunning':( 'int', None, 'stdcall', 'ole32.OleIsRunning', (('int', None),) ),
    'ole32.oleload':( 'int', None, 'msfastcall', 'ole32.OleLoad', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oleloadfromstream':( 'int', None, 'stdcall', 'ole32.OleLoadFromStream', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.olelockrunning':( 'int', None, 'stdcall', 'ole32.OleLockRunning', (('int', None), ('int', None), ('int', None)) ),
    'ole32.olemetafilepictfromiconandlabel':( 'int', None, 'stdcall', 'ole32.OleMetafilePictFromIconAndLabel', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ole32.olenoteobjectvisible':( 'int', None, 'stdcall', 'ole32.OleNoteObjectVisible', ( ('int', None), ('int', None)) ),
    'ole32.olequerycreatefromdata':( 'int', None, 'stdcall', 'ole32.OleQueryCreateFromData', (('int', None),) ),
    'ole32.olequerylinkfromdata':( 'int', None, 'stdcall', 'ole32.OleQueryLinkFromData', (('int', None),) ),
    'ole32.oleregenumformatetc':( 'int', None, 'stdcall', 'ole32.OleRegEnumFormatEtc', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.oleregenumverbs':( 'int', None, 'stdcall', 'ole32.OleRegEnumVerbs', (('void *', 'ptr'), ('int', None)) ),
    'ole32.olereggetmiscstatus':( 'int', None, 'stdcall', 'ole32.OleRegGetMiscStatus', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.olereggetusertype':( 'int', None, 'stdcall', 'ole32.OleRegGetUserType', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.olerun':( 'int', None, 'stdcall', 'ole32.OleRun', (('int', None),) ),
    'ole32.olesave':( 'int', None, 'stdcall', 'ole32.OleSave', (('int', None), ('int', None), ('int', None)) ),
    'ole32.olesavetostream':( 'int', None, 'stdcall', 'ole32.OleSaveToStream', (('int', None), ('int', None)) ),
    'ole32.olesetautoconvert':( 'int', None, 'stdcall', 'ole32.OleSetAutoConvert', (('void *', 'ptr'), ('int', None)) ),
    'ole32.olesetclipboard':( 'int', None, 'stdcall', 'ole32.OleSetClipboard', ( ('int', None),) ),
    'ole32.olesetcontainedobject':( 'int', None, 'stdcall', 'ole32.OleSetContainedObject', (('int', None), ('int', None)) ),
    'ole32.olesetmenudescriptor':( 'int', None, 'stdcall', 'ole32.OleSetMenuDescriptor', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oletranslateaccelerator':( 'int', None, 'stdcall', 'ole32.OleTranslateAccelerator', (('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.oleuninitialize':( 'int', None, 'cdecl', 'ole32.OleUninitialize', () ),
    'ole32.openorcreatestream':( 'int', None, 'stdcall', 'ole32.OpenOrCreateStream', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.progidfromclsid':( 'int', None, 'stdcall', 'ole32.ProgIDFromCLSID', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.propstgnametofmtid':( 'int', None, 'stdcall', 'ole32.PropStgNameToFmtId', (('int', None), ('int', None)) ),
    'ole32.propsysallocstring':( 'int', None, 'stdcall', 'ole32.PropSysAllocString', (('void *', 'ptr'),) ),
    'ole32.propsysfreestring':( 'int', None, 'stdcall', 'ole32.PropSysFreeString', (('int', None),) ),
    'ole32.propvariantchangetype':( 'int', None, 'stdcall', 'ole32.PropVariantChangeType', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.propvariantclear':( 'int', None, 'stdcall', 'ole32.PropVariantClear', (('void *', 'ptr'),) ),
    'ole32.propvariantcopy':( 'int', None, 'stdcall', 'ole32.PropVariantCopy', (('void *', 'ptr'), ('int', None)) ),
    'ole32.readclassstg':( 'int', None, 'stdcall', 'ole32.ReadClassStg', (('int', None), ('void *', 'ptr')) ),
    'ole32.readclassstm':( 'int', None, 'stdcall', 'ole32.ReadClassStm', (('int', None), ('void *', 'ptr')) ),
    'ole32.readfmtusertypestg':( 'int', None, 'stdcall', 'ole32.ReadFmtUserTypeStg', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.readolestg':( 'int', None, 'stdcall', 'ole32.ReadOleStg', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.readstringstream':( 'int', None, 'stdcall', 'ole32.ReadStringStream', ( ('void *', 'ptr'),) ),
    'ole32.registerdragdrop':( 'int', None, 'stdcall', 'ole32.RegisterDragDrop', (('int', None), ('int', None)) ),
    'ole32.releasestgmedium':( 'int', None, 'stdcall', 'ole32.ReleaseStgMedium', (('void *', 'ptr'),) ),
    'ole32.revokedragdrop':( 'int', None, 'stdcall', 'ole32.RevokeDragDrop', (('int', None),) ),
    'ole32.snb_userfree':( 'int', None, 'stdcall', 'ole32.SNB_UserFree', (('int', None), ('int', None)) ),
    'ole32.snb_usermarshal':( 'int', None, 'stdcall', 'ole32.SNB_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.snb_usersize':( 'int', None, 'stdcall', 'ole32.SNB_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.snb_userunmarshal':( 'int', None, 'stdcall', 'ole32.SNB_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_userfree':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserFree', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.stgmedium_usermarshal':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_usersize':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_userunmarshal':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.setconvertstg':( 'int', None, 'msfastcall', 'ole32.SetConvertStg', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.setdocumentbitstg':( 'int', None, 'msfastcall', 'ole32.SetDocumentBitStg', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.seterrorinfo':( 'int', None, 'stdcall', 'ole32.SetErrorInfo', (('int', None), ('int', None)) ),
    'ole32.stgconvertpropertytovariant':( 'int', None, 'stdcall', 'ole32.StgConvertPropertyToVariant', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgconvertvarianttoproperty':( 'int', None, 'stdcall', 'ole32.StgConvertVariantToProperty', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatedocfile':( 'int', None, 'stdcall', 'ole32.StgCreateDocfile', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatedocfileonilockbytes':( 'int', None, 'stdcall', 'ole32.StgCreateDocfileOnILockBytes', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.stgcreatepropsetstg':( 'int', None, 'stdcall', 'ole32.StgCreatePropSetStg', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatepropstg':( 'int', None, 'stdcall', 'ole32.StgCreatePropStg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatestorageex':( 'int', None, 'stdcall', 'ole32.StgCreateStorageEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stggetifilllockbytesonfile':( 'int', None, 'stdcall', 'ole32.StgGetIFillLockBytesOnFile', ( ('int', None), ('int', None)) ),
    'ole32.stggetifilllockbytesonilockbytes':( 'int', None, 'stdcall', 'ole32.StgGetIFillLockBytesOnILockBytes', (('int', None), ('int', None)) ),
    'ole32.stgisstoragefile':( 'int', None, 'stdcall', 'ole32.StgIsStorageFile', (('StringW', None),) ),
    'ole32.stgisstorageilockbytes':( 'int', None, 'stdcall', 'ole32.StgIsStorageILockBytes', (('int', None),) ),
    'ole32.stgopenasyncdocfileonifilllockbytes':( 'int', None, 'stdcall', 'ole32.StgOpenAsyncDocfileOnIFillLockBytes', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenpropstg':( 'int', None, 'stdcall', 'ole32.StgOpenPropStg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorage':( 'int', None, 'stdcall', 'ole32.StgOpenStorage', (('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageex':( 'int', None, 'stdcall', 'ole32.StgOpenStorageEx', (('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageonhandle':( 'int', None, 'stdcall', 'ole32.StgOpenStorageOnHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageonilockbytes':( 'int', None, 'stdcall', 'ole32.StgOpenStorageOnILockBytes', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.stgpropertylengthasvariant':( 'int', None, 'stdcall', 'ole32.StgPropertyLengthAsVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgsettimes':( 'int', None, 'stdcall', 'ole32.StgSetTimes', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stringfromclsid':( 'int', None, 'stdcall', 'ole32.StringFromCLSID', (('int', None), ('void *', 'ptr')) ),
    'ole32.stringfromguid2':( 'int', None, 'stdcall', 'ole32.StringFromGUID2', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.stringfromiid':( 'int', None, 'stdcall', 'ole32.StringFromIID', (('int', None), ('int', None)) ),
    'ole32.updatedcomsettings':( 'int', None, 'cdecl', 'ole32.UpdateDCOMSettings', () ),
    'ole32.utconvertdvtd16todvtd32':( 'int', None, 'stdcall', 'ole32.UtConvertDvtd16toDvtd32', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.utconvertdvtd32todvtd16':( 'int', None, 'stdcall', 'ole32.UtConvertDvtd32toDvtd16', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.utgetdvtd16info':( 'int', None, 'stdcall', 'ole32.UtGetDvtd16Info', (('int', None), ('void *', 'ptr')) ),
    'ole32.utgetdvtd32info':( 'int', None, 'stdcall', 'ole32.UtGetDvtd32Info', (('int', None), ('void *', 'ptr')) ),
    'ole32.wdtpinterfacepointer_userfree':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserFree', (('int', None),) ),
    'ole32.wdtpinterfacepointer_usermarshal':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.wdtpinterfacepointer_usersize':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserSize', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.wdtpinterfacepointer_userunmarshal':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserUnmarshal', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.writeclassstg':( 'int', None, 'stdcall', 'ole32.WriteClassStg', (('int', None), ('void *', 'ptr')) ),
    'ole32.writeclassstm':( 'int', None, 'stdcall', 'ole32.WriteClassStm', (('int', None), ('void *', 'ptr')) ),
    'ole32.writefmtusertypestg':( 'int', None, 'stdcall', 'ole32.WriteFmtUserTypeStg', (('int', None), ('int', None), ('int', None)) ),
    'ole32.writeolestg':( 'int', None, 'stdcall', 'ole32.WriteOleStg', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.writestringstream':( 'int', None, 'stdcall', 'ole32.WriteStringStream', ( ('void *', 'ptr'),) ),

    # USER32
    'user32.main_entry':( 'int', None, 'stdcall', 'user32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'user32.activatekeyboardlayout':( 'int', None, 'stdcall', 'user32.ActivateKeyboardLayout', (('int', None), ('int', None)) ),
    'user32.adjustwindowrect':( 'int', None, 'stdcall', 'user32.AdjustWindowRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.adjustwindowrectex':( 'int', None, 'stdcall', 'user32.AdjustWindowRectEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.alignrects':( 'int', None, 'stdcall', 'user32.AlignRects', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.allowforegroundactivation':( 'int', None, 'cdecl', 'user32.AllowForegroundActivation', () ),
    'user32.allowsetforegroundwindow':( 'int', None, 'stdcall', 'user32.AllowSetForegroundWindow', (('int', None),) ),
    'user32.animatewindow':( 'int', None, 'stdcall', 'user32.AnimateWindow', ( ('int', None), ('int', None)) ),
    'user32.anypopup':( 'int', None, 'cdecl', 'user32.AnyPopup', () ),
    'user32.appendmenua':( 'int', None, 'stdcall', 'user32.AppendMenuA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.appendmenuw':( 'int', None, 'stdcall', 'user32.AppendMenuW', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.arrangeiconicwindows':( 'int', None, 'stdcall', 'user32.ArrangeIconicWindows', (('int', None),) ),
    'user32.attachthreadinput':( 'int', None, 'stdcall', 'user32.AttachThreadInput', (('int', None), ('int', None), ('int', None)) ),
    'user32.begindeferwindowpos':( 'int', None, 'stdcall', 'user32.BeginDeferWindowPos', (('int', None),) ),
    'user32.beginpaint':( 'int', None, 'stdcall', 'user32.BeginPaint', (('int', None), ('void *', 'ptr')) ),
    'user32.blockinput':( 'int', None, 'stdcall', 'user32.BlockInput', (('int', None),) ),
    'user32.bringwindowtotop':( 'int', None, 'stdcall', 'user32.BringWindowToTop', (('int', None),) ),
    'user32.broadcastsystemmessage':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessagea':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessageexa':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessageexw':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessagew':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.buildreasonarray':( 'int', None, 'stdcall', 'user32.BuildReasonArray', (('int', None), ('int', None), ('int', None)) ),
    'user32.calcmenubar':( 'int', None, 'stdcall', 'user32.CalcMenuBar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.callmsgfilter':( 'int', None, 'stdcall', 'user32.CallMsgFilter', (('int', None), ('int', None)) ),
    'user32.callmsgfiltera':( 'int', None, 'stdcall', 'user32.CallMsgFilterA', (('int', None), ('int', None)) ),
    'user32.callmsgfilterw':( 'int', None, 'stdcall', 'user32.CallMsgFilterW', (('void *', 'ptr'), ('int', None)) ),
    'user32.callnexthookex':( 'int', None, 'stdcall', 'user32.CallNextHookEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.callwindowproca':( 'int', None, 'stdcall', 'user32.CallWindowProcA', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.callwindowprocw':( 'int', None, 'stdcall', 'user32.CallWindowProcW', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.cascadechildwindows':( 'int', None, 'stdcall', 'user32.CascadeChildWindows', ( ('int', None),) ),
    'user32.cascadewindows':( 'int', None, 'stdcall', 'user32.CascadeWindows', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changeclipboardchain':( 'int', None, 'stdcall', 'user32.ChangeClipboardChain', (('int', None), ('int', None)) ),
    'user32.changedisplaysettingsa':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsA', (('int', None), ('int', None)) ),
    'user32.changedisplaysettingsexa':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changedisplaysettingsexw':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changedisplaysettingsw':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsW', (('int', None), ('int', None)) ),
    'user32.changemenua':( 'int', None, 'stdcall', 'user32.ChangeMenuA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changemenuw':( 'int', None, 'stdcall', 'user32.ChangeMenuW', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.charlowera':( 'int', None, 'stdcall', 'user32.CharLowerA', (('int', None),) ),
    'user32.charlowerbuffa':( 'int', None, 'stdcall', 'user32.CharLowerBuffA', (('int', None), ('int', None)) ),
    'user32.charlowerbuffw':( 'int', None, 'stdcall', 'user32.CharLowerBuffW', (('void *', 'ptr'), ('int', None)) ),
    'user32.charlowerw':( 'int', None, 'stdcall', 'user32.CharLowerW', (('void *', 'ptr'),) ),
    'user32.charnexta':( 'int', None, 'stdcall', 'user32.CharNextA', (('int', None),) ),
    'user32.charnextexa':( 'int', None, 'stdcall', 'user32.CharNextExA', (('int', None), ('int', None), ('int', None)) ),
    'user32.charnextw':( 'int', None, 'stdcall', 'user32.CharNextW', (('int', None),) ),
    'user32.charpreva':( 'int', None, 'stdcall', 'user32.CharPrevA', (('int', None), ('int', None)) ),
    'user32.charprevexa':( 'int', None, 'stdcall', 'user32.CharPrevExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.charprevw':( 'int', None, 'stdcall', 'user32.CharPrevW', (('int', None), ('int', None)) ),
    'user32.chartooema':( 'int', None, 'stdcall', 'user32.CharToOemA', (('int', None), ('int', None)) ),
    'user32.chartooembuffa':( 'int', None, 'stdcall', 'user32.CharToOemBuffA', (('int', None), ('int', None), ('int', None)) ),
    'user32.chartooembuffw':( 'int', None, 'stdcall', 'user32.CharToOemBuffW', (('int', None), ('int', None), ('int', None)) ),
    'user32.chartooemw':( 'int', None, 'stdcall', 'user32.CharToOemW', (('int', None), ('int', None)) ),
    'user32.charuppera':( 'int', None, 'stdcall', 'user32.CharUpperA', (('int', None),) ),
    'user32.charupperbuffa':( 'int', None, 'stdcall', 'user32.CharUpperBuffA', (('int', None), ('int', None)) ),
    'user32.charupperbuffw':( 'int', None, 'stdcall', 'user32.CharUpperBuffW', (('void *', 'ptr'), ('int', None)) ),
    'user32.charupperw':( 'int', None, 'stdcall', 'user32.CharUpperW', (('void *', 'ptr'),) ),
    'user32.checkdlgbutton':( 'int', None, 'stdcall', 'user32.CheckDlgButton', ( ('int', None), ('int', None)) ),
    'user32.checkmenuitem':( 'int', None, 'stdcall', 'user32.CheckMenuItem', ( ('int', None), ('int', None)) ),
    'user32.checkmenuradioitem':( 'int', None, 'stdcall', 'user32.CheckMenuRadioItem', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.checkradiobutton':( 'int', None, 'stdcall', 'user32.CheckRadioButton', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.childwindowfrompoint':( 'int', None, 'stdcall', 'user32.ChildWindowFromPoint', ( ('int', None), ('int', None)) ),
    'user32.childwindowfrompointex':( 'int', None, 'stdcall', 'user32.ChildWindowFromPointEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.cliimmsethotkey':( 'int', None, 'stdcall', 'user32.CliImmSetHotKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.clientthreadsetup':( 'int', None, 'cdecl', 'user32.ClientThreadSetup', () ),
    'user32.clienttoscreen':( 'int', None, 'stdcall', 'user32.ClientToScreen', ( ('void *', 'ptr'),) ),
    'user32.clipcursor':( 'int', None, 'stdcall', 'user32.ClipCursor', (('int', None),) ),
    'user32.closeclipboard':( 'int', None, 'cdecl', 'user32.CloseClipboard', () ),
    'user32.closedesktop':( 'int', None, 'stdcall', 'user32.CloseDesktop', (('int', None),) ),
    'user32.closewindow':( 'int', None, 'stdcall', 'user32.CloseWindow', () ),
    'user32.closewindowstation':( 'int', None, 'stdcall', 'user32.CloseWindowStation', (('int', None),) ),
    'user32.copyacceleratortablea':( 'int', None, 'stdcall', 'user32.CopyAcceleratorTableA', (('int', None), ('int', None), ('int', None)) ),
    'user32.copyacceleratortablew':( 'int', None, 'stdcall', 'user32.CopyAcceleratorTableW', (('int', None), ('int', None), ('int', None)) ),
    'user32.copyicon':( 'int', None, 'stdcall', 'user32.CopyIcon', (('int', None),) ),
    'user32.copyimage':( 'int', None, 'stdcall', 'user32.CopyImage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.copyrect':( 'int', None, 'stdcall', 'user32.CopyRect', (('int', None), ('int', None)) ),
    'user32.countclipboardformats':( 'int', None, 'cdecl', 'user32.CountClipboardFormats', () ),
    'user32.createacceleratortablea':( 'int', None, 'stdcall', 'user32.CreateAcceleratorTableA', (('int', None), ('int', None)) ),
    'user32.createacceleratortablew':( 'int', None, 'stdcall', 'user32.CreateAcceleratorTableW', (('int', None), ('int', None)) ),
    'user32.createcaret':( 'int', None, 'stdcall', 'user32.CreateCaret', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createcursor':( 'int', None, 'stdcall', 'user32.CreateCursor', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdesktopa':( 'int', None, 'stdcall', 'user32.CreateDesktopA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdesktopw':( 'int', None, 'stdcall', 'user32.CreateDesktopW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdialogindirectparama':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogindirectparamaorw':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamAorW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.createdialogindirectparamw':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogparama':( 'int', None, 'stdcall', 'user32.CreateDialogParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogparamw':( 'int', None, 'stdcall', 'user32.CreateDialogParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createicon':( 'int', None, 'stdcall', 'user32.CreateIcon', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconfromresource':( 'int', None, 'stdcall', 'user32.CreateIconFromResource', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconfromresourceex':( 'int', None, 'stdcall', 'user32.CreateIconFromResourceEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconindirect':( 'int', None, 'stdcall', 'user32.CreateIconIndirect', (('void *', 'ptr'),) ),
    'user32.createmdiwindowa':( 'int', None, 'stdcall', 'user32.CreateMDIWindowA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.createmdiwindoww':( 'int', None, 'stdcall', 'user32.CreateMDIWindowW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.createmenu':( 'int', None, 'cdecl', 'user32.CreateMenu', () ),
    'user32.createpopupmenu':( 'int', None, 'cdecl', 'user32.CreatePopupMenu', () ),
    'user32.createsystemthreads':( 'int', None, 'stdcall', 'user32.CreateSystemThreads', (('int', None), ('int', None)) ),
    'user32.createwindowexa':( 'int', None, 'stdcall', 'user32.CreateWindowExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowexw':( 'int', None, 'stdcall', 'user32.CreateWindowExW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowstationa':( 'int', None, 'stdcall', 'user32.CreateWindowStationA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowstationw':( 'int', None, 'stdcall', 'user32.CreateWindowStationW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.csrbroadcastsystemmessageexw':( 'int', None, 'stdcall', 'user32.CsrBroadcastSystemMessageExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ctxinituser32':( 'int', None, 'cdecl', 'user32.CtxInitUser32', () ),
    'user32.ddeabandontransaction':( 'int', None, 'stdcall', 'user32.DdeAbandonTransaction', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddeaccessdata':( 'int', None, 'stdcall', 'user32.DdeAccessData', (('int', None), ('int', None)) ),
    'user32.ddeadddata':( 'int', None, 'stdcall', 'user32.DdeAddData', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddeclienttransaction':( 'int', None, 'stdcall', 'user32.DdeClientTransaction', (('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddecmpstringhandles':( 'int', None, 'stdcall', 'user32.DdeCmpStringHandles', (('int', None), ('int', None)) ),
    'user32.ddeconnect':( 'int', None, 'stdcall', 'user32.DdeConnect', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddeconnectlist':( 'int', None, 'stdcall', 'user32.DdeConnectList', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddecreatedatahandle':( 'int', None, 'stdcall', 'user32.DdeCreateDataHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddecreatestringhandlea':( 'int', None, 'stdcall', 'user32.DdeCreateStringHandleA', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddecreatestringhandlew':( 'int', None, 'stdcall', 'user32.DdeCreateStringHandleW', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddedisconnect':( 'int', None, 'stdcall', 'user32.DdeDisconnect', (('int', None),) ),
    'user32.ddedisconnectlist':( 'int', None, 'stdcall', 'user32.DdeDisconnectList', (('int', None),) ),
    'user32.ddeenablecallback':( 'int', None, 'stdcall', 'user32.DdeEnableCallback', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.ddefreedatahandle':( 'int', None, 'stdcall', 'user32.DdeFreeDataHandle', (('int', None),) ),
    'user32.ddefreestringhandle':( 'int', None, 'stdcall', 'user32.DdeFreeStringHandle', (('int', None), ('int', None)) ),
    'user32.ddegetdata':( 'int', None, 'stdcall', 'user32.DdeGetData', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddegetlasterror':( 'int', None, 'stdcall', 'user32.DdeGetLastError', (('int', None),) ),
    'user32.ddegetqualityofservice':( 'int', None, 'stdcall', 'user32.DdeGetQualityOfService', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddeimpersonateclient':( 'int', None, 'stdcall', 'user32.DdeImpersonateClient', (('int', None),) ),
    'user32.ddeinitializea':( 'int', None, 'stdcall', 'user32.DdeInitializeA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddeinitializew':( 'int', None, 'stdcall', 'user32.DdeInitializeW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddekeepstringhandle':( 'int', None, 'stdcall', 'user32.DdeKeepStringHandle', (('int', None), ('int', None)) ),
    'user32.ddenameservice':( 'int', None, 'stdcall', 'user32.DdeNameService', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddepostadvise':( 'int', None, 'stdcall', 'user32.DdePostAdvise', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddequeryconvinfo':( 'int', None, 'stdcall', 'user32.DdeQueryConvInfo', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddequerynextserver':( 'int', None, 'stdcall', 'user32.DdeQueryNextServer', (('int', None), ('int', None)) ),
    'user32.ddequerystringa':( 'int', None, 'stdcall', 'user32.DdeQueryStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddequerystringw':( 'int', None, 'stdcall', 'user32.DdeQueryStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddereconnect':( 'int', None, 'stdcall', 'user32.DdeReconnect', (('int', None),) ),
    'user32.ddesetqualityofservice':( 'int', None, 'stdcall', 'user32.DdeSetQualityOfService', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddesetuserhandle':( 'int', None, 'stdcall', 'user32.DdeSetUserHandle', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddeunaccessdata':( 'int', None, 'stdcall', 'user32.DdeUnaccessData', (('int', None),) ),
    'user32.ddeuninitialize':( 'int', None, 'stdcall', 'user32.DdeUninitialize', (('int', None),) ),
    'user32.defdlgproca':( 'int', None, 'stdcall', 'user32.DefDlgProcA', ( ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defdlgprocw':( 'int', None, 'stdcall', 'user32.DefDlgProcW', ( ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defframeproca':( 'int', None, 'stdcall', 'user32.DefFrameProcA', ( ('void *', 'obj'), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.defframeprocw':( 'int', None, 'stdcall', 'user32.DefFrameProcW', ( ('void *', 'obj'), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.defmdichildproca':( 'int', None, 'stdcall', 'user32.DefMDIChildProcA', ( ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.defmdichildprocw':( 'int', None, 'stdcall', 'user32.DefMDIChildProcW', ( ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.defrawinputproc':( 'int', None, 'stdcall', 'user32.DefRawInputProc', (('int', None), ('int', None), ('int', None)) ),
    'user32.defwindowproca':( 'int', None, 'stdcall', 'user32.DefWindowProcA', ( ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.defwindowprocw':( 'int', None, 'stdcall', 'user32.DefWindowProcW', ( ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.deferwindowpos':( 'int', None, 'stdcall', 'user32.DeferWindowPos', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.deletemenu':( 'int', None, 'stdcall', 'user32.DeleteMenu', (('int', None), ('int', None), ('int', None)) ),
    'user32.deregistershellhookwindow':( 'int', None, 'stdcall', 'user32.DeregisterShellHookWindow', (('int', None),) ),
    'user32.destroyacceleratortable':( 'int', None, 'stdcall', 'user32.DestroyAcceleratorTable', (('int', None),) ),
    'user32.destroycaret':( 'int', None, 'cdecl', 'user32.DestroyCaret', () ),
    'user32.destroycursor':( 'int', None, 'stdcall', 'user32.DestroyCursor', (('int', None),) ),
    'user32.destroyicon':( 'int', None, 'stdcall', 'user32.DestroyIcon', (('int', None),) ),
    'user32.destroymenu':( 'int', None, 'stdcall', 'user32.DestroyMenu', (('int', None),) ),
    'user32.destroyreasons':( 'int', None, 'stdcall', 'user32.DestroyReasons', (('int', None),) ),
    'user32.destroywindow':( 'int', None, 'stdcall', 'user32.DestroyWindow', (('int', None),) ),
    'user32.deviceeventworker':( 'int', None, 'stdcall', 'user32.DeviceEventWorker', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.dialogboxindirectparama':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxindirectparamaorw':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamAorW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.dialogboxindirectparamw':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxparama':( 'int', None, 'stdcall', 'user32.DialogBoxParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxparamw':( 'int', None, 'stdcall', 'user32.DialogBoxParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.disableprocesswindowsghosting':( 'int', None, 'cdecl', 'user32.DisableProcessWindowsGhosting', () ),
    'user32.dispatchmessagea':( 'int', None, 'stdcall', 'user32.DispatchMessageA', (('int', None),) ),
    'user32.dispatchmessagew':( 'int', None, 'stdcall', 'user32.DispatchMessageW', (('void *', 'ptr'),) ),
    'user32.displayexitwindowswarnings':( 'int', None, 'stdcall', 'user32.DisplayExitWindowsWarnings', (('int', None),) ),
    'user32.dlgdirlista':( 'int', None, 'stdcall', 'user32.DlgDirListA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistcomboboxa':( 'int', None, 'stdcall', 'user32.DlgDirListComboBoxA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistcomboboxw':( 'int', None, 'stdcall', 'user32.DlgDirListComboBoxW', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistw':( 'int', None, 'stdcall', 'user32.DlgDirListW', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirselectcomboboxexa':( 'int', None, 'stdcall', 'user32.DlgDirSelectComboBoxExA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirselectcomboboxexw':( 'int', None, 'stdcall', 'user32.DlgDirSelectComboBoxExW', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dlgdirselectexa':( 'int', None, 'stdcall', 'user32.DlgDirSelectExA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirselectexw':( 'int', None, 'stdcall', 'user32.DlgDirSelectExW', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dragdetect':( 'int', None, 'stdcall', 'user32.DragDetect', (('int', None), ('int', None), ('int', None)) ),
    'user32.dragobject':( 'int', None, 'stdcall', 'user32.DragObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawanimatedrects':( 'int', None, 'stdcall', 'user32.DrawAnimatedRects', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawcaption':( 'int', None, 'stdcall', 'user32.DrawCaption', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawcaptiontempa':( 'int', None, 'stdcall', 'user32.DrawCaptionTempA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.drawcaptiontempw':( 'int', None, 'stdcall', 'user32.DrawCaptionTempW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawedge':( 'int', None, 'stdcall', 'user32.DrawEdge', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawfocusrect':( 'int', None, 'stdcall', 'user32.DrawFocusRect', (('int', None), ('void *', 'ptr')) ),
    'user32.drawframe':( 'int', None, 'stdcall', 'user32.DrawFrame', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawframecontrol':( 'int', None, 'stdcall', 'user32.DrawFrameControl', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawicon':( 'int', None, 'stdcall', 'user32.DrawIcon', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawiconex':( 'int', None, 'stdcall', 'user32.DrawIconEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawmenubar':( 'int', None, 'stdcall', 'user32.DrawMenuBar', (('int', None),) ),
    'user32.drawmenubartemp':( 'int', None, 'stdcall', 'user32.DrawMenuBarTemp', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawstatea':( 'int', None, 'stdcall', 'user32.DrawStateA', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawstatew':( 'int', None, 'stdcall', 'user32.DrawStateW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawtexta':( 'int', None, 'stdcall', 'user32.DrawTextA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawtextexa':( 'int', None, 'stdcall', 'user32.DrawTextExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.drawtextexw':( 'int', None, 'stdcall', 'user32.DrawTextExW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'user32.drawtextw':( 'int', None, 'stdcall', 'user32.DrawTextW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.editwndproc':( 'int', None, 'stdcall', 'user32.EditWndProc', (('int', None), ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.emptyclipboard':( 'int', None, 'cdecl', 'user32.EmptyClipboard', () ),
    'user32.enablemenuitem':( 'int', None, 'stdcall', 'user32.EnableMenuItem', ( ('int', None), ('int', None)) ),
    'user32.enablescrollbar':( 'int', None, 'stdcall', 'user32.EnableScrollBar', (('int', None), ('int', None), ('int', None)) ),
    'user32.enablewindow':( 'int', None, 'stdcall', 'user32.EnableWindow', (('int', None), ('int', None)) ),
    'user32.enddeferwindowpos':( 'int', None, 'stdcall', 'user32.EndDeferWindowPos', (('int', None),) ),
    'user32.enddialog':( 'int', None, 'stdcall', 'user32.EndDialog', ( ('int', None),) ),
    'user32.endmenu':( 'int', None, 'cdecl', 'user32.EndMenu', () ),
    'user32.endpaint':( 'int', None, 'stdcall', 'user32.EndPaint', (('int', None), ('void *', 'ptr')) ),
    'user32.endtask':( 'int', None, 'stdcall', 'user32.EndTask', (('int', None), ('int', None), ('int', None)) ),
    'user32.enterreadermodehelper':( 'int', None, 'stdcall', 'user32.EnterReaderModeHelper', () ),
    'user32.enumchildwindows':( 'int', None, 'stdcall', 'user32.EnumChildWindows', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'user32.enumclipboardformats':( 'int', None, 'stdcall', 'user32.EnumClipboardFormats', (('int', None),) ),
    'user32.enumdesktopwindows':( 'int', None, 'stdcall', 'user32.EnumDesktopWindows', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdesktopsa':( 'int', None, 'stdcall', 'user32.EnumDesktopsA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdesktopsw':( 'int', None, 'stdcall', 'user32.EnumDesktopsW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdisplaydevicesa':( 'int', None, 'stdcall', 'user32.EnumDisplayDevicesA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaydevicesw':( 'int', None, 'stdcall', 'user32.EnumDisplayDevicesW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaymonitors':( 'int', None, 'stdcall', 'user32.EnumDisplayMonitors', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.enumdisplaysettingsa':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsA', (('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsexa':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsexw':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsw':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsW', (('int', None), ('int', None), ('int', None)) ),
    'user32.enumpropsa':( 'int', None, 'stdcall', 'user32.EnumPropsA', (('int', None), ('void *', 'funcptr')) ),
    'user32.enumpropsexa':( 'int', None, 'stdcall', 'user32.EnumPropsExA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumpropsexw':( 'int', None, 'stdcall', 'user32.EnumPropsExW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumpropsw':( 'int', None, 'stdcall', 'user32.EnumPropsW', (('int', None), ('void *', 'funcptr')) ),
    'user32.enumthreadwindows':( 'int', None, 'stdcall', 'user32.EnumThreadWindows', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindowstationsa':( 'int', None, 'stdcall', 'user32.EnumWindowStationsA', (('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindowstationsw':( 'int', None, 'stdcall', 'user32.EnumWindowStationsW', (('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindows':( 'int', None, 'stdcall', 'user32.EnumWindows', (('void *', 'funcptr'), ('void *', 'ptr')) ),
    'user32.equalrect':( 'int', None, 'stdcall', 'user32.EqualRect', (('int', None), ('int', None)) ),
    'user32.excludeupdatergn':( 'int', None, 'stdcall', 'user32.ExcludeUpdateRgn', (('int', None), ('int', None)) ),
    'user32.exitwindowsex':( 'int', None, 'stdcall', 'user32.ExitWindowsEx', ( ('int', None), ('int', None)) ),
    'user32.fillrect':( 'int', None, 'stdcall', 'user32.FillRect', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.findwindowa':( 'int', None, 'stdcall', 'user32.FindWindowA', (('int', None), ('int', None)) ),
    'user32.findwindowexa':( 'int', None, 'stdcall', 'user32.FindWindowExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.findwindowexw':( 'int', None, 'stdcall', 'user32.FindWindowExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.findwindoww':( 'int', None, 'stdcall', 'user32.FindWindowW', (('int', None), ('int', None)) ),
    'user32.flashwindow':( 'int', None, 'stdcall', 'user32.FlashWindow', (('int', None), ('int', None)) ),
    'user32.flashwindowex':( 'int', None, 'stdcall', 'user32.FlashWindowEx', (('void *', 'ptr'),) ),
    'user32.framerect':( 'int', None, 'stdcall', 'user32.FrameRect', (('int', None), ('int', None), ('int', None)) ),
    'user32.freeddelparam':( 'int', None, 'stdcall', 'user32.FreeDDElParam', (('int', None), ('void *', 'ptr')) ),
    'user32.getactivewindow':( 'int', None, 'cdecl', 'user32.GetActiveWindow', () ),
    'user32.getalttabinfo':( 'int', None, 'stdcall', 'user32.GetAltTabInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getalttabinfoa':( 'int', None, 'stdcall', 'user32.GetAltTabInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getalttabinfow':( 'int', None, 'stdcall', 'user32.GetAltTabInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getancestor':( 'int', None, 'stdcall', 'user32.GetAncestor', (('int', None), ('int', None)) ),
    'user32.getappcompatflags':( 'int', None, 'stdcall', 'user32.GetAppCompatFlags', (('int', None),) ),
    'user32.getappcompatflags2':( 'int', None, 'stdcall', 'user32.GetAppCompatFlags2', (('int', None),) ),
    'user32.getasynckeystate':( 'int', None, 'stdcall', 'user32.GetAsyncKeyState', (('int', None),) ),
    'user32.getcapture':( 'int', None, 'cdecl', 'user32.GetCapture', () ),
    'user32.getcaretblinktime':( 'int', None, 'cdecl', 'user32.GetCaretBlinkTime', () ),
    'user32.getcaretpos':( 'int', None, 'stdcall', 'user32.GetCaretPos', (('void *', 'ptr'),) ),
    'user32.getclassinfoa':( 'int', None, 'stdcall', 'user32.GetClassInfoA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclassinfoexa':( 'int', None, 'stdcall', 'user32.GetClassInfoExA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getclassinfoexw':( 'int', None, 'stdcall', 'user32.GetClassInfoExW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getclassinfow':( 'int', None, 'stdcall', 'user32.GetClassInfoW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.getclasslonga':( 'int', None, 'stdcall', 'user32.GetClassLongA', ( ('int', None),) ),
    'user32.getclasslongw':( 'int', None, 'stdcall', 'user32.GetClassLongW', ( ('int', None),) ),
    'user32.getclassnamea':( 'int', None, 'stdcall', 'user32.GetClassNameA', ( ('int', None), ('int', None)) ),
    'user32.getclassnamew':( 'int', None, 'stdcall', 'user32.GetClassNameW', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclassword':( 'int', None, 'stdcall', 'user32.GetClassWord', ( ('int', None),) ),
    'user32.getclientrect':( 'int', None, 'stdcall', 'user32.GetClientRect', ( ('void *', 'ptr'),) ),
    'user32.getclipcursor':( 'int', None, 'stdcall', 'user32.GetClipCursor', (('int', None),) ),
    'user32.getclipboarddata':( 'int', None, 'stdcall', 'user32.GetClipboardData', ( ('int', None),) ),
    'user32.getclipboardformatnamea':( 'int', None, 'stdcall', 'user32.GetClipboardFormatNameA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclipboardformatnamew':( 'int', None, 'stdcall', 'user32.GetClipboardFormatNameW', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclipboardowner':( 'int', None, 'cdecl', 'user32.GetClipboardOwner', () ),
    'user32.getclipboardsequencenumber':( 'int', None, 'cdecl', 'user32.GetClipboardSequenceNumber', () ),
    'user32.getclipboardviewer':( 'int', None, 'cdecl', 'user32.GetClipboardViewer', () ),
    'user32.getcomboboxinfo':( 'int', None, 'stdcall', 'user32.GetComboBoxInfo', (('int', None), ('int', None)) ),
    'user32.getcursor':( 'int', None, 'cdecl', 'user32.GetCursor', () ),
    'user32.getcursorframeinfo':( 'int', None, 'stdcall', 'user32.GetCursorFrameInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getcursorinfo':( 'int', None, 'stdcall', 'user32.GetCursorInfo', (('int', None),) ),
    'user32.getcursorpos':( 'int', None, 'stdcall', 'user32.GetCursorPos', (('void *', 'ptr'),) ),
    'user32.getdc':( 'int', None, 'stdcall', 'user32.GetDC', (('int', None),) ),
    'user32.getdcex':( 'int', None, 'stdcall', 'user32.GetDCEx', (('int', None), ('int', None), ('int', None)) ),
    'user32.getdesktopwindow':( 'int', None, 'cdecl', 'user32.GetDesktopWindow', () ),
    'user32.getdialogbaseunits':( 'int', None, 'cdecl', 'user32.GetDialogBaseUnits', () ),
    'user32.getdlgctrlid':( 'int', None, 'stdcall', 'user32.GetDlgCtrlID', () ),
    'user32.getdlgitem':( 'int', None, 'stdcall', 'user32.GetDlgItem', ( ('int', None),) ),
    'user32.getdlgitemint':( 'int', None, 'stdcall', 'user32.GetDlgItemInt', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.getdlgitemtexta':( 'int', None, 'stdcall', 'user32.GetDlgItemTextA', ( ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getdlgitemtextw':( 'int', None, 'stdcall', 'user32.GetDlgItemTextW', ( ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getdoubleclicktime':( 'int', None, 'cdecl', 'user32.GetDoubleClickTime', () ),
    'user32.getfocus':( 'int', None, 'cdecl', 'user32.GetFocus', () ),
    'user32.getforegroundwindow':( 'int', None, 'cdecl', 'user32.GetForegroundWindow', () ),
    'user32.getguithreadinfo':( 'int', None, 'stdcall', 'user32.GetGUIThreadInfo', (('int', None), ('int', None)) ),
    'user32.getguiresources':( 'int', None, 'stdcall', 'user32.GetGuiResources', (('int', None), ('int', None)) ),
    'user32.geticoninfo':( 'int', None, 'stdcall', 'user32.GetIconInfo', (('int', None), ('void *', 'ptr')) ),
    'user32.getinputdesktop':( 'int', None, 'cdecl', 'user32.GetInputDesktop', () ),
    'user32.getinputstate':( 'int', None, 'cdecl', 'user32.GetInputState', () ),
    'user32.getinternalwindowpos':( 'int', None, 'stdcall', 'user32.GetInternalWindowPos', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkbcodepage':( 'int', None, 'stdcall', 'user32.GetKBCodePage', () ),
    'user32.getkeynametexta':( 'int', None, 'stdcall', 'user32.GetKeyNameTextA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkeynametextw':( 'int', None, 'stdcall', 'user32.GetKeyNameTextW', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkeystate':( 'int', None, 'stdcall', 'user32.GetKeyState', (('int', None),) ),
    'user32.getkeyboardlayout':( 'int', None, 'stdcall', 'user32.GetKeyboardLayout', (('int', None),) ),
    'user32.getkeyboardlayoutlist':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutList', (('int', None), ('int', None)) ),
    'user32.getkeyboardlayoutnamea':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutNameA', (('int', None),) ),
    'user32.getkeyboardlayoutnamew':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutNameW', (('int', None),) ),
    'user32.getkeyboardstate':( 'int', None, 'stdcall', 'user32.GetKeyboardState', (('int', None),) ),
    'user32.getkeyboardtype':( 'int', None, 'stdcall', 'user32.GetKeyboardType', (('int', None),) ),
    'user32.getlastactivepopup':( 'int', None, 'stdcall', 'user32.GetLastActivePopup', () ),
    'user32.getlastinputinfo':( 'int', None, 'stdcall', 'user32.GetLastInputInfo', (('int', None),) ),
    'user32.getlayeredwindowattributes':( 'int', None, 'stdcall', 'user32.GetLayeredWindowAttributes', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getlistboxinfo':( 'int', None, 'stdcall', 'user32.GetListBoxInfo', (('int', None),) ),
    'user32.getmenu':( 'int', None, 'stdcall', 'user32.GetMenu', () ),
    'user32.getmenubarinfo':( 'int', None, 'stdcall', 'user32.GetMenuBarInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenucheckmarkdimensions':( 'int', None, 'cdecl', 'user32.GetMenuCheckMarkDimensions', () ),
    'user32.getmenucontexthelpid':( 'int', None, 'stdcall', 'user32.GetMenuContextHelpId', () ),
    'user32.getmenudefaultitem':( 'int', None, 'stdcall', 'user32.GetMenuDefaultItem', ( ('int', None), ('int', None)) ),
    'user32.getmenuinfo':( 'int', None, 'stdcall', 'user32.GetMenuInfo', ( ('int', None),) ),
    'user32.getmenuitemcount':( 'int', None, 'stdcall', 'user32.GetMenuItemCount', () ),
    'user32.getmenuitemid':( 'int', None, 'stdcall', 'user32.GetMenuItemID', ( ('int', None),) ),
    'user32.getmenuiteminfoa':( 'int', None, 'stdcall', 'user32.GetMenuItemInfoA', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenuiteminfow':( 'int', None, 'stdcall', 'user32.GetMenuItemInfoW', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenuitemrect':( 'int', None, 'stdcall', 'user32.GetMenuItemRect', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenustate':( 'int', None, 'stdcall', 'user32.GetMenuState', ( ('int', None), ('int', None)) ),
    'user32.getmenustringa':( 'int', None, 'stdcall', 'user32.GetMenuStringA', ( ('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getmenustringw':( 'int', None, 'stdcall', 'user32.GetMenuStringW', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmessagea':( 'int', None, 'stdcall', 'user32.GetMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmessageextrainfo':( 'int', None, 'cdecl', 'user32.GetMessageExtraInfo', () ),
    'user32.getmessagepos':( 'int', None, 'cdecl', 'user32.GetMessagePos', () ),
    'user32.getmessagetime':( 'int', None, 'cdecl', 'user32.GetMessageTime', () ),
    'user32.getmessagew':( 'int', None, 'stdcall', 'user32.GetMessageW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmonitorinfoa':( 'int', None, 'stdcall', 'user32.GetMonitorInfoA', (('void *', 'ptr'), ('int', None)) ),
    'user32.getmonitorinfow':( 'int', None, 'stdcall', 'user32.GetMonitorInfoW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.getmousemovepointsex':( 'int', None, 'stdcall', 'user32.GetMouseMovePointsEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getnextdlggroupitem':( 'int', None, 'stdcall', 'user32.GetNextDlgGroupItem', ( ('void *', 'obj'), ('int', None)) ),
    'user32.getnextdlgtabitem':( 'int', None, 'stdcall', 'user32.GetNextDlgTabItem', ( ('void *', 'obj'), ('int', None)) ),
    'user32.getopenclipboardwindow':( 'int', None, 'cdecl', 'user32.GetOpenClipboardWindow', () ),
    'user32.getparent':( 'int', None, 'stdcall', 'user32.GetParent', () ),
    'user32.getpriorityclipboardformat':( 'int', None, 'stdcall', 'user32.GetPriorityClipboardFormat', (('int', None), ('int', None)) ),
    'user32.getprocessdefaultlayout':( 'int', None, 'stdcall', 'user32.GetProcessDefaultLayout', (('int', None),) ),
    'user32.getprocesswindowstation':( 'int', None, 'cdecl', 'user32.GetProcessWindowStation', () ),
    'user32.getprogmanwindow':( 'int', None, 'cdecl', 'user32.GetProgmanWindow', () ),
    'user32.getpropa':( 'int', None, 'stdcall', 'user32.GetPropA', ( ('int', None),) ),
    'user32.getpropw':( 'int', None, 'stdcall', 'user32.GetPropW', ( ('int', None),) ),
    'user32.getqueuestatus':( 'int', None, 'stdcall', 'user32.GetQueueStatus', (('int', None),) ),
    'user32.getrawinputbuffer':( 'int', None, 'stdcall', 'user32.GetRawInputBuffer', (('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdata':( 'int', None, 'stdcall', 'user32.GetRawInputData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdeviceinfoa':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceInfoA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getrawinputdeviceinfow':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdevicelist':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceList', (('int', None), ('int', None), ('int', None)) ),
    'user32.getreasontitlefromreasoncode':( 'int', None, 'stdcall', 'user32.GetReasonTitleFromReasonCode', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getregisteredrawinputdevices':( 'int', None, 'stdcall', 'user32.GetRegisteredRawInputDevices', (('int', None), ('int', None), ('int', None)) ),
    'user32.getscrollbarinfo':( 'int', None, 'stdcall', 'user32.GetScrollBarInfo', (('int', None), ('int', None), ('int', None)) ),
    'user32.getscrollinfo':( 'int', None, 'stdcall', 'user32.GetScrollInfo', ( ('int', None), ('void *', 'obj')) ),
    'user32.getscrollpos':( 'int', None, 'stdcall', 'user32.GetScrollPos', ( ('int', None),) ),
    'user32.getscrollrange':( 'int', None, 'stdcall', 'user32.GetScrollRange', ( ('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.getshellwindow':( 'int', None, 'cdecl', 'user32.GetShellWindow', () ),
    'user32.getsubmenu':( 'int', None, 'stdcall', 'user32.GetSubMenu', ( ('int', None),) ),
    'user32.getsyscolor':( 'int', None, 'stdcall', 'user32.GetSysColor', (('int', None),) ),
    'user32.getsyscolorbrush':( 'int', None, 'stdcall', 'user32.GetSysColorBrush', (('int', None),) ),
    'user32.getsystemmenu':( 'int', None, 'stdcall', 'user32.GetSystemMenu', (('int', None), ('int', None)) ),
    'user32.getsystemmetrics':( 'int', None, 'stdcall', 'user32.GetSystemMetrics', (('int', None),) ),
    'user32.gettabbedtextextenta':( 'int', None, 'stdcall', 'user32.GetTabbedTextExtentA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.gettabbedtextextentw':( 'int', None, 'stdcall', 'user32.GetTabbedTextExtentW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.gettaskmanwindow':( 'int', None, 'cdecl', 'user32.GetTaskmanWindow', () ),
    'user32.getthreaddesktop':( 'int', None, 'stdcall', 'user32.GetThreadDesktop', (('int', None),) ),
    'user32.gettitlebarinfo':( 'int', None, 'stdcall', 'user32.GetTitleBarInfo', (('int', None), ('int', None)) ),
    'user32.gettopwindow':( 'int', None, 'stdcall', 'user32.GetTopWindow', () ),
    'user32.getupdaterect':( 'int', None, 'stdcall', 'user32.GetUpdateRect', ( ('int', None), ('int', None)) ),
    'user32.getupdatergn':( 'int', None, 'stdcall', 'user32.GetUpdateRgn', ( ('int', None), ('int', None)) ),
    'user32.getuserobjectinformationa':( 'int', None, 'stdcall', 'user32.GetUserObjectInformationA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getuserobjectinformationw':( 'int', None, 'stdcall', 'user32.GetUserObjectInformationW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getuserobjectsecurity':( 'int', None, 'stdcall', 'user32.GetUserObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getwinstationinfo':( 'int', None, 'stdcall', 'user32.GetWinStationInfo', (('int', None),) ),
    'user32.getwindow':( 'int', None, 'stdcall', 'user32.GetWindow', ( ('int', None),) ),
    'user32.getwindowcontexthelpid':( 'int', None, 'stdcall', 'user32.GetWindowContextHelpId', (('int', None),) ),
    'user32.getwindowdc':( 'int', None, 'stdcall', 'user32.GetWindowDC', (('int', None),) ),
    'user32.getwindowinfo':( 'int', None, 'stdcall', 'user32.GetWindowInfo', ( ('int', None),) ),
    'user32.getwindowlonga':( 'int', None, 'stdcall', 'user32.GetWindowLongA', ( ('int', None),) ),
    'user32.getwindowlongw':( 'int', None, 'stdcall', 'user32.GetWindowLongW', ( ('int', None),) ),
    'user32.getwindowmodulefilename':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileName', ( ('int', None), ('int', None)) ),
    'user32.getwindowmodulefilenamea':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileNameA', ( ('int', None), ('int', None)) ),
    'user32.getwindowmodulefilenamew':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileNameW', ( ('int', None), ('int', None)) ),
    'user32.getwindowplacement':( 'int', None, 'stdcall', 'user32.GetWindowPlacement', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowrect':( 'int', None, 'stdcall', 'user32.GetWindowRect', ( ('void *', 'ptr'),) ),
    'user32.getwindowrgn':( 'int', None, 'stdcall', 'user32.GetWindowRgn', ( ('int', None),) ),
    'user32.getwindowrgnbox':( 'int', None, 'stdcall', 'user32.GetWindowRgnBox', ( ('int', None),) ),
    'user32.getwindowtexta':( 'int', None, 'stdcall', 'user32.GetWindowTextA', ( ('void *', 'obj'), ('int', None)) ),
    'user32.getwindowtextlengtha':( 'int', None, 'stdcall', 'user32.GetWindowTextLengthA', () ),
    'user32.getwindowtextlengthw':( 'int', None, 'stdcall', 'user32.GetWindowTextLengthW', () ),
    'user32.getwindowtextw':( 'int', None, 'stdcall', 'user32.GetWindowTextW', ( ('void *', 'obj'), ('int', None)) ),
    'user32.getwindowthreadprocessid':( 'int', None, 'stdcall', 'user32.GetWindowThreadProcessId', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowword':( 'int', None, 'stdcall', 'user32.GetWindowWord', ( ('int', None),) ),
    'user32.graystringa':( 'int', None, 'stdcall', 'user32.GrayStringA', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.graystringw':( 'int', None, 'stdcall', 'user32.GrayStringW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.hidecaret':( 'int', None, 'stdcall', 'user32.HideCaret', (('int', None),) ),
    'user32.hilitemenuitem':( 'int', None, 'stdcall', 'user32.HiliteMenuItem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.impgetimea':( 'int', None, 'stdcall', 'user32.IMPGetIMEA', (('int', None), ('int', None)) ),
    'user32.impgetimew':( 'int', None, 'stdcall', 'user32.IMPGetIMEW', (('int', None), ('int', None)) ),
    'user32.impqueryimea':( 'int', None, 'stdcall', 'user32.IMPQueryIMEA', (('int', None),) ),
    'user32.impqueryimew':( 'int', None, 'stdcall', 'user32.IMPQueryIMEW', (('int', None),) ),
    'user32.impsetimea':( 'int', None, 'stdcall', 'user32.IMPSetIMEA', (('int', None), ('int', None)) ),
    'user32.impsetimew':( 'int', None, 'stdcall', 'user32.IMPSetIMEW', (('int', None), ('int', None)) ),
    'user32.impersonateddeclientwindow':( 'int', None, 'stdcall', 'user32.ImpersonateDdeClientWindow', (('int', None), ('int', None)) ),
    'user32.insendmessage':( 'int', None, 'cdecl', 'user32.InSendMessage', () ),
    'user32.insendmessageex':( 'int', None, 'stdcall', 'user32.InSendMessageEx', (('int', None),) ),
    'user32.inflaterect':( 'int', None, 'stdcall', 'user32.InflateRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.initializelpkhooks':( 'int', None, 'stdcall', 'user32.InitializeLpkHooks', (('int', None),) ),
    'user32.initializewin32entrytable':( 'int', None, 'stdcall', 'user32.InitializeWin32EntryTable', (('int', None),) ),
    'user32.insertmenua':( 'int', None, 'stdcall', 'user32.InsertMenuA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.insertmenuitema':( 'int', None, 'stdcall', 'user32.InsertMenuItemA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.insertmenuitemw':( 'int', None, 'stdcall', 'user32.InsertMenuItemW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.insertmenuw':( 'int', None, 'stdcall', 'user32.InsertMenuW', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.internalgetwindowtext':( 'int', None, 'stdcall', 'user32.InternalGetWindowText', (('int', None), ('int', None), ('int', None)) ),
    'user32.intersectrect':( 'int', None, 'stdcall', 'user32.IntersectRect', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.invalidaterect':( 'int', None, 'stdcall', 'user32.InvalidateRect', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.invalidatergn':( 'int', None, 'stdcall', 'user32.InvalidateRgn', (('int', None), ('int', None), ('int', None)) ),
    'user32.invertrect':( 'int', None, 'stdcall', 'user32.InvertRect', (('int', None), ('int', None)) ),
    'user32.ischaralphaa':( 'int', None, 'stdcall', 'user32.IsCharAlphaA', (('int', None),) ),
    'user32.ischaralphanumerica':( 'int', None, 'stdcall', 'user32.IsCharAlphaNumericA', (('int', None),) ),
    'user32.ischaralphanumericw':( 'int', None, 'stdcall', 'user32.IsCharAlphaNumericW', (('int', None),) ),
    'user32.ischaralphaw':( 'int', None, 'stdcall', 'user32.IsCharAlphaW', (('int', None),) ),
    'user32.ischarlowera':( 'int', None, 'stdcall', 'user32.IsCharLowerA', (('int', None),) ),
    'user32.ischarlowerw':( 'int', None, 'stdcall', 'user32.IsCharLowerW', (('int', None),) ),
    'user32.ischaruppera':( 'int', None, 'stdcall', 'user32.IsCharUpperA', (('int', None),) ),
    'user32.ischarupperw':( 'int', None, 'stdcall', 'user32.IsCharUpperW', (('int', None),) ),
    'user32.ischild':( 'int', None, 'stdcall', 'user32.IsChild', ( ('void *', 'obj'),) ),
    'user32.isclipboardformatavailable':( 'int', None, 'stdcall', 'user32.IsClipboardFormatAvailable', (('int', None),) ),
    'user32.isdialogmessage':( 'int', None, 'stdcall', 'user32.IsDialogMessage', ( ('void *', 'obj'),) ),
    'user32.isdialogmessagea':( 'int', None, 'stdcall', 'user32.IsDialogMessageA', ( ('void *', 'obj'),) ),
    'user32.isdialogmessagew':( 'int', None, 'stdcall', 'user32.IsDialogMessageW', ( ('void *', 'obj'),) ),
    'user32.isdlgbuttonchecked':( 'int', None, 'stdcall', 'user32.IsDlgButtonChecked', ( ('int', None),) ),
    'user32.isguithread':( 'int', None, 'stdcall', 'user32.IsGUIThread', (('int', None),) ),
    'user32.ishungappwindow':( 'int', None, 'stdcall', 'user32.IsHungAppWindow', (('int', None),) ),
    'user32.isiconic':( 'int', None, 'stdcall', 'user32.IsIconic', () ),
    'user32.ismenu':( 'int', None, 'stdcall', 'user32.IsMenu', () ),
    'user32.isrectempty':( 'int', None, 'stdcall', 'user32.IsRectEmpty', (('int', None),) ),
    'user32.isserversidewindow':( 'int', None, 'stdcall', 'user32.IsServerSideWindow', () ),
    'user32.iswineventhookinstalled':( 'int', None, 'stdcall', 'user32.IsWinEventHookInstalled', (('int', None),) ),
    'user32.iswindow':( 'int', None, 'stdcall', 'user32.IsWindow', () ),
    'user32.iswindowenabled':( 'int', None, 'stdcall', 'user32.IsWindowEnabled', () ),
    'user32.iswindowindestroy':( 'int', None, 'stdcall', 'user32.IsWindowInDestroy', () ),
    'user32.iswindowunicode':( 'int', None, 'stdcall', 'user32.IsWindowUnicode', () ),
    'user32.iswindowvisible':( 'int', None, 'stdcall', 'user32.IsWindowVisible', () ),
    'user32.iszoomed':( 'int', None, 'stdcall', 'user32.IsZoomed', () ),
    'user32.killsystemtimer':( 'int', None, 'stdcall', 'user32.KillSystemTimer', (('int', None), ('int', None)) ),
    'user32.killtimer':( 'int', None, 'stdcall', 'user32.KillTimer', (('int', None), ('int', None)) ),
    'user32.loadacceleratorsa':( 'int', None, 'stdcall', 'user32.LoadAcceleratorsA', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadacceleratorsw':( 'int', None, 'stdcall', 'user32.LoadAcceleratorsW', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadbitmapa':( 'int', None, 'stdcall', 'user32.LoadBitmapA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadbitmapw':( 'int', None, 'stdcall', 'user32.LoadBitmapW', (('int', None), ('int', None)) ),
    'user32.loadcursora':( 'int', None, 'stdcall', 'user32.LoadCursorA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadcursorfromfilea':( 'int', None, 'stdcall', 'user32.LoadCursorFromFileA', (('void *', 'ptr'),) ),
    'user32.loadcursorfromfilew':( 'int', None, 'stdcall', 'user32.LoadCursorFromFileW', (('int', None),) ),
    'user32.loadcursorw':( 'int', None, 'stdcall', 'user32.LoadCursorW', (('int', None), ('int', None)) ),
    'user32.loadicona':( 'int', None, 'stdcall', 'user32.LoadIconA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadiconw':( 'int', None, 'stdcall', 'user32.LoadIconW', (('int', None), ('int', None)) ),
    'user32.loadimagea':( 'int', None, 'stdcall', 'user32.LoadImageA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.loadimagew':( 'int', None, 'stdcall', 'user32.LoadImageW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.loadkeyboardlayouta':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutA', (('int', None), ('int', None)) ),
    'user32.loadkeyboardlayoutex':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutEx', (('int', None), ('int', None), ('int', None)) ),
    'user32.loadkeyboardlayoutw':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutW', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadlocalfonts':( 'int', None, 'cdecl', 'user32.LoadLocalFonts', () ),
    'user32.loadmenua':( 'int', None, 'stdcall', 'user32.LoadMenuA', (('int', None), ('int', None)) ),
    'user32.loadmenuindirecta':( 'int', None, 'stdcall', 'user32.LoadMenuIndirectA', (('int', None),) ),
    'user32.loadmenuindirectw':( 'int', None, 'stdcall', 'user32.LoadMenuIndirectW', (('int', None),) ),
    'user32.loadmenuw':( 'int', None, 'stdcall', 'user32.LoadMenuW', (('int', None), ('int', None)) ),
    'user32.loadremotefonts':( 'int', None, 'cdecl', 'user32.LoadRemoteFonts', () ),
    'user32.loadstringa':( 'int', None, 'stdcall', 'user32.LoadStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.loadstringw':( 'int', None, 'stdcall', 'user32.LoadStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.locksetforegroundwindow':( 'int', None, 'stdcall', 'user32.LockSetForegroundWindow', (('int', None),) ),
    'user32.lockwindowstation':( 'int', None, 'stdcall', 'user32.LockWindowStation', (('int', None),) ),
    'user32.lockwindowupdate':( 'int', None, 'stdcall', 'user32.LockWindowUpdate', (('int', None),) ),
    'user32.lockworkstation':( 'int', None, 'cdecl', 'user32.LockWorkStation', () ),
    'user32.lookupiconidfromdirectory':( 'int', None, 'stdcall', 'user32.LookupIconIdFromDirectory', (('int', None), ('int', None)) ),
    'user32.lookupiconidfromdirectoryex':( 'int', None, 'stdcall', 'user32.LookupIconIdFromDirectoryEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.mbtowcsex':( 'int', None, 'stdcall', 'user32.MBToWCSEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.mb_getstring':( 'int', None, 'stdcall', 'user32.MB_GetString', (('int', None),) ),
    'user32.mapdialogrect':( 'int', None, 'stdcall', 'user32.MapDialogRect', ( ('int', None),) ),
    'user32.mapvirtualkeya':( 'int', None, 'stdcall', 'user32.MapVirtualKeyA', (('int', None), ('int', None)) ),
    'user32.mapvirtualkeyexa':( 'int', None, 'stdcall', 'user32.MapVirtualKeyExA', (('int', None), ('int', None), ('int', None)) ),
    'user32.mapvirtualkeyexw':( 'int', None, 'stdcall', 'user32.MapVirtualKeyExW', (('int', None), ('int', None), ('int', None)) ),
    'user32.mapvirtualkeyw':( 'int', None, 'stdcall', 'user32.MapVirtualKeyW', (('int', None), ('int', None)) ),
    'user32.mapwindowpoints':( 'int', None, 'stdcall', 'user32.MapWindowPoints', ( ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'user32.menuitemfrompoint':( 'int', None, 'stdcall', 'user32.MenuItemFromPoint', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.menuwindowproca':( 'int', None, 'stdcall', 'user32.MenuWindowProcA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.menuwindowprocw':( 'int', None, 'stdcall', 'user32.MenuWindowProcW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messagebeep':( 'int', None, 'stdcall', 'user32.MessageBeep', (('int', None),) ),
    'user32.messageboxa':( 'int', None, 'stdcall', 'user32.MessageBoxA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxexa':( 'int', None, 'stdcall', 'user32.MessageBoxExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxexw':( 'int', None, 'stdcall', 'user32.MessageBoxExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxindirecta':( 'int', None, 'stdcall', 'user32.MessageBoxIndirectA', (('int', None),) ),
    'user32.messageboxindirectw':( 'int', None, 'stdcall', 'user32.MessageBoxIndirectW', (('int', None),) ),
    'user32.messageboxtimeouta':( 'int', None, 'stdcall', 'user32.MessageBoxTimeoutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxtimeoutw':( 'int', None, 'stdcall', 'user32.MessageBoxTimeoutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxw':( 'int', None, 'stdcall', 'user32.MessageBoxW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'user32.modifymenua':( 'int', None, 'stdcall', 'user32.ModifyMenuA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.modifymenuw':( 'int', None, 'stdcall', 'user32.ModifyMenuW', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.monitorfrompoint':( 'int', None, 'stdcall', 'user32.MonitorFromPoint', (('int', None), ('int', None), ('int', None)) ),
    'user32.monitorfromrect':( 'int', None, 'stdcall', 'user32.MonitorFromRect', (('void *', 'ptr'), ('int', None)) ),
    'user32.monitorfromwindow':( 'int', None, 'stdcall', 'user32.MonitorFromWindow', ( ('int', None),) ),
    'user32.movewindow':( 'int', None, 'stdcall', 'user32.MoveWindow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.msgwaitformultipleobjects':( 'int', None, 'stdcall', 'user32.MsgWaitForMultipleObjects', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.msgwaitformultipleobjectsex':( 'int', None, 'stdcall', 'user32.MsgWaitForMultipleObjectsEx', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.notifywinevent':( 'int', None, 'stdcall', 'user32.NotifyWinEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.oemkeyscan':( 'int', None, 'stdcall', 'user32.OemKeyScan', ( ('int', None),) ),
    'user32.oemtochara':( 'int', None, 'stdcall', 'user32.OemToCharA', (('int', None), ('int', None)) ),
    'user32.oemtocharbuffa':( 'int', None, 'stdcall', 'user32.OemToCharBuffA', (('int', None), ('int', None), ('int', None)) ),
    'user32.oemtocharbuffw':( 'int', None, 'stdcall', 'user32.OemToCharBuffW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.oemtocharw':( 'int', None, 'stdcall', 'user32.OemToCharW', (('int', None), ('int', None)) ),
    'user32.offsetrect':( 'int', None, 'stdcall', 'user32.OffsetRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.openclipboard':( 'int', None, 'stdcall', 'user32.OpenClipboard', (('int', None),) ),
    'user32.opendesktopa':( 'int', None, 'stdcall', 'user32.OpenDesktopA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.opendesktopw':( 'int', None, 'stdcall', 'user32.OpenDesktopW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.openicon':( 'int', None, 'stdcall', 'user32.OpenIcon', () ),
    'user32.openinputdesktop':( 'int', None, 'stdcall', 'user32.OpenInputDesktop', (('int', None), ('int', None), ('int', None)) ),
    'user32.openwindowstationa':( 'int', None, 'stdcall', 'user32.OpenWindowStationA', (('int', None), ('int', None), ('int', None)) ),
    'user32.openwindowstationw':( 'int', None, 'stdcall', 'user32.OpenWindowStationW', (('int', None), ('int', None), ('int', None)) ),
    'user32.packddelparam':( 'int', None, 'stdcall', 'user32.PackDDElParam', (('int', None), ('int', None), ('int', None)) ),
    'user32.paintdesktop':( 'int', None, 'stdcall', 'user32.PaintDesktop', (('int', None),) ),
    'user32.paintmenubar':( 'int', None, 'stdcall', 'user32.PaintMenuBar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.peekmessagea':( 'int', None, 'stdcall', 'user32.PeekMessageA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.peekmessagew':( 'int', None, 'stdcall', 'user32.PeekMessageW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.postmessagea':( 'int', None, 'stdcall', 'user32.PostMessageA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.postmessagew':( 'int', None, 'stdcall', 'user32.PostMessageW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.postquitmessage':( 'int', None, 'stdcall', 'user32.PostQuitMessage', (('int', None),) ),
    'user32.postthreadmessagea':( 'int', None, 'stdcall', 'user32.PostThreadMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.postthreadmessagew':( 'int', None, 'stdcall', 'user32.PostThreadMessageW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.printwindow':( 'int', None, 'stdcall', 'user32.PrintWindow', (('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonexa':( 'int', None, 'stdcall', 'user32.PrivateExtractIconExA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonexw':( 'int', None, 'stdcall', 'user32.PrivateExtractIconExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonsa':( 'int', None, 'stdcall', 'user32.PrivateExtractIconsA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonsw':( 'int', None, 'stdcall', 'user32.PrivateExtractIconsW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.privatesetdbgtag':( 'int', None, 'stdcall', 'user32.PrivateSetDbgTag', (('int', None), ('int', None)) ),
    'user32.privatesetripflags':( 'int', None, 'stdcall', 'user32.PrivateSetRipFlags', (('int', None), ('int', None)) ),
    'user32.ptinrect':( 'int', None, 'stdcall', 'user32.PtInRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.querysendmessage':( 'int', None, 'stdcall', 'user32.QuerySendMessage', (('int', None),) ),
    'user32.queryusercounters':( 'int', None, 'stdcall', 'user32.QueryUserCounters', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.realchildwindowfrompoint':( 'int', None, 'stdcall', 'user32.RealChildWindowFromPoint', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclass':( 'int', None, 'stdcall', 'user32.RealGetWindowClass', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclassa':( 'int', None, 'stdcall', 'user32.RealGetWindowClassA', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclassw':( 'int', None, 'stdcall', 'user32.RealGetWindowClassW', (('int', None), ('int', None), ('int', None)) ),
    'user32.reasoncodeneedsbugid':( 'int', None, 'stdcall', 'user32.ReasonCodeNeedsBugID', (('int', None),) ),
    'user32.reasoncodeneedscomment':( 'int', None, 'stdcall', 'user32.ReasonCodeNeedsComment', (('int', None),) ),
    'user32.recordshutdownreason':( 'int', None, 'stdcall', 'user32.RecordShutdownReason', ( ('void *', 'ptr'),) ),
    'user32.redrawwindow':( 'int', None, 'stdcall', 'user32.RedrawWindow', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.registerclassa':( 'int', None, 'stdcall', 'user32.RegisterClassA', (('int', None),) ),
    'user32.registerclassexa':( 'int', None, 'stdcall', 'user32.RegisterClassExA', (('void *', 'ptr'),) ),
    'user32.registerclassexw':( 'int', None, 'stdcall', 'user32.RegisterClassExW', (('void *', 'ptr'),) ),
    'user32.registerclassw':( 'int', None, 'stdcall', 'user32.RegisterClassW', (('int', None),) ),
    'user32.registerclipboardformata':( 'int', None, 'stdcall', 'user32.RegisterClipboardFormatA', (('int', None),) ),
    'user32.registerclipboardformatw':( 'int', None, 'stdcall', 'user32.RegisterClipboardFormatW', (('int', None),) ),
    'user32.registerdevicenotificationa':( 'int', None, 'stdcall', 'user32.RegisterDeviceNotificationA', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerdevicenotificationw':( 'int', None, 'stdcall', 'user32.RegisterDeviceNotificationW', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerhotkey':( 'int', None, 'stdcall', 'user32.RegisterHotKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.registerlogonprocess':( 'int', None, 'stdcall', 'user32.RegisterLogonProcess', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.registermessagepumphook':( 'int', None, 'stdcall', 'user32.RegisterMessagePumpHook', (('void *', 'funcptr'),) ),
    'user32.registerrawinputdevices':( 'int', None, 'stdcall', 'user32.RegisterRawInputDevices', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerservicesprocess':( 'int', None, 'stdcall', 'user32.RegisterServicesProcess', (('int', None),) ),
    'user32.registershellhookwindow':( 'int', None, 'stdcall', 'user32.RegisterShellHookWindow', (('int', None),) ),
    'user32.registersystemthread':( 'int', None, 'stdcall', 'user32.RegisterSystemThread', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.registertasklist':( 'int', None, 'stdcall', 'user32.RegisterTasklist', (('int', None),) ),
    'user32.registeruserapihook':( 'int', None, 'stdcall', 'user32.RegisterUserApiHook', (('int', None), ('int', None)) ),
    'user32.registerwindowmessagea':( 'int', None, 'stdcall', 'user32.RegisterWindowMessageA', (('int', None),) ),
    'user32.registerwindowmessagew':( 'int', None, 'stdcall', 'user32.RegisterWindowMessageW', (('int', None),) ),
    'user32.releasecapture':( 'int', None, 'cdecl', 'user32.ReleaseCapture', () ),
    'user32.releasedc':( 'int', None, 'stdcall', 'user32.ReleaseDC', (('int', None), ('int', None)) ),
    'user32.removemenu':( 'int', None, 'stdcall', 'user32.RemoveMenu', (('int', None), ('int', None), ('int', None)) ),
    'user32.removepropa':( 'int', None, 'stdcall', 'user32.RemovePropA', (('int', None), ('int', None)) ),
    'user32.removepropw':( 'int', None, 'stdcall', 'user32.RemovePropW', (('int', None), ('int', None)) ),
    'user32.replymessage':( 'int', None, 'stdcall', 'user32.ReplyMessage', (('int', None),) ),
    'user32.resolvedesktopforwow':( 'int', None, 'stdcall', 'user32.ResolveDesktopForWOW', (('int', None),) ),
    'user32.reuseddelparam':( 'int', None, 'stdcall', 'user32.ReuseDDElParam', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.screentoclient':( 'int', None, 'stdcall', 'user32.ScreenToClient', ( ('void *', 'ptr'),) ),
    'user32.scrollchildren':( 'int', None, 'stdcall', 'user32.ScrollChildren', ( ('int', None), ('int', None)) ),
    'user32.scrolldc':( 'int', None, 'stdcall', 'user32.ScrollDC', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.scrollwindow':( 'int', None, 'stdcall', 'user32.ScrollWindow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.scrollwindowex':( 'int', None, 'stdcall', 'user32.ScrollWindowEx', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.senddlgitemmessagea':( 'int', None, 'stdcall', 'user32.SendDlgItemMessageA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.senddlgitemmessagew':( 'int', None, 'stdcall', 'user32.SendDlgItemMessageW', ( ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.sendimemessageexa':( 'int', None, 'stdcall', 'user32.SendIMEMessageExA', (('int', None), ('int', None)) ),
    'user32.sendimemessageexw':( 'int', None, 'stdcall', 'user32.SendIMEMessageExW', (('int', None), ('int', None)) ),
    'user32.sendinput':( 'int', None, 'stdcall', 'user32.SendInput', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.sendmessagea':( 'int', None, 'stdcall', 'user32.SendMessageA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagecallbacka':( 'int', None, 'stdcall', 'user32.SendMessageCallbackA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagecallbackw':( 'int', None, 'stdcall', 'user32.SendMessageCallbackW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagetimeouta':( 'int', None, 'stdcall', 'user32.SendMessageTimeoutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagetimeoutw':( 'int', None, 'stdcall', 'user32.SendMessageTimeoutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.sendmessagew':( 'int', None, 'stdcall', 'user32.SendMessageW', ( ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.sendnotifymessagea':( 'int', None, 'stdcall', 'user32.SendNotifyMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendnotifymessagew':( 'int', None, 'stdcall', 'user32.SendNotifyMessageW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setactivewindow':( 'int', None, 'stdcall', 'user32.SetActiveWindow', (('int', None),) ),
    'user32.setcapture':( 'int', None, 'stdcall', 'user32.SetCapture', (('int', None),) ),
    'user32.setcaretblinktime':( 'int', None, 'stdcall', 'user32.SetCaretBlinkTime', (('int', None),) ),
    'user32.setcaretpos':( 'int', None, 'stdcall', 'user32.SetCaretPos', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.setclasslonga':( 'int', None, 'stdcall', 'user32.SetClassLongA', (('int', None), ('int', None), ('int', None)) ),
    'user32.setclasslongw':( 'int', None, 'stdcall', 'user32.SetClassLongW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.setclassword':( 'int', None, 'stdcall', 'user32.SetClassWord', (('int', None), ('int', None), ('int', None)) ),
    'user32.setclipboarddata':( 'int', None, 'stdcall', 'user32.SetClipboardData', (('int', None), ('int', None)) ),
    'user32.setclipboardviewer':( 'int', None, 'stdcall', 'user32.SetClipboardViewer', (('int', None),) ),
    'user32.setconsolereservekeys':( 'int', None, 'stdcall', 'user32.SetConsoleReserveKeys', (('int', None), ('int', None)) ),
    'user32.setcursor':( 'int', None, 'stdcall', 'user32.SetCursor', (('int', None),) ),
    'user32.setcursorcontents':( 'int', None, 'stdcall', 'user32.SetCursorContents', (('int', None), ('int', None)) ),
    'user32.setcursorpos':( 'int', None, 'stdcall', 'user32.SetCursorPos', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.setdebugerrorlevel':( 'int', None, 'stdcall', 'user32.SetDebugErrorLevel', (('int', None),) ),
    'user32.setdeskwallpaper':( 'int', None, 'stdcall', 'user32.SetDeskWallpaper', (('void *', 'ptr'),) ),
    'user32.setdlgitemint':( 'int', None, 'stdcall', 'user32.SetDlgItemInt', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.setdlgitemtexta':( 'int', None, 'stdcall', 'user32.SetDlgItemTextA', ( ('int', None), ('void *', 'obj')) ),
    'user32.setdlgitemtextw':( 'int', None, 'stdcall', 'user32.SetDlgItemTextW', ( ('int', None), ('void *', 'obj')) ),
    'user32.setdoubleclicktime':( 'int', None, 'stdcall', 'user32.SetDoubleClickTime', (('int', None),) ),
    'user32.setfocus':( 'int', None, 'stdcall', 'user32.SetFocus', (('int', None),) ),
    'user32.setforegroundwindow':( 'int', None, 'stdcall', 'user32.SetForegroundWindow', (('int', None),) ),
    'user32.setinternalwindowpos':( 'int', None, 'stdcall', 'user32.SetInternalWindowPos', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setkeyboardstate':( 'int', None, 'stdcall', 'user32.SetKeyboardState', (('int', None),) ),
    'user32.setlasterrorex':( 'int', None, 'stdcall', 'user32.SetLastErrorEx', (('int', None), ('int', None)) ),
    'user32.setlayeredwindowattributes':( 'int', None, 'stdcall', 'user32.SetLayeredWindowAttributes', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setlogonnotifywindow':( 'int', None, 'stdcall', 'user32.SetLogonNotifyWindow', (('int', None),) ),
    'user32.setmenu':( 'int', None, 'stdcall', 'user32.SetMenu', (('int', None), ('int', None)) ),
    'user32.setmenucontexthelpid':( 'int', None, 'stdcall', 'user32.SetMenuContextHelpId', (('int', None), ('int', None)) ),
    'user32.setmenudefaultitem':( 'int', None, 'stdcall', 'user32.SetMenuDefaultItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuinfo':( 'int', None, 'stdcall', 'user32.SetMenuInfo', (('int', None), ('int', None)) ),
    'user32.setmenuitembitmaps':( 'int', None, 'stdcall', 'user32.SetMenuItemBitmaps', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuiteminfoa':( 'int', None, 'stdcall', 'user32.SetMenuItemInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuiteminfow':( 'int', None, 'stdcall', 'user32.SetMenuItemInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.setmessageextrainfo':( 'int', None, 'stdcall', 'user32.SetMessageExtraInfo', (('int', None),) ),
    'user32.setmessagequeue':( 'int', None, 'stdcall', 'user32.SetMessageQueue', (('int', None),) ),
    'user32.setparent':( 'int', None, 'stdcall', 'user32.SetParent', (('int', None), ('int', None)) ),
    'user32.setprocessdefaultlayout':( 'int', None, 'stdcall', 'user32.SetProcessDefaultLayout', (('int', None),) ),
    'user32.setprocesswindowstation':( 'int', None, 'stdcall', 'user32.SetProcessWindowStation', (('int', None),) ),
    'user32.setprogmanwindow':( 'int', None, 'stdcall', 'user32.SetProgmanWindow', (('int', None),) ),
    'user32.setpropa':( 'int', None, 'stdcall', 'user32.SetPropA', (('int', None), ('int', None), ('int', None)) ),
    'user32.setpropw':( 'int', None, 'stdcall', 'user32.SetPropW', (('int', None), ('int', None), ('int', None)) ),
    'user32.setrect':( 'int', None, 'stdcall', 'user32.SetRect', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setrectempty':( 'int', None, 'stdcall', 'user32.SetRectEmpty', (('int', None),) ),
    'user32.setscrollinfo':( 'int', None, 'stdcall', 'user32.SetScrollInfo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.setscrollpos':( 'int', None, 'stdcall', 'user32.SetScrollPos', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setscrollrange':( 'int', None, 'stdcall', 'user32.SetScrollRange', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setshellwindow':( 'int', None, 'stdcall', 'user32.SetShellWindow', (('int', None),) ),
    'user32.setshellwindowex':( 'int', None, 'stdcall', 'user32.SetShellWindowEx', (('int', None), ('int', None)) ),
    'user32.setsyscolors':( 'int', None, 'stdcall', 'user32.SetSysColors', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.setsyscolorstemp':( 'int', None, 'stdcall', 'user32.SetSysColorsTemp', (('int', None), ('int', None), ('int', None)) ),
    'user32.setsystemcursor':( 'int', None, 'stdcall', 'user32.SetSystemCursor', (('int', None), ('int', None)) ),
    'user32.setsystemmenu':( 'int', None, 'stdcall', 'user32.SetSystemMenu', (('int', None), ('int', None)) ),
    'user32.setsystemtimer':( 'int', None, 'stdcall', 'user32.SetSystemTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.settaskmanwindow':( 'int', None, 'stdcall', 'user32.SetTaskmanWindow', (('int', None),) ),
    'user32.setthreaddesktop':( 'int', None, 'stdcall', 'user32.SetThreadDesktop', (('int', None),) ),
    'user32.settimer':( 'int', None, 'stdcall', 'user32.SetTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectinformationa':( 'int', None, 'stdcall', 'user32.SetUserObjectInformationA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectinformationw':( 'int', None, 'stdcall', 'user32.SetUserObjectInformationW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectsecurity':( 'int', None, 'stdcall', 'user32.SetUserObjectSecurity', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwineventhook':( 'int', None, 'stdcall', 'user32.SetWinEventHook', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowcontexthelpid':( 'int', None, 'stdcall', 'user32.SetWindowContextHelpId', (('int', None), ('int', None)) ),
    'user32.setwindowlonga':( 'int', None, 'stdcall', 'user32.SetWindowLongA', ( ('int', None), ('void *', 'obj')) ),
    'user32.setwindowlongw':( 'int', None, 'stdcall', 'user32.SetWindowLongW', ( ('int', None), ('void *', 'obj')) ),
    'user32.setwindowplacement':( 'int', None, 'stdcall', 'user32.SetWindowPlacement', (('int', None), ('int', None)) ),
    'user32.setwindowpos':( 'int', None, 'stdcall', 'user32.SetWindowPos', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowrgn':( 'int', None, 'stdcall', 'user32.SetWindowRgn', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowstationuser':( 'int', None, 'stdcall', 'user32.SetWindowStationUser', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowtexta':( 'int', None, 'stdcall', 'user32.SetWindowTextA', ( ('void *', 'obj'),) ),
    'user32.setwindowtextw':( 'int', None, 'stdcall', 'user32.SetWindowTextW', ( ('void *', 'obj'),) ),
    'user32.setwindowword':( 'int', None, 'stdcall', 'user32.SetWindowWord', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshooka':( 'int', None, 'stdcall', 'user32.SetWindowsHookA', (('int', None), ('int', None)) ),
    'user32.setwindowshookexa':( 'int', None, 'stdcall', 'user32.SetWindowsHookExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshookexw':( 'int', None, 'stdcall', 'user32.SetWindowsHookExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshookw':( 'int', None, 'stdcall', 'user32.SetWindowsHookW', (('int', None), ('int', None)) ),
    'user32.showcaret':( 'int', None, 'stdcall', 'user32.ShowCaret', (('int', None),) ),
    'user32.showcursor':( 'int', None, 'stdcall', 'user32.ShowCursor', (('int', None),) ),
    'user32.showownedpopups':( 'int', None, 'stdcall', 'user32.ShowOwnedPopups', (('int', None), ('int', None)) ),
    'user32.showscrollbar':( 'int', None, 'stdcall', 'user32.ShowScrollBar', (('int', None), ('int', None), ('int', None)) ),
    'user32.showstartglass':( 'int', None, 'stdcall', 'user32.ShowStartGlass', (('int', None),) ),
    'user32.showwindow':( 'int', None, 'stdcall', 'user32.ShowWindow', (('int', None), ('int', None)) ),
    'user32.showwindowasync':( 'int', None, 'stdcall', 'user32.ShowWindowAsync', (('int', None), ('int', None)) ),
    'user32.softmodalmessagebox':( 'int', None, 'stdcall', 'user32.SoftModalMessageBox', () ),
    'user32.subtractrect':( 'int', None, 'stdcall', 'user32.SubtractRect', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.swapmousebutton':( 'int', None, 'stdcall', 'user32.SwapMouseButton', (('int', None),) ),
    'user32.switchdesktop':( 'int', None, 'stdcall', 'user32.SwitchDesktop', (('int', None),) ),
    'user32.switchtothiswindow':( 'int', None, 'stdcall', 'user32.SwitchToThisWindow', (('int', None), ('int', None)) ),
    'user32.systemparametersinfoa':( 'int', None, 'stdcall', 'user32.SystemParametersInfoA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.systemparametersinfow':( 'int', None, 'stdcall', 'user32.SystemParametersInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tabbedtextouta':( 'int', None, 'stdcall', 'user32.TabbedTextOutA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tabbedtextoutw':( 'int', None, 'stdcall', 'user32.TabbedTextOutW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tilechildwindows':( 'int', None, 'stdcall', 'user32.TileChildWindows', ( ('int', None),) ),
    'user32.tilewindows':( 'int', None, 'stdcall', 'user32.TileWindows', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.toascii':( 'int', None, 'stdcall', 'user32.ToAscii', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.toasciiex':( 'int', None, 'stdcall', 'user32.ToAsciiEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tounicode':( 'int', None, 'stdcall', 'user32.ToUnicode', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tounicodeex':( 'int', None, 'stdcall', 'user32.ToUnicodeEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.trackmouseevent':( 'int', None, 'stdcall', 'user32.TrackMouseEvent', (('int', None),) ),
    'user32.trackpopupmenu':( 'int', None, 'stdcall', 'user32.TrackPopupMenu', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.trackpopupmenuex':( 'int', None, 'stdcall', 'user32.TrackPopupMenuEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.translateaccelerator':( 'int', None, 'stdcall', 'user32.TranslateAccelerator', (('int', None), ('int', None), ('int', None)) ),
    'user32.translateacceleratora':( 'int', None, 'stdcall', 'user32.TranslateAcceleratorA', (('int', None), ('int', None), ('int', None)) ),
    'user32.translateacceleratorw':( 'int', None, 'stdcall', 'user32.TranslateAcceleratorW', (('int', None), ('int', None), ('int', None)) ),
    'user32.translatemdisysaccel':( 'int', None, 'stdcall', 'user32.TranslateMDISysAccel', ( ('int', None),) ),
    'user32.translatemessage':( 'int', None, 'stdcall', 'user32.TranslateMessage', (('void *', 'ptr'),) ),
    'user32.translatemessageex':( 'int', None, 'stdcall', 'user32.TranslateMessageEx', (('int', None), ('int', None)) ),
    'user32.unhookwinevent':( 'int', None, 'stdcall', 'user32.UnhookWinEvent', (('int', None),) ),
    'user32.unhookwindowshook':( 'int', None, 'stdcall', 'user32.UnhookWindowsHook', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unhookwindowshookex':( 'int', None, 'stdcall', 'user32.UnhookWindowsHookEx', (('int', None),) ),
    'user32.unionrect':( 'int', None, 'stdcall', 'user32.UnionRect', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unloadkeyboardlayout':( 'int', None, 'stdcall', 'user32.UnloadKeyboardLayout', (('int', None),) ),
    'user32.unlockwindowstation':( 'int', None, 'stdcall', 'user32.UnlockWindowStation', (('int', None),) ),
    'user32.unpackddelparam':( 'int', None, 'stdcall', 'user32.UnpackDDElParam', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unregisterclassa':( 'int', None, 'stdcall', 'user32.UnregisterClassA', (('int', None), ('int', None)) ),
    'user32.unregisterclassw':( 'int', None, 'stdcall', 'user32.UnregisterClassW', (('int', None), ('int', None)) ),
    'user32.unregisterdevicenotification':( 'int', None, 'stdcall', 'user32.UnregisterDeviceNotification', (('int', None),) ),
    'user32.unregisterhotkey':( 'int', None, 'stdcall', 'user32.UnregisterHotKey', (('int', None), ('int', None)) ),
    'user32.unregistermessagepumphook':( 'int', None, 'cdecl', 'user32.UnregisterMessagePumpHook', () ),
    'user32.unregisteruserapihook':( 'int', None, 'cdecl', 'user32.UnregisterUserApiHook', () ),
    'user32.updatelayeredwindow':( 'int', None, 'stdcall', 'user32.UpdateLayeredWindow', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.updateperusersystemparameters':( 'int', None, 'stdcall', 'user32.UpdatePerUserSystemParameters', (('int', None), ('int', None)) ),
    'user32.updatewindow':( 'int', None, 'stdcall', 'user32.UpdateWindow', () ),
    'user32.user32initializeimmentrytable':( 'int', None, 'stdcall', 'user32.User32InitializeImmEntryTable', (('int', None),) ),
    'user32.userclientdllinitialize':( 'int', None, 'stdcall', 'user32.UserClientDllInitialize', (('int', None), ('int', None), ('int', None)) ),
    'user32.userhandlegrantaccess':( 'int', None, 'stdcall', 'user32.UserHandleGrantAccess', (('int', None), ('int', None), ('int', None)) ),
    'user32.userlpkpsmtextout':( 'int', None, 'stdcall', 'user32.UserLpkPSMTextOut', (('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.userlpktabbedtextout':( 'int', None, 'stdcall', 'user32.UserLpkTabbedTextOut', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.userrealizepalette':( 'int', None, 'stdcall', 'user32.UserRealizePalette', (('int', None),) ),
    'user32.userregisterwowhandlers':( 'int', None, 'stdcall', 'user32.UserRegisterWowHandlers', (('int', None), ('int', None)) ),
    'user32.vripoutput':( 'int', None, 'cdecl', 'user32.VRipOutput', () ),
    'user32.vtagoutput':( 'int', None, 'cdecl', 'user32.VTagOutput', () ),
    'user32.validaterect':( 'int', None, 'stdcall', 'user32.ValidateRect', (('int', None), ('int', None)) ),
    'user32.validatergn':( 'int', None, 'stdcall', 'user32.ValidateRgn', (('int', None), ('int', None)) ),
    'user32.vkkeyscana':( 'int', None, 'stdcall', 'user32.VkKeyScanA', ( ('int', None),) ),
    'user32.vkkeyscanexa':( 'int', None, 'stdcall', 'user32.VkKeyScanExA', ( ('int', None), ('int', None)) ),
    'user32.vkkeyscanexw':( 'int', None, 'stdcall', 'user32.VkKeyScanExW', (('int', None), ('int', None)) ),
    'user32.vkkeyscanw':( 'int', None, 'stdcall', 'user32.VkKeyScanW', (('int', None),) ),
    'user32.wcstombex':( 'int', None, 'stdcall', 'user32.WCSToMBEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.winnlsenableime':( 'int', None, 'stdcall', 'user32.WINNLSEnableIME', (('int', None), ('int', None)) ),
    'user32.winnlsgetenablestatus':( 'int', None, 'stdcall', 'user32.WINNLSGetEnableStatus', (('int', None),) ),
    'user32.winnlsgetimehotkey':( 'int', None, 'stdcall', 'user32.WINNLSGetIMEHotkey', (('int', None),) ),
    'user32.waitforinputidle':( 'int', None, 'stdcall', 'user32.WaitForInputIdle', (('int', None), ('int', None)) ),
    'user32.waitmessage':( 'int', None, 'cdecl', 'user32.WaitMessage', () ),
    'user32.win32poolallocationstats':( 'int', None, 'stdcall', 'user32.Win32PoolAllocationStats', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.winhelpa':( 'int', None, 'stdcall', 'user32.WinHelpA', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.winhelpw':( 'int', None, 'stdcall', 'user32.WinHelpW', ( ('int', None), ('int', None), ('int', None)) ),
    'user32.windowfromdc':( 'int', None, 'stdcall', 'user32.WindowFromDC', (('int', None),) ),
    'user32.windowfrompoint':( 'int', None, 'stdcall', 'user32.WindowFromPoint', (('int', None), ('int', None)) ),
    'user32.keybd_event':( 'int', None, 'stdcall', 'user32.keybd_event', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.mouse_event':( 'int', None, 'stdcall', 'user32.mouse_event', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.wsprintfa':( 'int', None, 'cdecl', 'user32.wsprintfA', (('int', None), ('int', None)) ),
    'user32.wsprintfw':( 'int', None, 'cdecl', 'user32.wsprintfW', (('void *', 'ptr'), ('int', None)) ),
    'user32.wvsprintfa':( 'int', None, 'stdcall', 'user32.wvsprintfA', (('int', None), ('int', None), ('int', None)) ),
    'user32.wvsprintfw':( 'int', None, 'stdcall', 'user32.wvsprintfW', (('int', None), ('int', None), ('int', None)) ),

    # RPCRT4
    'rpcrt4.main_entry':( 'int', None, 'stdcall', 'rpcrt4.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_addref':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_AddRef', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_connect':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Connect', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_countrefs':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_CountRefs', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_debugserverqueryinterface':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_DebugServerQueryInterface', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_debugserverrelease':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_DebugServerRelease', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_disconnect':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Disconnect', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_invoke':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Invoke', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_isiidsupported':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_IsIIDSupported', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_queryinterface':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_QueryInterface', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.checkverificationtrailer':( 'int', None, 'stdcall', 'rpcrt4.CheckVerificationTrailer', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.createproxyfromtypeinfo':( 'int', None, 'stdcall', 'rpcrt4.CreateProxyFromTypeInfo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.createstubfromtypeinfo':( 'int', None, 'stdcall', 'rpcrt4.CreateStubFromTypeInfo', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.dceerrorinqtexta':( 'int', None, 'stdcall', 'rpcrt4.DceErrorInqTextA', (('int', None), ('int', None)) ),
    'rpcrt4.dceerrorinqtextw':( 'int', None, 'stdcall', 'rpcrt4.DceErrorInqTextW', (('int', None), ('int', None)) ),
    'rpcrt4.dllgetclassobject':( 'int', None, 'stdcall', 'rpcrt4.DllGetClassObject', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.dllregisterserver':( 'int', None, 'cdecl', 'rpcrt4.DllRegisterServer', () ),
    'rpcrt4.globalmutexclearexternal':( 'int', None, 'cdecl', 'rpcrt4.GlobalMutexClearExternal', () ),
    'rpcrt4.globalmutexrequestexternal':( 'int', None, 'cdecl', 'rpcrt4.GlobalMutexRequestExternal', () ),
    'rpcrt4.iunknown_addref_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_AddRef_Proxy', (('int', None),) ),
    'rpcrt4.iunknown_queryinterface_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_QueryInterface_Proxy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.iunknown_release_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_Release_Proxy', (('int', None),) ),
    'rpcrt4.i_rpcallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAllocate', (('DWORD', None),) ),
    'rpcrt4.i_rpcasyncabortcall':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAsyncAbortCall', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcasyncsethandle':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAsyncSetHandle', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbcacheallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBCacheAllocate', (('DWORD', None),) ),
    'rpcrt4.i_rpcbcachefree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBCacheFree', (('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindingcopy':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingCopy', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindinghandletoasynchandle':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingHandleToAsyncHandle', ( ('int', None),) ),
    'rpcrt4.i_rpcbindinginqconnid':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqConnId', ( ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqdynamicendpointa':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqDynamicEndpointA', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqdynamicendpointw':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqDynamicEndpointW', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindinginqlocalclientpid':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqLocalClientPID', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqsecuritycontext':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqSecurityContext', ( ('int', None),) ),
    'rpcrt4.i_rpcbindinginqtransporttype':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqTransportType', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqwireidforsnego':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqWireIdForSnego', ( ('int', None),) ),
    'rpcrt4.i_rpcbindingisclientlocal':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingIsClientLocal', ( ('int', None),) ),
    'rpcrt4.i_rpcbindingtostaticstringbindingw':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingToStaticStringBindingW', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcclearmutex':( 'int', None, 'cdecl', 'rpcrt4.I_RpcClearMutex', () ),
    'rpcrt4.i_rpcconnectioninqsockbuffsize':( 'int', None, 'stdcall', 'rpcrt4.I_RpcConnectionInqSockBuffSize', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcconnectionsetsockbuffsize':( 'int', None, 'stdcall', 'rpcrt4.I_RpcConnectionSetSockBuffSize', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcdeletemutex':( 'int', None, 'stdcall', 'rpcrt4.I_RpcDeleteMutex', () ),
    'rpcrt4.i_rpcenablewmitrace':( 'int', None, 'stdcall', 'rpcrt4.I_RpcEnableWmiTrace', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcexceptionfilter':( 'int', None, 'stdcall', 'rpcrt4.I_RpcExceptionFilter', (('int', None),) ),
    'rpcrt4.i_rpcfree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFree', (('void *', 'ptr'),) ),
    'rpcrt4.i_rpcfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFreeBuffer', (('int', None),) ),
    'rpcrt4.i_rpcfreepipebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFreePipeBuffer', (('int', None),) ),
    'rpcrt4.i_rpcgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcGetBuffer', (('int', None),) ),
    'rpcrt4.i_rpcgetbufferwithobject':( 'int', None, 'stdcall', 'rpcrt4.I_RpcGetBufferWithObject', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.i_rpcgetcurrentcallhandle':( 'int', None, 'cdecl', 'rpcrt4.I_RpcGetCurrentCallHandle', () ),
    'rpcrt4.i_rpcgetextendederror':( 'int', None, 'cdecl', 'rpcrt4.I_RpcGetExtendedError', () ),
    'rpcrt4.i_rpcifinqtransfersyntaxes':( 'int', None, 'stdcall', 'rpcrt4.I_RpcIfInqTransferSyntaxes', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpclogevent':( 'int', None, 'stdcall', 'rpcrt4.I_RpcLogEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcmapwin32status':( 'int', None, 'stdcall', 'rpcrt4.I_RpcMapWin32Status', (('int', None),) ),
    'rpcrt4.i_rpcnegotiatetransfersyntax':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNegotiateTransferSyntax', (('int', None),) ),
    'rpcrt4.i_rpcnsbindingsetentrynamea':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsBindingSetEntryNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsbindingsetentrynamew':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsBindingSetEntryNameW', ( ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsinterfaceexported':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsInterfaceExported', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsinterfaceunexported':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsInterfaceUnexported', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcparsesecurity':( 'int', None, 'stdcall', 'rpcrt4.I_RpcParseSecurity', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcpauseexecution':( 'int', None, 'cdecl', 'rpcrt4.I_RpcPauseExecution', () ),
    'rpcrt4.i_rpcproxynewconnection':( 'int', None, 'stdcall', 'rpcrt4.I_RpcProxyNewConnection', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcreallocpipebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcReallocPipeBuffer', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcreceive':( 'int', None, 'stdcall', 'rpcrt4.I_RpcReceive', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcrequestmutex':( 'int', None, 'stdcall', 'rpcrt4.I_RpcRequestMutex', (('int', None),) ),
    'rpcrt4.i_rpcsend':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSend', (('int', None),) ),
    'rpcrt4.i_rpcsendreceive':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSendReceive', (('int', None),) ),
    'rpcrt4.i_rpcserverallocateipport':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerAllocateIpPort', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcservercheckclientrestriction':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerCheckClientRestriction', () ),
    'rpcrt4.i_rpcserverinqaddresschangefn':( 'int', None, 'cdecl', 'rpcrt4.I_RpcServerInqAddressChangeFn', () ),
    'rpcrt4.i_rpcserverinqlocalconnaddress':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerInqLocalConnAddress', ( ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcserverinqtransporttype':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerInqTransportType', (('int', None),) ),
    'rpcrt4.i_rpcserverregisterforwardfunction':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerRegisterForwardFunction', (('int', None),) ),
    'rpcrt4.i_rpcserversetaddresschangefn':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerSetAddressChangeFn', (('int', None),) ),
    'rpcrt4.i_rpcserveruseprotseq2a':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseq2A', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcserveruseprotseq2w':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseq2W', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.i_rpcserveruseprotseqep2a':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseqEp2A', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcserveruseprotseqep2w':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseqEp2W', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.i_rpcsessionstrictcontexthandle':( 'int', None, 'cdecl', 'rpcrt4.I_RpcSessionStrictContextHandle', () ),
    'rpcrt4.i_rpcssdontserializecontext':( 'int', None, 'cdecl', 'rpcrt4.I_RpcSsDontSerializeContext', () ),
    'rpcrt4.i_rpcsystemfunction001':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSystemFunction001', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransconnectionallocatepacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionAllocatePacket', (('int', None), ('DWORD', None)) ),
    'rpcrt4.i_rpctransconnectionfreepacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionFreePacket', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpctransconnectionreallocpacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionReallocPacket', (('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'rpcrt4.i_rpctransdatagramallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramAllocate', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransdatagramallocate2':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramAllocate2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransdatagramfree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramFree', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpctransgetthreadevent':( 'int', None, 'cdecl', 'rpcrt4.I_RpcTransGetThreadEvent', () ),
    'rpcrt4.i_rpctransiocancelled':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransIoCancelled', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpctransservernewconnection':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransServerNewConnection', () ),
    'rpcrt4.i_rpcturnoneeinfopropagation':( 'int', None, 'cdecl', 'rpcrt4.I_RpcTurnOnEEInfoPropagation', () ),
    'rpcrt4.i_uuidcreate':( 'int', None, 'stdcall', 'rpcrt4.I_UuidCreate', (('int', None),) ),
    'rpcrt4.midl_wchar_strcpy':( 'int', None, 'stdcall', 'rpcrt4.MIDL_wchar_strcpy', (('int', None), ('int', None)) ),
    'rpcrt4.midl_wchar_strlen':( 'int', None, 'stdcall', 'rpcrt4.MIDL_wchar_strlen', (('int', None),) ),
    'rpcrt4.mesbufferhandlereset':( 'int', None, 'stdcall', 'rpcrt4.MesBufferHandleReset', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.mesdecodebufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesDecodeBufferHandleCreate', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.mesdecodeincrementalhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesDecodeIncrementalHandleCreate', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.mesencodedynbufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeDynBufferHandleCreate', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.mesencodefixedbufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeFixedBufferHandleCreate', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.mesencodeincrementalhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeIncrementalHandleCreate', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.meshandlefree':( 'int', None, 'stdcall', 'rpcrt4.MesHandleFree', (('void *', 'ptr'),) ),
    'rpcrt4.mesincrementalhandlereset':( 'int', None, 'stdcall', 'rpcrt4.MesIncrementalHandleReset', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.mesinqprocencodingid':( 'int', None, 'stdcall', 'rpcrt4.MesInqProcEncodingId', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrccontextbinding':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextBinding', (('int', None),) ),
    'rpcrt4.ndrccontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrccontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextUnmarshall', (('int', None),) ),
    'rpcrt4.ndrscontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshall', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextmarshall2':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshall2', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextmarshallex':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshallEx', ( ('void *', 'obj'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshall2':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshall2', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshallex':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshallEx', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrcopy':( 'int', None, 'stdcall', 'rpcrt4.NDRcopy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrAllocate', (('int', None), ('int', None)) ),
    'rpcrt4.ndrasyncclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrAsyncClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrasyncservercall':( 'int', None, 'stdcall', 'rpcrt4.NdrAsyncServerCall', (('int', None),) ),
    'rpcrt4.ndrbytecountpointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcstdstubbuffer2_release':( 'int', None, 'stdcall', 'rpcrt4.NdrCStdStubBuffer2_Release', (('int', None), ('int', None)) ),
    'rpcrt4.ndrcstdstubbuffer_release':( 'int', None, 'stdcall', 'rpcrt4.NdrCStdStubBuffer_Release', (('int', None), ('int', None)) ),
    'rpcrt4.ndrclearoutparameters':( 'int', None, 'stdcall', 'rpcrt4.NdrClearOutParameters', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcall2':( 'int', None, 'cdecl', 'rpcrt4.NdrClientCall2', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrClientContextMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrClientContextUnmarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrClientInitialize', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientinitializenew':( 'int', None, 'stdcall', 'rpcrt4.NdrClientInitializeNew', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrcomplexarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrcomplexstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrcomplexstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrconformantarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructMemorySize', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrconformantvaryingarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructMemorySize', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructUnmarshall', (('void *', 'ptr'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrcontexthandleinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrContextHandleInitialize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrcontexthandlesize':( 'int', None, 'stdcall', 'rpcrt4.NdrContextHandleSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconvert':( 'int', None, 'stdcall', 'rpcrt4.NdrConvert', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrconvert2':( 'int', None, 'stdcall', 'rpcrt4.NdrConvert2', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcorrelationfree':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrcorrelationinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationInitialize', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcorrelationpass':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationPass', (('int', None),) ),
    'rpcrt4.ndrcreateserverinterfacefromstub':( 'int', None, 'stdcall', 'rpcrt4.NdrCreateServerInterfaceFromStub', (('int', None), ('int', None)) ),
    'rpcrt4.ndrdcomasyncclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrDcomAsyncClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdcomasyncstubcall':( 'int', None, 'stdcall', 'rpcrt4.NdrDcomAsyncStubCall', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrdllcanunloadnow':( 'int', None, 'stdcall', 'rpcrt4.NdrDllCanUnloadNow', (('int', None),) ),
    'rpcrt4.ndrdllgetclassobject':( 'int', None, 'stdcall', 'rpcrt4.NdrDllGetClassObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdllregisterproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrDllRegisterProxy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdllunregisterproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrDllUnregisterProxy', (('int', None), ('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrencapsulatedunionbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionfree':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrFreeBuffer', (('void *', 'ptr'),) ),
    'rpcrt4.ndrfullpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerFree', (('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerinsertrefid':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerInsertRefId', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerquerypointer':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerQueryPointer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerqueryrefid':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerQueryRefId', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerxlatfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerXlatFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrfullpointerxlatinit':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerXlatInit', (('DWORD', None), ('int', None)) ),
    'rpcrt4.ndrgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrGetBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrgetdcomprotocolversion':( 'int', None, 'stdcall', 'rpcrt4.NdrGetDcomProtocolVersion', (('int', None), ('int', None)) ),
    'rpcrt4.ndrgetsimpletypebufferalignment':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeBufferAlignment', (('int', None),) ),
    'rpcrt4.ndrgetsimpletypebuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeBufferSize', (('int', None),) ),
    'rpcrt4.ndrgetsimpletypememorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeMemorySize', (('int', None),) ),
    'rpcrt4.ndrgettypeflags':( 'int', None, 'stdcall', 'rpcrt4.NdrGetTypeFlags', (('int', None),) ),
    'rpcrt4.ndrgetusermarshalinfo':( 'int', None, 'stdcall', 'rpcrt4.NdrGetUserMarshalInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrinterfacepointermemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmapcommandfaultstatus':( 'int', None, 'stdcall', 'rpcrt4.NdrMapCommAndFaultStatus', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmesprocencodedecode':( 'int', None, 'cdecl', 'rpcrt4.NdrMesProcEncodeDecode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmesprocencodedecode2':( 'int', None, 'cdecl', 'rpcrt4.NdrMesProcEncodeDecode2', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmessimpletypealignsize':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeAlignSize', (('int', None),) ),
    'rpcrt4.ndrmessimpletypedecode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeDecode', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmessimpletypeencode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeEncode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypealignsize':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeAlignSize', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypealignsize2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeAlignSize2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypedecode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeDecode', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypedecode2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeDecode2', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypeencode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeEncode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypeencode2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeEncode2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypefree2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeFree2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrnonencapsulatedunionbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionfree':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnsgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrNsGetBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnssendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrNsSendReceive', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndroleallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrOleAllocate', (('int', None),) ),
    'rpcrt4.ndrolefree':( 'int', None, 'stdcall', 'rpcrt4.NdrOleFree', (('int', None),) ),
    'rpcrt4.ndroutinit':( 'int', None, 'stdcall', 'rpcrt4.NdrOutInit', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreclientbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreClientBufferSize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreclientmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreClientMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreserverinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreServerInitialize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreserverunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreServerUnmarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrpointermemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrproxyerrorhandler':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyErrorHandler', (('int', None),) ),
    'rpcrt4.ndrproxyfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyFreeBuffer', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrproxygetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyGetBuffer', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrproxyinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyInitialize', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrproxysendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrProxySendReceive', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrrangeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrRangeUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrrpcsmclientallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmClientAllocate', (('int', None),) ),
    'rpcrt4.ndrrpcsmclientfree':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmClientFree', (('int', None),) ),
    'rpcrt4.ndrrpcsmsetclienttoosf':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmSetClientToOsf', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssdefaultallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDefaultAllocate', (('DWORD', None),) ),
    'rpcrt4.ndrrpcssdefaultfree':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDefaultFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssdisableallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDisableAllocate', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssenableallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsEnableAllocate', (('int', None),) ),
    'rpcrt4.ndrsendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrSendReceive', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrservercall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerCall', (('int', None),) ),
    'rpcrt4.ndrservercall2':( 'int', None, 'stdcall', 'rpcrt4.NdrServerCall2', (('int', None),) ),
    'rpcrt4.ndrservercontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrservercontextnewmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextNewMarshall', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrservercontextnewunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextNewUnmarshall', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.ndrservercontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextUnmarshall', (('int', None),) ),
    'rpcrt4.ndrserverinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitialize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrserverinitializemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializenew':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeNew', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializepartial':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializePartial', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeUnmarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrservermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerMarshall', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrserverunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerUnmarshall', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrsimplestructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrsimplestructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrsimpletypemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleTypeMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimpletypeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleTypeUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrstubcall':( 'int', None, 'stdcall', 'rpcrt4.NdrStubCall', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubcall2':( 'int', None, 'stdcall', 'rpcrt4.NdrStubCall2', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubforwardingfunction':( 'int', None, 'stdcall', 'rpcrt4.NdrStubForwardingFunction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrstubgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrStubGetBuffer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrStubInitialize', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrstubinitializemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrStubInitializeMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypeflags':( 'int', None, 'cdecl', 'rpcrt4.NdrTypeFlags', () ),
    'rpcrt4.ndrtypefree':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypesize':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrunmarshallbasetypeinline':( 'int', None, 'stdcall', 'rpcrt4.NdrUnmarshallBasetypeInline', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalfree':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrusermarshalmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalsimpletypeconvert':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalSimpleTypeConvert', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasfree':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpcreateproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrpCreateProxy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpcreatestub':( 'int', None, 'stdcall', 'rpcrt4.NdrpCreateStub', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpgetprocformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetProcFormatString', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrpgettypeformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetTypeFormatString', ( ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrpgettypegencookie':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetTypeGenCookie', (('int', None),) ),
    'rpcrt4.ndrpmemoryincrement':( 'int', None, 'stdcall', 'rpcrt4.NdrpMemoryIncrement', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpreleasetypeformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpReleaseTypeFormatString', (('void *', 'ptr'),) ),
    'rpcrt4.ndrpreleasetypegencookie':( 'int', None, 'stdcall', 'rpcrt4.NdrpReleaseTypeGenCookie', () ),
    'rpcrt4.ndrpsetrpcssdefaults':( 'int', None, 'stdcall', 'rpcrt4.NdrpSetRpcSsDefaults', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpvarvtoftypedesc':( 'int', None, 'stdcall', 'rpcrt4.NdrpVarVtOfTypeDesc', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcasyncabortcall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncAbortCall', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcasynccancelcall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncCancelCall', (('int', None), ('int', None)) ),
    'rpcrt4.rpcasynccompletecall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncCompleteCall', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcasyncgetcallstatus':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncGetCallStatus', (('int', None),) ),
    'rpcrt4.rpcasyncinitializehandle':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncInitializeHandle', (('int', None), ('int', None)) ),
    'rpcrt4.rpcasyncregisterinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncRegisterInfo', (('int', None),) ),
    'rpcrt4.rpcbindingcopy':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingCopy', ( ('int', None),) ),
    'rpcrt4.rpcbindingfree':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingfromstringbindinga':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFromStringBindingA', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcbindingfromstringbindingw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFromStringBindingW', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclienta':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientExW', ( ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientW', ( ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoExW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqobject':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqObject', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcbindinginqoption':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqOption', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingreset':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingReset', () ),
    'rpcrt4.rpcbindingserverfromclient':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingServerFromClient', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingsetauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfoexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfoexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoExW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetobject':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetObject', ( ('void *', 'obj'),) ),
    'rpcrt4.rpcbindingsetoption':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetOption', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingtostringbindinga':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingToStringBindingA', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingtostringbindingw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingToStringBindingW', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingVectorFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpccancelthread':( 'int', None, 'stdcall', 'rpcrt4.RpcCancelThread', (('int', None),) ),
    'rpcrt4.rpccancelthreadex':( 'int', None, 'stdcall', 'rpcrt4.RpcCancelThreadEx', (('int', None), ('int', None)) ),
    'rpcrt4.rpccertgenerateprincipalnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcCertGeneratePrincipalNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpccertgenerateprincipalnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcCertGeneratePrincipalNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcepregistera':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcepregisternoreplacea':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterNoReplaceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcepregisternoreplacew':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterNoReplaceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcepregisterw':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcepresolvebinding':( 'int', None, 'stdcall', 'rpcrt4.RpcEpResolveBinding', ( ('int', None),) ),
    'rpcrt4.rpcepunregister':( 'int', None, 'stdcall', 'rpcrt4.RpcEpUnregister', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerroraddrecord':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorAddRecord', (('int', None),) ),
    'rpcrt4.rpcerrorclearinformation':( 'int', None, 'cdecl', 'rpcrt4.RpcErrorClearInformation', () ),
    'rpcrt4.rpcerrorendenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorEndEnumeration', (('int', None),) ),
    'rpcrt4.rpcerrorgetnextrecord':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorGetNextRecord', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorgetnumberofrecords':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorGetNumberOfRecords', (('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorloaderrorinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorLoadErrorInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorresetenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorResetEnumeration', (('int', None),) ),
    'rpcrt4.rpcerrorsaveerrorinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorSaveErrorInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorstartenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorStartEnumeration', (('int', None),) ),
    'rpcrt4.rpcfreeauthorizationcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcFreeAuthorizationContext', (('int', None),) ),
    'rpcrt4.rpcgetauthorizationcontextforclient':( 'int', None, 'stdcall', 'rpcrt4.RpcGetAuthorizationContextForClient', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcifidvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcIfIdVectorFree', (('int', None),) ),
    'rpcrt4.rpcifinqid':( 'int', None, 'stdcall', 'rpcrt4.RpcIfInqId', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcimpersonateclient':( 'int', None, 'stdcall', 'rpcrt4.RpcImpersonateClient', () ),
    'rpcrt4.rpcmgmtenableidlecleanup':( 'int', None, 'cdecl', 'rpcrt4.RpcMgmtEnableIdleCleanup', () ),
    'rpcrt4.rpcmgmtepeltinqbegin':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqBegin', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtepeltinqdone':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqDone', (('int', None),) ),
    'rpcrt4.rpcmgmtepeltinqnexta':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqNextA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtepeltinqnextw':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqNextW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcmgmtepunregister':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpUnregister', ( ('void *', 'obj'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcmgmtinqcomtimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqComTimeout', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcmgmtinqdefaultprotectlevel':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqDefaultProtectLevel', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqifids':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqIfIds', (('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqserverprincnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqServerPrincNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqserverprincnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqServerPrincNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcmgmtinqstats':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqStats', (('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtisserverlistening':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtIsServerListening', (('int', None),) ),
    'rpcrt4.rpcmgmtsetauthorizationfn':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetAuthorizationFn', (('int', None),) ),
    'rpcrt4.rpcmgmtsetcanceltimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetCancelTimeout', (('int', None),) ),
    'rpcrt4.rpcmgmtsetcomtimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetComTimeout', ( ('int', None),) ),
    'rpcrt4.rpcmgmtsetserverstacksize':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetServerStackSize', (('int', None),) ),
    'rpcrt4.rpcmgmtstatsvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtStatsVectorFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpcmgmtstopserverlistening':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtStopServerListening', (('int', None),) ),
    'rpcrt4.rpcmgmtwaitserverlisten':( 'int', None, 'cdecl', 'rpcrt4.RpcMgmtWaitServerListen', () ),
    'rpcrt4.rpcnetworkinqprotseqsa':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkInqProtseqsA', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcnetworkinqprotseqsw':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkInqProtseqsW', (('int', None),) ),
    'rpcrt4.rpcnetworkisprotseqvalida':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkIsProtseqValidA', (('int', None),) ),
    'rpcrt4.rpcnetworkisprotseqvalidw':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkIsProtseqValidW', (('void *', 'ptr'),) ),
    'rpcrt4.rpcnsbindinginqentrynamea':( 'int', None, 'stdcall', 'rpcrt4.RpcNsBindingInqEntryNameA', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcnsbindinginqentrynamew':( 'int', None, 'stdcall', 'rpcrt4.RpcNsBindingInqEntryNameW', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcobjectinqtype':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectInqType', ( ('int', None),) ),
    'rpcrt4.rpcobjectsetinqfn':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectSetInqFn', (('int', None),) ),
    'rpcrt4.rpcobjectsettype':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectSetType', ( ('void *', 'obj'),) ),
    'rpcrt4.rpcprotseqvectorfreea':( 'int', None, 'stdcall', 'rpcrt4.RpcProtseqVectorFreeA', (('int', None),) ),
    'rpcrt4.rpcprotseqvectorfreew':( 'int', None, 'stdcall', 'rpcrt4.RpcProtseqVectorFreeW', (('void *', 'ptr'),) ),
    'rpcrt4.rpcraiseexception':( 'int', None, 'stdcall', 'rpcrt4.RpcRaiseException', (('int', None),) ),
    'rpcrt4.rpcreverttoself':( 'int', None, 'cdecl', 'rpcrt4.RpcRevertToSelf', () ),
    'rpcrt4.rpcreverttoselfex':( 'int', None, 'stdcall', 'rpcrt4.RpcRevertToSelfEx', () ),
    'rpcrt4.rpcserverinqbindings':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqBindings', (('int', None),) ),
    'rpcrt4.rpcserverinqcallattributesa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqCallAttributesA', ( ('int', None),) ),
    'rpcrt4.rpcserverinqcallattributesw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqCallAttributesW', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcserverinqdefaultprincnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqDefaultPrincNameA', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverinqdefaultprincnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqDefaultPrincNameW', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserverinqif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverlisten':( 'int', None, 'stdcall', 'rpcrt4.RpcServerListen', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterAuthInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterAuthInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverregisterif2':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIf2', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIfEx', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcservertestcancel':( 'int', None, 'stdcall', 'rpcrt4.RpcServerTestCancel', () ),
    'rpcrt4.rpcserverunregisterif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUnregisterIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverunregisterifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUnregisterIfEx', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserveruseallprotseqs':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqs', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsEx', ( ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsIf', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsIfEx', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcserveruseprotseqepexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpExW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqExA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcserveruseprotseqexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqExW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfExW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveryield':( 'int', None, 'cdecl', 'rpcrt4.RpcServerYield', () ),
    'rpcrt4.rpcsmallocate':( 'int', None, 'stdcall', 'rpcrt4.RpcSmAllocate', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsmclientfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmClientFree', (('int', None),) ),
    'rpcrt4.rpcsmdestroyclientcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcSmDestroyClientContext', (('int', None),) ),
    'rpcrt4.rpcsmdisableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSmDisableAllocate', () ),
    'rpcrt4.rpcsmenableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSmEnableAllocate', () ),
    'rpcrt4.rpcsmfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmFree', (('int', None),) ),
    'rpcrt4.rpcsmgetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSmGetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcsmsetclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSetClientAllocFree', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsmsetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcsmswapclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSwapClientAllocFree', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcssallocate':( 'int', None, 'stdcall', 'rpcrt4.RpcSsAllocate', (('int', None),) ),
    'rpcrt4.rpcsscontextlockexclusive':( 'int', None, 'stdcall', 'rpcrt4.RpcSsContextLockExclusive', ( ('int', None),) ),
    'rpcrt4.rpcsscontextlockshared':( 'int', None, 'stdcall', 'rpcrt4.RpcSsContextLockShared', ( ('int', None),) ),
    'rpcrt4.rpcssdestroyclientcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcSsDestroyClientContext', (('void *', 'ptr'),) ),
    'rpcrt4.rpcssdisableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSsDisableAllocate', () ),
    'rpcrt4.rpcssenableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSsEnableAllocate', () ),
    'rpcrt4.rpcssfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsFree', (('int', None),) ),
    'rpcrt4.rpcssgetcontextbinding':( 'int', None, 'stdcall', 'rpcrt4.RpcSsGetContextBinding', (('int', None), ('int', None)) ),
    'rpcrt4.rpcssgetthreadhandle':( 'int', None, 'cdecl', 'rpcrt4.RpcSsGetThreadHandle', () ),
    'rpcrt4.rpcsssetclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSetClientAllocFree', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsssetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcssswapclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSwapClientAllocFree', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcstringbindingcomposea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingComposeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringbindingcomposew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingComposeW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringbindingparsea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingParseA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcstringbindingparsew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingParseW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringfreea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringFreeA', (('void *', 'ptr'),) ),
    'rpcrt4.rpcstringfreew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringFreeW', (('void *', 'ptr'),) ),
    'rpcrt4.rpctestcancel':( 'int', None, 'cdecl', 'rpcrt4.RpcTestCancel', () ),
    'rpcrt4.rpcuserfree':( 'int', None, 'stdcall', 'rpcrt4.RpcUserFree', (('int', None), ('int', None)) ),
    'rpcrt4.simpletypealignment':( 'int', None, 'cdecl', 'rpcrt4.SimpleTypeAlignment', () ),
    'rpcrt4.simpletypebuffersize':( 'int', None, 'msfastcall', 'rpcrt4.SimpleTypeBufferSize', (('int', None), ('int', None)) ),
    'rpcrt4.simpletypememorysize':( 'int', None, 'msfastcall', 'rpcrt4.SimpleTypeMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.towerconstruct':( 'int', None, 'stdcall', 'rpcrt4.TowerConstruct', ( ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.towerexplode':( 'int', None, 'stdcall', 'rpcrt4.TowerExplode', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.uuidcompare':( 'int', None, 'stdcall', 'rpcrt4.UuidCompare', ( ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.uuidcreate':( 'int', None, 'stdcall', 'rpcrt4.UuidCreate', (('void *', 'ptr'),) ),
    'rpcrt4.uuidcreatenil':( 'int', None, 'stdcall', 'rpcrt4.UuidCreateNil', () ),
    'rpcrt4.uuidcreatesequential':( 'int', None, 'stdcall', 'rpcrt4.UuidCreateSequential', (('int', None),) ),
    'rpcrt4.uuidequal':( 'int', None, 'stdcall', 'rpcrt4.UuidEqual', ( ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.uuidfromstringa':( 'int', None, 'stdcall', 'rpcrt4.UuidFromStringA', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.uuidfromstringw':( 'int', None, 'stdcall', 'rpcrt4.UuidFromStringW', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.uuidhash':( 'int', None, 'stdcall', 'rpcrt4.UuidHash', ( ('int', None),) ),
    'rpcrt4.uuidisnil':( 'int', None, 'stdcall', 'rpcrt4.UuidIsNil', ( ('void *', 'ptr'),) ),
    'rpcrt4.uuidtostringa':( 'int', None, 'stdcall', 'rpcrt4.UuidToStringA', ( ('int', None),) ),
    'rpcrt4.uuidtostringw':( 'int', None, 'stdcall', 'rpcrt4.UuidToStringW', ( ('void *', 'ptr'),) ),
    'rpcrt4.char_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.char_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.char_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.char_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.data_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.data_into_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_into_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.data_size_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_size_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.double_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.double_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.double_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.double_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.enum_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.enum_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.float_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.float_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.float_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.float_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.long_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.long_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.long_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.long_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.long_from_ndr_temp':( 'int', None, 'stdcall', 'rpcrt4.long_from_ndr_temp', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.pfnfreeroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnFreeRoutines', () ),
    'rpcrt4.pfnmarshallroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnMarshallRoutines', () ),
    'rpcrt4.pfnsizeroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnSizeRoutines', () ),
    'rpcrt4.pfnunmarshallroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnUnmarshallRoutines', () ),
    'rpcrt4.short_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.short_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.short_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.short_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.short_from_ndr_temp':( 'int', None, 'stdcall', 'rpcrt4.short_from_ndr_temp', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_into_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_into_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_peek_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_peek_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_size_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_size_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    # FIXME unresolved I_RpcAbortAsyncCall -> RPCRT4.I_RpcAsyncAbortCall
    # FIXME unresolved I_RpcBindingInqDynamicEndpoint -> RPCRT4.I_RpcBindingInqDynamicEndpointW
    # FIXME unresolved I_RpcNsBindingSetEntryName -> RPCRT4.I_RpcNsBindingSetEntryNameW
    # FIXME unresolved I_RpcSetAsyncHandle -> RPCRT4.I_RpcAsyncSetHandle
    # FIXME unresolved RpcAbortAsyncCall -> RPCRT4.RpcAsyncAbortCall
    # FIXME unresolved RpcCancelAsyncCall -> RPCRT4.RpcAsyncCancelCall
    # FIXME unresolved RpcCompleteAsyncCall -> RPCRT4.RpcAsyncCompleteCall
    # FIXME unresolved RpcGetAsyncCallStatus -> RPCRT4.RpcAsyncGetCallStatus
    # FIXME unresolved RpcInitializeAsyncHandle -> RPCRT4.RpcAsyncInitializeHandle
    # FIXME unresolved RpcRegisterAsyncInfo -> RPCRT4.RpcAsyncRegisterInfo
    # FIXME unresolved RpcSsDontSerializeContext -> RPCRT4.I_RpcSsDontSerializeContext

    # MSVCRT
    'msvcrt.main_entry':( 'int', None, 'stdcall', 'msvcrt.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.$i10_output':( 'int', None, 'cdecl', 'msvcrt.$I10_OUTPUT', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'msvcrt.??0__non_rtti_object@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??0__non_rtti_object@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??0__non_rtti_object@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcrt.??0__non_rtti_object@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcrt.??0bad_cast@@aae@pbqbd@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_cast@@AAE@PBQBD@Z', ( ('int', None),) ),
    'msvcrt.??0bad_cast@@qae@abqbd@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_cast@@QAE@ABQBD@Z', ( ('int', None),) ),
    'msvcrt.??0bad_cast@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_cast@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??0bad_cast@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_cast@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcrt.??0bad_typeid@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_typeid@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??0bad_typeid@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcrt.??0bad_typeid@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcrt.??0exception@@qae@abqbd@z':( 'int', None, 'stdcall', 'msvcrt.??0exception@@QAE@ABQBD@Z', ( ('int', None),) ),
    'msvcrt.??0exception@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??0exception@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??0exception@@qae@xz':( 'int', None, 'stdcall', 'msvcrt.??0exception@@QAE@XZ', () ),
    'msvcrt.??1__non_rtti_object@@uae@xz':( 'int', None, 'stdcall', 'msvcrt.??1__non_rtti_object@@UAE@XZ', () ),
    'msvcrt.??1bad_cast@@uae@xz':( 'int', None, 'stdcall', 'msvcrt.??1bad_cast@@UAE@XZ', () ),
    'msvcrt.??1bad_typeid@@uae@xz':( 'int', None, 'stdcall', 'msvcrt.??1bad_typeid@@UAE@XZ', () ),
    'msvcrt.??1exception@@uae@xz':( 'int', None, 'stdcall', 'msvcrt.??1exception@@UAE@XZ', () ),
    'msvcrt.??1type_info@@uae@xz':( 'int', None, 'stdcall', 'msvcrt.??1type_info@@UAE@XZ', () ),
    'msvcrt.??2@yapaxi@z':( 'int', None, 'cdecl', 'msvcrt.??2@YAPAXI@Z', (('DWORD', None),) ),
    'msvcrt.??3@yaxpax@z':( 'int', None, 'cdecl', 'msvcrt.??3@YAXPAX@Z', (('void *', 'ptr'),) ),
    'msvcrt.??4__non_rtti_object@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??4__non_rtti_object@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??4bad_cast@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??4bad_cast@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??4bad_typeid@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??4bad_typeid@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??4exception@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcrt.??4exception@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcrt.??8type_info@@qbehabv0@@z':( 'int', None, 'stdcall', 'msvcrt.??8type_info@@QBEHABV0@@Z', ( ('int', None),) ),
    'msvcrt.??9type_info@@qbehabv0@@z':( 'int', None, 'stdcall', 'msvcrt.??9type_info@@QBEHABV0@@Z', ( ('int', None),) ),
    'msvcrt.??_7exception@@6b@':( 'int', None, 'cdecl', 'msvcrt.??_7exception@@6B@', () ),
    'msvcrt.??_e__non_rtti_object@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_E__non_rtti_object@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_ebad_cast@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Ebad_cast@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_ebad_typeid@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Ebad_typeid@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_eexception@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Eexception@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_fbad_cast@@qaexxz':( 'int', None, 'stdcall', 'msvcrt.??_Fbad_cast@@QAEXXZ', () ),
    'msvcrt.??_fbad_typeid@@qaexxz':( 'int', None, 'stdcall', 'msvcrt.??_Fbad_typeid@@QAEXXZ', () ),
    'msvcrt.??_g__non_rtti_object@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_G__non_rtti_object@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_gbad_cast@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Gbad_cast@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_gbad_typeid@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Gbad_typeid@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_gexception@@uaepaxi@z':( 'int', None, 'stdcall', 'msvcrt.??_Gexception@@UAEPAXI@Z', ( ('int', None),) ),
    'msvcrt.??_u@yapaxi@z':( 'int', None, 'cdecl', 'msvcrt.??_U@YAPAXI@Z', (('DWORD', None),) ),
    'msvcrt.??_v@yaxpax@z':( 'int', None, 'cdecl', 'msvcrt.??_V@YAXPAX@Z', (('void *', 'ptr'),) ),
    'msvcrt.?_query_new_handler@@yap6ahi@zxz':( 'int', None, 'cdecl', 'msvcrt.?_query_new_handler@@YAP6AHI@ZXZ', () ),
    'msvcrt.?_query_new_mode@@yahxz':( 'int', None, 'cdecl', 'msvcrt.?_query_new_mode@@YAHXZ', () ),
    'msvcrt.?_set_new_handler@@yap6ahi@zp6ahi@z@z':( 'int', None, 'cdecl', 'msvcrt.?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z', (('int', None),) ),
    'msvcrt.?_set_new_mode@@yahh@z':( 'int', None, 'cdecl', 'msvcrt.?_set_new_mode@@YAHH@Z', (('int', None),) ),
    'msvcrt.?_set_se_translator@@yap6axipau_exception_pointers@@@zp6axi0@z@z':( 'int', None, 'cdecl', 'msvcrt.?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z', (('int', None),) ),
    'msvcrt.?before@type_info@@qbehabv1@@z':( 'int', None, 'stdcall', 'msvcrt.?before@type_info@@QBEHABV1@@Z', ( ('int', None),) ),
    'msvcrt.?name@type_info@@qbepbdxz':( 'int', None, 'stdcall', 'msvcrt.?name@type_info@@QBEPBDXZ', () ),
    'msvcrt.?raw_name@type_info@@qbepbdxz':( 'int', None, 'cdecl', 'msvcrt.?raw_name@type_info@@QBEPBDXZ', () ),
    'msvcrt.?set_new_handler@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcrt.?set_new_handler@@YAP6AXXZP6AXXZ@Z', () ),
    'msvcrt.?set_terminate@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcrt.?set_terminate@@YAP6AXXZP6AXXZ@Z', (('int', None),) ),
    'msvcrt.?set_unexpected@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcrt.?set_unexpected@@YAP6AXXZP6AXXZ@Z', (('int', None),) ),
    'msvcrt.?terminate@@yaxxz':( 'int', None, 'cdecl', 'msvcrt.?terminate@@YAXXZ', () ),
    'msvcrt.?unexpected@@yaxxz':( 'int', None, 'cdecl', 'msvcrt.?unexpected@@YAXXZ', () ),
    'msvcrt.?what@exception@@ubepbdxz':( 'int', None, 'stdcall', 'msvcrt.?what@exception@@UBEPBDXZ', () ),
    'msvcrt._ciacos':( 'int', None, 'cdecl', 'msvcrt._CIacos', () ),
    'msvcrt._ciasin':( 'int', None, 'cdecl', 'msvcrt._CIasin', () ),
    'msvcrt._ciatan':( 'int', None, 'cdecl', 'msvcrt._CIatan', () ),
    'msvcrt._ciatan2':( 'int', None, 'cdecl', 'msvcrt._CIatan2', () ),
    'msvcrt._cicos':( 'int', None, 'cdecl', 'msvcrt._CIcos', () ),
    'msvcrt._cicosh':( 'int', None, 'cdecl', 'msvcrt._CIcosh', () ),
    'msvcrt._ciexp':( 'int', None, 'cdecl', 'msvcrt._CIexp', () ),
    'msvcrt._cifmod':( 'int', None, 'cdecl', 'msvcrt._CIfmod', () ),
    'msvcrt._cilog':( 'int', None, 'cdecl', 'msvcrt._CIlog', () ),
    'msvcrt._cilog10':( 'int', None, 'cdecl', 'msvcrt._CIlog10', () ),
    'msvcrt._cipow':( 'int', None, 'cdecl', 'msvcrt._CIpow', () ),
    'msvcrt._cisin':( 'int', None, 'cdecl', 'msvcrt._CIsin', () ),
    'msvcrt._cisinh':( 'int', None, 'cdecl', 'msvcrt._CIsinh', () ),
    'msvcrt._cisqrt':( 'int', None, 'cdecl', 'msvcrt._CIsqrt', () ),
    'msvcrt._citan':( 'int', None, 'cdecl', 'msvcrt._CItan', () ),
    'msvcrt._citanh':( 'int', None, 'cdecl', 'msvcrt._CItanh', () ),
    'msvcrt._cxxthrowexception':( 'int', None, 'stdcall', 'msvcrt._CxxThrowException', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._eh_prolog':( 'int', None, 'cdecl', 'msvcrt._EH_prolog', () ),
    'msvcrt._getdays':( 'int', None, 'cdecl', 'msvcrt._Getdays', () ),
    'msvcrt._getmonths':( 'int', None, 'cdecl', 'msvcrt._Getmonths', () ),
    'msvcrt._gettnames':( 'int', None, 'cdecl', 'msvcrt._Gettnames', () ),
    'msvcrt._huge':( 'int', None, 'cdecl', 'msvcrt._HUGE', () ),
    'msvcrt._strftime':( 'int', None, 'cdecl', 'msvcrt._Strftime', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._xcptfilter':( 'int', None, 'cdecl', 'msvcrt._XcptFilter', (('int', None), ('int', None)) ),
    'msvcrt.__cxxcallunwinddtor':( 'int', None, 'cdecl', 'msvcrt.__CxxCallUnwindDtor', (('void *', 'funcptr'), ('int', None)) ),
    'msvcrt.__cxxdetectrethrow':( 'int', None, 'cdecl', 'msvcrt.__CxxDetectRethrow', (('int', None),) ),
    'msvcrt.__cxxexceptionfilter':( 'int', None, 'cdecl', 'msvcrt.__CxxExceptionFilter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__cxxframehandler':( 'int', None, 'bfastcall', 'msvcrt.__CxxFrameHandler', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__cxxlongjmpunwind':( 'int', None, 'stdcall', 'msvcrt.__CxxLongjmpUnwind', (('int', None),) ),
    'msvcrt.__cxxqueryexceptionsize':( 'int', None, 'cdecl', 'msvcrt.__CxxQueryExceptionSize', () ),
    'msvcrt.__cxxregisterexceptionobject':( 'int', None, 'cdecl', 'msvcrt.__CxxRegisterExceptionObject', (('int', None), ('void *', 'ptr')) ),
    'msvcrt.__cxxunregisterexceptionobject':( 'int', None, 'cdecl', 'msvcrt.__CxxUnregisterExceptionObject', (('int', None), ('int', None)) ),
    'msvcrt.__destructexceptionobject':( 'int', None, 'cdecl', 'msvcrt.__DestructExceptionObject', (('int', None),) ),
    'msvcrt.__rtcasttovoid':( 'int', None, 'cdecl', 'msvcrt.__RTCastToVoid', () ),
    'msvcrt.__rtdynamiccast':( 'int', None, 'cdecl', 'msvcrt.__RTDynamicCast', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__rttypeid':( 'int', None, 'cdecl', 'msvcrt.__RTtypeid', (('int', None),) ),
    'msvcrt.__stringtold':( 'int', None, 'cdecl', 'msvcrt.__STRINGTOLD', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt.___lc_codepage_func':( 'int', None, 'cdecl', 'msvcrt.___lc_codepage_func', () ),
    'msvcrt.___lc_handle_func':( 'int', None, 'cdecl', 'msvcrt.___lc_handle_func', () ),
    'msvcrt.___mb_cur_max_func':( 'int', None, 'cdecl', 'msvcrt.___mb_cur_max_func', () ),
    'msvcrt.___setlc_active_func':( 'int', None, 'cdecl', 'msvcrt.___setlc_active_func', () ),
    'msvcrt.___unguarded_readlc_active_add_func':( 'int', None, 'cdecl', 'msvcrt.___unguarded_readlc_active_add_func', () ),
    'msvcrt.__argc':( 'int', None, 'cdecl', 'msvcrt.__argc', () ),
    'msvcrt.__argv':( 'int', None, 'cdecl', 'msvcrt.__argv', () ),
    'msvcrt.__badioinfo':( 'int', None, 'cdecl', 'msvcrt.__badioinfo', () ),
    'msvcrt.__crtcomparestringa':( 'int', None, 'cdecl', 'msvcrt.__crtCompareStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__crtcomparestringw':( 'int', None, 'cdecl', 'msvcrt.__crtCompareStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__crtgetlocaleinfow':( 'int', None, 'cdecl', 'msvcrt.__crtGetLocaleInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__crtgetstringtypew':( 'int', None, 'cdecl', 'msvcrt.__crtGetStringTypeW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt.__crtlcmapstringa':( 'int', None, 'cdecl', 'msvcrt.__crtLCMapStringA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__crtlcmapstringw':( 'int', None, 'cdecl', 'msvcrt.__crtLCMapStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt.__dllonexit':( 'int', None, 'cdecl', 'msvcrt.__dllonexit', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__doserrno':( 'int', None, 'cdecl', 'msvcrt.__doserrno', () ),
    'msvcrt.__fpecode':( 'int', None, 'cdecl', 'msvcrt.__fpecode', () ),
    'msvcrt.__getmainargs':( 'int', None, 'cdecl', 'msvcrt.__getmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__initenv':( 'int', None, 'cdecl', 'msvcrt.__initenv', () ),
    'msvcrt.__iob_func':( 'int', None, 'cdecl', 'msvcrt.__iob_func', () ),
    'msvcrt.__isascii':( 'int', None, 'cdecl', 'msvcrt.__isascii', (('int', None),) ),
    'msvcrt.__iscsym':( 'int', None, 'cdecl', 'msvcrt.__iscsym', (('int', None),) ),
    'msvcrt.__iscsymf':( 'int', None, 'cdecl', 'msvcrt.__iscsymf', (('int', None),) ),
    'msvcrt.__lc_codepage':( 'int', None, 'cdecl', 'msvcrt.__lc_codepage', () ),
    'msvcrt.__lc_collate_cp':( 'int', None, 'cdecl', 'msvcrt.__lc_collate_cp', () ),
    'msvcrt.__lc_handle':( 'int', None, 'cdecl', 'msvcrt.__lc_handle', () ),
    'msvcrt.__lconv_init':( 'int', None, 'cdecl', 'msvcrt.__lconv_init', () ),
    'msvcrt.__mb_cur_max':( 'int', None, 'bfastcall', 'msvcrt.__mb_cur_max', (('int', None),) ),
    'msvcrt.__p___argc':( 'int', None, 'cdecl', 'msvcrt.__p___argc', () ),
    'msvcrt.__p___argv':( 'int', None, 'cdecl', 'msvcrt.__p___argv', () ),
    'msvcrt.__p___initenv':( 'int', None, 'cdecl', 'msvcrt.__p___initenv', () ),
    'msvcrt.__p___mb_cur_max':( 'int', None, 'cdecl', 'msvcrt.__p___mb_cur_max', () ),
    'msvcrt.__p___wargv':( 'int', None, 'cdecl', 'msvcrt.__p___wargv', () ),
    'msvcrt.__p___winitenv':( 'int', None, 'cdecl', 'msvcrt.__p___winitenv', () ),
    'msvcrt.__p__acmdln':( 'int', None, 'cdecl', 'msvcrt.__p__acmdln', () ),
    'msvcrt.__p__amblksiz':( 'int', None, 'cdecl', 'msvcrt.__p__amblksiz', () ),
    'msvcrt.__p__commode':( 'int', None, 'cdecl', 'msvcrt.__p__commode', () ),
    'msvcrt.__p__daylight':( 'int', None, 'cdecl', 'msvcrt.__p__daylight', () ),
    'msvcrt.__p__dstbias':( 'int', None, 'cdecl', 'msvcrt.__p__dstbias', () ),
    'msvcrt.__p__environ':( 'int', None, 'cdecl', 'msvcrt.__p__environ', () ),
    'msvcrt.__p__fileinfo':( 'int', None, 'cdecl', 'msvcrt.__p__fileinfo', () ),
    'msvcrt.__p__fmode':( 'int', None, 'cdecl', 'msvcrt.__p__fmode', () ),
    'msvcrt.__p__iob':( 'int', None, 'cdecl', 'msvcrt.__p__iob', () ),
    'msvcrt.__p__mbcasemap':( 'int', None, 'cdecl', 'msvcrt.__p__mbcasemap', () ),
    'msvcrt.__p__mbctype':( 'int', None, 'cdecl', 'msvcrt.__p__mbctype', () ),
    'msvcrt.__p__osver':( 'int', None, 'cdecl', 'msvcrt.__p__osver', () ),
    'msvcrt.__p__pctype':( 'int', None, 'cdecl', 'msvcrt.__p__pctype', () ),
    'msvcrt.__p__pgmptr':( 'int', None, 'cdecl', 'msvcrt.__p__pgmptr', () ),
    'msvcrt.__p__pwctype':( 'int', None, 'cdecl', 'msvcrt.__p__pwctype', () ),
    'msvcrt.__p__timezone':( 'int', None, 'cdecl', 'msvcrt.__p__timezone', () ),
    'msvcrt.__p__tzname':( 'int', None, 'cdecl', 'msvcrt.__p__tzname', () ),
    'msvcrt.__p__wcmdln':( 'int', None, 'cdecl', 'msvcrt.__p__wcmdln', () ),
    'msvcrt.__p__wenviron':( 'int', None, 'cdecl', 'msvcrt.__p__wenviron', () ),
    'msvcrt.__p__winmajor':( 'int', None, 'cdecl', 'msvcrt.__p__winmajor', () ),
    'msvcrt.__p__winminor':( 'int', None, 'cdecl', 'msvcrt.__p__winminor', () ),
    'msvcrt.__p__winver':( 'int', None, 'cdecl', 'msvcrt.__p__winver', () ),
    'msvcrt.__p__wpgmptr':( 'int', None, 'cdecl', 'msvcrt.__p__wpgmptr', () ),
    'msvcrt.__pctype_func':( 'int', None, 'cdecl', 'msvcrt.__pctype_func', () ),
    'msvcrt.__pioinfo':( 'int', None, 'cdecl', 'msvcrt.__pioinfo', () ),
    'msvcrt.__pxcptinfoptrs':( 'int', None, 'cdecl', 'msvcrt.__pxcptinfoptrs', () ),
    'msvcrt.__set_app_type':( 'int', None, 'cdecl', 'msvcrt.__set_app_type', (('int', None),) ),
    'msvcrt.__setlc_active':( 'int', None, 'cdecl', 'msvcrt.__setlc_active', () ),
    'msvcrt.__setusermatherr':( 'int', None, 'cdecl', 'msvcrt.__setusermatherr', (('int', None),) ),
    'msvcrt.__threadhandle':( 'int', None, 'stdcall', 'msvcrt.__threadhandle', () ),
    'msvcrt.__threadid':( 'int', None, 'stdcall', 'msvcrt.__threadid', () ),
    'msvcrt.__toascii':( 'int', None, 'cdecl', 'msvcrt.__toascii', (('int', None),) ),
    'msvcrt.__undname':( 'int', None, 'cdecl', 'msvcrt.__unDName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__undnameex':( 'int', None, 'cdecl', 'msvcrt.__unDNameEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__uncaught_exception':( 'int', None, 'cdecl', 'msvcrt.__uncaught_exception', () ),
    'msvcrt.__unguarded_readlc_active':( 'int', None, 'cdecl', 'msvcrt.__unguarded_readlc_active', () ),
    'msvcrt.__wargv':( 'int', None, 'cdecl', 'msvcrt.__wargv', () ),
    'msvcrt.__wcserror':( 'int', None, 'cdecl', 'msvcrt.__wcserror', (('int', None),) ),
    'msvcrt.__wgetmainargs':( 'int', None, 'msfastcall', 'msvcrt.__wgetmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.__winitenv':( 'int', None, 'cdecl', 'msvcrt.__winitenv', () ),
    'msvcrt._abnormal_termination':( 'int', None, 'cdecl', 'msvcrt._abnormal_termination', () ),
    'msvcrt._access':( 'int', None, 'cdecl', 'msvcrt._access', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._acmdln':( 'int', None, 'cdecl', 'msvcrt._acmdln', () ),
    'msvcrt._adj_fdiv_m16i':( 'int', None, 'cdecl', 'msvcrt._adj_fdiv_m16i', () ),
    'msvcrt._adj_fdiv_m32':( 'int', None, 'cdecl', 'msvcrt._adj_fdiv_m32', (('int', None),) ),
    'msvcrt._adj_fdiv_m32i':( 'int', None, 'cdecl', 'msvcrt._adj_fdiv_m32i', () ),
    'msvcrt._adj_fdiv_m64':( 'int', None, 'cdecl', 'msvcrt._adj_fdiv_m64', (('int', None), ('int', None)) ),
    'msvcrt._adj_fdiv_r':( 'int', None, 'cdecl', 'msvcrt._adj_fdiv_r', () ),
    'msvcrt._adj_fdivr_m16i':( 'int', None, 'cdecl', 'msvcrt._adj_fdivr_m16i', () ),
    'msvcrt._adj_fdivr_m32':( 'int', None, 'cdecl', 'msvcrt._adj_fdivr_m32', (('int', None),) ),
    'msvcrt._adj_fdivr_m32i':( 'int', None, 'cdecl', 'msvcrt._adj_fdivr_m32i', () ),
    'msvcrt._adj_fdivr_m64':( 'int', None, 'cdecl', 'msvcrt._adj_fdivr_m64', (('int', None), ('int', None)) ),
    'msvcrt._adj_fpatan':( 'int', None, 'cdecl', 'msvcrt._adj_fpatan', () ),
    'msvcrt._adj_fprem':( 'int', None, 'cdecl', 'msvcrt._adj_fprem', () ),
    'msvcrt._adj_fprem1':( 'int', None, 'cdecl', 'msvcrt._adj_fprem1', () ),
    'msvcrt._adj_fptan':( 'int', None, 'cdecl', 'msvcrt._adj_fptan', () ),
    'msvcrt._adjust_fdiv':( 'int', None, 'cdecl', 'msvcrt._adjust_fdiv', () ),
    'msvcrt._aexit_rtn':( 'int', None, 'cdecl', 'msvcrt._aexit_rtn', () ),
    'msvcrt._aligned_free':( 'int', None, 'cdecl', 'msvcrt._aligned_free', (('int', None),) ),
    'msvcrt._aligned_malloc':( 'int', None, 'cdecl', 'msvcrt._aligned_malloc', (('int', None), ('int', None)) ),
    'msvcrt._aligned_offset_malloc':( 'int', None, 'cdecl', 'msvcrt._aligned_offset_malloc', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._aligned_offset_realloc':( 'int', None, 'cdecl', 'msvcrt._aligned_offset_realloc', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._aligned_realloc':( 'int', None, 'cdecl', 'msvcrt._aligned_realloc', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._amsg_exit':( 'int', None, 'cdecl', 'msvcrt._amsg_exit', (('int', None),) ),
    'msvcrt._assert':( 'int', None, 'cdecl', 'msvcrt._assert', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._atodbl':( 'int', None, 'cdecl', 'msvcrt._atodbl', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._atoi64':( 'int', None, 'cdecl', 'msvcrt._atoi64', (('int', None),) ),
    'msvcrt._atoldbl':( 'int', None, 'cdecl', 'msvcrt._atoldbl', (('int', None), ('int', None)) ),
    'msvcrt._beep':( 'int', None, 'cdecl', 'msvcrt._beep', (('int', None), ('int', None)) ),
    'msvcrt._beginthread':( 'int', None, 'cdecl', 'msvcrt._beginthread', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._beginthreadex':( 'int', None, 'cdecl', 'msvcrt._beginthreadex', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._c_exit':( 'int', None, 'cdecl', 'msvcrt._c_exit', () ),
    'msvcrt._cabs':( 'int', None, 'cdecl', 'msvcrt._cabs', () ),
    'msvcrt._callnewh':( 'int', None, 'cdecl', 'msvcrt._callnewh', (('int', None),) ),
    'msvcrt._cexit':( 'int', None, 'cdecl', 'msvcrt._cexit', () ),
    'msvcrt._cgets':( 'int', None, 'stdcall', 'msvcrt._cgets', ( ('int', None),) ),
    'msvcrt._cgetws':( 'int', None, 'cdecl', 'msvcrt._cgetws', (('int', None),) ),
    'msvcrt._chdir':( 'int', None, 'cdecl', 'msvcrt._chdir', (('int', None),) ),
    'msvcrt._chdrive':( 'int', None, 'cdecl', 'msvcrt._chdrive', (('int', None),) ),
    'msvcrt._chgsign':( 'int', None, 'cdecl', 'msvcrt._chgsign', (('int', None), ('int', None)) ),
    'msvcrt._chkesp':( 'int', None, 'cdecl', 'msvcrt._chkesp', () ),
    'msvcrt._chmod':( 'int', None, 'cdecl', 'msvcrt._chmod', (('int', None), ('int', None)) ),
    'msvcrt._chsize':( 'int', None, 'cdecl', 'msvcrt._chsize', (('int', None), ('int', None)) ),
    'msvcrt._clearfp':( 'int', None, 'cdecl', 'msvcrt._clearfp', () ),
    'msvcrt._close':( 'int', None, 'cdecl', 'msvcrt._close', (('int', None),) ),
    'msvcrt._commit':( 'int', None, 'cdecl', 'msvcrt._commit', (('int', None),) ),
    'msvcrt._commode':( 'int', None, 'cdecl', 'msvcrt._commode', () ),
    'msvcrt._control87':( 'int', None, 'cdecl', 'msvcrt._control87', () ),
    'msvcrt._controlfp':( 'int', None, 'cdecl', 'msvcrt._controlfp', (('int', None), ('int', None)) ),
    'msvcrt._copysign':( 'int', None, 'cdecl', 'msvcrt._copysign', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._cprintf':( 'int', None, 'cdecl', 'msvcrt._cprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._cputs':( 'int', None, 'cdecl', 'msvcrt._cputs', (('int', None),) ),
    'msvcrt._cputws':( 'int', None, 'cdecl', 'msvcrt._cputws', (('void *', 'ptr'),) ),
    'msvcrt._creat':( 'int', None, 'cdecl', 'msvcrt._creat', (('StringA', None), ('int', None)) ),
    'msvcrt._cscanf':( 'int', None, 'cdecl', 'msvcrt._cscanf', () ),
    'msvcrt._ctime64':( 'int', None, 'cdecl', 'msvcrt._ctime64', (('int', None),) ),
    'msvcrt._ctype':( 'int', None, 'cdecl', 'msvcrt._ctype', () ),
    'msvcrt._cwait':( 'int', None, 'cdecl', 'msvcrt._cwait', (('void *', 'ptr'), ('HANDLE', None)) ),
    'msvcrt._cwprintf':( 'int', None, 'cdecl', 'msvcrt._cwprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._cwscanf':( 'int', None, 'cdecl', 'msvcrt._cwscanf', () ),
    'msvcrt._daylight':( 'int', None, 'bfastcall', 'msvcrt._daylight', (('int', None),) ),
    'msvcrt._dstbias':( 'int', None, 'cdecl', 'msvcrt._dstbias', () ),
    'msvcrt._dup':( 'int', None, 'cdecl', 'msvcrt._dup', (('int', None),) ),
    'msvcrt._dup2':( 'int', None, 'cdecl', 'msvcrt._dup2', (('int', None), ('int', None)) ),
    'msvcrt._ecvt':( 'int', None, 'cdecl', 'msvcrt._ecvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._endthread':( 'int', None, 'cdecl', 'msvcrt._endthread', () ),
    'msvcrt._endthreadex':( 'int', None, 'cdecl', 'msvcrt._endthreadex', (('int', None),) ),
    'msvcrt._environ':( 'int', None, 'cdecl', 'msvcrt._environ', () ),
    'msvcrt._eof':( 'int', None, 'cdecl', 'msvcrt._eof', (('int', None),) ),
    'msvcrt._errno':( 'int', None, 'cdecl', 'msvcrt._errno', () ),
    'msvcrt._except_handler2':( 'int', None, 'cdecl', 'msvcrt._except_handler2', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._except_handler3':( 'int', None, 'cdecl', 'msvcrt._except_handler3', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._execl':( 'int', None, 'cdecl', 'msvcrt._execl', (('void *', 'ptr'),) ),
    'msvcrt._execle':( 'int', None, 'cdecl', 'msvcrt._execle', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._execlp':( 'int', None, 'cdecl', 'msvcrt._execlp', (('void *', 'ptr'),) ),
    'msvcrt._execlpe':( 'int', None, 'cdecl', 'msvcrt._execlpe', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._execv':( 'int', None, 'cdecl', 'msvcrt._execv', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._execve':( 'int', None, 'cdecl', 'msvcrt._execve', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._execvp':( 'int', None, 'cdecl', 'msvcrt._execvp', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._execvpe':( 'int', None, 'cdecl', 'msvcrt._execvpe', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._exit':( 'int', None, 'cdecl', 'msvcrt._exit', (('int', None),) ),
    'msvcrt._expand':( 'int', None, 'cdecl', 'msvcrt._expand', (('int', None), ('int', None)) ),
    'msvcrt._fcloseall':( 'int', None, 'cdecl', 'msvcrt._fcloseall', () ),
    'msvcrt._fcvt':( 'int', None, 'cdecl', 'msvcrt._fcvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._fdopen':( 'int', None, 'cdecl', 'msvcrt._fdopen', (('int', None), ('int', None)) ),
    'msvcrt._fgetchar':( 'int', None, 'cdecl', 'msvcrt._fgetchar', () ),
    'msvcrt._fgetwchar':( 'int', None, 'cdecl', 'msvcrt._fgetwchar', () ),
    'msvcrt._filbuf':( 'int', None, 'cdecl', 'msvcrt._filbuf', (('int', None),) ),
    'msvcrt._fileinfo':( 'int', None, 'cdecl', 'msvcrt._fileinfo', () ),
    'msvcrt._filelength':( 'int', None, 'cdecl', 'msvcrt._filelength', (('int', None),) ),
    'msvcrt._filelengthi64':( 'int', None, 'cdecl', 'msvcrt._filelengthi64', (('int', None),) ),
    'msvcrt._fileno':( 'int', None, 'cdecl', 'msvcrt._fileno', (('int', None),) ),
    'msvcrt._findclose':( 'int', None, 'cdecl', 'msvcrt._findclose', (('void *', 'ptr'),) ),
    'msvcrt._findfirst':( 'int', None, 'cdecl', 'msvcrt._findfirst', (('int', None), ('int', None)) ),
    'msvcrt._findfirst64':( 'int', None, 'cdecl', 'msvcrt._findfirst64', (('int', None), ('int', None)) ),
    'msvcrt._findfirsti64':( 'int', None, 'cdecl', 'msvcrt._findfirsti64', (('int', None), ('int', None)) ),
    'msvcrt._findnext':( 'int', None, 'cdecl', 'msvcrt._findnext', (('int', None), ('int', None)) ),
    'msvcrt._findnext64':( 'int', None, 'cdecl', 'msvcrt._findnext64', (('int', None), ('int', None)) ),
    'msvcrt._findnexti64':( 'int', None, 'cdecl', 'msvcrt._findnexti64', (('int', None), ('int', None)) ),
    'msvcrt._finite':( 'int', None, 'cdecl', 'msvcrt._finite', (('int', None), ('int', None)) ),
    'msvcrt._flsbuf':( 'int', None, 'cdecl', 'msvcrt._flsbuf', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._flushall':( 'int', None, 'cdecl', 'msvcrt._flushall', () ),
    'msvcrt._fmode':( 'int', None, 'cdecl', 'msvcrt._fmode', () ),
    'msvcrt._fpclass':( 'int', None, 'cdecl', 'msvcrt._fpclass', (('int', None), ('int', None)) ),
    'msvcrt._fpieee_flt':( 'int', None, 'cdecl', 'msvcrt._fpieee_flt', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._fpreset':( 'int', None, 'cdecl', 'msvcrt._fpreset', () ),
    'msvcrt._fputchar':( 'int', None, 'cdecl', 'msvcrt._fputchar', (('int', None),) ),
    'msvcrt._fputwchar':( 'int', None, 'cdecl', 'msvcrt._fputwchar', (('int', None),) ),
    'msvcrt._fsopen':( 'int', None, 'cdecl', 'msvcrt._fsopen', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcrt._fstat':( 'int', None, 'cdecl', 'msvcrt._fstat', (('int', None), ('int', None)) ),
    'msvcrt._fstat64':( 'int', None, 'cdecl', 'msvcrt._fstat64', (('int', None), ('int', None)) ),
    'msvcrt._fstati64':( 'int', None, 'cdecl', 'msvcrt._fstati64', (('int', None), ('int', None)) ),
    'msvcrt._ftime':( 'int', None, 'cdecl', 'msvcrt._ftime', (('int', None),) ),
    'msvcrt._ftime64':( 'int', None, 'cdecl', 'msvcrt._ftime64', (('int', None),) ),
    'msvcrt._ftol':( 'int', None, 'cdecl', 'msvcrt._ftol', () ),
    'msvcrt._fullpath':( 'int', None, 'cdecl', 'msvcrt._fullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._futime':( 'int', None, 'cdecl', 'msvcrt._futime', (('int', None), ('int', None)) ),
    'msvcrt._futime64':( 'int', None, 'cdecl', 'msvcrt._futime64', (('int', None), ('int', None)) ),
    'msvcrt._gcvt':( 'int', None, 'cdecl', 'msvcrt._gcvt', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'msvcrt._get_heap_handle':( 'int', None, 'cdecl', 'msvcrt._get_heap_handle', () ),
    'msvcrt._get_osfhandle':( 'int', None, 'cdecl', 'msvcrt._get_osfhandle', (('int', None),) ),
    'msvcrt._get_sbh_threshold':( 'int', None, 'cdecl', 'msvcrt._get_sbh_threshold', () ),
    'msvcrt._getch':( 'int', None, 'cdecl', 'msvcrt._getch', () ),
    'msvcrt._getche':( 'int', None, 'cdecl', 'msvcrt._getche', () ),
    'msvcrt._getcwd':( 'int', None, 'cdecl', 'msvcrt._getcwd', (('int', None), ('int', None)) ),
    'msvcrt._getdcwd':( 'int', None, 'cdecl', 'msvcrt._getdcwd', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._getdiskfree':( 'int', None, 'cdecl', 'msvcrt._getdiskfree', (('int', None), ('int', None)) ),
    'msvcrt._getdllprocaddr':( 'int', None, 'cdecl', 'msvcrt._getdllprocaddr', (('HMODULE', None), ('StringA', None), ('int', None)) ),
    'msvcrt._getdrive':( 'int', None, 'cdecl', 'msvcrt._getdrive', () ),
    'msvcrt._getdrives':( 'int', None, 'stdcall', 'msvcrt._getdrives', () ),
    'msvcrt._getmaxstdio':( 'int', None, 'cdecl', 'msvcrt._getmaxstdio', () ),
    'msvcrt._getmbcp':( 'int', None, 'cdecl', 'msvcrt._getmbcp', () ),
    'msvcrt._getpid':( 'int', None, 'stdcall', 'msvcrt._getpid', () ),
    'msvcrt._getsystime':( 'int', None, 'cdecl', 'msvcrt._getsystime', (('int', None),) ),
    'msvcrt._getw':( 'int', None, 'cdecl', 'msvcrt._getw', (('int', None),) ),
    'msvcrt._getwch':( 'int', None, 'cdecl', 'msvcrt._getwch', () ),
    'msvcrt._getwche':( 'int', None, 'cdecl', 'msvcrt._getwche', () ),
    'msvcrt._getws':( 'int', None, 'cdecl', 'msvcrt._getws', (('int', None),) ),
    'msvcrt._global_unwind2':( 'int', None, 'cdecl', 'msvcrt._global_unwind2', (('int', None),) ),
    'msvcrt._gmtime64':( 'int', None, 'cdecl', 'msvcrt._gmtime64', (('void *', 'ptr'),) ),
    'msvcrt._heapadd':( 'int', None, 'cdecl', 'msvcrt._heapadd', () ),
    'msvcrt._heapchk':( 'int', None, 'cdecl', 'msvcrt._heapchk', () ),
    'msvcrt._heapmin':( 'int', None, 'cdecl', 'msvcrt._heapmin', () ),
    'msvcrt._heapset':( 'int', None, 'cdecl', 'msvcrt._heapset', () ),
    'msvcrt._heapused':( 'int', None, 'cdecl', 'msvcrt._heapused', () ),
    'msvcrt._heapwalk':( 'int', None, 'cdecl', 'msvcrt._heapwalk', (('int', None),) ),
    'msvcrt._hypot':( 'int', None, 'cdecl', 'msvcrt._hypot', () ),
    'msvcrt._i64toa':( 'int', None, 'msfastcall', 'msvcrt._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._i64tow':( 'int', None, 'msfastcall', 'msvcrt._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._initterm':( 'int', None, 'cdecl', 'msvcrt._initterm', (('int', None), ('int', None)) ),
    'msvcrt._inp':( 'int', None, 'cdecl', 'msvcrt._inp', (('int', None),) ),
    'msvcrt._inpd':( 'int', None, 'cdecl', 'msvcrt._inpd', (('int', None),) ),
    'msvcrt._inpw':( 'int', None, 'cdecl', 'msvcrt._inpw', (('int', None),) ),
    'msvcrt._iob':( 'int', None, 'cdecl', 'msvcrt._iob', () ),
    'msvcrt._isatty':( 'int', None, 'cdecl', 'msvcrt._isatty', (('int', None),) ),
    'msvcrt._isctype':( 'int', None, 'cdecl', 'msvcrt._isctype', (('int', None), ('int', None)) ),
    'msvcrt._ismbbalnum':( 'int', None, 'cdecl', 'msvcrt._ismbbalnum', (('int', None),) ),
    'msvcrt._ismbbalpha':( 'int', None, 'cdecl', 'msvcrt._ismbbalpha', (('int', None),) ),
    'msvcrt._ismbbgraph':( 'int', None, 'cdecl', 'msvcrt._ismbbgraph', (('int', None),) ),
    'msvcrt._ismbbkalnum':( 'int', None, 'cdecl', 'msvcrt._ismbbkalnum', (('int', None),) ),
    'msvcrt._ismbbkana':( 'int', None, 'cdecl', 'msvcrt._ismbbkana', (('int', None),) ),
    'msvcrt._ismbbkprint':( 'int', None, 'cdecl', 'msvcrt._ismbbkprint', (('int', None),) ),
    'msvcrt._ismbbkpunct':( 'int', None, 'cdecl', 'msvcrt._ismbbkpunct', (('int', None),) ),
    'msvcrt._ismbblead':( 'int', None, 'cdecl', 'msvcrt._ismbblead', (('int', None),) ),
    'msvcrt._ismbbprint':( 'int', None, 'cdecl', 'msvcrt._ismbbprint', (('int', None),) ),
    'msvcrt._ismbbpunct':( 'int', None, 'cdecl', 'msvcrt._ismbbpunct', (('int', None),) ),
    'msvcrt._ismbbtrail':( 'int', None, 'cdecl', 'msvcrt._ismbbtrail', (('int', None),) ),
    'msvcrt._ismbcalnum':( 'int', None, 'cdecl', 'msvcrt._ismbcalnum', (('int', None),) ),
    'msvcrt._ismbcalpha':( 'int', None, 'cdecl', 'msvcrt._ismbcalpha', (('int', None),) ),
    'msvcrt._ismbcdigit':( 'int', None, 'cdecl', 'msvcrt._ismbcdigit', (('int', None),) ),
    'msvcrt._ismbcgraph':( 'int', None, 'cdecl', 'msvcrt._ismbcgraph', (('int', None),) ),
    'msvcrt._ismbchira':( 'int', None, 'cdecl', 'msvcrt._ismbchira', (('int', None),) ),
    'msvcrt._ismbckata':( 'int', None, 'cdecl', 'msvcrt._ismbckata', (('int', None),) ),
    'msvcrt._ismbcl0':( 'int', None, 'cdecl', 'msvcrt._ismbcl0', (('int', None),) ),
    'msvcrt._ismbcl1':( 'int', None, 'cdecl', 'msvcrt._ismbcl1', (('int', None),) ),
    'msvcrt._ismbcl2':( 'int', None, 'cdecl', 'msvcrt._ismbcl2', (('int', None),) ),
    'msvcrt._ismbclegal':( 'int', None, 'cdecl', 'msvcrt._ismbclegal', (('int', None),) ),
    'msvcrt._ismbclower':( 'int', None, 'cdecl', 'msvcrt._ismbclower', (('int', None),) ),
    'msvcrt._ismbcprint':( 'int', None, 'cdecl', 'msvcrt._ismbcprint', (('int', None),) ),
    'msvcrt._ismbcpunct':( 'int', None, 'cdecl', 'msvcrt._ismbcpunct', (('int', None),) ),
    'msvcrt._ismbcspace':( 'int', None, 'cdecl', 'msvcrt._ismbcspace', (('int', None),) ),
    'msvcrt._ismbcsymbol':( 'int', None, 'cdecl', 'msvcrt._ismbcsymbol', (('int', None),) ),
    'msvcrt._ismbcupper':( 'int', None, 'cdecl', 'msvcrt._ismbcupper', (('int', None),) ),
    'msvcrt._ismbslead':( 'int', None, 'cdecl', 'msvcrt._ismbslead', (('int', None), ('int', None)) ),
    'msvcrt._ismbstrail':( 'int', None, 'cdecl', 'msvcrt._ismbstrail', (('int', None), ('int', None)) ),
    'msvcrt._isnan':( 'int', None, 'cdecl', 'msvcrt._isnan', (('int', None), ('int', None)) ),
    'msvcrt._itoa':( 'int', None, 'cdecl', 'msvcrt._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._itow':( 'int', None, 'cdecl', 'msvcrt._itow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._j0':( 'int', None, 'cdecl', 'msvcrt._j0', () ),
    'msvcrt._j1':( 'int', None, 'cdecl', 'msvcrt._j1', () ),
    'msvcrt._jn':( 'int', None, 'cdecl', 'msvcrt._jn', (('int', None),) ),
    'msvcrt._kbhit':( 'int', None, 'cdecl', 'msvcrt._kbhit', () ),
    'msvcrt._lfind':( 'int', None, 'cdecl', 'msvcrt._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcrt._loaddll':( 'int', None, 'cdecl', 'msvcrt._loaddll', (('FileNameA', None),) ),
    'msvcrt._local_unwind2':( 'int', None, 'cdecl', 'msvcrt._local_unwind2', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._localtime64':( 'int', None, 'cdecl', 'msvcrt._localtime64', (('void *', 'ptr'),) ),
    'msvcrt._lock':( 'int', None, 'cdecl', 'msvcrt._lock', (('int', None),) ),
    'msvcrt._locking':( 'int', None, 'cdecl', 'msvcrt._locking', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._logb':( 'int', None, 'cdecl', 'msvcrt._logb', (('int', None), ('int', None)) ),
    'msvcrt._longjmpex':( 'int', None, 'cdecl', 'msvcrt._longjmpex', (('int', None), ('int', None)) ),
    'msvcrt._lrotl':( 'int', None, 'cdecl', 'msvcrt._lrotl', (('int', None), ('int', None)) ),
    'msvcrt._lrotr':( 'int', None, 'cdecl', 'msvcrt._lrotr', (('int', None), ('int', None)) ),
    'msvcrt._lsearch':( 'int', None, 'cdecl', 'msvcrt._lsearch', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcrt._lseek':( 'int', None, 'cdecl', 'msvcrt._lseek', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._lseeki64':( 'int', None, 'cdecl', 'msvcrt._lseeki64', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._ltoa':( 'int', None, 'cdecl', 'msvcrt._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._ltow':( 'int', None, 'cdecl', 'msvcrt._ltow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._makepath':( 'int', None, 'cdecl', 'msvcrt._makepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbbtombc':( 'int', None, 'cdecl', 'msvcrt._mbbtombc', (('int', None),) ),
    'msvcrt._mbbtype':( 'int', None, 'cdecl', 'msvcrt._mbbtype', (('int', None), ('int', None)) ),
    'msvcrt._mbcasemap':( 'int', None, 'cdecl', 'msvcrt._mbcasemap', () ),
    'msvcrt._mbccpy':( 'int', None, 'cdecl', 'msvcrt._mbccpy', (('int', None), ('int', None)) ),
    'msvcrt._mbcjistojms':( 'int', None, 'cdecl', 'msvcrt._mbcjistojms', (('int', None),) ),
    'msvcrt._mbcjmstojis':( 'int', None, 'cdecl', 'msvcrt._mbcjmstojis', (('int', None),) ),
    'msvcrt._mbclen':( 'int', None, 'cdecl', 'msvcrt._mbclen', (('int', None),) ),
    'msvcrt._mbctohira':( 'int', None, 'cdecl', 'msvcrt._mbctohira', (('int', None),) ),
    'msvcrt._mbctokata':( 'int', None, 'cdecl', 'msvcrt._mbctokata', (('int', None),) ),
    'msvcrt._mbctolower':( 'int', None, 'cdecl', 'msvcrt._mbctolower', (('int', None),) ),
    'msvcrt._mbctombb':( 'int', None, 'cdecl', 'msvcrt._mbctombb', (('int', None),) ),
    'msvcrt._mbctoupper':( 'int', None, 'cdecl', 'msvcrt._mbctoupper', (('int', None),) ),
    'msvcrt._mbctype':( 'int', None, 'cdecl', 'msvcrt._mbctype', () ),
    'msvcrt._mbsbtype':( 'int', None, 'cdecl', 'msvcrt._mbsbtype', (('int', None), ('int', None)) ),
    'msvcrt._mbscat':( 'int', None, 'cdecl', 'msvcrt._mbscat', (('int', None), ('int', None)) ),
    'msvcrt._mbschr':( 'int', None, 'cdecl', 'msvcrt._mbschr', (('int', None), ('int', None)) ),
    'msvcrt._mbscmp':( 'int', None, 'cdecl', 'msvcrt._mbscmp', (('int', None), ('int', None)) ),
    'msvcrt._mbscoll':( 'int', None, 'cdecl', 'msvcrt._mbscoll', (('int', None), ('int', None)) ),
    'msvcrt._mbscpy':( 'int', None, 'cdecl', 'msvcrt._mbscpy', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._mbscspn':( 'int', None, 'cdecl', 'msvcrt._mbscspn', (('int', None), ('int', None)) ),
    'msvcrt._mbsdec':( 'int', None, 'cdecl', 'msvcrt._mbsdec', (('int', None), ('int', None)) ),
    'msvcrt._mbsdup':( 'int', None, 'cdecl', 'msvcrt._mbsdup', (('int', None),) ),
    'msvcrt._mbsicmp':( 'int', None, 'cdecl', 'msvcrt._mbsicmp', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcrt._mbsicoll':( 'int', None, 'cdecl', 'msvcrt._mbsicoll', (('int', None), ('int', None)) ),
    'msvcrt._mbsinc':( 'int', None, 'cdecl', 'msvcrt._mbsinc', (('int', None),) ),
    'msvcrt._mbslen':( 'int', None, 'cdecl', 'msvcrt._mbslen', (('int', None),) ),
    'msvcrt._mbslwr':( 'int', None, 'cdecl', 'msvcrt._mbslwr', (('void *', 'ptr'),) ),
    'msvcrt._mbsnbcat':( 'int', None, 'cdecl', 'msvcrt._mbsnbcat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._mbsnbcmp':( 'int', None, 'cdecl', 'msvcrt._mbsnbcmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnbcnt':( 'int', None, 'cdecl', 'msvcrt._mbsnbcnt', (('int', None), ('int', None)) ),
    'msvcrt._mbsnbcoll':( 'int', None, 'cdecl', 'msvcrt._mbsnbcoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnbcpy':( 'int', None, 'cdecl', 'msvcrt._mbsnbcpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._mbsnbicmp':( 'int', None, 'cdecl', 'msvcrt._mbsnbicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnbicoll':( 'int', None, 'cdecl', 'msvcrt._mbsnbicoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnbset':( 'int', None, 'cdecl', 'msvcrt._mbsnbset', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsncat':( 'int', None, 'cdecl', 'msvcrt._mbsncat', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnccnt':( 'int', None, 'cdecl', 'msvcrt._mbsnccnt', (('int', None), ('int', None)) ),
    'msvcrt._mbsncmp':( 'int', None, 'cdecl', 'msvcrt._mbsncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsncoll':( 'int', None, 'cdecl', 'msvcrt._mbsncoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsncpy':( 'int', None, 'cdecl', 'msvcrt._mbsncpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._mbsnextc':( 'int', None, 'cdecl', 'msvcrt._mbsnextc', (('int', None),) ),
    'msvcrt._mbsnicmp':( 'int', None, 'cdecl', 'msvcrt._mbsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsnicoll':( 'int', None, 'cdecl', 'msvcrt._mbsnicoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbsninc':( 'int', None, 'cdecl', 'msvcrt._mbsninc', (('int', None), ('int', None)) ),
    'msvcrt._mbsnset':( 'int', None, 'cdecl', 'msvcrt._mbsnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mbspbrk':( 'int', None, 'cdecl', 'msvcrt._mbspbrk', (('int', None), ('int', None)) ),
    'msvcrt._mbsrchr':( 'int', None, 'cdecl', 'msvcrt._mbsrchr', (('int', None), ('int', None)) ),
    'msvcrt._mbsrev':( 'int', None, 'cdecl', 'msvcrt._mbsrev', (('int', None),) ),
    'msvcrt._mbsset':( 'int', None, 'cdecl', 'msvcrt._mbsset', (('int', None), ('int', None)) ),
    'msvcrt._mbsspn':( 'int', None, 'cdecl', 'msvcrt._mbsspn', (('int', None), ('int', None)) ),
    'msvcrt._mbsspnp':( 'int', None, 'cdecl', 'msvcrt._mbsspnp', (('int', None), ('int', None)) ),
    'msvcrt._mbsstr':( 'int', None, 'cdecl', 'msvcrt._mbsstr', (('int', None), ('int', None)) ),
    'msvcrt._mbstok':( 'int', None, 'cdecl', 'msvcrt._mbstok', (('int', None), ('int', None)) ),
    'msvcrt._mbstrlen':( 'int', None, 'cdecl', 'msvcrt._mbstrlen', (('int', None),) ),
    'msvcrt._mbsupr':( 'int', None, 'cdecl', 'msvcrt._mbsupr', (('void *', 'ptr'),) ),
    'msvcrt._memccpy':( 'int', None, 'cdecl', 'msvcrt._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._memicmp':( 'int', None, 'cdecl', 'msvcrt._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._mkdir':( 'int', None, 'cdecl', 'msvcrt._mkdir', (('StringA', None),) ),
    'msvcrt._mktemp':( 'int', None, 'cdecl', 'msvcrt._mktemp', (('void *', 'ptr'),) ),
    'msvcrt._mktime64':( 'int', None, 'cdecl', 'msvcrt._mktime64', (('int', None),) ),
    'msvcrt._msize':( 'int', None, 'cdecl', 'msvcrt._msize', (('int', None),) ),
    'msvcrt._nextafter':( 'int', None, 'cdecl', 'msvcrt._nextafter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._onexit':( 'int', None, 'cdecl', 'msvcrt._onexit', (('int', None),) ),
    'msvcrt._open':( 'int', None, 'cdecl', 'msvcrt._open', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcrt._open_osfhandle':( 'int', None, 'cdecl', 'msvcrt._open_osfhandle', (('int', None), ('int', None)) ),
    'msvcrt._osplatform':( 'int', None, 'cdecl', 'msvcrt._osplatform', () ),
    'msvcrt._osver':( 'int', None, 'cdecl', 'msvcrt._osver', () ),
    'msvcrt._outp':( 'int', None, 'cdecl', 'msvcrt._outp', (('int', None), ('int', None)) ),
    'msvcrt._outpd':( 'int', None, 'cdecl', 'msvcrt._outpd', (('int', None), ('int', None)) ),
    'msvcrt._outpw':( 'int', None, 'cdecl', 'msvcrt._outpw', (('int', None), ('int', None)) ),
    'msvcrt._pclose':( 'int', None, 'cdecl', 'msvcrt._pclose', (('int', None),) ),
    'msvcrt._pctype':( 'int', None, 'cdecl', 'msvcrt._pctype', () ),
    'msvcrt._pgmptr':( 'int', None, 'cdecl', 'msvcrt._pgmptr', () ),
    'msvcrt._pipe':( 'int', None, 'cdecl', 'msvcrt._pipe', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._popen':( 'int', None, 'cdecl', 'msvcrt._popen', (('int', None), ('int', None)) ),
    'msvcrt._purecall':( 'int', None, 'cdecl', 'msvcrt._purecall', () ),
    'msvcrt._putch':( 'int', None, 'cdecl', 'msvcrt._putch', (('int', None),) ),
    'msvcrt._putenv':( 'int', None, 'cdecl', 'msvcrt._putenv', (('int', None),) ),
    'msvcrt._putw':( 'int', None, 'cdecl', 'msvcrt._putw', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._putwch':( 'int', None, 'cdecl', 'msvcrt._putwch', (('int', None),) ),
    'msvcrt._putws':( 'int', None, 'cdecl', 'msvcrt._putws', (('int', None),) ),
    'msvcrt._pwctype':( 'int', None, 'cdecl', 'msvcrt._pwctype', () ),
    'msvcrt._read':( 'int', None, 'cdecl', 'msvcrt._read', (('int', None), ('StringA', None), ('DWORD', None)) ),
    'msvcrt._resetstkoflw':( 'int', None, 'cdecl', 'msvcrt._resetstkoflw', () ),
    'msvcrt._rmdir':( 'int', None, 'cdecl', 'msvcrt._rmdir', (('int', None),) ),
    'msvcrt._rmtmp':( 'int', None, 'cdecl', 'msvcrt._rmtmp', () ),
    'msvcrt._rotl':( 'int', None, 'cdecl', 'msvcrt._rotl', (('int', None), ('int', None)) ),
    'msvcrt._rotr':( 'int', None, 'cdecl', 'msvcrt._rotr', (('int', None), ('int', None)) ),
    'msvcrt._safe_fdiv':( 'int', None, 'cdecl', 'msvcrt._safe_fdiv', () ),
    'msvcrt._safe_fdivr':( 'int', None, 'cdecl', 'msvcrt._safe_fdivr', () ),
    'msvcrt._safe_fprem':( 'int', None, 'cdecl', 'msvcrt._safe_fprem', () ),
    'msvcrt._safe_fprem1':( 'int', None, 'cdecl', 'msvcrt._safe_fprem1', () ),
    'msvcrt._scalb':( 'int', None, 'cdecl', 'msvcrt._scalb', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._scprintf':( 'int', None, 'cdecl', 'msvcrt._scprintf', (('int', None),) ),
    'msvcrt._scwprintf':( 'int', None, 'cdecl', 'msvcrt._scwprintf', (('int', None),) ),
    'msvcrt._searchenv':( 'int', None, 'cdecl', 'msvcrt._searchenv', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'msvcrt._seh_longjmp_unwind':( 'int', None, 'stdcall', 'msvcrt._seh_longjmp_unwind', (('int', None),) ),
    'msvcrt._set_sse2_enable':( 'int', None, 'cdecl', 'msvcrt._set_SSE2_enable', (('int', None),) ),
    'msvcrt._set_error_mode':( 'int', None, 'cdecl', 'msvcrt._set_error_mode', (('int', None),) ),
    'msvcrt._set_sbh_threshold':( 'int', None, 'cdecl', 'msvcrt._set_sbh_threshold', (('int', None),) ),
    'msvcrt._seterrormode':( 'int', None, 'cdecl', 'msvcrt._seterrormode', (('int', None),) ),
    'msvcrt._setjmp':( 'int', None, 'cdecl', 'msvcrt._setjmp', (('int', None),) ),
    'msvcrt._setjmp3':( 'int', None, 'cdecl', 'msvcrt._setjmp3', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._setmaxstdio':( 'int', None, 'cdecl', 'msvcrt._setmaxstdio', (('int', None),) ),
    'msvcrt._setmbcp':( 'int', None, 'cdecl', 'msvcrt._setmbcp', (('int', None),) ),
    'msvcrt._setmode':( 'int', None, 'cdecl', 'msvcrt._setmode', (('int', None), ('int', None)) ),
    'msvcrt._setsystime':( 'int', None, 'cdecl', 'msvcrt._setsystime', (('int', None), ('int', None)) ),
    'msvcrt._sleep':( 'int', None, 'cdecl', 'msvcrt._sleep', (('int', None),) ),
    'msvcrt._snprintf':( 'int', None, 'cdecl', 'msvcrt._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._snscanf':( 'int', None, 'cdecl', 'msvcrt._snscanf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._snwprintf':( 'int', None, 'cdecl', 'msvcrt._snwprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._snwscanf':( 'int', None, 'cdecl', 'msvcrt._snwscanf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._sopen':( 'int', None, 'cdecl', 'msvcrt._sopen', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._spawnl':( 'int', None, 'cdecl', 'msvcrt._spawnl', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._spawnle':( 'int', None, 'cdecl', 'msvcrt._spawnle', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._spawnlp':( 'int', None, 'cdecl', 'msvcrt._spawnlp', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._spawnlpe':( 'int', None, 'cdecl', 'msvcrt._spawnlpe', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._spawnv':( 'int', None, 'cdecl', 'msvcrt._spawnv', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcrt._spawnve':( 'int', None, 'cdecl', 'msvcrt._spawnve', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._spawnvp':( 'int', None, 'cdecl', 'msvcrt._spawnvp', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._spawnvpe':( 'int', None, 'cdecl', 'msvcrt._spawnvpe', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._splitpath':( 'int', None, 'cdecl', 'msvcrt._splitpath', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcrt._stat':( 'int', None, 'cdecl', 'msvcrt._stat', (('int', None), ('int', None)) ),
    'msvcrt._stat64':( 'int', None, 'cdecl', 'msvcrt._stat64', (('int', None), ('int', None)) ),
    'msvcrt._stati64':( 'int', None, 'cdecl', 'msvcrt._stati64', (('int', None), ('int', None)) ),
    'msvcrt._statusfp':( 'int', None, 'cdecl', 'msvcrt._statusfp', () ),
    'msvcrt._strcmpi':( 'int', None, 'cdecl', 'msvcrt._strcmpi', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._strdate':( 'int', None, 'cdecl', 'msvcrt._strdate', (('int', None),) ),
    'msvcrt._strdup':( 'int', None, 'cdecl', 'msvcrt._strdup', (('int', None),) ),
    'msvcrt._strerror':( 'int', None, 'cdecl', 'msvcrt._strerror', (('int', None),) ),
    'msvcrt._stricmp':( 'int', None, 'cdecl', 'msvcrt._stricmp', (('int', None), ('void *', 'ptr')) ),
    'msvcrt._stricoll':( 'int', None, 'cdecl', 'msvcrt._stricoll', (('int', None), ('int', None)) ),
    'msvcrt._strlwr':( 'int', None, 'cdecl', 'msvcrt._strlwr', (('void *', 'ptr'),) ),
    'msvcrt._strncoll':( 'int', None, 'cdecl', 'msvcrt._strncoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._strnicmp':( 'int', None, 'cdecl', 'msvcrt._strnicmp', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._strnicoll':( 'int', None, 'cdecl', 'msvcrt._strnicoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._strnset':( 'int', None, 'cdecl', 'msvcrt._strnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._strrev':( 'int', None, 'cdecl', 'msvcrt._strrev', (('int', None),) ),
    'msvcrt._strset':( 'int', None, 'cdecl', 'msvcrt._strset', (('int', None), ('int', None)) ),
    'msvcrt._strtime':( 'int', None, 'cdecl', 'msvcrt._strtime', (('int', None),) ),
    'msvcrt._strtoi64':( 'int', None, 'cdecl', 'msvcrt._strtoi64', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._strtoui64':( 'int', None, 'cdecl', 'msvcrt._strtoui64', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._strupr':( 'int', None, 'cdecl', 'msvcrt._strupr', (('void *', 'ptr'),) ),
    'msvcrt._swab':( 'int', None, 'cdecl', 'msvcrt._swab', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._sys_errlist':( 'int', None, 'cdecl', 'msvcrt._sys_errlist', () ),
    'msvcrt._sys_nerr':( 'int', None, 'bfastcall', 'msvcrt._sys_nerr', (('int', None),) ),
    'msvcrt._tell':( 'int', None, 'cdecl', 'msvcrt._tell', (('int', None),) ),
    'msvcrt._telli64':( 'int', None, 'cdecl', 'msvcrt._telli64', (('int', None),) ),
    'msvcrt._tempnam':( 'int', None, 'cdecl', 'msvcrt._tempnam', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._time64':( 'int', None, 'cdecl', 'msvcrt._time64', (('void *', 'ptr'),) ),
    'msvcrt._timezone':( 'int', None, 'bfastcall', 'msvcrt._timezone', (('int', None),) ),
    'msvcrt._tolower':( 'int', None, 'cdecl', 'msvcrt._tolower', (('int', None),) ),
    'msvcrt._toupper':( 'int', None, 'cdecl', 'msvcrt._toupper', (('int', None),) ),
    'msvcrt._tzname':( 'int', None, 'cdecl', 'msvcrt._tzname', () ),
    'msvcrt._tzset':( 'int', None, 'cdecl', 'msvcrt._tzset', () ),
    'msvcrt._ui64toa':( 'int', None, 'msfastcall', 'msvcrt._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._ui64tow':( 'int', None, 'msfastcall', 'msvcrt._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._ultoa':( 'int', None, 'cdecl', 'msvcrt._ultoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._ultow':( 'int', None, 'cdecl', 'msvcrt._ultow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._umask':( 'int', None, 'cdecl', 'msvcrt._umask', (('int', None),) ),
    'msvcrt._ungetch':( 'int', None, 'cdecl', 'msvcrt._ungetch', (('int', None),) ),
    'msvcrt._ungetwch':( 'int', None, 'cdecl', 'msvcrt._ungetwch', (('int', None),) ),
    'msvcrt._unlink':( 'int', None, 'cdecl', 'msvcrt._unlink', (('int', None),) ),
    'msvcrt._unloaddll':( 'int', None, 'cdecl', 'msvcrt._unloaddll', (('int', None),) ),
    'msvcrt._unlock':( 'int', None, 'cdecl', 'msvcrt._unlock', (('int', None),) ),
    'msvcrt._utime':( 'int', None, 'cdecl', 'msvcrt._utime', (('StringA', None), ('int', None)) ),
    'msvcrt._utime64':( 'int', None, 'cdecl', 'msvcrt._utime64', (('StringA', None), ('int', None)) ),
    'msvcrt._vscprintf':( 'int', None, 'cdecl', 'msvcrt._vscprintf', (('int', None), ('int', None)) ),
    'msvcrt._vscwprintf':( 'int', None, 'cdecl', 'msvcrt._vscwprintf', (('int', None), ('int', None)) ),
    'msvcrt._vsnprintf':( 'int', None, 'cdecl', 'msvcrt._vsnprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._vsnwprintf':( 'int', None, 'cdecl', 'msvcrt._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._waccess':( 'int', None, 'cdecl', 'msvcrt._waccess', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt._wasctime':( 'int', None, 'cdecl', 'msvcrt._wasctime', (('int', None),) ),
    'msvcrt._wchdir':( 'int', None, 'cdecl', 'msvcrt._wchdir', (('int', None),) ),
    'msvcrt._wchmod':( 'int', None, 'cdecl', 'msvcrt._wchmod', (('int', None), ('int', None)) ),
    'msvcrt._wcmdln':( 'int', None, 'cdecl', 'msvcrt._wcmdln', () ),
    'msvcrt._wcreat':( 'int', None, 'cdecl', 'msvcrt._wcreat', (('StringW', None), ('int', None)) ),
    'msvcrt._wcsdup':( 'int', None, 'cdecl', 'msvcrt._wcsdup', (('int', None),) ),
    'msvcrt._wcserror':( 'int', None, 'cdecl', 'msvcrt._wcserror', (('int', None),) ),
    'msvcrt._wcsicmp':( 'int', None, 'cdecl', 'msvcrt._wcsicmp', (('int', None), ('int', None)) ),
    'msvcrt._wcsicoll':( 'int', None, 'cdecl', 'msvcrt._wcsicoll', (('int', None), ('int', None)) ),
    'msvcrt._wcslwr':( 'int', None, 'cdecl', 'msvcrt._wcslwr', (('int', None),) ),
    'msvcrt._wcsncoll':( 'int', None, 'cdecl', 'msvcrt._wcsncoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcsnicmp':( 'int', None, 'cdecl', 'msvcrt._wcsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcsnicoll':( 'int', None, 'cdecl', 'msvcrt._wcsnicoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcsnset':( 'int', None, 'cdecl', 'msvcrt._wcsnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcsrev':( 'int', None, 'cdecl', 'msvcrt._wcsrev', (('int', None),) ),
    'msvcrt._wcsset':( 'int', None, 'cdecl', 'msvcrt._wcsset', (('int', None), ('int', None)) ),
    'msvcrt._wcstoi64':( 'int', None, 'cdecl', 'msvcrt._wcstoi64', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcstoui64':( 'int', None, 'cdecl', 'msvcrt._wcstoui64', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wcsupr':( 'int', None, 'cdecl', 'msvcrt._wcsupr', (('int', None),) ),
    'msvcrt._wctime':( 'int', None, 'cdecl', 'msvcrt._wctime', (('void *', 'ptr'),) ),
    'msvcrt._wctime64':( 'int', None, 'cdecl', 'msvcrt._wctime64', (('int', None),) ),
    'msvcrt._wenviron':( 'int', None, 'cdecl', 'msvcrt._wenviron', () ),
    'msvcrt._wexecl':( 'int', None, 'cdecl', 'msvcrt._wexecl', () ),
    'msvcrt._wexecle':( 'int', None, 'cdecl', 'msvcrt._wexecle', ( ('int', None), ('int', None)) ),
    'msvcrt._wexeclp':( 'int', None, 'cdecl', 'msvcrt._wexeclp', () ),
    'msvcrt._wexeclpe':( 'int', None, 'cdecl', 'msvcrt._wexeclpe', ( ('int', None), ('int', None)) ),
    'msvcrt._wexecv':( 'int', None, 'cdecl', 'msvcrt._wexecv', ( ('int', None),) ),
    'msvcrt._wexecve':( 'int', None, 'cdecl', 'msvcrt._wexecve', ( ('int', None), ('int', None)) ),
    'msvcrt._wexecvp':( 'int', None, 'cdecl', 'msvcrt._wexecvp', ( ('int', None),) ),
    'msvcrt._wexecvpe':( 'int', None, 'cdecl', 'msvcrt._wexecvpe', ( ('int', None), ('int', None)) ),
    'msvcrt._wfdopen':( 'int', None, 'cdecl', 'msvcrt._wfdopen', (('int', None), ('int', None)) ),
    'msvcrt._wfindfirst':( 'int', None, 'cdecl', 'msvcrt._wfindfirst', (('int', None), ('int', None)) ),
    'msvcrt._wfindfirst64':( 'int', None, 'cdecl', 'msvcrt._wfindfirst64', (('int', None), ('int', None)) ),
    'msvcrt._wfindfirsti64':( 'int', None, 'cdecl', 'msvcrt._wfindfirsti64', (('int', None), ('int', None)) ),
    'msvcrt._wfindnext':( 'int', None, 'cdecl', 'msvcrt._wfindnext', (('int', None), ('int', None)) ),
    'msvcrt._wfindnext64':( 'int', None, 'cdecl', 'msvcrt._wfindnext64', (('int', None), ('int', None)) ),
    'msvcrt._wfindnexti64':( 'int', None, 'cdecl', 'msvcrt._wfindnexti64', (('int', None), ('int', None)) ),
    'msvcrt._wfopen':( 'int', None, 'cdecl', 'msvcrt._wfopen', (('StringW', None), ('int', None)) ),
    'msvcrt._wfreopen':( 'int', None, 'cdecl', 'msvcrt._wfreopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcrt._wfsopen':( 'int', None, 'cdecl', 'msvcrt._wfsopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcrt._wfullpath':( 'int', None, 'cdecl', 'msvcrt._wfullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt._wgetcwd':( 'int', None, 'cdecl', 'msvcrt._wgetcwd', (('int', None), ('int', None)) ),
    'msvcrt._wgetdcwd':( 'int', None, 'cdecl', 'msvcrt._wgetdcwd', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wgetenv':( 'int', None, 'cdecl', 'msvcrt._wgetenv', (('int', None),) ),
    'msvcrt._winmajor':( 'int', None, 'cdecl', 'msvcrt._winmajor', () ),
    'msvcrt._winminor':( 'int', None, 'cdecl', 'msvcrt._winminor', () ),
    'msvcrt._winver':( 'int', None, 'cdecl', 'msvcrt._winver', () ),
    'msvcrt._wmakepath':( 'int', None, 'cdecl', 'msvcrt._wmakepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wmkdir':( 'int', None, 'cdecl', 'msvcrt._wmkdir', (('StringW', None),) ),
    'msvcrt._wmktemp':( 'int', None, 'cdecl', 'msvcrt._wmktemp', (('void *', 'ptr'),) ),
    'msvcrt._wopen':( 'int', None, 'cdecl', 'msvcrt._wopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcrt._wperror':( 'int', None, 'cdecl', 'msvcrt._wperror', (('void *', 'ptr'),) ),
    'msvcrt._wpgmptr':( 'int', None, 'cdecl', 'msvcrt._wpgmptr', () ),
    'msvcrt._wpopen':( 'int', None, 'cdecl', 'msvcrt._wpopen', (('int', None), ('int', None)) ),
    'msvcrt._wputenv':( 'int', None, 'cdecl', 'msvcrt._wputenv', (('int', None),) ),
    'msvcrt._wremove':( 'int', None, 'cdecl', 'msvcrt._wremove', (('int', None),) ),
    'msvcrt._wrename':( 'int', None, 'cdecl', 'msvcrt._wrename', (('int', None), ('int', None)) ),
    'msvcrt._write':( 'int', None, 'cdecl', 'msvcrt._write', (('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'msvcrt._wrmdir':( 'int', None, 'cdecl', 'msvcrt._wrmdir', (('int', None),) ),
    'msvcrt._wsearchenv':( 'int', None, 'cdecl', 'msvcrt._wsearchenv', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'msvcrt._wsetlocale':( 'int', None, 'cdecl', 'msvcrt._wsetlocale', ( ('void *', 'ptr'),) ),
    'msvcrt._wsopen':( 'int', None, 'cdecl', 'msvcrt._wsopen', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wspawnl':( 'int', None, 'cdecl', 'msvcrt._wspawnl', (('int', None), ('void *', 'obj')) ),
    'msvcrt._wspawnle':( 'int', None, 'cdecl', 'msvcrt._wspawnle', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcrt._wspawnlp':( 'int', None, 'cdecl', 'msvcrt._wspawnlp', (('int', None), ('void *', 'obj')) ),
    'msvcrt._wspawnlpe':( 'int', None, 'cdecl', 'msvcrt._wspawnlpe', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcrt._wspawnv':( 'int', None, 'cdecl', 'msvcrt._wspawnv', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'msvcrt._wspawnve':( 'int', None, 'cdecl', 'msvcrt._wspawnve', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._wspawnvp':( 'int', None, 'cdecl', 'msvcrt._wspawnvp', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcrt._wspawnvpe':( 'int', None, 'cdecl', 'msvcrt._wspawnvpe', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt._wsplitpath':( 'int', None, 'cdecl', 'msvcrt._wsplitpath', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt._wstat':( 'int', None, 'cdecl', 'msvcrt._wstat', (('int', None), ('int', None)) ),
    'msvcrt._wstat64':( 'int', None, 'cdecl', 'msvcrt._wstat64', (('int', None), ('int', None)) ),
    'msvcrt._wstati64':( 'int', None, 'cdecl', 'msvcrt._wstati64', (('int', None), ('int', None)) ),
    'msvcrt._wstrdate':( 'int', None, 'cdecl', 'msvcrt._wstrdate', (('int', None),) ),
    'msvcrt._wstrtime':( 'int', None, 'cdecl', 'msvcrt._wstrtime', (('int', None),) ),
    'msvcrt._wsystem':( 'int', None, 'cdecl', 'msvcrt._wsystem', (('int', None),) ),
    'msvcrt._wtempnam':( 'int', None, 'cdecl', 'msvcrt._wtempnam', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcrt._wtmpnam':( 'int', None, 'cdecl', 'msvcrt._wtmpnam', (('int', None),) ),
    'msvcrt._wtof':( 'int', None, 'cdecl', 'msvcrt._wtof', (('void *', 'ptr'),) ),
    'msvcrt._wtoi':( 'int', None, 'cdecl', 'msvcrt._wtoi', (('int', None),) ),
    'msvcrt._wtoi64':( 'int', None, 'cdecl', 'msvcrt._wtoi64', (('int', None),) ),
    'msvcrt._wtol':( 'int', None, 'cdecl', 'msvcrt._wtol', (('int', None),) ),
    'msvcrt._wunlink':( 'int', None, 'cdecl', 'msvcrt._wunlink', (('int', None),) ),
    'msvcrt._wutime':( 'int', None, 'cdecl', 'msvcrt._wutime', (('StringW', None), ('int', None)) ),
    'msvcrt._wutime64':( 'int', None, 'cdecl', 'msvcrt._wutime64', (('StringW', None), ('int', None)) ),
    'msvcrt._y0':( 'int', None, 'cdecl', 'msvcrt._y0', () ),
    'msvcrt._y1':( 'int', None, 'cdecl', 'msvcrt._y1', () ),
    'msvcrt._yn':( 'int', None, 'cdecl', 'msvcrt._yn', () ),
    'msvcrt.abort':( 'int', None, 'cdecl', 'msvcrt.abort', () ),
    'msvcrt.abs':( 'int', None, 'cdecl', 'msvcrt.abs', (('int', None),) ),
    'msvcrt.acos':( 'int', None, 'cdecl', 'msvcrt.acos', () ),
    'msvcrt.asctime':( 'int', None, 'cdecl', 'msvcrt.asctime', (('int', None),) ),
    'msvcrt.asin':( 'int', None, 'cdecl', 'msvcrt.asin', () ),
    'msvcrt.atan':( 'int', None, 'cdecl', 'msvcrt.atan', () ),
    'msvcrt.atan2':( 'int', None, 'cdecl', 'msvcrt.atan2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.atexit':( 'int', None, 'cdecl', 'msvcrt.atexit', (('int', None),) ),
    'msvcrt.atof':( 'int', None, 'cdecl', 'msvcrt.atof', (('void *', 'ptr'),) ),
    'msvcrt.atoi':( 'int', None, 'cdecl', 'msvcrt.atoi', (('int', None),) ),
    'msvcrt.atol':( 'int', None, 'cdecl', 'msvcrt.atol', (('void *', 'ptr'),) ),
    'msvcrt.bsearch':( 'int', None, 'cdecl', 'msvcrt.bsearch', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcrt.calloc':( 'int', None, 'cdecl', 'msvcrt.calloc', (('int', None), ('int', None)) ),
    'msvcrt.ceil':( 'int', None, 'cdecl', 'msvcrt.ceil', () ),
    'msvcrt.clearerr':( 'int', None, 'cdecl', 'msvcrt.clearerr', (('int', None),) ),
    'msvcrt.clock':( 'int', None, 'msfastcall', 'msvcrt.clock', (('int', None), ('int', None)) ),
    'msvcrt.cos':( 'int', None, 'cdecl', 'msvcrt.cos', () ),
    'msvcrt.cosh':( 'int', None, 'cdecl', 'msvcrt.cosh', (('int', None), ('int', None)) ),
    'msvcrt.ctime':( 'int', None, 'cdecl', 'msvcrt.ctime', (('int', None),) ),
    'msvcrt.difftime':( 'int', None, 'cdecl', 'msvcrt.difftime', (('int', None), ('int', None)) ),
    'msvcrt.div':( 'int', None, 'cdecl', 'msvcrt.div', (('int', None), ('int', None)) ),
    'msvcrt.exit':( 'int', None, 'cdecl', 'msvcrt.exit', (('int', None),) ),
    'msvcrt.exp':( 'int', None, 'cdecl', 'msvcrt.exp', (('int', None), ('int', None)) ),
    'msvcrt.fabs':( 'int', None, 'cdecl', 'msvcrt.fabs', (('int', None), ('int', None)) ),
    'msvcrt.fclose':( 'int', None, 'cdecl', 'msvcrt.fclose', (('int', None),) ),
    'msvcrt.feof':( 'int', None, 'cdecl', 'msvcrt.feof', (('int', None),) ),
    'msvcrt.ferror':( 'int', None, 'cdecl', 'msvcrt.ferror', (('int', None),) ),
    'msvcrt.fflush':( 'int', None, 'cdecl', 'msvcrt.fflush', (('int', None),) ),
    'msvcrt.fgetc':( 'int', None, 'cdecl', 'msvcrt.fgetc', (('int', None),) ),
    'msvcrt.fgetpos':( 'int', None, 'cdecl', 'msvcrt.fgetpos', (('int', None), ('int', None)) ),
    'msvcrt.fgets':( 'int', None, 'cdecl', 'msvcrt.fgets', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.fgetwc':( 'int', None, 'cdecl', 'msvcrt.fgetwc', (('int', None),) ),
    'msvcrt.fgetws':( 'int', None, 'cdecl', 'msvcrt.fgetws', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.floor':( 'int', None, 'cdecl', 'msvcrt.floor', () ),
    'msvcrt.fmod':( 'int', None, 'cdecl', 'msvcrt.fmod', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.fopen':( 'int', None, 'cdecl', 'msvcrt.fopen', (('StringA', None), ('int', None)) ),
    'msvcrt.fprintf':( 'int', None, 'cdecl', 'msvcrt.fprintf', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.fputc':( 'int', None, 'cdecl', 'msvcrt.fputc', (('int', None), ('int', None)) ),
    'msvcrt.fputs':( 'int', None, 'cdecl', 'msvcrt.fputs', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.fputwc':( 'int', None, 'cdecl', 'msvcrt.fputwc', (('int', None), ('int', None)) ),
    'msvcrt.fputws':( 'int', None, 'cdecl', 'msvcrt.fputws', (('int', None), ('int', None)) ),
    'msvcrt.fread':( 'int', None, 'cdecl', 'msvcrt.fread', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.free':( 'int', None, 'cdecl', 'msvcrt.free', (('void *', 'ptr'),) ),
    'msvcrt.freopen':( 'int', None, 'cdecl', 'msvcrt.freopen', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcrt.frexp':( 'int', None, 'cdecl', 'msvcrt.frexp', () ),
    'msvcrt.fscanf':( 'int', None, 'cdecl', 'msvcrt.fscanf', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.fseek':( 'int', None, 'cdecl', 'msvcrt.fseek', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.fsetpos':( 'int', None, 'cdecl', 'msvcrt.fsetpos', (('int', None), ('int', None)) ),
    'msvcrt.ftell':( 'int', None, 'cdecl', 'msvcrt.ftell', (('int', None),) ),
    'msvcrt.fwprintf':( 'int', None, 'cdecl', 'msvcrt.fwprintf', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.fwrite':( 'int', None, 'cdecl', 'msvcrt.fwrite', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.fwscanf':( 'int', None, 'cdecl', 'msvcrt.fwscanf', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.getc':( 'int', None, 'cdecl', 'msvcrt.getc', (('int', None),) ),
    'msvcrt.getchar':( 'int', None, 'cdecl', 'msvcrt.getchar', () ),
    'msvcrt.getenv':( 'int', None, 'cdecl', 'msvcrt.getenv', (('int', None),) ),
    'msvcrt.gets':( 'int', None, 'cdecl', 'msvcrt.gets', (('int', None),) ),
    'msvcrt.getwc':( 'int', None, 'cdecl', 'msvcrt.getwc', (('int', None),) ),
    'msvcrt.getwchar':( 'int', None, 'cdecl', 'msvcrt.getwchar', () ),
    'msvcrt.gmtime':( 'int', None, 'cdecl', 'msvcrt.gmtime', (('void *', 'ptr'),) ),
    'msvcrt.is_wctype':( 'int', None, 'cdecl', 'msvcrt.is_wctype', (('int', None), ('int', None)) ),
    'msvcrt.isalnum':( 'int', None, 'cdecl', 'msvcrt.isalnum', (('int', None),) ),
    'msvcrt.isalpha':( 'int', None, 'cdecl', 'msvcrt.isalpha', (('int', None),) ),
    'msvcrt.iscntrl':( 'int', None, 'cdecl', 'msvcrt.iscntrl', (('int', None),) ),
    'msvcrt.isdigit':( 'int', None, 'cdecl', 'msvcrt.isdigit', (('int', None),) ),
    'msvcrt.isgraph':( 'int', None, 'cdecl', 'msvcrt.isgraph', (('int', None),) ),
    'msvcrt.isleadbyte':( 'int', None, 'cdecl', 'msvcrt.isleadbyte', (('int', None),) ),
    'msvcrt.islower':( 'int', None, 'cdecl', 'msvcrt.islower', (('int', None),) ),
    'msvcrt.isprint':( 'int', None, 'cdecl', 'msvcrt.isprint', (('int', None),) ),
    'msvcrt.ispunct':( 'int', None, 'cdecl', 'msvcrt.ispunct', (('int', None),) ),
    'msvcrt.isspace':( 'int', None, 'cdecl', 'msvcrt.isspace', (('int', None),) ),
    'msvcrt.isupper':( 'int', None, 'cdecl', 'msvcrt.isupper', (('int', None),) ),
    'msvcrt.iswalnum':( 'int', None, 'cdecl', 'msvcrt.iswalnum', (('int', None),) ),
    'msvcrt.iswalpha':( 'int', None, 'cdecl', 'msvcrt.iswalpha', (('int', None),) ),
    'msvcrt.iswascii':( 'int', None, 'cdecl', 'msvcrt.iswascii', (('int', None),) ),
    'msvcrt.iswcntrl':( 'int', None, 'cdecl', 'msvcrt.iswcntrl', (('int', None),) ),
    'msvcrt.iswctype':( 'int', None, 'cdecl', 'msvcrt.iswctype', (('int', None), ('int', None)) ),
    'msvcrt.iswdigit':( 'int', None, 'cdecl', 'msvcrt.iswdigit', (('int', None),) ),
    'msvcrt.iswgraph':( 'int', None, 'cdecl', 'msvcrt.iswgraph', (('int', None),) ),
    'msvcrt.iswlower':( 'int', None, 'cdecl', 'msvcrt.iswlower', (('int', None),) ),
    'msvcrt.iswprint':( 'int', None, 'cdecl', 'msvcrt.iswprint', (('int', None),) ),
    'msvcrt.iswpunct':( 'int', None, 'cdecl', 'msvcrt.iswpunct', (('int', None),) ),
    'msvcrt.iswspace':( 'int', None, 'cdecl', 'msvcrt.iswspace', (('int', None),) ),
    'msvcrt.iswupper':( 'int', None, 'cdecl', 'msvcrt.iswupper', (('int', None),) ),
    'msvcrt.iswxdigit':( 'int', None, 'cdecl', 'msvcrt.iswxdigit', (('int', None),) ),
    'msvcrt.isxdigit':( 'int', None, 'cdecl', 'msvcrt.isxdigit', (('int', None),) ),
    'msvcrt.labs':( 'int', None, 'cdecl', 'msvcrt.labs', (('int', None),) ),
    'msvcrt.ldexp':( 'int', None, 'cdecl', 'msvcrt.ldexp', (('int', None), ('int', None)) ),
    'msvcrt.ldiv':( 'int', None, 'cdecl', 'msvcrt.ldiv', (('int', None), ('int', None)) ),
    'msvcrt.localeconv':( 'int', None, 'cdecl', 'msvcrt.localeconv', () ),
    'msvcrt.localtime':( 'int', None, 'cdecl', 'msvcrt.localtime', (('void *', 'ptr'),) ),
    'msvcrt.log':( 'int', None, 'cdecl', 'msvcrt.log', () ),
    'msvcrt.log10':( 'int', None, 'cdecl', 'msvcrt.log10', () ),
    'msvcrt.longjmp':( 'int', None, 'cdecl', 'msvcrt.longjmp', (('int', None), ('int', None)) ),
    'msvcrt.malloc':( 'int', None, 'cdecl', 'msvcrt.malloc', (('DWORD', None),) ),
    'msvcrt.mblen':( 'int', None, 'cdecl', 'msvcrt.mblen', (('int', None), ('int', None)) ),
    'msvcrt.mbstowcs':( 'int', None, 'cdecl', 'msvcrt.mbstowcs', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.mbtowc':( 'int', None, 'cdecl', 'msvcrt.mbtowc', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.memchr':( 'int', None, 'cdecl', 'msvcrt.memchr', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.memcmp':( 'int', None, 'cdecl', 'msvcrt.memcmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.memcpy':( 'int', None, 'cdecl', 'msvcrt.memcpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.memmove':( 'int', None, 'cdecl', 'msvcrt.memmove', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.memset':( 'int', None, 'cdecl', 'msvcrt.memset', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.mktime':( 'int', None, 'cdecl', 'msvcrt.mktime', (('int', None),) ),
    'msvcrt.modf':( 'int', None, 'cdecl', 'msvcrt.modf', (('int', None), ('int', None)) ),
    'msvcrt.perror':( 'int', None, 'cdecl', 'msvcrt.perror', (('void *', 'ptr'),) ),
    'msvcrt.pow':( 'int', None, 'cdecl', 'msvcrt.pow', () ),
    'msvcrt.printf':( 'int', None, 'cdecl', 'msvcrt.printf', (('int', None),) ),
    'msvcrt.putc':( 'int', None, 'cdecl', 'msvcrt.putc', (('int', None), ('int', None)) ),
    'msvcrt.putchar':( 'int', None, 'cdecl', 'msvcrt.putchar', (('int', None),) ),
    'msvcrt.puts':( 'int', None, 'cdecl', 'msvcrt.puts', (('void *', 'ptr'),) ),
    'msvcrt.putwc':( 'int', None, 'cdecl', 'msvcrt.putwc', (('int', None), ('int', None)) ),
    'msvcrt.putwchar':( 'int', None, 'cdecl', 'msvcrt.putwchar', (('int', None),) ),
    'msvcrt.qsort':( 'int', None, 'stdcall', 'msvcrt.qsort', ( ('void *', 'funcptr'), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.quick_exit':( 'int', None, 'cdecl', 'msvcrt.quick_exit', (('int', None),) ),
    'msvcrt.raise':( 'int', None, 'cdecl', 'msvcrt.raise', (('int', None),) ),
    'msvcrt.rand':( 'int', None, 'cdecl', 'msvcrt.rand', () ),
    'msvcrt.realloc':( 'int', None, 'cdecl', 'msvcrt.realloc', (('void *', 'ptr'), ('DWORD', None)) ),
    'msvcrt.remove':( 'int', None, 'cdecl', 'msvcrt.remove', (('int', None),) ),
    'msvcrt.rename':( 'int', None, 'cdecl', 'msvcrt.rename', (('int', None), ('int', None)) ),
    'msvcrt.rewind':( 'int', None, 'cdecl', 'msvcrt.rewind', (('int', None),) ),
    'msvcrt.scanf':( 'int', None, 'cdecl', 'msvcrt.scanf', (('int', None),) ),
    'msvcrt.setbuf':( 'int', None, 'cdecl', 'msvcrt.setbuf', (('int', None), ('int', None)) ),
    'msvcrt.setlocale':( 'int', None, 'cdecl', 'msvcrt.setlocale', ( ('void *', 'ptr'),) ),
    'msvcrt.setvbuf':( 'int', None, 'cdecl', 'msvcrt.setvbuf', (('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'msvcrt.signal':( 'int', None, 'cdecl', 'msvcrt.signal', (('int', None), ('int', None)) ),
    'msvcrt.sin':( 'int', None, 'cdecl', 'msvcrt.sin', () ),
    'msvcrt.sinh':( 'int', None, 'cdecl', 'msvcrt.sinh', (('int', None), ('int', None)) ),
    'msvcrt.sprintf':( 'int', None, 'cdecl', 'msvcrt.sprintf', (('int', None), ('int', None)) ),
    'msvcrt.sqrt':( 'int', None, 'cdecl', 'msvcrt.sqrt', () ),
    'msvcrt.srand':( 'int', None, 'cdecl', 'msvcrt.srand', (('int', None),) ),
    'msvcrt.sscanf':( 'int', None, 'cdecl', 'msvcrt.sscanf', (('int', None), ('int', None)) ),
    'msvcrt.strcat':( 'int', None, 'cdecl', 'msvcrt.strcat', (('int', None), ('int', None)) ),
    'msvcrt.strchr':( 'int', None, 'cdecl', 'msvcrt.strchr', (('int', None), ('int', None)) ),
    'msvcrt.strcmp':( 'int', None, 'cdecl', 'msvcrt.strcmp', (('int', None), ('int', None)) ),
    'msvcrt.strcoll':( 'int', None, 'cdecl', 'msvcrt.strcoll', (('int', None), ('int', None)) ),
    'msvcrt.strcpy':( 'int', None, 'cdecl', 'msvcrt.strcpy', (('int', None), ('void *', 'ptr')) ),
    'msvcrt.strcspn':( 'int', None, 'cdecl', 'msvcrt.strcspn', (('int', None), ('int', None)) ),
    'msvcrt.strerror':( 'int', None, 'cdecl', 'msvcrt.strerror', (('int', None),) ),
    'msvcrt.strftime':( 'int', None, 'cdecl', 'msvcrt.strftime', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcrt.strlen':( 'int', None, 'cdecl', 'msvcrt.strlen', (('int', None),) ),
    'msvcrt.strncat':( 'int', None, 'cdecl', 'msvcrt.strncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt.strncmp':( 'int', None, 'cdecl', 'msvcrt.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.strncpy':( 'int', None, 'cdecl', 'msvcrt.strncpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.strpbrk':( 'int', None, 'cdecl', 'msvcrt.strpbrk', (('int', None), ('int', None)) ),
    'msvcrt.strrchr':( 'int', None, 'cdecl', 'msvcrt.strrchr', (('int', None), ('int', None)) ),
    'msvcrt.strspn':( 'int', None, 'cdecl', 'msvcrt.strspn', (('int', None), ('int', None)) ),
    'msvcrt.strstr':( 'int', None, 'cdecl', 'msvcrt.strstr', (('int', None), ('int', None)) ),
    'msvcrt.strtod':( 'int', None, 'cdecl', 'msvcrt.strtod', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.strtok':( 'int', None, 'cdecl', 'msvcrt.strtok', (('int', None), ('int', None)) ),
    'msvcrt.strtol':( 'int', None, 'cdecl', 'msvcrt.strtol', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.strtoul':( 'int', None, 'cdecl', 'msvcrt.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.strxfrm':( 'int', None, 'cdecl', 'msvcrt.strxfrm', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.swprintf':( 'int', None, 'cdecl', 'msvcrt.swprintf', (('int', None), ('int', None)) ),
    'msvcrt.swscanf':( 'int', None, 'cdecl', 'msvcrt.swscanf', (('int', None), ('int', None)) ),
    'msvcrt.system':( 'int', None, 'cdecl', 'msvcrt.system', (('int', None),) ),
    'msvcrt.tan':( 'int', None, 'cdecl', 'msvcrt.tan', () ),
    'msvcrt.tanh':( 'int', None, 'cdecl', 'msvcrt.tanh', (('int', None), ('int', None)) ),
    'msvcrt.time':( 'int', None, 'cdecl', 'msvcrt.time', (('void *', 'ptr'),) ),
    'msvcrt.tmpfile':( 'int', None, 'cdecl', 'msvcrt.tmpfile', () ),
    'msvcrt.tmpnam':( 'int', None, 'cdecl', 'msvcrt.tmpnam', (('int', None),) ),
    'msvcrt.tolower':( 'int', None, 'cdecl', 'msvcrt.tolower', (('int', None),) ),
    'msvcrt.toupper':( 'int', None, 'cdecl', 'msvcrt.toupper', (('int', None),) ),
    'msvcrt.towlower':( 'int', None, 'cdecl', 'msvcrt.towlower', (('int', None),) ),
    'msvcrt.towupper':( 'int', None, 'cdecl', 'msvcrt.towupper', (('int', None),) ),
    'msvcrt.ungetc':( 'int', None, 'cdecl', 'msvcrt.ungetc', (('int', None), ('int', None)) ),
    'msvcrt.ungetwc':( 'int', None, 'cdecl', 'msvcrt.ungetwc', (('int', None), ('int', None)) ),
    'msvcrt.vfprintf':( 'int', None, 'cdecl', 'msvcrt.vfprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.vfwprintf':( 'int', None, 'cdecl', 'msvcrt.vfwprintf', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcrt.vprintf':( 'int', None, 'cdecl', 'msvcrt.vprintf', (('int', None), ('int', None)) ),
    'msvcrt.vsprintf':( 'int', None, 'cdecl', 'msvcrt.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.vswprintf':( 'int', None, 'cdecl', 'msvcrt.vswprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.vwprintf':( 'int', None, 'cdecl', 'msvcrt.vwprintf', (('int', None), ('int', None)) ),
    'msvcrt.wcscat':( 'int', None, 'cdecl', 'msvcrt.wcscat', (('int', None), ('int', None)) ),
    'msvcrt.wcschr':( 'int', None, 'cdecl', 'msvcrt.wcschr', (('int', None), ('int', None)) ),
    'msvcrt.wcscmp':( 'int', None, 'cdecl', 'msvcrt.wcscmp', (('int', None), ('int', None)) ),
    'msvcrt.wcscoll':( 'int', None, 'cdecl', 'msvcrt.wcscoll', (('int', None), ('int', None)) ),
    'msvcrt.wcscpy':( 'int', None, 'cdecl', 'msvcrt.wcscpy', (('int', None), ('void *', 'ptr')) ),
    'msvcrt.wcscspn':( 'int', None, 'cdecl', 'msvcrt.wcscspn', (('int', None), ('int', None)) ),
    'msvcrt.wcsftime':( 'int', None, 'cdecl', 'msvcrt.wcsftime', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.wcslen':( 'int', None, 'cdecl', 'msvcrt.wcslen', (('void *', 'ptr'),) ),
    'msvcrt.wcsncat':( 'int', None, 'cdecl', 'msvcrt.wcsncat', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.wcsncmp':( 'int', None, 'cdecl', 'msvcrt.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.wcsncpy':( 'int', None, 'cdecl', 'msvcrt.wcsncpy', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.wcspbrk':( 'int', None, 'cdecl', 'msvcrt.wcspbrk', (('int', None), ('int', None)) ),
    'msvcrt.wcsrchr':( 'int', None, 'cdecl', 'msvcrt.wcsrchr', (('int', None), ('int', None)) ),
    'msvcrt.wcsspn':( 'int', None, 'cdecl', 'msvcrt.wcsspn', (('int', None), ('int', None)) ),
    'msvcrt.wcsstr':( 'int', None, 'cdecl', 'msvcrt.wcsstr', (('int', None), ('int', None)) ),
    'msvcrt.wcstod':( 'int', None, 'cdecl', 'msvcrt.wcstod', (('int', None), ('int', None)) ),
    'msvcrt.wcstok':( 'int', None, 'cdecl', 'msvcrt.wcstok', (('int', None), ('int', None)) ),
    'msvcrt.wcstol':( 'int', None, 'cdecl', 'msvcrt.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.wcstombs':( 'int', None, 'cdecl', 'msvcrt.wcstombs', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.wcstoul':( 'int', None, 'cdecl', 'msvcrt.wcstoul', (('int', None), ('int', None), ('int', None)) ),
    'msvcrt.wcsxfrm':( 'int', None, 'cdecl', 'msvcrt.wcsxfrm', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcrt.wctomb':( 'int', None, 'cdecl', 'msvcrt.wctomb', (('void *', 'ptr'), ('int', None)) ),
    'msvcrt.wprintf':( 'int', None, 'cdecl', 'msvcrt.wprintf', (('int', None),) ),
    'msvcrt.wscanf':( 'int', None, 'cdecl', 'msvcrt.wscanf', (('int', None),) ),

    # MSVCR71
    'msvcr71.main_entry':( 'int', None, 'stdcall', 'msvcr71.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.$i10_output':( 'int', None, 'cdecl', 'msvcr71.$I10_OUTPUT', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'msvcr71.??0__non_rtti_object@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??0__non_rtti_object@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??0__non_rtti_object@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcr71.??0__non_rtti_object@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcr71.??0bad_cast@@aae@pbqbd@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_cast@@AAE@PBQBD@Z', ( ('int', None),) ),
    'msvcr71.??0bad_cast@@qae@abqbd@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_cast@@QAE@ABQBD@Z', ( ('int', None),) ),
    'msvcr71.??0bad_cast@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_cast@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??0bad_cast@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_cast@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcr71.??0bad_typeid@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_typeid@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??0bad_typeid@@qae@pbd@z':( 'int', None, 'stdcall', 'msvcr71.??0bad_typeid@@QAE@PBD@Z', ( ('int', None),) ),
    'msvcr71.??0exception@@qae@abqbd@z':( 'int', None, 'stdcall', 'msvcr71.??0exception@@QAE@ABQBD@Z', ( ('int', None),) ),
    'msvcr71.??0exception@@qae@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??0exception@@QAE@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??0exception@@qae@xz':( 'int', None, 'stdcall', 'msvcr71.??0exception@@QAE@XZ', () ),
    'msvcr71.??1__non_rtti_object@@uae@xz':( 'int', None, 'stdcall', 'msvcr71.??1__non_rtti_object@@UAE@XZ', () ),
    'msvcr71.??1bad_cast@@uae@xz':( 'int', None, 'stdcall', 'msvcr71.??1bad_cast@@UAE@XZ', () ),
    'msvcr71.??1bad_typeid@@uae@xz':( 'int', None, 'stdcall', 'msvcr71.??1bad_typeid@@UAE@XZ', () ),
    'msvcr71.??1exception@@uae@xz':( 'int', None, 'stdcall', 'msvcr71.??1exception@@UAE@XZ', () ),
    'msvcr71.??1type_info@@uae@xz':( 'int', None, 'stdcall', 'msvcr71.??1type_info@@UAE@XZ', () ),
    'msvcr71.??2@yapaxi@z':( 'int', None, 'cdecl', 'msvcr71.??2@YAPAXI@Z', (('DWORD', None),) ),
    'msvcr71.??3@yaxpax@z':( 'int', None, 'cdecl', 'msvcr71.??3@YAXPAX@Z', (('void *', 'ptr'),) ),
    'msvcr71.??4__non_rtti_object@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??4__non_rtti_object@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??4bad_cast@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??4bad_cast@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??4bad_typeid@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??4bad_typeid@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??4exception@@qaeaav0@abv0@@z':( 'int', None, 'stdcall', 'msvcr71.??4exception@@QAEAAV0@ABV0@@Z', ( ('int', None),) ),
    'msvcr71.??8type_info@@qbehabv0@@z':( 'int', None, 'stdcall', 'msvcr71.??8type_info@@QBEHABV0@@Z', ( ('int', None),) ),
    'msvcr71.??9type_info@@qbehabv0@@z':( 'int', None, 'stdcall', 'msvcr71.??9type_info@@QBEHABV0@@Z', ( ('int', None),) ),
    'msvcr71.??_7__non_rtti_object@@6b@':( 'int', None, 'cdecl', 'msvcr71.??_7__non_rtti_object@@6B@', () ),
    'msvcr71.??_7bad_cast@@6b@':( 'int', None, 'cdecl', 'msvcr71.??_7bad_cast@@6B@', () ),
    'msvcr71.??_7bad_typeid@@6b@':( 'int', None, 'cdecl', 'msvcr71.??_7bad_typeid@@6B@', () ),
    'msvcr71.??_7exception@@6b@':( 'int', None, 'bfastcall', 'msvcr71.??_7exception@@6B@', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.??_fbad_cast@@qaexxz':( 'int', None, 'stdcall', 'msvcr71.??_Fbad_cast@@QAEXXZ', () ),
    'msvcr71.??_fbad_typeid@@qaexxz':( 'int', None, 'stdcall', 'msvcr71.??_Fbad_typeid@@QAEXXZ', () ),
    'msvcr71.??_u@yapaxi@z':( 'int', None, 'cdecl', 'msvcr71.??_U@YAPAXI@Z', (('DWORD', None),) ),
    'msvcr71.??_v@yaxpax@z':( 'int', None, 'cdecl', 'msvcr71.??_V@YAXPAX@Z', (('void *', 'ptr'),) ),
    'msvcr71.?_query_new_handler@@yap6ahi@zxz':( 'int', None, 'cdecl', 'msvcr71.?_query_new_handler@@YAP6AHI@ZXZ', () ),
    'msvcr71.?_query_new_mode@@yahxz':( 'int', None, 'cdecl', 'msvcr71.?_query_new_mode@@YAHXZ', () ),
    'msvcr71.?_set_new_handler@@yap6ahi@zp6ahi@z@z':( 'int', None, 'cdecl', 'msvcr71.?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z', (('int', None),) ),
    'msvcr71.?_set_new_mode@@yahh@z':( 'int', None, 'cdecl', 'msvcr71.?_set_new_mode@@YAHH@Z', (('int', None),) ),
    'msvcr71.?_set_se_translator@@yap6axipau_exception_pointers@@@zp6axi0@z@z':( 'int', None, 'cdecl', 'msvcr71.?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z', (('int', None),) ),
    'msvcr71.?before@type_info@@qbehabv1@@z':( 'int', None, 'stdcall', 'msvcr71.?before@type_info@@QBEHABV1@@Z', ( ('int', None),) ),
    'msvcr71.?name@type_info@@qbepbdxz':( 'int', None, 'stdcall', 'msvcr71.?name@type_info@@QBEPBDXZ', () ),
    'msvcr71.?raw_name@type_info@@qbepbdxz':( 'int', None, 'cdecl', 'msvcr71.?raw_name@type_info@@QBEPBDXZ', () ),
    'msvcr71.?set_new_handler@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcr71.?set_new_handler@@YAP6AXXZP6AXXZ@Z', (('int', None),) ),
    'msvcr71.?set_terminate@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcr71.?set_terminate@@YAP6AXXZP6AXXZ@Z', (('int', None),) ),
    'msvcr71.?set_unexpected@@yap6axxzp6axxz@z':( 'int', None, 'cdecl', 'msvcr71.?set_unexpected@@YAP6AXXZP6AXXZ@Z', (('int', None),) ),
    'msvcr71.?swprintf@@yahpagipbgzz':( 'int', None, 'cdecl', 'msvcr71.?swprintf@@YAHPAGIPBGZZ', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.?swprintf@@yahpa_wipb_wzz':( 'int', None, 'cdecl', 'msvcr71.?swprintf@@YAHPA_WIPB_WZZ', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.?terminate@@yaxxz':( 'int', None, 'stdcall', 'msvcr71.?terminate@@YAXXZ', (('int', None),) ),
    'msvcr71.?unexpected@@yaxxz':( 'int', None, 'stdcall', 'msvcr71.?unexpected@@YAXXZ', (('int', None),) ),
    'msvcr71.?vswprintf@@yahpagipbgpad@z':( 'int', None, 'cdecl', 'msvcr71.?vswprintf@@YAHPAGIPBGPAD@Z', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.?vswprintf@@yahpa_wipb_wpad@z':( 'int', None, 'cdecl', 'msvcr71.?vswprintf@@YAHPA_WIPB_WPAD@Z', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.?what@exception@@ubepbdxz':( 'int', None, 'stdcall', 'msvcr71.?what@exception@@UBEPBDXZ', () ),
    'msvcr71._ciacos':( 'int', None, 'cdecl', 'msvcr71._CIacos', () ),
    'msvcr71._ciasin':( 'int', None, 'cdecl', 'msvcr71._CIasin', () ),
    'msvcr71._ciatan':( 'int', None, 'cdecl', 'msvcr71._CIatan', () ),
    'msvcr71._ciatan2':( 'int', None, 'cdecl', 'msvcr71._CIatan2', () ),
    'msvcr71._cicos':( 'int', None, 'cdecl', 'msvcr71._CIcos', () ),
    'msvcr71._cicosh':( 'int', None, 'cdecl', 'msvcr71._CIcosh', () ),
    'msvcr71._ciexp':( 'int', None, 'cdecl', 'msvcr71._CIexp', () ),
    'msvcr71._cifmod':( 'int', None, 'cdecl', 'msvcr71._CIfmod', () ),
    'msvcr71._cilog':( 'int', None, 'cdecl', 'msvcr71._CIlog', () ),
    'msvcr71._cilog10':( 'int', None, 'cdecl', 'msvcr71._CIlog10', () ),
    'msvcr71._cipow':( 'int', None, 'cdecl', 'msvcr71._CIpow', () ),
    'msvcr71._cisin':( 'int', None, 'cdecl', 'msvcr71._CIsin', () ),
    'msvcr71._cisinh':( 'int', None, 'cdecl', 'msvcr71._CIsinh', () ),
    'msvcr71._cisqrt':( 'int', None, 'cdecl', 'msvcr71._CIsqrt', () ),
    'msvcr71._citan':( 'int', None, 'cdecl', 'msvcr71._CItan', () ),
    'msvcr71._citanh':( 'int', None, 'cdecl', 'msvcr71._CItanh', () ),
    'msvcr71._crt_rtc_init':( 'int', None, 'cdecl', 'msvcr71._CRT_RTC_INIT', () ),
    'msvcr71._cxxthrowexception':( 'int', None, 'stdcall', 'msvcr71._CxxThrowException', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._eh_prolog':( 'int', None, 'cdecl', 'msvcr71._EH_prolog', () ),
    'msvcr71._getdays':( 'int', None, 'cdecl', 'msvcr71._Getdays', () ),
    'msvcr71._getmonths':( 'int', None, 'cdecl', 'msvcr71._Getmonths', () ),
    'msvcr71._gettnames':( 'int', None, 'cdecl', 'msvcr71._Gettnames', () ),
    'msvcr71._huge':( 'int', None, 'cdecl', 'msvcr71._HUGE', () ),
    'msvcr71._strftime':( 'int', None, 'cdecl', 'msvcr71._Strftime', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._xcptfilter':( 'int', None, 'cdecl', 'msvcr71._XcptFilter', (('int', None), ('int', None)) ),
    'msvcr71.__cppxcptfilter':( 'int', None, 'cdecl', 'msvcr71.__CppXcptFilter', (('int', None), ('int', None)) ),
    'msvcr71.__cxxcallunwinddtor':( 'int', None, 'cdecl', 'msvcr71.__CxxCallUnwindDtor', (('void *', 'funcptr'), ('int', None)) ),
    'msvcr71.__cxxcallunwindvecdtor':( 'int', None, 'cdecl', 'msvcr71.__CxxCallUnwindVecDtor', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__cxxdetectrethrow':( 'int', None, 'cdecl', 'msvcr71.__CxxDetectRethrow', (('int', None),) ),
    'msvcr71.__cxxexceptionfilter':( 'int', None, 'cdecl', 'msvcr71.__CxxExceptionFilter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__cxxframehandler':( 'int', None, 'bfastcall', 'msvcr71.__CxxFrameHandler', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__cxxlongjmpunwind':( 'int', None, 'stdcall', 'msvcr71.__CxxLongjmpUnwind', (('int', None),) ),
    'msvcr71.__cxxqueryexceptionsize':( 'int', None, 'cdecl', 'msvcr71.__CxxQueryExceptionSize', () ),
    'msvcr71.__cxxregisterexceptionobject':( 'int', None, 'cdecl', 'msvcr71.__CxxRegisterExceptionObject', (('int', None), ('void *', 'ptr')) ),
    'msvcr71.__cxxunregisterexceptionobject':( 'int', None, 'cdecl', 'msvcr71.__CxxUnregisterExceptionObject', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__destructexceptionobject':( 'int', None, 'cdecl', 'msvcr71.__DestructExceptionObject', (('int', None),) ),
    'msvcr71.__rtcasttovoid':( 'int', None, 'cdecl', 'msvcr71.__RTCastToVoid', () ),
    'msvcr71.__rtdynamiccast':( 'int', None, 'cdecl', 'msvcr71.__RTDynamicCast', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__rttypeid':( 'int', None, 'cdecl', 'msvcr71.__RTtypeid', (('int', None),) ),
    'msvcr71.__stringtold':( 'int', None, 'cdecl', 'msvcr71.__STRINGTOLD', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.___lc_codepage_func':( 'int', None, 'cdecl', 'msvcr71.___lc_codepage_func', () ),
    'msvcr71.___lc_collate_cp_func':( 'int', None, 'cdecl', 'msvcr71.___lc_collate_cp_func', () ),
    'msvcr71.___lc_handle_func':( 'int', None, 'cdecl', 'msvcr71.___lc_handle_func', () ),
    'msvcr71.___mb_cur_max_func':( 'int', None, 'cdecl', 'msvcr71.___mb_cur_max_func', () ),
    'msvcr71.___setlc_active_func':( 'int', None, 'cdecl', 'msvcr71.___setlc_active_func', () ),
    'msvcr71.___unguarded_readlc_active_add_func':( 'int', None, 'cdecl', 'msvcr71.___unguarded_readlc_active_add_func', () ),
    'msvcr71.__argc':( 'int', None, 'cdecl', 'msvcr71.__argc', () ),
    'msvcr71.__argv':( 'int', None, 'cdecl', 'msvcr71.__argv', () ),
    'msvcr71.__badioinfo':( 'int', None, 'cdecl', 'msvcr71.__badioinfo', () ),
    'msvcr71.__buffer_overrun':( 'int', None, 'cdecl', 'msvcr71.__buffer_overrun', () ),
    'msvcr71.__crtcomparestringa':( 'int', None, 'cdecl', 'msvcr71.__crtCompareStringA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.__crtcomparestringw':( 'int', None, 'cdecl', 'msvcr71.__crtCompareStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__crtgetlocaleinfow':( 'int', None, 'cdecl', 'msvcr71.__crtGetLocaleInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__crtgetstringtypew':( 'int', None, 'cdecl', 'msvcr71.__crtGetStringTypeW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.__crtlcmapstringa':( 'int', None, 'cdecl', 'msvcr71.__crtLCMapStringA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__crtlcmapstringw':( 'int', None, 'cdecl', 'msvcr71.__crtLCMapStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.__dllonexit':( 'int', None, 'cdecl', 'msvcr71.__dllonexit', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__doserrno':( 'int', None, 'cdecl', 'msvcr71.__doserrno', () ),
    'msvcr71.__fpecode':( 'int', None, 'cdecl', 'msvcr71.__fpecode', () ),
    'msvcr71.__getmainargs':( 'int', None, 'cdecl', 'msvcr71.__getmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__initenv':( 'int', None, 'cdecl', 'msvcr71.__initenv', () ),
    'msvcr71.__iob_func':( 'int', None, 'cdecl', 'msvcr71.__iob_func', () ),
    'msvcr71.__isascii':( 'int', None, 'cdecl', 'msvcr71.__isascii', (('int', None),) ),
    'msvcr71.__iscsym':( 'int', None, 'cdecl', 'msvcr71.__iscsym', (('int', None),) ),
    'msvcr71.__iscsymf':( 'int', None, 'cdecl', 'msvcr71.__iscsymf', (('int', None),) ),
    'msvcr71.__lc_clike':( 'int', None, 'bfastcall', 'msvcr71.__lc_clike', (('int', None),) ),
    'msvcr71.__lc_codepage':( 'int', None, 'cdecl', 'msvcr71.__lc_codepage', () ),
    'msvcr71.__lc_collate_cp':( 'int', None, 'cdecl', 'msvcr71.__lc_collate_cp', () ),
    'msvcr71.__lc_handle':( 'int', None, 'cdecl', 'msvcr71.__lc_handle', () ),
    'msvcr71.__lconv_init':( 'int', None, 'cdecl', 'msvcr71.__lconv_init', () ),
    'msvcr71.__mb_cur_max':( 'int', None, 'bfastcall', 'msvcr71.__mb_cur_max', (('int', None),) ),
    'msvcr71.__p___argc':( 'int', None, 'cdecl', 'msvcr71.__p___argc', () ),
    'msvcr71.__p___argv':( 'int', None, 'cdecl', 'msvcr71.__p___argv', () ),
    'msvcr71.__p___initenv':( 'int', None, 'cdecl', 'msvcr71.__p___initenv', () ),
    'msvcr71.__p___mb_cur_max':( 'int', None, 'cdecl', 'msvcr71.__p___mb_cur_max', () ),
    'msvcr71.__p___wargv':( 'int', None, 'cdecl', 'msvcr71.__p___wargv', () ),
    'msvcr71.__p___winitenv':( 'int', None, 'cdecl', 'msvcr71.__p___winitenv', () ),
    'msvcr71.__p__acmdln':( 'int', None, 'cdecl', 'msvcr71.__p__acmdln', () ),
    'msvcr71.__p__amblksiz':( 'int', None, 'cdecl', 'msvcr71.__p__amblksiz', () ),
    'msvcr71.__p__commode':( 'int', None, 'cdecl', 'msvcr71.__p__commode', () ),
    'msvcr71.__p__daylight':( 'int', None, 'cdecl', 'msvcr71.__p__daylight', () ),
    'msvcr71.__p__dstbias':( 'int', None, 'cdecl', 'msvcr71.__p__dstbias', () ),
    'msvcr71.__p__environ':( 'int', None, 'cdecl', 'msvcr71.__p__environ', () ),
    'msvcr71.__p__fileinfo':( 'int', None, 'cdecl', 'msvcr71.__p__fileinfo', () ),
    'msvcr71.__p__fmode':( 'int', None, 'cdecl', 'msvcr71.__p__fmode', () ),
    'msvcr71.__p__iob':( 'int', None, 'cdecl', 'msvcr71.__p__iob', () ),
    'msvcr71.__p__mbcasemap':( 'int', None, 'cdecl', 'msvcr71.__p__mbcasemap', () ),
    'msvcr71.__p__mbctype':( 'int', None, 'cdecl', 'msvcr71.__p__mbctype', () ),
    'msvcr71.__p__osver':( 'int', None, 'cdecl', 'msvcr71.__p__osver', () ),
    'msvcr71.__p__pctype':( 'int', None, 'cdecl', 'msvcr71.__p__pctype', () ),
    'msvcr71.__p__pgmptr':( 'int', None, 'cdecl', 'msvcr71.__p__pgmptr', () ),
    'msvcr71.__p__pwctype':( 'int', None, 'cdecl', 'msvcr71.__p__pwctype', () ),
    'msvcr71.__p__timezone':( 'int', None, 'cdecl', 'msvcr71.__p__timezone', () ),
    'msvcr71.__p__tzname':( 'int', None, 'cdecl', 'msvcr71.__p__tzname', () ),
    'msvcr71.__p__wcmdln':( 'int', None, 'cdecl', 'msvcr71.__p__wcmdln', () ),
    'msvcr71.__p__wenviron':( 'int', None, 'cdecl', 'msvcr71.__p__wenviron', () ),
    'msvcr71.__p__winmajor':( 'int', None, 'cdecl', 'msvcr71.__p__winmajor', () ),
    'msvcr71.__p__winminor':( 'int', None, 'cdecl', 'msvcr71.__p__winminor', () ),
    'msvcr71.__p__winver':( 'int', None, 'cdecl', 'msvcr71.__p__winver', () ),
    'msvcr71.__p__wpgmptr':( 'int', None, 'cdecl', 'msvcr71.__p__wpgmptr', () ),
    'msvcr71.__pctype_func':( 'int', None, 'cdecl', 'msvcr71.__pctype_func', () ),
    'msvcr71.__pioinfo':( 'int', None, 'cdecl', 'msvcr71.__pioinfo', () ),
    'msvcr71.__pwctype_func':( 'int', None, 'cdecl', 'msvcr71.__pwctype_func', () ),
    'msvcr71.__pxcptinfoptrs':( 'int', None, 'cdecl', 'msvcr71.__pxcptinfoptrs', () ),
    'msvcr71.__security_error_handler':( 'int', None, 'cdecl', 'msvcr71.__security_error_handler', (('int', None), ('int', None)) ),
    'msvcr71.__set_app_type':( 'int', None, 'cdecl', 'msvcr71.__set_app_type', (('int', None),) ),
    'msvcr71.__set_buffer_overrun_handler':( 'int', None, 'cdecl', 'msvcr71.__set_buffer_overrun_handler', (('int', None),) ),
    'msvcr71.__setlc_active':( 'int', None, 'cdecl', 'msvcr71.__setlc_active', () ),
    'msvcr71.__setusermatherr':( 'int', None, 'cdecl', 'msvcr71.__setusermatherr', (('int', None),) ),
    'msvcr71.__threadhandle':( 'int', None, 'stdcall', 'msvcr71.__threadhandle', () ),
    'msvcr71.__threadid':( 'int', None, 'stdcall', 'msvcr71.__threadid', () ),
    'msvcr71.__toascii':( 'int', None, 'cdecl', 'msvcr71.__toascii', (('int', None),) ),
    'msvcr71.__undname':( 'int', None, 'cdecl', 'msvcr71.__unDName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__undnameex':( 'int', None, 'cdecl', 'msvcr71.__unDNameEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__uncaught_exception':( 'int', None, 'cdecl', 'msvcr71.__uncaught_exception', () ),
    'msvcr71.__unguarded_readlc_active':( 'int', None, 'cdecl', 'msvcr71.__unguarded_readlc_active', () ),
    'msvcr71.__wargv':( 'int', None, 'cdecl', 'msvcr71.__wargv', () ),
    'msvcr71.__wcserror':( 'int', None, 'cdecl', 'msvcr71.__wcserror', (('int', None),) ),
    'msvcr71.__wgetmainargs':( 'int', None, 'msfastcall', 'msvcr71.__wgetmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.__winitenv':( 'int', None, 'cdecl', 'msvcr71.__winitenv', () ),
    'msvcr71._abnormal_termination':( 'int', None, 'cdecl', 'msvcr71._abnormal_termination', () ),
    'msvcr71._access':( 'int', None, 'cdecl', 'msvcr71._access', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._acmdln':( 'int', None, 'cdecl', 'msvcr71._acmdln', () ),
    'msvcr71._adj_fdiv_m16i':( 'int', None, 'cdecl', 'msvcr71._adj_fdiv_m16i', () ),
    'msvcr71._adj_fdiv_m32':( 'int', None, 'cdecl', 'msvcr71._adj_fdiv_m32', (('int', None),) ),
    'msvcr71._adj_fdiv_m32i':( 'int', None, 'cdecl', 'msvcr71._adj_fdiv_m32i', () ),
    'msvcr71._adj_fdiv_m64':( 'int', None, 'cdecl', 'msvcr71._adj_fdiv_m64', (('int', None), ('int', None)) ),
    'msvcr71._adj_fdiv_r':( 'int', None, 'cdecl', 'msvcr71._adj_fdiv_r', () ),
    'msvcr71._adj_fdivr_m16i':( 'int', None, 'cdecl', 'msvcr71._adj_fdivr_m16i', () ),
    'msvcr71._adj_fdivr_m32':( 'int', None, 'cdecl', 'msvcr71._adj_fdivr_m32', (('int', None),) ),
    'msvcr71._adj_fdivr_m32i':( 'int', None, 'cdecl', 'msvcr71._adj_fdivr_m32i', () ),
    'msvcr71._adj_fdivr_m64':( 'int', None, 'cdecl', 'msvcr71._adj_fdivr_m64', (('int', None), ('int', None)) ),
    'msvcr71._adj_fpatan':( 'int', None, 'cdecl', 'msvcr71._adj_fpatan', () ),
    'msvcr71._adj_fprem':( 'int', None, 'cdecl', 'msvcr71._adj_fprem', () ),
    'msvcr71._adj_fprem1':( 'int', None, 'cdecl', 'msvcr71._adj_fprem1', () ),
    'msvcr71._adj_fptan':( 'int', None, 'cdecl', 'msvcr71._adj_fptan', () ),
    'msvcr71._adjust_fdiv':( 'int', None, 'cdecl', 'msvcr71._adjust_fdiv', () ),
    'msvcr71._aexit_rtn':( 'int', None, 'cdecl', 'msvcr71._aexit_rtn', () ),
    'msvcr71._aligned_free':( 'int', None, 'cdecl', 'msvcr71._aligned_free', (('int', None),) ),
    'msvcr71._aligned_malloc':( 'int', None, 'cdecl', 'msvcr71._aligned_malloc', (('int', None), ('int', None)) ),
    'msvcr71._aligned_offset_malloc':( 'int', None, 'cdecl', 'msvcr71._aligned_offset_malloc', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._aligned_offset_realloc':( 'int', None, 'cdecl', 'msvcr71._aligned_offset_realloc', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._aligned_realloc':( 'int', None, 'cdecl', 'msvcr71._aligned_realloc', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._amsg_exit':( 'int', None, 'cdecl', 'msvcr71._amsg_exit', (('int', None),) ),
    'msvcr71._assert':( 'int', None, 'stdcall', 'msvcr71._assert', (('void *', 'ptr'),) ),
    'msvcr71._atodbl':( 'int', None, 'cdecl', 'msvcr71._atodbl', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._atoi64':( 'int', None, 'cdecl', 'msvcr71._atoi64', (('int', None),) ),
    'msvcr71._atoldbl':( 'int', None, 'cdecl', 'msvcr71._atoldbl', (('int', None), ('int', None)) ),
    'msvcr71._beep':( 'int', None, 'cdecl', 'msvcr71._beep', (('int', None), ('int', None)) ),
    'msvcr71._beginthread':( 'int', None, 'cdecl', 'msvcr71._beginthread', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._beginthreadex':( 'int', None, 'cdecl', 'msvcr71._beginthreadex', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._c_exit':( 'int', None, 'cdecl', 'msvcr71._c_exit', () ),
    'msvcr71._cabs':( 'int', None, 'cdecl', 'msvcr71._cabs', () ),
    'msvcr71._callnewh':( 'int', None, 'cdecl', 'msvcr71._callnewh', (('int', None),) ),
    'msvcr71._cexit':( 'int', None, 'cdecl', 'msvcr71._cexit', () ),
    'msvcr71._cgets':( 'int', None, 'cdecl', 'msvcr71._cgets', (('int', None),) ),
    'msvcr71._cgetws':( 'int', None, 'cdecl', 'msvcr71._cgetws', (('int', None),) ),
    'msvcr71._chdir':( 'int', None, 'cdecl', 'msvcr71._chdir', (('int', None),) ),
    'msvcr71._chdrive':( 'int', None, 'cdecl', 'msvcr71._chdrive', (('int', None),) ),
    'msvcr71._chgsign':( 'int', None, 'cdecl', 'msvcr71._chgsign', (('int', None), ('int', None)) ),
    'msvcr71._chkesp':( 'int', None, 'cdecl', 'msvcr71._chkesp', () ),
    'msvcr71._chmod':( 'int', None, 'cdecl', 'msvcr71._chmod', (('int', None), ('int', None)) ),
    'msvcr71._chsize':( 'int', None, 'cdecl', 'msvcr71._chsize', (('int', None), ('int', None)) ),
    'msvcr71._clearfp':( 'int', None, 'cdecl', 'msvcr71._clearfp', () ),
    'msvcr71._close':( 'int', None, 'cdecl', 'msvcr71._close', (('int', None),) ),
    'msvcr71._commit':( 'int', None, 'cdecl', 'msvcr71._commit', (('int', None),) ),
    'msvcr71._commode':( 'int', None, 'cdecl', 'msvcr71._commode', () ),
    'msvcr71._control87':( 'int', None, 'cdecl', 'msvcr71._control87', () ),
    'msvcr71._controlfp':( 'int', None, 'cdecl', 'msvcr71._controlfp', (('int', None), ('int', None)) ),
    'msvcr71._copysign':( 'int', None, 'cdecl', 'msvcr71._copysign', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._cprintf':( 'int', None, 'cdecl', 'msvcr71._cprintf', (('int', None),) ),
    'msvcr71._cputs':( 'int', None, 'cdecl', 'msvcr71._cputs', (('void *', 'ptr'),) ),
    'msvcr71._cputws':( 'int', None, 'cdecl', 'msvcr71._cputws', (('void *', 'ptr'),) ),
    'msvcr71._creat':( 'int', None, 'cdecl', 'msvcr71._creat', (('StringA', None), ('int', None)) ),
    'msvcr71._cscanf':( 'int', None, 'cdecl', 'msvcr71._cscanf', (('int', None),) ),
    'msvcr71._ctime64':( 'int', None, 'cdecl', 'msvcr71._ctime64', (('void *', 'ptr'),) ),
    'msvcr71._cwait':( 'int', None, 'cdecl', 'msvcr71._cwait', (('void *', 'ptr'), ('HANDLE', None)) ),
    'msvcr71._cwprintf':( 'int', None, 'cdecl', 'msvcr71._cwprintf', (('int', None),) ),
    'msvcr71._cwscanf':( 'int', None, 'cdecl', 'msvcr71._cwscanf', (('int', None),) ),
    'msvcr71._daylight':( 'int', None, 'bfastcall', 'msvcr71._daylight', (('int', None),) ),
    'msvcr71._dstbias':( 'int', None, 'cdecl', 'msvcr71._dstbias', () ),
    'msvcr71._dup':( 'int', None, 'cdecl', 'msvcr71._dup', (('int', None),) ),
    'msvcr71._dup2':( 'int', None, 'cdecl', 'msvcr71._dup2', (('int', None), ('int', None)) ),
    'msvcr71._ecvt':( 'int', None, 'cdecl', 'msvcr71._ecvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._endthread':( 'int', None, 'cdecl', 'msvcr71._endthread', () ),
    'msvcr71._endthreadex':( 'int', None, 'cdecl', 'msvcr71._endthreadex', (('int', None),) ),
    'msvcr71._environ':( 'int', None, 'cdecl', 'msvcr71._environ', () ),
    'msvcr71._eof':( 'int', None, 'cdecl', 'msvcr71._eof', (('int', None),) ),
    'msvcr71._errno':( 'int', None, 'cdecl', 'msvcr71._errno', () ),
    'msvcr71._except_handler2':( 'int', None, 'cdecl', 'msvcr71._except_handler2', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._except_handler3':( 'int', None, 'cdecl', 'msvcr71._except_handler3', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._execl':( 'int', None, 'cdecl', 'msvcr71._execl', () ),
    'msvcr71._execle':( 'int', None, 'cdecl', 'msvcr71._execle', ( ('int', None), ('int', None)) ),
    'msvcr71._execlp':( 'int', None, 'cdecl', 'msvcr71._execlp', () ),
    'msvcr71._execlpe':( 'int', None, 'cdecl', 'msvcr71._execlpe', ( ('int', None), ('int', None)) ),
    'msvcr71._execv':( 'int', None, 'cdecl', 'msvcr71._execv', ( ('int', None),) ),
    'msvcr71._execve':( 'int', None, 'cdecl', 'msvcr71._execve', ( ('int', None), ('int', None)) ),
    'msvcr71._execvp':( 'int', None, 'cdecl', 'msvcr71._execvp', ( ('int', None),) ),
    'msvcr71._execvpe':( 'int', None, 'cdecl', 'msvcr71._execvpe', ( ('int', None), ('int', None)) ),
    'msvcr71._exit':( 'int', None, 'cdecl', 'msvcr71._exit', (('int', None),) ),
    'msvcr71._expand':( 'int', None, 'cdecl', 'msvcr71._expand', (('int', None), ('int', None)) ),
    'msvcr71._fcloseall':( 'int', None, 'cdecl', 'msvcr71._fcloseall', () ),
    'msvcr71._fcvt':( 'int', None, 'cdecl', 'msvcr71._fcvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._fdopen':( 'int', None, 'cdecl', 'msvcr71._fdopen', (('int', None), ('int', None)) ),
    'msvcr71._fgetchar':( 'int', None, 'cdecl', 'msvcr71._fgetchar', () ),
    'msvcr71._fgetwchar':( 'int', None, 'cdecl', 'msvcr71._fgetwchar', () ),
    'msvcr71._filbuf':( 'int', None, 'cdecl', 'msvcr71._filbuf', (('int', None),) ),
    'msvcr71._fileinfo':( 'int', None, 'cdecl', 'msvcr71._fileinfo', () ),
    'msvcr71._filelength':( 'int', None, 'cdecl', 'msvcr71._filelength', (('int', None),) ),
    'msvcr71._filelengthi64':( 'int', None, 'cdecl', 'msvcr71._filelengthi64', (('int', None),) ),
    'msvcr71._fileno':( 'int', None, 'cdecl', 'msvcr71._fileno', (('int', None),) ),
    'msvcr71._findclose':( 'int', None, 'cdecl', 'msvcr71._findclose', (('void *', 'ptr'),) ),
    'msvcr71._findfirst':( 'int', None, 'cdecl', 'msvcr71._findfirst', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._findfirst64':( 'int', None, 'cdecl', 'msvcr71._findfirst64', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._findfirsti64':( 'int', None, 'cdecl', 'msvcr71._findfirsti64', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._findnext':( 'int', None, 'cdecl', 'msvcr71._findnext', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._findnext64':( 'int', None, 'cdecl', 'msvcr71._findnext64', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._findnexti64':( 'int', None, 'cdecl', 'msvcr71._findnexti64', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._finite':( 'int', None, 'cdecl', 'msvcr71._finite', (('int', None), ('int', None)) ),
    'msvcr71._flsbuf':( 'int', None, 'cdecl', 'msvcr71._flsbuf', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._flushall':( 'int', None, 'cdecl', 'msvcr71._flushall', () ),
    'msvcr71._fmode':( 'int', None, 'cdecl', 'msvcr71._fmode', () ),
    'msvcr71._fpclass':( 'int', None, 'cdecl', 'msvcr71._fpclass', (('int', None), ('int', None)) ),
    'msvcr71._fpieee_flt':( 'int', None, 'cdecl', 'msvcr71._fpieee_flt', (('int', None),) ),
    'msvcr71._fpreset':( 'int', None, 'cdecl', 'msvcr71._fpreset', () ),
    'msvcr71._fputchar':( 'int', None, 'cdecl', 'msvcr71._fputchar', (('int', None),) ),
    'msvcr71._fputwchar':( 'int', None, 'cdecl', 'msvcr71._fputwchar', (('int', None),) ),
    'msvcr71._fsopen':( 'int', None, 'cdecl', 'msvcr71._fsopen', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcr71._fstat':( 'int', None, 'cdecl', 'msvcr71._fstat', (('int', None), ('int', None)) ),
    'msvcr71._fstat64':( 'int', None, 'cdecl', 'msvcr71._fstat64', (('int', None), ('int', None)) ),
    'msvcr71._fstati64':( 'int', None, 'cdecl', 'msvcr71._fstati64', (('int', None), ('int', None)) ),
    'msvcr71._ftime':( 'int', None, 'cdecl', 'msvcr71._ftime', (('int', None),) ),
    'msvcr71._ftime64':( 'int', None, 'cdecl', 'msvcr71._ftime64', (('int', None),) ),
    'msvcr71._ftol':( 'int', None, 'cdecl', 'msvcr71._ftol', () ),
    'msvcr71._fullpath':( 'int', None, 'cdecl', 'msvcr71._fullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._futime':( 'int', None, 'cdecl', 'msvcr71._futime', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._futime64':( 'int', None, 'cdecl', 'msvcr71._futime64', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._gcvt':( 'int', None, 'cdecl', 'msvcr71._gcvt', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'msvcr71._get_heap_handle':( 'int', None, 'cdecl', 'msvcr71._get_heap_handle', () ),
    'msvcr71._get_osfhandle':( 'int', None, 'cdecl', 'msvcr71._get_osfhandle', (('int', None),) ),
    'msvcr71._get_sbh_threshold':( 'int', None, 'cdecl', 'msvcr71._get_sbh_threshold', () ),
    'msvcr71._getch':( 'int', None, 'cdecl', 'msvcr71._getch', () ),
    'msvcr71._getche':( 'int', None, 'cdecl', 'msvcr71._getche', () ),
    'msvcr71._getcwd':( 'int', None, 'cdecl', 'msvcr71._getcwd', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._getdcwd':( 'int', None, 'cdecl', 'msvcr71._getdcwd', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._getdiskfree':( 'int', None, 'cdecl', 'msvcr71._getdiskfree', (('int', None), ('int', None)) ),
    'msvcr71._getdllprocaddr':( 'int', None, 'cdecl', 'msvcr71._getdllprocaddr', (('HMODULE', None), ('StringA', None), ('int', None)) ),
    'msvcr71._getdrive':( 'int', None, 'cdecl', 'msvcr71._getdrive', () ),
    'msvcr71._getdrives':( 'int', None, 'stdcall', 'msvcr71._getdrives', () ),
    'msvcr71._getmaxstdio':( 'int', None, 'cdecl', 'msvcr71._getmaxstdio', () ),
    'msvcr71._getmbcp':( 'int', None, 'cdecl', 'msvcr71._getmbcp', () ),
    'msvcr71._getpid':( 'int', None, 'stdcall', 'msvcr71._getpid', () ),
    'msvcr71._getsystime':( 'int', None, 'cdecl', 'msvcr71._getsystime', (('int', None),) ),
    'msvcr71._getw':( 'int', None, 'cdecl', 'msvcr71._getw', (('int', None),) ),
    'msvcr71._getwch':( 'int', None, 'cdecl', 'msvcr71._getwch', () ),
    'msvcr71._getwche':( 'int', None, 'cdecl', 'msvcr71._getwche', () ),
    'msvcr71._getws':( 'int', None, 'cdecl', 'msvcr71._getws', (('int', None),) ),
    'msvcr71._global_unwind2':( 'int', None, 'cdecl', 'msvcr71._global_unwind2', (('int', None),) ),
    'msvcr71._gmtime64':( 'int', None, 'cdecl', 'msvcr71._gmtime64', (('void *', 'ptr'),) ),
    'msvcr71._heapadd':( 'int', None, 'cdecl', 'msvcr71._heapadd', () ),
    'msvcr71._heapchk':( 'int', None, 'cdecl', 'msvcr71._heapchk', () ),
    'msvcr71._heapmin':( 'int', None, 'cdecl', 'msvcr71._heapmin', () ),
    'msvcr71._heapset':( 'int', None, 'cdecl', 'msvcr71._heapset', () ),
    'msvcr71._heapused':( 'int', None, 'cdecl', 'msvcr71._heapused', () ),
    'msvcr71._heapwalk':( 'int', None, 'cdecl', 'msvcr71._heapwalk', (('int', None),) ),
    'msvcr71._hypot':( 'int', None, 'cdecl', 'msvcr71._hypot', () ),
    'msvcr71._i64toa':( 'int', None, 'msfastcall', 'msvcr71._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._i64tow':( 'int', None, 'msfastcall', 'msvcr71._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._initterm':( 'int', None, 'cdecl', 'msvcr71._initterm', (('int', None), ('int', None)) ),
    'msvcr71._inp':( 'int', None, 'cdecl', 'msvcr71._inp', (('int', None),) ),
    'msvcr71._inpd':( 'int', None, 'cdecl', 'msvcr71._inpd', (('int', None),) ),
    'msvcr71._inpw':( 'int', None, 'cdecl', 'msvcr71._inpw', (('int', None),) ),
    'msvcr71._iob':( 'int', None, 'bfastcall', 'msvcr71._iob', (('int', None),) ),
    'msvcr71._isatty':( 'int', None, 'cdecl', 'msvcr71._isatty', (('int', None),) ),
    'msvcr71._isctype':( 'int', None, 'cdecl', 'msvcr71._isctype', (('int', None), ('int', None)) ),
    'msvcr71._ismbbalnum':( 'int', None, 'cdecl', 'msvcr71._ismbbalnum', (('int', None),) ),
    'msvcr71._ismbbalpha':( 'int', None, 'cdecl', 'msvcr71._ismbbalpha', (('int', None),) ),
    'msvcr71._ismbbgraph':( 'int', None, 'cdecl', 'msvcr71._ismbbgraph', (('int', None),) ),
    'msvcr71._ismbbkalnum':( 'int', None, 'cdecl', 'msvcr71._ismbbkalnum', (('int', None),) ),
    'msvcr71._ismbbkana':( 'int', None, 'cdecl', 'msvcr71._ismbbkana', (('int', None),) ),
    'msvcr71._ismbbkprint':( 'int', None, 'cdecl', 'msvcr71._ismbbkprint', (('int', None),) ),
    'msvcr71._ismbbkpunct':( 'int', None, 'cdecl', 'msvcr71._ismbbkpunct', (('int', None),) ),
    'msvcr71._ismbblead':( 'int', None, 'cdecl', 'msvcr71._ismbblead', (('int', None),) ),
    'msvcr71._ismbbprint':( 'int', None, 'cdecl', 'msvcr71._ismbbprint', (('int', None),) ),
    'msvcr71._ismbbpunct':( 'int', None, 'cdecl', 'msvcr71._ismbbpunct', (('int', None),) ),
    'msvcr71._ismbbtrail':( 'int', None, 'cdecl', 'msvcr71._ismbbtrail', (('int', None),) ),
    'msvcr71._ismbcalnum':( 'int', None, 'cdecl', 'msvcr71._ismbcalnum', (('int', None),) ),
    'msvcr71._ismbcalpha':( 'int', None, 'cdecl', 'msvcr71._ismbcalpha', (('int', None),) ),
    'msvcr71._ismbcdigit':( 'int', None, 'cdecl', 'msvcr71._ismbcdigit', (('int', None),) ),
    'msvcr71._ismbcgraph':( 'int', None, 'cdecl', 'msvcr71._ismbcgraph', (('int', None),) ),
    'msvcr71._ismbchira':( 'int', None, 'cdecl', 'msvcr71._ismbchira', (('int', None),) ),
    'msvcr71._ismbckata':( 'int', None, 'cdecl', 'msvcr71._ismbckata', (('int', None),) ),
    'msvcr71._ismbcl0':( 'int', None, 'cdecl', 'msvcr71._ismbcl0', (('int', None),) ),
    'msvcr71._ismbcl1':( 'int', None, 'cdecl', 'msvcr71._ismbcl1', (('int', None),) ),
    'msvcr71._ismbcl2':( 'int', None, 'cdecl', 'msvcr71._ismbcl2', (('int', None),) ),
    'msvcr71._ismbclegal':( 'int', None, 'cdecl', 'msvcr71._ismbclegal', (('int', None),) ),
    'msvcr71._ismbclower':( 'int', None, 'cdecl', 'msvcr71._ismbclower', (('int', None),) ),
    'msvcr71._ismbcprint':( 'int', None, 'cdecl', 'msvcr71._ismbcprint', (('int', None),) ),
    'msvcr71._ismbcpunct':( 'int', None, 'cdecl', 'msvcr71._ismbcpunct', (('int', None),) ),
    'msvcr71._ismbcspace':( 'int', None, 'cdecl', 'msvcr71._ismbcspace', (('int', None),) ),
    'msvcr71._ismbcsymbol':( 'int', None, 'cdecl', 'msvcr71._ismbcsymbol', (('int', None),) ),
    'msvcr71._ismbcupper':( 'int', None, 'cdecl', 'msvcr71._ismbcupper', (('int', None),) ),
    'msvcr71._ismbslead':( 'int', None, 'cdecl', 'msvcr71._ismbslead', (('int', None), ('int', None)) ),
    'msvcr71._ismbstrail':( 'int', None, 'cdecl', 'msvcr71._ismbstrail', (('int', None), ('int', None)) ),
    'msvcr71._isnan':( 'int', None, 'cdecl', 'msvcr71._isnan', (('int', None), ('int', None)) ),
    'msvcr71._itoa':( 'int', None, 'cdecl', 'msvcr71._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcr71._itow':( 'int', None, 'cdecl', 'msvcr71._itow', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._j0':( 'int', None, 'cdecl', 'msvcr71._j0', () ),
    'msvcr71._j1':( 'int', None, 'cdecl', 'msvcr71._j1', () ),
    'msvcr71._jn':( 'int', None, 'cdecl', 'msvcr71._jn', (('int', None),) ),
    'msvcr71._kbhit':( 'int', None, 'cdecl', 'msvcr71._kbhit', () ),
    'msvcr71._lfind':( 'int', None, 'cdecl', 'msvcr71._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcr71._loaddll':( 'int', None, 'cdecl', 'msvcr71._loaddll', (('FileNameA', None),) ),
    'msvcr71._local_unwind2':( 'int', None, 'cdecl', 'msvcr71._local_unwind2', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._localtime64':( 'int', None, 'cdecl', 'msvcr71._localtime64', (('void *', 'ptr'),) ),
    'msvcr71._lock':( 'int', None, 'cdecl', 'msvcr71._lock', (('int', None),) ),
    'msvcr71._locking':( 'int', None, 'cdecl', 'msvcr71._locking', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._logb':( 'int', None, 'cdecl', 'msvcr71._logb', (('int', None), ('int', None)) ),
    'msvcr71._longjmpex':( 'int', None, 'cdecl', 'msvcr71._longjmpex', (('int', None), ('int', None)) ),
    'msvcr71._lrotl':( 'int', None, 'cdecl', 'msvcr71._lrotl', (('int', None), ('int', None)) ),
    'msvcr71._lrotr':( 'int', None, 'cdecl', 'msvcr71._lrotr', (('int', None), ('int', None)) ),
    'msvcr71._lsearch':( 'int', None, 'cdecl', 'msvcr71._lsearch', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcr71._lseek':( 'int', None, 'cdecl', 'msvcr71._lseek', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._lseeki64':( 'int', None, 'cdecl', 'msvcr71._lseeki64', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._ltoa':( 'int', None, 'cdecl', 'msvcr71._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'msvcr71._ltow':( 'int', None, 'cdecl', 'msvcr71._ltow', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._makepath':( 'int', None, 'cdecl', 'msvcr71._makepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbbtombc':( 'int', None, 'cdecl', 'msvcr71._mbbtombc', (('int', None),) ),
    'msvcr71._mbbtype':( 'int', None, 'cdecl', 'msvcr71._mbbtype', (('int', None), ('int', None)) ),
    'msvcr71._mbcasemap':( 'int', None, 'cdecl', 'msvcr71._mbcasemap', () ),
    'msvcr71._mbccpy':( 'int', None, 'cdecl', 'msvcr71._mbccpy', (('int', None), ('int', None)) ),
    'msvcr71._mbcjistojms':( 'int', None, 'cdecl', 'msvcr71._mbcjistojms', (('int', None),) ),
    'msvcr71._mbcjmstojis':( 'int', None, 'cdecl', 'msvcr71._mbcjmstojis', (('int', None),) ),
    'msvcr71._mbclen':( 'int', None, 'cdecl', 'msvcr71._mbclen', (('int', None),) ),
    'msvcr71._mbctohira':( 'int', None, 'cdecl', 'msvcr71._mbctohira', (('int', None),) ),
    'msvcr71._mbctokata':( 'int', None, 'cdecl', 'msvcr71._mbctokata', (('int', None),) ),
    'msvcr71._mbctolower':( 'int', None, 'cdecl', 'msvcr71._mbctolower', (('int', None),) ),
    'msvcr71._mbctombb':( 'int', None, 'cdecl', 'msvcr71._mbctombb', (('int', None),) ),
    'msvcr71._mbctoupper':( 'int', None, 'cdecl', 'msvcr71._mbctoupper', (('int', None),) ),
    'msvcr71._mbctype':( 'int', None, 'cdecl', 'msvcr71._mbctype', () ),
    'msvcr71._mbsbtype':( 'int', None, 'cdecl', 'msvcr71._mbsbtype', (('int', None), ('int', None)) ),
    'msvcr71._mbscat':( 'int', None, 'cdecl', 'msvcr71._mbscat', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbschr':( 'int', None, 'cdecl', 'msvcr71._mbschr', (('int', None), ('int', None)) ),
    'msvcr71._mbscmp':( 'int', None, 'cdecl', 'msvcr71._mbscmp', (('int', None), ('int', None)) ),
    'msvcr71._mbscoll':( 'int', None, 'cdecl', 'msvcr71._mbscoll', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbscpy':( 'int', None, 'cdecl', 'msvcr71._mbscpy', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbscspn':( 'int', None, 'cdecl', 'msvcr71._mbscspn', (('int', None), ('int', None)) ),
    'msvcr71._mbsdec':( 'int', None, 'cdecl', 'msvcr71._mbsdec', (('int', None), ('int', None)) ),
    'msvcr71._mbsdup':( 'int', None, 'cdecl', 'msvcr71._mbsdup', (('void *', 'ptr'),) ),
    'msvcr71._mbsicmp':( 'int', None, 'cdecl', 'msvcr71._mbsicmp', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbsicoll':( 'int', None, 'cdecl', 'msvcr71._mbsicoll', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbsinc':( 'int', None, 'cdecl', 'msvcr71._mbsinc', (('int', None),) ),
    'msvcr71._mbslen':( 'int', None, 'cdecl', 'msvcr71._mbslen', (('int', None),) ),
    'msvcr71._mbslwr':( 'int', None, 'cdecl', 'msvcr71._mbslwr', (('void *', 'ptr'),) ),
    'msvcr71._mbsnbcat':( 'int', None, 'cdecl', 'msvcr71._mbsnbcat', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsnbcmp':( 'int', None, 'cdecl', 'msvcr71._mbsnbcmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsnbcnt':( 'int', None, 'cdecl', 'msvcr71._mbsnbcnt', (('int', None), ('int', None)) ),
    'msvcr71._mbsnbcoll':( 'int', None, 'cdecl', 'msvcr71._mbsnbcoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsnbcpy':( 'int', None, 'cdecl', 'msvcr71._mbsnbcpy', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsnbicmp':( 'int', None, 'cdecl', 'msvcr71._mbsnbicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsnbicoll':( 'int', None, 'cdecl', 'msvcr71._mbsnbicoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsnbset':( 'int', None, 'cdecl', 'msvcr71._mbsnbset', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsncat':( 'int', None, 'cdecl', 'msvcr71._mbsncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._mbsnccnt':( 'int', None, 'cdecl', 'msvcr71._mbsnccnt', (('int', None), ('int', None)) ),
    'msvcr71._mbsncmp':( 'int', None, 'cdecl', 'msvcr71._mbsncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsncoll':( 'int', None, 'cdecl', 'msvcr71._mbsncoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsncpy':( 'int', None, 'cdecl', 'msvcr71._mbsncpy', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsnextc':( 'int', None, 'cdecl', 'msvcr71._mbsnextc', (('int', None),) ),
    'msvcr71._mbsnicmp':( 'int', None, 'cdecl', 'msvcr71._mbsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbsnicoll':( 'int', None, 'cdecl', 'msvcr71._mbsnicoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._mbsninc':( 'int', None, 'cdecl', 'msvcr71._mbsninc', (('int', None), ('int', None)) ),
    'msvcr71._mbsnset':( 'int', None, 'cdecl', 'msvcr71._mbsnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mbspbrk':( 'int', None, 'cdecl', 'msvcr71._mbspbrk', (('int', None), ('int', None)) ),
    'msvcr71._mbsrchr':( 'int', None, 'cdecl', 'msvcr71._mbsrchr', (('int', None), ('int', None)) ),
    'msvcr71._mbsrev':( 'int', None, 'cdecl', 'msvcr71._mbsrev', (('int', None),) ),
    'msvcr71._mbsset':( 'int', None, 'cdecl', 'msvcr71._mbsset', (('int', None), ('int', None)) ),
    'msvcr71._mbsspn':( 'int', None, 'cdecl', 'msvcr71._mbsspn', (('int', None), ('int', None)) ),
    'msvcr71._mbsspnp':( 'int', None, 'cdecl', 'msvcr71._mbsspnp', (('int', None), ('int', None)) ),
    'msvcr71._mbsstr':( 'int', None, 'cdecl', 'msvcr71._mbsstr', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._mbstok':( 'int', None, 'cdecl', 'msvcr71._mbstok', (('int', None), ('int', None)) ),
    'msvcr71._mbstrlen':( 'int', None, 'cdecl', 'msvcr71._mbstrlen', (('int', None),) ),
    'msvcr71._mbsupr':( 'int', None, 'cdecl', 'msvcr71._mbsupr', (('void *', 'ptr'),) ),
    'msvcr71._memccpy':( 'int', None, 'cdecl', 'msvcr71._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._memicmp':( 'int', None, 'cdecl', 'msvcr71._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._mkdir':( 'int', None, 'cdecl', 'msvcr71._mkdir', (('StringA', None),) ),
    'msvcr71._mktemp':( 'int', None, 'cdecl', 'msvcr71._mktemp', (('void *', 'ptr'),) ),
    'msvcr71._mktime64':( 'int', None, 'cdecl', 'msvcr71._mktime64', (('int', None),) ),
    'msvcr71._msize':( 'int', None, 'cdecl', 'msvcr71._msize', (('int', None),) ),
    'msvcr71._nextafter':( 'int', None, 'cdecl', 'msvcr71._nextafter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._onexit':( 'int', None, 'cdecl', 'msvcr71._onexit', (('int', None),) ),
    'msvcr71._open':( 'int', None, 'cdecl', 'msvcr71._open', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcr71._open_osfhandle':( 'int', None, 'cdecl', 'msvcr71._open_osfhandle', (('int', None), ('int', None)) ),
    'msvcr71._osplatform':( 'int', None, 'cdecl', 'msvcr71._osplatform', () ),
    'msvcr71._osver':( 'int', None, 'cdecl', 'msvcr71._osver', () ),
    'msvcr71._outp':( 'int', None, 'cdecl', 'msvcr71._outp', (('int', None), ('int', None)) ),
    'msvcr71._outpd':( 'int', None, 'cdecl', 'msvcr71._outpd', (('int', None), ('int', None)) ),
    'msvcr71._outpw':( 'int', None, 'cdecl', 'msvcr71._outpw', (('int', None), ('int', None)) ),
    'msvcr71._pclose':( 'int', None, 'cdecl', 'msvcr71._pclose', (('int', None),) ),
    'msvcr71._pctype':( 'int', None, 'cdecl', 'msvcr71._pctype', () ),
    'msvcr71._pgmptr':( 'int', None, 'cdecl', 'msvcr71._pgmptr', () ),
    'msvcr71._pipe':( 'int', None, 'cdecl', 'msvcr71._pipe', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._popen':( 'int', None, 'cdecl', 'msvcr71._popen', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._purecall':( 'int', None, 'cdecl', 'msvcr71._purecall', () ),
    'msvcr71._putch':( 'int', None, 'cdecl', 'msvcr71._putch', (('int', None),) ),
    'msvcr71._putenv':( 'int', None, 'cdecl', 'msvcr71._putenv', (('void *', 'ptr'),) ),
    'msvcr71._putw':( 'int', None, 'cdecl', 'msvcr71._putw', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._putwch':( 'int', None, 'cdecl', 'msvcr71._putwch', (('int', None),) ),
    'msvcr71._putws':( 'int', None, 'cdecl', 'msvcr71._putws', (('int', None),) ),
    'msvcr71._pwctype':( 'int', None, 'cdecl', 'msvcr71._pwctype', () ),
    'msvcr71._read':( 'int', None, 'cdecl', 'msvcr71._read', (('int', None), ('StringA', None), ('DWORD', None)) ),
    'msvcr71._resetstkoflw':( 'int', None, 'cdecl', 'msvcr71._resetstkoflw', () ),
    'msvcr71._rmdir':( 'int', None, 'cdecl', 'msvcr71._rmdir', (('int', None),) ),
    'msvcr71._rmtmp':( 'int', None, 'cdecl', 'msvcr71._rmtmp', () ),
    'msvcr71._rotl':( 'int', None, 'cdecl', 'msvcr71._rotl', (('int', None), ('int', None)) ),
    'msvcr71._rotr':( 'int', None, 'cdecl', 'msvcr71._rotr', (('int', None), ('int', None)) ),
    'msvcr71._safe_fdiv':( 'int', None, 'cdecl', 'msvcr71._safe_fdiv', () ),
    'msvcr71._safe_fdivr':( 'int', None, 'cdecl', 'msvcr71._safe_fdivr', () ),
    'msvcr71._safe_fprem':( 'int', None, 'cdecl', 'msvcr71._safe_fprem', () ),
    'msvcr71._safe_fprem1':( 'int', None, 'cdecl', 'msvcr71._safe_fprem1', () ),
    'msvcr71._scalb':( 'int', None, 'cdecl', 'msvcr71._scalb', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._scprintf':( 'int', None, 'cdecl', 'msvcr71._scprintf', (('int', None),) ),
    'msvcr71._scwprintf':( 'int', None, 'cdecl', 'msvcr71._scwprintf', (('int', None),) ),
    'msvcr71._searchenv':( 'int', None, 'cdecl', 'msvcr71._searchenv', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._seh_longjmp_unwind':( 'int', None, 'stdcall', 'msvcr71._seh_longjmp_unwind', (('int', None),) ),
    'msvcr71._set_sse2_enable':( 'int', None, 'cdecl', 'msvcr71._set_SSE2_enable', (('int', None),) ),
    'msvcr71._set_error_mode':( 'int', None, 'cdecl', 'msvcr71._set_error_mode', (('int', None),) ),
    'msvcr71._set_purecall_handler':( 'int', None, 'cdecl', 'msvcr71._set_purecall_handler', (('int', None),) ),
    'msvcr71._set_sbh_threshold':( 'int', None, 'cdecl', 'msvcr71._set_sbh_threshold', (('int', None),) ),
    'msvcr71._set_security_error_handler':( 'int', None, 'cdecl', 'msvcr71._set_security_error_handler', (('int', None),) ),
    'msvcr71._seterrormode':( 'int', None, 'cdecl', 'msvcr71._seterrormode', (('int', None),) ),
    'msvcr71._setjmp':( 'int', None, 'cdecl', 'msvcr71._setjmp', (('int', None),) ),
    'msvcr71._setjmp3':( 'int', None, 'cdecl', 'msvcr71._setjmp3', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._setmaxstdio':( 'int', None, 'cdecl', 'msvcr71._setmaxstdio', (('int', None),) ),
    'msvcr71._setmbcp':( 'int', None, 'cdecl', 'msvcr71._setmbcp', (('int', None),) ),
    'msvcr71._setmode':( 'int', None, 'cdecl', 'msvcr71._setmode', (('int', None), ('int', None)) ),
    'msvcr71._setsystime':( 'int', None, 'cdecl', 'msvcr71._setsystime', (('int', None), ('int', None)) ),
    'msvcr71._sleep':( 'int', None, 'cdecl', 'msvcr71._sleep', (('int', None),) ),
    'msvcr71._snprintf':( 'int', None, 'cdecl', 'msvcr71._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._snscanf':( 'int', None, 'cdecl', 'msvcr71._snscanf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._snwprintf':( 'int', None, 'cdecl', 'msvcr71._snwprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._snwscanf':( 'int', None, 'cdecl', 'msvcr71._snwscanf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._sopen':( 'int', None, 'cdecl', 'msvcr71._sopen', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._spawnl':( 'int', None, 'cdecl', 'msvcr71._spawnl', (('int', None), ('void *', 'obj')) ),
    'msvcr71._spawnle':( 'int', None, 'cdecl', 'msvcr71._spawnle', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcr71._spawnlp':( 'int', None, 'cdecl', 'msvcr71._spawnlp', (('int', None), ('void *', 'obj')) ),
    'msvcr71._spawnlpe':( 'int', None, 'cdecl', 'msvcr71._spawnlpe', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcr71._spawnv':( 'int', None, 'cdecl', 'msvcr71._spawnv', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'msvcr71._spawnve':( 'int', None, 'cdecl', 'msvcr71._spawnve', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._spawnvp':( 'int', None, 'cdecl', 'msvcr71._spawnvp', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'msvcr71._spawnvpe':( 'int', None, 'cdecl', 'msvcr71._spawnvpe', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._splitpath':( 'int', None, 'cdecl', 'msvcr71._splitpath', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._stat':( 'int', None, 'cdecl', 'msvcr71._stat', (('int', None), ('int', None)) ),
    'msvcr71._stat64':( 'int', None, 'cdecl', 'msvcr71._stat64', (('int', None), ('int', None)) ),
    'msvcr71._stati64':( 'int', None, 'cdecl', 'msvcr71._stati64', (('int', None), ('int', None)) ),
    'msvcr71._statusfp':( 'int', None, 'cdecl', 'msvcr71._statusfp', () ),
    'msvcr71._strcmpi':( 'int', None, 'cdecl', 'msvcr71._strcmpi', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._strdate':( 'int', None, 'cdecl', 'msvcr71._strdate', (('int', None),) ),
    'msvcr71._strdup':( 'int', None, 'cdecl', 'msvcr71._strdup', (('void *', 'ptr'),) ),
    'msvcr71._strerror':( 'int', None, 'cdecl', 'msvcr71._strerror', (('int', None),) ),
    'msvcr71._stricmp':( 'int', None, 'cdecl', 'msvcr71._stricmp', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._stricoll':( 'int', None, 'cdecl', 'msvcr71._stricoll', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._strlwr':( 'int', None, 'cdecl', 'msvcr71._strlwr', (('void *', 'ptr'),) ),
    'msvcr71._strncoll':( 'int', None, 'cdecl', 'msvcr71._strncoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._strnicmp':( 'int', None, 'cdecl', 'msvcr71._strnicmp', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._strnicoll':( 'int', None, 'cdecl', 'msvcr71._strnicoll', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._strnset':( 'int', None, 'cdecl', 'msvcr71._strnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._strrev':( 'int', None, 'cdecl', 'msvcr71._strrev', (('int', None),) ),
    'msvcr71._strset':( 'int', None, 'cdecl', 'msvcr71._strset', (('int', None), ('int', None)) ),
    'msvcr71._strtime':( 'int', None, 'cdecl', 'msvcr71._strtime', (('int', None),) ),
    'msvcr71._strtoi64':( 'int', None, 'cdecl', 'msvcr71._strtoi64', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._strtoui64':( 'int', None, 'cdecl', 'msvcr71._strtoui64', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._strupr':( 'int', None, 'cdecl', 'msvcr71._strupr', (('void *', 'ptr'),) ),
    'msvcr71._swab':( 'int', None, 'cdecl', 'msvcr71._swab', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._sys_errlist':( 'int', None, 'cdecl', 'msvcr71._sys_errlist', () ),
    'msvcr71._sys_nerr':( 'int', None, 'bfastcall', 'msvcr71._sys_nerr', (('int', None),) ),
    'msvcr71._tell':( 'int', None, 'cdecl', 'msvcr71._tell', (('int', None),) ),
    'msvcr71._telli64':( 'int', None, 'cdecl', 'msvcr71._telli64', (('int', None),) ),
    'msvcr71._tempnam':( 'int', None, 'cdecl', 'msvcr71._tempnam', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._time64':( 'int', None, 'cdecl', 'msvcr71._time64', (('void *', 'ptr'),) ),
    'msvcr71._timezone':( 'int', None, 'bfastcall', 'msvcr71._timezone', (('int', None),) ),
    'msvcr71._tolower':( 'int', None, 'cdecl', 'msvcr71._tolower', (('int', None),) ),
    'msvcr71._toupper':( 'int', None, 'cdecl', 'msvcr71._toupper', (('int', None),) ),
    'msvcr71._tzname':( 'int', None, 'cdecl', 'msvcr71._tzname', () ),
    'msvcr71._tzset':( 'int', None, 'cdecl', 'msvcr71._tzset', () ),
    'msvcr71._ui64toa':( 'int', None, 'msfastcall', 'msvcr71._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._ui64tow':( 'int', None, 'msfastcall', 'msvcr71._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._ultoa':( 'int', None, 'cdecl', 'msvcr71._ultoa', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcr71._ultow':( 'int', None, 'cdecl', 'msvcr71._ultow', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._umask':( 'int', None, 'cdecl', 'msvcr71._umask', (('int', None),) ),
    'msvcr71._ungetch':( 'int', None, 'cdecl', 'msvcr71._ungetch', (('int', None),) ),
    'msvcr71._ungetwch':( 'int', None, 'cdecl', 'msvcr71._ungetwch', (('int', None),) ),
    'msvcr71._unlink':( 'int', None, 'cdecl', 'msvcr71._unlink', (('int', None),) ),
    'msvcr71._unloaddll':( 'int', None, 'cdecl', 'msvcr71._unloaddll', (('int', None),) ),
    'msvcr71._unlock':( 'int', None, 'cdecl', 'msvcr71._unlock', (('int', None),) ),
    'msvcr71._utime':( 'int', None, 'cdecl', 'msvcr71._utime', (('StringA', None), ('void *', 'ptr')) ),
    'msvcr71._utime64':( 'int', None, 'cdecl', 'msvcr71._utime64', (('StringA', None), ('void *', 'ptr')) ),
    'msvcr71._vscprintf':( 'int', None, 'cdecl', 'msvcr71._vscprintf', (('int', None), ('int', None)) ),
    'msvcr71._vscwprintf':( 'int', None, 'cdecl', 'msvcr71._vscwprintf', (('int', None), ('int', None)) ),
    'msvcr71._vsnprintf':( 'int', None, 'cdecl', 'msvcr71._vsnprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._vsnwprintf':( 'int', None, 'cdecl', 'msvcr71._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._waccess':( 'int', None, 'cdecl', 'msvcr71._waccess', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._wasctime':( 'int', None, 'cdecl', 'msvcr71._wasctime', (('int', None),) ),
    'msvcr71._wchdir':( 'int', None, 'cdecl', 'msvcr71._wchdir', (('int', None),) ),
    'msvcr71._wchmod':( 'int', None, 'cdecl', 'msvcr71._wchmod', (('int', None), ('int', None)) ),
    'msvcr71._wcmdln':( 'int', None, 'cdecl', 'msvcr71._wcmdln', () ),
    'msvcr71._wcreat':( 'int', None, 'cdecl', 'msvcr71._wcreat', (('StringW', None), ('int', None)) ),
    'msvcr71._wcsdup':( 'int', None, 'cdecl', 'msvcr71._wcsdup', (('int', None),) ),
    'msvcr71._wcserror':( 'int', None, 'cdecl', 'msvcr71._wcserror', (('int', None),) ),
    'msvcr71._wcsicmp':( 'int', None, 'cdecl', 'msvcr71._wcsicmp', (('int', None), ('int', None)) ),
    'msvcr71._wcsicoll':( 'int', None, 'cdecl', 'msvcr71._wcsicoll', (('int', None), ('int', None)) ),
    'msvcr71._wcslwr':( 'int', None, 'cdecl', 'msvcr71._wcslwr', (('int', None),) ),
    'msvcr71._wcsncoll':( 'int', None, 'cdecl', 'msvcr71._wcsncoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcsnicmp':( 'int', None, 'cdecl', 'msvcr71._wcsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcsnicoll':( 'int', None, 'cdecl', 'msvcr71._wcsnicoll', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcsnset':( 'int', None, 'cdecl', 'msvcr71._wcsnset', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcsrev':( 'int', None, 'cdecl', 'msvcr71._wcsrev', (('int', None),) ),
    'msvcr71._wcsset':( 'int', None, 'cdecl', 'msvcr71._wcsset', (('int', None), ('int', None)) ),
    'msvcr71._wcstoi64':( 'int', None, 'cdecl', 'msvcr71._wcstoi64', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcstoui64':( 'int', None, 'cdecl', 'msvcr71._wcstoui64', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wcsupr':( 'int', None, 'cdecl', 'msvcr71._wcsupr', (('int', None),) ),
    'msvcr71._wctime':( 'int', None, 'cdecl', 'msvcr71._wctime', (('void *', 'ptr'),) ),
    'msvcr71._wctime64':( 'int', None, 'cdecl', 'msvcr71._wctime64', (('void *', 'ptr'),) ),
    'msvcr71._wctype':( 'int', None, 'cdecl', 'msvcr71._wctype', () ),
    'msvcr71._wenviron':( 'int', None, 'cdecl', 'msvcr71._wenviron', () ),
    'msvcr71._wexecl':( 'int', None, 'cdecl', 'msvcr71._wexecl', () ),
    'msvcr71._wexecle':( 'int', None, 'cdecl', 'msvcr71._wexecle', ( ('int', None), ('int', None)) ),
    'msvcr71._wexeclp':( 'int', None, 'cdecl', 'msvcr71._wexeclp', () ),
    'msvcr71._wexeclpe':( 'int', None, 'cdecl', 'msvcr71._wexeclpe', ( ('int', None), ('int', None)) ),
    'msvcr71._wexecv':( 'int', None, 'cdecl', 'msvcr71._wexecv', ( ('int', None),) ),
    'msvcr71._wexecve':( 'int', None, 'cdecl', 'msvcr71._wexecve', ( ('int', None), ('int', None)) ),
    'msvcr71._wexecvp':( 'int', None, 'cdecl', 'msvcr71._wexecvp', ( ('int', None),) ),
    'msvcr71._wexecvpe':( 'int', None, 'cdecl', 'msvcr71._wexecvpe', ( ('int', None), ('int', None)) ),
    'msvcr71._wfdopen':( 'int', None, 'cdecl', 'msvcr71._wfdopen', (('int', None), ('int', None)) ),
    'msvcr71._wfindfirst':( 'int', None, 'cdecl', 'msvcr71._wfindfirst', (('int', None), ('int', None)) ),
    'msvcr71._wfindfirst64':( 'int', None, 'cdecl', 'msvcr71._wfindfirst64', (('int', None), ('int', None)) ),
    'msvcr71._wfindfirsti64':( 'int', None, 'cdecl', 'msvcr71._wfindfirsti64', (('int', None), ('int', None)) ),
    'msvcr71._wfindnext':( 'int', None, 'cdecl', 'msvcr71._wfindnext', (('int', None), ('int', None)) ),
    'msvcr71._wfindnext64':( 'int', None, 'cdecl', 'msvcr71._wfindnext64', (('int', None), ('int', None)) ),
    'msvcr71._wfindnexti64':( 'int', None, 'cdecl', 'msvcr71._wfindnexti64', (('int', None), ('int', None)) ),
    'msvcr71._wfopen':( 'int', None, 'cdecl', 'msvcr71._wfopen', (('StringW', None), ('int', None)) ),
    'msvcr71._wfreopen':( 'int', None, 'cdecl', 'msvcr71._wfreopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcr71._wfsopen':( 'int', None, 'cdecl', 'msvcr71._wfsopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcr71._wfullpath':( 'int', None, 'cdecl', 'msvcr71._wfullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71._wgetcwd':( 'int', None, 'cdecl', 'msvcr71._wgetcwd', (('int', None), ('int', None)) ),
    'msvcr71._wgetdcwd':( 'int', None, 'cdecl', 'msvcr71._wgetdcwd', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wgetenv':( 'int', None, 'cdecl', 'msvcr71._wgetenv', (('int', None),) ),
    'msvcr71._winmajor':( 'int', None, 'cdecl', 'msvcr71._winmajor', () ),
    'msvcr71._winminor':( 'int', None, 'cdecl', 'msvcr71._winminor', () ),
    'msvcr71._winver':( 'int', None, 'cdecl', 'msvcr71._winver', () ),
    'msvcr71._wmakepath':( 'int', None, 'cdecl', 'msvcr71._wmakepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wmkdir':( 'int', None, 'cdecl', 'msvcr71._wmkdir', (('StringW', None),) ),
    'msvcr71._wmktemp':( 'int', None, 'cdecl', 'msvcr71._wmktemp', (('void *', 'ptr'),) ),
    'msvcr71._wopen':( 'int', None, 'cdecl', 'msvcr71._wopen', (('StringW', None), ('int', None), ('int', None)) ),
    'msvcr71._wperror':( 'int', None, 'cdecl', 'msvcr71._wperror', (('void *', 'ptr'),) ),
    'msvcr71._wpgmptr':( 'int', None, 'cdecl', 'msvcr71._wpgmptr', () ),
    'msvcr71._wpopen':( 'int', None, 'cdecl', 'msvcr71._wpopen', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71._wputenv':( 'int', None, 'cdecl', 'msvcr71._wputenv', (('void *', 'ptr'),) ),
    'msvcr71._wremove':( 'int', None, 'cdecl', 'msvcr71._wremove', (('int', None),) ),
    'msvcr71._wrename':( 'int', None, 'cdecl', 'msvcr71._wrename', (('int', None), ('int', None)) ),
    'msvcr71._write':( 'int', None, 'cdecl', 'msvcr71._write', (('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'msvcr71._wrmdir':( 'int', None, 'cdecl', 'msvcr71._wrmdir', (('int', None),) ),
    'msvcr71._wsearchenv':( 'int', None, 'cdecl', 'msvcr71._wsearchenv', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'msvcr71._wsetlocale':( 'int', None, 'cdecl', 'msvcr71._wsetlocale', (('int', None), ('void *', 'ptr')) ),
    'msvcr71._wsopen':( 'int', None, 'cdecl', 'msvcr71._wsopen', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wspawnl':( 'int', None, 'cdecl', 'msvcr71._wspawnl', (('int', None), ('void *', 'obj')) ),
    'msvcr71._wspawnle':( 'int', None, 'cdecl', 'msvcr71._wspawnle', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcr71._wspawnlp':( 'int', None, 'cdecl', 'msvcr71._wspawnlp', (('int', None), ('void *', 'obj')) ),
    'msvcr71._wspawnlpe':( 'int', None, 'cdecl', 'msvcr71._wspawnlpe', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'msvcr71._wspawnv':( 'int', None, 'cdecl', 'msvcr71._wspawnv', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'msvcr71._wspawnve':( 'int', None, 'cdecl', 'msvcr71._wspawnve', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._wspawnvp':( 'int', None, 'cdecl', 'msvcr71._wspawnvp', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'msvcr71._wspawnvpe':( 'int', None, 'cdecl', 'msvcr71._wspawnvpe', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71._wsplitpath':( 'int', None, 'cdecl', 'msvcr71._wsplitpath', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71._wstat':( 'int', None, 'cdecl', 'msvcr71._wstat', (('int', None), ('int', None)) ),
    'msvcr71._wstat64':( 'int', None, 'cdecl', 'msvcr71._wstat64', (('int', None), ('int', None)) ),
    'msvcr71._wstati64':( 'int', None, 'cdecl', 'msvcr71._wstati64', (('int', None), ('int', None)) ),
    'msvcr71._wstrdate':( 'int', None, 'cdecl', 'msvcr71._wstrdate', (('int', None),) ),
    'msvcr71._wstrtime':( 'int', None, 'cdecl', 'msvcr71._wstrtime', (('int', None),) ),
    'msvcr71._wsystem':( 'int', None, 'cdecl', 'msvcr71._wsystem', (('int', None),) ),
    'msvcr71._wtempnam':( 'int', None, 'cdecl', 'msvcr71._wtempnam', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71._wtmpnam':( 'int', None, 'cdecl', 'msvcr71._wtmpnam', (('int', None),) ),
    'msvcr71._wtof':( 'int', None, 'cdecl', 'msvcr71._wtof', (('void *', 'ptr'),) ),
    'msvcr71._wtoi':( 'int', None, 'cdecl', 'msvcr71._wtoi', (('int', None),) ),
    'msvcr71._wtoi64':( 'int', None, 'cdecl', 'msvcr71._wtoi64', (('int', None),) ),
    'msvcr71._wtol':( 'int', None, 'cdecl', 'msvcr71._wtol', (('int', None),) ),
    'msvcr71._wunlink':( 'int', None, 'cdecl', 'msvcr71._wunlink', (('int', None),) ),
    'msvcr71._wutime':( 'int', None, 'cdecl', 'msvcr71._wutime', (('StringW', None), ('void *', 'ptr')) ),
    'msvcr71._wutime64':( 'int', None, 'cdecl', 'msvcr71._wutime64', (('StringW', None), ('void *', 'ptr')) ),
    'msvcr71._y0':( 'int', None, 'cdecl', 'msvcr71._y0', () ),
    'msvcr71._y1':( 'int', None, 'cdecl', 'msvcr71._y1', () ),
    'msvcr71._yn':( 'int', None, 'cdecl', 'msvcr71._yn', () ),
    'msvcr71.abort':( 'int', None, 'stdcall', 'msvcr71.abort', (('int', None),) ),
    'msvcr71.abs':( 'int', None, 'cdecl', 'msvcr71.abs', (('int', None),) ),
    'msvcr71.acos':( 'int', None, 'cdecl', 'msvcr71.acos', () ),
    'msvcr71.asctime':( 'int', None, 'cdecl', 'msvcr71.asctime', (('int', None),) ),
    'msvcr71.asin':( 'int', None, 'cdecl', 'msvcr71.asin', () ),
    'msvcr71.atan':( 'int', None, 'cdecl', 'msvcr71.atan', () ),
    'msvcr71.atan2':( 'int', None, 'cdecl', 'msvcr71.atan2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.atexit':( 'int', None, 'cdecl', 'msvcr71.atexit', (('int', None),) ),
    'msvcr71.atof':( 'int', None, 'cdecl', 'msvcr71.atof', (('void *', 'ptr'),) ),
    'msvcr71.atoi':( 'int', None, 'cdecl', 'msvcr71.atoi', (('int', None),) ),
    'msvcr71.atol':( 'int', None, 'cdecl', 'msvcr71.atol', (('void *', 'ptr'),) ),
    'msvcr71.bsearch':( 'int', None, 'cdecl', 'msvcr71.bsearch', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'msvcr71.calloc':( 'int', None, 'cdecl', 'msvcr71.calloc', (('int', None), ('int', None)) ),
    'msvcr71.ceil':( 'int', None, 'cdecl', 'msvcr71.ceil', () ),
    'msvcr71.clearerr':( 'int', None, 'cdecl', 'msvcr71.clearerr', (('int', None),) ),
    'msvcr71.clock':( 'int', None, 'msfastcall', 'msvcr71.clock', (('int', None), ('int', None)) ),
    'msvcr71.cos':( 'int', None, 'cdecl', 'msvcr71.cos', () ),
    'msvcr71.cosh':( 'int', None, 'cdecl', 'msvcr71.cosh', (('int', None), ('int', None)) ),
    'msvcr71.ctime':( 'int', None, 'cdecl', 'msvcr71.ctime', (('void *', 'ptr'),) ),
    'msvcr71.difftime':( 'int', None, 'cdecl', 'msvcr71.difftime', (('int', None), ('int', None)) ),
    'msvcr71.div':( 'int', None, 'cdecl', 'msvcr71.div', (('int', None), ('int', None)) ),
    'msvcr71.exit':( 'int', None, 'cdecl', 'msvcr71.exit', (('int', None),) ),
    'msvcr71.exp':( 'int', None, 'cdecl', 'msvcr71.exp', (('int', None), ('int', None)) ),
    'msvcr71.fabs':( 'int', None, 'cdecl', 'msvcr71.fabs', (('int', None), ('int', None)) ),
    'msvcr71.fclose':( 'int', None, 'cdecl', 'msvcr71.fclose', (('int', None),) ),
    'msvcr71.feof':( 'int', None, 'cdecl', 'msvcr71.feof', (('int', None),) ),
    'msvcr71.ferror':( 'int', None, 'cdecl', 'msvcr71.ferror', (('int', None),) ),
    'msvcr71.fflush':( 'int', None, 'cdecl', 'msvcr71.fflush', (('int', None),) ),
    'msvcr71.fgetc':( 'int', None, 'cdecl', 'msvcr71.fgetc', (('int', None),) ),
    'msvcr71.fgetpos':( 'int', None, 'cdecl', 'msvcr71.fgetpos', (('int', None), ('int', None)) ),
    'msvcr71.fgets':( 'int', None, 'cdecl', 'msvcr71.fgets', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.fgetwc':( 'int', None, 'cdecl', 'msvcr71.fgetwc', (('int', None),) ),
    'msvcr71.fgetws':( 'int', None, 'cdecl', 'msvcr71.fgetws', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.floor':( 'int', None, 'cdecl', 'msvcr71.floor', () ),
    'msvcr71.fmod':( 'int', None, 'cdecl', 'msvcr71.fmod', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.fopen':( 'int', None, 'cdecl', 'msvcr71.fopen', (('StringA', None), ('int', None)) ),
    'msvcr71.fprintf':( 'int', None, 'cdecl', 'msvcr71.fprintf', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.fputc':( 'int', None, 'cdecl', 'msvcr71.fputc', (('int', None), ('void *', 'ptr')) ),
    'msvcr71.fputs':( 'int', None, 'cdecl', 'msvcr71.fputs', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.fputwc':( 'int', None, 'cdecl', 'msvcr71.fputwc', (('int', None), ('int', None)) ),
    'msvcr71.fputws':( 'int', None, 'cdecl', 'msvcr71.fputws', (('int', None), ('int', None)) ),
    'msvcr71.fread':( 'int', None, 'cdecl', 'msvcr71.fread', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.free':( 'int', None, 'cdecl', 'msvcr71.free', (('void *', 'ptr'),) ),
    'msvcr71.freopen':( 'int', None, 'cdecl', 'msvcr71.freopen', (('StringA', None), ('int', None), ('int', None)) ),
    'msvcr71.frexp':( 'int', None, 'cdecl', 'msvcr71.frexp', () ),
    'msvcr71.fscanf':( 'int', None, 'cdecl', 'msvcr71.fscanf', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.fseek':( 'int', None, 'cdecl', 'msvcr71.fseek', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.fsetpos':( 'int', None, 'cdecl', 'msvcr71.fsetpos', (('int', None), ('int', None)) ),
    'msvcr71.ftell':( 'int', None, 'cdecl', 'msvcr71.ftell', (('int', None),) ),
    'msvcr71.fwprintf':( 'int', None, 'cdecl', 'msvcr71.fwprintf', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.fwrite':( 'int', None, 'cdecl', 'msvcr71.fwrite', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.fwscanf':( 'int', None, 'cdecl', 'msvcr71.fwscanf', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.getc':( 'int', None, 'cdecl', 'msvcr71.getc', (('int', None),) ),
    'msvcr71.getchar':( 'int', None, 'cdecl', 'msvcr71.getchar', () ),
    'msvcr71.getenv':( 'int', None, 'cdecl', 'msvcr71.getenv', (('void *', 'ptr'),) ),
    'msvcr71.gets':( 'int', None, 'cdecl', 'msvcr71.gets', (('int', None),) ),
    'msvcr71.getwc':( 'int', None, 'cdecl', 'msvcr71.getwc', (('int', None),) ),
    'msvcr71.getwchar':( 'int', None, 'cdecl', 'msvcr71.getwchar', () ),
    'msvcr71.gmtime':( 'int', None, 'cdecl', 'msvcr71.gmtime', (('void *', 'ptr'),) ),
    'msvcr71.is_wctype':( 'int', None, 'cdecl', 'msvcr71.is_wctype', (('int', None), ('int', None)) ),
    'msvcr71.isalnum':( 'int', None, 'cdecl', 'msvcr71.isalnum', (('int', None),) ),
    'msvcr71.isalpha':( 'int', None, 'cdecl', 'msvcr71.isalpha', (('int', None),) ),
    'msvcr71.iscntrl':( 'int', None, 'cdecl', 'msvcr71.iscntrl', (('int', None),) ),
    'msvcr71.isdigit':( 'int', None, 'cdecl', 'msvcr71.isdigit', (('int', None),) ),
    'msvcr71.isgraph':( 'int', None, 'cdecl', 'msvcr71.isgraph', (('int', None),) ),
    'msvcr71.isleadbyte':( 'int', None, 'cdecl', 'msvcr71.isleadbyte', (('int', None),) ),
    'msvcr71.islower':( 'int', None, 'cdecl', 'msvcr71.islower', (('int', None),) ),
    'msvcr71.isprint':( 'int', None, 'cdecl', 'msvcr71.isprint', (('int', None),) ),
    'msvcr71.ispunct':( 'int', None, 'cdecl', 'msvcr71.ispunct', (('int', None),) ),
    'msvcr71.isspace':( 'int', None, 'cdecl', 'msvcr71.isspace', (('int', None),) ),
    'msvcr71.isupper':( 'int', None, 'cdecl', 'msvcr71.isupper', (('int', None),) ),
    'msvcr71.iswalnum':( 'int', None, 'cdecl', 'msvcr71.iswalnum', (('int', None),) ),
    'msvcr71.iswalpha':( 'int', None, 'cdecl', 'msvcr71.iswalpha', (('int', None),) ),
    'msvcr71.iswascii':( 'int', None, 'cdecl', 'msvcr71.iswascii', (('int', None),) ),
    'msvcr71.iswcntrl':( 'int', None, 'cdecl', 'msvcr71.iswcntrl', (('int', None),) ),
    'msvcr71.iswctype':( 'int', None, 'cdecl', 'msvcr71.iswctype', (('int', None), ('int', None)) ),
    'msvcr71.iswdigit':( 'int', None, 'cdecl', 'msvcr71.iswdigit', (('int', None),) ),
    'msvcr71.iswgraph':( 'int', None, 'cdecl', 'msvcr71.iswgraph', (('int', None),) ),
    'msvcr71.iswlower':( 'int', None, 'cdecl', 'msvcr71.iswlower', (('int', None),) ),
    'msvcr71.iswprint':( 'int', None, 'cdecl', 'msvcr71.iswprint', (('int', None),) ),
    'msvcr71.iswpunct':( 'int', None, 'cdecl', 'msvcr71.iswpunct', (('int', None),) ),
    'msvcr71.iswspace':( 'int', None, 'cdecl', 'msvcr71.iswspace', (('int', None),) ),
    'msvcr71.iswupper':( 'int', None, 'cdecl', 'msvcr71.iswupper', (('int', None),) ),
    'msvcr71.iswxdigit':( 'int', None, 'cdecl', 'msvcr71.iswxdigit', (('int', None),) ),
    'msvcr71.isxdigit':( 'int', None, 'cdecl', 'msvcr71.isxdigit', (('int', None),) ),
    'msvcr71.labs':( 'int', None, 'cdecl', 'msvcr71.labs', (('int', None),) ),
    'msvcr71.ldexp':( 'int', None, 'cdecl', 'msvcr71.ldexp', (('int', None), ('int', None)) ),
    'msvcr71.ldiv':( 'int', None, 'cdecl', 'msvcr71.ldiv', (('int', None), ('int', None)) ),
    'msvcr71.localeconv':( 'int', None, 'cdecl', 'msvcr71.localeconv', () ),
    'msvcr71.localtime':( 'int', None, 'cdecl', 'msvcr71.localtime', (('void *', 'ptr'),) ),
    'msvcr71.log':( 'int', None, 'cdecl', 'msvcr71.log', () ),
    'msvcr71.log10':( 'int', None, 'cdecl', 'msvcr71.log10', () ),
    'msvcr71.longjmp':( 'int', None, 'cdecl', 'msvcr71.longjmp', (('int', None), ('int', None)) ),
    'msvcr71.malloc':( 'int', None, 'cdecl', 'msvcr71.malloc', (('DWORD', None),) ),
    'msvcr71.mblen':( 'int', None, 'cdecl', 'msvcr71.mblen', (('int', None), ('int', None)) ),
    'msvcr71.mbstowcs':( 'int', None, 'cdecl', 'msvcr71.mbstowcs', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.mbtowc':( 'int', None, 'cdecl', 'msvcr71.mbtowc', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.memchr':( 'int', None, 'cdecl', 'msvcr71.memchr', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.memcmp':( 'int', None, 'cdecl', 'msvcr71.memcmp', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.memcpy':( 'int', None, 'cdecl', 'msvcr71.memcpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.memmove':( 'int', None, 'cdecl', 'msvcr71.memmove', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.memset':( 'int', None, 'cdecl', 'msvcr71.memset', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.mktime':( 'int', None, 'cdecl', 'msvcr71.mktime', (('int', None),) ),
    'msvcr71.modf':( 'int', None, 'cdecl', 'msvcr71.modf', (('int', None), ('int', None)) ),
    'msvcr71.perror':( 'int', None, 'cdecl', 'msvcr71.perror', (('void *', 'ptr'),) ),
    'msvcr71.pow':( 'int', None, 'cdecl', 'msvcr71.pow', () ),
    'msvcr71.printf':( 'int', None, 'cdecl', 'msvcr71.printf', (('int', None),) ),
    'msvcr71.putc':( 'int', None, 'cdecl', 'msvcr71.putc', (('int', None), ('void *', 'ptr')) ),
    'msvcr71.putchar':( 'int', None, 'cdecl', 'msvcr71.putchar', (('int', None),) ),
    'msvcr71.puts':( 'int', None, 'cdecl', 'msvcr71.puts', (('void *', 'ptr'),) ),
    'msvcr71.putwc':( 'int', None, 'cdecl', 'msvcr71.putwc', (('int', None), ('int', None)) ),
    'msvcr71.putwchar':( 'int', None, 'cdecl', 'msvcr71.putwchar', (('int', None),) ),
    'msvcr71.qsort':( 'int', None, 'stdcall', 'msvcr71.qsort', ( ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.raise':( 'int', None, 'cdecl', 'msvcr71.raise', (('int', None),) ),
    'msvcr71.rand':( 'int', None, 'cdecl', 'msvcr71.rand', () ),
    'msvcr71.realloc':( 'int', None, 'cdecl', 'msvcr71.realloc', (('void *', 'ptr'), ('DWORD', None)) ),
    'msvcr71.remove':( 'int', None, 'cdecl', 'msvcr71.remove', (('int', None),) ),
    'msvcr71.rename':( 'int', None, 'cdecl', 'msvcr71.rename', (('int', None), ('int', None)) ),
    'msvcr71.rewind':( 'int', None, 'cdecl', 'msvcr71.rewind', (('int', None),) ),
    'msvcr71.scanf':( 'int', None, 'cdecl', 'msvcr71.scanf', (('int', None),) ),
    'msvcr71.setbuf':( 'int', None, 'cdecl', 'msvcr71.setbuf', (('int', None), ('int', None)) ),
    'msvcr71.setlocale':( 'int', None, 'cdecl', 'msvcr71.setlocale', (('int', None), ('void *', 'obj')) ),
    'msvcr71.setvbuf':( 'int', None, 'cdecl', 'msvcr71.setvbuf', (('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'msvcr71.signal':( 'int', None, 'cdecl', 'msvcr71.signal', (('int', None), ('int', None)) ),
    'msvcr71.sin':( 'int', None, 'cdecl', 'msvcr71.sin', () ),
    'msvcr71.sinh':( 'int', None, 'cdecl', 'msvcr71.sinh', (('int', None), ('int', None)) ),
    'msvcr71.sprintf':( 'int', None, 'cdecl', 'msvcr71.sprintf', (('int', None), ('int', None)) ),
    'msvcr71.sqrt':( 'int', None, 'cdecl', 'msvcr71.sqrt', () ),
    'msvcr71.srand':( 'int', None, 'cdecl', 'msvcr71.srand', (('int', None),) ),
    'msvcr71.sscanf':( 'int', None, 'cdecl', 'msvcr71.sscanf', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.strcat':( 'int', None, 'cdecl', 'msvcr71.strcat', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71.strchr':( 'int', None, 'cdecl', 'msvcr71.strchr', (('int', None), ('int', None)) ),
    'msvcr71.strcmp':( 'int', None, 'cdecl', 'msvcr71.strcmp', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.strcoll':( 'int', None, 'cdecl', 'msvcr71.strcoll', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71.strcpy':( 'int', None, 'cdecl', 'msvcr71.strcpy', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'msvcr71.strcspn':( 'int', None, 'cdecl', 'msvcr71.strcspn', (('int', None), ('int', None)) ),
    'msvcr71.strerror':( 'int', None, 'cdecl', 'msvcr71.strerror', (('int', None),) ),
    'msvcr71.strftime':( 'int', None, 'cdecl', 'msvcr71.strftime', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.strlen':( 'int', None, 'cdecl', 'msvcr71.strlen', (('void *', 'ptr'),) ),
    'msvcr71.strncat':( 'int', None, 'cdecl', 'msvcr71.strncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.strncmp':( 'int', None, 'cdecl', 'msvcr71.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.strncpy':( 'int', None, 'cdecl', 'msvcr71.strncpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.strpbrk':( 'int', None, 'cdecl', 'msvcr71.strpbrk', (('int', None), ('int', None)) ),
    'msvcr71.strrchr':( 'int', None, 'cdecl', 'msvcr71.strrchr', (('int', None), ('int', None)) ),
    'msvcr71.strspn':( 'int', None, 'cdecl', 'msvcr71.strspn', (('int', None), ('int', None)) ),
    'msvcr71.strstr':( 'int', None, 'cdecl', 'msvcr71.strstr', (('int', None), ('void *', 'ptr')) ),
    'msvcr71.strtod':( 'int', None, 'cdecl', 'msvcr71.strtod', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.strtok':( 'int', None, 'cdecl', 'msvcr71.strtok', (('int', None), ('int', None)) ),
    'msvcr71.strtol':( 'int', None, 'cdecl', 'msvcr71.strtol', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.strtoul':( 'int', None, 'cdecl', 'msvcr71.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.strxfrm':( 'int', None, 'cdecl', 'msvcr71.strxfrm', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.swprintf':( 'int', None, 'cdecl', 'msvcr71.swprintf', (('int', None), ('int', None)) ),
    'msvcr71.swscanf':( 'int', None, 'cdecl', 'msvcr71.swscanf', (('int', None), ('int', None)) ),
    'msvcr71.system':( 'int', None, 'cdecl', 'msvcr71.system', (('int', None),) ),
    'msvcr71.tan':( 'int', None, 'cdecl', 'msvcr71.tan', () ),
    'msvcr71.tanh':( 'int', None, 'cdecl', 'msvcr71.tanh', (('int', None), ('int', None)) ),
    'msvcr71.time':( 'int', None, 'cdecl', 'msvcr71.time', (('void *', 'ptr'),) ),
    'msvcr71.tmpfile':( 'int', None, 'cdecl', 'msvcr71.tmpfile', () ),
    'msvcr71.tmpnam':( 'int', None, 'cdecl', 'msvcr71.tmpnam', (('void *', 'ptr'),) ),
    'msvcr71.tolower':( 'int', None, 'cdecl', 'msvcr71.tolower', (('int', None),) ),
    'msvcr71.toupper':( 'int', None, 'cdecl', 'msvcr71.toupper', (('int', None),) ),
    'msvcr71.towlower':( 'int', None, 'cdecl', 'msvcr71.towlower', (('int', None),) ),
    'msvcr71.towupper':( 'int', None, 'cdecl', 'msvcr71.towupper', (('int', None),) ),
    'msvcr71.ungetc':( 'int', None, 'cdecl', 'msvcr71.ungetc', (('int', None), ('int', None)) ),
    'msvcr71.ungetwc':( 'int', None, 'cdecl', 'msvcr71.ungetwc', (('int', None), ('int', None)) ),
    'msvcr71.vfprintf':( 'int', None, 'cdecl', 'msvcr71.vfprintf', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.vfwprintf':( 'int', None, 'cdecl', 'msvcr71.vfwprintf', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.vprintf':( 'int', None, 'cdecl', 'msvcr71.vprintf', (('int', None), ('int', None)) ),
    'msvcr71.vsprintf':( 'int', None, 'cdecl', 'msvcr71.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.vswprintf':( 'int', None, 'cdecl', 'msvcr71.vswprintf', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.vwprintf':( 'int', None, 'cdecl', 'msvcr71.vwprintf', (('int', None), ('int', None)) ),
    'msvcr71.wcscat':( 'int', None, 'cdecl', 'msvcr71.wcscat', (('int', None), ('int', None)) ),
    'msvcr71.wcschr':( 'int', None, 'cdecl', 'msvcr71.wcschr', (('int', None), ('int', None)) ),
    'msvcr71.wcscmp':( 'int', None, 'cdecl', 'msvcr71.wcscmp', (('int', None), ('int', None)) ),
    'msvcr71.wcscoll':( 'int', None, 'cdecl', 'msvcr71.wcscoll', (('int', None), ('int', None)) ),
    'msvcr71.wcscpy':( 'int', None, 'cdecl', 'msvcr71.wcscpy', (('int', None), ('void *', 'ptr')) ),
    'msvcr71.wcscspn':( 'int', None, 'cdecl', 'msvcr71.wcscspn', (('int', None), ('int', None)) ),
    'msvcr71.wcsftime':( 'int', None, 'cdecl', 'msvcr71.wcsftime', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcslen':( 'int', None, 'cdecl', 'msvcr71.wcslen', (('void *', 'ptr'),) ),
    'msvcr71.wcsncat':( 'int', None, 'cdecl', 'msvcr71.wcsncat', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcsncmp':( 'int', None, 'cdecl', 'msvcr71.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcsncpy':( 'int', None, 'cdecl', 'msvcr71.wcsncpy', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcspbrk':( 'int', None, 'cdecl', 'msvcr71.wcspbrk', (('int', None), ('int', None)) ),
    'msvcr71.wcsrchr':( 'int', None, 'cdecl', 'msvcr71.wcsrchr', (('int', None), ('int', None)) ),
    'msvcr71.wcsspn':( 'int', None, 'cdecl', 'msvcr71.wcsspn', (('int', None), ('int', None)) ),
    'msvcr71.wcsstr':( 'int', None, 'cdecl', 'msvcr71.wcsstr', (('int', None), ('int', None)) ),
    'msvcr71.wcstod':( 'int', None, 'cdecl', 'msvcr71.wcstod', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.wcstok':( 'int', None, 'cdecl', 'msvcr71.wcstok', (('int', None), ('int', None)) ),
    'msvcr71.wcstol':( 'int', None, 'cdecl', 'msvcr71.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcstombs':( 'int', None, 'cdecl', 'msvcr71.wcstombs', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'msvcr71.wcstoul':( 'int', None, 'cdecl', 'msvcr71.wcstoul', (('int', None), ('int', None), ('int', None)) ),
    'msvcr71.wcsxfrm':( 'int', None, 'cdecl', 'msvcr71.wcsxfrm', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'msvcr71.wctomb':( 'int', None, 'cdecl', 'msvcr71.wctomb', (('void *', 'ptr'), ('int', None)) ),
    'msvcr71.wprintf':( 'int', None, 'cdecl', 'msvcr71.wprintf', (('int', None),) ),
    'msvcr71.wscanf':( 'int', None, 'cdecl', 'msvcr71.wscanf', (('int', None),) ),

    # WS2_32
    'ws2_32.main_entry':( 'int', None, 'stdcall', 'ws2_32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.freeaddrinfow':( 'int', None, 'stdcall', 'ws2_32.FreeAddrInfoW', (('void *', 'ptr'),) ),
    'ws2_32.getaddrinfow':( 'int', None, 'stdcall', 'ws2_32.GetAddrInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.getnameinfow':( 'int', None, 'stdcall', 'ws2_32.GetNameInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wep':( 'int', None, 'cdecl', 'ws2_32.WEP', () ),
    'ws2_32.wpucompleteoverlappedrequest':( 'int', None, 'stdcall', 'ws2_32.WPUCompleteOverlappedRequest', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaccept':( 'int', None, 'stdcall', 'ws2_32.WSAAccept', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaddresstostringa':( 'int', None, 'stdcall', 'ws2_32.WSAAddressToStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaddresstostringw':( 'int', None, 'stdcall', 'ws2_32.WSAAddressToStringW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgethostbyaddr':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByAddr', (('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgethostbyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetprotobyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetprotobynumber':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByNumber', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetservbyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetservbyport':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncselect':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncSelect', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsacancelasyncrequest':( 'int', None, 'stdcall', 'ws2_32.WSACancelAsyncRequest', (('int', None),) ),
    'ws2_32.wsacancelblockingcall':( 'int', None, 'stdcall', 'ws2_32.WSACancelBlockingCall', () ),
    'ws2_32.wsacleanup':( 'int', None, 'stdcall', 'ws2_32.WSACleanup', () ),
    'ws2_32.wsacloseevent':( 'int', None, 'stdcall', 'ws2_32.WSACloseEvent', (('HANDLE', None),) ),
    'ws2_32.wsaconnect':( 'int', None, 'stdcall', 'ws2_32.WSAConnect', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsacreateevent':( 'int', None, 'cdecl', 'ws2_32.WSACreateEvent', () ),
    'ws2_32.wsaduplicatesocketa':( 'int', None, 'stdcall', 'ws2_32.WSADuplicateSocketA', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaduplicatesocketw':( 'int', None, 'stdcall', 'ws2_32.WSADuplicateSocketW', ( ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsaenumnamespaceprovidersa':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNameSpaceProvidersA', (('int', None), ('int', None)) ),
    'ws2_32.wsaenumnamespaceprovidersw':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNameSpaceProvidersW', (('int', None), ('int', None)) ),
    'ws2_32.wsaenumnetworkevents':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNetworkEvents', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaenumprotocolsa':( 'int', None, 'stdcall', 'ws2_32.WSAEnumProtocolsA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaenumprotocolsw':( 'int', None, 'stdcall', 'ws2_32.WSAEnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsaeventselect':( 'int', None, 'stdcall', 'ws2_32.WSAEventSelect', ( ('int', None), ('int', None)) ),
    'ws2_32.wsagetlasterror':( 'int', None, 'stdcall', 'ws2_32.WSAGetLastError', () ),
    'ws2_32.wsagetoverlappedresult':( 'int', None, 'stdcall', 'ws2_32.WSAGetOverlappedResult', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetqosbyname':( 'int', None, 'stdcall', 'ws2_32.WSAGetQOSByName', ( ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassinfoa':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassinfow':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassnamebyclassida':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassNameByClassIdA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassnamebyclassidw':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassNameByClassIdW', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsahtonl':( 'int', None, 'stdcall', 'ws2_32.WSAHtonl', ( ('int', None), ('int', None)) ),
    'ws2_32.wsahtons':( 'int', None, 'stdcall', 'ws2_32.WSAHtons', ( ('int', None), ('int', None)) ),
    'ws2_32.wsainstallserviceclassa':( 'int', None, 'stdcall', 'ws2_32.WSAInstallServiceClassA', (('int', None),) ),
    'ws2_32.wsainstallserviceclassw':( 'int', None, 'stdcall', 'ws2_32.WSAInstallServiceClassW', (('int', None),) ),
    'ws2_32.wsaioctl':( 'int', None, 'stdcall', 'ws2_32.WSAIoctl', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ws2_32.wsaisblocking':( 'int', None, 'stdcall', 'ws2_32.WSAIsBlocking', () ),
    'ws2_32.wsajoinleaf':( 'int', None, 'stdcall', 'ws2_32.WSAJoinLeaf', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsalookupservicebegina':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceBeginA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsalookupservicebeginw':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceBeginW', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsalookupserviceend':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceEnd', () ),
    'ws2_32.wsalookupservicenexta':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceNextA', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsalookupservicenextw':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceNextW', ( ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ws2_32.wsanspioctl':( 'int', None, 'stdcall', 'ws2_32.WSANSPIoctl', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsantohl':( 'int', None, 'stdcall', 'ws2_32.WSANtohl', ( ('int', None), ('int', None)) ),
    'ws2_32.wsantohs':( 'int', None, 'stdcall', 'ws2_32.WSANtohs', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaproviderconfigchange':( 'int', None, 'stdcall', 'ws2_32.WSAProviderConfigChange', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsarecv':( 'int', None, 'stdcall', 'ws2_32.WSARecv', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsarecvdisconnect':( 'int', None, 'stdcall', 'ws2_32.WSARecvDisconnect', ( ('int', None),) ),
    'ws2_32.wsarecvfrom':( 'int', None, 'stdcall', 'ws2_32.WSARecvFrom', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaremoveserviceclass':( 'int', None, 'stdcall', 'ws2_32.WSARemoveServiceClass', (('int', None),) ),
    'ws2_32.wsaresetevent':( 'int', None, 'cdecl', 'ws2_32.WSAResetEvent', () ),
    'ws2_32.wsasend':( 'int', None, 'stdcall', 'ws2_32.WSASend', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasenddisconnect':( 'int', None, 'stdcall', 'ws2_32.WSASendDisconnect', ( ('int', None),) ),
    'ws2_32.wsasendto':( 'int', None, 'stdcall', 'ws2_32.WSASendTo', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasetblockinghook':( 'int', None, 'stdcall', 'ws2_32.WSASetBlockingHook', ( ('int', None),) ),
    'ws2_32.wsasetevent':( 'int', None, 'cdecl', 'ws2_32.WSASetEvent', () ),
    'ws2_32.wsasetlasterror':( 'int', None, 'cdecl', 'ws2_32.WSASetLastError', () ),
    'ws2_32.wsasetservicea':( 'int', None, 'stdcall', 'ws2_32.WSASetServiceA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasetservicew':( 'int', None, 'stdcall', 'ws2_32.WSASetServiceW', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasocketa':( 'int', None, 'stdcall', 'ws2_32.WSASocketA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasocketw':( 'int', None, 'stdcall', 'ws2_32.WSASocketW', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ws2_32.wsastartup':( 'int', None, 'stdcall', 'ws2_32.WSAStartup', (('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsastringtoaddressa':( 'int', None, 'stdcall', 'ws2_32.WSAStringToAddressA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsastringtoaddressw':( 'int', None, 'stdcall', 'ws2_32.WSAStringToAddressW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ws2_32.wsaunhookblockinghook':( 'int', None, 'stdcall', 'ws2_32.WSAUnhookBlockingHook', () ),
    'ws2_32.wsawaitformultipleevents':( 'int', None, 'cdecl', 'ws2_32.WSAWaitForMultipleEvents', () ),
    'ws2_32.wsapsetpostroutine':( 'int', None, 'stdcall', 'ws2_32.WSApSetPostRoutine', (('int', None),) ),
    'ws2_32.wscdeinstallprovider':( 'int', None, 'stdcall', 'ws2_32.WSCDeinstallProvider', (('int', None), ('int', None)) ),
    'ws2_32.wscenablensprovider':( 'int', None, 'stdcall', 'ws2_32.WSCEnableNSProvider', (('int', None), ('int', None)) ),
    'ws2_32.wscenumprotocols':( 'int', None, 'stdcall', 'ws2_32.WSCEnumProtocols', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscgetproviderpath':( 'int', None, 'stdcall', 'ws2_32.WSCGetProviderPath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscinstallnamespace':( 'int', None, 'stdcall', 'ws2_32.WSCInstallNameSpace', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscinstallprovider':( 'int', None, 'stdcall', 'ws2_32.WSCInstallProvider', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscuninstallnamespace':( 'int', None, 'stdcall', 'ws2_32.WSCUnInstallNameSpace', (('int', None),) ),
    'ws2_32.wscupdateprovider':( 'int', None, 'stdcall', 'ws2_32.WSCUpdateProvider', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscwritenamespaceorder':( 'int', None, 'stdcall', 'ws2_32.WSCWriteNameSpaceOrder', (('int', None), ('int', None)) ),
    'ws2_32.wscwriteproviderorder':( 'int', None, 'stdcall', 'ws2_32.WSCWriteProviderOrder', (('int', None), ('int', None)) ),
    'ws2_32.__wsafdisset':( 'int', None, 'stdcall', 'ws2_32.__WSAFDIsSet', (('int', None), ('int', None)) ),
    'ws2_32.accept':( 'int', None, 'stdcall', 'ws2_32.accept', ( ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ws2_32.bind':( 'int', None, 'stdcall', 'ws2_32.bind', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.closesocket':( 'int', None, 'stdcall', 'ws2_32.closesocket', ( ('int', None), ) ),
    'ws2_32.connect':( 'int', None, 'stdcall', 'ws2_32.connect', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.freeaddrinfo':( 'int', None, 'stdcall', 'ws2_32.freeaddrinfo', (('void *', 'ptr'),) ),
    'ws2_32.getaddrinfo':( 'int', None, 'stdcall', 'ws2_32.getaddrinfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.gethostbyaddr':( 'int', None, 'stdcall', 'ws2_32.gethostbyaddr', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.gethostbyname':( 'int', None, 'stdcall', 'ws2_32.gethostbyname', ( ('void *', 'ptr'),) ),
    'ws2_32.gethostname':( 'int', None, 'stdcall', 'ws2_32.gethostname', ( ('void *', 'ptr'), ('int', None)) ),
    'ws2_32.getnameinfo':( 'int', None, 'stdcall', 'ws2_32.getnameinfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.getpeername':( 'int', None, 'stdcall', 'ws2_32.getpeername', ( ('int', None), ('int', None)) ),
    'ws2_32.getprotobyname':( 'int', None, 'stdcall', 'ws2_32.getprotobyname', (('int', None),) ),
    'ws2_32.getprotobynumber':( 'int', None, 'stdcall', 'ws2_32.getprotobynumber', ( ('int', None),) ),
    'ws2_32.getservbyname':( 'int', None, 'stdcall', 'ws2_32.getservbyname', (('void *', 'ptr'), ('int', None)) ),
    'ws2_32.getservbyport':( 'int', None, 'stdcall', 'ws2_32.getservbyport', (('int', None), ('int', None)) ),
    'ws2_32.getsockname':( 'int', None, 'stdcall', 'ws2_32.getsockname', ( ('int', None), ('int', None)) ),
    'ws2_32.getsockopt':( 'int', None, 'stdcall', 'ws2_32.getsockopt', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.htonl':( 'int', None, 'stdcall', 'ws2_32.htonl', (('int', None),) ),
    'ws2_32.htons':( 'int', None, 'stdcall', 'ws2_32.htons', (('int', None),) ),
    'ws2_32.inet_addr':( 'int', None, 'stdcall', 'ws2_32.inet_addr', (('int', None),) ),
    'ws2_32.inet_ntoa':( 'int', None, 'stdcall', 'ws2_32.inet_ntoa', ( ('int', None),) ),
    'ws2_32.ioctlsocket':( 'int', None, 'stdcall', 'ws2_32.ioctlsocket', ( ('int', None), ('int', None)) ),
    'ws2_32.listen':( 'int', None, 'stdcall', 'ws2_32.listen', ( ('int', None),) ),
    'ws2_32.ntohl':( 'int', None, 'stdcall', 'ws2_32.ntohl', (('int', None),) ),
    'ws2_32.ntohs':( 'int', None, 'stdcall', 'ws2_32.ntohs', (('int', None),) ),
    'ws2_32.recv':( 'int', None, 'stdcall', 'ws2_32.recv', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.recvfrom':( 'int', None, 'stdcall', 'ws2_32.recvfrom', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.select':( 'int', None, 'stdcall', 'ws2_32.select', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.send':( 'int', None, 'stdcall', 'ws2_32.send', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.sendto':( 'int', None, 'stdcall', 'ws2_32.sendto', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.setsockopt':( 'int', None, 'stdcall', 'ws2_32.setsockopt', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.shutdown':( 'int', None, 'stdcall', 'ws2_32.shutdown', ( ('int', None),) ),
    'ws2_32.socket':( 'int', None, 'stdcall', 'ws2_32.socket', ( ('int', None), ('int', None), ('void *', 'obj')) ),

    # MSWSOCK
    'mswsock.main_entry':( 'int', None, 'stdcall', 'mswsock.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.acceptex':( 'int', None, 'stdcall', 'mswsock.AcceptEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.enumprotocolsa':( 'int', None, 'stdcall', 'mswsock.EnumProtocolsA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.enumprotocolsw':( 'int', None, 'stdcall', 'mswsock.EnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.getacceptexsockaddrs':( 'int', None, 'stdcall', 'mswsock.GetAcceptExSockaddrs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getaddressbynamea':( 'int', None, 'stdcall', 'mswsock.GetAddressByNameA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getaddressbynamew':( 'int', None, 'stdcall', 'mswsock.GetAddressByNameW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.getnamebytypea':( 'int', None, 'stdcall', 'mswsock.GetNameByTypeA', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.getnamebytypew':( 'int', None, 'stdcall', 'mswsock.GetNameByTypeW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'mswsock.getservicea':( 'int', None, 'stdcall', 'mswsock.GetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getservicew':( 'int', None, 'stdcall', 'mswsock.GetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.gettypebynamea':( 'int', None, 'stdcall', 'mswsock.GetTypeByNameA', (('int', None), ('void *', 'ptr')) ),
    'mswsock.gettypebynamew':( 'int', None, 'stdcall', 'mswsock.GetTypeByNameW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'mswsock.migratewinsockconfiguration':( 'int', None, 'stdcall', 'mswsock.MigrateWinsockConfiguration', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'mswsock.nploadnamespaces':( 'int', None, 'stdcall', 'mswsock.NPLoadNameSpaces', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.nspstartup':( 'int', None, 'stdcall', 'mswsock.NSPStartup', (('int', None), ('int', None)) ),
    'mswsock.servicemain':( 'int', None, 'stdcall', 'mswsock.ServiceMain', (('int', None), ('int', None)) ),
    'mswsock.setservicea':( 'int', None, 'stdcall', 'mswsock.SetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.setservicew':( 'int', None, 'stdcall', 'mswsock.SetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.startwsdpservice':( 'int', None, 'cdecl', 'mswsock.StartWsdpService', () ),
    'mswsock.stopwsdpservice':( 'int', None, 'cdecl', 'mswsock.StopWsdpService', () ),
    'mswsock.svchostpushserviceglobals':( 'int', None, 'stdcall', 'mswsock.SvchostPushServiceGlobals', (('int', None),) ),
    'mswsock.transmitfile':( 'int', None, 'stdcall', 'mswsock.TransmitFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.wsarecvex':( 'int', None, 'stdcall', 'mswsock.WSARecvEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.wspstartup':( 'int', None, 'stdcall', 'mswsock.WSPStartup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.dn_expand':( 'int', None, 'stdcall', 'mswsock.dn_expand', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getnetbyname':( 'int', None, 'stdcall', 'mswsock.getnetbyname', (('int', None),) ),
    'mswsock.inet_network':( 'int', None, 'stdcall', 'mswsock.inet_network', (('int', None),) ),
    'mswsock.rcmd':( 'int', None, 'stdcall', 'mswsock.rcmd', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.rexec':( 'int', None, 'stdcall', 'mswsock.rexec', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.rresvport':( 'int', None, 'stdcall', 'mswsock.rresvport', (('void *', 'ptr'),) ),
    'mswsock.s_perror':( 'int', None, 'stdcall', 'mswsock.s_perror', (('void *', 'ptr'), ('int', None)) ),
    'mswsock.sethostname':( 'int', None, 'stdcall', 'mswsock.sethostname', (('int', None), ('int', None)) ),

    # WSOCK32
    'wsock32.main_entry':( 'int', None, 'stdcall', 'wsock32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'wsock32.getsockopt':( 'int', None, 'stdcall', 'wsock32.getsockopt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.recv':( 'int', None, 'stdcall', 'wsock32.recv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.recvfrom':( 'int', None, 'stdcall', 'wsock32.recvfrom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.setsockopt':( 'int', None, 'stdcall', 'wsock32.setsockopt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.acceptex':('int', None, 'stdcall', 'mswsock.AcceptEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.enumprotocolsa':('int', None, 'stdcall', 'mswsock.EnumProtocolsA', (('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.enumprotocolsw':('int', None, 'stdcall', 'mswsock.EnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.getacceptexsockaddrs':('int', None, 'stdcall', 'mswsock.GetAcceptExSockaddrs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getaddressbynamea':('int', None, 'stdcall', 'mswsock.GetAddressByNameA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getaddressbynamew':('int', None, 'stdcall', 'mswsock.GetAddressByNameW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.getnamebytypea':('int', None, 'stdcall', 'mswsock.GetNameByTypeA', (('int', None), ('int', None), ('int', None))),
    'wsock32.getnamebytypew':('int', None, 'stdcall', 'mswsock.GetNameByTypeW', (('int', None), ('void *', 'ptr'), ('int', None))),
    'wsock32.getservicea':('int', None, 'stdcall', 'mswsock.GetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getservicew':('int', None, 'stdcall', 'mswsock.GetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.gettypebynamea':('int', None, 'stdcall', 'mswsock.GetTypeByNameA', (('int', None), ('void *', 'ptr'))),
    'wsock32.gettypebynamew':('int', None, 'stdcall', 'mswsock.GetTypeByNameW', (('void *', 'ptr'), ('void *', 'ptr'))),
    'wsock32.migratewinsockconfiguration':('int', None, 'stdcall', 'mswsock.MigrateWinsockConfiguration', (('int', None), ('void *', 'funcptr'), ('int', None))),
    'wsock32.nploadnamespaces':('int', None, 'stdcall', 'mswsock.NPLoadNameSpaces', (('int', None), ('int', None), ('int', None))),
    'wsock32.setservicea':('int', None, 'stdcall', 'mswsock.SetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.setservicew':('int', None, 'stdcall', 'mswsock.SetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.transmitfile':('int', None, 'stdcall', 'mswsock.TransmitFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wep':('int', None, 'cdecl', 'ws2_32.WEP', ()),
    'wsock32.wsaasyncgethostbyaddr':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByAddr', (('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgethostbyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetprotobyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetprotobynumber':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByNumber', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetservbyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetservbyport':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncselect':('int', None, 'stdcall', 'ws2_32.WSAAsyncSelect', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.wsacancelasyncrequest':('int', None, 'stdcall', 'ws2_32.WSACancelAsyncRequest', (('int', None),)),
    'wsock32.wsacancelblockingcall':('int', None, 'stdcall', 'ws2_32.WSACancelBlockingCall', ()),
    'wsock32.wsacleanup':('int', None, 'stdcall', 'ws2_32.WSACleanup', ()),
    'wsock32.wsagetlasterror':('int', None, 'stdcall', 'ws2_32.WSAGetLastError', ()),
    'wsock32.wsaisblocking':('int', None, 'stdcall', 'ws2_32.WSAIsBlocking', ()),
    'wsock32.wsarecvex':('int', None, 'stdcall', 'mswsock.WSARecvEx', (('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsasetblockinghook':('int', None, 'stdcall', 'ws2_32.WSASetBlockingHook', ( ('int', None),)),
    'wsock32.wsasetlasterror':('int', None, 'cdecl', 'ws2_32.WSASetLastError', ()),
    'wsock32.wsastartup':('int', None, 'stdcall', 'ws2_32.WSAStartup', (('int', None), ('void *', 'ptr'))),
    'wsock32.wsaunhookblockinghook':('int', None, 'stdcall', 'ws2_32.WSAUnhookBlockingHook', ()),
    'wsock32.wsapsetpostroutine':('int', None, 'stdcall', 'ws2_32.WSApSetPostRoutine', (('int', None),)),
    'wsock32.__wsafdisset':('int', None, 'stdcall', 'ws2_32.__WSAFDIsSet', (('int', None), ('int', None))),
    'wsock32.accept':('int', None, 'stdcall', 'ws2_32.accept', ( ('void *', 'obj'), ('int', None), ('int', None))),
    'wsock32.bind':('int', None, 'stdcall', 'ws2_32.bind', ( ('int', None), ('int', None))),
    'wsock32.closesocket':('int', None, 'stdcall', 'ws2_32.closesocket', ()),
    'wsock32.connect':('int', None, 'stdcall', 'ws2_32.connect', ( ('int', None), ('int', None))),
    'wsock32.dn_expand':('int', None, 'stdcall', 'mswsock.dn_expand', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.gethostbyaddr':('int', None, 'stdcall', 'ws2_32.gethostbyaddr', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.gethostbyname':('int', None, 'stdcall', 'ws2_32.gethostbyname', ( ('void *', 'ptr'),)),
    'wsock32.gethostname':('int', None, 'stdcall', 'ws2_32.gethostname', ( ('void *', 'ptr'), ('int', None))),
    'wsock32.getnetbyname':('int', None, 'stdcall', 'mswsock.getnetbyname', (('int', None),)),
    'wsock32.getpeername':('int', None, 'stdcall', 'ws2_32.getpeername', ( ('int', None), ('int', None))),
    'wsock32.getprotobyname':('int', None, 'stdcall', 'ws2_32.getprotobyname', (('int', None),)),
    'wsock32.getprotobynumber':('int', None, 'stdcall', 'ws2_32.getprotobynumber', ( ('int', None),)),
    'wsock32.getservbyname':('int', None, 'stdcall', 'ws2_32.getservbyname', (('void *', 'ptr'), ('int', None))),
    'wsock32.getservbyport':('int', None, 'stdcall', 'ws2_32.getservbyport', (('int', None), ('int', None))),
    'wsock32.getsockname':('int', None, 'stdcall', 'ws2_32.getsockname', ( ('int', None), ('int', None))),
    'wsock32.htonl':('int', None, 'stdcall', 'ws2_32.htonl', (('int', None),)),
    'wsock32.htons':('int', None, 'stdcall', 'ws2_32.htons', (('int', None),)),
    'wsock32.inet_addr':('int', None, 'stdcall', 'ws2_32.inet_addr', (('int', None),)),
    'wsock32.inet_network':('int', None, 'stdcall', 'mswsock.inet_network', (('int', None),)),
    'wsock32.inet_ntoa':('int', None, 'stdcall', 'ws2_32.inet_ntoa', ( ('int', None),)),
    'wsock32.ioctlsocket':('int', None, 'stdcall', 'ws2_32.ioctlsocket', ( ('int', None), ('int', None))),
    'wsock32.listen':('int', None, 'stdcall', 'ws2_32.listen', ( ('int', None),)),
    'wsock32.ntohl':('int', None, 'stdcall', 'ws2_32.ntohl', (('int', None),)),
    'wsock32.ntohs':('int', None, 'stdcall', 'ws2_32.ntohs', (('int', None),)),
    'wsock32.rcmd':('int', None, 'stdcall', 'mswsock.rcmd', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.rexec':('int', None, 'stdcall', 'mswsock.rexec', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.rresvport':('int', None, 'stdcall', 'mswsock.rresvport', (('void *', 'ptr'),)),
    'wsock32.s_perror':('int', None, 'stdcall', 'mswsock.s_perror', (('void *', 'ptr'), ('int', None))),
    'wsock32.select':('int', None, 'stdcall', 'ws2_32.select', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.send':('int', None, 'stdcall', 'ws2_32.send', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.sendto':('int', None, 'stdcall', 'ws2_32.sendto', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.sethostname':('int', None, 'stdcall', 'mswsock.sethostname', (('int', None), ('int', None))),
    'wsock32.shutdown':('int', None, 'stdcall', 'ws2_32.shutdown', ( ('int', None),)),
    'wsock32.socket':('int', None, 'stdcall', 'ws2_32.socket', ( ('int', None), ('int', None), ('void *', 'obj'))),

    # WININET
    'wininet.main_entry':( 'int', None, 'stdcall', 'wininet.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'wininet.commiturlcacheentrya':( 'int', None, 'stdcall', 'wininet.CommitUrlCacheEntryA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.commiturlcacheentryw':( 'int', None, 'stdcall', 'wininet.CommitUrlCacheEntryW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.createmd5ssohash':( 'int', None, 'stdcall', 'wininet.CreateMD5SSOHash', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachecontainera':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheContainerA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachecontainerw':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheContainerW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcacheentrya':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheEntryA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.createurlcacheentryw':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheEntryW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachegroup':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheGroup', (('int', None), ('int', None)) ),
    'wininet.deleteie3cache':( 'int', None, 'stdcall', 'wininet.DeleteIE3Cache', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.deleteurlcachecontainera':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheContainerA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.deleteurlcachecontainerw':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheContainerW', (('int', None), ('int', None)) ),
    'wininet.deleteurlcacheentry':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntry', (('int', None),) ),
    'wininet.deleteurlcacheentrya':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntryA', (('int', None),) ),
    'wininet.deleteurlcacheentryw':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntryW', (('void *', 'ptr'),) ),
    'wininet.deleteurlcachegroup':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheGroup', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.deletewpadcachefornetworks':( 'int', None, 'stdcall', 'wininet.DeleteWpadCacheForNetworks', (('int', None),) ),
    'wininet.detectautoproxyurl':( 'int', None, 'stdcall', 'wininet.DetectAutoProxyUrl', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.dispatchapicall':( 'int', None, 'stdcall', 'wininet.DispatchAPICall', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.dllinstall':( 'int', None, 'stdcall', 'wininet.DllInstall', (('int', None), ('int', None)) ),
    'wininet.findcloseurlcache':( 'int', None, 'stdcall', 'wininet.FindCloseUrlCache', (('int', None),) ),
    'wininet.findfirsturlcachecontainera':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheContainerA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findfirsturlcachecontainerw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheContainerW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentrya':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findfirsturlcacheentryexa':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentryexw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryExW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentryw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findfirsturlcachegroup':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheGroup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcachecontainera':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheContainerA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findnexturlcachecontainerw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheContainerW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findnexturlcacheentrya':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findnexturlcacheentryexa':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryExA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcacheentryexw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcacheentryw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findnexturlcachegroup':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheGroup', (('int', None), ('int', None), ('int', None)) ),
    'wininet.forcenexuslookup':( 'int', None, 'cdecl', 'wininet.ForceNexusLookup', () ),
    'wininet.forcenexuslookupexw':( 'int', None, 'stdcall', 'wininet.ForceNexusLookupExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.freeurlcachespacea':( 'int', None, 'stdcall', 'wininet.FreeUrlCacheSpaceA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.freeurlcachespacew':( 'int', None, 'stdcall', 'wininet.FreeUrlCacheSpaceW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpcommanda':( 'int', None, 'stdcall', 'wininet.FtpCommandA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.ftpcommandw':( 'int', None, 'stdcall', 'wininet.FtpCommandW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpcreatedirectorya':( 'int', None, 'stdcall', 'wininet.FtpCreateDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpcreatedirectoryw':( 'int', None, 'stdcall', 'wininet.FtpCreateDirectoryW', (('int', None), ('int', None)) ),
    'wininet.ftpdeletefilea':( 'int', None, 'stdcall', 'wininet.FtpDeleteFileA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpdeletefilew':( 'int', None, 'stdcall', 'wininet.FtpDeleteFileW', (('int', None), ('int', None)) ),
    'wininet.ftpfindfirstfilea':( 'int', None, 'stdcall', 'wininet.FtpFindFirstFileA', (('int', None), ('void *', 'ptr'), ('StringA', None), ('int', None), ('int', None)) ),
    'wininet.ftpfindfirstfilew':( 'int', None, 'stdcall', 'wininet.FtpFindFirstFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpgetcurrentdirectorya':( 'int', None, 'stdcall', 'wininet.FtpGetCurrentDirectoryA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.ftpgetcurrentdirectoryw':( 'int', None, 'stdcall', 'wininet.FtpGetCurrentDirectoryW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpgetfilea':( 'int', None, 'stdcall', 'wininet.FtpGetFileA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpgetfileex':( 'int', None, 'stdcall', 'wininet.FtpGetFileEx', ( ('int', None), ('StringW', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpgetfilesize':( 'int', None, 'stdcall', 'wininet.FtpGetFileSize', (('int', None), ('int', None)) ),
    'wininet.ftpgetfilew':( 'int', None, 'stdcall', 'wininet.FtpGetFileW', ( ('int', None), ('StringW', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpopenfilea':( 'int', None, 'stdcall', 'wininet.FtpOpenFileA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpopenfilew':( 'int', None, 'stdcall', 'wininet.FtpOpenFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfilea':( 'int', None, 'stdcall', 'wininet.FtpPutFileA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfileex':( 'int', None, 'stdcall', 'wininet.FtpPutFileEx', ( ('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfilew':( 'int', None, 'stdcall', 'wininet.FtpPutFileW', ( ('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpremovedirectorya':( 'int', None, 'stdcall', 'wininet.FtpRemoveDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpremovedirectoryw':( 'int', None, 'stdcall', 'wininet.FtpRemoveDirectoryW', (('int', None), ('int', None)) ),
    'wininet.ftprenamefilea':( 'int', None, 'stdcall', 'wininet.FtpRenameFileA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.ftprenamefilew':( 'int', None, 'stdcall', 'wininet.FtpRenameFileW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpsetcurrentdirectorya':( 'int', None, 'stdcall', 'wininet.FtpSetCurrentDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpsetcurrentdirectoryw':( 'int', None, 'stdcall', 'wininet.FtpSetCurrentDirectoryW', (('int', None), ('int', None)) ),
    'wininet.geturlcacheconfiginfoa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheConfigInfoA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.geturlcacheconfiginfow':( 'int', None, 'stdcall', 'wininet.GetUrlCacheConfigInfoW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfoa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.geturlcacheentryinfoexa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoExA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfoexw':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoExW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfow':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.geturlcachegroupattributea':( 'int', None, 'stdcall', 'wininet.GetUrlCacheGroupAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.geturlcachegroupattributew':( 'int', None, 'stdcall', 'wininet.GetUrlCacheGroupAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.GetUrlCacheHeaderData', (('int', None), ('void *', 'ptr')) ),
    'wininet.gophercreatelocatora':( 'int', None, 'stdcall', 'wininet.GopherCreateLocatorA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophercreatelocatorw':( 'int', None, 'stdcall', 'wininet.GopherCreateLocatorW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopherfindfirstfilea':( 'int', None, 'stdcall', 'wininet.GopherFindFirstFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopherfindfirstfilew':( 'int', None, 'stdcall', 'wininet.GopherFindFirstFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetattributea':( 'int', None, 'stdcall', 'wininet.GopherGetAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetattributew':( 'int', None, 'stdcall', 'wininet.GopherGetAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetlocatortypea':( 'int', None, 'stdcall', 'wininet.GopherGetLocatorTypeA', (('int', None), ('int', None)) ),
    'wininet.gophergetlocatortypew':( 'int', None, 'stdcall', 'wininet.GopherGetLocatorTypeW', (('int', None), ('int', None)) ),
    'wininet.gopheropenfilea':( 'int', None, 'stdcall', 'wininet.GopherOpenFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopheropenfilew':( 'int', None, 'stdcall', 'wininet.GopherOpenFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpaddrequestheadersa':( 'int', None, 'stdcall', 'wininet.HttpAddRequestHeadersA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.httpaddrequestheadersw':( 'int', None, 'stdcall', 'wininet.HttpAddRequestHeadersW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpcheckdavcompliance':( 'int', None, 'stdcall', 'wininet.HttpCheckDavCompliance', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpendrequesta':( 'int', None, 'stdcall', 'wininet.HttpEndRequestA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpendrequestw':( 'int', None, 'stdcall', 'wininet.HttpEndRequestW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpopenrequesta':( 'int', None, 'stdcall', 'wininet.HttpOpenRequestA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpopenrequestw':( 'int', None, 'stdcall', 'wininet.HttpOpenRequestW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpqueryinfoa':( 'int', None, 'stdcall', 'wininet.HttpQueryInfoA', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.httpqueryinfow':( 'int', None, 'stdcall', 'wininet.HttpQueryInfoW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr')) ),
    'wininet.httpsendrequesta':( 'int', None, 'stdcall', 'wininet.HttpSendRequestA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestexa':( 'int', None, 'stdcall', 'wininet.HttpSendRequestExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestexw':( 'int', None, 'stdcall', 'wininet.HttpSendRequestExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestw':( 'int', None, 'stdcall', 'wininet.HttpSendRequestW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.incrementurlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.IncrementUrlCacheHeaderData', (('int', None), ('int', None)) ),
    'wininet.internetalgidtostringa':( 'int', None, 'stdcall', 'wininet.InternetAlgIdToStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetalgidtostringw':( 'int', None, 'stdcall', 'wininet.InternetAlgIdToStringW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetattemptconnect':( 'int', None, 'stdcall', 'wininet.InternetAttemptConnect', (('int', None),) ),
    'wininet.internetautodial':( 'int', None, 'stdcall', 'wininet.InternetAutodial', (('int', None), ('int', None)) ),
    'wininet.internetautodialcallback':( 'int', None, 'stdcall', 'wininet.InternetAutodialCallback', (('int', None), ('void *', 'ptr')) ),
    'wininet.internetautodialhangup':( 'int', None, 'stdcall', 'wininet.InternetAutodialHangup', (('int', None),) ),
    'wininet.internetcanonicalizeurla':( 'int', None, 'stdcall', 'wininet.InternetCanonicalizeUrlA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetcanonicalizeurlw':( 'int', None, 'stdcall', 'wininet.InternetCanonicalizeUrlW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetcheckconnectiona':( 'int', None, 'stdcall', 'wininet.InternetCheckConnectionA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetcheckconnectionw':( 'int', None, 'msfastcall', 'wininet.InternetCheckConnectionW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetclearallpersitecookiedecisions':( 'int', None, 'cdecl', 'wininet.InternetClearAllPerSiteCookieDecisions', () ),
    'wininet.internetclosehandle':( 'int', None, 'stdcall', 'wininet.InternetCloseHandle', (('int', None),) ),
    'wininet.internetcombineurla':( 'int', None, 'stdcall', 'wininet.InternetCombineUrlA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetcombineurlw':( 'int', None, 'stdcall', 'wininet.InternetCombineUrlW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetconfirmzonecrossing':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossing', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.internetconfirmzonecrossinga':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossingA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.internetconfirmzonecrossingw':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossingW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetconnecta':( 'int', None, 'stdcall', 'wininet.InternetConnectA', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetconnectw':( 'int', None, 'stdcall', 'wininet.InternetConnectW', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    #'wininet.internetconnectw':( 'int', None, 'msfastcall', 'wininet.InternetConnectW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetcrackurla':( 'int', None, 'stdcall', 'wininet.InternetCrackUrlA', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetcrackurlw':( 'int', None, 'stdcall', 'wininet.InternetCrackUrlW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetcreateurla':( 'int', None, 'stdcall', 'wininet.InternetCreateUrlA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.internetcreateurlw':( 'int', None, 'stdcall', 'wininet.InternetCreateUrlW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetdial':( 'int', None, 'stdcall', 'wininet.InternetDial', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetdiala':( 'int', None, 'stdcall', 'wininet.InternetDialA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetdialw':( 'int', None, 'stdcall', 'wininet.InternetDialW', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetenumpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetEnumPerSiteCookieDecisionA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetenumpersitecookiedecisionw':( 'int', None, 'stdcall', 'wininet.InternetEnumPerSiteCookieDecisionW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.interneterrordlg':( 'int', None, 'stdcall', 'wininet.InternetErrorDlg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetfindnextfilea':( 'int', None, 'stdcall', 'wininet.InternetFindNextFileA', (('int', None), ('StringA', None)) ),
    'wininet.internetfindnextfilew':( 'int', None, 'stdcall', 'wininet.InternetFindNextFileW', (('int', None), ('int', None)) ),
    'wininet.internetfortezzacommand':( 'int', None, 'stdcall', 'wininet.InternetFortezzaCommand', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetcertbyurl':( 'int', None, 'stdcall', 'wininet.InternetGetCertByURL', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetcertbyurla':( 'int', None, 'stdcall', 'wininet.InternetGetCertByURLA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstate':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedState', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetgetconnectedstateex':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstateexa':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstateexw':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookiea':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetcookieexa':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieExA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookieexw':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieExW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookiew':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetlastresponseinfoa':( 'int', None, 'stdcall', 'wininet.InternetGetLastResponseInfoA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetlastresponseinfow':( 'int', None, 'stdcall', 'wininet.InternetGetLastResponseInfoW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetGetPerSiteCookieDecisionA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetgetpersitecookiedecisionw':( 'int', None, 'msfastcall', 'wininet.InternetGetPerSiteCookieDecisionW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetsecurityinfobyurl':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURL', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetsecurityinfobyurla':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURLA', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetsecurityinfobyurlw':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURLW', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonline':( 'int', None, 'msfastcall', 'wininet.InternetGoOnline', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonlinea':( 'int', None, 'msfastcall', 'wininet.InternetGoOnlineA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonlinew':( 'int', None, 'msfastcall', 'wininet.InternetGoOnlineW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internethangup':( 'int', None, 'stdcall', 'wininet.InternetHangUp', (('int', None), ('int', None)) ),
    'wininet.internetinitializeautoproxydll':( 'int', None, 'stdcall', 'wininet.InternetInitializeAutoProxyDll', ( ('int', None),) ),
    'wininet.internetlockrequestfile':( 'int', None, 'stdcall', 'wininet.InternetLockRequestFile', ( ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetopena':( 'int', None, 'stdcall', 'wininet.InternetOpenA', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetopenurla':( 'int', None, 'stdcall', 'wininet.InternetOpenUrlA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetopenurlw':( 'int', None, 'stdcall', 'wininet.InternetOpenUrlW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetopenw':( 'int', None, 'stdcall', 'wininet.InternetOpenW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetquerydataavailable':( 'int', None, 'stdcall', 'wininet.InternetQueryDataAvailable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetqueryfortezzastatus':( 'int', None, 'stdcall', 'wininet.InternetQueryFortezzaStatus', (('int', None), ('int', None)) ),
    'wininet.internetqueryoptiona':( 'int', None, 'stdcall', 'wininet.InternetQueryOptionA', ( ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetqueryoptionw':( 'int', None, 'msfastcall', 'wininet.InternetQueryOptionW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetreadfile':( 'int', None, 'stdcall', 'wininet.InternetReadFile', (('int', None), ('StringA', None), ('DWORD', None), ('void *', 'ptr')) ),
    'wininet.internetreadfileexa':( 'int', None, 'stdcall', 'wininet.InternetReadFileExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetreadfileexw':( 'int', None, 'stdcall', 'wininet.InternetReadFileExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsecurityprotocoltostringa':( 'int', None, 'stdcall', 'wininet.InternetSecurityProtocolToStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsecurityprotocoltostringw':( 'int', None, 'stdcall', 'wininet.InternetSecurityProtocolToStringW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetcookiea':( 'int', None, 'stdcall', 'wininet.InternetSetCookieA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetsetcookieexa':( 'int', None, 'stdcall', 'wininet.InternetSetCookieExA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetcookieexw':( 'int', None, 'stdcall', 'wininet.InternetSetCookieExW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetcookiew':( 'int', None, 'stdcall', 'wininet.InternetSetCookieW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstate':( 'int', None, 'stdcall', 'wininet.InternetSetDialState', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstatea':( 'int', None, 'stdcall', 'wininet.InternetSetDialStateA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstatew':( 'int', None, 'stdcall', 'wininet.InternetSetDialStateW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetfilepointer':( 'int', None, 'stdcall', 'wininet.InternetSetFilePointer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetoptiona':( 'int', None, 'stdcall', 'wininet.InternetSetOptionA', ( ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetsetoptionexa':( 'int', None, 'stdcall', 'wininet.InternetSetOptionExA', ( ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetoptionexw':( 'int', None, 'msfastcall', 'wininet.InternetSetOptionExW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetoptionw':( 'int', None, 'msfastcall', 'wininet.InternetSetOptionW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetsetpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetSetPerSiteCookieDecisionA', (('int', None), ('int', None)) ),
    'wininet.internetsetpersitecookiedecisionw':( 'int', None, 'msfastcall', 'wininet.InternetSetPerSiteCookieDecisionW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallback':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallback', ( ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallbacka':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallbackA', ( ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallbackw':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallbackW', ( ('int', None), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurl':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURL', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurla':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURLA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurlw':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURLW', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtime':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTime', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtimea':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTimeA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtimew':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTimeW', (('void *', 'ptr'), ('int', None), ('int', None), ('DWORD', None)) ),
    'wininet.internettimetosystemtime':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTime', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimetosystemtimea':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTimeA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimetosystemtimew':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTimeW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetunlockrequestfile':( 'int', None, 'stdcall', 'wininet.InternetUnlockRequestFile', ( ('void *', 'ptr'),) ),
    'wininet.internetwritefile':( 'int', None, 'stdcall', 'wininet.InternetWriteFile', ( ('int', None), ('void *', 'ptr'), ('DWORD', None), ('DWORD_P', None)) ),
    'wininet.internetwritefileexa':( 'int', None, 'stdcall', 'wininet.InternetWriteFileExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetwritefileexw':( 'int', None, 'stdcall', 'wininet.InternetWriteFileExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ishostinproxybypasslist':( 'int', None, 'stdcall', 'wininet.IsHostInProxyBypassList', ( ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.isurlcacheentryexpireda':( 'int', None, 'stdcall', 'wininet.IsUrlCacheEntryExpiredA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.isurlcacheentryexpiredw':( 'int', None, 'stdcall', 'wininet.IsUrlCacheEntryExpiredW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.loadurlcachecontent':( 'int', None, 'cdecl', 'wininet.LoadUrlCacheContent', () ),
    'wininet.parsex509encodedcertificateforlistboxentry':( 'int', None, 'stdcall', 'wininet.ParseX509EncodedCertificateForListBoxEntry', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.privacygetzonepreferencew':( 'int', None, 'stdcall', 'wininet.PrivacyGetZonePreferenceW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.privacysetzonepreferencew':( 'int', None, 'stdcall', 'wininet.PrivacySetZonePreferenceW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.readurlcacheentrystream':( 'int', None, 'stdcall', 'wininet.ReadUrlCacheEntryStream', (('int', None), ('int', None), ('StringA', None), ('DWORD_P', None), ('int', None)) ),
    'wininet.readurlcacheentrystreamex':( 'int', None, 'stdcall', 'wininet.ReadUrlCacheEntryStreamEx', (('int', None), ('int', None), ('int', None), ('StringA', None), ('DWORD_P', None)) ),
    'wininet.registerurlcachenotification':( 'int', None, 'stdcall', 'wininet.RegisterUrlCacheNotification', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.resumesuspendeddownload':( 'int', None, 'stdcall', 'wininet.ResumeSuspendedDownload', (('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentryfilea':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryFileA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.retrieveurlcacheentryfilew':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryFileW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentrystreama':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryStreamA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentrystreamw':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryStreamW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.runonceurlcache':( 'int', None, 'stdcall', 'wininet.RunOnceUrlCache', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheconfiginfoa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheConfigInfoA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheconfiginfow':( 'int', None, 'stdcall', 'wininet.SetUrlCacheConfigInfoW', (('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroup':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroupa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroupA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroupw':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroupW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentryinfoa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryInfoA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheentryinfow':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryInfoW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.seturlcachegroupattributea':( 'int', None, 'stdcall', 'wininet.SetUrlCacheGroupAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcachegroupattributew':( 'int', None, 'stdcall', 'wininet.SetUrlCacheGroupAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.SetUrlCacheHeaderData', (('int', None), ('int', None)) ),
    'wininet.showcertificate':( 'int', None, 'stdcall', 'wininet.ShowCertificate', (('int', None), ('int', None)) ),
    'wininet.showclientauthcerts':( 'int', None, 'stdcall', 'wininet.ShowClientAuthCerts', (('int', None),) ),
    'wininet.showsecurityinfo':( 'int', None, 'stdcall', 'wininet.ShowSecurityInfo', (('int', None), ('void *', 'ptr')) ),
    'wininet.showx509encodedcertificate':( 'int', None, 'stdcall', 'wininet.ShowX509EncodedCertificate', (('int', None), ('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfile':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFile', (('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfilea':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFileA', (('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfilew':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFileW', (('void *', 'ptr'), ('int', None)) ),
    'wininet.unlockurlcacheentrystream':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryStream', (('int', None), ('int', None)) ),
    'wininet.updateurlcachecontentpath':( 'int', None, 'stdcall', 'wininet.UpdateUrlCacheContentPath', (('StringA', None),) ),
    'wininet.urlzonesdetach':( 'int', None, 'cdecl', 'wininet.UrlZonesDetach', () ),
    'wininet._getfileextensionfromurl':( 'int', None, 'stdcall', 'wininet._GetFileExtensionFromUrl', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),

    'mfc42.?afxbeginthread@@ygpavcwinthread@@p6aipax@z0hikpau_security_attributes@@@z':( 'int', None, 'cdecl', 'mfc42.?AfxBeginThread@@YGPAVCWinThread@@P6AIPAX@Z0HIKPAU_SECURITY_ATTRIBUTES@@@Z', (('void *','funcptr'), ('void *','ptr'), ('int',None), ('int',None), ('int',None), ('void *','ptr')) ),

} # END
