apitypes = {
    'DWORD':        'unsigned int',
    'HANDLE':       'unsigned int',
}

api = {
    # libc
    'plt___libc_start_main':( 'int', None, 'cdecl', '*.__libc_start_main', (('int', 'main'), ('int', 'argc'), ('int', 'argv')) ),
    'plt_main_entry':( 'int', None, 'stdcall', '*.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'plt__cicos':( 'int', None, 'cdecl', '*._CIcos', () ),
    'plt__cilog':( 'int', None, 'cdecl', '*._CIlog', () ),
    'plt__cipow':( 'int', None, 'cdecl', '*._CIpow', () ),
    'plt__cisin':( 'int', None, 'cdecl', '*._CIsin', () ),
    'plt__cisqrt':( 'int', None, 'cdecl', '*._CIsqrt', () ),
    'plt___isascii':( 'int', None, 'cdecl', '*.__isascii', (('int', None),) ),
    'plt___iscsym':( 'int', None, 'cdecl', '*.__iscsym', (('int', None),) ),
    'plt___iscsymf':( 'int', None, 'cdecl', '*.__iscsymf', (('int', None),) ),
    'plt___toascii':( 'int', None, 'cdecl', '*.__toascii', (('int', None),) ),
    'plt__alldiv':( 'int', None, 'stdcall', '*._alldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__alldvrm':( 'int', None, 'stdcall', '*._alldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__allmul':( 'int', None, 'stdcall', '*._allmul', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__alloca_probe':( 'int', None, 'cdecl', '*._alloca_probe', () ),
    'plt__allrem':( 'int', None, 'stdcall', '*._allrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__allshl':( 'int', None, 'cdecl', '*._allshl', () ),
    'plt__allshr':( 'int', None, 'cdecl', '*._allshr', () ),
    'plt__atoi64':( 'int', None, 'cdecl', '*._atoi64', (('int', None),) ),
    'plt__aulldiv':( 'int', None, 'stdcall', '*._aulldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__aulldvrm':( 'int', None, 'stdcall', '*._aulldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__aullrem':( 'int', None, 'stdcall', '*._aullrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__aullshr':( 'int', None, 'cdecl', '*._aullshr', () ),
    'plt__chkstk':( 'int', None, 'cdecl', '*._chkstk', () ),
    'plt__fltused':( 'int', None, 'cdecl', '*._fltused', () ),
    'plt__ftol':( 'int', None, 'cdecl', '*._ftol', () ),
    'plt__i64toa':( 'int', None, 'msfastcall', '*._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__i64tow':( 'int', None, 'msfastcall', '*._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__itoa':( 'int', None, 'cdecl', '*._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__itow':( 'int', None, 'cdecl', '*._itow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__lfind':( 'int', None, 'cdecl', '*._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'plt__ltoa':( 'int', None, 'cdecl', '*._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__ltow':( 'int', None, 'cdecl', '*._ltow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__memccpy':( 'int', None, 'cdecl', '*._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__memicmp':( 'int', None, 'cdecl', '*._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__snprintf':( 'int', None, 'cdecl', '*._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt__snwprintf':( 'int', None, 'cdecl', '*._snwprintf', (('void *', 'buffer'), ('int', 'count'), ('void *', 'fmt')) ),
    'plt__splitpath':( 'int', None, 'cdecl', '*._splitpath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__strcmpi':( 'int', None, 'cdecl', '*._strcmpi', (('int', None), ('int', None)) ),
    'plt__stricmp':( 'int', None, 'cdecl', '*._stricmp', (('int', None), ('int', None)) ),
    'plt__strlwr':( 'int', None, 'cdecl', '*._strlwr', (('int', None),) ),
    'plt__strnicmp':( 'int', None, 'cdecl', '*._strnicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__strupr':( 'int', None, 'cdecl', '*._strupr', (('int', None),) ),
    'plt__tolower':( 'int', None, 'cdecl', '*._tolower', (('int', None),) ),
    'plt__toupper':( 'int', None, 'cdecl', '*._toupper', (('int', None),) ),
    'plt__ui64toa':( 'int', None, 'msfastcall', '*._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__ui64tow':( 'int', None, 'msfastcall', '*._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__ultoa':( 'int', None, 'cdecl', '*._ultoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__ultow':( 'int', None, 'cdecl', '*._ultow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__vsnprintf':( 'int', None, 'cdecl', '*._vsnprintf', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'plt__vsnwprintf':( 'int', None, 'cdecl', '*._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__wcsicmp':( 'int', None, 'cdecl', '*._wcsicmp', (('int', None), ('int', None)) ),
    'plt__wcslwr':( 'int', None, 'cdecl', '*._wcslwr', (('int', None),) ),
    'plt__wcsnicmp':( 'int', None, 'cdecl', '*._wcsnicmp', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__wcsupr':( 'int', None, 'cdecl', '*._wcsupr', (('int', None),) ),
    'plt__wtoi':( 'int', None, 'cdecl', '*._wtoi', (('int', None),) ),
    'plt__wtoi64':( 'int', None, 'cdecl', '*._wtoi64', (('int', None),) ),
    'plt__wtol':( 'int', None, 'cdecl', '*._wtol', (('int', None),) ),
    'plt_abs':( 'int', None, 'cdecl', '*.abs', (('int', None),) ),
    'plt_atan':( 'int', None, 'cdecl', '*.atan', () ),
    'plt_atoi':( 'int', None, 'cdecl', '*.atoi', (('int', None),) ),
    'plt_atol':( 'int', None, 'cdecl', '*.atol', (('int', None),) ),
    'plt_bsearch':( 'int', None, 'cdecl', '*.bsearch', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'plt_ceil':( 'int', None, 'cdecl', '*.ceil', () ),
    'plt_cos':( 'int', None, 'cdecl', '*.cos', () ),
    'plt_fabs':( 'int', None, 'cdecl', '*.fabs', (('int', None), ('int', None)) ),
    'plt_floor':( 'int', None, 'cdecl', '*.floor', () ),
    'plt_isalnum':( 'int', None, 'cdecl', '*.isalnum', (('int', None),) ),
    'plt_isalpha':( 'int', None, 'cdecl', '*.isalpha', (('int', None),) ),
    'plt_iscntrl':( 'int', None, 'cdecl', '*.iscntrl', (('int', None),) ),
    'plt_isdigit':( 'int', None, 'cdecl', '*.isdigit', (('int', None),) ),
    'plt_isgraph':( 'int', None, 'cdecl', '*.isgraph', (('int', None),) ),
    'plt_islower':( 'int', None, 'cdecl', '*.islower', (('int', None),) ),
    'plt_isprint':( 'int', None, 'cdecl', '*.isprint', (('int', None),) ),
    'plt_ispunct':( 'int', None, 'cdecl', '*.ispunct', (('int', None),) ),
    'plt_isspace':( 'int', None, 'cdecl', '*.isspace', (('int', None),) ),
    'plt_isupper':( 'int', None, 'cdecl', '*.isupper', (('int', None),) ),
    'plt_iswalpha':( 'int', None, 'cdecl', '*.iswalpha', (('int', None),) ),
    'plt_iswctype':( 'int', None, 'cdecl', '*.iswctype', (('int', None), ('int', None)) ),
    'plt_iswdigit':( 'int', None, 'cdecl', '*.iswdigit', (('int', None),) ),
    'plt_iswlower':( 'int', None, 'cdecl', '*.iswlower', (('int', None),) ),
    'plt_iswspace':( 'int', None, 'cdecl', '*.iswspace', (('int', None),) ),
    'plt_iswxdigit':( 'int', None, 'cdecl', '*.iswxdigit', (('int', None),) ),
    'plt_isxdigit':( 'int', None, 'cdecl', '*.isxdigit', (('int', None),) ),
    'plt_labs':( 'int', None, 'cdecl', '*.labs', (('int', None),) ),
    'plt_log':( 'int', None, 'cdecl', '*.log', () ),
    'plt_mbstowcs':( 'int', None, 'cdecl', '*.mbstowcs', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_memchr':( 'int', None, 'cdecl', '*.memchr', (('int', None), ('int', None), ('int', None)) ),
    'plt_memcmp':( 'int', None, 'cdecl', '*.memcmp', (('int', None), ('int', None), ('int', None)) ),
    'plt_memcpy':( 'int', None, 'cdecl', '*.memcpy', (('int', None), ('int', None), ('int', None)) ),
    'plt_memmove':( 'int', None, 'cdecl', '*.memmove', (('void *', 'dst'), ('void *', 'src'), ('int', 'count')) ),
    'plt_memset':( 'int', None, 'cdecl', '*.memset', (('int', None), ('int', None), ('int', None)) ),
    'plt_pow':( 'int', None, 'cdecl', '*.pow', () ),
    'plt_qsort':( 'int', None, 'stdcall', '*.qsort', ( ('void *', 'funcptr'), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_sin':( 'int', None, 'cdecl', '*.sin', () ),
    'plt_sprintf':( 'int', None, 'cdecl', '*.sprintf', (('void *', 'ptr'), ('int', None)) ),
    'plt_sqrt':( 'int', None, 'cdecl', '*.sqrt', () ),
    'plt_sscanf':( 'int', None, 'cdecl', '*.sscanf', (('int', None), ('int', None)) ),
    'plt_strcat':( 'int', None, 'cdecl', '*.strcat', (('int', None), ('int', None)) ),
    'plt_strchr':( 'int', None, 'cdecl', '*.strchr', (('int', None), ('int', None)) ),
    'plt_strcmp':( 'int', None, 'cdecl', '*.strcmp', (('int', None), ('int', None)) ),
    'plt_strcpy':( 'int', None, 'cdecl', '*.strcpy', (('int', None), ('int', None)) ),
    'plt_strcspn':( 'int', None, 'cdecl', '*.strcspn', (('int', None), ('int', None)) ),
    'plt_strlen':( 'int', None, 'cdecl', '*.strlen', (('int', None),) ),
    'plt_strncat':( 'int', None, 'cdecl', '*.strncat', (('int', None), ('int', None), ('int', None)) ),
    'plt_strncmp':( 'int', None, 'cdecl', '*.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'plt_strncpy':( 'int', None, 'cdecl', '*.strncpy', (('int', None), ('int', None), ('int', None)) ),
    'plt_strpbrk':( 'int', None, 'cdecl', '*.strpbrk', (('int', None), ('int', None)) ),
    'plt_strrchr':( 'int', None, 'cdecl', '*.strrchr', (('int', None), ('int', None)) ),
    'plt_strspn':( 'int', None, 'cdecl', '*.strspn', (('int', None), ('int', None)) ),
    'plt_strstr':( 'int', None, 'cdecl', '*.strstr', (('int', None), ('int', None)) ),
    'plt_strtol':( 'int', None, 'cdecl', '*.strtol', (('int', None), ('int', None), ('int', None)) ),
    'plt_strtoul':( 'int', None, 'cdecl', '*.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'plt_swprintf':( 'int', None, 'cdecl', '*.swprintf', (('wchar *', 'ptr'), ('int', None)) ),
    'plt_tan':( 'int', None, 'cdecl', '*.tan', () ),
    'plt_tolower':( 'int', None, 'cdecl', '*.tolower', (('int', None),) ),
    'plt_toupper':( 'int', None, 'cdecl', '*.toupper', (('int', None),) ),
    'plt_towlower':( 'int', None, 'cdecl', '*.towlower', (('int', None),) ),
    'plt_towupper':( 'int', None, 'cdecl', '*.towupper', (('int', None),) ),
    'plt_vdbgprintex':( 'int', None, 'stdcall', '*.vDbgPrintEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_vdbgprintexwithprefix':( 'int', None, 'stdcall', '*.vDbgPrintExWithPrefix', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_vsprintf':( 'int', None, 'cdecl', '*.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcscat':( 'int', None, 'cdecl', '*.wcscat', (('int', None), ('void *', 'ptr')) ),
    'plt_wcschr':( 'int', None, 'cdecl', '*.wcschr', (('void *', 'ptr'), ('int', None)) ),
    'plt_wcscmp':( 'int', None, 'cdecl', '*.wcscmp', (('void *', 'ptr'), ('int', None)) ),
    'plt_wcscpy':( 'int', None, 'cdecl', '*.wcscpy', (('void *', 'dst'), ('void *', 'src')) ),
    'plt_wcscspn':( 'int', None, 'cdecl', '*.wcscspn', (('void *', 'ptr'), ('int', None)) ),
    'plt_wcslen':( 'int', None, 'cdecl', '*.wcslen', (('void *', 'ptr'),) ),
    'plt_wcsncat':( 'int', None, 'cdecl', '*.wcsncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_wcsncmp':( 'int', None, 'cdecl', '*.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcsncpy':( 'int', None, 'cdecl', '*.wcsncpy', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_wcspbrk':( 'int', None, 'cdecl', '*.wcspbrk', (('int', None), ('int', None)) ),
    'plt_wcsrchr':( 'int', None, 'cdecl', '*.wcsrchr', (('int', None), ('int', None)) ),
    'plt_wcsspn':( 'int', None, 'cdecl', '*.wcsspn', (('int', None), ('int', None)) ),
    'plt_wcsstr':( 'int', None, 'cdecl', '*.wcsstr', (('void *', 'ptr'), ('int', None)) ),
    'plt_wcstol':( 'int', None, 'cdecl', '*.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcstombs':( 'int', None, 'cdecl', '*.wcstombs', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt_wcstoul':( 'int', None, 'cdecl', '*.wcstoul', (('int', None), ('void *', 'ptr'), ('int', None)) ),

    'plt__hread':( 'int', None, 'stdcall', '*._hread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__hwrite':( 'int', None, 'stdcall', '*._hwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__lclose':( 'int', None, 'stdcall', '*._lclose', (('int', None),) ),
    'plt__lcreat':( 'int', None, 'stdcall', '*._lcreat', (('int', None), ('int', None)) ),
    'plt__llseek':( 'int', None, 'stdcall', '*._llseek', (('int', None), ('int', None), ('int', None)) ),
    'plt__lopen':( 'int', None, 'stdcall', '*._lopen', (('int', None), ('int', None)) ),
    'plt__lread':( 'int', None, 'stdcall', '*._lread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__lwrite':( 'int', None, 'stdcall', '*._lwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt_lstrcat':( 'int', None, 'stdcall', '*.lstrcat', (('int', None), ('int', None)) ),
    'plt_lstrcata':( 'int', None, 'stdcall', '*.lstrcatA', (('int', None), ('int', None)) ),
    'plt_lstrcatw':( 'int', None, 'stdcall', '*.lstrcatW', (('int', None), ('void *', 'ptr')) ),
    'plt_lstrcmp':( 'int', None, 'stdcall', '*.lstrcmp', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcmpa':( 'int', None, 'stdcall', '*.lstrcmpA', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcmpw':( 'int', None, 'stdcall', '*.lstrcmpW', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcmpi':( 'int', None, 'stdcall', '*.lstrcmpi', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcmpia':( 'int', None, 'stdcall', '*.lstrcmpiA', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcmpiw':( 'int', None, 'stdcall', '*.lstrcmpiW', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt_lstrcpy':( 'int', None, 'stdcall', '*.lstrcpy', (('int', None), ('int', None)) ),
    'plt_lstrcpya':( 'int', None, 'stdcall', '*.lstrcpyA', (('int', None), ('int', None)) ),
    'plt_lstrcpyw':( 'int', None, 'stdcall', '*.lstrcpyW', (('int', None), ('int', None)) ),
    'plt_lstrcpyn':( 'int', None, 'stdcall', '*.lstrcpyn', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_lstrcpyna':( 'int', None, 'stdcall', '*.lstrcpynA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_lstrcpynw':( 'int', None, 'stdcall', '*.lstrcpynW', (('int', None), ('int', None), ('int', None)) ),
    'plt_lstrlen':( 'int', None, 'stdcall', '*.lstrlen', (('int', None),) ),
    'plt_lstrlena':( 'int', None, 'stdcall', '*.lstrlenA', (('int', None),) ),
    'plt_lstrlenw':( 'int', None, 'stdcall', '*.lstrlenW', (('int', None),) ),

    'plt__getdays':( 'int', None, 'cdecl', '*._Getdays', () ),
    'plt__getmonths':( 'int', None, 'cdecl', '*._Getmonths', () ),
    'plt__gettnames':( 'int', None, 'cdecl', '*._Gettnames', () ),
    'plt__huge':( 'int', None, 'cdecl', '*._HUGE', () ),
    'plt__strftime':( 'int', None, 'cdecl', '*._Strftime', (('void *', 's'), ('int', 'max'), ('void *', 'fmt'), ('int', 'tm'), ('int', None)) ),
    'plt__xcptfilter':( 'int', None, 'cdecl', '*._XcptFilter', (('int', None), ('int', None)) ),
    'plt___cppxcptfilter':( 'int', None, 'cdecl', '*.__CppXcptFilter', (('int', None), ('int', None)) ),
    'plt___cxxcallunwinddtor':( 'int', None, 'cdecl', '*.__CxxCallUnwindDtor', (('void *', 'funcptr'), ('int', None)) ),
    'plt___cxxcallunwindvecdtor':( 'int', None, 'cdecl', '*.__CxxCallUnwindVecDtor', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___cxxdetectrethrow':( 'int', None, 'cdecl', '*.__CxxDetectRethrow', (('int', None),) ),
    'plt___cxxexceptionfilter':( 'int', None, 'cdecl', '*.__CxxExceptionFilter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___cxxframehandler':( 'int', None, 'bfastcall', '*.__CxxFrameHandler', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___cxxlongjmpunwind':( 'int', None, 'stdcall', '*.__CxxLongjmpUnwind', (('int', None),) ),
    'plt___cxxqueryexceptionsize':( 'int', None, 'cdecl', '*.__CxxQueryExceptionSize', () ),
    'plt___cxxregisterexceptionobject':( 'int', None, 'cdecl', '*.__CxxRegisterExceptionObject', (('int', None), ('void *', 'ptr')) ),
    'plt___cxxunregisterexceptionobject':( 'int', None, 'cdecl', '*.__CxxUnregisterExceptionObject', (('int', None), ('int', None), ('int', None)) ),
    'plt___destructexceptionobject':( 'int', None, 'cdecl', '*.__DestructExceptionObject', (('int', None),) ),
    'plt___rtcasttovoid':( 'int', None, 'cdecl', '*.__RTCastToVoid', () ),
    'plt___rtdynamiccast':( 'int', None, 'cdecl', '*.__RTDynamicCast', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___rttypeid':( 'int', None, 'cdecl', '*.__RTtypeid', (('int', None),) ),
    'plt___stringtold':( 'int', None, 'cdecl', '*.__STRINGTOLD', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt____lc_codepage_func':( 'int', None, 'cdecl', '*.___lc_codepage_func', () ),
    'plt____lc_collate_cp_func':( 'int', None, 'cdecl', '*.___lc_collate_cp_func', () ),
    'plt____lc_handle_func':( 'int', None, 'cdecl', '*.___lc_handle_func', () ),
    'plt____mb_cur_max_func':( 'int', None, 'cdecl', '*.___mb_cur_max_func', () ),
    'plt____setlc_active_func':( 'int', None, 'cdecl', '*.___setlc_active_func', () ),
    'plt____unguarded_readlc_active_add_func':( 'int', None, 'cdecl', '*.___unguarded_readlc_active_add_func', () ),
    'plt___argc':( 'int', None, 'cdecl', '*.__argc', () ),
    'plt___argv':( 'int', None, 'cdecl', '*.__argv', () ),
    'plt___badioinfo':( 'int', None, 'cdecl', '*.__badioinfo', () ),
    'plt___buffer_overrun':( 'int', None, 'cdecl', '*.__buffer_overrun', () ),
    'plt___crtcomparestringa':( 'int', None, 'cdecl', '*.__crtCompareStringA', (('int', 'Locale'), ('int', 'dwCmpFlags'), ('void *', 'lpString1'), ('int', 'cchCount1'), ('void *', 'lpString2'), ('int', 'cchCount2'), ('int', 'code_page')) ),
    'plt___crtcomparestringw':( 'int', None, 'cdecl', '*.__crtCompareStringW', (('int', 'Locale'), ('int', 'dwCmpFlags'), ('void *', 'lpString1'), ('int', 'cchCount1'), ('void *', 'lpString2'), ('int', 'cchCount2'), ('int', 'code_page')) ),
    'plt___crtgetlocaleinfow':( 'int', None, 'cdecl', '*.__crtGetLocaleInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___crtgetstringtypew':( 'int', None, 'cdecl', '*.__crtGetStringTypeW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt___crtlcmapstringa':( 'int', None, 'cdecl', '*.__crtLCMapStringA', (('int', 'LocalName'), ('int', 'dwMapFlags'), ('void *', 'lpSrcStr'), ('int', 'cchSrc'), ('void *', 'lpDstStr'), ('int', 'cchDst'), ('int', 'code_page'), ('int', 'bError')) ),
    'plt___crtlcmapstringw':( 'int', None, 'cdecl', '*.__crtLCMapStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt___dllonexit':( 'int', None, 'cdecl', '*.__dllonexit', (('int', None), ('int', None), ('int', None)) ),
    'plt___doserrno':( 'int', None, 'cdecl', '*.__doserrno', () ),
    'plt___fpecode':( 'int', None, 'cdecl', '*.__fpecode', () ),
    'plt___getmainargs':( 'int', None, 'cdecl', '*.__getmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___initenv':( 'int', None, 'cdecl', '*.__initenv', () ),
    'plt___iob_func':( 'int', None, 'cdecl', '*.__iob_func', () ),
    'plt___isascii':( 'int', None, 'cdecl', '*.__isascii', (('int', None),) ),
    'plt___iscsym':( 'int', None, 'cdecl', '*.__iscsym', (('int', None),) ),
    'plt___iscsymf':( 'int', None, 'cdecl', '*.__iscsymf', (('int', None),) ),
    'plt___lc_clike':( 'int', None, 'bfastcall', '*.__lc_clike', (('int', None),) ),
    'plt___lc_codepage':( 'int', None, 'cdecl', '*.__lc_codepage', () ),
    'plt___lc_collate_cp':( 'int', None, 'cdecl', '*.__lc_collate_cp', () ),
    'plt___lc_handle':( 'int', None, 'cdecl', '*.__lc_handle', () ),
    'plt___lconv_init':( 'int', None, 'cdecl', '*.__lconv_init', () ),
    'plt___mb_cur_max':( 'int', None, 'bfastcall', '*.__mb_cur_max', (('int', None),) ),
    'plt___p___argc':( 'int', None, 'cdecl', '*.__p___argc', () ),
    'plt___p___argv':( 'int', None, 'cdecl', '*.__p___argv', () ),
    'plt___p___initenv':( 'int', None, 'cdecl', '*.__p___initenv', () ),
    'plt___p___mb_cur_max':( 'int', None, 'cdecl', '*.__p___mb_cur_max', () ),
    'plt___p___wargv':( 'int', None, 'cdecl', '*.__p___wargv', () ),
    'plt___p___winitenv':( 'int', None, 'cdecl', '*.__p___winitenv', () ),
    'plt___p__acmdln':( 'int', None, 'cdecl', '*.__p__acmdln', () ),
    'plt___p__amblksiz':( 'int', None, 'cdecl', '*.__p__amblksiz', () ),
    'plt___p__commode':( 'int', None, 'cdecl', '*.__p__commode', () ),
    'plt___p__daylight':( 'int', None, 'cdecl', '*.__p__daylight', () ),
    'plt___p__dstbias':( 'int', None, 'cdecl', '*.__p__dstbias', () ),
    'plt___p__environ':( 'int', None, 'cdecl', '*.__p__environ', () ),
    'plt___p__fileinfo':( 'int', None, 'cdecl', '*.__p__fileinfo', () ),
    'plt___p__fmode':( 'int', None, 'cdecl', '*.__p__fmode', () ),
    'plt___p__iob':( 'int', None, 'cdecl', '*.__p__iob', () ),
    'plt___p__mbcasemap':( 'int', None, 'cdecl', '*.__p__mbcasemap', () ),
    'plt___p__mbctype':( 'int', None, 'cdecl', '*.__p__mbctype', () ),
    'plt___p__osver':( 'int', None, 'cdecl', '*.__p__osver', () ),
    'plt___p__pctype':( 'int', None, 'cdecl', '*.__p__pctype', () ),
    'plt___p__pgmptr':( 'int', None, 'cdecl', '*.__p__pgmptr', () ),
    'plt___p__pwctype':( 'int', None, 'cdecl', '*.__p__pwctype', () ),
    'plt___p__timezone':( 'int', None, 'cdecl', '*.__p__timezone', () ),
    'plt___p__tzname':( 'int', None, 'cdecl', '*.__p__tzname', () ),
    'plt___p__wcmdln':( 'int', None, 'cdecl', '*.__p__wcmdln', () ),
    'plt___p__wenviron':( 'int', None, 'cdecl', '*.__p__wenviron', () ),
    'plt___p__winmajor':( 'int', None, 'cdecl', '*.__p__winmajor', () ),
    'plt___p__winminor':( 'int', None, 'cdecl', '*.__p__winminor', () ),
    'plt___p__winver':( 'int', None, 'cdecl', '*.__p__winver', () ),
    'plt___p__wpgmptr':( 'int', None, 'cdecl', '*.__p__wpgmptr', () ),
    'plt___pctype_func':( 'int', None, 'cdecl', '*.__pctype_func', () ),
    'plt___pioinfo':( 'int', None, 'cdecl', '*.__pioinfo', () ),
    'plt___pwctype_func':( 'int', None, 'cdecl', '*.__pwctype_func', () ),
    'plt___pxcptinfoptrs':( 'int', None, 'cdecl', '*.__pxcptinfoptrs', () ),
    'plt___security_error_handler':( 'int', None, 'cdecl', '*.__security_error_handler', (('int', None), ('int', None)) ),
    'plt___set_app_type':( 'int', None, 'cdecl', '*.__set_app_type', (('int', None),) ),
    'plt___set_buffer_overrun_handler':( 'int', None, 'cdecl', '*.__set_buffer_overrun_handler', (('int', None),) ),
    'plt___setlc_active':( 'int', None, 'cdecl', '*.__setlc_active', () ),
    'plt___setusermatherr':( 'int', None, 'cdecl', '*.__setusermatherr', (('int', None),) ),
    'plt___threadhandle':( 'int', None, 'stdcall', '*.__threadhandle', () ),
    'plt___threadid':( 'int', None, 'stdcall', '*.__threadid', () ),
    'plt___toascii':( 'int', None, 'cdecl', '*.__toascii', (('int', None),) ),
    'plt___undname':( 'int', None, 'cdecl', '*.__unDName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___undnameex':( 'int', None, 'cdecl', '*.__unDNameEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___uncaught_exception':( 'int', None, 'cdecl', '*.__uncaught_exception', () ),
    'plt___unguarded_readlc_active':( 'int', None, 'cdecl', '*.__unguarded_readlc_active', () ),
    'plt___wargv':( 'int', None, 'cdecl', '*.__wargv', () ),
    'plt___wcserror':( 'int', None, 'cdecl', '*.__wcserror', (('int', None),) ),
    'plt___wgetmainargs':( 'int', None, 'msfastcall', '*.__wgetmainargs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt___winitenv':( 'int', None, 'cdecl', '*.__winitenv', () ),
    'plt__abnormal_termination':( 'int', None, 'cdecl', '*._abnormal_termination', () ),
    'plt__access':( 'int', None, 'cdecl', '*._access', (('void *', 'ptr'), ('int', None)) ),
    'plt__acmdln':( 'int', None, 'cdecl', '*._acmdln', () ),
    'plt__adj_fdiv_m16i':( 'int', None, 'cdecl', '*._adj_fdiv_m16i', () ),
    'plt__adj_fdiv_m32':( 'int', None, 'cdecl', '*._adj_fdiv_m32', (('int', None),) ),
    'plt__adj_fdiv_m32i':( 'int', None, 'cdecl', '*._adj_fdiv_m32i', () ),
    'plt__adj_fdiv_m64':( 'int', None, 'cdecl', '*._adj_fdiv_m64', (('int', None), ('int', None)) ),
    'plt__adj_fdiv_r':( 'int', None, 'cdecl', '*._adj_fdiv_r', () ),
    'plt__adj_fdivr_m16i':( 'int', None, 'cdecl', '*._adj_fdivr_m16i', () ),
    'plt__adj_fdivr_m32':( 'int', None, 'cdecl', '*._adj_fdivr_m32', (('int', None),) ),
    'plt__adj_fdivr_m32i':( 'int', None, 'cdecl', '*._adj_fdivr_m32i', () ),
    'plt__adj_fdivr_m64':( 'int', None, 'cdecl', '*._adj_fdivr_m64', (('int', None), ('int', None)) ),
    'plt__adj_fpatan':( 'int', None, 'cdecl', '*._adj_fpatan', () ),
    'plt__adj_fprem':( 'int', None, 'cdecl', '*._adj_fprem', () ),
    'plt__adj_fprem1':( 'int', None, 'cdecl', '*._adj_fprem1', () ),
    'plt__adj_fptan':( 'int', None, 'cdecl', '*._adj_fptan', () ),
    'plt__adjust_fdiv':( 'int', None, 'cdecl', '*._adjust_fdiv', () ),
    'plt__aexit_rtn':( 'int', None, 'cdecl', '*._aexit_rtn', () ),
    'plt__aligned_free':( 'int', None, 'cdecl', '*._aligned_free', (('int', None),) ),
    'plt__aligned_malloc':( 'int', None, 'cdecl', '*._aligned_malloc', (('int', None), ('int', None)) ),
    'plt__aligned_offset_malloc':( 'int', None, 'cdecl', '*._aligned_offset_malloc', (('int', None), ('int', None), ('int', None)) ),
    'plt__aligned_offset_realloc':( 'int', None, 'cdecl', '*._aligned_offset_realloc', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'plt__aligned_realloc':( 'int', None, 'cdecl', '*._aligned_realloc', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__amsg_exit':( 'int', None, 'cdecl', '*._amsg_exit', (('int', None),) ),
    'plt__assert':( 'int', None, 'stdcall', '*._assert', (('void *', 'ptr'),) ),
    'plt__atodbl':( 'int', None, 'cdecl', '*._atodbl', (('void *', 'ptr'), ('int', None)) ),
    'plt__atoi64':( 'int', None, 'cdecl', '*._atoi64', (('int', None),) ),
    'plt__atoldbl':( 'int', None, 'cdecl', '*._atoldbl', (('int', None), ('int', None)) ),
    'plt__beep':( 'int', None, 'cdecl', '*._beep', (('int', None), ('int', None)) ),
    'plt__beginthread':( 'int', None, 'cdecl', '*._beginthread', (('int', None), ('int', None), ('int', None)) ),
    'plt__beginthreadex':( 'int', None, 'cdecl', '*._beginthreadex', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__c_exit':( 'int', None, 'cdecl', '*._c_exit', () ),
    'plt__cabs':( 'int', None, 'cdecl', '*._cabs', () ),
    'plt__callnewh':( 'int', None, 'cdecl', '*._callnewh', (('int', None),) ),
    'plt__cexit':( 'int', None, 'cdecl', '*._cexit', () ),
    'plt__cgets':( 'int', None, 'cdecl', '*._cgets', (('int', None),) ),
    'plt__cgetws':( 'int', None, 'cdecl', '*._cgetws', (('int', None),) ),
    'plt__chdir':( 'int', None, 'cdecl', '*._chdir', (('int', None),) ),
    'plt__chdrive':( 'int', None, 'cdecl', '*._chdrive', (('int', None),) ),
    'plt__chgsign':( 'int', None, 'cdecl', '*._chgsign', (('int', None), ('int', None)) ),
    'plt__chkesp':( 'int', None, 'cdecl', '*._chkesp', () ),
    'plt__chmod':( 'int', None, 'cdecl', '*._chmod', (('int', None), ('int', None)) ),
    'plt__chsize':( 'int', None, 'cdecl', '*._chsize', (('int', None), ('int', None)) ),
    'plt__clearfp':( 'int', None, 'cdecl', '*._clearfp', () ),
    'plt__close':( 'int', None, 'cdecl', '*._close', (('int', None),) ),
    'plt__commit':( 'int', None, 'cdecl', '*._commit', (('int', None),) ),
    'plt__commode':( 'int', None, 'cdecl', '*._commode', () ),
    'plt__control87':( 'int', None, 'cdecl', '*._control87', () ),
    'plt__controlfp':( 'int', None, 'cdecl', '*._controlfp', (('int', None), ('int', None)) ),
    'plt__copysign':( 'int', None, 'cdecl', '*._copysign', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__cprintf':( 'int', None, 'cdecl', '*._cprintf', (('int', None),) ),
    'plt__cputs':( 'int', None, 'cdecl', '*._cputs', (('void *', 'ptr'),) ),
    'plt__cputws':( 'int', None, 'cdecl', '*._cputws', (('void *', 'ptr'),) ),
    'plt__creat':( 'int', None, 'cdecl', '*._creat', (('StringA', None), ('int', None)) ),
    'plt__cscanf':( 'int', None, 'cdecl', '*._cscanf', (('int', None),) ),
    'plt__ctime64':( 'int', None, 'cdecl', '*._ctime64', (('void *', 'ptr'),) ),
    'plt__cwait':( 'int', None, 'cdecl', '*._cwait', (('void *', 'ptr'), ('HANDLE', None)) ),
    'plt__cwprintf':( 'int', None, 'cdecl', '*._cwprintf', (('int', None),) ),
    'plt__cwscanf':( 'int', None, 'cdecl', '*._cwscanf', (('int', None),) ),
    'plt__daylight':( 'int', None, 'bfastcall', '*._daylight', (('int', None),) ),
    'plt__dstbias':( 'int', None, 'cdecl', '*._dstbias', () ),
    'plt__dup':( 'int', None, 'cdecl', '*._dup', (('int', None),) ),
    'plt__dup2':( 'int', None, 'cdecl', '*._dup2', (('int', None), ('int', None)) ),
    'plt__ecvt':( 'int', None, 'cdecl', '*._ecvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__endthread':( 'int', None, 'cdecl', '*._endthread', () ),
    'plt__endthreadex':( 'int', None, 'cdecl', '*._endthreadex', (('int', None),) ),
    'plt__environ':( 'int', None, 'cdecl', '*._environ', () ),
    'plt__eof':( 'int', None, 'cdecl', '*._eof', (('int', None),) ),
    'plt__errno':( 'int', None, 'cdecl', '*._errno', () ),
    'plt__except_handler2':( 'int', None, 'cdecl', '*._except_handler2', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__except_handler3':( 'int', None, 'cdecl', '*._except_handler3', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__execl':( 'int', None, 'cdecl', '*._execl', () ),
    'plt__execle':( 'int', None, 'cdecl', '*._execle', ( ('int', None), ('int', None)) ),
    'plt__execlp':( 'int', None, 'cdecl', '*._execlp', () ),
    'plt__execlpe':( 'int', None, 'cdecl', '*._execlpe', ( ('int', None), ('int', None)) ),
    'plt__execv':( 'int', None, 'cdecl', '*._execv', ( ('int', None),) ),
    'plt__execve':( 'int', None, 'cdecl', '*._execve', ( ('int', None), ('int', None)) ),
    'plt__execvp':( 'int', None, 'cdecl', '*._execvp', ( ('int', None),) ),
    'plt__execvpe':( 'int', None, 'cdecl', '*._execvpe', ( ('int', None), ('int', None)) ),
    'plt__exit':( 'int', None, 'cdecl', '*._exit', (('int', None),) ),
    'plt__expand':( 'int', None, 'cdecl', '*._expand', (('int', None), ('int', None)) ),
    'plt__fcloseall':( 'int', None, 'cdecl', '*._fcloseall', () ),
    'plt__fcvt':( 'int', None, 'cdecl', '*._fcvt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__fdopen':( 'int', None, 'cdecl', '*._fdopen', (('int', None), ('int', None)) ),
    'plt__fgetchar':( 'int', None, 'cdecl', '*._fgetchar', () ),
    'plt__fgetwchar':( 'int', None, 'cdecl', '*._fgetwchar', () ),
    'plt__filbuf':( 'int', None, 'cdecl', '*._filbuf', (('int', None),) ),
    'plt__fileinfo':( 'int', None, 'cdecl', '*._fileinfo', () ),
    'plt__filelength':( 'int', None, 'cdecl', '*._filelength', (('int', None),) ),
    'plt__filelengthi64':( 'int', None, 'cdecl', '*._filelengthi64', (('int', None),) ),
    'plt__fileno':( 'int', None, 'cdecl', '*._fileno', (('int', None),) ),
    'plt__findclose':( 'int', None, 'cdecl', '*._findclose', (('void *', 'ptr'),) ),
    'plt__findfirst':( 'int', None, 'cdecl', '*._findfirst', (('int', None), ('void *', 'ptr')) ),
    'plt__findfirst64':( 'int', None, 'cdecl', '*._findfirst64', (('int', None), ('void *', 'ptr')) ),
    'plt__findfirsti64':( 'int', None, 'cdecl', '*._findfirsti64', (('int', None), ('void *', 'ptr')) ),
    'plt__findnext':( 'int', None, 'cdecl', '*._findnext', (('int', None), ('void *', 'ptr')) ),
    'plt__findnext64':( 'int', None, 'cdecl', '*._findnext64', (('int', None), ('void *', 'ptr')) ),
    'plt__findnexti64':( 'int', None, 'cdecl', '*._findnexti64', (('int', None), ('void *', 'ptr')) ),
    'plt__finite':( 'int', None, 'cdecl', '*._finite', (('int', None), ('int', None)) ),
    'plt__flsbuf':( 'int', None, 'cdecl', '*._flsbuf', (('int', None), ('void *', 'ptr')) ),
    'plt__flushall':( 'int', None, 'cdecl', '*._flushall', () ),
    'plt__fmode':( 'int', None, 'cdecl', '*._fmode', () ),
    'plt__fpclass':( 'int', None, 'cdecl', '*._fpclass', (('int', None), ('int', None)) ),
    'plt__fpieee_flt':( 'int', None, 'cdecl', '*._fpieee_flt', (('int', None),) ),
    'plt__fpreset':( 'int', None, 'cdecl', '*._fpreset', () ),
    'plt__fputchar':( 'int', None, 'cdecl', '*._fputchar', (('int', None),) ),
    'plt__fputwchar':( 'int', None, 'cdecl', '*._fputwchar', (('int', None),) ),
    'plt__fsopen':( 'int', None, 'cdecl', '*._fsopen', (('StringA', None), ('int', None), ('int', None)) ),
    'plt__fstat':( 'int', None, 'cdecl', '*._fstat', (('int', None), ('int', None)) ),
    'plt__fstat64':( 'int', None, 'cdecl', '*._fstat64', (('int', None), ('int', None)) ),
    'plt__fstati64':( 'int', None, 'cdecl', '*._fstati64', (('int', None), ('int', None)) ),
    'plt__ftime':( 'int', None, 'cdecl', '*._ftime', (('int', None),) ),
    'plt__ftime64':( 'int', None, 'cdecl', '*._ftime64', (('int', None),) ),
    'plt__ftol':( 'int', None, 'cdecl', '*._ftol', () ),
    'plt__fullpath':( 'int', None, 'cdecl', '*._fullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__futime':( 'int', None, 'cdecl', '*._futime', (('int', None), ('void *', 'ptr')) ),
    'plt__futime64':( 'int', None, 'cdecl', '*._futime64', (('int', None), ('void *', 'ptr')) ),
    'plt__gcvt':( 'int', None, 'cdecl', '*._gcvt', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'plt__get_heap_handle':( 'int', None, 'cdecl', '*._get_heap_handle', () ),
    'plt__get_osfhandle':( 'int', None, 'cdecl', '*._get_osfhandle', (('int', None),) ),
    'plt__get_sbh_threshold':( 'int', None, 'cdecl', '*._get_sbh_threshold', () ),
    'plt__getch':( 'int', None, 'cdecl', '*._getch', () ),
    'plt__getche':( 'int', None, 'cdecl', '*._getche', () ),
    'plt__getcwd':( 'int', None, 'cdecl', '*._getcwd', (('void *', 'ptr'), ('int', None)) ),
    'plt__getdcwd':( 'int', None, 'cdecl', '*._getdcwd', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__getdiskfree':( 'int', None, 'cdecl', '*._getdiskfree', (('int', None), ('int', None)) ),
    'plt__getdllprocaddr':( 'int', None, 'cdecl', '*._getdllprocaddr', (('HMODULE', None), ('StringA', None), ('int', None)) ),
    'plt__getdrive':( 'int', None, 'cdecl', '*._getdrive', () ),
    'plt__getdrives':( 'int', None, 'stdcall', '*._getdrives', () ),
    'plt__getmaxstdio':( 'int', None, 'cdecl', '*._getmaxstdio', () ),
    'plt__getmbcp':( 'int', None, 'cdecl', '*._getmbcp', () ),
    'plt__getpid':( 'int', None, 'stdcall', '*._getpid', () ),
    'plt__getsystime':( 'int', None, 'cdecl', '*._getsystime', (('int', None),) ),
    'plt__getw':( 'int', None, 'cdecl', '*._getw', (('int', None),) ),
    'plt__getwch':( 'int', None, 'cdecl', '*._getwch', () ),
    'plt__getwche':( 'int', None, 'cdecl', '*._getwche', () ),
    'plt__getws':( 'int', None, 'cdecl', '*._getws', (('int', None),) ),
    'plt__global_unwind2':( 'int', None, 'cdecl', '*._global_unwind2', (('int', None),) ),
    'plt__gmtime64':( 'int', None, 'cdecl', '*._gmtime64', (('void *', 'ptr'),) ),
    'plt__heapadd':( 'int', None, 'cdecl', '*._heapadd', () ),
    'plt__heapchk':( 'int', None, 'cdecl', '*._heapchk', () ),
    'plt__heapmin':( 'int', None, 'cdecl', '*._heapmin', () ),
    'plt__heapset':( 'int', None, 'cdecl', '*._heapset', () ),
    'plt__heapused':( 'int', None, 'cdecl', '*._heapused', () ),
    'plt__heapwalk':( 'int', None, 'cdecl', '*._heapwalk', (('int', None),) ),
    'plt__hypot':( 'int', None, 'cdecl', '*._hypot', () ),
    'plt__i64toa':( 'int', None, 'msfastcall', '*._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__i64tow':( 'int', None, 'msfastcall', '*._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__initterm':( 'int', None, 'cdecl', '*._initterm', (('int', None), ('int', None)) ),
    'plt__inp':( 'int', None, 'cdecl', '*._inp', (('int', None),) ),
    'plt__inpd':( 'int', None, 'cdecl', '*._inpd', (('int', None),) ),
    'plt__inpw':( 'int', None, 'cdecl', '*._inpw', (('int', None),) ),
    'plt__iob':( 'int', None, 'bfastcall', '*._iob', (('int', None),) ),
    'plt__isatty':( 'int', None, 'cdecl', '*._isatty', (('int', None),) ),
    'plt__isctype':( 'int', None, 'cdecl', '*._isctype', (('int', None), ('int', None)) ),
    'plt__ismbbalnum':( 'int', None, 'cdecl', '*._ismbbalnum', (('int', None),) ),
    'plt__ismbbalpha':( 'int', None, 'cdecl', '*._ismbbalpha', (('int', None),) ),
    'plt__ismbbgraph':( 'int', None, 'cdecl', '*._ismbbgraph', (('int', None),) ),
    'plt__ismbbkalnum':( 'int', None, 'cdecl', '*._ismbbkalnum', (('int', None),) ),
    'plt__ismbbkana':( 'int', None, 'cdecl', '*._ismbbkana', (('int', None),) ),
    'plt__ismbbkprint':( 'int', None, 'cdecl', '*._ismbbkprint', (('int', None),) ),
    'plt__ismbbkpunct':( 'int', None, 'cdecl', '*._ismbbkpunct', (('int', None),) ),
    'plt__ismbblead':( 'int', None, 'cdecl', '*._ismbblead', (('int', None),) ),
    'plt__ismbbprint':( 'int', None, 'cdecl', '*._ismbbprint', (('int', None),) ),
    'plt__ismbbpunct':( 'int', None, 'cdecl', '*._ismbbpunct', (('int', None),) ),
    'plt__ismbbtrail':( 'int', None, 'cdecl', '*._ismbbtrail', (('int', None),) ),
    'plt__ismbcalnum':( 'int', None, 'cdecl', '*._ismbcalnum', (('int', None),) ),
    'plt__ismbcalpha':( 'int', None, 'cdecl', '*._ismbcalpha', (('int', None),) ),
    'plt__ismbcdigit':( 'int', None, 'cdecl', '*._ismbcdigit', (('int', None),) ),
    'plt__ismbcgraph':( 'int', None, 'cdecl', '*._ismbcgraph', (('int', None),) ),
    'plt__ismbchira':( 'int', None, 'cdecl', '*._ismbchira', (('int', None),) ),
    'plt__ismbckata':( 'int', None, 'cdecl', '*._ismbckata', (('int', None),) ),
    'plt__ismbcl0':( 'int', None, 'cdecl', '*._ismbcl0', (('int', None),) ),
    'plt__ismbcl1':( 'int', None, 'cdecl', '*._ismbcl1', (('int', None),) ),
    'plt__ismbcl2':( 'int', None, 'cdecl', '*._ismbcl2', (('int', None),) ),
    'plt__ismbclegal':( 'int', None, 'cdecl', '*._ismbclegal', (('int', None),) ),
    'plt__ismbclower':( 'int', None, 'cdecl', '*._ismbclower', (('int', None),) ),
    'plt__ismbcprint':( 'int', None, 'cdecl', '*._ismbcprint', (('int', None),) ),
    'plt__ismbcpunct':( 'int', None, 'cdecl', '*._ismbcpunct', (('int', None),) ),
    'plt__ismbcspace':( 'int', None, 'cdecl', '*._ismbcspace', (('int', None),) ),
    'plt__ismbcsymbol':( 'int', None, 'cdecl', '*._ismbcsymbol', (('int', None),) ),
    'plt__ismbcupper':( 'int', None, 'cdecl', '*._ismbcupper', (('int', None),) ),
    'plt__ismbslead':( 'int', None, 'cdecl', '*._ismbslead', (('int', None), ('int', None)) ),
    'plt__ismbstrail':( 'int', None, 'cdecl', '*._ismbstrail', (('int', None), ('int', None)) ),
    'plt__isnan':( 'int', None, 'cdecl', '*._isnan', (('int', None), ('int', None)) ),
    'plt__itoa':( 'int', None, 'cdecl', '*._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__itow':( 'int', None, 'cdecl', '*._itow', (('int', None), ('int', None), ('int', None)) ),
    'plt__j0':( 'int', None, 'cdecl', '*._j0', () ),
    'plt__j1':( 'int', None, 'cdecl', '*._j1', () ),
    'plt__jn':( 'int', None, 'cdecl', '*._jn', (('int', None),) ),
    'plt__kbhit':( 'int', None, 'cdecl', '*._kbhit', () ),
    'plt__lfind':( 'int', None, 'cdecl', '*._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'plt__loaddll':( 'int', None, 'cdecl', '*._loaddll', (('FileNameA', None),) ),
    'plt__local_unwind2':( 'int', None, 'cdecl', '*._local_unwind2', (('void *', 'ptr'), ('int', None)) ),
    'plt__localtime64':( 'int', None, 'cdecl', '*._localtime64', (('void *', 'ptr'),) ),
    'plt__lock':( 'int', None, 'cdecl', '*._lock', (('int', None),) ),
    'plt__locking':( 'int', None, 'cdecl', '*._locking', (('int', None), ('int', None), ('int', None)) ),
    'plt__logb':( 'int', None, 'cdecl', '*._logb', (('int', None), ('int', None)) ),
    'plt__longjmpex':( 'int', None, 'cdecl', '*._longjmpex', (('int', None), ('int', None)) ),
    'plt__lrotl':( 'int', None, 'cdecl', '*._lrotl', (('int', None), ('int', None)) ),
    'plt__lrotr':( 'int', None, 'cdecl', '*._lrotr', (('int', None), ('int', None)) ),
    'plt__lsearch':( 'int', None, 'cdecl', '*._lsearch', (('void *', 'key'), ('void *', 'base'), ('int', 'nmemb'), ('int', 'size'), ('void *', 'cmpptr')) ),
    'plt__lseek':( 'int', None, 'cdecl', '*._lseek', (('int', None), ('int', None), ('int', None)) ),
    'plt__lseeki64':( 'int', None, 'cdecl', '*._lseeki64', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__ltoa':( 'int', None, 'cdecl', '*._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'plt__ltow':( 'int', None, 'cdecl', '*._ltow', (('int', None), ('int', None), ('int', None)) ),
    'plt__makepath':( 'int', None, 'cdecl', '*._makepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__mbbtombc':( 'int', None, 'cdecl', '*._mbbtombc', (('int', None),) ),
    'plt__mbbtype':( 'int', None, 'cdecl', '*._mbbtype', (('int', None), ('int', None)) ),
    'plt__mbcasemap':( 'int', None, 'cdecl', '*._mbcasemap', () ),
    'plt__mbccpy':( 'int', None, 'cdecl', '*._mbccpy', (('int', None), ('int', None)) ),
    'plt__mbcjistojms':( 'int', None, 'cdecl', '*._mbcjistojms', (('int', None),) ),
    'plt__mbcjmstojis':( 'int', None, 'cdecl', '*._mbcjmstojis', (('int', None),) ),
    'plt__mbclen':( 'int', None, 'cdecl', '*._mbclen', (('int', None),) ),
    'plt__mbctohira':( 'int', None, 'cdecl', '*._mbctohira', (('int', None),) ),
    'plt__mbctokata':( 'int', None, 'cdecl', '*._mbctokata', (('int', None),) ),
    'plt__mbctolower':( 'int', None, 'cdecl', '*._mbctolower', (('int', None),) ),
    'plt__mbctombb':( 'int', None, 'cdecl', '*._mbctombb', (('int', None),) ),
    'plt__mbctoupper':( 'int', None, 'cdecl', '*._mbctoupper', (('int', None),) ),
    'plt__mbctype':( 'int', None, 'cdecl', '*._mbctype', () ),
    'plt__mbsbtype':( 'int', None, 'cdecl', '*._mbsbtype', (('int', None), ('int', None)) ),
    'plt__mbscat':( 'int', None, 'cdecl', '*._mbscat', (('void *', 'mbstr1'), ('void *', 'mbstr2')) ),
    'plt__mbschr':( 'int', None, 'cdecl', '*._mbschr', (('int', None), ('int', None)) ),
    'plt__mbscmp':( 'int', None, 'cdecl', '*._mbscmp', (('int', None), ('int', None)) ),
    'plt__mbscoll':( 'int', None, 'cdecl', '*._mbscoll', (('void *', 'mbstr1'), ('void *', 'mbstr2')) ),
    'plt__mbscpy':( 'int', None, 'cdecl', '*._mbscpy', (('void *', 'mbstr1'), ('void *', 'mbstr2')) ),
    'plt__mbscspn':( 'int', None, 'cdecl', '*._mbscspn', (('int', None), ('int', None)) ),
    'plt__mbsdec':( 'int', None, 'cdecl', '*._mbsdec', (('int', None), ('int', None)) ),
    'plt__mbsdup':( 'int', None, 'cdecl', '*._mbsdup', (('void *', 'ptr'),) ),
    'plt__mbsicmp':( 'int', None, 'cdecl', '*._mbsicmp', (('void *', 'mbstr1'), ('void *', 'mbstr2')) ),
    'plt__mbsicoll':( 'int', None, 'cdecl', '*._mbsicoll', (('void *', 'mbstr1'), ('void *', 'mbstr2')) ),
    'plt__mbsinc':( 'int', None, 'cdecl', '*._mbsinc', (('int', None),) ),
    'plt__mbslen':( 'int', None, 'cdecl', '*._mbslen', (('int', None),) ),
    'plt__mbslwr':( 'int', None, 'cdecl', '*._mbslwr', (('void *', 'ptr'),) ),
    'plt__mbsnbcat':( 'int', None, 'cdecl', '*._mbsnbcat', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsnbcmp':( 'int', None, 'cdecl', '*._mbsnbcmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsnbcnt':( 'int', None, 'cdecl', '*._mbsnbcnt', (('int', None), ('int', None)) ),
    'plt__mbsnbcoll':( 'int', None, 'cdecl', '*._mbsnbcoll', (('void *', 'mbstr1'), ('void *', 'mbstr2'), ('int', 'count')) ),
    'plt__mbsnbcpy':( 'int', None, 'cdecl', '*._mbsnbcpy', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__mbsnbicmp':( 'int', None, 'cdecl', '*._mbsnbicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsnbicoll':( 'int', None, 'cdecl', '*._mbsnbicoll', (('void *', 'mbstr1'), ('void *', 'mbstr2'), ('int', 'count')) ),
    'plt__mbsnbset':( 'int', None, 'cdecl', '*._mbsnbset', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsncat':( 'int', None, 'cdecl', '*._mbsncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__mbsnccnt':( 'int', None, 'cdecl', '*._mbsnccnt', (('int', None), ('int', None)) ),
    'plt__mbsncmp':( 'int', None, 'cdecl', '*._mbsncmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsncoll':( 'int', None, 'cdecl', '*._mbsncoll', (('void *', 'mbstr1'), ('void *', 'mbstr2'), ('int', 'count')) ),
    'plt__mbsncpy':( 'int', None, 'cdecl', '*._mbsncpy', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__mbsnextc':( 'int', None, 'cdecl', '*._mbsnextc', (('int', None),) ),
    'plt__mbsnicmp':( 'int', None, 'cdecl', '*._mbsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbsnicoll':( 'int', None, 'cdecl', '*._mbsnicoll', (('void *', 'mbstr1'), ('void *', 'mbstr2'), ('int', 'count')) ),
    'plt__mbsninc':( 'int', None, 'cdecl', '*._mbsninc', (('int', None), ('int', None)) ),
    'plt__mbsnset':( 'int', None, 'cdecl', '*._mbsnset', (('int', None), ('int', None), ('int', None)) ),
    'plt__mbspbrk':( 'int', None, 'cdecl', '*._mbspbrk', (('int', None), ('int', None)) ),
    'plt__mbsrchr':( 'int', None, 'cdecl', '*._mbsrchr', (('int', None), ('int', None)) ),
    'plt__mbsrev':( 'int', None, 'cdecl', '*._mbsrev', (('int', None),) ),
    'plt__mbsset':( 'int', None, 'cdecl', '*._mbsset', (('int', None), ('int', None)) ),
    'plt__mbsspn':( 'int', None, 'cdecl', '*._mbsspn', (('int', None), ('int', None)) ),
    'plt__mbsspnp':( 'int', None, 'cdecl', '*._mbsspnp', (('int', None), ('int', None)) ),
    'plt__mbsstr':( 'int', None, 'cdecl', '*._mbsstr', (('void *', 'mbstr1'), ('void *', 'mbstrkey')) ),
    'plt__mbstok':( 'int', None, 'cdecl', '*._mbstok', (('int', None), ('int', None)) ),
    'plt__mbstrlen':( 'int', None, 'cdecl', '*._mbstrlen', (('int', None),) ),
    'plt__mbsupr':( 'int', None, 'cdecl', '*._mbsupr', (('void *', 'ptr'),) ),
    'plt__memccpy':( 'int', None, 'cdecl', '*._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__memicmp':( 'int', None, 'cdecl', '*._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__mkdir':( 'int', None, 'cdecl', '*._mkdir', (('StringA', None),) ),
    'plt__mktemp':( 'int', None, 'cdecl', '*._mktemp', (('void *', 'ptr'),) ),
    'plt__mktime64':( 'int', None, 'cdecl', '*._mktime64', (('int', None),) ),
    'plt__msize':( 'int', None, 'cdecl', '*._msize', (('int', None),) ),
    'plt__nextafter':( 'int', None, 'cdecl', '*._nextafter', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__onexit':( 'int', None, 'cdecl', '*._onexit', (('int', None),) ),
    'plt__open':( 'int', None, 'cdecl', '*._open', (('StringA', None), ('int', None), ('int', None)) ),
    'plt__open_osfhandle':( 'int', None, 'cdecl', '*._open_osfhandle', (('int', None), ('int', None)) ),
    'plt__osplatform':( 'int', None, 'cdecl', '*._osplatform', () ),
    'plt__osver':( 'int', None, 'cdecl', '*._osver', () ),
    'plt__outp':( 'int', None, 'cdecl', '*._outp', (('int', None), ('int', None)) ),
    'plt__outpd':( 'int', None, 'cdecl', '*._outpd', (('int', None), ('int', None)) ),
    'plt__outpw':( 'int', None, 'cdecl', '*._outpw', (('int', None), ('int', None)) ),
    'plt__pclose':( 'int', None, 'cdecl', '*._pclose', (('int', None),) ),
    'plt__pctype':( 'int', None, 'cdecl', '*._pctype', () ),
    'plt__pgmptr':( 'int', None, 'cdecl', '*._pgmptr', () ),
    'plt__pipe':( 'int', None, 'cdecl', '*._pipe', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__popen':( 'int', None, 'cdecl', '*._popen', (('void *', 'ptr'), ('int', None)) ),
    'plt__purecall':( 'int', None, 'cdecl', '*._purecall', () ),
    'plt__putch':( 'int', None, 'cdecl', '*._putch', (('int', None),) ),
    'plt__putenv':( 'int', None, 'cdecl', '*._putenv', (('void *', 'ptr'),) ),
    'plt__putw':( 'int', None, 'cdecl', '*._putw', (('int', None), ('void *', 'ptr')) ),
    'plt__putwch':( 'int', None, 'cdecl', '*._putwch', (('int', None),) ),
    'plt__putws':( 'int', None, 'cdecl', '*._putws', (('int', None),) ),
    'plt__pwctype':( 'int', None, 'cdecl', '*._pwctype', () ),
    'plt__read':( 'int', None, 'cdecl', '*._read', (('int', None), ('StringA', None), ('DWORD', None)) ),
    'plt__resetstkoflw':( 'int', None, 'cdecl', '*._resetstkoflw', () ),
    'plt__rmdir':( 'int', None, 'cdecl', '*._rmdir', (('int', None),) ),
    'plt__rmtmp':( 'int', None, 'cdecl', '*._rmtmp', () ),
    'plt__rotl':( 'int', None, 'cdecl', '*._rotl', (('int', None), ('int', None)) ),
    'plt__rotr':( 'int', None, 'cdecl', '*._rotr', (('int', None), ('int', None)) ),
    'plt__safe_fdiv':( 'int', None, 'cdecl', '*._safe_fdiv', () ),
    'plt__safe_fdivr':( 'int', None, 'cdecl', '*._safe_fdivr', () ),
    'plt__safe_fprem':( 'int', None, 'cdecl', '*._safe_fprem', () ),
    'plt__safe_fprem1':( 'int', None, 'cdecl', '*._safe_fprem1', () ),
    'plt__scalb':( 'int', None, 'cdecl', '*._scalb', (('int', None), ('int', None), ('int', None)) ),
    'plt__scprintf':( 'int', None, 'cdecl', '*._scprintf', (('int', None),) ),
    'plt__scwprintf':( 'int', None, 'cdecl', '*._scwprintf', (('int', None),) ),
    'plt__searchenv':( 'int', None, 'cdecl', '*._searchenv', (('void *', 'name'), ('void *', 'env_var'), ('void *', 'buffer')) ),
    'plt__seh_longjmp_unwind':( 'int', None, 'stdcall', '*._seh_longjmp_unwind', (('int', None),) ),
    'plt__set_sse2_enable':( 'int', None, 'cdecl', '*._set_SSE2_enable', (('int', None),) ),
    'plt__set_error_mode':( 'int', None, 'cdecl', '*._set_error_mode', (('int', None),) ),
    'plt__set_purecall_handler':( 'int', None, 'cdecl', '*._set_purecall_handler', (('int', None),) ),
    'plt__set_sbh_threshold':( 'int', None, 'cdecl', '*._set_sbh_threshold', (('int', None),) ),
    'plt__set_security_error_handler':( 'int', None, 'cdecl', '*._set_security_error_handler', (('int', None),) ),
    'plt__seterrormode':( 'int', None, 'cdecl', '*._seterrormode', (('int', None),) ),
    'plt__setjmp':( 'int', None, 'cdecl', '*._setjmp', (('int', None),) ),
    'plt__setjmp3':( 'int', None, 'cdecl', '*._setjmp3', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__setmaxstdio':( 'int', None, 'cdecl', '*._setmaxstdio', (('int', None),) ),
    'plt__setmbcp':( 'int', None, 'cdecl', '*._setmbcp', (('int', None),) ),
    'plt__setmode':( 'int', None, 'cdecl', '*._setmode', (('int', None), ('int', None)) ),
    'plt__setsystime':( 'int', None, 'cdecl', '*._setsystime', (('int', None), ('int', None)) ),
    'plt__sleep':( 'int', None, 'cdecl', '*._sleep', (('int', None),) ),
    'plt__snprintf':( 'int', None, 'cdecl', '*._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt__snscanf':( 'int', None, 'cdecl', '*._snscanf', (('int', None), ('int', None), ('int', None)) ),
    'plt__snwprintf':( 'int', None, 'cdecl', '*._snwprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt__snwscanf':( 'int', None, 'cdecl', '*._snwscanf', (('int', None), ('int', None), ('int', None)) ),
    'plt__sopen':( 'int', None, 'cdecl', '*._sopen', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__spawnl':( 'int', None, 'cdecl', '*._spawnl', (('int', None), ('void *', 'obj')) ),
    'plt__spawnle':( 'int', None, 'cdecl', '*._spawnle', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'plt__spawnlp':( 'int', None, 'cdecl', '*._spawnlp', (('int', None), ('void *', 'obj')) ),
    'plt__spawnlpe':( 'int', None, 'cdecl', '*._spawnlpe', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'plt__spawnv':( 'int', None, 'cdecl', '*._spawnv', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'plt__spawnve':( 'int', None, 'cdecl', '*._spawnve', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'plt__spawnvp':( 'int', None, 'cdecl', '*._spawnvp', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'plt__spawnvpe':( 'int', None, 'cdecl', '*._spawnvpe', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'plt__splitpath':( 'int', None, 'cdecl', '*._splitpath', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__stat':( 'int', None, 'cdecl', '*._stat', (('int', None), ('int', None)) ),
    'plt__stat64':( 'int', None, 'cdecl', '*._stat64', (('int', None), ('int', None)) ),
    'plt__stati64':( 'int', None, 'cdecl', '*._stati64', (('int', None), ('int', None)) ),
    'plt__statusfp':( 'int', None, 'cdecl', '*._statusfp', () ),
    'plt__strcmpi':( 'int', None, 'cdecl', '*._strcmpi', (('int', None), ('void *', 'ptr')) ),
    'plt__strdate':( 'int', None, 'cdecl', '*._strdate', (('int', None),) ),
    'plt__strdup':( 'int', None, 'cdecl', '*._strdup', (('void *', 'ptr'),) ),
    'plt__strerror':( 'int', None, 'cdecl', '*._strerror', (('int', None),) ),
    'plt__stricmp':( 'int', None, 'cdecl', '*._stricmp', (('int', None), ('void *', 'ptr')) ),
    'plt__stricoll':( 'int', None, 'cdecl', '*._stricoll', (('void *', 'str1'), ('void *', 'str2')) ),
    'plt__strlwr':( 'int', None, 'cdecl', '*._strlwr', (('void *', 'ptr'),) ),
    'plt__strncoll':( 'int', None, 'cdecl', '*._strncoll', (('void *', 'str1'), ('void *', 'str2'), ('int', None)) ),
    'plt__strnicmp':( 'int', None, 'cdecl', '*._strnicmp', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__strnicoll':( 'int', None, 'cdecl', '*._strnicoll', (('void *', 'str1'), ('void *', 'str2'), ('int', None)) ),
    'plt__strnset':( 'int', None, 'cdecl', '*._strnset', (('int', None), ('int', None), ('int', None)) ),
    'plt__strrev':( 'int', None, 'cdecl', '*._strrev', (('int', None),) ),
    'plt__strset':( 'int', None, 'cdecl', '*._strset', (('int', None), ('int', None)) ),
    'plt__strtime':( 'int', None, 'cdecl', '*._strtime', (('int', None),) ),
    'plt__strtoi64':( 'int', None, 'cdecl', '*._strtoi64', (('int', None), ('int', None), ('int', None)) ),
    'plt__strtoui64':( 'int', None, 'cdecl', '*._strtoui64', (('int', None), ('int', None), ('int', None)) ),
    'plt__strupr':( 'int', None, 'cdecl', '*._strupr', (('void *', 'ptr'),) ),
    'plt__swab':( 'int', None, 'cdecl', '*._swab', (('int', None), ('int', None), ('int', None)) ),
    'plt__sys_errlist':( 'int', None, 'cdecl', '*._sys_errlist', () ),
    'plt__sys_nerr':( 'int', None, 'bfastcall', '*._sys_nerr', (('int', None),) ),
    'plt__tell':( 'int', None, 'cdecl', '*._tell', (('int', None),) ),
    'plt__telli64':( 'int', None, 'cdecl', '*._telli64', (('int', None),) ),
    'plt__tempnam':( 'int', None, 'cdecl', '*._tempnam', (('void *', 'dir'), ('void *', 'pfx')) ),
    'plt__time64':( 'int', None, 'cdecl', '*._time64', (('void *', 'ptr'),) ),
    'plt__timezone':( 'int', None, 'bfastcall', '*._timezone', (('int', None),) ),
    'plt__tolower':( 'int', None, 'cdecl', '*._tolower', (('int', None),) ),
    'plt__toupper':( 'int', None, 'cdecl', '*._toupper', (('int', None),) ),
    'plt__tzname':( 'int', None, 'cdecl', '*._tzname', () ),
    'plt__tzset':( 'int', None, 'cdecl', '*._tzset', () ),
    'plt__ui64toa':( 'int', None, 'msfastcall', '*._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__ui64tow':( 'int', None, 'msfastcall', '*._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__ultoa':( 'int', None, 'cdecl', '*._ultoa', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'plt__ultow':( 'int', None, 'cdecl', '*._ultow', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt__umask':( 'int', None, 'cdecl', '*._umask', (('int', None),) ),
    'plt__ungetch':( 'int', None, 'cdecl', '*._ungetch', (('int', None),) ),
    'plt__ungetwch':( 'int', None, 'cdecl', '*._ungetwch', (('int', None),) ),
    'plt__unlink':( 'int', None, 'cdecl', '*._unlink', (('int', None),) ),
    'plt__unloaddll':( 'int', None, 'cdecl', '*._unloaddll', (('int', None),) ),
    'plt__unlock':( 'int', None, 'cdecl', '*._unlock', (('int', None),) ),
    'plt__utime':( 'int', None, 'cdecl', '*._utime', (('StringA', None), ('void *', 'ptr')) ),
    'plt__utime64':( 'int', None, 'cdecl', '*._utime64', (('StringA', None), ('void *', 'ptr')) ),
    'plt__vscprintf':( 'int', None, 'cdecl', '*._vscprintf', (('int', None), ('int', None)) ),
    'plt__vscwprintf':( 'int', None, 'cdecl', '*._vscwprintf', (('int', None), ('int', None)) ),
    'plt__vsnprintf':( 'int', None, 'cdecl', '*._vsnprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__vsnwprintf':( 'int', None, 'cdecl', '*._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__waccess':( 'int', None, 'cdecl', '*._waccess', (('void *', 'ptr'), ('int', None)) ),
    'plt__wasctime':( 'int', None, 'cdecl', '*._wasctime', (('int', None),) ),
    'plt__wchdir':( 'int', None, 'cdecl', '*._wchdir', (('int', None),) ),
    'plt__wchmod':( 'int', None, 'cdecl', '*._wchmod', (('int', None), ('int', None)) ),
    'plt__wcmdln':( 'int', None, 'cdecl', '*._wcmdln', () ),
    'plt__wcreat':( 'int', None, 'cdecl', '*._wcreat', (('StringW', None), ('int', None)) ),
    'plt__wcsdup':( 'int', None, 'cdecl', '*._wcsdup', (('int', None),) ),
    'plt__wcserror':( 'int', None, 'cdecl', '*._wcserror', (('int', None),) ),
    'plt__wcsicmp':( 'int', None, 'cdecl', '*._wcsicmp', (('int', None), ('int', None)) ),
    'plt__wcsicoll':( 'int', None, 'cdecl', '*._wcsicoll', (('int', None), ('int', None)) ),
    'plt__wcslwr':( 'int', None, 'cdecl', '*._wcslwr', (('int', None),) ),
    'plt__wcsncoll':( 'int', None, 'cdecl', '*._wcsncoll', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcsnicmp':( 'int', None, 'cdecl', '*._wcsnicmp', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcsnicoll':( 'int', None, 'cdecl', '*._wcsnicoll', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcsnset':( 'int', None, 'cdecl', '*._wcsnset', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcsrev':( 'int', None, 'cdecl', '*._wcsrev', (('int', None),) ),
    'plt__wcsset':( 'int', None, 'cdecl', '*._wcsset', (('int', None), ('int', None)) ),
    'plt__wcstoi64':( 'int', None, 'cdecl', '*._wcstoi64', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcstoui64':( 'int', None, 'cdecl', '*._wcstoui64', (('int', None), ('int', None), ('int', None)) ),
    'plt__wcsupr':( 'int', None, 'cdecl', '*._wcsupr', (('int', None),) ),
    'plt__wctime':( 'int', None, 'cdecl', '*._wctime', (('void *', 'ptr'),) ),
    'plt__wctime64':( 'int', None, 'cdecl', '*._wctime64', (('void *', 'ptr'),) ),
    'plt__wctype':( 'int', None, 'cdecl', '*._wctype', () ),
    'plt__wenviron':( 'int', None, 'cdecl', '*._wenviron', () ),
    'plt__wexecl':( 'int', None, 'cdecl', '*._wexecl', () ),
    'plt__wexecle':( 'int', None, 'cdecl', '*._wexecle', ( ('int', None), ('int', None)) ),
    'plt__wexeclp':( 'int', None, 'cdecl', '*._wexeclp', () ),
    'plt__wexeclpe':( 'int', None, 'cdecl', '*._wexeclpe', ( ('int', None), ('int', None)) ),
    'plt__wexecv':( 'int', None, 'cdecl', '*._wexecv', ( ('int', None),) ),
    'plt__wexecve':( 'int', None, 'cdecl', '*._wexecve', ( ('int', None), ('int', None)) ),
    'plt__wexecvp':( 'int', None, 'cdecl', '*._wexecvp', ( ('int', None),) ),
    'plt__wexecvpe':( 'int', None, 'cdecl', '*._wexecvpe', ( ('int', None), ('int', None)) ),
    'plt__wfdopen':( 'int', None, 'cdecl', '*._wfdopen', (('int', None), ('int', None)) ),
    'plt__wfindfirst':( 'int', None, 'cdecl', '*._wfindfirst', (('int', None), ('int', None)) ),
    'plt__wfindfirst64':( 'int', None, 'cdecl', '*._wfindfirst64', (('int', None), ('int', None)) ),
    'plt__wfindfirsti64':( 'int', None, 'cdecl', '*._wfindfirsti64', (('int', None), ('int', None)) ),
    'plt__wfindnext':( 'int', None, 'cdecl', '*._wfindnext', (('int', None), ('int', None)) ),
    'plt__wfindnext64':( 'int', None, 'cdecl', '*._wfindnext64', (('int', None), ('int', None)) ),
    'plt__wfindnexti64':( 'int', None, 'cdecl', '*._wfindnexti64', (('int', None), ('int', None)) ),
    'plt__wfopen':( 'int', None, 'cdecl', '*._wfopen', (('StringW', None), ('int', None)) ),
    'plt__wfreopen':( 'int', None, 'cdecl', '*._wfreopen', (('StringW', None), ('int', None), ('int', None)) ),
    'plt__wfsopen':( 'int', None, 'cdecl', '*._wfsopen', (('StringW', None), ('int', None), ('int', None)) ),
    'plt__wfullpath':( 'int', None, 'cdecl', '*._wfullpath', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt__wgetcwd':( 'int', None, 'cdecl', '*._wgetcwd', (('int', None), ('int', None)) ),
    'plt__wgetdcwd':( 'int', None, 'cdecl', '*._wgetdcwd', (('int', None), ('int', None), ('int', None)) ),
    'plt__wgetenv':( 'int', None, 'cdecl', '*._wgetenv', (('int', None),) ),
    'plt__winmajor':( 'int', None, 'cdecl', '*._winmajor', () ),
    'plt__winminor':( 'int', None, 'cdecl', '*._winminor', () ),
    'plt__winver':( 'int', None, 'cdecl', '*._winver', () ),
    'plt__wmakepath':( 'int', None, 'cdecl', '*._wmakepath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__wmkdir':( 'int', None, 'cdecl', '*._wmkdir', (('StringW', None),) ),
    'plt__wmktemp':( 'int', None, 'cdecl', '*._wmktemp', (('void *', 'ptr'),) ),
    'plt__wopen':( 'int', None, 'cdecl', '*._wopen', (('StringW', None), ('int', None), ('int', None)) ),
    'plt__wperror':( 'int', None, 'cdecl', '*._wperror', (('void *', 'ptr'),) ),
    'plt__wpgmptr':( 'int', None, 'cdecl', '*._wpgmptr', () ),
    'plt__wpopen':( 'int', None, 'cdecl', '*._wpopen', (('void *', 'ptr'), ('int', None)) ),
    'plt__wputenv':( 'int', None, 'cdecl', '*._wputenv', (('void *', 'ptr'),) ),
    'plt__wremove':( 'int', None, 'cdecl', '*._wremove', (('int', None),) ),
    'plt__wrename':( 'int', None, 'cdecl', '*._wrename', (('int', None), ('int', None)) ),
    'plt__write':( 'int', None, 'cdecl', '*._write', (('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'plt__wrmdir':( 'int', None, 'cdecl', '*._wrmdir', (('int', None),) ),
    'plt__wsearchenv':( 'int', None, 'cdecl', '*._wsearchenv', (('void *', 'filename'), ('void *', 'varname'), ('void *', 'size')) ),
    'plt__wsetlocale':( 'int', None, 'cdecl', '*._wsetlocale', (('int', None), ('void *', 'ptr')) ),
    'plt__wsopen':( 'int', None, 'cdecl', '*._wsopen', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__wspawnl':( 'int', None, 'cdecl', '*._wspawnl', (('int', None), ('void *', 'obj')) ),
    'plt__wspawnle':( 'int', None, 'cdecl', '*._wspawnle', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'plt__wspawnlp':( 'int', None, 'cdecl', '*._wspawnlp', (('int', None), ('void *', 'obj')) ),
    'plt__wspawnlpe':( 'int', None, 'cdecl', '*._wspawnlpe', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'plt__wspawnv':( 'int', None, 'cdecl', '*._wspawnv', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'plt__wspawnve':( 'int', None, 'cdecl', '*._wspawnve', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'plt__wspawnvp':( 'int', None, 'cdecl', '*._wspawnvp', (('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'plt__wspawnvpe':( 'int', None, 'cdecl', '*._wspawnvpe', (('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'plt__wsplitpath':( 'int', None, 'cdecl', '*._wsplitpath', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt__wstat':( 'int', None, 'cdecl', '*._wstat', (('int', None), ('int', None)) ),
    'plt__wstat64':( 'int', None, 'cdecl', '*._wstat64', (('int', None), ('int', None)) ),
    'plt__wstati64':( 'int', None, 'cdecl', '*._wstati64', (('int', None), ('int', None)) ),
    'plt__wstrdate':( 'int', None, 'cdecl', '*._wstrdate', (('int', None),) ),
    'plt__wstrtime':( 'int', None, 'cdecl', '*._wstrtime', (('int', None),) ),
    'plt__wsystem':( 'int', None, 'cdecl', '*._wsystem', (('int', None),) ),
    'plt__wtempnam':( 'int', None, 'cdecl', '*._wtempnam', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'plt__wtmpnam':( 'int', None, 'cdecl', '*._wtmpnam', (('int', None),) ),
    'plt__wtof':( 'int', None, 'cdecl', '*._wtof', (('void *', 'ptr'),) ),
    'plt__wtoi':( 'int', None, 'cdecl', '*._wtoi', (('int', None),) ),
    'plt__wtoi64':( 'int', None, 'cdecl', '*._wtoi64', (('int', None),) ),
    'plt__wtol':( 'int', None, 'cdecl', '*._wtol', (('int', None),) ),
    'plt__wunlink':( 'int', None, 'cdecl', '*._wunlink', (('int', None),) ),
    'plt__wutime':( 'int', None, 'cdecl', '*._wutime', (('StringW', None), ('void *', 'ptr')) ),
    'plt__wutime64':( 'int', None, 'cdecl', '*._wutime64', (('StringW', None), ('void *', 'ptr')) ),
    'plt__y0':( 'int', None, 'cdecl', '*._y0', () ),
    'plt__y1':( 'int', None, 'cdecl', '*._y1', () ),
    'plt__yn':( 'int', None, 'cdecl', '*._yn', () ),
    'plt_abort':( 'int', None, 'stdcall', '*.abort', () ),
    'plt_abs':( 'int', None, 'cdecl', '*.abs', (('int', None),) ),
    'plt_acos':( 'int', None, 'cdecl', '*.acos', () ),
    'plt_asctime':( 'int', None, 'cdecl', '*.asctime', (('int', None),) ),
    'plt_asin':( 'int', None, 'cdecl', '*.asin', () ),
    'plt_atan':( 'int', None, 'cdecl', '*.atan', () ),
    'plt_atan2':( 'int', None, 'cdecl', '*.atan2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_atexit':( 'int', None, 'cdecl', '*.atexit', (('int', None),) ),
    'plt_atof':( 'int', None, 'cdecl', '*.atof', (('void *', 'ptr'),) ),
    'plt_atoi':( 'int', None, 'cdecl', '*.atoi', (('int', None),) ),
    'plt_atol':( 'int', None, 'cdecl', '*.atol', (('void *', 'ptr'),) ),
    'plt_bsearch':( 'int', None, 'cdecl', '*.bsearch', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'plt_calloc':( 'int', None, 'cdecl', '*.calloc', (('int', None), ('int', None)) ),
    'plt_ceil':( 'int', None, 'cdecl', '*.ceil', () ),
    'plt_clearerr':( 'int', None, 'cdecl', '*.clearerr', (('int', None),) ),
    'plt_clock':( 'int', None, 'msfastcall', '*.clock', (('int', None), ('int', None)) ),
    'plt_cos':( 'int', None, 'cdecl', '*.cos', () ),
    'plt_cosh':( 'int', None, 'cdecl', '*.cosh', (('int', None), ('int', None)) ),
    'plt_ctime':( 'int', None, 'cdecl', '*.ctime', (('void *', 'ptr'),) ),
    'plt_difftime':( 'int', None, 'cdecl', '*.difftime', (('int', None), ('int', None)) ),
    'plt_div':( 'int', None, 'cdecl', '*.div', (('int', None), ('int', None)) ),
    'plt_exit':( 'int', None, 'cdecl', '*.exit', (('int', None),) ),
    'plt_exp':( 'int', None, 'cdecl', '*.exp', (('int', None), ('int', None)) ),
    'plt_fabs':( 'int', None, 'cdecl', '*.fabs', (('int', None), ('int', None)) ),
    'plt_fclose':( 'int', None, 'cdecl', '*.fclose', (('int', None),) ),
    'plt_feof':( 'int', None, 'cdecl', '*.feof', (('int', None),) ),
    'plt_ferror':( 'int', None, 'cdecl', '*.ferror', (('int', None),) ),
    'plt_fflush':( 'int', None, 'cdecl', '*.fflush', (('int', None),) ),
    'plt_fgetc':( 'int', None, 'cdecl', '*.fgetc', (('int', None),) ),
    'plt_fgetpos':( 'int', None, 'cdecl', '*.fgetpos', (('int', None), ('int', None)) ),
    'plt_fgets':( 'int', None, 'cdecl', '*.fgets', (('int', None), ('int', None), ('int', None)) ),
    'plt_fgetwc':( 'int', None, 'cdecl', '*.fgetwc', (('int', None),) ),
    'plt_fgetws':( 'int', None, 'cdecl', '*.fgetws', (('int', None), ('int', None), ('int', None)) ),
    'plt_floor':( 'int', None, 'cdecl', '*.floor', () ),
    'plt_fmod':( 'int', None, 'cdecl', '*.fmod', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_fopen':( 'int', None, 'cdecl', '*.fopen', (('StringA', None), ('int', None)) ),
    'plt_fprintf':( 'int', None, 'cdecl', '*.fprintf', (('void *', 'ptr'), ('int', None)) ),
    'plt_fputc':( 'int', None, 'cdecl', '*.fputc', (('int', None), ('void *', 'ptr')) ),
    'plt_fputs':( 'int', None, 'cdecl', '*.fputs', (('void *', 'ptr'), ('int', None)) ),
    'plt_fputwc':( 'int', None, 'cdecl', '*.fputwc', (('int', None), ('int', None)) ),
    'plt_fputws':( 'int', None, 'cdecl', '*.fputws', (('int', None), ('int', None)) ),
    'plt_fread':( 'int', None, 'cdecl', '*.fread', (('StringA', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_free':( 'int', None, 'cdecl', '*.free', (('void *', 'ptr'),) ),
    'plt_freopen':( 'int', None, 'cdecl', '*.freopen', (('StringA', None), ('int', None), ('int', None)) ),
    'plt_frexp':( 'int', None, 'cdecl', '*.frexp', () ),
    'plt_fscanf':( 'int', None, 'cdecl', '*.fscanf', (('void *', 'ptr'), ('int', None)) ),
    'plt_fseek':( 'int', None, 'cdecl', '*.fseek', (('int', None), ('int', None), ('int', None)) ),
    'plt_fsetpos':( 'int', None, 'cdecl', '*.fsetpos', (('int', None), ('int', None)) ),
    'plt_ftell':( 'int', None, 'cdecl', '*.ftell', (('int', None),) ),
    'plt_fwprintf':( 'int', None, 'cdecl', '*.fwprintf', (('void *', 'ptr'), ('int', None)) ),
    'plt_fwrite':( 'int', None, 'cdecl', '*.fwrite', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'plt_fwscanf':( 'int', None, 'cdecl', '*.fwscanf', (('void *', 'ptr'), ('int', None)) ),
    'plt_getc':( 'int', None, 'cdecl', '*.getc', (('int', None),) ),
    'plt_getchar':( 'int', None, 'cdecl', '*.getchar', () ),
    'plt_getenv':( 'int', None, 'cdecl', '*.getenv', (('void *', 'ptr'),) ),
    'plt_gets':( 'int', None, 'cdecl', '*.gets', (('int', None),) ),
    'plt_getwc':( 'int', None, 'cdecl', '*.getwc', (('int', None),) ),
    'plt_getwchar':( 'int', None, 'cdecl', '*.getwchar', () ),
    'plt_gmtime':( 'int', None, 'cdecl', '*.gmtime', (('void *', 'ptr'),) ),
    'plt_is_wctype':( 'int', None, 'cdecl', '*.is_wctype', (('int', None), ('int', None)) ),
    'plt_isalnum':( 'int', None, 'cdecl', '*.isalnum', (('int', None),) ),
    'plt_isalpha':( 'int', None, 'cdecl', '*.isalpha', (('int', None),) ),
    'plt_iscntrl':( 'int', None, 'cdecl', '*.iscntrl', (('int', None),) ),
    'plt_isdigit':( 'int', None, 'cdecl', '*.isdigit', (('int', None),) ),
    'plt_isgraph':( 'int', None, 'cdecl', '*.isgraph', (('int', None),) ),
    'plt_isleadbyte':( 'int', None, 'cdecl', '*.isleadbyte', (('int', None),) ),
    'plt_islower':( 'int', None, 'cdecl', '*.islower', (('int', None),) ),
    'plt_isprint':( 'int', None, 'cdecl', '*.isprint', (('int', None),) ),
    'plt_ispunct':( 'int', None, 'cdecl', '*.ispunct', (('int', None),) ),
    'plt_isspace':( 'int', None, 'cdecl', '*.isspace', (('int', None),) ),
    'plt_isupper':( 'int', None, 'cdecl', '*.isupper', (('int', None),) ),
    'plt_iswalnum':( 'int', None, 'cdecl', '*.iswalnum', (('int', None),) ),
    'plt_iswalpha':( 'int', None, 'cdecl', '*.iswalpha', (('int', None),) ),
    'plt_iswascii':( 'int', None, 'cdecl', '*.iswascii', (('int', None),) ),
    'plt_iswcntrl':( 'int', None, 'cdecl', '*.iswcntrl', (('int', None),) ),
    'plt_iswctype':( 'int', None, 'cdecl', '*.iswctype', (('int', None), ('int', None)) ),
    'plt_iswdigit':( 'int', None, 'cdecl', '*.iswdigit', (('int', None),) ),
    'plt_iswgraph':( 'int', None, 'cdecl', '*.iswgraph', (('int', None),) ),
    'plt_iswlower':( 'int', None, 'cdecl', '*.iswlower', (('int', None),) ),
    'plt_iswprint':( 'int', None, 'cdecl', '*.iswprint', (('int', None),) ),
    'plt_iswpunct':( 'int', None, 'cdecl', '*.iswpunct', (('int', None),) ),
    'plt_iswspace':( 'int', None, 'cdecl', '*.iswspace', (('int', None),) ),
    'plt_iswupper':( 'int', None, 'cdecl', '*.iswupper', (('int', None),) ),
    'plt_iswxdigit':( 'int', None, 'cdecl', '*.iswxdigit', (('int', None),) ),
    'plt_isxdigit':( 'int', None, 'cdecl', '*.isxdigit', (('int', None),) ),
    'plt_labs':( 'int', None, 'cdecl', '*.labs', (('int', None),) ),
    'plt_ldexp':( 'int', None, 'cdecl', '*.ldexp', (('int', None), ('int', None)) ),
    'plt_ldiv':( 'int', None, 'cdecl', '*.ldiv', (('int', None), ('int', None)) ),
    'plt_localeconv':( 'int', None, 'cdecl', '*.localeconv', () ),
    'plt_localtime':( 'int', None, 'cdecl', '*.localtime', (('void *', 'ptr'),) ),
    'plt_log':( 'int', None, 'cdecl', '*.log', () ),
    'plt_log10':( 'int', None, 'cdecl', '*.log10', () ),
    'plt_longjmp':( 'int', None, 'cdecl', '*.longjmp', (('int', None), ('int', None)) ),
    'plt_malloc':( 'int', None, 'cdecl', '*.malloc', (('DWORD', None),) ),
    'plt_mblen':( 'int', None, 'cdecl', '*.mblen', (('int', None), ('int', None)) ),
    'plt_mbstowcs':( 'int', None, 'cdecl', '*.mbstowcs', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt_mbtowc':( 'int', None, 'cdecl', '*.mbtowc', (('void *', 'dst'), ('void *', 'src'), ('int', 'max')) ),
    'plt_memchr':( 'int', None, 'cdecl', '*.memchr', (('int', None), ('int', None), ('int', None)) ),
    'plt_memcmp':( 'int', None, 'cdecl', '*.memcmp', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_memcpy':( 'int', None, 'cdecl', '*.memcpy', (('void *', 'dst'), ('void *', 'src'), ('int', 'count')) ),
    'plt_memmove':( 'int', None, 'cdecl', '*.memmove', (('void *', 'dst'), ('void *', 'src'), ('int', 'count')) ),
    'plt_memset':( 'int', None, 'cdecl', '*.memset', (('void *', 'ptr'), ('int', 'char'), ('int', None)) ),
    'plt_mktime':( 'int', None, 'cdecl', '*.mktime', (('int', None),) ),
    'plt_modf':( 'int', None, 'cdecl', '*.modf', (('int', None), ('int', None)) ),
    'plt_perror':( 'int', None, 'cdecl', '*.perror', (('void *', 'ptr'),) ),
    'plt_pow':( 'int', None, 'cdecl', '*.pow', () ),
    'plt_printf':( 'int', None, 'cdecl', '*.printf', (('int', None),) ),
    'plt_putc':( 'int', None, 'cdecl', '*.putc', (('int', None), ('void *', 'ptr')) ),
    'plt_putchar':( 'int', None, 'cdecl', '*.putchar', (('int', None),) ),
    'plt_puts':( 'int', None, 'cdecl', '*.puts', (('void *', 'ptr'),) ),
    'plt_putwc':( 'int', None, 'cdecl', '*.putwc', (('int', None), ('int', None)) ),
    'plt_putwchar':( 'int', None, 'cdecl', '*.putwchar', (('int', None),) ),
    'plt_qsort':( 'int', None, 'stdcall', '*.qsort', ( ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_raise':( 'int', None, 'cdecl', '*.raise', (('int', None),) ),
    'plt_rand':( 'int', None, 'cdecl', '*.rand', () ),
    'plt_realloc':( 'int', None, 'cdecl', '*.realloc', (('void *', 'ptr'), ('DWORD', None)) ),
    'plt_remove':( 'int', None, 'cdecl', '*.remove', (('int', None),) ),
    'plt_rename':( 'int', None, 'cdecl', '*.rename', (('int', None), ('int', None)) ),
    'plt_rewind':( 'int', None, 'cdecl', '*.rewind', (('int', None),) ),
    'plt_scanf':( 'int', None, 'cdecl', '*.scanf', (('int', None),) ),
    'plt_setbuf':( 'int', None, 'cdecl', '*.setbuf', (('int', None), ('int', None)) ),
    'plt_setlocale':( 'int', None, 'cdecl', '*.setlocale', (('int', None), ('void *', 'obj')) ),
    'plt_setvbuf':( 'int', None, 'cdecl', '*.setvbuf', (('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'plt_signal':( 'int', None, 'cdecl', '*.signal', (('int', None), ('int', None)) ),
    'plt_sin':( 'int', None, 'cdecl', '*.sin', () ),
    'plt_sinh':( 'int', None, 'cdecl', '*.sinh', (('int', None), ('int', None)) ),
    'plt_sprintf':( 'int', None, 'cdecl', '*.sprintf', (('int', None), ('int', None)) ),
    'plt_sqrt':( 'int', None, 'cdecl', '*.sqrt', () ),
    'plt_srand':( 'int', None, 'cdecl', '*.srand', (('int', None),) ),
    'plt_sscanf':( 'int', None, 'cdecl', '*.sscanf', (('void *', 'ptr'), ('int', None)) ),
    'plt_strcat':( 'int', None, 'cdecl', '*.strcat', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'plt_strchr':( 'int', None, 'cdecl', '*.strchr', (('int', None), ('int', None)) ),
    'plt_strcmp':( 'int', None, 'cdecl', '*.strcmp', (('void *', 'ptr'), ('int', None)) ),
    'plt_strcoll':( 'int', None, 'cdecl', '*.strcoll', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'plt_strcpy':( 'int', None, 'cdecl', '*.strcpy', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'plt_strcspn':( 'int', None, 'cdecl', '*.strcspn', (('int', None), ('int', None)) ),
    'plt_strerror':( 'int', None, 'cdecl', '*.strerror', (('int', None),) ),
    'plt_strftime':( 'int', None, 'cdecl', '*.strftime', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'plt_strlen':( 'int', None, 'cdecl', '*.strlen', (('void *', 'ptr'),) ),
    'plt_strncat':( 'int', None, 'cdecl', '*.strncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_strncmp':( 'int', None, 'cdecl', '*.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'plt_strncpy':( 'int', None, 'cdecl', '*.strncpy', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'plt_strpbrk':( 'int', None, 'cdecl', '*.strpbrk', (('int', None), ('int', None)) ),
    'plt_strrchr':( 'int', None, 'cdecl', '*.strrchr', (('int', None), ('int', None)) ),
    'plt_strspn':( 'int', None, 'cdecl', '*.strspn', (('int', None), ('int', None)) ),
    'plt_strstr':( 'int', None, 'cdecl', '*.strstr', (('int', None), ('void *', 'ptr')) ),
    'plt_strtod':( 'int', None, 'cdecl', '*.strtod', (('void *', 'ptr'), ('int', None)) ),
    'plt_strtok':( 'int', None, 'cdecl', '*.strtok', (('int', None), ('int', None)) ),
    'plt_strtol':( 'int', None, 'cdecl', '*.strtol', (('int', None), ('int', None), ('int', None)) ),
    'plt_strtoul':( 'int', None, 'cdecl', '*.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'plt_strxfrm':( 'int', None, 'cdecl', '*.strxfrm', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'plt_swprintf':( 'int', None, 'cdecl', '*.swprintf', (('int', None), ('int', None)) ),
    'plt_swscanf':( 'int', None, 'cdecl', '*.swscanf', (('int', None), ('int', None)) ),
    'plt_system':( 'int', None, 'cdecl', '*.system', (('int', None),) ),
    'plt_tan':( 'int', None, 'cdecl', '*.tan', () ),
    'plt_tanh':( 'int', None, 'cdecl', '*.tanh', (('int', None), ('int', None)) ),
    'plt_time':( 'int', None, 'cdecl', '*.time', (('void *', 'ptr'),) ),
    'plt_tmpfile':( 'int', None, 'cdecl', '*.tmpfile', () ),
    'plt_tmpnam':( 'int', None, 'cdecl', '*.tmpnam', (('void *', 'ptr'),) ),
    'plt_tolower':( 'int', None, 'cdecl', '*.tolower', (('int', None),) ),
    'plt_toupper':( 'int', None, 'cdecl', '*.toupper', (('int', None),) ),
    'plt_towlower':( 'int', None, 'cdecl', '*.towlower', (('int', None),) ),
    'plt_towupper':( 'int', None, 'cdecl', '*.towupper', (('int', None),) ),
    'plt_ungetc':( 'int', None, 'cdecl', '*.ungetc', (('int', None), ('int', None)) ),
    'plt_ungetwc':( 'int', None, 'cdecl', '*.ungetwc', (('int', None), ('int', None)) ),
    'plt_vfprintf':( 'int', None, 'cdecl', '*.vfprintf', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_vfwprintf':( 'int', None, 'cdecl', '*.vfwprintf', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_vprintf':( 'int', None, 'cdecl', '*.vprintf', (('int', None), ('int', None)) ),
    'plt_vsprintf':( 'int', None, 'cdecl', '*.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt_vswprintf':( 'int', None, 'cdecl', '*.vswprintf', (('int', None), ('int', None), ('int', None)) ),
    'plt_vwprintf':( 'int', None, 'cdecl', '*.vwprintf', (('int', None), ('int', None)) ),
    'plt_wcscat':( 'int', None, 'cdecl', '*.wcscat', (('int', None), ('int', None)) ),
    'plt_wcschr':( 'int', None, 'cdecl', '*.wcschr', (('int', None), ('int', None)) ),
    'plt_wcscmp':( 'int', None, 'cdecl', '*.wcscmp', (('int', None), ('int', None)) ),
    'plt_wcscoll':( 'int', None, 'cdecl', '*.wcscoll', (('int', None), ('int', None)) ),
    'plt_wcscpy':( 'int', None, 'cdecl', '*.wcscpy', (('int', None), ('void *', 'ptr')) ),
    'plt_wcscspn':( 'int', None, 'cdecl', '*.wcscspn', (('int', None), ('int', None)) ),
    'plt_wcsftime':( 'int', None, 'cdecl', '*.wcsftime', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'plt_wcslen':( 'int', None, 'cdecl', '*.wcslen', (('void *', 'ptr'),) ),
    'plt_wcsncat':( 'int', None, 'cdecl', '*.wcsncat', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcsncmp':( 'int', None, 'cdecl', '*.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcsncpy':( 'int', None, 'cdecl', '*.wcsncpy', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcspbrk':( 'int', None, 'cdecl', '*.wcspbrk', (('int', None), ('int', None)) ),
    'plt_wcsrchr':( 'int', None, 'cdecl', '*.wcsrchr', (('int', None), ('int', None)) ),
    'plt_wcsspn':( 'int', None, 'cdecl', '*.wcsspn', (('int', None), ('int', None)) ),
    'plt_wcsstr':( 'int', None, 'cdecl', '*.wcsstr', (('int', None), ('int', None)) ),
    'plt_wcstod':( 'int', None, 'cdecl', '*.wcstod', (('void *', 'ptr'), ('int', None)) ),
    'plt_wcstok':( 'int', None, 'cdecl', '*.wcstok', (('int', None), ('int', None)) ),
    'plt_wcstol':( 'int', None, 'cdecl', '*.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcstombs':( 'int', None, 'cdecl', '*.wcstombs', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'plt_wcstoul':( 'int', None, 'cdecl', '*.wcstoul', (('int', None), ('int', None), ('int', None)) ),
    'plt_wcsxfrm':( 'int', None, 'cdecl', '*.wcsxfrm', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'plt_wctomb':( 'int', None, 'cdecl', '*.wctomb', (('void *', 'ptr'), ('int', None)) ),
    'plt_wprintf':( 'int', None, 'cdecl', '*.wprintf', (('int', None),) ),
    'plt_wscanf':( 'int', None, 'cdecl', '*.wscanf', (('int', None),) ),
    'plt___ctype_b_loc':( 'int', None, 'cdecl', '*.__ctype_b_loc', () ),

} # END
