from tkinter import *
from tkdev import (window_popup, window_custom_taskbar, WS_EX_TOOLWINDOW, CreateWindowEx, WS_VISIBLE, WS_EX_APPWINDOW,
                   DevToplevel, DevWindow, window_border,
                   SetWindowLong, GetParent, GWL_STYLE, ShowWindow, SW_SHOW, SW_HIDE, window_sizebox)
from typing import Literal


class DevPreTooltip(Toplevel):
    def __init__(self, widget: Widget, window: Tk, message: str = "", after: int = 500, border: bool = True, side=CENTER,
                 background="#ffffff", foreground="#000000"):
        super(DevPreTooltip, self).__init__()
        self.configure(background=background, relief=RAISED, border=1)
        if border:
            window_border(self)
        if not border:
            self.overrideredirect(True)

        self.withdraw()

        self.side = side

        self.widget = widget
        self.widget.bind("<Enter>", lambda evt: self.show(evt.x_root, evt.y_root))
        self.widget.bind("<Motion>", lambda evt: self.show(evt.x_root, evt.y_root))
        self.widget.bind("<Leave>", lambda evt: self.hide())
        self.widget.bind("<ButtonPress>", lambda evt: self.hide())
        self.window = window

        self.message = StringVar()
        self.message.set(message)

        self.after = after
        self.on = False

        Message(self, textvariable=self.message, background=background, foreground=foreground).grid()

    def show(self, x, y):
        self.on = True

        self.attributes("-topmost", True)
        if self.side == LEFT:
            self.geometry(f"+{x - int(self.winfo_width())}+{y + 10}")
        if self.side == CENTER:
            self.geometry(f"+{x - int(self.winfo_width() / 2)}+{y + 10}")
        if self.side == RIGHT:
            self.geometry(f"+{x}+{y + 10}")
        self.update()
        self.deiconify()

    def hide(self):
        self.on = False
        self.attributes("-topmost", False)
        self.window.attributes("-topmost", True)
        self.withdraw()
        self.window.after(1000, lambda: self.window.attributes("-topmost", False))


class DevPreToolbox(DevToplevel):
    def __init__(self, master: Tk, title: str = "ToolBox"):
        super(DevPreToolbox, self).__init__()
        from tkdev import window_move, window_border
        from tkinter import ttk

        self.geometry("355x450")
        self.title = Label(self, text=title, background="#fcfcfc")
        self.title.pack(fill=X, side=TOP)

        window_move(self.title, self)
        window_border(self)
        self.Title_Button = ttk.Button(self, text="修改标题", command=self.set_title)
        self.Title_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Topmost_Button = ttk.Button(self, text="置顶", command=self.set_topmost)
        self.Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.No_Topmost_Button = ttk.Button(self, text="取消置顶", command=self.set_no_topmost)
        self.No_Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Light_Button = ttk.Button(self, text="云母特效-浅色", command=self.mica_light)
        self.Mica_Light_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Dark_Button = ttk.Button(self, text="云母特效-深色", command=self.mica_dark)
        self.Mica_Dark_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Close_Button = ttk.Button(self, text="关闭窗口", command=self.master.destroy)
        self.Close_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.master = master

    def set_title(self):
        from tkinter import simpledialog
        title = simpledialog.askstring("输入标题", "请设置窗口的标题")
        self.master.title(title)

    def set_topmost(self):
        self.master.attributes("-topmost", True)

    def set_no_topmost(self):
        self.master.attributes("-topmost", False)

    def mica_light(self):
        from tkdev import window_mica_light
        window_mica_light(self.master)
        self.master.configure(background="#ffffff")

    def mica_dark(self):
        from tkdev import window_mica_dark
        window_mica_dark(self.master)
        self.master.configure(background="#000000")

    def show(self):
        self.mainloop()


if __name__ == '__main__':
    Window = DevWindow()
    Window.title("Hello")
    Tooltip = DevPreTooltip(Window, Window, message="asdassssssssssssssssssdasd")
    Window.mainloop()
