![Pecos](documentation/figures/logo.png)
=========================================

[![TravisCI](https://travis-ci.org/sandialabs/pecos.svg?branch=master)](https://travis-ci.org/sandialabs/pecos)
[![Coverage Status](https://coveralls.io/repos/github/sandialabs/pecos/badge.svg?branch=master)](https://coveralls.io/github/sandialabs/pecos?branch=master)
[![Documentation Status](https://readthedocs.org/projects/pecos/badge/?version=stable)](https://pecos.readthedocs.io/en/stable/?badge=stable)
[![Downloads](https://pepy.tech/badge/pecos)](https://pepy.tech/project/pecos)

Advances in sensor technology have rapidly increased our ability to monitor 
natural and human-made physical systems. In many cases, it is critical to 
process the resulting large volumes of data on a regular schedule and alert 
system operators when the system has changed. Automated quality control and 
performance monitoring can allow system operators to quickly detect performance 
issues.  

Pecos is an open source Python package designed to address this need. Pecos 
includes built-in functionality to monitor performance of time series data, 
subject to a series of quality control tests. The Python package includes 
methods to run quality control tests defined by the user and generate reports 
which include performance metrics, test results, and graphics. The software was 
developed specifically for solar photovoltaic system monitoring, but is 
designed to be used for a wide range of applications. 

For more information, go to http://pecos.readthedocs.io

Citing Pecos
--------------
To cite Pecos, use one of the following references:

* K.A. Klise and J.S. Stein (2016), Performance Monitoring using Pecos, Technical Report SAND2016-3583, Sandia National Laboratories. 
* K.A. Klise and J.S. Stein (2016), Automated Performance Monitoring for PV Systems using Pecos, 43rd IEEE Photovoltaic Specialists Conference (PVSC), Portland, OR, June 5-10. 

License
------------

Revised BSD.  See the LICENSE.txt file.

Organization
------------

Directories
  * pecos - Python package
  * documentation - User manual
  * examples - Examples
  * ci - Software requirements

Contact
-------
   * Katherine Klise, Sandia National Laboratories, kaklise@sandia.gov
   * Joshua Stein, Sandia National Laboratories, jsstein@sandia.gov

Sandia National Laboratories is a multimission laboratory managed and operated 
by National Technology and Engineering Solutions of Sandia, LLC., a wholly 
owned subsidiary of Honeywell International, Inc., for the U.S. Department of 
Energy's National Nuclear Security Administration under contract DE-NA-0003525.
