#!/usr/bin/env python3
# -*- coding:utf-8 -*-
# @Author:      thepoy
# @Email:       thepoy@163.com
# @File Name:   paragraph.pyi
# @Created At:  2023-03-20 15:59:18
# @Modified At: 2023-03-20 16:30:05
# @Modified By: thepoy

from typing import Any, Self
from lxml.etree import ElementBase as Element
from docx.enum.text import WD_PARAGRAPH_ALIGNMENT

from docx.styles.style import ParagraphStyle
from docx.text.parfmt import ParagraphFormat
from ..shared import Parented
from .run import Run

class Paragraph(Parented):
    def __init__(self, p: Element, parent: Any) -> None: ...
    def add_run(
        self, text: str | None = ..., style: ParagraphStyle | None = ...
    ) -> Run: ...
    @property
    def alignment(self) -> WD_PARAGRAPH_ALIGNMENT: ...
    @alignment.setter
    def alignment(self, value: WD_PARAGRAPH_ALIGNMENT) -> None: ...
    def clear(self) -> Self: ...
    def insert_paragraph_before(
        self, text: str | None = ..., style: ParagraphStyle | None = ...
    ) -> Paragraph: ...
    @property
    def paragraph_format(self) -> ParagraphFormat: ...
    @property
    def runs(self) -> list[Run]: ...
    @property
    def style(self) -> ParagraphStyle: ...
    @style.setter
    def style(self, style_or_name: ParagraphStyle | str) -> None: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...
    def _insert_paragraph_before(self) -> Paragraph: ...
