/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.io.BytesInputStream;
import com.sas.io.Cp1047Encoder;
import com.sas.io.EncoderInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;

public class Encoder
implements EncoderInterface {
    protected BytesInputStream iStream;
    protected ByteArrayOutputStream oStream;
    protected InputStreamReader reader;
    protected OutputStreamWriter writer;
    protected String encoding;
    protected char[] byteByffer;
    protected char[] charBuffer;
    private char[] charArray;
    private static final int MAX_POOL_SIZE = 64;
    public static boolean DEBUG = false;
    protected static final String EmptyString = "";
    private byte[] byteArray;
    protected static Vector encoders = new Vector();
    static final byte[] AA = new byte[]{65, -63};
    private static Boolean needsCp1047Patch = null;

    public Encoder(String encoding) throws UnsupportedEncodingException {
        this.setEncoding(encoding);
    }

    public Encoder() {
        try {
            this.setEncoding(null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected void createReader() throws UnsupportedEncodingException {
        String enc;
        if (this.iStream == null) {
            this.iStream = new BytesInputStream(null);
        }
        if ((enc = this.getEncoding()) == null) {
            this.reader = new InputStreamReader(this.iStream);
        } else {
            if (enc.equals("ISO8859_1")) {
                enc = "8859_1";
            }
            this.reader = new InputStreamReader((InputStream)this.iStream, enc);
        }
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected void createWriter() throws UnsupportedEncodingException {
        String enc;
        if (this.oStream == null) {
            this.oStream = new ByteArrayOutputStream();
        }
        if ((enc = this.getEncoding()) == null) {
            this.writer = new OutputStreamWriter(this.oStream);
        } else {
            if (enc.equals("ISO8859_1")) {
                enc = "8859_1";
            }
            this.writer = new OutputStreamWriter((OutputStream)this.oStream, enc);
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
        this.createReader();
        this.createWriter();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public final String toString(byte[] bytes) {
        return this.toString(bytes, 0, bytes.length);
    }

    @Override
    public synchronized String toString(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return EmptyString;
        }
        try {
            int nChars = this.encode(bytes, offset, length);
            String string = new String(this.charBuffer, 0, nChars);
            if (this.charBuffer.length >= 0x100000) {
                this.charBuffer = null;
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected int encode(byte[] bytes, int offset, int length) throws IOException {
        this.iStream.setBytes(bytes, offset, length);
        Reader reader = this.getReader();
        this.ensureBuffer(length);
        length = reader.read(this.charBuffer, 0, length);
        return length;
    }

    public final char[] toCharArray(byte[] bytes) {
        return this.toCharArray(bytes, 0, bytes.length);
    }

    @Override
    public synchronized char[] toCharArray(byte[] bytes, int offset, int length) {
        try {
            int nChars = this.encode(bytes, offset, length);
            char[] charArray = new char[nChars];
            System.arraycopy(this.charBuffer, 0, charArray, 0, nChars);
            return charArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    public final byte[] toByteArray(String string) {
        return this.toByteArray(string, 0, string.length());
    }

    @Override
    public final synchronized byte[] toByteArray(String string, int offset, int length) {
        this.ensureBuffer(length);
        string.getChars(offset, offset + length, this.charBuffer, 0);
        byte[] bytes = this.toByteArray(this.charBuffer, 0, length);
        return bytes;
    }

    protected void ensureBuffer(int size) {
        if (this.charBuffer == null || this.charBuffer.length < size) {
            this.charBuffer = new char[size];
        }
    }

    public final byte[] toByteArray(char[] chars) {
        return this.toByteArray(chars, 0, chars.length);
    }

    @Override
    public synchronized byte[] toByteArray(char[] chars, int offset, int length) {
        Writer writer = this.getWriter();
        this.oStream.reset();
        try {
            writer.write(chars, offset, length);
            writer.flush();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return this.oStream.toByteArray();
    }

    @Override
    public byte[] getByteArray(int nBytes) {
        if (this.byteArray == null || this.byteArray.length <= nBytes) {
            this.byteArray = new byte[nBytes];
        }
        return this.byteArray;
    }

    public char[] getCharArray(int nChars) {
        if (this.charArray == null || this.charArray.length <= nChars) {
            this.charArray = new char[nChars];
        }
        return this.charArray;
    }

    public static final String readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        return Encoder.readUTF(in, utflen);
    }

    public static final String readUTF(DataInput in, int utflen) throws IOException {
        if (utflen == 0) {
            return EmptyString;
        }
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = in.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            UTFDataFormatException e = new UTFDataFormatException(EmptyString + (byte)c);
            throw e;
        }
        String s = new String(str, 0, strlen);
        return s;
    }

    public static void writeUTF(String string, DataOutputStream stream) throws IOException {
        string = string == null ? EmptyString : string;
        stream.writeUTF(string);
    }

    public static void writeUTF32(String string, DataOutputStream stream) throws IOException {
        string = string == null ? EmptyString : string;
        stream.writeInt(Encoder.utfByteCount(string));
        Encoder.writeUTFData(string, stream);
    }

    public static int utfByteCount(String string) {
        int utfLength = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        return utfLength;
    }

    public static void writeUTFData(String string, DataOutputStream stream) throws IOException {
        string = string == null ? EmptyString : string;
        int length = string.length();
        int utfLength = Encoder.utfByteCount(string);
        if (utfLength > 65535) {
            throw new UTFDataFormatException();
        }
        if (length == utfLength) {
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                stream.write(c);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    stream.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    stream.write(0xE0 | c >> 12 & 0xF);
                    stream.write(0x80 | c >> 6 & 0x3F);
                    stream.write(0x80 | c & 0x3F);
                    continue;
                }
                stream.write(0xC0 | c >> 6 & 0x1F);
                stream.write(0x80 | c & 0x3F);
            }
        }
    }

    public void reset() {
        this.charArray = null;
        this.reader = null;
        this.writer = null;
        this.iStream = null;
        this.oStream = null;
        try {
            this.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncoderInterface getInstance(String encoding) throws UnsupportedEncodingException {
        if (DEBUG) {
            System.out.println("_DEBUG_:Looking for encoder " + encoding);
        }
        Vector vector = encoders;
        synchronized (vector) {
            int encodersLen = encoders.size();
            for (int i = 0; i < encodersLen; ++i) {
                EncoderInterface enc = (EncoderInterface)encoders.elementAt(i);
                if (encoding == null || !encoding.equals(enc.getEncoding())) continue;
                encoders.removeElementAt(i);
                if (DEBUG) {
                    System.out.println("_DEBUG_:Found encoder in pool");
                }
                return enc;
            }
            EncoderInterface encoder = encoding.equalsIgnoreCase("cp1047") && Encoder.needsCp1047Patch() ? new Cp1047Encoder() : new Encoder(encoding);
            if (DEBUG) {
                System.out.println("_DEBUG_:Creating new encoder " + encoder.getClass().getName());
            }
            return encoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnInstance(EncoderInterface encoder) {
        if (DEBUG) {
            System.out.println("_DEBUG_:Returning encoder to pool: " + encoder.getEncoding());
        }
        Vector vector = encoders;
        synchronized (vector) {
            if (encoders.size() < 64) {
                try {
                    Encoder enc = (Encoder)encoder;
                    enc.charBuffer = null;
                    try {
                        if (enc.reader.ready()) {
                            enc.reset();
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                encoders.addElement(encoder);
            } else if (DEBUG) {
                System.out.println("_DEBUG_:No room in pool; discarding encoder");
            }
        }
    }

    public static boolean isValid(String encoding) {
        try {
            if (encoding.equals("Cp1047") && Encoder.needsCp1047Patch()) {
                return true;
            }
            String s = new String(AA, encoding);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public String toString() {
        return this.encoding;
    }

    public boolean equals(Encoder enc) {
        if (enc == null) {
            return false;
        }
        return enc.getEncoding().equals(this.getEncoding());
    }

    public boolean equals(Object object) {
        if (object instanceof Encoder) {
            return this.equals((Encoder)object);
        }
        return false;
    }

    public int hashCode() {
        return this.encoding != null ? this.encoding.hashCode() : 0;
    }

    private static boolean needsCp1047Patch() {
        if (needsCp1047Patch == null) {
            needsCp1047Patch = Boolean.TRUE;
            try {
                if (new String(AA, "Cp1047").charAt(1) == 'A') {
                    needsCp1047Patch = Boolean.FALSE;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return needsCp1047Patch;
    }
}

