/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.LoggerFactory;
import com.sas.services.connection.Request;

@SASScope
public final class ConnectionFactoryRequest
extends Request {
    private ConnectionFactoryManager _manager;
    private ConnectionFactoryConfiguration _originalConfiguration;

    private ConnectionFactoryRequest(ConnectionFactoryManager manager, ConnectionFactoryConfiguration cxfConfig) {
        this.setManager(manager);
        this.setOriginalConfiguration(cxfConfig);
        String msgPrefix = ConnectionFactoryRequest.formatMessagePrefix(manager);
        this.setMessagePrefix(msgPrefix);
    }

    public static ConnectionFactoryRequest wrap(ConnectionFactoryManager manager, ConnectionFactoryConfiguration originalConfiguration) {
        ConnectionFactoryRequest cxfReq = new ConnectionFactoryRequest(manager, originalConfiguration);
        return cxfReq;
    }

    public ConnectionFactoryManager getManager() {
        return this._manager;
    }

    public ConnectionFactoryConfiguration getOriginalConfiguration() {
        return this._originalConfiguration;
    }

    public String toString() {
        String[][] nvPairArr = new String[][]{{"config", this._originalConfiguration.toString()}};
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }

    private void setManager(ConnectionFactoryManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this._manager = manager;
    }

    private void setOriginalConfiguration(ConnectionFactoryConfiguration originalConfiguration) {
        if (originalConfiguration == null) {
            throw new IllegalArgumentException("originalConfiguration cannot be null");
        }
        this._originalConfiguration = originalConfiguration;
    }

    private static String formatMessagePrefix(ConnectionFactoryManager manager) {
        long managerID = manager.getManagerID();
        long requestID = manager.assignRequestID();
        String msgPrefix = LoggerFactory.formatOrderedPair('m', managerID, 'g', requestID);
        return msgPrefix;
    }
}

