"""
________________________________________________________________________

:PROJECT: lara-django

*lara-django base settings*

:details: Django settings for lara project.
    Generated by 'django-admin startproject' using Django 2.0.6.
    For more information on this file, see
    https://docs.djangoproject.com/en/2.1/topics/settings/

    For the full list of settings and their values, see
    https://docs.djangoproject.com/en/2.1/ref/settings/

:authors: mark doerr (mark@uni-greifswald.de)

:date: (creation)          20180623
:date: (last modification) 20180626

.. note:: -
.. todo:: -
________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.1.6"

import os
import sys
from configparser import ConfigParser, NoSectionError, NoOptionError

USER_HOME_DIR = os.environ.get('HOME')

# config_file = os.path.join(USER_HOME_DIR, '.config', 'lara-suite', 'lara-django', 'lara-django.conf')
#
# try:
#     lara_config = ConfigParser()
#     lara_config.read(config_file)
#
#     DB_PATH = lara_config['database']['DB_PATH']
#     DJANGO_MEDIA_PATH = lara_config['media']['DJANGO_MEDIA_PATH']
#     DJANGO_STATIC_PATH = lara_config['static']['DJANGO_STATIC_PATH']
#     LARA_TO_MONITOR_PATH = lara_config['evaluation']['LARA_TO_MONITOR_PATH']
#     BASE_DATA_DESTINATION = lara_config['evaluation']['BASE_DATA_DESTINATION']
#
# except NoSectionError as err :
#     sys.stderr.write("ERROR: Please add section in your config file {}".format(err) )
# except NoOptionError as err:
#     sys.stderr.write("ERROR: Cannot read lara-django config file option in {}".format(err) )


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'ay13+1dv2xe_ofyy)8z8g1yu#4hpp+)3ri@w##k$&)i-8u@v9v'

# Application definition
# s. devel or production settings

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'lara_django.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [], # os.path.join(BASE_DIR, 'templates') templates dir in lara,
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'lara_django.wsgi.application'

EMAIL_BACKEND = "django.core.mail.backends.filebased.EmailBackend"
EMAIL_FILE_PATH = os.path.join(BASE_DIR, "sent_emails")

# Database
# s. devel or production settings

# Password validation
# https://docs.djangoproject.com/en/2.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.1/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True
