"""
________________________________________________________________________

:PROJECT: lara-django

*lara-django development settings*

:details: Django settings for lara project.
    Generated by 'django-admin startproject' using Django 2.1.
    For more information on this file, see
    https://docs.djangoproject.com/en/2.1/topics/settings/

    For the full list of settings and their values, see
    https://docs.djangoproject.com/en/2.1/ref/settings/

:authors: mark doerr (mark@uni-greifswald.de)

:date: (creation)          20180623
:date: (last modification) 20180627

.. note:: -
.. todo:: -
________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.1.6"

import os
import sys
import logging

from lara_django.settings.settings_base import *

# Database
# https://docs.djangoproject.com/en/2.1/ref/settings/#databases

#~ DB_PATH = '/var/local/lara'
#~ DB_PATH = '/opt/lara/lara_django/'
DB_PATH = BASE_DIR

DB_FILENAME = "lara_devel_db.sqlite3"

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(DB_PATH, DB_FILENAME),
    }
}

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

DJNAGO_SYS_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles', # this is only important in the development env.
    'mptt',    # tree representation this has been omitted in favour of llist
    #'javascript_settings', # for AJAX requests
]

# please add all project apps here ...
PROJECT_APPS = ['lara_base',
                'lara_people',
                'lara_library',
                'lara_material',
                'lara_parts',
                'lara_devices',
                'lara_sequences',
                'lara_substances',
                'lara_substances_store',
                'lara_containers',
                #'lara_labstore',
                'lara_processes',
                'lara_data',
                'lara_projects'
                ]

INSTALLED_APPS = DJNAGO_SYS_APPS + PROJECT_APPS

LOGIN_REDIRECT_URL = 'index'
LOGOUT_REDIRECT_URL = 'index'

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.1/howto/static-files/

STATIC_URL = '/static/'

MEDIA_URL = '/media/'

media_path = os.environ["DJANGO_MEDIA_PATH"]  # Absolute path to the media directory
DJANGO_MEDIA_PATH = media_path
MEDIA_ROOT = DJANGO_MEDIA_PATH

DESTINATION_BASE = os.path.join(DJANGO_MEDIA_PATH, "evaluation"),

#~ print(" -~~~~ {}".format(MEDIA_ROOT) )

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, "static"),
    DJANGO_MEDIA_PATH # media_path
]

FIXTURE_DIRS = [ #os.path.join(DJANGO_MEDIA_PATH, 'lara_fixtures', 'lara_people', 'fixtures'),
                 #~ os.path.join(DJANGO_MEDIA_PATH, 'lara_metainfo', 'fixtures'),
                 #~ os.path.join(DJANGO_MEDIA_PATH, 'lara_devices', 'fixtures'),
                 #~ os.path.join(DJANGO_MEDIA_PATH, 'lara_assays', 'fixtures'),
                ]

print(FIXTURE_DIRS)

#MEDIA_ROOT = os.path.join(PROJECT_PATH, 'media') # Absolute path to the media directory
#~ MEDIA_ROOT =  media_path # os.path.join(PROJECT_PATH, media_path )
#~ os.environ["DJANGO_MEDIA_ROOT"] = MEDIA_ROOT

ADMINS = (
    ('mark doerr', 'mark.doerr@uni-greifswald.de')
)
