"""
________________________________________________________________________

:PROJECT: lara-django

*lara-django development settings*

:details: Django settings for lara project.
	Generated by 'django-admin startproject' using Django 2.0.6.
	For more information on this file, see
	https://docs.djangoproject.com/en/2.0/topics/settings/

	For the full list of settings and their values, see
	https://docs.djangoproject.com/en/2.0/ref/settings/

:authors: mark doerr (mark@uni-greifswald.de)

:date: (creation)          20180623
:date: (last modification) 20180627

.. note:: -
.. todo:: -
________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.1.6"

import os
import sys

from lara_django.settings.settings_base import *

# Database
# https://docs.djangoproject.com/en/2.0/ref/settings/#databases

#~ DB_PATH = '/var/local/lara'
#~ DB_PATH = '/opt/lara/lara_django/'
#~ DB_PATH = BASE_DIR

DB_FILENAME = "lara_devel_db.sqlite3"

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(DB_PATH, DB_FILENAME),
    }
}

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

DJNAGO_SYS_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles', # this is only important in the development env.
    'mptt',    # tree representation
]

# please add all project apps here ...
PROJECT_APPS = ['lara',
                'lara_people',
                'lara_metainfo',
                'lara_devices',
                'lara_processes',
                'lara_data',
                'lara_substances',
                'lara_containers',
                'lara_projects']

INSTALLED_APPS = DJNAGO_SYS_APPS + PROJECT_APPS

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.0/howto/static-files/

STATIC_URL = '/static/'

MEDIA_URL = '/media/'

#~ media_path = os.environ["DJANGO_MEDIA_PATH"]  # Absolute path to the media directory
MEDIA_ROOT = DJANGO_MEDIA_PATH

#~ print(" -~~~~ {}".format(MEDIA_ROOT) )

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, "static"),
    DJANGO_MEDIA_PATH # media_path
]

FIXTURE_DIRS = [
                 os.path.join(DJANGO_MEDIA_PATH, 'lara_people', 'fixtures'),
                 os.path.join(DJANGO_MEDIA_PATH, 'lara_metainfo', 'fixtures'),
                 os.path.join(DJANGO_MEDIA_PATH, 'lara_devices', 'fixtures'),
                 os.path.join(DJANGO_MEDIA_PATH, 'lara_assays', 'fixtures'),
                ]

#MEDIA_ROOT = os.path.join(PROJECT_PATH, 'media') # Absolute path to the media directory
#~ MEDIA_ROOT =  media_path # os.path.join(PROJECT_PATH, media_path )
#~ os.environ["DJANGO_MEDIA_ROOT"] = MEDIA_ROOT

ADMINS = (
    ('mark doerr', 'mark.doerr@uni-greifswald.de')
)
