# Copyright 2019 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!

import grpc

from google.cloud.monitoring_dashboard.v1.proto import (
    dashboard_pb2 as google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2,
)
from google.cloud.monitoring_dashboard.v1.proto import (
    dashboards_service_pb2 as google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2,
)
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class DashboardsServiceStub(object):
    """Manages Stackdriver dashboards. A dashboard is an arrangement of data display
  widgets in a specific layout.
  """

    def __init__(self, channel):
        """Constructor.

    Args:
      channel: A grpc.Channel.
    """
        self.CreateDashboard = channel.unary_unary(
            "/google.monitoring.dashboard.v1.DashboardsService/CreateDashboard",
            request_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.CreateDashboardRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.FromString,
        )
        self.ListDashboards = channel.unary_unary(
            "/google.monitoring.dashboard.v1.DashboardsService/ListDashboards",
            request_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.ListDashboardsRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.ListDashboardsResponse.FromString,
        )
        self.GetDashboard = channel.unary_unary(
            "/google.monitoring.dashboard.v1.DashboardsService/GetDashboard",
            request_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.GetDashboardRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.FromString,
        )
        self.DeleteDashboard = channel.unary_unary(
            "/google.monitoring.dashboard.v1.DashboardsService/DeleteDashboard",
            request_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.DeleteDashboardRequest.SerializeToString,
            response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
        self.UpdateDashboard = channel.unary_unary(
            "/google.monitoring.dashboard.v1.DashboardsService/UpdateDashboard",
            request_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.UpdateDashboardRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.FromString,
        )


class DashboardsServiceServicer(object):
    """Manages Stackdriver dashboards. A dashboard is an arrangement of data display
  widgets in a specific layout.
  """

    def CreateDashboard(self, request, context):
        """Creates a new custom dashboard.

    This method requires the `monitoring.dashboards.create` permission
    on the specified project. For more information, see
    [Google Cloud IAM](https://cloud.google.com/iam).
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListDashboards(self, request, context):
        """Lists the existing dashboards.

    This method requires the `monitoring.dashboards.list` permission
    on the specified project. For more information, see
    [Google Cloud IAM](https://cloud.google.com/iam).
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetDashboard(self, request, context):
        """Fetches a specific dashboard.

    This method requires the `monitoring.dashboards.get` permission
    on the specified dashboard. For more information, see
    [Google Cloud IAM](https://cloud.google.com/iam).
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DeleteDashboard(self, request, context):
        """Deletes an existing custom dashboard.

    This method requires the `monitoring.dashboards.delete` permission
    on the specified dashboard. For more information, see
    [Google Cloud IAM](https://cloud.google.com/iam).
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def UpdateDashboard(self, request, context):
        """Replaces an existing custom dashboard with a new definition.

    This method requires the `monitoring.dashboards.update` permission
    on the specified dashboard. For more information, see
    [Google Cloud IAM](https://cloud.google.com/iam).
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_DashboardsServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "CreateDashboard": grpc.unary_unary_rpc_method_handler(
            servicer.CreateDashboard,
            request_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.CreateDashboardRequest.FromString,
            response_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.SerializeToString,
        ),
        "ListDashboards": grpc.unary_unary_rpc_method_handler(
            servicer.ListDashboards,
            request_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.ListDashboardsRequest.FromString,
            response_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.ListDashboardsResponse.SerializeToString,
        ),
        "GetDashboard": grpc.unary_unary_rpc_method_handler(
            servicer.GetDashboard,
            request_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.GetDashboardRequest.FromString,
            response_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.SerializeToString,
        ),
        "DeleteDashboard": grpc.unary_unary_rpc_method_handler(
            servicer.DeleteDashboard,
            request_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.DeleteDashboardRequest.FromString,
            response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
        ),
        "UpdateDashboard": grpc.unary_unary_rpc_method_handler(
            servicer.UpdateDashboard,
            request_deserializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboards__service__pb2.UpdateDashboardRequest.FromString,
            response_serializer=google_dot_cloud_dot_monitoring_dot_dashboard__v1_dot_proto_dot_dashboard__pb2.Dashboard.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "google.monitoring.dashboard.v1.DashboardsService", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))
