# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ice_launcher',
 'ice_launcher.assets',
 'ice_launcher.components',
 'ice_launcher.lib',
 'ice_launcher.views']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'customtkinter>=4.5.10,<5.0.0',
 'minecraft-launcher-lib>=5.2,<6.0',
 'packaging>=21.3,<22.0',
 'requests>=2.28.1,<3.0.0',
 'tomli-w>=1.0.0,<2.0.0',
 'tomli>=2.0.1,<3.0.0']

entry_points = \
{'console_scripts': ['start = ice_launcher.__main__:main']}

setup_kwargs = {
    'name': 'ice-launcher',
    'version': '0.0.14',
    'description': 'An unofficial WIP Minecraft Launcher',
    'long_description': '<p align="center">\n<img src="./ice_launcher/assets/ice-launcher.png" alt="Ice Launcher Logo" height="128px">\n</p>\n\n<h1 align="center">Ice Launcher</h1>\n\n<p align="center">\n<a href="https://github.com/mq1/ice-launcher/blob/main/LICENSE"><img alt="License: GPL-3.0" src="https://img.shields.io/github/license/mq1/ice-launcher"></a>\n<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n</p>\n\n-----\n\nAn unofficial WIP Minecraft Launcher\n\n**Table of Contents**\n\n- [Installation](#installation)\n- [Thanks](#thanks)\n- [License](#license)\n\n## Installation\n\n### Package (recommended)\n\nJust grab the [latest release](https://github.com/mq1/ice-launcher/releases/latest) for your platform\n\n### From pip\n\n```sh\npip install ice-launcher\n```\n\n## Thanks\n\n- Aru for the awesome logo!\n- [JakobDev](https://gitlab.com/JakobDev) for building [minecraft-launcher-lib](https://gitlab.com/JakobDev/minecraft-launcher-lib)\n- [TomSchimansky](https://github.com/TomSchimansky) for building [CustomTkinter](https://github.com/TomSchimansky/CustomTkinter)\n\n## License\n\n`ice-launcher` is distributed under the terms of the [GPL-3.0-only](https://spdx.org/licenses/GPL-3.0-only.html) license.\n',
    'author': 'Manuel Quarneti',
    'author_email': 'manuelquarneti@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mq1/ice-launcher#readme',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
