# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.xsd
from typing_extensions import Literal


class DataTypeClass:
    """
    Const Class

    These constants specify the class used of an XDataType.

    See Also:
        `API DataTypeClass <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1xsd_1_1DataTypeClass.html>`_
    """
    STRING: Literal[1]
    """
    specifies an XSD compliant string type
    """
    BOOLEAN: Literal[2]
    """
    specifies an XSD compliant boolean type
    """
    DECIMAL: Literal[3]
    """
    specifies an XSD compliant decimal type
    """
    FLOAT: Literal[4]
    """
    specifies an XSD compliant float type
    """
    DOUBLE: Literal[5]
    """
    specifies an XSD compliant double type
    """
    DURATION: Literal[6]
    """
    specifies an XSD compliant duration type
    """
    DATETIME: Literal[7]
    """
    specifies an XSD compliant datetime type
    """
    TIME: Literal[8]
    """
    specifies an XSD compliant time type
    """
    DATE: Literal[9]
    """
    specifies an XSD compliant date type
    """
    gYearMonth: Literal[10]
    """
    specifies an XSD compliant gYearMonth type
    """
    gYear: Literal[11]
    """
    specifies an XSD compliant gYear type
    """
    gMonthDay: Literal[12]
    """
    specifies an XSD compliant gMonthDay type
    """
    gDay: Literal[13]
    """
    specifies an XSD compliant gDay type
    """
    gMonth: Literal[14]
    """
    specifies an XSD compliant gMonth type
    """
    hexBinary: Literal[15]
    """
    specifies an XSD compliant hexBinary type
    """
    base64Binary: Literal[16]
    """
    specifies an XSD compliant base64Binary type
    """
    anyURI: Literal[17]
    """
    specifies an XSD compliant anyURI type
    """
    QName: Literal[18]
    """
    specifies an XSD compliant QName type
    """
    NOTATION: Literal[19]
    """
    specifies an XSD compliant NOTATION type
    """

__all__ = ['DataTypeClass']
