# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.xml.sax
# Libre Office Version: 7.2
from typing_extensions import Literal
from ooo.oenv.env_const import UNO_NONE
import typing
from .sax_exception import SAXException as SAXException_d1a00c6e
from ...uno.x_interface import XInterface as XInterface_8f010a43

class SAXParseException(SAXException_d1a00c6e):
    """
    Exception Class

    stores information for locating the error in the original XML document.

    See Also:
        `API SAXParseException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1xml_1_1sax_1_1SAXParseException.html>`_
    """

    typeName: Literal['com.sun.star.xml.sax.SAXParseException']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., WrappedException: typing.Optional[object] = ..., PublicId: typing.Optional[str] = ..., SystemId: typing.Optional[str] = ..., LineNumber: typing.Optional[int] = ..., ColumnNumber: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            WrappedException (object, optional): WrappedException value.
            PublicId (str, optional): PublicId value.
            SystemId (str, optional): SystemId value.
            LineNumber (int, optional): LineNumber value.
            ColumnNumber (int, optional): ColumnNumber value.
        """
    @property
    def PublicId(self) -> str:
        """
        contains the public identifier of the document where the exception has occurred.
        """

    @property
    def SystemId(self) -> str:
        """
        contains the system identifier of the document.
        """

    @property
    def LineNumber(self) -> int:
        """
        contains the line number in the document.
        """

    @property
    def ColumnNumber(self) -> int:
        """
        contains the column number in the document.
        """


__all__ = ['SAXParseException']

