# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class AtomClassRequest(object):
    """
    Struct Class

    is used to describe which atoms the user wants to know about.

    See Also:
        `API AtomClassRequest <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1AtomClassRequest.html>`_
    """
    typeName: Literal['com.sun.star.util.AtomClassRequest']

    def __init__(self, atoms: typing.Optional[typing.Tuple[int, ...]] = ..., atomClass: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            atoms (typing.Tuple[int, ...], optional): atoms value.
            atomClass (int, optional): atomClass value.
        """


    @property
    def atoms(self) -> typing.Tuple[int, ...]:
        """
        the atoms requested from class AtomClassRequest.atomClass().
        """


    @property
    def atomClass(self) -> int:
        """
        the class of the atoms described in member AtomClassRequest.atoms().
        """



__all__ = ['AtomClassRequest']
