# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class AliasProgrammaticPair(object):
    """
    Struct Class

    represents an entry from a component which implements the XLocalizedAliases.

    See Also:
        `API AliasProgrammaticPair <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1AliasProgrammaticPair.html>`_
    """
    typeName: Literal['com.sun.star.util.AliasProgrammaticPair']

    def __init__(self, Alias: typing.Optional[str] = ..., ProgrammaticName: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            Alias (str, optional): Alias value.
            ProgrammaticName (str, optional): ProgrammaticName value.
        """


    @property
    def Alias(self) -> str:
        """
        determines the name which is registered as an alias for a programmatic name.
        """


    @property
    def ProgrammaticName(self) -> str:
        """
        determines which programmatic name belongs to the alias.
        """



__all__ = ['AliasProgrammaticPair']
