# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Enum Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.uno
# Libre Office Version: 7.2
from typing_extensions import Literal
from enum import Enum


class TypeClass(Enum):
    """
    Enum Class

    

    See Also:
        `API TypeClass <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1uno.html#a00683ed3ec24b47c36ead10a20d6f328>`_
    """
    ANY: Literal['ANY']
    """
    reflecting the any type; anys can carry any UNO value except of any values
    """
    ARRAY: Literal['ARRAY']
    """
    Deprecated, UNOIDL does not have an array concept.
    """
    BOOLEAN: Literal['BOOLEAN']
    """
    reflecting the boolean type; true and false
    """
    BYTE: Literal['BYTE']
    """
    reflecting the 8-bit ordinal type
    """
    CHAR: Literal['CHAR']
    """
    reflecting the 16-bit unicode character type
    """
    CONSTANT: Literal['CONSTANT']
    """
    reflecting constants
    """
    CONSTANTS: Literal['CONSTANTS']
    """
    reflecting constants groups
    """
    DOUBLE: Literal['DOUBLE']
    """
    reflecting the 64-bit floating point type
    """
    ENUM: Literal['ENUM']
    """
    reflecting enum types
    """
    EXCEPTION: Literal['EXCEPTION']
    """
    reflecting exception types
    """
    FLOAT: Literal['FLOAT']
    """
    reflecting the 32-bit floating point type
    """
    HYPER: Literal['HYPER']
    """
    reflecting the signed 64-bit ordinal type
    """
    INTERFACE: Literal['INTERFACE']
    """
    reflecting interface types
    """
    INTERFACE_ATTRIBUTE: Literal['INTERFACE_ATTRIBUTE']
    """
    reflecting interface attributes
    """
    INTERFACE_METHOD: Literal['INTERFACE_METHOD']
    """
    reflecting interface methods
    """
    LONG: Literal['LONG']
    """
    reflecting the signed 32-bit ordinal type
    """
    MODULE: Literal['MODULE']
    """
    reflecting modules
    """
    PROPERTY: Literal['PROPERTY']
    """
    reflecting properties
    """
    SEQUENCE: Literal['SEQUENCE']
    """
    reflecting sequence types
    """
    SERVICE: Literal['SERVICE']
    """
    reflecting services
    """
    SHORT: Literal['SHORT']
    """
    reflecting the signed 16-bit ordinal type
    """
    SINGLETON: Literal['SINGLETON']
    """
    reflecting singletons
    """
    STRING: Literal['STRING']
    """
    reflecting the string type; strings of unicode characters
    """
    STRUCT: Literal['STRUCT']
    """
    reflecting compound types
    """
    TYPE: Literal['TYPE']
    """
    reflecting the meta type
    """
    TYPEDEF: Literal['TYPEDEF']
    """
    reflecting typedefed types referencing other types
    """
    UNION: Literal['UNION']
    """
    Deprecated, UNOIDL does not have a union concept.
    """
    UNKNOWN: Literal['UNKNOWN']
    """
    reflecting the unreflectable type
    """
    UNSIGNED_HYPER: Literal['UNSIGNED_HYPER']
    """
    reflecting the unsigned 64-bit ordinal type
    """
    UNSIGNED_LONG: Literal['UNSIGNED_LONG']
    """
    reflecting the unsigned 32-bit type
    """
    UNSIGNED_SHORT: Literal['UNSIGNED_SHORT']
    """
    reflecting the unsigned 16-bit ordinal type
    """
    VOID: Literal['VOID']
    """
    reflecting the void type; denotes no type
    """

__all__ = ['TypeClass']

