# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .border_line2 import BorderLine2 as BorderLine2_af200b28


class TableBorder2(object):
    """
    Struct Class

    contains the style settings of the border lines of all cells in a cell range.
    
    TableBorder2 is nearly identical to TableBorder, except that it has members of BorderLine2 instead of BorderLine.
    
    In a queried structure, the flags in TableBorder2.Is...LineValid indicate that not all lines of the boxes have the same values.
    
    In a structure which is used for setting, these flags determine if the corresponding line should be set or if the old value should be kept.
    
    **since**
    
        LibreOffice 3.6

    See Also:
        `API TableBorder2 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1TableBorder2.html>`_
    """
    typeName: Literal['com.sun.star.table.TableBorder2']

    def __init__(self, TopLine: typing.Optional[BorderLine2_af200b28] = ..., IsTopLineValid: typing.Optional[bool] = ..., BottomLine: typing.Optional[BorderLine2_af200b28] = ..., IsBottomLineValid: typing.Optional[bool] = ..., LeftLine: typing.Optional[BorderLine2_af200b28] = ..., IsLeftLineValid: typing.Optional[bool] = ..., RightLine: typing.Optional[BorderLine2_af200b28] = ..., IsRightLineValid: typing.Optional[bool] = ..., HorizontalLine: typing.Optional[BorderLine2_af200b28] = ..., IsHorizontalLineValid: typing.Optional[bool] = ..., VerticalLine: typing.Optional[BorderLine2_af200b28] = ..., IsVerticalLineValid: typing.Optional[bool] = ..., Distance: typing.Optional[int] = ..., IsDistanceValid: typing.Optional[bool] = ...) -> None:
        """
        Constructor

        Arguments:
            TopLine (BorderLine2, optional): TopLine value.
            IsTopLineValid (bool, optional): IsTopLineValid value.
            BottomLine (BorderLine2, optional): BottomLine value.
            IsBottomLineValid (bool, optional): IsBottomLineValid value.
            LeftLine (BorderLine2, optional): LeftLine value.
            IsLeftLineValid (bool, optional): IsLeftLineValid value.
            RightLine (BorderLine2, optional): RightLine value.
            IsRightLineValid (bool, optional): IsRightLineValid value.
            HorizontalLine (BorderLine2, optional): HorizontalLine value.
            IsHorizontalLineValid (bool, optional): IsHorizontalLineValid value.
            VerticalLine (BorderLine2, optional): VerticalLine value.
            IsVerticalLineValid (bool, optional): IsVerticalLineValid value.
            Distance (int, optional): Distance value.
            IsDistanceValid (bool, optional): IsDistanceValid value.
        """


    @property
    def TopLine(self) -> BorderLine2_af200b28:
        """
        determines the line style at the top edge.
        """


    @property
    def IsTopLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.TopLine is used.
        """


    @property
    def BottomLine(self) -> BorderLine2_af200b28:
        """
        determines the line style at the bottom edge.
        """


    @property
    def IsBottomLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.BottomLine is used.
        """


    @property
    def LeftLine(self) -> BorderLine2_af200b28:
        """
        determines the line style at the left edge.
        """


    @property
    def IsLeftLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.LeftLine is used.
        """


    @property
    def RightLine(self) -> BorderLine2_af200b28:
        """
        determines the line style at the right edge.
        """


    @property
    def IsRightLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.RightLine is used.
        """


    @property
    def HorizontalLine(self) -> BorderLine2_af200b28:
        """
        determines the line style of horizontal lines for the inner part of a cell range.
        """


    @property
    def IsHorizontalLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.HorizontalLine is used.
        """


    @property
    def VerticalLine(self) -> BorderLine2_af200b28:
        """
        determines the line style of vertical lines for the inner part of a cell range.
        """


    @property
    def IsVerticalLineValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.VerticalLine is used.
        """


    @property
    def Distance(self) -> int:
        """
        contains the distance between the lines and other contents.
        """


    @property
    def IsDistanceValid(self) -> bool:
        """
        specifies whether the value of TableBorder2.Distance is used.
        """



__all__ = ['TableBorder2']
